
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQLibrary.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQLibrary_EventAdaptor.h"
#include "gsiDeclQLibrary_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QLibrary

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QLibrary::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QString QLibrary::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLibrary *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QLibrary::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// QString QLibrary::fileName()


static void _init_f_fileName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_fileName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QLibrary *)cls)->fileName ());
}

static qt_gsi::GenericMethod *_create_f_fileName_c0 ()
{
  return new qt_gsi::GenericMethod (":fileName", "@brief Method QString QLibrary::fileName()\n", true, &_init_f_fileName_c0, &_call_f_fileName_c0);
}

// bool QLibrary::isLoaded()


static void _init_f_isLoaded_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLoaded_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLibrary *)cls)->isLoaded ());
}

static qt_gsi::GenericMethod *_create_f_isLoaded_c0 ()
{
  return new qt_gsi::GenericMethod ("isLoaded?", "@brief Method bool QLibrary::isLoaded()\n", true, &_init_f_isLoaded_c0, &_call_f_isLoaded_c0);
}

// bool QLibrary::load()


static void _init_f_load_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_load_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLibrary *)cls)->load ());
}

static qt_gsi::GenericMethod *_create_f_load_0 ()
{
  return new qt_gsi::GenericMethod ("load", "@brief Method bool QLibrary::load()\n", false, &_init_f_load_0, &_call_f_load_0);
}

// QFlags<QLibrary::LoadHint> QLibrary::loadHints()


static void _init_f_loadHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QLibrary::LoadHint> >::target_type > ();
}

static void _call_f_loadHints_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QLibrary::LoadHint> >::target_type > ((qt_gsi::Converter<QFlags<QLibrary::LoadHint> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QLibrary::LoadHint> >(((QLibrary *)cls)->loadHints ()));
}

static qt_gsi::GenericMethod *_create_f_loadHints_c0 ()
{
  return new qt_gsi::GenericMethod (":loadHints", "@brief Method QFlags<QLibrary::LoadHint> QLibrary::loadHints()\n", true, &_init_f_loadHints_c0, &_call_f_loadHints_c0);
}

// void *QLibrary::resolve(const char *symbol)


static void _init_f_resolve_1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("symbol");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void * > ();
}

static void _call_f_resolve_1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<void * > ((void *)((QLibrary *)cls)->resolve (arg1));
}

static qt_gsi::GenericMethod *_create_f_resolve_1731 ()
{
  return new qt_gsi::GenericMethod ("resolve", "@brief Method void *QLibrary::resolve(const char *symbol)\n", false, &_init_f_resolve_1731, &_call_f_resolve_1731);
}

// void QLibrary::setFileName(const QString &fileName)


static void _init_f_setFileName_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFileName_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QLibrary *)cls)->setFileName (arg1);
}

static qt_gsi::GenericMethod *_create_f_setFileName_2025 ()
{
  return new qt_gsi::GenericMethod ("setFileName|fileName=", "@brief Method void QLibrary::setFileName(const QString &fileName)\n", false, &_init_f_setFileName_2025, &_call_f_setFileName_2025);
}

// void QLibrary::setFileNameAndVersion(const QString &fileName, int verNum)


static void _init_f_setFileNameAndVersion_2684 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("verNum");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFileNameAndVersion_2684 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args.read<int > ();
  ((QLibrary *)cls)->setFileNameAndVersion (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setFileNameAndVersion_2684 ()
{
  return new qt_gsi::GenericMethod ("setFileNameAndVersion", "@brief Method void QLibrary::setFileNameAndVersion(const QString &fileName, int verNum)\n", false, &_init_f_setFileNameAndVersion_2684, &_call_f_setFileNameAndVersion_2684);
}

// void QLibrary::setFileNameAndVersion(const QString &fileName, const QString &version)


static void _init_f_setFileNameAndVersion_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("version");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFileNameAndVersion_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ((QLibrary *)cls)->setFileNameAndVersion (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setFileNameAndVersion_3942 ()
{
  return new qt_gsi::GenericMethod ("setFileNameAndVersion", "@brief Method void QLibrary::setFileNameAndVersion(const QString &fileName, const QString &version)\n", false, &_init_f_setFileNameAndVersion_3942, &_call_f_setFileNameAndVersion_3942);
}

// void QLibrary::setLoadHints(QFlags<QLibrary::LoadHint> hints)


static void _init_f_setLoadHints_2841 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<const qt_gsi::Converter<QFlags<QLibrary::LoadHint> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLoadHints_2841 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QLibrary::LoadHint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QLibrary::LoadHint> >::target_type & > ();
  ((QLibrary *)cls)->setLoadHints (qt_gsi::QtToCppAdaptor<QFlags<QLibrary::LoadHint> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setLoadHints_2841 ()
{
  return new qt_gsi::GenericMethod ("setLoadHints|loadHints=", "@brief Method void QLibrary::setLoadHints(QFlags<QLibrary::LoadHint> hints)\n", false, &_init_f_setLoadHints_2841, &_call_f_setLoadHints_2841);
}

// bool QLibrary::unload()


static void _init_f_unload_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_unload_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QLibrary *)cls)->unload ());
}

static qt_gsi::GenericMethod *_create_f_unload_0 ()
{
  return new qt_gsi::GenericMethod ("unload", "@brief Method bool QLibrary::unload()\n", false, &_init_f_unload_0, &_call_f_unload_0);
}

// static bool QLibrary::isLibrary(const QString &fileName)


static void _init_f_isLibrary_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isLibrary_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<bool > ((bool)QLibrary::isLibrary (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_isLibrary_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("isLibrary?", "@brief Static method bool QLibrary::isLibrary(const QString &fileName)\nThis method is static and can be called without an instance.", &_init_f_isLibrary_2025, &_call_f_isLibrary_2025);
}

// static void *QLibrary::resolve(const QString &fileName, const char *symbol)


static void _init_f_resolve_3648 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("symbol");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void * > ();
}

static void _call_f_resolve_3648 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const char *arg2 = args.read<const char * > ();
  ret.write<void * > ((void *)QLibrary::resolve (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_resolve_3648 ()
{
  return new qt_gsi::GenericStaticMethod ("resolve", "@brief Static method void *QLibrary::resolve(const QString &fileName, const char *symbol)\nThis method is static and can be called without an instance.", &_init_f_resolve_3648, &_call_f_resolve_3648);
}

// static void *QLibrary::resolve(const QString &fileName, int verNum, const char *symbol)


static void _init_f_resolve_4307 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("verNum");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("symbol");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<void * > ();
}

static void _call_f_resolve_4307 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args.read<int > ();
  const char *arg3 = args.read<const char * > ();
  ret.write<void * > ((void *)QLibrary::resolve (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_resolve_4307 ()
{
  return new qt_gsi::GenericStaticMethod ("resolve", "@brief Static method void *QLibrary::resolve(const QString &fileName, int verNum, const char *symbol)\nThis method is static and can be called without an instance.", &_init_f_resolve_4307, &_call_f_resolve_4307);
}

// static void *QLibrary::resolve(const QString &fileName, const QString &version, const char *symbol)


static void _init_f_resolve_5565 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("version");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("symbol");
  decl->add_arg<const char * > (argspec_2);
  decl->set_return<void * > ();
}

static void _call_f_resolve_5565 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  const char *arg3 = args.read<const char * > ();
  ret.write<void * > ((void *)QLibrary::resolve (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_resolve_5565 ()
{
  return new qt_gsi::GenericStaticMethod ("resolve", "@brief Static method void *QLibrary::resolve(const QString &fileName, const QString &version, const char *symbol)\nThis method is static and can be called without an instance.", &_init_f_resolve_5565, &_call_f_resolve_5565);
}

// static QString QLibrary::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QLibrary::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLibrary::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QLibrary::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QLibrary::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QLibrary::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QLibrary::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QLibrary::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLibrary::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QLibrary::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QLibrary::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QLibrary::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QLibrary, QLibrary_EventAdaptor> ea_QLibrary;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QLibrary> decl_QLibrary (ea_QLibrary, decl_QObject, "QLibrary_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_fileName_c0 ()) +
  gsi::Methods(_create_f_isLoaded_c0 ()) +
  gsi::Methods(_create_f_load_0 ()) +
  gsi::Methods(_create_f_loadHints_c0 ()) +
  gsi::Methods(_create_f_resolve_1731 ()) +
  gsi::Methods(_create_f_setFileName_2025 ()) +
  gsi::Methods(_create_f_setFileNameAndVersion_2684 ()) +
  gsi::Methods(_create_f_setFileNameAndVersion_3942 ()) +
  gsi::Methods(_create_f_setLoadHints_2841 ()) +
  gsi::Methods(_create_f_unload_0 ()) +
  qt_gsi::qt_signal<QLibrary, QLibrary_EventAdaptor, QObject *> ("destroyed", &QLibrary_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QLibrary::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_isLibrary_2025 ()) +
  gsi::Methods(_create_f_resolve_3648 ()) +
  gsi::Methods(_create_f_resolve_4307 ()) +
  gsi::Methods(_create_f_resolve_5565 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QLibrary");
}


class QLibrary_Adaptor : public QLibrary, public qt_gsi::QtObjectBase
{
public:

  virtual ~QLibrary_Adaptor();

  //  [adaptor ctor] QLibrary::QLibrary(QObject *parent)
  QLibrary_Adaptor() : QLibrary()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(QObject *parent)
  QLibrary_Adaptor(QObject *parent) : QLibrary(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(const QString &fileName, QObject *parent)
  QLibrary_Adaptor(const QString &fileName) : QLibrary(fileName)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(const QString &fileName, QObject *parent)
  QLibrary_Adaptor(const QString &fileName, QObject *parent) : QLibrary(fileName, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(const QString &fileName, int verNum, QObject *parent)
  QLibrary_Adaptor(const QString &fileName, int verNum) : QLibrary(fileName, verNum)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(const QString &fileName, int verNum, QObject *parent)
  QLibrary_Adaptor(const QString &fileName, int verNum, QObject *parent) : QLibrary(fileName, verNum, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(const QString &fileName, const QString &version, QObject *parent)
  QLibrary_Adaptor(const QString &fileName, const QString &version) : QLibrary(fileName, version)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QLibrary::QLibrary(const QString &fileName, const QString &version, QObject *parent)
  QLibrary_Adaptor(const QString &fileName, const QString &version, QObject *parent) : QLibrary(fileName, version, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QLibrary::receivers(const char *signal)
  int fp_QLibrary_receivers_c1731 (const char *signal) const {
    return QLibrary::receivers(signal);
  }

  //  QObject *QLibrary::sender()
  QObject * fp_QLibrary_sender_c0 () const {
    return QLibrary::sender();
  }

  //  [adaptor impl] bool QLibrary::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QLibrary::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QLibrary_Adaptor, bool, QEvent *>(&QLibrary_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QLibrary::event(arg1);
    }
  }

  //  [adaptor impl] bool QLibrary::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QLibrary::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QLibrary_Adaptor, bool, QObject *, QEvent *>(&QLibrary_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QLibrary::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QLibrary::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QLibrary::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QLibrary_Adaptor, QChildEvent *>(&QLibrary_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QLibrary::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QLibrary::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QLibrary::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QLibrary_Adaptor, QEvent *>(&QLibrary_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QLibrary::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QLibrary::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QLibrary::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QLibrary_Adaptor, const char *>(&QLibrary_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QLibrary::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QLibrary::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QLibrary::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QLibrary_Adaptor, QTimerEvent *>(&QLibrary_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QLibrary::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QLibrary_Adaptor::~QLibrary_Adaptor() { }

//  Constructor QLibrary::QLibrary(QObject *parent) (adaptor class)

static void _init_ctor_QLibrary_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QLibrary_Adaptor *> ();
}

static void _call_ctor_QLibrary_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QLibrary_Adaptor *> (new QLibrary_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLibrary_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLibrary::QLibrary(QObject *parent)\nThis method creates an object of class QLibrary.", &_init_ctor_QLibrary_Adaptor_1302, &_call_ctor_QLibrary_Adaptor_1302);
}

//  Constructor QLibrary::QLibrary(const QString &fileName, QObject *parent) (adaptor class)

static void _init_ctor_QLibrary_Adaptor_3219 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_1);
  decl->set_return_new<QLibrary_Adaptor *> ();
}

static void _call_ctor_QLibrary_Adaptor_3219 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QObject *arg2 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QLibrary_Adaptor *> (new QLibrary_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLibrary_Adaptor_3219 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLibrary::QLibrary(const QString &fileName, QObject *parent)\nThis method creates an object of class QLibrary.", &_init_ctor_QLibrary_Adaptor_3219, &_call_ctor_QLibrary_Adaptor_3219);
}

//  Constructor QLibrary::QLibrary(const QString &fileName, int verNum, QObject *parent) (adaptor class)

static void _init_ctor_QLibrary_Adaptor_3878 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("verNum");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QLibrary_Adaptor *> ();
}

static void _call_ctor_QLibrary_Adaptor_3878 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  int arg2 = args.read<int > ();
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QLibrary_Adaptor *> (new QLibrary_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLibrary_Adaptor_3878 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLibrary::QLibrary(const QString &fileName, int verNum, QObject *parent)\nThis method creates an object of class QLibrary.", &_init_ctor_QLibrary_Adaptor_3878, &_call_ctor_QLibrary_Adaptor_3878);
}

//  Constructor QLibrary::QLibrary(const QString &fileName, const QString &version, QObject *parent) (adaptor class)

static void _init_ctor_QLibrary_Adaptor_5136 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fileName");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("version");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_2);
  decl->set_return_new<QLibrary_Adaptor *> ();
}

static void _call_ctor_QLibrary_Adaptor_5136 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  QObject *arg3 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QLibrary_Adaptor *> (new QLibrary_Adaptor (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QLibrary_Adaptor_5136 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QLibrary::QLibrary(const QString &fileName, const QString &version, QObject *parent)\nThis method creates an object of class QLibrary.", &_init_ctor_QLibrary_Adaptor_5136, &_call_ctor_QLibrary_Adaptor_5136);
}

// int QLibrary::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QLibrary_Adaptor *)cls)->fp_QLibrary_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QLibrary::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QLibrary::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QLibrary_Adaptor *)cls)->fp_QLibrary_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QLibrary::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QLibrary::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QLibrary_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLibrary_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QLibrary::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QLibrary::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QLibrary_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QLibrary_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QLibrary::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QLibrary::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QLibrary_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QLibrary_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QLibrary::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QLibrary::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QLibrary_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QLibrary_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QLibrary::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QLibrary::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QLibrary_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QLibrary_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QLibrary::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QLibrary::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QLibrary_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QLibrary_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QLibrary::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QLibrary> decl_QLibrary;

gsi::Class<QLibrary_Adaptor> decl_QLibrary_Adaptor (decl_QLibrary, "QLibrary",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QLibrary_Adaptor_1302 ()) +
  gsi::Methods(_create_ctor_QLibrary_Adaptor_3219 ()) +
  gsi::Methods(_create_ctor_QLibrary_Adaptor_3878 ()) +
  gsi::Methods(_create_ctor_QLibrary_Adaptor_5136 ()),
  "@qt\n@brief Binding of QLibrary");

}


//  Implementation of the enum wrapper class for QLibrary::LoadHint
namespace qt_gsi
{

static QLibrary_LoadHint_Enum *c_1_QLibrary_LoadHint_Enum () { return new QLibrary_LoadHint_Enum (QLibrary::ResolveAllSymbolsHint); }
static QLibrary_LoadHint_Enum *c_2_QLibrary_LoadHint_Enum () { return new QLibrary_LoadHint_Enum (QLibrary::ExportExternalSymbolsHint); }
static QLibrary_LoadHint_Enum *c_3_QLibrary_LoadHint_Enum () { return new QLibrary_LoadHint_Enum (QLibrary::LoadArchiveMemberHint); }

static gsi::Methods mkdefs_QLibrary_LoadHint () {
  return
    gsi::constant ("ResolveAllSymbolsHint", &qt_gsi::c_1_QLibrary_LoadHint_Enum, "@brief Enum constant QLibrary::ResolveAllSymbolsHint") +
    gsi::constant ("ExportExternalSymbolsHint", &qt_gsi::c_2_QLibrary_LoadHint_Enum, "@brief Enum constant QLibrary::ExportExternalSymbolsHint") +
    gsi::constant ("LoadArchiveMemberHint", &qt_gsi::c_3_QLibrary_LoadHint_Enum, "@brief Enum constant QLibrary::LoadArchiveMemberHint");
}

static std::string to_s_QLibrary_LoadHint_Enum (const QLibrary_LoadHint_Enum *e)
{
  if (e->value () == QLibrary::ResolveAllSymbolsHint) { return tl::sprintf ("ResolveAllSymbolsHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLibrary::ExportExternalSymbolsHint) { return tl::sprintf ("ExportExternalSymbolsHint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QLibrary::LoadArchiveMemberHint) { return tl::sprintf ("LoadArchiveMemberHint (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QLibrary_LoadHint_Enum (const QLibrary_LoadHint_Enum *e)
{
  return (unsigned int) e->value ();
}

static QLibrary_LoadHint_Enum *from_i_QLibrary_LoadHint_Enum (unsigned int i)
{
  return new QLibrary_LoadHint_Enum ((QLibrary::LoadHint) i);
}

static bool equalQLibrary_LoadHint_Enum (const QLibrary_LoadHint_Enum *e, QLibrary_LoadHint_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QLibrary_LoadHint_Enum (const QLibrary_LoadHint_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QLibrary_LoadHint_Enums oropQLibrary_LoadHint_Enums (const QLibrary_LoadHint_Enums *e, const QLibrary_LoadHint_Enums &d)
{
  return e->flags () | d.flags ();
}

static QLibrary_LoadHint_Enums andopQLibrary_LoadHint_Enums (const QLibrary_LoadHint_Enums *e, const QLibrary_LoadHint_Enums &d)
{
  return e->flags () & d.flags ();
}

static QLibrary_LoadHint_Enums xoropQLibrary_LoadHint_Enums (const QLibrary_LoadHint_Enums *e, const QLibrary_LoadHint_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QLibrary_LoadHint_Enums (const QLibrary_LoadHint_Enums *e)
{
  std::string l;
  if (e->testFlag (QLibrary::ResolveAllSymbolsHint)) { if (!l.empty ()) l += "|"; l += "ResolveAllSymbolsHint"; }
  if (e->testFlag (QLibrary::ExportExternalSymbolsHint)) { if (!l.empty ()) l += "|"; l += "ExportExternalSymbolsHint"; }
  if (e->testFlag (QLibrary::LoadArchiveMemberHint)) { if (!l.empty ()) l += "|"; l += "LoadArchiveMemberHint"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QLibrary_LoadHint_Enums (const QLibrary_LoadHint_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QLibrary_LoadHint_Enums (const QLibrary_LoadHint_Enums *e, const QLibrary_LoadHint_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QLibrary_LoadHint_Enums> decl_QLibrary_LoadHint_Enums ("QLibrary_QFlags_LoadHint",
  gsi::method_ext ("|", &qt_gsi::oropQLibrary_LoadHint_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQLibrary_LoadHint_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQLibrary_LoadHint_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLibrary_LoadHint_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLibrary_LoadHint_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QLibrary_LoadHint_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QLibrary::LoadHint> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QLibrary_LoadHint_Enum> decl_QLibrary_LoadHint_Enum (decl_QLibrary_LoadHint_Enums, "QLibrary_LoadHint",
  qt_gsi::mkdefs_QLibrary_LoadHint () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QLibrary_LoadHint_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QLibrary_LoadHint_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQLibrary_LoadHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QLibrary_LoadHint_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QLibrary_LoadHint_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QLibrary::LoadHint enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QLibrary> inject_QLibrary_LoadHint_Enum_in_parent (qt_gsi::mkdefs_QLibrary_LoadHint ());
static gsi::ClassExt<QLibrary> decl_QLibrary_LoadHint_Enum_as_child (decl_QLibrary_LoadHint_Enum, "LoadHint");

}

