
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQKeySequence.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQKeySequence_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QKeySequence

//  Constructor QKeySequence::QKeySequence()


static void _init_ctor_QKeySequence_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QKeySequence *> ();
}

static void _call_ctor_QKeySequence_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QKeySequence *> (new QKeySequence ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QKeySequence_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QKeySequence::QKeySequence()\nThis method creates an object of class QKeySequence.", &_init_ctor_QKeySequence_0, &_call_ctor_QKeySequence_0);
}

//  Constructor QKeySequence::QKeySequence(const QString &key)


static void _init_ctor_QKeySequence_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QKeySequence *> ();
}

static void _call_ctor_QKeySequence_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QKeySequence *> (new QKeySequence (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QKeySequence_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QKeySequence::QKeySequence(const QString &key)\nThis method creates an object of class QKeySequence.", &_init_ctor_QKeySequence_2025, &_call_ctor_QKeySequence_2025);
}

//  Constructor QKeySequence::QKeySequence(int k1, int k2, int k3, int k4)


static void _init_ctor_QKeySequence_2744 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("k1");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("k2", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("k3", true, "0");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("k4", true, "0");
  decl->add_arg<int > (argspec_3);
  decl->set_return_new<QKeySequence *> ();
}

static void _call_ctor_QKeySequence_2744 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  int arg3 = args ? args.read<int > () : (int)(0);
  int arg4 = args ? args.read<int > () : (int)(0);
  ret.write<QKeySequence *> (new QKeySequence (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QKeySequence_2744 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QKeySequence::QKeySequence(int k1, int k2, int k3, int k4)\nThis method creates an object of class QKeySequence.", &_init_ctor_QKeySequence_2744, &_call_ctor_QKeySequence_2744);
}

//  Constructor QKeySequence::QKeySequence(const QKeySequence &ks)


static void _init_ctor_QKeySequence_2516 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ks");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return_new<QKeySequence *> ();
}

static void _call_ctor_QKeySequence_2516 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<QKeySequence *> (new QKeySequence (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QKeySequence_2516 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QKeySequence::QKeySequence(const QKeySequence &ks)\nThis method creates an object of class QKeySequence.", &_init_ctor_QKeySequence_2516, &_call_ctor_QKeySequence_2516);
}

//  Constructor QKeySequence::QKeySequence(QKeySequence::StandardKey key)


static void _init_ctor_QKeySequence_2869 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > (argspec_0);
  decl->set_return_new<QKeySequence *> ();
}

static void _call_ctor_QKeySequence_2869 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > ();
  ret.write<QKeySequence *> (new QKeySequence (qt_gsi::QtToCppAdaptor<QKeySequence::StandardKey>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QKeySequence_2869 ()
{
  return new qt_gsi::GenericStaticMethod ("new_std", "@brief Constructor QKeySequence::QKeySequence(QKeySequence::StandardKey key)\nThis method creates an object of class QKeySequence.", &_init_ctor_QKeySequence_2869, &_call_ctor_QKeySequence_2869);
}

// unsigned int QKeySequence::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<unsigned int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<unsigned int > ((unsigned int)((QKeySequence *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method unsigned int QKeySequence::count()\n", true, &_init_f_count_c0, &_call_f_count_c0);
}

// bool QKeySequence::isDetached()


static void _init_f_isDetached_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDetached_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QKeySequence *)cls)->isDetached ());
}

static qt_gsi::GenericMethod *_create_f_isDetached_c0 ()
{
  return new qt_gsi::GenericMethod ("isDetached?", "@brief Method bool QKeySequence::isDetached()\n", true, &_init_f_isDetached_c0, &_call_f_isDetached_c0);
}

// bool QKeySequence::isEmpty()


static void _init_f_isEmpty_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEmpty_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QKeySequence *)cls)->isEmpty ());
}

static qt_gsi::GenericMethod *_create_f_isEmpty_c0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty?", "@brief Method bool QKeySequence::isEmpty()\n", true, &_init_f_isEmpty_c0, &_call_f_isEmpty_c0);
}

// QKeySequence::SequenceMatch QKeySequence::matches(const QKeySequence &seq)


static void _init_f_matches_c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("seq");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QKeySequence::SequenceMatch>::target_type > ();
}

static void _call_f_matches_c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<qt_gsi::Converter<QKeySequence::SequenceMatch>::target_type > ((qt_gsi::Converter<QKeySequence::SequenceMatch>::target_type)qt_gsi::CppToQtAdaptor<QKeySequence::SequenceMatch>(((QKeySequence *)cls)->matches (arg1)));
}

static qt_gsi::GenericMethod *_create_f_matches_c2516 ()
{
  return new qt_gsi::GenericMethod ("matches", "@brief Method QKeySequence::SequenceMatch QKeySequence::matches(const QKeySequence &seq)\n", true, &_init_f_matches_c2516, &_call_f_matches_c2516);
}

// bool QKeySequence::operator!=(const QKeySequence &other)


static void _init_f_operator_excl__eq__c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<bool > ((bool)((QKeySequence *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2516 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QKeySequence::operator!=(const QKeySequence &other)\n", true, &_init_f_operator_excl__eq__c2516, &_call_f_operator_excl__eq__c2516);
}

// bool QKeySequence::operator<(const QKeySequence &ks)


static void _init_f_operator_lt__c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ks");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<bool > ((bool)((QKeySequence *)cls)->operator< (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__c2516 ()
{
  return new qt_gsi::GenericMethod ("<", "@brief Method bool QKeySequence::operator<(const QKeySequence &ks)\n", true, &_init_f_operator_lt__c2516, &_call_f_operator_lt__c2516);
}

// bool QKeySequence::operator<=(const QKeySequence &other)


static void _init_f_operator_lt__eq__c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_lt__eq__c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<bool > ((bool)((QKeySequence *)cls)->operator<= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_lt__eq__c2516 ()
{
  return new qt_gsi::GenericMethod ("<=", "@brief Method bool QKeySequence::operator<=(const QKeySequence &other)\n", true, &_init_f_operator_lt__eq__c2516, &_call_f_operator_lt__eq__c2516);
}

// QKeySequence &QKeySequence::operator=(const QKeySequence &other)


static void _init_f_operator_eq__2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<QKeySequence & > ();
}

static void _call_f_operator_eq__2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<QKeySequence & > ((QKeySequence &)((QKeySequence *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2516 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QKeySequence &QKeySequence::operator=(const QKeySequence &other)\n", false, &_init_f_operator_eq__2516, &_call_f_operator_eq__2516);
}

// bool QKeySequence::operator==(const QKeySequence &other)


static void _init_f_operator_eq__eq__c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<bool > ((bool)((QKeySequence *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2516 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QKeySequence::operator==(const QKeySequence &other)\n", true, &_init_f_operator_eq__eq__c2516, &_call_f_operator_eq__eq__c2516);
}

// bool QKeySequence::operator>(const QKeySequence &other)


static void _init_f_operator_gt__c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<bool > ((bool)((QKeySequence *)cls)->operator> (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_gt__c2516 ()
{
  return new qt_gsi::GenericMethod (">", "@brief Method bool QKeySequence::operator>(const QKeySequence &other)\n", true, &_init_f_operator_gt__c2516, &_call_f_operator_gt__c2516);
}

// bool QKeySequence::operator>=(const QKeySequence &other)


static void _init_f_operator_gt__eq__c2516 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QKeySequence & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_gt__eq__c2516 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QKeySequence &arg1 = args.read<const QKeySequence & > ();
  ret.write<bool > ((bool)((QKeySequence *)cls)->operator>= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_gt__eq__c2516 ()
{
  return new qt_gsi::GenericMethod (">=", "@brief Method bool QKeySequence::operator>=(const QKeySequence &other)\n", true, &_init_f_operator_gt__eq__c2516, &_call_f_operator_gt__eq__c2516);
}

// int QKeySequence::operator[](unsigned int i)


static void _init_f_operator_index__c1772 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("i");
  decl->add_arg<unsigned int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_operator_index__c1772 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  unsigned int arg1 = args.read<unsigned int > ();
  ret.write<int > ((int)((QKeySequence *)cls)->operator[] (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_index__c1772 ()
{
  return new qt_gsi::GenericMethod ("[]", "@brief Method int QKeySequence::operator[](unsigned int i)\n", true, &_init_f_operator_index__c1772, &_call_f_operator_index__c1772);
}

// QString QKeySequence::toString(QKeySequence::SequenceFormat format)


static void _init_f_toString_c3197 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format", true, "QKeySequence::PortableText");
  decl->add_arg<const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type & > (argspec_0);
  decl->set_return<QString > ();
}

static void _call_f_toString_c3197 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type & > () : (const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<QKeySequence::SequenceFormat>(heap, QKeySequence::PortableText));
  ret.write<QString > ((QString)((QKeySequence *)cls)->toString (qt_gsi::QtToCppAdaptor<QKeySequence::SequenceFormat>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_toString_c3197 ()
{
  return new qt_gsi::GenericMethod ("toString", "@brief Method QString QKeySequence::toString(QKeySequence::SequenceFormat format)\n", true, &_init_f_toString_c3197, &_call_f_toString_c3197);
}

// static QKeySequence QKeySequence::fromString(const QString &str, QKeySequence::SequenceFormat format)


static void _init_f_fromString_5114 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("str");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format", true, "QKeySequence::PortableText");
  decl->add_arg<const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type & > (argspec_1);
  decl->set_return<QKeySequence > ();
}

static void _call_f_fromString_5114 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type & > () : (const qt_gsi::Converter<QKeySequence::SequenceFormat>::target_type &)(qt_gsi::CppToQtReadAdaptor<QKeySequence::SequenceFormat>(heap, QKeySequence::PortableText));
  ret.write<QKeySequence > ((QKeySequence)QKeySequence::fromString (arg1, qt_gsi::QtToCppAdaptor<QKeySequence::SequenceFormat>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_fromString_5114 ()
{
  return new qt_gsi::GenericStaticMethod ("fromString", "@brief Static method QKeySequence QKeySequence::fromString(const QString &str, QKeySequence::SequenceFormat format)\nThis method is static and can be called without an instance.", &_init_f_fromString_5114, &_call_f_fromString_5114);
}

// static QList<QKeySequence> QKeySequence::keyBindings(QKeySequence::StandardKey key)


static void _init_f_keyBindings_2869 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("key");
  decl->add_arg<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QKeySequence> >::target_type > ();
}

static void _call_f_keyBindings_2869 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & arg1 = args.read<const qt_gsi::Converter<QKeySequence::StandardKey>::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QKeySequence> >::target_type > ((qt_gsi::Converter<QList<QKeySequence> >::target_type)qt_gsi::CppToQtAdaptor<QList<QKeySequence> >(QKeySequence::keyBindings (qt_gsi::QtToCppAdaptor<QKeySequence::StandardKey>(arg1).cref())));
}

static qt_gsi::GenericStaticMethod *_create_f_keyBindings_2869 ()
{
  return new qt_gsi::GenericStaticMethod ("keyBindings", "@brief Static method QList<QKeySequence> QKeySequence::keyBindings(QKeySequence::StandardKey key)\nThis method is static and can be called without an instance.", &_init_f_keyBindings_2869, &_call_f_keyBindings_2869);
}

// static QKeySequence QKeySequence::mnemonic(const QString &text)


static void _init_f_mnemonic_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QKeySequence > ();
}

static void _call_f_mnemonic_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QKeySequence > ((QKeySequence)QKeySequence::mnemonic (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_mnemonic_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("mnemonic", "@brief Static method QKeySequence QKeySequence::mnemonic(const QString &text)\nThis method is static and can be called without an instance.", &_init_f_mnemonic_2025, &_call_f_mnemonic_2025);
}


namespace gsi
{
gsi::Class<QKeySequence> decl_QKeySequence ("QKeySequence",
  gsi::Methods(_create_ctor_QKeySequence_0 ()) +
  gsi::Methods(_create_ctor_QKeySequence_2025 ()) +
  gsi::Methods(_create_ctor_QKeySequence_2744 ()) +
  gsi::Methods(_create_ctor_QKeySequence_2516 ()) +
  gsi::Methods(_create_ctor_QKeySequence_2869 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_isDetached_c0 ()) +
  gsi::Methods(_create_f_isEmpty_c0 ()) +
  gsi::Methods(_create_f_matches_c2516 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2516 ()) +
  gsi::Methods(_create_f_operator_lt__c2516 ()) +
  gsi::Methods(_create_f_operator_lt__eq__c2516 ()) +
  gsi::Methods(_create_f_operator_eq__2516 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2516 ()) +
  gsi::Methods(_create_f_operator_gt__c2516 ()) +
  gsi::Methods(_create_f_operator_gt__eq__c2516 ()) +
  gsi::Methods(_create_f_operator_index__c1772 ()) +
  gsi::Methods(_create_f_toString_c3197 ()) +
  gsi::Methods(_create_f_fromString_5114 ()) +
  gsi::Methods(_create_f_keyBindings_2869 ()) +
  gsi::Methods(_create_f_mnemonic_2025 ()),
  "@qt\n@brief Binding of QKeySequence");

}


//  Implementation of the enum wrapper class for QKeySequence::SequenceFormat
namespace qt_gsi
{

static QKeySequence_SequenceFormat_Enum *c_1_QKeySequence_SequenceFormat_Enum () { return new QKeySequence_SequenceFormat_Enum (QKeySequence::NativeText); }
static QKeySequence_SequenceFormat_Enum *c_2_QKeySequence_SequenceFormat_Enum () { return new QKeySequence_SequenceFormat_Enum (QKeySequence::PortableText); }

static gsi::Methods mkdefs_QKeySequence_SequenceFormat () {
  return
    gsi::constant ("NativeText", &qt_gsi::c_1_QKeySequence_SequenceFormat_Enum, "@brief Enum constant QKeySequence::NativeText") +
    gsi::constant ("PortableText", &qt_gsi::c_2_QKeySequence_SequenceFormat_Enum, "@brief Enum constant QKeySequence::PortableText");
}

static std::string to_s_QKeySequence_SequenceFormat_Enum (const QKeySequence_SequenceFormat_Enum *e)
{
  if (e->value () == QKeySequence::NativeText) { return tl::sprintf ("NativeText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::PortableText) { return tl::sprintf ("PortableText (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QKeySequence_SequenceFormat_Enum (const QKeySequence_SequenceFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static QKeySequence_SequenceFormat_Enum *from_i_QKeySequence_SequenceFormat_Enum (unsigned int i)
{
  return new QKeySequence_SequenceFormat_Enum ((QKeySequence::SequenceFormat) i);
}

static bool equalQKeySequence_SequenceFormat_Enum (const QKeySequence_SequenceFormat_Enum *e, QKeySequence_SequenceFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QKeySequence_SequenceFormat_Enum (const QKeySequence_SequenceFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QKeySequence_SequenceFormat_Enums oropQKeySequence_SequenceFormat_Enums (const QKeySequence_SequenceFormat_Enums *e, const QKeySequence_SequenceFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static QKeySequence_SequenceFormat_Enums andopQKeySequence_SequenceFormat_Enums (const QKeySequence_SequenceFormat_Enums *e, const QKeySequence_SequenceFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static QKeySequence_SequenceFormat_Enums xoropQKeySequence_SequenceFormat_Enums (const QKeySequence_SequenceFormat_Enums *e, const QKeySequence_SequenceFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QKeySequence_SequenceFormat_Enums (const QKeySequence_SequenceFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (QKeySequence::NativeText)) { if (!l.empty ()) l += "|"; l += "NativeText"; }
  if (e->testFlag (QKeySequence::PortableText)) { if (!l.empty ()) l += "|"; l += "PortableText"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QKeySequence_SequenceFormat_Enums (const QKeySequence_SequenceFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QKeySequence_SequenceFormat_Enums (const QKeySequence_SequenceFormat_Enums *e, const QKeySequence_SequenceFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QKeySequence_SequenceFormat_Enums> decl_QKeySequence_SequenceFormat_Enums ("QKeySequence_QFlags_SequenceFormat",
  gsi::method_ext ("|", &qt_gsi::oropQKeySequence_SequenceFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQKeySequence_SequenceFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQKeySequence_SequenceFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QKeySequence_SequenceFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QKeySequence_SequenceFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QKeySequence_SequenceFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QKeySequence::SequenceFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QKeySequence_SequenceFormat_Enum> decl_QKeySequence_SequenceFormat_Enum (decl_QKeySequence_SequenceFormat_Enums, "QKeySequence_SequenceFormat",
  qt_gsi::mkdefs_QKeySequence_SequenceFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QKeySequence_SequenceFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QKeySequence_SequenceFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQKeySequence_SequenceFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QKeySequence_SequenceFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QKeySequence_SequenceFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QKeySequence::SequenceFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QKeySequence> inject_QKeySequence_SequenceFormat_Enum_in_parent (qt_gsi::mkdefs_QKeySequence_SequenceFormat ());
static gsi::ClassExt<QKeySequence> decl_QKeySequence_SequenceFormat_Enum_as_child (decl_QKeySequence_SequenceFormat_Enum, "SequenceFormat");

}


//  Implementation of the enum wrapper class for QKeySequence::SequenceMatch
namespace qt_gsi
{

static QKeySequence_SequenceMatch_Enum *c_1_QKeySequence_SequenceMatch_Enum () { return new QKeySequence_SequenceMatch_Enum (QKeySequence::NoMatch); }
static QKeySequence_SequenceMatch_Enum *c_2_QKeySequence_SequenceMatch_Enum () { return new QKeySequence_SequenceMatch_Enum (QKeySequence::PartialMatch); }
static QKeySequence_SequenceMatch_Enum *c_3_QKeySequence_SequenceMatch_Enum () { return new QKeySequence_SequenceMatch_Enum (QKeySequence::ExactMatch); }

static gsi::Methods mkdefs_QKeySequence_SequenceMatch () {
  return
    gsi::constant ("NoMatch", &qt_gsi::c_1_QKeySequence_SequenceMatch_Enum, "@brief Enum constant QKeySequence::NoMatch") +
    gsi::constant ("PartialMatch", &qt_gsi::c_2_QKeySequence_SequenceMatch_Enum, "@brief Enum constant QKeySequence::PartialMatch") +
    gsi::constant ("ExactMatch", &qt_gsi::c_3_QKeySequence_SequenceMatch_Enum, "@brief Enum constant QKeySequence::ExactMatch");
}

static std::string to_s_QKeySequence_SequenceMatch_Enum (const QKeySequence_SequenceMatch_Enum *e)
{
  if (e->value () == QKeySequence::NoMatch) { return tl::sprintf ("NoMatch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::PartialMatch) { return tl::sprintf ("PartialMatch (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::ExactMatch) { return tl::sprintf ("ExactMatch (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QKeySequence_SequenceMatch_Enum (const QKeySequence_SequenceMatch_Enum *e)
{
  return (unsigned int) e->value ();
}

static QKeySequence_SequenceMatch_Enum *from_i_QKeySequence_SequenceMatch_Enum (unsigned int i)
{
  return new QKeySequence_SequenceMatch_Enum ((QKeySequence::SequenceMatch) i);
}

static bool equalQKeySequence_SequenceMatch_Enum (const QKeySequence_SequenceMatch_Enum *e, QKeySequence_SequenceMatch_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QKeySequence_SequenceMatch_Enum (const QKeySequence_SequenceMatch_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QKeySequence_SequenceMatch_Enums oropQKeySequence_SequenceMatch_Enums (const QKeySequence_SequenceMatch_Enums *e, const QKeySequence_SequenceMatch_Enums &d)
{
  return e->flags () | d.flags ();
}

static QKeySequence_SequenceMatch_Enums andopQKeySequence_SequenceMatch_Enums (const QKeySequence_SequenceMatch_Enums *e, const QKeySequence_SequenceMatch_Enums &d)
{
  return e->flags () & d.flags ();
}

static QKeySequence_SequenceMatch_Enums xoropQKeySequence_SequenceMatch_Enums (const QKeySequence_SequenceMatch_Enums *e, const QKeySequence_SequenceMatch_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QKeySequence_SequenceMatch_Enums (const QKeySequence_SequenceMatch_Enums *e)
{
  std::string l;
  if (e->testFlag (QKeySequence::NoMatch)) { if (!l.empty ()) l += "|"; l += "NoMatch"; }
  if (e->testFlag (QKeySequence::PartialMatch)) { if (!l.empty ()) l += "|"; l += "PartialMatch"; }
  if (e->testFlag (QKeySequence::ExactMatch)) { if (!l.empty ()) l += "|"; l += "ExactMatch"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QKeySequence_SequenceMatch_Enums (const QKeySequence_SequenceMatch_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QKeySequence_SequenceMatch_Enums (const QKeySequence_SequenceMatch_Enums *e, const QKeySequence_SequenceMatch_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QKeySequence_SequenceMatch_Enums> decl_QKeySequence_SequenceMatch_Enums ("QKeySequence_QFlags_SequenceMatch",
  gsi::method_ext ("|", &qt_gsi::oropQKeySequence_SequenceMatch_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQKeySequence_SequenceMatch_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQKeySequence_SequenceMatch_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QKeySequence_SequenceMatch_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QKeySequence_SequenceMatch_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QKeySequence_SequenceMatch_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QKeySequence::SequenceMatch> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QKeySequence_SequenceMatch_Enum> decl_QKeySequence_SequenceMatch_Enum (decl_QKeySequence_SequenceMatch_Enums, "QKeySequence_SequenceMatch",
  qt_gsi::mkdefs_QKeySequence_SequenceMatch () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QKeySequence_SequenceMatch_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QKeySequence_SequenceMatch_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQKeySequence_SequenceMatch_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QKeySequence_SequenceMatch_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QKeySequence_SequenceMatch_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QKeySequence::SequenceMatch enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QKeySequence> inject_QKeySequence_SequenceMatch_Enum_in_parent (qt_gsi::mkdefs_QKeySequence_SequenceMatch ());
static gsi::ClassExt<QKeySequence> decl_QKeySequence_SequenceMatch_Enum_as_child (decl_QKeySequence_SequenceMatch_Enum, "SequenceMatch");

}


//  Implementation of the enum wrapper class for QKeySequence::StandardKey
namespace qt_gsi
{

static QKeySequence_StandardKey_Enum *c_1_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::UnknownKey); }
static QKeySequence_StandardKey_Enum *c_2_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::HelpContents); }
static QKeySequence_StandardKey_Enum *c_3_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::WhatsThis); }
static QKeySequence_StandardKey_Enum *c_4_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Open); }
static QKeySequence_StandardKey_Enum *c_5_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Close); }
static QKeySequence_StandardKey_Enum *c_6_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Save); }
static QKeySequence_StandardKey_Enum *c_7_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::New); }
static QKeySequence_StandardKey_Enum *c_8_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Delete); }
static QKeySequence_StandardKey_Enum *c_9_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Cut); }
static QKeySequence_StandardKey_Enum *c_10_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Copy); }
static QKeySequence_StandardKey_Enum *c_11_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Paste); }
static QKeySequence_StandardKey_Enum *c_12_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Undo); }
static QKeySequence_StandardKey_Enum *c_13_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Redo); }
static QKeySequence_StandardKey_Enum *c_14_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Back); }
static QKeySequence_StandardKey_Enum *c_15_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Forward); }
static QKeySequence_StandardKey_Enum *c_16_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Refresh); }
static QKeySequence_StandardKey_Enum *c_17_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::ZoomIn); }
static QKeySequence_StandardKey_Enum *c_18_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::ZoomOut); }
static QKeySequence_StandardKey_Enum *c_19_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Print); }
static QKeySequence_StandardKey_Enum *c_20_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::AddTab); }
static QKeySequence_StandardKey_Enum *c_21_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::NextChild); }
static QKeySequence_StandardKey_Enum *c_22_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::PreviousChild); }
static QKeySequence_StandardKey_Enum *c_23_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Find); }
static QKeySequence_StandardKey_Enum *c_24_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::FindNext); }
static QKeySequence_StandardKey_Enum *c_25_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::FindPrevious); }
static QKeySequence_StandardKey_Enum *c_26_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Replace); }
static QKeySequence_StandardKey_Enum *c_27_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectAll); }
static QKeySequence_StandardKey_Enum *c_28_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Bold); }
static QKeySequence_StandardKey_Enum *c_29_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Italic); }
static QKeySequence_StandardKey_Enum *c_30_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Underline); }
static QKeySequence_StandardKey_Enum *c_31_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToNextChar); }
static QKeySequence_StandardKey_Enum *c_32_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToPreviousChar); }
static QKeySequence_StandardKey_Enum *c_33_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToNextWord); }
static QKeySequence_StandardKey_Enum *c_34_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToPreviousWord); }
static QKeySequence_StandardKey_Enum *c_35_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToNextLine); }
static QKeySequence_StandardKey_Enum *c_36_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToPreviousLine); }
static QKeySequence_StandardKey_Enum *c_37_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToNextPage); }
static QKeySequence_StandardKey_Enum *c_38_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToPreviousPage); }
static QKeySequence_StandardKey_Enum *c_39_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToStartOfLine); }
static QKeySequence_StandardKey_Enum *c_40_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToEndOfLine); }
static QKeySequence_StandardKey_Enum *c_41_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToStartOfBlock); }
static QKeySequence_StandardKey_Enum *c_42_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToEndOfBlock); }
static QKeySequence_StandardKey_Enum *c_43_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToStartOfDocument); }
static QKeySequence_StandardKey_Enum *c_44_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::MoveToEndOfDocument); }
static QKeySequence_StandardKey_Enum *c_45_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectNextChar); }
static QKeySequence_StandardKey_Enum *c_46_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectPreviousChar); }
static QKeySequence_StandardKey_Enum *c_47_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectNextWord); }
static QKeySequence_StandardKey_Enum *c_48_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectPreviousWord); }
static QKeySequence_StandardKey_Enum *c_49_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectNextLine); }
static QKeySequence_StandardKey_Enum *c_50_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectPreviousLine); }
static QKeySequence_StandardKey_Enum *c_51_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectNextPage); }
static QKeySequence_StandardKey_Enum *c_52_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectPreviousPage); }
static QKeySequence_StandardKey_Enum *c_53_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectStartOfLine); }
static QKeySequence_StandardKey_Enum *c_54_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectEndOfLine); }
static QKeySequence_StandardKey_Enum *c_55_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectStartOfBlock); }
static QKeySequence_StandardKey_Enum *c_56_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectEndOfBlock); }
static QKeySequence_StandardKey_Enum *c_57_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectStartOfDocument); }
static QKeySequence_StandardKey_Enum *c_58_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SelectEndOfDocument); }
static QKeySequence_StandardKey_Enum *c_59_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::DeleteStartOfWord); }
static QKeySequence_StandardKey_Enum *c_60_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::DeleteEndOfWord); }
static QKeySequence_StandardKey_Enum *c_61_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::DeleteEndOfLine); }
static QKeySequence_StandardKey_Enum *c_62_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::InsertParagraphSeparator); }
static QKeySequence_StandardKey_Enum *c_63_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::InsertLineSeparator); }
static QKeySequence_StandardKey_Enum *c_64_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::SaveAs); }
static QKeySequence_StandardKey_Enum *c_65_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Preferences); }
static QKeySequence_StandardKey_Enum *c_66_QKeySequence_StandardKey_Enum () { return new QKeySequence_StandardKey_Enum (QKeySequence::Quit); }

static gsi::Methods mkdefs_QKeySequence_StandardKey () {
  return
    gsi::constant ("UnknownKey", &qt_gsi::c_1_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::UnknownKey") +
    gsi::constant ("HelpContents", &qt_gsi::c_2_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::HelpContents") +
    gsi::constant ("WhatsThis", &qt_gsi::c_3_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::WhatsThis") +
    gsi::constant ("Open", &qt_gsi::c_4_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Open") +
    gsi::constant ("Close", &qt_gsi::c_5_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Close") +
    gsi::constant ("Save", &qt_gsi::c_6_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Save") +
    gsi::constant ("New", &qt_gsi::c_7_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::New") +
    gsi::constant ("Delete", &qt_gsi::c_8_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Delete") +
    gsi::constant ("Cut", &qt_gsi::c_9_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Cut") +
    gsi::constant ("Copy", &qt_gsi::c_10_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Copy") +
    gsi::constant ("Paste", &qt_gsi::c_11_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Paste") +
    gsi::constant ("Undo", &qt_gsi::c_12_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Undo") +
    gsi::constant ("Redo", &qt_gsi::c_13_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Redo") +
    gsi::constant ("Back", &qt_gsi::c_14_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Back") +
    gsi::constant ("Forward", &qt_gsi::c_15_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Forward") +
    gsi::constant ("Refresh", &qt_gsi::c_16_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Refresh") +
    gsi::constant ("ZoomIn", &qt_gsi::c_17_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::ZoomIn") +
    gsi::constant ("ZoomOut", &qt_gsi::c_18_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::ZoomOut") +
    gsi::constant ("Print", &qt_gsi::c_19_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Print") +
    gsi::constant ("AddTab", &qt_gsi::c_20_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::AddTab") +
    gsi::constant ("NextChild", &qt_gsi::c_21_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::NextChild") +
    gsi::constant ("PreviousChild", &qt_gsi::c_22_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::PreviousChild") +
    gsi::constant ("Find", &qt_gsi::c_23_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Find") +
    gsi::constant ("FindNext", &qt_gsi::c_24_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::FindNext") +
    gsi::constant ("FindPrevious", &qt_gsi::c_25_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::FindPrevious") +
    gsi::constant ("Replace", &qt_gsi::c_26_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Replace") +
    gsi::constant ("SelectAll", &qt_gsi::c_27_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectAll") +
    gsi::constant ("Bold", &qt_gsi::c_28_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Bold") +
    gsi::constant ("Italic", &qt_gsi::c_29_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Italic") +
    gsi::constant ("Underline", &qt_gsi::c_30_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Underline") +
    gsi::constant ("MoveToNextChar", &qt_gsi::c_31_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToNextChar") +
    gsi::constant ("MoveToPreviousChar", &qt_gsi::c_32_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToPreviousChar") +
    gsi::constant ("MoveToNextWord", &qt_gsi::c_33_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToNextWord") +
    gsi::constant ("MoveToPreviousWord", &qt_gsi::c_34_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToPreviousWord") +
    gsi::constant ("MoveToNextLine", &qt_gsi::c_35_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToNextLine") +
    gsi::constant ("MoveToPreviousLine", &qt_gsi::c_36_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToPreviousLine") +
    gsi::constant ("MoveToNextPage", &qt_gsi::c_37_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToNextPage") +
    gsi::constant ("MoveToPreviousPage", &qt_gsi::c_38_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToPreviousPage") +
    gsi::constant ("MoveToStartOfLine", &qt_gsi::c_39_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToStartOfLine") +
    gsi::constant ("MoveToEndOfLine", &qt_gsi::c_40_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToEndOfLine") +
    gsi::constant ("MoveToStartOfBlock", &qt_gsi::c_41_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToStartOfBlock") +
    gsi::constant ("MoveToEndOfBlock", &qt_gsi::c_42_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToEndOfBlock") +
    gsi::constant ("MoveToStartOfDocument", &qt_gsi::c_43_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToStartOfDocument") +
    gsi::constant ("MoveToEndOfDocument", &qt_gsi::c_44_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::MoveToEndOfDocument") +
    gsi::constant ("SelectNextChar", &qt_gsi::c_45_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectNextChar") +
    gsi::constant ("SelectPreviousChar", &qt_gsi::c_46_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectPreviousChar") +
    gsi::constant ("SelectNextWord", &qt_gsi::c_47_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectNextWord") +
    gsi::constant ("SelectPreviousWord", &qt_gsi::c_48_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectPreviousWord") +
    gsi::constant ("SelectNextLine", &qt_gsi::c_49_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectNextLine") +
    gsi::constant ("SelectPreviousLine", &qt_gsi::c_50_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectPreviousLine") +
    gsi::constant ("SelectNextPage", &qt_gsi::c_51_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectNextPage") +
    gsi::constant ("SelectPreviousPage", &qt_gsi::c_52_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectPreviousPage") +
    gsi::constant ("SelectStartOfLine", &qt_gsi::c_53_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectStartOfLine") +
    gsi::constant ("SelectEndOfLine", &qt_gsi::c_54_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectEndOfLine") +
    gsi::constant ("SelectStartOfBlock", &qt_gsi::c_55_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectStartOfBlock") +
    gsi::constant ("SelectEndOfBlock", &qt_gsi::c_56_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectEndOfBlock") +
    gsi::constant ("SelectStartOfDocument", &qt_gsi::c_57_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectStartOfDocument") +
    gsi::constant ("SelectEndOfDocument", &qt_gsi::c_58_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SelectEndOfDocument") +
    gsi::constant ("DeleteStartOfWord", &qt_gsi::c_59_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::DeleteStartOfWord") +
    gsi::constant ("DeleteEndOfWord", &qt_gsi::c_60_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::DeleteEndOfWord") +
    gsi::constant ("DeleteEndOfLine", &qt_gsi::c_61_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::DeleteEndOfLine") +
    gsi::constant ("InsertParagraphSeparator", &qt_gsi::c_62_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::InsertParagraphSeparator") +
    gsi::constant ("InsertLineSeparator", &qt_gsi::c_63_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::InsertLineSeparator") +
    gsi::constant ("SaveAs", &qt_gsi::c_64_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::SaveAs") +
    gsi::constant ("Preferences", &qt_gsi::c_65_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Preferences") +
    gsi::constant ("Quit", &qt_gsi::c_66_QKeySequence_StandardKey_Enum, "@brief Enum constant QKeySequence::Quit");
}

static std::string to_s_QKeySequence_StandardKey_Enum (const QKeySequence_StandardKey_Enum *e)
{
  if (e->value () == QKeySequence::UnknownKey) { return tl::sprintf ("UnknownKey (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::HelpContents) { return tl::sprintf ("HelpContents (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::WhatsThis) { return tl::sprintf ("WhatsThis (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Open) { return tl::sprintf ("Open (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Close) { return tl::sprintf ("Close (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Save) { return tl::sprintf ("Save (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::New) { return tl::sprintf ("New (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Delete) { return tl::sprintf ("Delete (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Cut) { return tl::sprintf ("Cut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Copy) { return tl::sprintf ("Copy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Paste) { return tl::sprintf ("Paste (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Undo) { return tl::sprintf ("Undo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Redo) { return tl::sprintf ("Redo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Back) { return tl::sprintf ("Back (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Forward) { return tl::sprintf ("Forward (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Refresh) { return tl::sprintf ("Refresh (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::ZoomIn) { return tl::sprintf ("ZoomIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::ZoomOut) { return tl::sprintf ("ZoomOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Print) { return tl::sprintf ("Print (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::AddTab) { return tl::sprintf ("AddTab (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::NextChild) { return tl::sprintf ("NextChild (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::PreviousChild) { return tl::sprintf ("PreviousChild (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Find) { return tl::sprintf ("Find (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::FindNext) { return tl::sprintf ("FindNext (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::FindPrevious) { return tl::sprintf ("FindPrevious (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Replace) { return tl::sprintf ("Replace (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectAll) { return tl::sprintf ("SelectAll (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Bold) { return tl::sprintf ("Bold (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Italic) { return tl::sprintf ("Italic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Underline) { return tl::sprintf ("Underline (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToNextChar) { return tl::sprintf ("MoveToNextChar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToPreviousChar) { return tl::sprintf ("MoveToPreviousChar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToNextWord) { return tl::sprintf ("MoveToNextWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToPreviousWord) { return tl::sprintf ("MoveToPreviousWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToNextLine) { return tl::sprintf ("MoveToNextLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToPreviousLine) { return tl::sprintf ("MoveToPreviousLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToNextPage) { return tl::sprintf ("MoveToNextPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToPreviousPage) { return tl::sprintf ("MoveToPreviousPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToStartOfLine) { return tl::sprintf ("MoveToStartOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToEndOfLine) { return tl::sprintf ("MoveToEndOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToStartOfBlock) { return tl::sprintf ("MoveToStartOfBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToEndOfBlock) { return tl::sprintf ("MoveToEndOfBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToStartOfDocument) { return tl::sprintf ("MoveToStartOfDocument (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::MoveToEndOfDocument) { return tl::sprintf ("MoveToEndOfDocument (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectNextChar) { return tl::sprintf ("SelectNextChar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectPreviousChar) { return tl::sprintf ("SelectPreviousChar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectNextWord) { return tl::sprintf ("SelectNextWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectPreviousWord) { return tl::sprintf ("SelectPreviousWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectNextLine) { return tl::sprintf ("SelectNextLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectPreviousLine) { return tl::sprintf ("SelectPreviousLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectNextPage) { return tl::sprintf ("SelectNextPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectPreviousPage) { return tl::sprintf ("SelectPreviousPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectStartOfLine) { return tl::sprintf ("SelectStartOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectEndOfLine) { return tl::sprintf ("SelectEndOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectStartOfBlock) { return tl::sprintf ("SelectStartOfBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectEndOfBlock) { return tl::sprintf ("SelectEndOfBlock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectStartOfDocument) { return tl::sprintf ("SelectStartOfDocument (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SelectEndOfDocument) { return tl::sprintf ("SelectEndOfDocument (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::DeleteStartOfWord) { return tl::sprintf ("DeleteStartOfWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::DeleteEndOfWord) { return tl::sprintf ("DeleteEndOfWord (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::DeleteEndOfLine) { return tl::sprintf ("DeleteEndOfLine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::InsertParagraphSeparator) { return tl::sprintf ("InsertParagraphSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::InsertLineSeparator) { return tl::sprintf ("InsertLineSeparator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::SaveAs) { return tl::sprintf ("SaveAs (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Preferences) { return tl::sprintf ("Preferences (%u)", (unsigned int) e->value ()); }
  if (e->value () == QKeySequence::Quit) { return tl::sprintf ("Quit (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QKeySequence_StandardKey_Enum (const QKeySequence_StandardKey_Enum *e)
{
  return (unsigned int) e->value ();
}

static QKeySequence_StandardKey_Enum *from_i_QKeySequence_StandardKey_Enum (unsigned int i)
{
  return new QKeySequence_StandardKey_Enum ((QKeySequence::StandardKey) i);
}

static bool equalQKeySequence_StandardKey_Enum (const QKeySequence_StandardKey_Enum *e, QKeySequence_StandardKey_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QKeySequence_StandardKey_Enum (const QKeySequence_StandardKey_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QKeySequence_StandardKey_Enums oropQKeySequence_StandardKey_Enums (const QKeySequence_StandardKey_Enums *e, const QKeySequence_StandardKey_Enums &d)
{
  return e->flags () | d.flags ();
}

static QKeySequence_StandardKey_Enums andopQKeySequence_StandardKey_Enums (const QKeySequence_StandardKey_Enums *e, const QKeySequence_StandardKey_Enums &d)
{
  return e->flags () & d.flags ();
}

static QKeySequence_StandardKey_Enums xoropQKeySequence_StandardKey_Enums (const QKeySequence_StandardKey_Enums *e, const QKeySequence_StandardKey_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QKeySequence_StandardKey_Enums (const QKeySequence_StandardKey_Enums *e)
{
  std::string l;
  if (e->testFlag (QKeySequence::UnknownKey)) { if (!l.empty ()) l += "|"; l += "UnknownKey"; }
  if (e->testFlag (QKeySequence::HelpContents)) { if (!l.empty ()) l += "|"; l += "HelpContents"; }
  if (e->testFlag (QKeySequence::WhatsThis)) { if (!l.empty ()) l += "|"; l += "WhatsThis"; }
  if (e->testFlag (QKeySequence::Open)) { if (!l.empty ()) l += "|"; l += "Open"; }
  if (e->testFlag (QKeySequence::Close)) { if (!l.empty ()) l += "|"; l += "Close"; }
  if (e->testFlag (QKeySequence::Save)) { if (!l.empty ()) l += "|"; l += "Save"; }
  if (e->testFlag (QKeySequence::New)) { if (!l.empty ()) l += "|"; l += "New"; }
  if (e->testFlag (QKeySequence::Delete)) { if (!l.empty ()) l += "|"; l += "Delete"; }
  if (e->testFlag (QKeySequence::Cut)) { if (!l.empty ()) l += "|"; l += "Cut"; }
  if (e->testFlag (QKeySequence::Copy)) { if (!l.empty ()) l += "|"; l += "Copy"; }
  if (e->testFlag (QKeySequence::Paste)) { if (!l.empty ()) l += "|"; l += "Paste"; }
  if (e->testFlag (QKeySequence::Undo)) { if (!l.empty ()) l += "|"; l += "Undo"; }
  if (e->testFlag (QKeySequence::Redo)) { if (!l.empty ()) l += "|"; l += "Redo"; }
  if (e->testFlag (QKeySequence::Back)) { if (!l.empty ()) l += "|"; l += "Back"; }
  if (e->testFlag (QKeySequence::Forward)) { if (!l.empty ()) l += "|"; l += "Forward"; }
  if (e->testFlag (QKeySequence::Refresh)) { if (!l.empty ()) l += "|"; l += "Refresh"; }
  if (e->testFlag (QKeySequence::ZoomIn)) { if (!l.empty ()) l += "|"; l += "ZoomIn"; }
  if (e->testFlag (QKeySequence::ZoomOut)) { if (!l.empty ()) l += "|"; l += "ZoomOut"; }
  if (e->testFlag (QKeySequence::Print)) { if (!l.empty ()) l += "|"; l += "Print"; }
  if (e->testFlag (QKeySequence::AddTab)) { if (!l.empty ()) l += "|"; l += "AddTab"; }
  if (e->testFlag (QKeySequence::NextChild)) { if (!l.empty ()) l += "|"; l += "NextChild"; }
  if (e->testFlag (QKeySequence::PreviousChild)) { if (!l.empty ()) l += "|"; l += "PreviousChild"; }
  if (e->testFlag (QKeySequence::Find)) { if (!l.empty ()) l += "|"; l += "Find"; }
  if (e->testFlag (QKeySequence::FindNext)) { if (!l.empty ()) l += "|"; l += "FindNext"; }
  if (e->testFlag (QKeySequence::FindPrevious)) { if (!l.empty ()) l += "|"; l += "FindPrevious"; }
  if (e->testFlag (QKeySequence::Replace)) { if (!l.empty ()) l += "|"; l += "Replace"; }
  if (e->testFlag (QKeySequence::SelectAll)) { if (!l.empty ()) l += "|"; l += "SelectAll"; }
  if (e->testFlag (QKeySequence::Bold)) { if (!l.empty ()) l += "|"; l += "Bold"; }
  if (e->testFlag (QKeySequence::Italic)) { if (!l.empty ()) l += "|"; l += "Italic"; }
  if (e->testFlag (QKeySequence::Underline)) { if (!l.empty ()) l += "|"; l += "Underline"; }
  if (e->testFlag (QKeySequence::MoveToNextChar)) { if (!l.empty ()) l += "|"; l += "MoveToNextChar"; }
  if (e->testFlag (QKeySequence::MoveToPreviousChar)) { if (!l.empty ()) l += "|"; l += "MoveToPreviousChar"; }
  if (e->testFlag (QKeySequence::MoveToNextWord)) { if (!l.empty ()) l += "|"; l += "MoveToNextWord"; }
  if (e->testFlag (QKeySequence::MoveToPreviousWord)) { if (!l.empty ()) l += "|"; l += "MoveToPreviousWord"; }
  if (e->testFlag (QKeySequence::MoveToNextLine)) { if (!l.empty ()) l += "|"; l += "MoveToNextLine"; }
  if (e->testFlag (QKeySequence::MoveToPreviousLine)) { if (!l.empty ()) l += "|"; l += "MoveToPreviousLine"; }
  if (e->testFlag (QKeySequence::MoveToNextPage)) { if (!l.empty ()) l += "|"; l += "MoveToNextPage"; }
  if (e->testFlag (QKeySequence::MoveToPreviousPage)) { if (!l.empty ()) l += "|"; l += "MoveToPreviousPage"; }
  if (e->testFlag (QKeySequence::MoveToStartOfLine)) { if (!l.empty ()) l += "|"; l += "MoveToStartOfLine"; }
  if (e->testFlag (QKeySequence::MoveToEndOfLine)) { if (!l.empty ()) l += "|"; l += "MoveToEndOfLine"; }
  if (e->testFlag (QKeySequence::MoveToStartOfBlock)) { if (!l.empty ()) l += "|"; l += "MoveToStartOfBlock"; }
  if (e->testFlag (QKeySequence::MoveToEndOfBlock)) { if (!l.empty ()) l += "|"; l += "MoveToEndOfBlock"; }
  if (e->testFlag (QKeySequence::MoveToStartOfDocument)) { if (!l.empty ()) l += "|"; l += "MoveToStartOfDocument"; }
  if (e->testFlag (QKeySequence::MoveToEndOfDocument)) { if (!l.empty ()) l += "|"; l += "MoveToEndOfDocument"; }
  if (e->testFlag (QKeySequence::SelectNextChar)) { if (!l.empty ()) l += "|"; l += "SelectNextChar"; }
  if (e->testFlag (QKeySequence::SelectPreviousChar)) { if (!l.empty ()) l += "|"; l += "SelectPreviousChar"; }
  if (e->testFlag (QKeySequence::SelectNextWord)) { if (!l.empty ()) l += "|"; l += "SelectNextWord"; }
  if (e->testFlag (QKeySequence::SelectPreviousWord)) { if (!l.empty ()) l += "|"; l += "SelectPreviousWord"; }
  if (e->testFlag (QKeySequence::SelectNextLine)) { if (!l.empty ()) l += "|"; l += "SelectNextLine"; }
  if (e->testFlag (QKeySequence::SelectPreviousLine)) { if (!l.empty ()) l += "|"; l += "SelectPreviousLine"; }
  if (e->testFlag (QKeySequence::SelectNextPage)) { if (!l.empty ()) l += "|"; l += "SelectNextPage"; }
  if (e->testFlag (QKeySequence::SelectPreviousPage)) { if (!l.empty ()) l += "|"; l += "SelectPreviousPage"; }
  if (e->testFlag (QKeySequence::SelectStartOfLine)) { if (!l.empty ()) l += "|"; l += "SelectStartOfLine"; }
  if (e->testFlag (QKeySequence::SelectEndOfLine)) { if (!l.empty ()) l += "|"; l += "SelectEndOfLine"; }
  if (e->testFlag (QKeySequence::SelectStartOfBlock)) { if (!l.empty ()) l += "|"; l += "SelectStartOfBlock"; }
  if (e->testFlag (QKeySequence::SelectEndOfBlock)) { if (!l.empty ()) l += "|"; l += "SelectEndOfBlock"; }
  if (e->testFlag (QKeySequence::SelectStartOfDocument)) { if (!l.empty ()) l += "|"; l += "SelectStartOfDocument"; }
  if (e->testFlag (QKeySequence::SelectEndOfDocument)) { if (!l.empty ()) l += "|"; l += "SelectEndOfDocument"; }
  if (e->testFlag (QKeySequence::DeleteStartOfWord)) { if (!l.empty ()) l += "|"; l += "DeleteStartOfWord"; }
  if (e->testFlag (QKeySequence::DeleteEndOfWord)) { if (!l.empty ()) l += "|"; l += "DeleteEndOfWord"; }
  if (e->testFlag (QKeySequence::DeleteEndOfLine)) { if (!l.empty ()) l += "|"; l += "DeleteEndOfLine"; }
  if (e->testFlag (QKeySequence::InsertParagraphSeparator)) { if (!l.empty ()) l += "|"; l += "InsertParagraphSeparator"; }
  if (e->testFlag (QKeySequence::InsertLineSeparator)) { if (!l.empty ()) l += "|"; l += "InsertLineSeparator"; }
  if (e->testFlag (QKeySequence::SaveAs)) { if (!l.empty ()) l += "|"; l += "SaveAs"; }
  if (e->testFlag (QKeySequence::Preferences)) { if (!l.empty ()) l += "|"; l += "Preferences"; }
  if (e->testFlag (QKeySequence::Quit)) { if (!l.empty ()) l += "|"; l += "Quit"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QKeySequence_StandardKey_Enums (const QKeySequence_StandardKey_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QKeySequence_StandardKey_Enums (const QKeySequence_StandardKey_Enums *e, const QKeySequence_StandardKey_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QKeySequence_StandardKey_Enums> decl_QKeySequence_StandardKey_Enums ("QKeySequence_QFlags_StandardKey",
  gsi::method_ext ("|", &qt_gsi::oropQKeySequence_StandardKey_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQKeySequence_StandardKey_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQKeySequence_StandardKey_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QKeySequence_StandardKey_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QKeySequence_StandardKey_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QKeySequence_StandardKey_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QKeySequence::StandardKey> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QKeySequence_StandardKey_Enum> decl_QKeySequence_StandardKey_Enum (decl_QKeySequence_StandardKey_Enums, "QKeySequence_StandardKey",
  qt_gsi::mkdefs_QKeySequence_StandardKey () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QKeySequence_StandardKey_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QKeySequence_StandardKey_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQKeySequence_StandardKey_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QKeySequence_StandardKey_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QKeySequence_StandardKey_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QKeySequence::StandardKey enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QKeySequence> inject_QKeySequence_StandardKey_Enum_in_parent (qt_gsi::mkdefs_QKeySequence_StandardKey ());
static gsi::ClassExt<QKeySequence> decl_QKeySequence_StandardKey_Enum_as_child (decl_QKeySequence_StandardKey_Enum, "StandardKey");

}

