
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQInputDialog.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQInputDialog_EventAdaptor.h"
#include "gsiDeclQInputDialog_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QInputDialog

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QInputDialog::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QString QInputDialog::cancelButtonText()


static void _init_f_cancelButtonText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_cancelButtonText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputDialog *)cls)->cancelButtonText ());
}

static qt_gsi::GenericMethod *_create_f_cancelButtonText_c0 ()
{
  return new qt_gsi::GenericMethod (":cancelButtonText", "@brief Method QString QInputDialog::cancelButtonText()\n", true, &_init_f_cancelButtonText_c0, &_call_f_cancelButtonText_c0);
}

// QStringList QInputDialog::comboBoxItems()


static void _init_f_comboBoxItems_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_f_comboBoxItems_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)qt_gsi::CppToQtAdaptor<QStringList>(((QInputDialog *)cls)->comboBoxItems ()));
}

static qt_gsi::GenericMethod *_create_f_comboBoxItems_c0 ()
{
  return new qt_gsi::GenericMethod (":comboBoxItems", "@brief Method QStringList QInputDialog::comboBoxItems()\n", true, &_init_f_comboBoxItems_c0, &_call_f_comboBoxItems_c0);
}

// void QInputDialog::done(int result)


static void _init_f_done_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_done_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog *)cls)->done (arg1);
}

static qt_gsi::GenericMethod *_create_f_done_767 ()
{
  return new qt_gsi::GenericMethod ("done", "@brief Method void QInputDialog::done(int result)\nThis is a reimplementation of QDialog::done", false, &_init_f_done_767, &_call_f_done_767);
}

// int QInputDialog::doubleDecimals()


static void _init_f_doubleDecimals_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_doubleDecimals_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QInputDialog *)cls)->doubleDecimals ());
}

static qt_gsi::GenericMethod *_create_f_doubleDecimals_c0 ()
{
  return new qt_gsi::GenericMethod (":doubleDecimals", "@brief Method int QInputDialog::doubleDecimals()\n", true, &_init_f_doubleDecimals_c0, &_call_f_doubleDecimals_c0);
}

// double QInputDialog::doubleMaximum()


static void _init_f_doubleMaximum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_doubleMaximum_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QInputDialog *)cls)->doubleMaximum ());
}

static qt_gsi::GenericMethod *_create_f_doubleMaximum_c0 ()
{
  return new qt_gsi::GenericMethod (":doubleMaximum", "@brief Method double QInputDialog::doubleMaximum()\n", true, &_init_f_doubleMaximum_c0, &_call_f_doubleMaximum_c0);
}

// double QInputDialog::doubleMinimum()


static void _init_f_doubleMinimum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_doubleMinimum_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QInputDialog *)cls)->doubleMinimum ());
}

static qt_gsi::GenericMethod *_create_f_doubleMinimum_c0 ()
{
  return new qt_gsi::GenericMethod (":doubleMinimum", "@brief Method double QInputDialog::doubleMinimum()\n", true, &_init_f_doubleMinimum_c0, &_call_f_doubleMinimum_c0);
}

// double QInputDialog::doubleValue()


static void _init_f_doubleValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_doubleValue_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QInputDialog *)cls)->doubleValue ());
}

static qt_gsi::GenericMethod *_create_f_doubleValue_c0 ()
{
  return new qt_gsi::GenericMethod (":doubleValue", "@brief Method double QInputDialog::doubleValue()\n", true, &_init_f_doubleValue_c0, &_call_f_doubleValue_c0);
}

// QInputDialog::InputMode QInputDialog::inputMode()


static void _init_f_inputMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QInputDialog::InputMode>::target_type > ();
}

static void _call_f_inputMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QInputDialog::InputMode>::target_type > ((qt_gsi::Converter<QInputDialog::InputMode>::target_type)qt_gsi::CppToQtAdaptor<QInputDialog::InputMode>(((QInputDialog *)cls)->inputMode ()));
}

static qt_gsi::GenericMethod *_create_f_inputMode_c0 ()
{
  return new qt_gsi::GenericMethod (":inputMode", "@brief Method QInputDialog::InputMode QInputDialog::inputMode()\n", true, &_init_f_inputMode_c0, &_call_f_inputMode_c0);
}

// int QInputDialog::intMaximum()


static void _init_f_intMaximum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intMaximum_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QInputDialog *)cls)->intMaximum ());
}

static qt_gsi::GenericMethod *_create_f_intMaximum_c0 ()
{
  return new qt_gsi::GenericMethod (":intMaximum", "@brief Method int QInputDialog::intMaximum()\n", true, &_init_f_intMaximum_c0, &_call_f_intMaximum_c0);
}

// int QInputDialog::intMinimum()


static void _init_f_intMinimum_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intMinimum_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QInputDialog *)cls)->intMinimum ());
}

static qt_gsi::GenericMethod *_create_f_intMinimum_c0 ()
{
  return new qt_gsi::GenericMethod (":intMinimum", "@brief Method int QInputDialog::intMinimum()\n", true, &_init_f_intMinimum_c0, &_call_f_intMinimum_c0);
}

// int QInputDialog::intStep()


static void _init_f_intStep_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intStep_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QInputDialog *)cls)->intStep ());
}

static qt_gsi::GenericMethod *_create_f_intStep_c0 ()
{
  return new qt_gsi::GenericMethod (":intStep", "@brief Method int QInputDialog::intStep()\n", true, &_init_f_intStep_c0, &_call_f_intStep_c0);
}

// int QInputDialog::intValue()


static void _init_f_intValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_intValue_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QInputDialog *)cls)->intValue ());
}

static qt_gsi::GenericMethod *_create_f_intValue_c0 ()
{
  return new qt_gsi::GenericMethod (":intValue", "@brief Method int QInputDialog::intValue()\n", true, &_init_f_intValue_c0, &_call_f_intValue_c0);
}

// bool QInputDialog::isComboBoxEditable()


static void _init_f_isComboBoxEditable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComboBoxEditable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QInputDialog *)cls)->isComboBoxEditable ());
}

static qt_gsi::GenericMethod *_create_f_isComboBoxEditable_c0 ()
{
  return new qt_gsi::GenericMethod ("isComboBoxEditable?|:comboBoxEditable", "@brief Method bool QInputDialog::isComboBoxEditable()\n", true, &_init_f_isComboBoxEditable_c0, &_call_f_isComboBoxEditable_c0);
}

// QString QInputDialog::labelText()


static void _init_f_labelText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_labelText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputDialog *)cls)->labelText ());
}

static qt_gsi::GenericMethod *_create_f_labelText_c0 ()
{
  return new qt_gsi::GenericMethod (":labelText", "@brief Method QString QInputDialog::labelText()\n", true, &_init_f_labelText_c0, &_call_f_labelText_c0);
}

// QSize QInputDialog::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QInputDialog *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QInputDialog::minimumSizeHint()\nThis is a reimplementation of QDialog::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// QString QInputDialog::okButtonText()


static void _init_f_okButtonText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_okButtonText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputDialog *)cls)->okButtonText ());
}

static qt_gsi::GenericMethod *_create_f_okButtonText_c0 ()
{
  return new qt_gsi::GenericMethod (":okButtonText", "@brief Method QString QInputDialog::okButtonText()\n", true, &_init_f_okButtonText_c0, &_call_f_okButtonText_c0);
}

// void QInputDialog::open()


static void _init_f_open_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_open_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputDialog *)cls)->open ();
}

static qt_gsi::GenericMethod *_create_f_open_0 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method void QInputDialog::open()\n", false, &_init_f_open_0, &_call_f_open_0);
}

// void QInputDialog::open(QObject *receiver, const char *member)


static void _init_f_open_2925 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("receiver");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("member");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_open_2925 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  const char *arg2 = args.read<const char * > ();
  ((QInputDialog *)cls)->open (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_open_2925 ()
{
  return new qt_gsi::GenericMethod ("open", "@brief Method void QInputDialog::open(QObject *receiver, const char *member)\n", false, &_init_f_open_2925, &_call_f_open_2925);
}

// QFlags<QInputDialog::InputDialogOption> QInputDialog::options()


static void _init_f_options_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QInputDialog::InputDialogOption> >::target_type > ();
}

static void _call_f_options_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QInputDialog::InputDialogOption> >::target_type > ((qt_gsi::Converter<QFlags<QInputDialog::InputDialogOption> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QInputDialog::InputDialogOption> >(((QInputDialog *)cls)->options ()));
}

static qt_gsi::GenericMethod *_create_f_options_c0 ()
{
  return new qt_gsi::GenericMethod (":options", "@brief Method QFlags<QInputDialog::InputDialogOption> QInputDialog::options()\n", true, &_init_f_options_c0, &_call_f_options_c0);
}

// void QInputDialog::setCancelButtonText(const QString &text)


static void _init_f_setCancelButtonText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCancelButtonText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QInputDialog *)cls)->setCancelButtonText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setCancelButtonText_2025 ()
{
  return new qt_gsi::GenericMethod ("setCancelButtonText|cancelButtonText=", "@brief Method void QInputDialog::setCancelButtonText(const QString &text)\n", false, &_init_f_setCancelButtonText_2025, &_call_f_setCancelButtonText_2025);
}

// void QInputDialog::setComboBoxEditable(bool editable)


static void _init_f_setComboBoxEditable_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("editable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setComboBoxEditable_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QInputDialog *)cls)->setComboBoxEditable (arg1);
}

static qt_gsi::GenericMethod *_create_f_setComboBoxEditable_864 ()
{
  return new qt_gsi::GenericMethod ("setComboBoxEditable|comboBoxEditable=", "@brief Method void QInputDialog::setComboBoxEditable(bool editable)\n", false, &_init_f_setComboBoxEditable_864, &_call_f_setComboBoxEditable_864);
}

// void QInputDialog::setComboBoxItems(const QStringList &items)


static void _init_f_setComboBoxItems_2437 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("items");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setComboBoxItems_2437 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QStringList>::target_type & arg1 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  ((QInputDialog *)cls)->setComboBoxItems (qt_gsi::QtToCppAdaptor<QStringList>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setComboBoxItems_2437 ()
{
  return new qt_gsi::GenericMethod ("setComboBoxItems|comboBoxItems=", "@brief Method void QInputDialog::setComboBoxItems(const QStringList &items)\n", false, &_init_f_setComboBoxItems_2437, &_call_f_setComboBoxItems_2437);
}

// void QInputDialog::setDoubleDecimals(int decimals)


static void _init_f_setDoubleDecimals_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("decimals");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleDecimals_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog *)cls)->setDoubleDecimals (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDoubleDecimals_767 ()
{
  return new qt_gsi::GenericMethod ("setDoubleDecimals|doubleDecimals=", "@brief Method void QInputDialog::setDoubleDecimals(int decimals)\n", false, &_init_f_setDoubleDecimals_767, &_call_f_setDoubleDecimals_767);
}

// void QInputDialog::setDoubleMaximum(double max)


static void _init_f_setDoubleMaximum_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleMaximum_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QInputDialog *)cls)->setDoubleMaximum (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDoubleMaximum_1071 ()
{
  return new qt_gsi::GenericMethod ("setDoubleMaximum|doubleMaximum=", "@brief Method void QInputDialog::setDoubleMaximum(double max)\n", false, &_init_f_setDoubleMaximum_1071, &_call_f_setDoubleMaximum_1071);
}

// void QInputDialog::setDoubleMinimum(double min)


static void _init_f_setDoubleMinimum_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleMinimum_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QInputDialog *)cls)->setDoubleMinimum (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDoubleMinimum_1071 ()
{
  return new qt_gsi::GenericMethod ("setDoubleMinimum|doubleMinimum=", "@brief Method void QInputDialog::setDoubleMinimum(double min)\n", false, &_init_f_setDoubleMinimum_1071, &_call_f_setDoubleMinimum_1071);
}

// void QInputDialog::setDoubleRange(double min, double max)


static void _init_f_setDoubleRange_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDoubleRange_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QInputDialog *)cls)->setDoubleRange (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setDoubleRange_2034 ()
{
  return new qt_gsi::GenericMethod ("setDoubleRange", "@brief Method void QInputDialog::setDoubleRange(double min, double max)\n", false, &_init_f_setDoubleRange_2034, &_call_f_setDoubleRange_2034);
}

// void QInputDialog::setDoubleValue(double value)


static void _init_f_setDoubleValue_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleValue_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QInputDialog *)cls)->setDoubleValue (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDoubleValue_1071 ()
{
  return new qt_gsi::GenericMethod ("setDoubleValue|doubleValue=", "@brief Method void QInputDialog::setDoubleValue(double value)\n", false, &_init_f_setDoubleValue_1071, &_call_f_setDoubleValue_1071);
}

// void QInputDialog::setInputMode(QInputDialog::InputMode mode)


static void _init_f_setInputMode_2670 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QInputDialog::InputMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputMode_2670 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QInputDialog::InputMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QInputDialog::InputMode>::target_type & > ();
  ((QInputDialog *)cls)->setInputMode (qt_gsi::QtToCppAdaptor<QInputDialog::InputMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setInputMode_2670 ()
{
  return new qt_gsi::GenericMethod ("setInputMode|inputMode=", "@brief Method void QInputDialog::setInputMode(QInputDialog::InputMode mode)\n", false, &_init_f_setInputMode_2670, &_call_f_setInputMode_2670);
}

// void QInputDialog::setIntMaximum(int max)


static void _init_f_setIntMaximum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("max");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntMaximum_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog *)cls)->setIntMaximum (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIntMaximum_767 ()
{
  return new qt_gsi::GenericMethod ("setIntMaximum|intMaximum=", "@brief Method void QInputDialog::setIntMaximum(int max)\n", false, &_init_f_setIntMaximum_767, &_call_f_setIntMaximum_767);
}

// void QInputDialog::setIntMinimum(int min)


static void _init_f_setIntMinimum_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntMinimum_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog *)cls)->setIntMinimum (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIntMinimum_767 ()
{
  return new qt_gsi::GenericMethod ("setIntMinimum|intMinimum=", "@brief Method void QInputDialog::setIntMinimum(int min)\n", false, &_init_f_setIntMinimum_767, &_call_f_setIntMinimum_767);
}

// void QInputDialog::setIntRange(int min, int max)


static void _init_f_setIntRange_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setIntRange_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QInputDialog *)cls)->setIntRange (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setIntRange_1426 ()
{
  return new qt_gsi::GenericMethod ("setIntRange", "@brief Method void QInputDialog::setIntRange(int min, int max)\n", false, &_init_f_setIntRange_1426, &_call_f_setIntRange_1426);
}

// void QInputDialog::setIntStep(int step)


static void _init_f_setIntStep_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("step");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntStep_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog *)cls)->setIntStep (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIntStep_767 ()
{
  return new qt_gsi::GenericMethod ("setIntStep|intStep=", "@brief Method void QInputDialog::setIntStep(int step)\n", false, &_init_f_setIntStep_767, &_call_f_setIntStep_767);
}

// void QInputDialog::setIntValue(int value)


static void _init_f_setIntValue_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setIntValue_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog *)cls)->setIntValue (arg1);
}

static qt_gsi::GenericMethod *_create_f_setIntValue_767 ()
{
  return new qt_gsi::GenericMethod ("setIntValue|intValue=", "@brief Method void QInputDialog::setIntValue(int value)\n", false, &_init_f_setIntValue_767, &_call_f_setIntValue_767);
}

// void QInputDialog::setLabelText(const QString &text)


static void _init_f_setLabelText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLabelText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QInputDialog *)cls)->setLabelText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setLabelText_2025 ()
{
  return new qt_gsi::GenericMethod ("setLabelText|labelText=", "@brief Method void QInputDialog::setLabelText(const QString &text)\n", false, &_init_f_setLabelText_2025, &_call_f_setLabelText_2025);
}

// void QInputDialog::setOkButtonText(const QString &text)


static void _init_f_setOkButtonText_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOkButtonText_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QInputDialog *)cls)->setOkButtonText (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOkButtonText_2025 ()
{
  return new qt_gsi::GenericMethod ("setOkButtonText|okButtonText=", "@brief Method void QInputDialog::setOkButtonText(const QString &text)\n", false, &_init_f_setOkButtonText_2025, &_call_f_setOkButtonText_2025);
}

// void QInputDialog::setOption(QInputDialog::InputDialogOption option, bool on)


static void _init_f_setOption_4262 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("on", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOption_4262 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QInputDialog *)cls)->setOption (qt_gsi::QtToCppAdaptor<QInputDialog::InputDialogOption>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setOption_4262 ()
{
  return new qt_gsi::GenericMethod ("setOption", "@brief Method void QInputDialog::setOption(QInputDialog::InputDialogOption option, bool on)\n", false, &_init_f_setOption_4262, &_call_f_setOption_4262);
}

// void QInputDialog::setOptions(QFlags<QInputDialog::InputDialogOption> options)


static void _init_f_setOptions_4202 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("options");
  decl->add_arg<const qt_gsi::Converter<QFlags<QInputDialog::InputDialogOption> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptions_4202 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QInputDialog::InputDialogOption> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QInputDialog::InputDialogOption> >::target_type & > ();
  ((QInputDialog *)cls)->setOptions (qt_gsi::QtToCppAdaptor<QFlags<QInputDialog::InputDialogOption> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOptions_4202 ()
{
  return new qt_gsi::GenericMethod ("setOptions|options=", "@brief Method void QInputDialog::setOptions(QFlags<QInputDialog::InputDialogOption> options)\n", false, &_init_f_setOptions_4202, &_call_f_setOptions_4202);
}

// void QInputDialog::setTextEchoMode(QLineEdit::EchoMode mode)


static void _init_f_setTextEchoMode_2187 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextEchoMode_2187 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & > ();
  ((QInputDialog *)cls)->setTextEchoMode (qt_gsi::QtToCppAdaptor<QLineEdit::EchoMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTextEchoMode_2187 ()
{
  return new qt_gsi::GenericMethod ("setTextEchoMode|textEchoMode=", "@brief Method void QInputDialog::setTextEchoMode(QLineEdit::EchoMode mode)\n", false, &_init_f_setTextEchoMode_2187, &_call_f_setTextEchoMode_2187);
}

// void QInputDialog::setTextValue(const QString &text)


static void _init_f_setTextValue_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("text");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTextValue_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QInputDialog *)cls)->setTextValue (arg1);
}

static qt_gsi::GenericMethod *_create_f_setTextValue_2025 ()
{
  return new qt_gsi::GenericMethod ("setTextValue|textValue=", "@brief Method void QInputDialog::setTextValue(const QString &text)\n", false, &_init_f_setTextValue_2025, &_call_f_setTextValue_2025);
}

// void QInputDialog::setVisible(bool visible)


static void _init_f_setVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QInputDialog *)cls)->setVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setVisible|visible=", "@brief Method void QInputDialog::setVisible(bool visible)\nThis is a reimplementation of QDialog::setVisible", false, &_init_f_setVisible_864, &_call_f_setVisible_864);
}

// QSize QInputDialog::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QInputDialog *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QInputDialog::sizeHint()\nThis is a reimplementation of QDialog::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// bool QInputDialog::testOption(QInputDialog::InputDialogOption option)


static void _init_f_testOption_c3506 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("option");
  decl->add_arg<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_testOption_c3506 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & arg1 = args.read<const qt_gsi::Converter<QInputDialog::InputDialogOption>::target_type & > ();
  ret.write<bool > ((bool)((QInputDialog *)cls)->testOption (qt_gsi::QtToCppAdaptor<QInputDialog::InputDialogOption>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_testOption_c3506 ()
{
  return new qt_gsi::GenericMethod ("testOption", "@brief Method bool QInputDialog::testOption(QInputDialog::InputDialogOption option)\n", true, &_init_f_testOption_c3506, &_call_f_testOption_c3506);
}

// QLineEdit::EchoMode QInputDialog::textEchoMode()


static void _init_f_textEchoMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QLineEdit::EchoMode>::target_type > ();
}

static void _call_f_textEchoMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QLineEdit::EchoMode>::target_type > ((qt_gsi::Converter<QLineEdit::EchoMode>::target_type)qt_gsi::CppToQtAdaptor<QLineEdit::EchoMode>(((QInputDialog *)cls)->textEchoMode ()));
}

static qt_gsi::GenericMethod *_create_f_textEchoMode_c0 ()
{
  return new qt_gsi::GenericMethod (":textEchoMode", "@brief Method QLineEdit::EchoMode QInputDialog::textEchoMode()\n", true, &_init_f_textEchoMode_c0, &_call_f_textEchoMode_c0);
}

// QString QInputDialog::textValue()


static void _init_f_textValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_textValue_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QInputDialog *)cls)->textValue ());
}

static qt_gsi::GenericMethod *_create_f_textValue_c0 ()
{
  return new qt_gsi::GenericMethod (":textValue", "@brief Method QString QInputDialog::textValue()\n", true, &_init_f_textValue_c0, &_call_f_textValue_c0);
}

// static double QInputDialog::getDouble(QWidget *parent, const QString &title, const QString &label, double value, double minValue, double maxValue, int decimals, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getDouble_12026 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("value", true, "0");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("minValue", true, "-2147483647");
  decl->add_arg<double > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("maxValue", true, "2147483647");
  decl->add_arg<double > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("decimals", true, "1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_8);
  decl->set_return<double > ();
}

static void _call_f_getDouble_12026 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  double arg4 = args ? args.read<double > () : (double)(0);
  double arg5 = args ? args.read<double > () : (double)(-2147483647);
  double arg6 = args ? args.read<double > () : (double)(2147483647);
  int arg7 = args ? args.read<int > () : (int)(1);
  bool *arg8 = args ? args.read<bool * > () : (bool *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg9 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<double > ((double)QInputDialog::getDouble (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg9).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getDouble_12026 ()
{
  return new qt_gsi::GenericStaticMethod ("getDouble", "@brief Static method double QInputDialog::getDouble(QWidget *parent, const QString &title, const QString &label, double value, double minValue, double maxValue, int decimals, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getDouble_12026, &_call_f_getDouble_12026);
}

// static int QInputDialog::getInt(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getInt_11114 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("value", true, "0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("minValue", true, "-2147483647");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("maxValue", true, "2147483647");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("step", true, "1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_8);
  decl->set_return<int > ();
}

static void _call_f_getInt_11114 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  int arg4 = args ? args.read<int > () : (int)(0);
  int arg5 = args ? args.read<int > () : (int)(-2147483647);
  int arg6 = args ? args.read<int > () : (int)(2147483647);
  int arg7 = args ? args.read<int > () : (int)(1);
  bool *arg8 = args ? args.read<bool * > () : (bool *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg9 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<int > ((int)QInputDialog::getInt (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg9).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getInt_11114 ()
{
  return new qt_gsi::GenericStaticMethod ("getInt", "@brief Static method int QInputDialog::getInt(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getInt_11114, &_call_f_getInt_11114);
}

// static int QInputDialog::getInteger(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getInteger_11114 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("value", true, "0");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("minValue", true, "-2147483647");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("maxValue", true, "2147483647");
  decl->add_arg<int > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("step", true, "1");
  decl->add_arg<int > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_7);
  static gsi::ArgSpecBase argspec_8 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_8);
  decl->set_return<int > ();
}

static void _call_f_getInteger_11114 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  int arg4 = args ? args.read<int > () : (int)(0);
  int arg5 = args ? args.read<int > () : (int)(-2147483647);
  int arg6 = args ? args.read<int > () : (int)(2147483647);
  int arg7 = args ? args.read<int > () : (int)(1);
  bool *arg8 = args ? args.read<bool * > () : (bool *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg9 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<int > ((int)QInputDialog::getInteger (arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg9).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getInteger_11114 ()
{
  return new qt_gsi::GenericStaticMethod ("getInteger", "@brief Static method int QInputDialog::getInteger(QWidget *parent, const QString &title, const QString &label, int value, int minValue, int maxValue, int step, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getInteger_11114, &_call_f_getInteger_11114);
}

// static QString QInputDialog::getItem(QWidget *parent, const QString &title, const QString &label, const QStringList &items, int current, bool editable, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getItem_12222 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("items");
  decl->add_arg<const qt_gsi::Converter<QStringList>::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("current", true, "0");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("editable", true, "true");
  decl->add_arg<bool > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_6);
  static gsi::ArgSpecBase argspec_7 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_7);
  decl->set_return<QString > ();
}

static void _call_f_getItem_12222 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  const qt_gsi::Converter<QStringList>::target_type & arg4 = args.read<const qt_gsi::Converter<QStringList>::target_type & > ();
  int arg5 = args ? args.read<int > () : (int)(0);
  bool arg6 = args ? args.read<bool > () : (bool)(true);
  bool *arg7 = args ? args.read<bool * > () : (bool *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg8 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QString > ((QString)QInputDialog::getItem (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QStringList>(arg4).cref(), arg5, arg6, arg7, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg8).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getItem_12222 ()
{
  return new qt_gsi::GenericStaticMethod ("getItem", "@brief Static method QString QInputDialog::getItem(QWidget *parent, const QString &title, const QString &label, const QStringList &items, int current, bool editable, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getItem_12222, &_call_f_getItem_12222);
}

// static QString QInputDialog::getText(QWidget *parent, const QString &title, const QString &label, QLineEdit::EchoMode echo, const QString &text, bool *ok, QFlags<Qt::WindowType> flags)


static void _init_f_getText_12474 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("title");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("label");
  decl->add_arg<const QString & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("echo", true, "QLineEdit::Normal");
  decl->add_arg<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("text", true, "QString()");
  decl->add_arg<const QString & > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("ok", true, "0");
  decl->add_arg<bool * > (argspec_5);
  static gsi::ArgSpecBase argspec_6 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_6);
  decl->set_return<QString > ();
}

static void _call_f_getText_12474 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  const QString &arg2 = args.read<const QString & > ();
  const QString &arg3 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QLineEdit::EchoMode>::target_type & > () : (const qt_gsi::Converter<QLineEdit::EchoMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QLineEdit::EchoMode>(heap, QLineEdit::Normal));
  const QString &arg5 = args ? args.read<const QString & > () : (const QString &)(QString());
  bool *arg6 = args ? args.read<bool * > () : (bool *)(0);
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg7 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QString > ((QString)QInputDialog::getText (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QLineEdit::EchoMode>(arg4).cref(), arg5, arg6, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg7).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_getText_12474 ()
{
  return new qt_gsi::GenericStaticMethod ("getText", "@brief Static method QString QInputDialog::getText(QWidget *parent, const QString &title, const QString &label, QLineEdit::EchoMode echo, const QString &text, bool *ok, QFlags<Qt::WindowType> flags)\nThis method is static and can be called without an instance.", &_init_f_getText_12474, &_call_f_getText_12474);
}

// static QString QInputDialog::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QInputDialog::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputDialog::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QInputDialog::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QInputDialog::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QInputDialog::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QInputDialog::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QInputDialog::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputDialog::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QInputDialog::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QInputDialog::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QInputDialog::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QInputDialog, QInputDialog_EventAdaptor> ea_QInputDialog;

namespace gsi
{
extern gsi::Class<QDialog> decl_QDialog;

gsi::Class<QInputDialog> decl_QInputDialog (ea_QInputDialog, decl_QDialog, "QInputDialog_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_cancelButtonText_c0 ()) +
  gsi::Methods(_create_f_comboBoxItems_c0 ()) +
  gsi::Methods(_create_f_done_767 ()) +
  gsi::Methods(_create_f_doubleDecimals_c0 ()) +
  gsi::Methods(_create_f_doubleMaximum_c0 ()) +
  gsi::Methods(_create_f_doubleMinimum_c0 ()) +
  gsi::Methods(_create_f_doubleValue_c0 ()) +
  gsi::Methods(_create_f_inputMode_c0 ()) +
  gsi::Methods(_create_f_intMaximum_c0 ()) +
  gsi::Methods(_create_f_intMinimum_c0 ()) +
  gsi::Methods(_create_f_intStep_c0 ()) +
  gsi::Methods(_create_f_intValue_c0 ()) +
  gsi::Methods(_create_f_isComboBoxEditable_c0 ()) +
  gsi::Methods(_create_f_labelText_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_okButtonText_c0 ()) +
  gsi::Methods(_create_f_open_0 ()) +
  gsi::Methods(_create_f_open_2925 ()) +
  gsi::Methods(_create_f_options_c0 ()) +
  gsi::Methods(_create_f_setCancelButtonText_2025 ()) +
  gsi::Methods(_create_f_setComboBoxEditable_864 ()) +
  gsi::Methods(_create_f_setComboBoxItems_2437 ()) +
  gsi::Methods(_create_f_setDoubleDecimals_767 ()) +
  gsi::Methods(_create_f_setDoubleMaximum_1071 ()) +
  gsi::Methods(_create_f_setDoubleMinimum_1071 ()) +
  gsi::Methods(_create_f_setDoubleRange_2034 ()) +
  gsi::Methods(_create_f_setDoubleValue_1071 ()) +
  gsi::Methods(_create_f_setInputMode_2670 ()) +
  gsi::Methods(_create_f_setIntMaximum_767 ()) +
  gsi::Methods(_create_f_setIntMinimum_767 ()) +
  gsi::Methods(_create_f_setIntRange_1426 ()) +
  gsi::Methods(_create_f_setIntStep_767 ()) +
  gsi::Methods(_create_f_setIntValue_767 ()) +
  gsi::Methods(_create_f_setLabelText_2025 ()) +
  gsi::Methods(_create_f_setOkButtonText_2025 ()) +
  gsi::Methods(_create_f_setOption_4262 ()) +
  gsi::Methods(_create_f_setOptions_4202 ()) +
  gsi::Methods(_create_f_setTextEchoMode_2187 ()) +
  gsi::Methods(_create_f_setTextValue_2025 ()) +
  gsi::Methods(_create_f_setVisible_864 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_testOption_c3506 ()) +
  gsi::Methods(_create_f_textEchoMode_c0 ()) +
  gsi::Methods(_create_f_textValue_c0 ()) +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor> ("accepted", &QInputDialog_EventAdaptor::accepted_e_0, "@brief Signal declaration for QInputDialog::accepted()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QInputDialog_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QInputDialog::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, QObject *> ("destroyed", &QInputDialog_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QInputDialog::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, double> ("doubleValueChanged", &QInputDialog_EventAdaptor::doubleValueChanged_e_1071, gsi::arg("value"), "@brief Signal declaration for QInputDialog::doubleValueChanged(double value)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, double> ("doubleValueSelected", &QInputDialog_EventAdaptor::doubleValueSelected_e_1071, gsi::arg("value"), "@brief Signal declaration for QInputDialog::doubleValueSelected(double value)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, int> ("finished", &QInputDialog_EventAdaptor::finished_e_767, gsi::arg("result"), "@brief Signal declaration for QInputDialog::finished(int result)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, int> ("intValueChanged", &QInputDialog_EventAdaptor::intValueChanged_e_767, gsi::arg("value"), "@brief Signal declaration for QInputDialog::intValueChanged(int value)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, int> ("intValueSelected", &QInputDialog_EventAdaptor::intValueSelected_e_767, gsi::arg("value"), "@brief Signal declaration for QInputDialog::intValueSelected(int value)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor> ("rejected", &QInputDialog_EventAdaptor::rejected_e_0, "@brief Signal declaration for QInputDialog::rejected()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, const QString &> ("textValueChanged", &QInputDialog_EventAdaptor::textValueChanged_e_2025, gsi::arg("text"), "@brief Signal declaration for QInputDialog::textValueChanged(const QString &text)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QInputDialog, QInputDialog_EventAdaptor, const QString &> ("textValueSelected", &QInputDialog_EventAdaptor::textValueSelected_e_2025, gsi::arg("text"), "@brief Signal declaration for QInputDialog::textValueSelected(const QString &text)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_getDouble_12026 ()) +
  gsi::Methods(_create_f_getInt_11114 ()) +
  gsi::Methods(_create_f_getInteger_11114 ()) +
  gsi::Methods(_create_f_getItem_12222 ()) +
  gsi::Methods(_create_f_getText_12474 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QInputDialog");
}


class QInputDialog_Adaptor : public QInputDialog, public qt_gsi::QtObjectBase
{
public:

  virtual ~QInputDialog_Adaptor();

  //  [adaptor ctor] QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QInputDialog_Adaptor() : QInputDialog()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QInputDialog_Adaptor(QWidget *parent) : QInputDialog(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)
  QInputDialog_Adaptor(QWidget *parent, QFlags<Qt::WindowType> flags) : QInputDialog(parent, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QInputDialog::adjustPosition(QWidget *)
  void fp_QInputDialog_adjustPosition_1315 (QWidget *arg1) {
    QInputDialog::adjustPosition(arg1);
  }

  //  void QInputDialog::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QInputDialog_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QInputDialog::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QInputDialog::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QInputDialog_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QInputDialog::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QInputDialog::focusNextChild()
  bool fp_QInputDialog_focusNextChild_0 () {
    return QInputDialog::focusNextChild();
  }

  //  bool QInputDialog::focusPreviousChild()
  bool fp_QInputDialog_focusPreviousChild_0 () {
    return QInputDialog::focusPreviousChild();
  }

  //  int QInputDialog::receivers(const char *signal)
  int fp_QInputDialog_receivers_c1731 (const char *signal) const {
    return QInputDialog::receivers(signal);
  }

  //  void QInputDialog::resetInputContext()
  void fp_QInputDialog_resetInputContext_0 () {
    QInputDialog::resetInputContext();
  }

  //  QObject *QInputDialog::sender()
  QObject * fp_QInputDialog_sender_c0 () const {
    return QInputDialog::sender();
  }

  //  void QInputDialog::updateMicroFocus()
  void fp_QInputDialog_updateMicroFocus_0 () {
    QInputDialog::updateMicroFocus();
  }

  //  [adaptor impl] void QInputDialog::accept()
  void cbs_accept_0_0()
  {
    QInputDialog::accept();
  }

  virtual void accept()
  {
    if (cb_accept_0_0.can_issue()) {
      cb_accept_0_0.issue<QInputDialog_Adaptor>(&QInputDialog_Adaptor::cbs_accept_0_0);
    } else {
      QInputDialog::accept();
    }
  }

  //  [adaptor impl] void QInputDialog::done(int result)
  void cbs_done_767_0(int result)
  {
    QInputDialog::done(result);
  }

  virtual void done(int result)
  {
    if (cb_done_767_0.can_issue()) {
      cb_done_767_0.issue<QInputDialog_Adaptor, int>(&QInputDialog_Adaptor::cbs_done_767_0, result);
    } else {
      QInputDialog::done(result);
    }
  }

  //  [adaptor impl] int QInputDialog::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QInputDialog::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QInputDialog_Adaptor, int, int>(&QInputDialog_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QInputDialog::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QInputDialog::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QInputDialog::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QInputDialog_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QInputDialog_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QInputDialog::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QInputDialog::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QInputDialog::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QInputDialog_Adaptor, QSize>(&QInputDialog_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QInputDialog::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QInputDialog::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QInputDialog::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QInputDialog_Adaptor, QPaintEngine *>(&QInputDialog_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QInputDialog::paintEngine();
    }
  }

  //  [adaptor impl] void QInputDialog::reject()
  void cbs_reject_0_0()
  {
    QInputDialog::reject();
  }

  virtual void reject()
  {
    if (cb_reject_0_0.can_issue()) {
      cb_reject_0_0.issue<QInputDialog_Adaptor>(&QInputDialog_Adaptor::cbs_reject_0_0);
    } else {
      QInputDialog::reject();
    }
  }

  //  [adaptor impl] void QInputDialog::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QInputDialog::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QInputDialog_Adaptor, bool>(&QInputDialog_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QInputDialog::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QInputDialog::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QInputDialog::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QInputDialog_Adaptor, QSize>(&QInputDialog_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QInputDialog::sizeHint();
    }
  }

  //  [adaptor impl] void QInputDialog::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QInputDialog::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QInputDialog_Adaptor, QActionEvent *>(&QInputDialog_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QInputDialog::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QInputDialog::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QInputDialog::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QInputDialog_Adaptor, QChildEvent *>(&QInputDialog_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QInputDialog::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QInputDialog::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QInputDialog_Adaptor, QCloseEvent *>(&QInputDialog_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QInputDialog::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QInputDialog::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QInputDialog_Adaptor, QContextMenuEvent *>(&QInputDialog_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QInputDialog::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QInputDialog::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QInputDialog::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QInputDialog_Adaptor, const char *>(&QInputDialog_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QInputDialog::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QInputDialog::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QInputDialog::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QInputDialog_Adaptor, QDragEnterEvent *>(&QInputDialog_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QInputDialog::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QInputDialog::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QInputDialog_Adaptor, QDragLeaveEvent *>(&QInputDialog_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QInputDialog::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QInputDialog::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QInputDialog_Adaptor, QDragMoveEvent *>(&QInputDialog_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QInputDialog::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QInputDialog::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QInputDialog_Adaptor, QDropEvent *>(&QInputDialog_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QInputDialog::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QInputDialog::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QInputDialog_Adaptor, bool>(&QInputDialog_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QInputDialog::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QInputDialog::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QInputDialog::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QInputDialog::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QInputDialog_Adaptor, bool, QEvent *>(&QInputDialog_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QInputDialog::event(arg1);
    }
  }

  //  [adaptor impl] bool QInputDialog::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QInputDialog::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QInputDialog_Adaptor, bool, QObject *, QEvent *>(&QInputDialog_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QInputDialog::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QInputDialog::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QInputDialog::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QInputDialog_Adaptor, QFocusEvent *>(&QInputDialog_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QInputDialog::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QInputDialog::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QInputDialog::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QInputDialog_Adaptor, bool, bool>(&QInputDialog_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QInputDialog::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QInputDialog::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QInputDialog::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QInputDialog_Adaptor, QFocusEvent *>(&QInputDialog_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QInputDialog::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QInputDialog::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QInputDialog_Adaptor, const QFont &>(&QInputDialog_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QInputDialog::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QInputDialog::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QInputDialog_Adaptor, QHideEvent *>(&QInputDialog_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QInputDialog::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QInputDialog::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QInputDialog_Adaptor, QInputMethodEvent *>(&QInputDialog_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QInputDialog::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::keyPressEvent(QKeyEvent *)
  void cbs_keyPressEvent_1514_0(QKeyEvent *arg1)
  {
    QInputDialog::keyPressEvent(arg1);
  }

  virtual void keyPressEvent(QKeyEvent *arg1)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QInputDialog_Adaptor, QKeyEvent *>(&QInputDialog_Adaptor::cbs_keyPressEvent_1514_0, arg1);
    } else {
      QInputDialog::keyPressEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QInputDialog::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QInputDialog_Adaptor, QKeyEvent *>(&QInputDialog_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QInputDialog::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::languageChange()
  void cbs_languageChange_0_0()
  {
    QInputDialog::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QInputDialog_Adaptor>(&QInputDialog_Adaptor::cbs_languageChange_0_0);
    } else {
      QInputDialog::languageChange();
    }
  }

  //  [adaptor impl] void QInputDialog::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QInputDialog::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QInputDialog_Adaptor, QEvent *>(&QInputDialog_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QInputDialog::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QInputDialog::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QInputDialog::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QInputDialog_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QInputDialog_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QInputDialog::metric(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QInputDialog::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QInputDialog::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mousePressEvent(QMouseEvent *)
  void cbs_mousePressEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mousePressEvent(arg1);
  }

  virtual void mousePressEvent(QMouseEvent *arg1)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mousePressEvent_1738_0, arg1);
    } else {
      QInputDialog::mousePressEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QInputDialog::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QInputDialog_Adaptor, QMouseEvent *>(&QInputDialog_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QInputDialog::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QInputDialog::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QInputDialog_Adaptor, QMoveEvent *>(&QInputDialog_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QInputDialog::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QInputDialog::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QInputDialog_Adaptor, QPaintEvent *>(&QInputDialog_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QInputDialog::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QInputDialog::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QInputDialog_Adaptor, const QPalette &>(&QInputDialog_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QInputDialog::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::resizeEvent(QResizeEvent *)
  void cbs_resizeEvent_1843_0(QResizeEvent *arg1)
  {
    QInputDialog::resizeEvent(arg1);
  }

  virtual void resizeEvent(QResizeEvent *arg1)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QInputDialog_Adaptor, QResizeEvent *>(&QInputDialog_Adaptor::cbs_resizeEvent_1843_0, arg1);
    } else {
      QInputDialog::resizeEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QInputDialog::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QInputDialog_Adaptor, QShowEvent *>(&QInputDialog_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QInputDialog::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QInputDialog::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QInputDialog_Adaptor, QStyle &>(&QInputDialog_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QInputDialog::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QInputDialog::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QInputDialog_Adaptor, QTabletEvent *>(&QInputDialog_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QInputDialog::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QInputDialog::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QInputDialog_Adaptor, QTimerEvent *>(&QInputDialog_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QInputDialog::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QInputDialog::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QInputDialog_Adaptor, QWheelEvent *>(&QInputDialog_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QInputDialog::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QInputDialog::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QInputDialog::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QInputDialog_Adaptor, bool>(&QInputDialog_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QInputDialog::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_accept_0_0;
  gsi::Callback cb_done_767_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_reject_0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QInputDialog_Adaptor::~QInputDialog_Adaptor() { }

//  Constructor QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags) (adaptor class)

static void _init_ctor_QInputDialog_Adaptor_3702 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > (argspec_1);
  decl->set_return_new<QInputDialog_Adaptor *> ();
}

static void _call_ctor_QInputDialog_Adaptor_3702 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::WindowType> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::WindowType> >(heap, 0));
  ret.write<QInputDialog_Adaptor *> (new QInputDialog_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<Qt::WindowType> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QInputDialog_Adaptor_3702 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QInputDialog::QInputDialog(QWidget *parent, QFlags<Qt::WindowType> flags)\nThis method creates an object of class QInputDialog.", &_init_ctor_QInputDialog_Adaptor_3702, &_call_ctor_QInputDialog_Adaptor_3702);
}

// void QInputDialog::adjustPosition(QWidget *)

static void _init_fp_adjustPosition_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_adjustPosition_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_adjustPosition_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_adjustPosition_1315 ()
{
  return new qt_gsi::GenericMethod("*adjustPosition", "@brief Method void QInputDialog::adjustPosition(QWidget *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adjustPosition_1315, &_call_fp_adjustPosition_1315);
}


// void QInputDialog::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QInputDialog::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QInputDialog::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QInputDialog::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QInputDialog::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QInputDialog::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QInputDialog::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QInputDialog::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QInputDialog::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QInputDialog::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QInputDialog::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QInputDialog::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QInputDialog::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QInputDialog_Adaptor *)cls)->fp_QInputDialog_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QInputDialog::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QInputDialog::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputDialog_Adaptor *)cls)->fp_QInputDialog_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QInputDialog::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// void QInputDialog::accept()

static void _init_cbs_accept_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_accept_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputDialog_Adaptor *)cls)->cbs_accept_0_0 ();
}

static void _set_callback_cbs_accept_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_accept_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@hide", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_accept_0_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@brief Virtual method void QInputDialog::accept()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_accept_0_0, &_call_cbs_accept_0_0, &_set_callback_cbs_accept_0_0);
}


// void QInputDialog::done(int result)

static void _init_cbs_done_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("result");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_done_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QInputDialog_Adaptor *)cls)->cbs_done_767_0 (arg1);
}

static void _set_callback_cbs_done_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_done_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("done", "@hide", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_done_767_0 ()
{
  return new qt_gsi::GenericMethod ("done", "@brief Virtual method void QInputDialog::done(int result)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_done_767_0, &_call_cbs_done_767_0, &_set_callback_cbs_done_767_0);
}


// int QInputDialog::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QInputDialog_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QInputDialog::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QInputDialog::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QInputDialog_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QInputDialog::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QInputDialog::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QInputDialog_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QInputDialog::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QInputDialog::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QInputDialog_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QInputDialog::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QInputDialog::reject()

static void _init_cbs_reject_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reject_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputDialog_Adaptor *)cls)->cbs_reject_0_0 ();
}

static void _set_callback_cbs_reject_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_reject_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@hide", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_reject_0_0 ()
{
  return new qt_gsi::GenericMethod ("reject", "@brief Virtual method void QInputDialog::reject()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reject_0_0, &_call_cbs_reject_0_0, &_set_callback_cbs_reject_0_0);
}


// void QInputDialog::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QInputDialog_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QInputDialog::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QInputDialog::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QInputDialog_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QInputDialog::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QInputDialog::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QInputDialog::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QInputDialog::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QInputDialog::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QInputDialog::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QInputDialog::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QInputDialog::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QInputDialog::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QInputDialog::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QInputDialog::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QInputDialog::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QInputDialog::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QInputDialog::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QInputDialog::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QInputDialog::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QInputDialog::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QInputDialog::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QInputDialog::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QInputDialog::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QInputDialog::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QInputDialog::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QInputDialog::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QInputDialog::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QInputDialog_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QInputDialog::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QInputDialog::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QInputDialog::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QInputDialog::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QInputDialog::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QInputDialog::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QInputDialog::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QInputDialog::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QInputDialog::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QInputDialog::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QInputDialog_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QInputDialog::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QInputDialog::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QInputDialog::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QInputDialog::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QInputDialog_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QInputDialog::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QInputDialog::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QInputDialog::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QInputDialog::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QInputDialog::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QInputDialog::keyPressEvent(QKeyEvent *)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QInputDialog::keyPressEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QInputDialog::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QInputDialog::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QInputDialog::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QInputDialog_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QInputDialog::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QInputDialog::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QInputDialog::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QInputDialog::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QInputDialog_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QInputDialog::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QInputDialog::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QInputDialog::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QInputDialog::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QInputDialog::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QInputDialog::mousePressEvent(QMouseEvent *)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QInputDialog::mousePressEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QInputDialog::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QInputDialog::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QInputDialog::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QInputDialog::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QInputDialog::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QInputDialog::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QInputDialog::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QInputDialog_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QInputDialog::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QInputDialog::resizeEvent(QResizeEvent *)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QInputDialog::resizeEvent(QResizeEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QInputDialog::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QInputDialog::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QInputDialog::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QInputDialog_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QInputDialog::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QInputDialog::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QInputDialog::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QInputDialog::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QInputDialog::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QInputDialog::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QInputDialog_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QInputDialog::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QInputDialog::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QInputDialog_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QInputDialog_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QInputDialog::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QInputDialog> decl_QInputDialog;

gsi::Class<QInputDialog_Adaptor> decl_QInputDialog_Adaptor (decl_QInputDialog, "QInputDialog",
  gsi::Methods(_create_fp_adjustPosition_1315 ()) +
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_accept_0_0 ()) +
  gsi::Methods(_create_callback_cbs_accept_0_0 ()) +
  gsi::Methods(_create_cbs_done_767_0 ()) +
  gsi::Methods(_create_callback_cbs_done_767_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_reject_0_0 ()) +
  gsi::Methods(_create_callback_cbs_reject_0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QInputDialog_Adaptor_3702 ()),
  "@qt\n@brief Binding of QInputDialog");

}


//  Implementation of the enum wrapper class for QInputDialog::InputDialogOption
namespace qt_gsi
{

static QInputDialog_InputDialogOption_Enum *c_1_QInputDialog_InputDialogOption_Enum () { return new QInputDialog_InputDialogOption_Enum (QInputDialog::NoButtons); }
static QInputDialog_InputDialogOption_Enum *c_2_QInputDialog_InputDialogOption_Enum () { return new QInputDialog_InputDialogOption_Enum (QInputDialog::UseListViewForComboBoxItems); }

static gsi::Methods mkdefs_QInputDialog_InputDialogOption () {
  return
    gsi::constant ("NoButtons", &qt_gsi::c_1_QInputDialog_InputDialogOption_Enum, "@brief Enum constant QInputDialog::NoButtons") +
    gsi::constant ("UseListViewForComboBoxItems", &qt_gsi::c_2_QInputDialog_InputDialogOption_Enum, "@brief Enum constant QInputDialog::UseListViewForComboBoxItems");
}

static std::string to_s_QInputDialog_InputDialogOption_Enum (const QInputDialog_InputDialogOption_Enum *e)
{
  if (e->value () == QInputDialog::NoButtons) { return tl::sprintf ("NoButtons (%u)", (unsigned int) e->value ()); }
  if (e->value () == QInputDialog::UseListViewForComboBoxItems) { return tl::sprintf ("UseListViewForComboBoxItems (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QInputDialog_InputDialogOption_Enum (const QInputDialog_InputDialogOption_Enum *e)
{
  return (unsigned int) e->value ();
}

static QInputDialog_InputDialogOption_Enum *from_i_QInputDialog_InputDialogOption_Enum (unsigned int i)
{
  return new QInputDialog_InputDialogOption_Enum ((QInputDialog::InputDialogOption) i);
}

static bool equalQInputDialog_InputDialogOption_Enum (const QInputDialog_InputDialogOption_Enum *e, QInputDialog_InputDialogOption_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QInputDialog_InputDialogOption_Enum (const QInputDialog_InputDialogOption_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QInputDialog_InputDialogOption_Enums oropQInputDialog_InputDialogOption_Enums (const QInputDialog_InputDialogOption_Enums *e, const QInputDialog_InputDialogOption_Enums &d)
{
  return e->flags () | d.flags ();
}

static QInputDialog_InputDialogOption_Enums andopQInputDialog_InputDialogOption_Enums (const QInputDialog_InputDialogOption_Enums *e, const QInputDialog_InputDialogOption_Enums &d)
{
  return e->flags () & d.flags ();
}

static QInputDialog_InputDialogOption_Enums xoropQInputDialog_InputDialogOption_Enums (const QInputDialog_InputDialogOption_Enums *e, const QInputDialog_InputDialogOption_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QInputDialog_InputDialogOption_Enums (const QInputDialog_InputDialogOption_Enums *e)
{
  std::string l;
  if (e->testFlag (QInputDialog::NoButtons)) { if (!l.empty ()) l += "|"; l += "NoButtons"; }
  if (e->testFlag (QInputDialog::UseListViewForComboBoxItems)) { if (!l.empty ()) l += "|"; l += "UseListViewForComboBoxItems"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QInputDialog_InputDialogOption_Enums (const QInputDialog_InputDialogOption_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QInputDialog_InputDialogOption_Enums (const QInputDialog_InputDialogOption_Enums *e, const QInputDialog_InputDialogOption_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QInputDialog_InputDialogOption_Enums> decl_QInputDialog_InputDialogOption_Enums ("QInputDialog_QFlags_InputDialogOption",
  gsi::method_ext ("|", &qt_gsi::oropQInputDialog_InputDialogOption_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQInputDialog_InputDialogOption_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQInputDialog_InputDialogOption_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QInputDialog_InputDialogOption_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QInputDialog_InputDialogOption_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QInputDialog_InputDialogOption_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QInputDialog::InputDialogOption> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QInputDialog_InputDialogOption_Enum> decl_QInputDialog_InputDialogOption_Enum (decl_QInputDialog_InputDialogOption_Enums, "QInputDialog_InputDialogOption",
  qt_gsi::mkdefs_QInputDialog_InputDialogOption () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QInputDialog_InputDialogOption_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QInputDialog_InputDialogOption_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQInputDialog_InputDialogOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QInputDialog_InputDialogOption_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QInputDialog_InputDialogOption_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QInputDialog::InputDialogOption enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QInputDialog> inject_QInputDialog_InputDialogOption_Enum_in_parent (qt_gsi::mkdefs_QInputDialog_InputDialogOption ());
static gsi::ClassExt<QInputDialog> decl_QInputDialog_InputDialogOption_Enum_as_child (decl_QInputDialog_InputDialogOption_Enum, "InputDialogOption");

}


//  Implementation of the enum wrapper class for QInputDialog::InputMode
namespace qt_gsi
{

static QInputDialog_InputMode_Enum *c_1_QInputDialog_InputMode_Enum () { return new QInputDialog_InputMode_Enum (QInputDialog::TextInput); }
static QInputDialog_InputMode_Enum *c_2_QInputDialog_InputMode_Enum () { return new QInputDialog_InputMode_Enum (QInputDialog::IntInput); }
static QInputDialog_InputMode_Enum *c_3_QInputDialog_InputMode_Enum () { return new QInputDialog_InputMode_Enum (QInputDialog::DoubleInput); }

static gsi::Methods mkdefs_QInputDialog_InputMode () {
  return
    gsi::constant ("TextInput", &qt_gsi::c_1_QInputDialog_InputMode_Enum, "@brief Enum constant QInputDialog::TextInput") +
    gsi::constant ("IntInput", &qt_gsi::c_2_QInputDialog_InputMode_Enum, "@brief Enum constant QInputDialog::IntInput") +
    gsi::constant ("DoubleInput", &qt_gsi::c_3_QInputDialog_InputMode_Enum, "@brief Enum constant QInputDialog::DoubleInput");
}

static std::string to_s_QInputDialog_InputMode_Enum (const QInputDialog_InputMode_Enum *e)
{
  if (e->value () == QInputDialog::TextInput) { return tl::sprintf ("TextInput (%u)", (unsigned int) e->value ()); }
  if (e->value () == QInputDialog::IntInput) { return tl::sprintf ("IntInput (%u)", (unsigned int) e->value ()); }
  if (e->value () == QInputDialog::DoubleInput) { return tl::sprintf ("DoubleInput (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QInputDialog_InputMode_Enum (const QInputDialog_InputMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QInputDialog_InputMode_Enum *from_i_QInputDialog_InputMode_Enum (unsigned int i)
{
  return new QInputDialog_InputMode_Enum ((QInputDialog::InputMode) i);
}

static bool equalQInputDialog_InputMode_Enum (const QInputDialog_InputMode_Enum *e, QInputDialog_InputMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QInputDialog_InputMode_Enum (const QInputDialog_InputMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QInputDialog_InputMode_Enums oropQInputDialog_InputMode_Enums (const QInputDialog_InputMode_Enums *e, const QInputDialog_InputMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QInputDialog_InputMode_Enums andopQInputDialog_InputMode_Enums (const QInputDialog_InputMode_Enums *e, const QInputDialog_InputMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QInputDialog_InputMode_Enums xoropQInputDialog_InputMode_Enums (const QInputDialog_InputMode_Enums *e, const QInputDialog_InputMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QInputDialog_InputMode_Enums (const QInputDialog_InputMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QInputDialog::TextInput)) { if (!l.empty ()) l += "|"; l += "TextInput"; }
  if (e->testFlag (QInputDialog::IntInput)) { if (!l.empty ()) l += "|"; l += "IntInput"; }
  if (e->testFlag (QInputDialog::DoubleInput)) { if (!l.empty ()) l += "|"; l += "DoubleInput"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QInputDialog_InputMode_Enums (const QInputDialog_InputMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QInputDialog_InputMode_Enums (const QInputDialog_InputMode_Enums *e, const QInputDialog_InputMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QInputDialog_InputMode_Enums> decl_QInputDialog_InputMode_Enums ("QInputDialog_QFlags_InputMode",
  gsi::method_ext ("|", &qt_gsi::oropQInputDialog_InputMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQInputDialog_InputMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQInputDialog_InputMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QInputDialog_InputMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QInputDialog_InputMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QInputDialog_InputMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QInputDialog::InputMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QInputDialog_InputMode_Enum> decl_QInputDialog_InputMode_Enum (decl_QInputDialog_InputMode_Enums, "QInputDialog_InputMode",
  qt_gsi::mkdefs_QInputDialog_InputMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QInputDialog_InputMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QInputDialog_InputMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQInputDialog_InputMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QInputDialog_InputMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QInputDialog_InputMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QInputDialog::InputMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QInputDialog> inject_QInputDialog_InputMode_Enum_in_parent (qt_gsi::mkdefs_QInputDialog_InputMode ());
static gsi::ClassExt<QInputDialog> decl_QInputDialog_InputMode_Enum_as_child (decl_QInputDialog_InputMode_Enum, "InputMode");

}

