
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsView.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsView_EventAdaptor.h"
#include "gsiDeclQGraphicsView_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsView

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsView::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QFlags<Qt::AlignmentFlag> QGraphicsView::alignment()


static void _init_f_alignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ();
}

static void _call_f_alignment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::AlignmentFlag> >(((QGraphicsView *)cls)->alignment ()));
}

static qt_gsi::GenericMethod *_create_f_alignment_c0 ()
{
  return new qt_gsi::GenericMethod (":alignment", "@brief Method QFlags<Qt::AlignmentFlag> QGraphicsView::alignment()\n", true, &_init_f_alignment_c0, &_call_f_alignment_c0);
}

// QBrush QGraphicsView::backgroundBrush()


static void _init_f_backgroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_backgroundBrush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QGraphicsView *)cls)->backgroundBrush ());
}

static qt_gsi::GenericMethod *_create_f_backgroundBrush_c0 ()
{
  return new qt_gsi::GenericMethod (":backgroundBrush", "@brief Method QBrush QGraphicsView::backgroundBrush()\n", true, &_init_f_backgroundBrush_c0, &_call_f_backgroundBrush_c0);
}

// QFlags<QGraphicsView::CacheModeFlag> QGraphicsView::cacheMode()


static void _init_f_cacheMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QGraphicsView::CacheModeFlag> >::target_type > ();
}

static void _call_f_cacheMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QGraphicsView::CacheModeFlag> >::target_type > ((qt_gsi::Converter<QFlags<QGraphicsView::CacheModeFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QGraphicsView::CacheModeFlag> >(((QGraphicsView *)cls)->cacheMode ()));
}

static qt_gsi::GenericMethod *_create_f_cacheMode_c0 ()
{
  return new qt_gsi::GenericMethod (":cacheMode", "@brief Method QFlags<QGraphicsView::CacheModeFlag> QGraphicsView::cacheMode()\n", true, &_init_f_cacheMode_c0, &_call_f_cacheMode_c0);
}

// void QGraphicsView::centerOn(const QPointF &pos)


static void _init_f_centerOn_1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_centerOn_1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ((QGraphicsView *)cls)->centerOn (arg1);
}

static qt_gsi::GenericMethod *_create_f_centerOn_1986 ()
{
  return new qt_gsi::GenericMethod ("centerOn", "@brief Method void QGraphicsView::centerOn(const QPointF &pos)\n", false, &_init_f_centerOn_1986, &_call_f_centerOn_1986);
}

// void QGraphicsView::centerOn(double x, double y)


static void _init_f_centerOn_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_centerOn_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsView *)cls)->centerOn (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_centerOn_2034 ()
{
  return new qt_gsi::GenericMethod ("centerOn", "@brief Method void QGraphicsView::centerOn(double x, double y)\n", false, &_init_f_centerOn_2034, &_call_f_centerOn_2034);
}

// void QGraphicsView::centerOn(const QGraphicsItem *item)


static void _init_f_centerOn_2614 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_centerOn_2614 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  ((QGraphicsView *)cls)->centerOn (arg1);
}

static qt_gsi::GenericMethod *_create_f_centerOn_2614 ()
{
  return new qt_gsi::GenericMethod ("centerOn", "@brief Method void QGraphicsView::centerOn(const QGraphicsItem *item)\n", false, &_init_f_centerOn_2614, &_call_f_centerOn_2614);
}

// QGraphicsView::DragMode QGraphicsView::dragMode()


static void _init_f_dragMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::DragMode>::target_type > ();
}

static void _call_f_dragMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsView::DragMode>::target_type > ((qt_gsi::Converter<QGraphicsView::DragMode>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::DragMode>(((QGraphicsView *)cls)->dragMode ()));
}

static qt_gsi::GenericMethod *_create_f_dragMode_c0 ()
{
  return new qt_gsi::GenericMethod (":dragMode", "@brief Method QGraphicsView::DragMode QGraphicsView::dragMode()\n", true, &_init_f_dragMode_c0, &_call_f_dragMode_c0);
}

// void QGraphicsView::ensureVisible(const QRectF &rect, int xmargin, int ymargin)


static void _init_f_ensureVisible_3180 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3180 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  int arg2 = args ? args.read<int > () : (int)(50);
  int arg3 = args ? args.read<int > () : (int)(50);
  ((QGraphicsView *)cls)->ensureVisible (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_ensureVisible_3180 ()
{
  return new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsView::ensureVisible(const QRectF &rect, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_3180, &_call_f_ensureVisible_3180);
}

// void QGraphicsView::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)


static void _init_f_ensureVisible_5278 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_4);
  static gsi::ArgSpecBase argspec_5 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_5);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_5278 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  int arg5 = args ? args.read<int > () : (int)(50);
  int arg6 = args ? args.read<int > () : (int)(50);
  ((QGraphicsView *)cls)->ensureVisible (arg1, arg2, arg3, arg4, arg5, arg6);
}

static qt_gsi::GenericMethod *_create_f_ensureVisible_5278 ()
{
  return new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsView::ensureVisible(double x, double y, double w, double h, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_5278, &_call_f_ensureVisible_5278);
}

// void QGraphicsView::ensureVisible(const QGraphicsItem *item, int xmargin, int ymargin)


static void _init_f_ensureVisible_3932 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("xmargin", true, "50");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("ymargin", true, "50");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_ensureVisible_3932 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  int arg2 = args ? args.read<int > () : (int)(50);
  int arg3 = args ? args.read<int > () : (int)(50);
  ((QGraphicsView *)cls)->ensureVisible (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_ensureVisible_3932 ()
{
  return new qt_gsi::GenericMethod ("ensureVisible", "@brief Method void QGraphicsView::ensureVisible(const QGraphicsItem *item, int xmargin, int ymargin)\n", false, &_init_f_ensureVisible_3932, &_call_f_ensureVisible_3932);
}

// void QGraphicsView::fitInView(const QRectF &rect, Qt::AspectRatioMode aspectRadioMode)


static void _init_f_fitInView_4011 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectRadioMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fitInView_4011 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  ((QGraphicsView *)cls)->fitInView (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_fitInView_4011 ()
{
  return new qt_gsi::GenericMethod ("fitInView", "@brief Method void QGraphicsView::fitInView(const QRectF &rect, Qt::AspectRatioMode aspectRadioMode)\n", false, &_init_f_fitInView_4011, &_call_f_fitInView_4011);
}

// void QGraphicsView::fitInView(double x, double y, double w, double h, Qt::AspectRatioMode aspectRadioMode)


static void _init_f_fitInView_6109 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("aspectRadioMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_4);
  decl->set_return<void > ();
}

static void _call_f_fitInView_6109 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  ((QGraphicsView *)cls)->fitInView (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg5).cref());
}

static qt_gsi::GenericMethod *_create_f_fitInView_6109 ()
{
  return new qt_gsi::GenericMethod ("fitInView", "@brief Method void QGraphicsView::fitInView(double x, double y, double w, double h, Qt::AspectRatioMode aspectRadioMode)\n", false, &_init_f_fitInView_6109, &_call_f_fitInView_6109);
}

// void QGraphicsView::fitInView(const QGraphicsItem *item, Qt::AspectRatioMode aspectRadioMode)


static void _init_f_fitInView_4763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<const QGraphicsItem * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("aspectRadioMode", true, "Qt::IgnoreAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_fitInView_4763 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QGraphicsItem *arg1 = args.read<const QGraphicsItem * > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::IgnoreAspectRatio));
  ((QGraphicsView *)cls)->fitInView (arg1, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_fitInView_4763 ()
{
  return new qt_gsi::GenericMethod ("fitInView", "@brief Method void QGraphicsView::fitInView(const QGraphicsItem *item, Qt::AspectRatioMode aspectRadioMode)\n", false, &_init_f_fitInView_4763, &_call_f_fitInView_4763);
}

// QBrush QGraphicsView::foregroundBrush()


static void _init_f_foregroundBrush_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_foregroundBrush_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QGraphicsView *)cls)->foregroundBrush ());
}

static qt_gsi::GenericMethod *_create_f_foregroundBrush_c0 ()
{
  return new qt_gsi::GenericMethod (":foregroundBrush", "@brief Method QBrush QGraphicsView::foregroundBrush()\n", true, &_init_f_foregroundBrush_c0, &_call_f_foregroundBrush_c0);
}

// QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)


static void _init_f_inputMethodQuery_c2420 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_f_inputMethodQuery_c2420 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsView *)cls)->inputMethodQuery (qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_inputMethodQuery_c2420 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Method QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)\nThis is a reimplementation of QWidget::inputMethodQuery", true, &_init_f_inputMethodQuery_c2420, &_call_f_inputMethodQuery_c2420);
}

// void QGraphicsView::invalidateScene(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)


static void _init_f_invalidateScene_5397 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layers", true, "QGraphicsScene::AllLayers");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_invalidateScene_5397 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & arg2 = args ? args.read<const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type & > () : (const qt_gsi::Converter<QFlags<QGraphicsScene::SceneLayer> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<QGraphicsScene::SceneLayer> >(heap, QGraphicsScene::AllLayers));
  ((QGraphicsView *)cls)->invalidateScene (arg1, qt_gsi::QtToCppAdaptor<QFlags<QGraphicsScene::SceneLayer> >(arg2).cref());
}

static qt_gsi::GenericMethod *_create_f_invalidateScene_5397 ()
{
  return new qt_gsi::GenericMethod ("invalidateScene", "@brief Method void QGraphicsView::invalidateScene(const QRectF &rect, QFlags<QGraphicsScene::SceneLayer> layers)\n", false, &_init_f_invalidateScene_5397, &_call_f_invalidateScene_5397);
}

// bool QGraphicsView::isInteractive()


static void _init_f_isInteractive_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isInteractive_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsView *)cls)->isInteractive ());
}

static qt_gsi::GenericMethod *_create_f_isInteractive_c0 ()
{
  return new qt_gsi::GenericMethod ("isInteractive?|:interactive", "@brief Method bool QGraphicsView::isInteractive()\n", true, &_init_f_isInteractive_c0, &_call_f_isInteractive_c0);
}

// bool QGraphicsView::isTransformed()


static void _init_f_isTransformed_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isTransformed_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsView *)cls)->isTransformed ());
}

static qt_gsi::GenericMethod *_create_f_isTransformed_c0 ()
{
  return new qt_gsi::GenericMethod ("isTransformed?", "@brief Method bool QGraphicsView::isTransformed()\n", true, &_init_f_isTransformed_c0, &_call_f_isTransformed_c0);
}

// QGraphicsItem *QGraphicsView::itemAt(const QPoint &pos)


static void _init_f_itemAt_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsView *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1916 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsView::itemAt(const QPoint &pos)\n", true, &_init_f_itemAt_c1916, &_call_f_itemAt_c1916);
}

// QGraphicsItem *QGraphicsView::itemAt(int x, int y)


static void _init_f_itemAt_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QGraphicsItem * > ();
}

static void _call_f_itemAt_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QGraphicsItem * > ((QGraphicsItem *)((QGraphicsView *)cls)->itemAt (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c1426 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QGraphicsItem *QGraphicsView::itemAt(int x, int y)\n", true, &_init_f_itemAt_c1426, &_call_f_itemAt_c1426);
}

// QList<QGraphicsItem *> QGraphicsView::items()


static void _init_f_items_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items ()));
}

static qt_gsi::GenericMethod *_create_f_items_c0 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items()\n", true, &_init_f_items_c0, &_call_f_items_c0);
}

// QList<QGraphicsItem *> QGraphicsView::items(const QPoint &pos)


static void _init_f_items_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pos");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items (arg1)));
}

static qt_gsi::GenericMethod *_create_f_items_c1916 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QPoint &pos)\n", true, &_init_f_items_c1916, &_call_f_items_c1916);
}

// QList<QGraphicsItem *> QGraphicsView::items(int x, int y)


static void _init_f_items_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items (arg1, arg2)));
}

static qt_gsi::GenericMethod *_create_f_items_c1426 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(int x, int y)\n", true, &_init_f_items_c1426, &_call_f_items_c1426);
}

// QList<QGraphicsItem *> QGraphicsView::items(const QRect &rect, Qt::ItemSelectionMode mode)


static void _init_f_items_c4155 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c4155 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c4155 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QRect &rect, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4155, &_call_f_items_c4155);
}

// QList<QGraphicsItem *> QGraphicsView::items(int x, int y, int w, int h, Qt::ItemSelectionMode mode)


static void _init_f_items_c5107 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c5107 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg5 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items (arg1, arg2, arg3, arg4, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg5).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c5107 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(int x, int y, int w, int h, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c5107, &_call_f_items_c5107);
}

// QList<QGraphicsItem *> QGraphicsView::items(const QPolygon &polygon, Qt::ItemSelectionMode mode)


static void _init_f_items_c4501 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c4501 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c4501 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QPolygon &polygon, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4501, &_call_f_items_c4501);
}

// QList<QGraphicsItem *> QGraphicsView::items(const QPainterPath &path, Qt::ItemSelectionMode mode)


static void _init_f_items_c4877 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("mode", true, "Qt::IntersectsItemShape");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_1);
  decl->set_return<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ();
}

static void _call_f_items_c4877 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  tl::Heap heap;
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg2 = args ? args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > () : (const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::ItemSelectionMode>(heap, Qt::IntersectsItemShape));
  ret.write<qt_gsi::Converter<QList<QGraphicsItem *> >::target_type > ((qt_gsi::Converter<QList<QGraphicsItem *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QGraphicsItem *> >(((QGraphicsView *)cls)->items (arg1, qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg2).cref())));
}

static qt_gsi::GenericMethod *_create_f_items_c4877 ()
{
  return new qt_gsi::GenericMethod ("items", "@brief Method QList<QGraphicsItem *> QGraphicsView::items(const QPainterPath &path, Qt::ItemSelectionMode mode)\n", true, &_init_f_items_c4877, &_call_f_items_c4877);
}

// QPoint QGraphicsView::mapFromScene(const QPointF &point)


static void _init_f_mapFromScene_c1986 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPointF & > (argspec_0);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromScene_c1986 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPointF &arg1 = args.read<const QPointF & > ();
  ret.write<QPoint > ((QPoint)((QGraphicsView *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c1986 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPoint QGraphicsView::mapFromScene(const QPointF &point)\n", true, &_init_f_mapFromScene_c1986, &_call_f_mapFromScene_c1986);
}

// QPolygon QGraphicsView::mapFromScene(const QRectF &rect)


static void _init_f_mapFromScene_c1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapFromScene_c1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QPolygon > ((QPolygon)((QGraphicsView *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c1862 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygon QGraphicsView::mapFromScene(const QRectF &rect)\n", true, &_init_f_mapFromScene_c1862, &_call_f_mapFromScene_c1862);
}

// QPolygon QGraphicsView::mapFromScene(const QPolygonF &polygon)


static void _init_f_mapFromScene_c2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygonF & > (argspec_0);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapFromScene_c2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygonF &arg1 = args.read<const QPolygonF & > ();
  ret.write<QPolygon > ((QPolygon)((QGraphicsView *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c2208 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygon QGraphicsView::mapFromScene(const QPolygonF &polygon)\n", true, &_init_f_mapFromScene_c2208, &_call_f_mapFromScene_c2208);
}

// QPainterPath QGraphicsView::mapFromScene(const QPainterPath &path)


static void _init_f_mapFromScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapFromScene_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsView *)cls)->mapFromScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c2514 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPainterPath QGraphicsView::mapFromScene(const QPainterPath &path)\n", true, &_init_f_mapFromScene_c2514, &_call_f_mapFromScene_c2514);
}

// QPoint QGraphicsView::mapFromScene(double x, double y)


static void _init_f_mapFromScene_c2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  decl->set_return<QPoint > ();
}

static void _call_f_mapFromScene_c2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ret.write<QPoint > ((QPoint)((QGraphicsView *)cls)->mapFromScene (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c2034 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPoint QGraphicsView::mapFromScene(double x, double y)\n", true, &_init_f_mapFromScene_c2034, &_call_f_mapFromScene_c2034);
}

// QPolygon QGraphicsView::mapFromScene(double x, double y, double w, double h)


static void _init_f_mapFromScene_c3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<QPolygon > ();
}

static void _call_f_mapFromScene_c3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ret.write<QPolygon > ((QPolygon)((QGraphicsView *)cls)->mapFromScene (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapFromScene_c3960 ()
{
  return new qt_gsi::GenericMethod ("mapFromScene", "@brief Method QPolygon QGraphicsView::mapFromScene(double x, double y, double w, double h)\n", true, &_init_f_mapFromScene_c3960, &_call_f_mapFromScene_c3960);
}

// QPointF QGraphicsView::mapToScene(const QPoint &point)


static void _init_f_mapToScene_c1916 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("point");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c1916 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QPointF > ((QPointF)((QGraphicsView *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c1916 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsView::mapToScene(const QPoint &point)\n", true, &_init_f_mapToScene_c1916, &_call_f_mapToScene_c1916);
}

// QPolygonF QGraphicsView::mapToScene(const QRect &rect)


static void _init_f_mapToScene_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsView *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c1792 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsView::mapToScene(const QRect &rect)\n", true, &_init_f_mapToScene_c1792, &_call_f_mapToScene_c1792);
}

// QPolygonF QGraphicsView::mapToScene(const QPolygon &polygon)


static void _init_f_mapToScene_c2138 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("polygon");
  decl->add_arg<const QPolygon & > (argspec_0);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c2138 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPolygon &arg1 = args.read<const QPolygon & > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsView *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c2138 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsView::mapToScene(const QPolygon &polygon)\n", true, &_init_f_mapToScene_c2138, &_call_f_mapToScene_c2138);
}

// QPainterPath QGraphicsView::mapToScene(const QPainterPath &path)


static void _init_f_mapToScene_c2514 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("path");
  decl->add_arg<const QPainterPath & > (argspec_0);
  decl->set_return<QPainterPath > ();
}

static void _call_f_mapToScene_c2514 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPainterPath &arg1 = args.read<const QPainterPath & > ();
  ret.write<QPainterPath > ((QPainterPath)((QGraphicsView *)cls)->mapToScene (arg1));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c2514 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPainterPath QGraphicsView::mapToScene(const QPainterPath &path)\n", true, &_init_f_mapToScene_c2514, &_call_f_mapToScene_c2514);
}

// QPointF QGraphicsView::mapToScene(int x, int y)


static void _init_f_mapToScene_c1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QPointF > ();
}

static void _call_f_mapToScene_c1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QPointF > ((QPointF)((QGraphicsView *)cls)->mapToScene (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c1426 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPointF QGraphicsView::mapToScene(int x, int y)\n", true, &_init_f_mapToScene_c1426, &_call_f_mapToScene_c1426);
}

// QPolygonF QGraphicsView::mapToScene(int x, int y, int w, int h)


static void _init_f_mapToScene_c2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<int > (argspec_3);
  decl->set_return<QPolygonF > ();
}

static void _call_f_mapToScene_c2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ret.write<QPolygonF > ((QPolygonF)((QGraphicsView *)cls)->mapToScene (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod *_create_f_mapToScene_c2744 ()
{
  return new qt_gsi::GenericMethod ("mapToScene", "@brief Method QPolygonF QGraphicsView::mapToScene(int x, int y, int w, int h)\n", true, &_init_f_mapToScene_c2744, &_call_f_mapToScene_c2744);
}

// QMatrix QGraphicsView::matrix()


static void _init_f_matrix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QMatrix > ();
}

static void _call_f_matrix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QMatrix > ((QMatrix)((QGraphicsView *)cls)->matrix ());
}

static qt_gsi::GenericMethod *_create_f_matrix_c0 ()
{
  return new qt_gsi::GenericMethod (":matrix", "@brief Method QMatrix QGraphicsView::matrix()\n", true, &_init_f_matrix_c0, &_call_f_matrix_c0);
}

// QFlags<QGraphicsView::OptimizationFlag> QGraphicsView::optimizationFlags()


static void _init_f_optimizationFlags_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QGraphicsView::OptimizationFlag> >::target_type > ();
}

static void _call_f_optimizationFlags_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QGraphicsView::OptimizationFlag> >::target_type > ((qt_gsi::Converter<QFlags<QGraphicsView::OptimizationFlag> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QGraphicsView::OptimizationFlag> >(((QGraphicsView *)cls)->optimizationFlags ()));
}

static qt_gsi::GenericMethod *_create_f_optimizationFlags_c0 ()
{
  return new qt_gsi::GenericMethod (":optimizationFlags", "@brief Method QFlags<QGraphicsView::OptimizationFlag> QGraphicsView::optimizationFlags()\n", true, &_init_f_optimizationFlags_c0, &_call_f_optimizationFlags_c0);
}

// void QGraphicsView::render(QPainter *painter, const QRectF &target, const QRect &source, Qt::AspectRatioMode aspectRatioMode)


static void _init_f_render_7013 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("target", true, "QRectF()");
  decl->add_arg<const QRectF & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("source", true, "QRect()");
  decl->add_arg<const QRect & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("aspectRatioMode", true, "Qt::KeepAspectRatio");
  decl->add_arg<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_render_7013 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args ? args.read<const QRectF & > () : (const QRectF &)(QRectF());
  const QRect &arg3 = args ? args.read<const QRect & > () : (const QRect &)(QRect());
  tl::Heap heap;
  const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & arg4 = args ? args.read<const qt_gsi::Converter<Qt::AspectRatioMode>::target_type & > () : (const qt_gsi::Converter<Qt::AspectRatioMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::AspectRatioMode>(heap, Qt::KeepAspectRatio));
  ((QGraphicsView *)cls)->render (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<Qt::AspectRatioMode>(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_render_7013 ()
{
  return new qt_gsi::GenericMethod ("render", "@brief Method void QGraphicsView::render(QPainter *painter, const QRectF &target, const QRect &source, Qt::AspectRatioMode aspectRatioMode)\n", false, &_init_f_render_7013, &_call_f_render_7013);
}

// QFlags<QPainter::RenderHint> QGraphicsView::renderHints()


static void _init_f_renderHints_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type > ();
}

static void _call_f_renderHints_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type > ((qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<QPainter::RenderHint> >(((QGraphicsView *)cls)->renderHints ()));
}

static qt_gsi::GenericMethod *_create_f_renderHints_c0 ()
{
  return new qt_gsi::GenericMethod (":renderHints", "@brief Method QFlags<QPainter::RenderHint> QGraphicsView::renderHints()\n", true, &_init_f_renderHints_c0, &_call_f_renderHints_c0);
}

// void QGraphicsView::resetCachedContent()


static void _init_f_resetCachedContent_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetCachedContent_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsView *)cls)->resetCachedContent ();
}

static qt_gsi::GenericMethod *_create_f_resetCachedContent_0 ()
{
  return new qt_gsi::GenericMethod ("resetCachedContent", "@brief Method void QGraphicsView::resetCachedContent()\n", false, &_init_f_resetCachedContent_0, &_call_f_resetCachedContent_0);
}

// void QGraphicsView::resetMatrix()


static void _init_f_resetMatrix_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetMatrix_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsView *)cls)->resetMatrix ();
}

static qt_gsi::GenericMethod *_create_f_resetMatrix_0 ()
{
  return new qt_gsi::GenericMethod ("resetMatrix", "@brief Method void QGraphicsView::resetMatrix()\n", false, &_init_f_resetMatrix_0, &_call_f_resetMatrix_0);
}

// void QGraphicsView::resetTransform()


static void _init_f_resetTransform_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetTransform_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsView *)cls)->resetTransform ();
}

static qt_gsi::GenericMethod *_create_f_resetTransform_0 ()
{
  return new qt_gsi::GenericMethod ("resetTransform", "@brief Method void QGraphicsView::resetTransform()\n", false, &_init_f_resetTransform_0, &_call_f_resetTransform_0);
}

// QGraphicsView::ViewportAnchor QGraphicsView::resizeAnchor()


static void _init_f_resizeAnchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ();
}

static void _call_f_resizeAnchor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ((qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::ViewportAnchor>(((QGraphicsView *)cls)->resizeAnchor ()));
}

static qt_gsi::GenericMethod *_create_f_resizeAnchor_c0 ()
{
  return new qt_gsi::GenericMethod (":resizeAnchor", "@brief Method QGraphicsView::ViewportAnchor QGraphicsView::resizeAnchor()\n", true, &_init_f_resizeAnchor_c0, &_call_f_resizeAnchor_c0);
}

// void QGraphicsView::rotate(double angle)


static void _init_f_rotate_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("angle");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_rotate_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsView *)cls)->rotate (arg1);
}

static qt_gsi::GenericMethod *_create_f_rotate_1071 ()
{
  return new qt_gsi::GenericMethod ("rotate", "@brief Method void QGraphicsView::rotate(double angle)\n", false, &_init_f_rotate_1071, &_call_f_rotate_1071);
}

// Qt::ItemSelectionMode QGraphicsView::rubberBandSelectionMode()


static void _init_f_rubberBandSelectionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::ItemSelectionMode>::target_type > ();
}

static void _call_f_rubberBandSelectionMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::ItemSelectionMode>::target_type > ((qt_gsi::Converter<Qt::ItemSelectionMode>::target_type)qt_gsi::CppToQtAdaptor<Qt::ItemSelectionMode>(((QGraphicsView *)cls)->rubberBandSelectionMode ()));
}

static qt_gsi::GenericMethod *_create_f_rubberBandSelectionMode_c0 ()
{
  return new qt_gsi::GenericMethod (":rubberBandSelectionMode", "@brief Method Qt::ItemSelectionMode QGraphicsView::rubberBandSelectionMode()\n", true, &_init_f_rubberBandSelectionMode_c0, &_call_f_rubberBandSelectionMode_c0);
}

// void QGraphicsView::scale(double sx, double sy)


static void _init_f_scale_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_scale_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsView *)cls)->scale (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_scale_2034 ()
{
  return new qt_gsi::GenericMethod ("scale", "@brief Method void QGraphicsView::scale(double sx, double sy)\n", false, &_init_f_scale_2034, &_call_f_scale_2034);
}

// QGraphicsScene *QGraphicsView::scene()


static void _init_f_scene_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QGraphicsScene * > ();
}

static void _call_f_scene_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QGraphicsScene * > ((QGraphicsScene *)((QGraphicsView *)cls)->scene ());
}

static qt_gsi::GenericMethod *_create_f_scene_c0 ()
{
  return new qt_gsi::GenericMethod (":scene", "@brief Method QGraphicsScene *QGraphicsView::scene()\n", true, &_init_f_scene_c0, &_call_f_scene_c0);
}

// QRectF QGraphicsView::sceneRect()


static void _init_f_sceneRect_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRectF > ();
}

static void _call_f_sceneRect_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRectF > ((QRectF)((QGraphicsView *)cls)->sceneRect ());
}

static qt_gsi::GenericMethod *_create_f_sceneRect_c0 ()
{
  return new qt_gsi::GenericMethod (":sceneRect", "@brief Method QRectF QGraphicsView::sceneRect()\n", true, &_init_f_sceneRect_c0, &_call_f_sceneRect_c0);
}

// void QGraphicsView::setAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAlignment_2750 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > ();
  ((QGraphicsView *)cls)->setAlignment (qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setAlignment_2750 ()
{
  return new qt_gsi::GenericMethod ("setAlignment|alignment=", "@brief Method void QGraphicsView::setAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setAlignment_2750, &_call_f_setAlignment_2750);
}

// void QGraphicsView::setBackgroundBrush(const QBrush &brush)


static void _init_f_setBackgroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBackgroundBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QGraphicsView *)cls)->setBackgroundBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setBackgroundBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setBackgroundBrush|backgroundBrush=", "@brief Method void QGraphicsView::setBackgroundBrush(const QBrush &brush)\n", false, &_init_f_setBackgroundBrush_1910, &_call_f_setBackgroundBrush_1910);
}

// void QGraphicsView::setCacheMode(QFlags<QGraphicsView::CacheModeFlag> mode)


static void _init_f_setCacheMode_3792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsView::CacheModeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCacheMode_3792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsView::CacheModeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsView::CacheModeFlag> >::target_type & > ();
  ((QGraphicsView *)cls)->setCacheMode (qt_gsi::QtToCppAdaptor<QFlags<QGraphicsView::CacheModeFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setCacheMode_3792 ()
{
  return new qt_gsi::GenericMethod ("setCacheMode|cacheMode=", "@brief Method void QGraphicsView::setCacheMode(QFlags<QGraphicsView::CacheModeFlag> mode)\n", false, &_init_f_setCacheMode_3792, &_call_f_setCacheMode_3792);
}

// void QGraphicsView::setDragMode(QGraphicsView::DragMode mode)


static void _init_f_setDragMode_2632 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::DragMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDragMode_2632 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsView::DragMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsView::DragMode>::target_type & > ();
  ((QGraphicsView *)cls)->setDragMode (qt_gsi::QtToCppAdaptor<QGraphicsView::DragMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDragMode_2632 ()
{
  return new qt_gsi::GenericMethod ("setDragMode|dragMode=", "@brief Method void QGraphicsView::setDragMode(QGraphicsView::DragMode mode)\n", false, &_init_f_setDragMode_2632, &_call_f_setDragMode_2632);
}

// void QGraphicsView::setForegroundBrush(const QBrush &brush)


static void _init_f_setForegroundBrush_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("brush");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setForegroundBrush_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QGraphicsView *)cls)->setForegroundBrush (arg1);
}

static qt_gsi::GenericMethod *_create_f_setForegroundBrush_1910 ()
{
  return new qt_gsi::GenericMethod ("setForegroundBrush|foregroundBrush=", "@brief Method void QGraphicsView::setForegroundBrush(const QBrush &brush)\n", false, &_init_f_setForegroundBrush_1910, &_call_f_setForegroundBrush_1910);
}

// void QGraphicsView::setInteractive(bool allowed)


static void _init_f_setInteractive_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("allowed");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInteractive_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsView *)cls)->setInteractive (arg1);
}

static qt_gsi::GenericMethod *_create_f_setInteractive_864 ()
{
  return new qt_gsi::GenericMethod ("setInteractive|interactive=", "@brief Method void QGraphicsView::setInteractive(bool allowed)\n", false, &_init_f_setInteractive_864, &_call_f_setInteractive_864);
}

// void QGraphicsView::setMatrix(const QMatrix &matrix, bool combine)


static void _init_f_setMatrix_2779 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QMatrix & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setMatrix_2779 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMatrix &arg1 = args.read<const QMatrix & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QGraphicsView *)cls)->setMatrix (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setMatrix_2779 ()
{
  return new qt_gsi::GenericMethod ("setMatrix", "@brief Method void QGraphicsView::setMatrix(const QMatrix &matrix, bool combine)\n", false, &_init_f_setMatrix_2779, &_call_f_setMatrix_2779);
}

// void QGraphicsView::setOptimizationFlag(QGraphicsView::OptimizationFlag flag, bool enabled)


static void _init_f_setOptimizationFlag_4282 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flag");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::OptimizationFlag>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setOptimizationFlag_4282 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsView::OptimizationFlag>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsView::OptimizationFlag>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsView *)cls)->setOptimizationFlag (qt_gsi::QtToCppAdaptor<QGraphicsView::OptimizationFlag>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setOptimizationFlag_4282 ()
{
  return new qt_gsi::GenericMethod ("setOptimizationFlag", "@brief Method void QGraphicsView::setOptimizationFlag(QGraphicsView::OptimizationFlag flag, bool enabled)\n", false, &_init_f_setOptimizationFlag_4282, &_call_f_setOptimizationFlag_4282);
}

// void QGraphicsView::setOptimizationFlags(QFlags<QGraphicsView::OptimizationFlag> flags)


static void _init_f_setOptimizationFlags_4222 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsView::OptimizationFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOptimizationFlags_4222 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsView::OptimizationFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsView::OptimizationFlag> >::target_type & > ();
  ((QGraphicsView *)cls)->setOptimizationFlags (qt_gsi::QtToCppAdaptor<QFlags<QGraphicsView::OptimizationFlag> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setOptimizationFlags_4222 ()
{
  return new qt_gsi::GenericMethod ("setOptimizationFlags|optimizationFlags=", "@brief Method void QGraphicsView::setOptimizationFlags(QFlags<QGraphicsView::OptimizationFlag> flags)\n", false, &_init_f_setOptimizationFlags_4222, &_call_f_setOptimizationFlags_4222);
}

// void QGraphicsView::setRenderHint(QPainter::RenderHint hint, bool enabled)


static void _init_f_setRenderHint_3123 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint");
  decl->add_arg<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enabled", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setRenderHint_3123 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPainter::RenderHint>::target_type & arg1 = args.read<const qt_gsi::Converter<QPainter::RenderHint>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsView *)cls)->setRenderHint (qt_gsi::QtToCppAdaptor<QPainter::RenderHint>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setRenderHint_3123 ()
{
  return new qt_gsi::GenericMethod ("setRenderHint", "@brief Method void QGraphicsView::setRenderHint(QPainter::RenderHint hint, bool enabled)\n", false, &_init_f_setRenderHint_3123, &_call_f_setRenderHint_3123);
}

// void QGraphicsView::setRenderHints(QFlags<QPainter::RenderHint> hints)


static void _init_f_setRenderHints_3063 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hints");
  decl->add_arg<const qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRenderHints_3063 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QPainter::RenderHint> >::target_type & > ();
  ((QGraphicsView *)cls)->setRenderHints (qt_gsi::QtToCppAdaptor<QFlags<QPainter::RenderHint> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setRenderHints_3063 ()
{
  return new qt_gsi::GenericMethod ("setRenderHints|renderHints=", "@brief Method void QGraphicsView::setRenderHints(QFlags<QPainter::RenderHint> hints)\n", false, &_init_f_setRenderHints_3063, &_call_f_setRenderHints_3063);
}

// void QGraphicsView::setResizeAnchor(QGraphicsView::ViewportAnchor anchor)


static void _init_f_setResizeAnchor_3328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("anchor");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResizeAnchor_3328 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & > ();
  ((QGraphicsView *)cls)->setResizeAnchor (qt_gsi::QtToCppAdaptor<QGraphicsView::ViewportAnchor>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setResizeAnchor_3328 ()
{
  return new qt_gsi::GenericMethod ("setResizeAnchor|resizeAnchor=", "@brief Method void QGraphicsView::setResizeAnchor(QGraphicsView::ViewportAnchor anchor)\n", false, &_init_f_setResizeAnchor_3328, &_call_f_setResizeAnchor_3328);
}

// void QGraphicsView::setRubberBandSelectionMode(Qt::ItemSelectionMode mode)


static void _init_f_setRubberBandSelectionMode_2471 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRubberBandSelectionMode_2471 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::ItemSelectionMode>::target_type & > ();
  ((QGraphicsView *)cls)->setRubberBandSelectionMode (qt_gsi::QtToCppAdaptor<Qt::ItemSelectionMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setRubberBandSelectionMode_2471 ()
{
  return new qt_gsi::GenericMethod ("setRubberBandSelectionMode|rubberBandSelectionMode=", "@brief Method void QGraphicsView::setRubberBandSelectionMode(Qt::ItemSelectionMode mode)\n", false, &_init_f_setRubberBandSelectionMode_2471, &_call_f_setRubberBandSelectionMode_2471);
}

// void QGraphicsView::setScene(QGraphicsScene *scene)


static void _init_f_setScene_2014 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scene");
  decl->add_arg<QGraphicsScene * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setScene_2014 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsScene *arg1 = args.read<QGraphicsScene * > ();
  ((QGraphicsView *)cls)->setScene (arg1);
}

static qt_gsi::GenericMethod *_create_f_setScene_2014 ()
{
  return new qt_gsi::GenericMethod ("setScene|scene=", "@brief Method void QGraphicsView::setScene(QGraphicsScene *scene)\n", false, &_init_f_setScene_2014, &_call_f_setScene_2014);
}

// void QGraphicsView::setSceneRect(const QRectF &rect)


static void _init_f_setSceneRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QGraphicsView *)cls)->setSceneRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSceneRect_1862 ()
{
  return new qt_gsi::GenericMethod ("setSceneRect|sceneRect=", "@brief Method void QGraphicsView::setSceneRect(const QRectF &rect)\n", false, &_init_f_setSceneRect_1862, &_call_f_setSceneRect_1862);
}

// void QGraphicsView::setSceneRect(double x, double y, double w, double h)


static void _init_f_setSceneRect_3960 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<double > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("w");
  decl->add_arg<double > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("h");
  decl->add_arg<double > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_setSceneRect_3960 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  double arg3 = args.read<double > ();
  double arg4 = args.read<double > ();
  ((QGraphicsView *)cls)->setSceneRect (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod *_create_f_setSceneRect_3960 ()
{
  return new qt_gsi::GenericMethod ("setSceneRect", "@brief Method void QGraphicsView::setSceneRect(double x, double y, double w, double h)\n", false, &_init_f_setSceneRect_3960, &_call_f_setSceneRect_3960);
}

// void QGraphicsView::setTransform(const QTransform &matrix, bool combine)


static void _init_f_setTransform_3106 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("matrix");
  decl->add_arg<const QTransform & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("combine", true, "false");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setTransform_3106 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTransform &arg1 = args.read<const QTransform & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(false);
  ((QGraphicsView *)cls)->setTransform (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setTransform_3106 ()
{
  return new qt_gsi::GenericMethod ("setTransform", "@brief Method void QGraphicsView::setTransform(const QTransform &matrix, bool combine)\n", false, &_init_f_setTransform_3106, &_call_f_setTransform_3106);
}

// void QGraphicsView::setTransformationAnchor(QGraphicsView::ViewportAnchor anchor)


static void _init_f_setTransformationAnchor_3328 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("anchor");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTransformationAnchor_3328 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type & > ();
  ((QGraphicsView *)cls)->setTransformationAnchor (qt_gsi::QtToCppAdaptor<QGraphicsView::ViewportAnchor>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setTransformationAnchor_3328 ()
{
  return new qt_gsi::GenericMethod ("setTransformationAnchor|transformationAnchor=", "@brief Method void QGraphicsView::setTransformationAnchor(QGraphicsView::ViewportAnchor anchor)\n", false, &_init_f_setTransformationAnchor_3328, &_call_f_setTransformationAnchor_3328);
}

// void QGraphicsView::setViewportUpdateMode(QGraphicsView::ViewportUpdateMode mode)


static void _init_f_setViewportUpdateMode_3725 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setViewportUpdateMode_3725 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type & > ();
  ((QGraphicsView *)cls)->setViewportUpdateMode (qt_gsi::QtToCppAdaptor<QGraphicsView::ViewportUpdateMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setViewportUpdateMode_3725 ()
{
  return new qt_gsi::GenericMethod ("setViewportUpdateMode|viewportUpdateMode=", "@brief Method void QGraphicsView::setViewportUpdateMode(QGraphicsView::ViewportUpdateMode mode)\n", false, &_init_f_setViewportUpdateMode_3725, &_call_f_setViewportUpdateMode_3725);
}

// void QGraphicsView::shear(double sh, double sv)


static void _init_f_shear_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sh");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sv");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_shear_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsView *)cls)->shear (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_shear_2034 ()
{
  return new qt_gsi::GenericMethod ("shear", "@brief Method void QGraphicsView::shear(double sh, double sv)\n", false, &_init_f_shear_2034, &_call_f_shear_2034);
}

// QSize QGraphicsView::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QGraphicsView *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QGraphicsView::sizeHint()\nThis is a reimplementation of QAbstractScrollArea::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// QTransform QGraphicsView::transform()


static void _init_f_transform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_transform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QGraphicsView *)cls)->transform ());
}

static qt_gsi::GenericMethod *_create_f_transform_c0 ()
{
  return new qt_gsi::GenericMethod (":transform", "@brief Method QTransform QGraphicsView::transform()\n", true, &_init_f_transform_c0, &_call_f_transform_c0);
}

// QGraphicsView::ViewportAnchor QGraphicsView::transformationAnchor()


static void _init_f_transformationAnchor_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ();
}

static void _call_f_transformationAnchor_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type > ((qt_gsi::Converter<QGraphicsView::ViewportAnchor>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::ViewportAnchor>(((QGraphicsView *)cls)->transformationAnchor ()));
}

static qt_gsi::GenericMethod *_create_f_transformationAnchor_c0 ()
{
  return new qt_gsi::GenericMethod (":transformationAnchor", "@brief Method QGraphicsView::ViewportAnchor QGraphicsView::transformationAnchor()\n", true, &_init_f_transformationAnchor_c0, &_call_f_transformationAnchor_c0);
}

// void QGraphicsView::translate(double dx, double dy)


static void _init_f_translate_2034 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<double > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<double > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_translate_2034 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  double arg2 = args.read<double > ();
  ((QGraphicsView *)cls)->translate (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_translate_2034 ()
{
  return new qt_gsi::GenericMethod ("translate", "@brief Method void QGraphicsView::translate(double dx, double dy)\n", false, &_init_f_translate_2034, &_call_f_translate_2034);
}

// void QGraphicsView::updateScene(const QList<QRectF> &rects)


static void _init_f_updateScene_2477 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rects");
  decl->add_arg<const qt_gsi::Converter<QList<QRectF> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateScene_2477 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QRectF> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QRectF> >::target_type & > ();
  ((QGraphicsView *)cls)->updateScene (qt_gsi::QtToCppAdaptor<QList<QRectF> >(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_updateScene_2477 ()
{
  return new qt_gsi::GenericMethod ("updateScene", "@brief Method void QGraphicsView::updateScene(const QList<QRectF> &rects)\n", false, &_init_f_updateScene_2477, &_call_f_updateScene_2477);
}

// void QGraphicsView::updateSceneRect(const QRectF &rect)


static void _init_f_updateSceneRect_1862 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_updateSceneRect_1862 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ((QGraphicsView *)cls)->updateSceneRect (arg1);
}

static qt_gsi::GenericMethod *_create_f_updateSceneRect_1862 ()
{
  return new qt_gsi::GenericMethod ("updateSceneRect", "@brief Method void QGraphicsView::updateSceneRect(const QRectF &rect)\n", false, &_init_f_updateSceneRect_1862, &_call_f_updateSceneRect_1862);
}

// QTransform QGraphicsView::viewportTransform()


static void _init_f_viewportTransform_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTransform > ();
}

static void _call_f_viewportTransform_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTransform > ((QTransform)((QGraphicsView *)cls)->viewportTransform ());
}

static qt_gsi::GenericMethod *_create_f_viewportTransform_c0 ()
{
  return new qt_gsi::GenericMethod ("viewportTransform", "@brief Method QTransform QGraphicsView::viewportTransform()\n", true, &_init_f_viewportTransform_c0, &_call_f_viewportTransform_c0);
}

// QGraphicsView::ViewportUpdateMode QGraphicsView::viewportUpdateMode()


static void _init_f_viewportUpdateMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type > ();
}

static void _call_f_viewportUpdateMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type > ((qt_gsi::Converter<QGraphicsView::ViewportUpdateMode>::target_type)qt_gsi::CppToQtAdaptor<QGraphicsView::ViewportUpdateMode>(((QGraphicsView *)cls)->viewportUpdateMode ()));
}

static qt_gsi::GenericMethod *_create_f_viewportUpdateMode_c0 ()
{
  return new qt_gsi::GenericMethod (":viewportUpdateMode", "@brief Method QGraphicsView::ViewportUpdateMode QGraphicsView::viewportUpdateMode()\n", true, &_init_f_viewportUpdateMode_c0, &_call_f_viewportUpdateMode_c0);
}

// static QString QGraphicsView::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsView::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsView::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsView::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsView::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsView::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsView::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsView::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsView::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsView::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsView::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsView::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsView, QGraphicsView_EventAdaptor> ea_QGraphicsView;

namespace gsi
{
extern gsi::Class<QAbstractScrollArea> decl_QAbstractScrollArea;

gsi::Class<QGraphicsView> decl_QGraphicsView (ea_QGraphicsView, decl_QAbstractScrollArea, "QGraphicsView_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_alignment_c0 ()) +
  gsi::Methods(_create_f_backgroundBrush_c0 ()) +
  gsi::Methods(_create_f_cacheMode_c0 ()) +
  gsi::Methods(_create_f_centerOn_1986 ()) +
  gsi::Methods(_create_f_centerOn_2034 ()) +
  gsi::Methods(_create_f_centerOn_2614 ()) +
  gsi::Methods(_create_f_dragMode_c0 ()) +
  gsi::Methods(_create_f_ensureVisible_3180 ()) +
  gsi::Methods(_create_f_ensureVisible_5278 ()) +
  gsi::Methods(_create_f_ensureVisible_3932 ()) +
  gsi::Methods(_create_f_fitInView_4011 ()) +
  gsi::Methods(_create_f_fitInView_6109 ()) +
  gsi::Methods(_create_f_fitInView_4763 ()) +
  gsi::Methods(_create_f_foregroundBrush_c0 ()) +
  gsi::Methods(_create_f_inputMethodQuery_c2420 ()) +
  gsi::Methods(_create_f_invalidateScene_5397 ()) +
  gsi::Methods(_create_f_isInteractive_c0 ()) +
  gsi::Methods(_create_f_isTransformed_c0 ()) +
  gsi::Methods(_create_f_itemAt_c1916 ()) +
  gsi::Methods(_create_f_itemAt_c1426 ()) +
  gsi::Methods(_create_f_items_c0 ()) +
  gsi::Methods(_create_f_items_c1916 ()) +
  gsi::Methods(_create_f_items_c1426 ()) +
  gsi::Methods(_create_f_items_c4155 ()) +
  gsi::Methods(_create_f_items_c5107 ()) +
  gsi::Methods(_create_f_items_c4501 ()) +
  gsi::Methods(_create_f_items_c4877 ()) +
  gsi::Methods(_create_f_mapFromScene_c1986 ()) +
  gsi::Methods(_create_f_mapFromScene_c1862 ()) +
  gsi::Methods(_create_f_mapFromScene_c2208 ()) +
  gsi::Methods(_create_f_mapFromScene_c2514 ()) +
  gsi::Methods(_create_f_mapFromScene_c2034 ()) +
  gsi::Methods(_create_f_mapFromScene_c3960 ()) +
  gsi::Methods(_create_f_mapToScene_c1916 ()) +
  gsi::Methods(_create_f_mapToScene_c1792 ()) +
  gsi::Methods(_create_f_mapToScene_c2138 ()) +
  gsi::Methods(_create_f_mapToScene_c2514 ()) +
  gsi::Methods(_create_f_mapToScene_c1426 ()) +
  gsi::Methods(_create_f_mapToScene_c2744 ()) +
  gsi::Methods(_create_f_matrix_c0 ()) +
  gsi::Methods(_create_f_optimizationFlags_c0 ()) +
  gsi::Methods(_create_f_render_7013 ()) +
  gsi::Methods(_create_f_renderHints_c0 ()) +
  gsi::Methods(_create_f_resetCachedContent_0 ()) +
  gsi::Methods(_create_f_resetMatrix_0 ()) +
  gsi::Methods(_create_f_resetTransform_0 ()) +
  gsi::Methods(_create_f_resizeAnchor_c0 ()) +
  gsi::Methods(_create_f_rotate_1071 ()) +
  gsi::Methods(_create_f_rubberBandSelectionMode_c0 ()) +
  gsi::Methods(_create_f_scale_2034 ()) +
  gsi::Methods(_create_f_scene_c0 ()) +
  gsi::Methods(_create_f_sceneRect_c0 ()) +
  gsi::Methods(_create_f_setAlignment_2750 ()) +
  gsi::Methods(_create_f_setBackgroundBrush_1910 ()) +
  gsi::Methods(_create_f_setCacheMode_3792 ()) +
  gsi::Methods(_create_f_setDragMode_2632 ()) +
  gsi::Methods(_create_f_setForegroundBrush_1910 ()) +
  gsi::Methods(_create_f_setInteractive_864 ()) +
  gsi::Methods(_create_f_setMatrix_2779 ()) +
  gsi::Methods(_create_f_setOptimizationFlag_4282 ()) +
  gsi::Methods(_create_f_setOptimizationFlags_4222 ()) +
  gsi::Methods(_create_f_setRenderHint_3123 ()) +
  gsi::Methods(_create_f_setRenderHints_3063 ()) +
  gsi::Methods(_create_f_setResizeAnchor_3328 ()) +
  gsi::Methods(_create_f_setRubberBandSelectionMode_2471 ()) +
  gsi::Methods(_create_f_setScene_2014 ()) +
  gsi::Methods(_create_f_setSceneRect_1862 ()) +
  gsi::Methods(_create_f_setSceneRect_3960 ()) +
  gsi::Methods(_create_f_setTransform_3106 ()) +
  gsi::Methods(_create_f_setTransformationAnchor_3328 ()) +
  gsi::Methods(_create_f_setViewportUpdateMode_3725 ()) +
  gsi::Methods(_create_f_shear_2034 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_transform_c0 ()) +
  gsi::Methods(_create_f_transformationAnchor_c0 ()) +
  gsi::Methods(_create_f_translate_2034 ()) +
  gsi::Methods(_create_f_updateScene_2477 ()) +
  gsi::Methods(_create_f_updateSceneRect_1862 ()) +
  gsi::Methods(_create_f_viewportTransform_c0 ()) +
  gsi::Methods(_create_f_viewportUpdateMode_c0 ()) +
  qt_gsi::qt_signal<QGraphicsView, QGraphicsView_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QGraphicsView_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QGraphicsView::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsView, QGraphicsView_EventAdaptor, QObject *> ("destroyed", &QGraphicsView_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsView::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsView");
}


class QGraphicsView_Adaptor : public QGraphicsView, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsView_Adaptor();

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QWidget *parent)
  QGraphicsView_Adaptor() : QGraphicsView()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QWidget *parent)
  QGraphicsView_Adaptor(QWidget *parent) : QGraphicsView(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent)
  QGraphicsView_Adaptor(QGraphicsScene *scene) : QGraphicsView(scene)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent)
  QGraphicsView_Adaptor(QGraphicsScene *scene, QWidget *parent) : QGraphicsView(scene, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsView::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QGraphicsView_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QGraphicsView::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QGraphicsView::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QGraphicsView_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QGraphicsView::destroy(destroyWindow, destroySubWindows);
  }

  //  void QGraphicsView::drawFrame(QPainter *)
  void fp_QGraphicsView_drawFrame_1426 (QPainter *arg1) {
    QGraphicsView::drawFrame(arg1);
  }

  //  bool QGraphicsView::focusNextChild()
  bool fp_QGraphicsView_focusNextChild_0 () {
    return QGraphicsView::focusNextChild();
  }

  //  bool QGraphicsView::focusPreviousChild()
  bool fp_QGraphicsView_focusPreviousChild_0 () {
    return QGraphicsView::focusPreviousChild();
  }

  //  int QGraphicsView::receivers(const char *signal)
  int fp_QGraphicsView_receivers_c1731 (const char *signal) const {
    return QGraphicsView::receivers(signal);
  }

  //  void QGraphicsView::resetInputContext()
  void fp_QGraphicsView_resetInputContext_0 () {
    QGraphicsView::resetInputContext();
  }

  //  QObject *QGraphicsView::sender()
  QObject * fp_QGraphicsView_sender_c0 () const {
    return QGraphicsView::sender();
  }

  //  void QGraphicsView::setViewportMargins(int left, int top, int right, int bottom)
  void fp_QGraphicsView_setViewportMargins_2744 (int left, int top, int right, int bottom) {
    QGraphicsView::setViewportMargins(left, top, right, bottom);
  }

  //  void QGraphicsView::setViewportMargins(const QMargins &margins)
  void fp_QGraphicsView_setViewportMargins_2115 (const QMargins &margins) {
    QGraphicsView::setViewportMargins(margins);
  }

  //  void QGraphicsView::setupViewport(QWidget *widget)
  void fp_QGraphicsView_setupViewport_1315 (QWidget *widget) {
    QGraphicsView::setupViewport(widget);
  }

  //  void QGraphicsView::updateMicroFocus()
  void fp_QGraphicsView_updateMicroFocus_0 () {
    QGraphicsView::updateMicroFocus();
  }

  //  [adaptor impl] bool QGraphicsView::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsView::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsView_Adaptor, bool, QObject *, QEvent *>(&QGraphicsView_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsView::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] int QGraphicsView::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QGraphicsView::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QGraphicsView_Adaptor, int, int>(&QGraphicsView_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QGraphicsView::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & query) const
  {
    return QGraphicsView::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(query).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery query) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QGraphicsView_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QGraphicsView_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(query));
    } else {
      return QGraphicsView::inputMethodQuery(query);
    }
  }

  //  [adaptor impl] QSize QGraphicsView::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QGraphicsView::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QGraphicsView_Adaptor, QSize>(&QGraphicsView_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QGraphicsView::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QGraphicsView::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QGraphicsView::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QGraphicsView_Adaptor, QPaintEngine *>(&QGraphicsView_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QGraphicsView::paintEngine();
    }
  }

  //  [adaptor impl] void QGraphicsView::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QGraphicsView::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QGraphicsView_Adaptor, bool>(&QGraphicsView_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QGraphicsView::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QGraphicsView::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QGraphicsView::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QGraphicsView_Adaptor, QSize>(&QGraphicsView_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QGraphicsView::sizeHint();
    }
  }

  //  [adaptor impl] void QGraphicsView::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QGraphicsView::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QGraphicsView_Adaptor, QActionEvent *>(&QGraphicsView_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QGraphicsView::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QGraphicsView::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QGraphicsView::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsView::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsView_Adaptor, QChildEvent *>(&QGraphicsView_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsView::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QGraphicsView::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QGraphicsView_Adaptor, QCloseEvent *>(&QGraphicsView_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QGraphicsView::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::contextMenuEvent(QContextMenuEvent *event)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *event)
  {
    QGraphicsView::contextMenuEvent(event);
  }

  virtual void contextMenuEvent(QContextMenuEvent *event)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QGraphicsView_Adaptor, QContextMenuEvent *>(&QGraphicsView_Adaptor::cbs_contextMenuEvent_2363_0, event);
    } else {
      QGraphicsView::contextMenuEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsView::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsView::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsView::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsView_Adaptor, const char *>(&QGraphicsView_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsView::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsView::dragEnterEvent(QDragEnterEvent *event)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *event)
  {
    QGraphicsView::dragEnterEvent(event);
  }

  virtual void dragEnterEvent(QDragEnterEvent *event)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QGraphicsView_Adaptor, QDragEnterEvent *>(&QGraphicsView_Adaptor::cbs_dragEnterEvent_2109_0, event);
    } else {
      QGraphicsView::dragEnterEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::dragLeaveEvent(QDragLeaveEvent *event)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *event)
  {
    QGraphicsView::dragLeaveEvent(event);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *event)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QGraphicsView_Adaptor, QDragLeaveEvent *>(&QGraphicsView_Adaptor::cbs_dragLeaveEvent_2092_0, event);
    } else {
      QGraphicsView::dragLeaveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::dragMoveEvent(QDragMoveEvent *event)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *event)
  {
    QGraphicsView::dragMoveEvent(event);
  }

  virtual void dragMoveEvent(QDragMoveEvent *event)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QGraphicsView_Adaptor, QDragMoveEvent *>(&QGraphicsView_Adaptor::cbs_dragMoveEvent_2006_0, event);
    } else {
      QGraphicsView::dragMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::drawBackground(QPainter *painter, const QRectF &rect)
  void cbs_drawBackground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsView::drawBackground(painter, rect);
  }

  virtual void drawBackground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawBackground_3180_0.can_issue()) {
      cb_drawBackground_3180_0.issue<QGraphicsView_Adaptor, QPainter *, const QRectF &>(&QGraphicsView_Adaptor::cbs_drawBackground_3180_0, painter, rect);
    } else {
      QGraphicsView::drawBackground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsView::drawForeground(QPainter *painter, const QRectF &rect)
  void cbs_drawForeground_3180_0(QPainter *painter, const QRectF &rect)
  {
    QGraphicsView::drawForeground(painter, rect);
  }

  virtual void drawForeground(QPainter *painter, const QRectF &rect)
  {
    if (cb_drawForeground_3180_0.can_issue()) {
      cb_drawForeground_3180_0.issue<QGraphicsView_Adaptor, QPainter *, const QRectF &>(&QGraphicsView_Adaptor::cbs_drawForeground_3180_0, painter, rect);
    } else {
      QGraphicsView::drawForeground(painter, rect);
    }
  }

  //  [adaptor impl] void QGraphicsView::dropEvent(QDropEvent *event)
  void cbs_dropEvent_1622_0(QDropEvent *event)
  {
    QGraphicsView::dropEvent(event);
  }

  virtual void dropEvent(QDropEvent *event)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QGraphicsView_Adaptor, QDropEvent *>(&QGraphicsView_Adaptor::cbs_dropEvent_1622_0, event);
    } else {
      QGraphicsView::dropEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QGraphicsView::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QGraphicsView_Adaptor, bool>(&QGraphicsView_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QGraphicsView::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QGraphicsView::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QGraphicsView::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsView::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QGraphicsView::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsView_Adaptor, bool, QEvent *>(&QGraphicsView_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QGraphicsView::event(_event);
    }
  }

  //  [adaptor impl] void QGraphicsView::focusInEvent(QFocusEvent *event)
  void cbs_focusInEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsView::focusInEvent(event);
  }

  virtual void focusInEvent(QFocusEvent *event)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QGraphicsView_Adaptor, QFocusEvent *>(&QGraphicsView_Adaptor::cbs_focusInEvent_1729_0, event);
    } else {
      QGraphicsView::focusInEvent(event);
    }
  }

  //  [adaptor impl] bool QGraphicsView::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QGraphicsView::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QGraphicsView_Adaptor, bool, bool>(&QGraphicsView_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QGraphicsView::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QGraphicsView::focusOutEvent(QFocusEvent *event)
  void cbs_focusOutEvent_1729_0(QFocusEvent *event)
  {
    QGraphicsView::focusOutEvent(event);
  }

  virtual void focusOutEvent(QFocusEvent *event)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QGraphicsView_Adaptor, QFocusEvent *>(&QGraphicsView_Adaptor::cbs_focusOutEvent_1729_0, event);
    } else {
      QGraphicsView::focusOutEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QGraphicsView::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QGraphicsView_Adaptor, const QFont &>(&QGraphicsView_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QGraphicsView::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QGraphicsView::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QGraphicsView_Adaptor, QHideEvent *>(&QGraphicsView_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QGraphicsView::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::inputMethodEvent(QInputMethodEvent *event)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *event)
  {
    QGraphicsView::inputMethodEvent(event);
  }

  virtual void inputMethodEvent(QInputMethodEvent *event)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QGraphicsView_Adaptor, QInputMethodEvent *>(&QGraphicsView_Adaptor::cbs_inputMethodEvent_2354_0, event);
    } else {
      QGraphicsView::inputMethodEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsView::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QGraphicsView_Adaptor, QKeyEvent *>(&QGraphicsView_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QGraphicsView::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::keyReleaseEvent(QKeyEvent *event)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *event)
  {
    QGraphicsView::keyReleaseEvent(event);
  }

  virtual void keyReleaseEvent(QKeyEvent *event)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QGraphicsView_Adaptor, QKeyEvent *>(&QGraphicsView_Adaptor::cbs_keyReleaseEvent_1514_0, event);
    } else {
      QGraphicsView::keyReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::languageChange()
  void cbs_languageChange_0_0()
  {
    QGraphicsView::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QGraphicsView_Adaptor>(&QGraphicsView_Adaptor::cbs_languageChange_0_0);
    } else {
      QGraphicsView::languageChange();
    }
  }

  //  [adaptor impl] void QGraphicsView::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QGraphicsView::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QGraphicsView_Adaptor, QEvent *>(&QGraphicsView_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QGraphicsView::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QGraphicsView::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QGraphicsView::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QGraphicsView_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QGraphicsView_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QGraphicsView::metric(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::mouseDoubleClickEvent(QMouseEvent *event)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mouseDoubleClickEvent(event);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *event)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mouseDoubleClickEvent_1738_0, event);
    } else {
      QGraphicsView::mouseDoubleClickEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::mouseMoveEvent(QMouseEvent *event)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mouseMoveEvent(event);
  }

  virtual void mouseMoveEvent(QMouseEvent *event)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mouseMoveEvent_1738_0, event);
    } else {
      QGraphicsView::mouseMoveEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QGraphicsView::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::mouseReleaseEvent(QMouseEvent *event)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *event)
  {
    QGraphicsView::mouseReleaseEvent(event);
  }

  virtual void mouseReleaseEvent(QMouseEvent *event)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QGraphicsView_Adaptor, QMouseEvent *>(&QGraphicsView_Adaptor::cbs_mouseReleaseEvent_1738_0, event);
    } else {
      QGraphicsView::mouseReleaseEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QGraphicsView::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QGraphicsView_Adaptor, QMoveEvent *>(&QGraphicsView_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QGraphicsView::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::paintEvent(QPaintEvent *event)
  void cbs_paintEvent_1725_0(QPaintEvent *event)
  {
    QGraphicsView::paintEvent(event);
  }

  virtual void paintEvent(QPaintEvent *event)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QGraphicsView_Adaptor, QPaintEvent *>(&QGraphicsView_Adaptor::cbs_paintEvent_1725_0, event);
    } else {
      QGraphicsView::paintEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QGraphicsView::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QGraphicsView_Adaptor, const QPalette &>(&QGraphicsView_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QGraphicsView::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QGraphicsView::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QGraphicsView_Adaptor, QResizeEvent *>(&QGraphicsView_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QGraphicsView::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::scrollContentsBy(int dx, int dy)
  void cbs_scrollContentsBy_1426_0(int dx, int dy)
  {
    QGraphicsView::scrollContentsBy(dx, dy);
  }

  virtual void scrollContentsBy(int dx, int dy)
  {
    if (cb_scrollContentsBy_1426_0.can_issue()) {
      cb_scrollContentsBy_1426_0.issue<QGraphicsView_Adaptor, int, int>(&QGraphicsView_Adaptor::cbs_scrollContentsBy_1426_0, dx, dy);
    } else {
      QGraphicsView::scrollContentsBy(dx, dy);
    }
  }

  //  [adaptor impl] void QGraphicsView::showEvent(QShowEvent *event)
  void cbs_showEvent_1634_0(QShowEvent *event)
  {
    QGraphicsView::showEvent(event);
  }

  virtual void showEvent(QShowEvent *event)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QGraphicsView_Adaptor, QShowEvent *>(&QGraphicsView_Adaptor::cbs_showEvent_1634_0, event);
    } else {
      QGraphicsView::showEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QGraphicsView::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QGraphicsView_Adaptor, QStyle &>(&QGraphicsView_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QGraphicsView::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QGraphicsView::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QGraphicsView_Adaptor, QTabletEvent *>(&QGraphicsView_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QGraphicsView::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsView::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsView::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsView_Adaptor, QTimerEvent *>(&QGraphicsView_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsView::timerEvent(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsView::viewportEvent(QEvent *event)
  bool cbs_viewportEvent_1217_0(QEvent *event)
  {
    return QGraphicsView::viewportEvent(event);
  }

  virtual bool viewportEvent(QEvent *event)
  {
    if (cb_viewportEvent_1217_0.can_issue()) {
      return cb_viewportEvent_1217_0.issue<QGraphicsView_Adaptor, bool, QEvent *>(&QGraphicsView_Adaptor::cbs_viewportEvent_1217_0, event);
    } else {
      return QGraphicsView::viewportEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::wheelEvent(QWheelEvent *event)
  void cbs_wheelEvent_1718_0(QWheelEvent *event)
  {
    QGraphicsView::wheelEvent(event);
  }

  virtual void wheelEvent(QWheelEvent *event)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QGraphicsView_Adaptor, QWheelEvent *>(&QGraphicsView_Adaptor::cbs_wheelEvent_1718_0, event);
    } else {
      QGraphicsView::wheelEvent(event);
    }
  }

  //  [adaptor impl] void QGraphicsView::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QGraphicsView::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QGraphicsView_Adaptor, bool>(&QGraphicsView_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QGraphicsView::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_drawBackground_3180_0;
  gsi::Callback cb_drawForeground_3180_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_scrollContentsBy_1426_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_viewportEvent_1217_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QGraphicsView_Adaptor::~QGraphicsView_Adaptor() { }

//  Constructor QGraphicsView::QGraphicsView(QWidget *parent) (adaptor class)

static void _init_ctor_QGraphicsView_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QGraphicsView_Adaptor *> ();
}

static void _call_ctor_QGraphicsView_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QGraphicsView_Adaptor *> (new QGraphicsView_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsView_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsView::QGraphicsView(QWidget *parent)\nThis method creates an object of class QGraphicsView.", &_init_ctor_QGraphicsView_Adaptor_1315, &_call_ctor_QGraphicsView_Adaptor_1315);
}

//  Constructor QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent) (adaptor class)

static void _init_ctor_QGraphicsView_Adaptor_3221 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("scene");
  decl->add_arg<QGraphicsScene * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QGraphicsView_Adaptor *> ();
}

static void _call_ctor_QGraphicsView_Adaptor_3221 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QGraphicsScene *arg1 = args.read<QGraphicsScene * > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QGraphicsView_Adaptor *> (new QGraphicsView_Adaptor (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsView_Adaptor_3221 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsView::QGraphicsView(QGraphicsScene *scene, QWidget *parent)\nThis method creates an object of class QGraphicsView.", &_init_ctor_QGraphicsView_Adaptor_3221, &_call_ctor_QGraphicsView_Adaptor_3221);
}

// void QGraphicsView::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QGraphicsView::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QGraphicsView::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QGraphicsView::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// void QGraphicsView::drawFrame(QPainter *)

static void _init_fp_drawFrame_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawFrame_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_drawFrame_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawFrame_1426 ()
{
  return new qt_gsi::GenericMethod("*drawFrame", "@brief Method void QGraphicsView::drawFrame(QPainter *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawFrame_1426, &_call_fp_drawFrame_1426);
}


// bool QGraphicsView::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QGraphicsView::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QGraphicsView::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QGraphicsView::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QGraphicsView::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsView::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QGraphicsView::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QGraphicsView::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QGraphicsView::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsView::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QGraphicsView::setViewportMargins(int left, int top, int right, int bottom)

static void _init_fp_setViewportMargins_2744 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("left");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("top");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("right");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("bottom");
  decl->add_arg<int > (argspec_3);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2744 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_setViewportMargins_2744 (arg1, arg2, arg3, arg4);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2744 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QGraphicsView::setViewportMargins(int left, int top, int right, int bottom)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2744, &_call_fp_setViewportMargins_2744);
}


// void QGraphicsView::setViewportMargins(const QMargins &margins)

static void _init_fp_setViewportMargins_2115 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("margins");
  decl->add_arg<const QMargins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setViewportMargins_2115 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMargins &arg1 = args.read<const QMargins & > ();
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_setViewportMargins_2115 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setViewportMargins_2115 ()
{
  return new qt_gsi::GenericMethod("*setViewportMargins", "@brief Method void QGraphicsView::setViewportMargins(const QMargins &margins)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setViewportMargins_2115, &_call_fp_setViewportMargins_2115);
}


// void QGraphicsView::setupViewport(QWidget *widget)

static void _init_fp_setupViewport_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_setupViewport_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_setupViewport_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_setupViewport_1315 ()
{
  return new qt_gsi::GenericMethod("*setupViewport", "@brief Method void QGraphicsView::setupViewport(QWidget *widget)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_setupViewport_1315, &_call_fp_setupViewport_1315);
}


// void QGraphicsView::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsView_Adaptor *)cls)->fp_QGraphicsView_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QGraphicsView::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// bool QGraphicsView::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsView::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// int QGraphicsView::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QGraphicsView::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("query");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QGraphicsView_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QGraphicsView::inputMethodQuery(Qt::InputMethodQuery query)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QGraphicsView::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QGraphicsView_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QGraphicsView::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QGraphicsView::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QGraphicsView_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QGraphicsView::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QGraphicsView::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QGraphicsView::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QGraphicsView::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QGraphicsView_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QGraphicsView::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QGraphicsView::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QGraphicsView::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QGraphicsView::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QGraphicsView::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QGraphicsView::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsView::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsView::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QGraphicsView::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QGraphicsView::contextMenuEvent(QContextMenuEvent *event)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QGraphicsView::contextMenuEvent(QContextMenuEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QGraphicsView::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsView::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsView::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsView::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsView::dragEnterEvent(QDragEnterEvent *event)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QGraphicsView::dragEnterEvent(QDragEnterEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QGraphicsView::dragLeaveEvent(QDragLeaveEvent *event)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QGraphicsView::dragLeaveEvent(QDragLeaveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QGraphicsView::dragMoveEvent(QDragMoveEvent *event)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QGraphicsView::dragMoveEvent(QDragMoveEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QGraphicsView::drawBackground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawBackground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawBackground_3180_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_drawBackground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawBackground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_drawBackground_3180_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawBackground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawBackground", "@hide", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawBackground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawBackground", "@brief Virtual method void QGraphicsView::drawBackground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawBackground_3180_0, &_call_cbs_drawBackground_3180_0, &_set_callback_cbs_drawBackground_3180_0);
}


// void QGraphicsView::drawForeground(QPainter *painter, const QRectF &rect)

static void _init_cbs_drawForeground_3180_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRectF & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_drawForeground_3180_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRectF &arg2 = args.read<const QRectF & > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_drawForeground_3180_0 (arg1, arg2);
}

static void _set_callback_cbs_drawForeground_3180_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_drawForeground_3180_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_drawForeground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawForeground", "@hide", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_drawForeground_3180_0 ()
{
  return new qt_gsi::GenericMethod ("*drawForeground", "@brief Virtual method void QGraphicsView::drawForeground(QPainter *painter, const QRectF &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_drawForeground_3180_0, &_call_cbs_drawForeground_3180_0, &_set_callback_cbs_drawForeground_3180_0);
}


// void QGraphicsView::dropEvent(QDropEvent *event)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QGraphicsView::dropEvent(QDropEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QGraphicsView::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QGraphicsView::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QGraphicsView::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QGraphicsView::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QGraphicsView::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QGraphicsView::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QGraphicsView::focusInEvent(QFocusEvent *event)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QGraphicsView::focusInEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QGraphicsView::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QGraphicsView::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QGraphicsView::focusOutEvent(QFocusEvent *event)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QGraphicsView::focusOutEvent(QFocusEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QGraphicsView::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QGraphicsView::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QGraphicsView::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QGraphicsView::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QGraphicsView::inputMethodEvent(QInputMethodEvent *event)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QGraphicsView::inputMethodEvent(QInputMethodEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QGraphicsView::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QGraphicsView::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QGraphicsView::keyReleaseEvent(QKeyEvent *event)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QGraphicsView::keyReleaseEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QGraphicsView::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsView_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QGraphicsView::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QGraphicsView::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QGraphicsView::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QGraphicsView::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QGraphicsView_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QGraphicsView::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QGraphicsView::mouseDoubleClickEvent(QMouseEvent *event)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QGraphicsView::mouseDoubleClickEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QGraphicsView::mouseMoveEvent(QMouseEvent *event)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QGraphicsView::mouseMoveEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QGraphicsView::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QGraphicsView::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QGraphicsView::mouseReleaseEvent(QMouseEvent *event)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QGraphicsView::mouseReleaseEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QGraphicsView::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QGraphicsView::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QGraphicsView::paintEvent(QPaintEvent *event)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QGraphicsView::paintEvent(QPaintEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QGraphicsView::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QGraphicsView::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QGraphicsView::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QGraphicsView::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QGraphicsView::scrollContentsBy(int dx, int dy)

static void _init_cbs_scrollContentsBy_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dx");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dy");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_scrollContentsBy_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_scrollContentsBy_1426_0 (arg1, arg2);
}

static void _set_callback_cbs_scrollContentsBy_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_scrollContentsBy_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@hide", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_scrollContentsBy_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*scrollContentsBy", "@brief Virtual method void QGraphicsView::scrollContentsBy(int dx, int dy)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_scrollContentsBy_1426_0, &_call_cbs_scrollContentsBy_1426_0, &_set_callback_cbs_scrollContentsBy_1426_0);
}


// void QGraphicsView::showEvent(QShowEvent *event)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QGraphicsView::showEvent(QShowEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QGraphicsView::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QGraphicsView::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QGraphicsView::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QGraphicsView::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QGraphicsView::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsView::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// bool QGraphicsView::viewportEvent(QEvent *event)

static void _init_cbs_viewportEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_viewportEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsView_Adaptor *)cls)->cbs_viewportEvent_1217_0 (arg1));
}

static void _set_callback_cbs_viewportEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_viewportEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@hide", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_viewportEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*viewportEvent", "@brief Virtual method bool QGraphicsView::viewportEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_viewportEvent_1217_0, &_call_cbs_viewportEvent_1217_0, &_set_callback_cbs_viewportEvent_1217_0);
}


// void QGraphicsView::wheelEvent(QWheelEvent *event)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QGraphicsView::wheelEvent(QWheelEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QGraphicsView::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QGraphicsView_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsView_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QGraphicsView::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsView> decl_QGraphicsView;

gsi::Class<QGraphicsView_Adaptor> decl_QGraphicsView_Adaptor (decl_QGraphicsView, "QGraphicsView",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_drawFrame_1426 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2744 ()) +
  gsi::Methods(_create_fp_setViewportMargins_2115 ()) +
  gsi::Methods(_create_fp_setupViewport_1315 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_drawBackground_3180_0 ()) +
  gsi::Methods(_create_callback_cbs_drawBackground_3180_0 ()) +
  gsi::Methods(_create_cbs_drawForeground_3180_0 ()) +
  gsi::Methods(_create_callback_cbs_drawForeground_3180_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_scrollContentsBy_1426_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_viewportEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsView_Adaptor_1315 ()) +
  gsi::Methods(_create_ctor_QGraphicsView_Adaptor_3221 ()),
  "@qt\n@brief Binding of QGraphicsView");

}


//  Implementation of the enum wrapper class for QGraphicsView::CacheModeFlag
namespace qt_gsi
{

static QGraphicsView_CacheModeFlag_Enum *c_1_QGraphicsView_CacheModeFlag_Enum () { return new QGraphicsView_CacheModeFlag_Enum (QGraphicsView::CacheNone); }
static QGraphicsView_CacheModeFlag_Enum *c_2_QGraphicsView_CacheModeFlag_Enum () { return new QGraphicsView_CacheModeFlag_Enum (QGraphicsView::CacheBackground); }

static gsi::Methods mkdefs_QGraphicsView_CacheModeFlag () {
  return
    gsi::constant ("CacheNone", &qt_gsi::c_1_QGraphicsView_CacheModeFlag_Enum, "@brief Enum constant QGraphicsView::CacheNone") +
    gsi::constant ("CacheBackground", &qt_gsi::c_2_QGraphicsView_CacheModeFlag_Enum, "@brief Enum constant QGraphicsView::CacheBackground");
}

static std::string to_s_QGraphicsView_CacheModeFlag_Enum (const QGraphicsView_CacheModeFlag_Enum *e)
{
  if (e->value () == QGraphicsView::CacheNone) { return tl::sprintf ("CacheNone (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::CacheBackground) { return tl::sprintf ("CacheBackground (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsView_CacheModeFlag_Enum (const QGraphicsView_CacheModeFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsView_CacheModeFlag_Enum *from_i_QGraphicsView_CacheModeFlag_Enum (unsigned int i)
{
  return new QGraphicsView_CacheModeFlag_Enum ((QGraphicsView::CacheModeFlag) i);
}

static bool equalQGraphicsView_CacheModeFlag_Enum (const QGraphicsView_CacheModeFlag_Enum *e, QGraphicsView_CacheModeFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsView_CacheModeFlag_Enum (const QGraphicsView_CacheModeFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsView_CacheModeFlag_Enums oropQGraphicsView_CacheModeFlag_Enums (const QGraphicsView_CacheModeFlag_Enums *e, const QGraphicsView_CacheModeFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsView_CacheModeFlag_Enums andopQGraphicsView_CacheModeFlag_Enums (const QGraphicsView_CacheModeFlag_Enums *e, const QGraphicsView_CacheModeFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsView_CacheModeFlag_Enums xoropQGraphicsView_CacheModeFlag_Enums (const QGraphicsView_CacheModeFlag_Enums *e, const QGraphicsView_CacheModeFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsView_CacheModeFlag_Enums (const QGraphicsView_CacheModeFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsView::CacheNone)) { if (!l.empty ()) l += "|"; l += "CacheNone"; }
  if (e->testFlag (QGraphicsView::CacheBackground)) { if (!l.empty ()) l += "|"; l += "CacheBackground"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsView_CacheModeFlag_Enums (const QGraphicsView_CacheModeFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsView_CacheModeFlag_Enums (const QGraphicsView_CacheModeFlag_Enums *e, const QGraphicsView_CacheModeFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsView_CacheModeFlag_Enums> decl_QGraphicsView_CacheModeFlag_Enums ("QGraphicsView_QFlags_CacheModeFlag",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsView_CacheModeFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsView_CacheModeFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsView_CacheModeFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_CacheModeFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_CacheModeFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsView_CacheModeFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsView::CacheModeFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsView_CacheModeFlag_Enum> decl_QGraphicsView_CacheModeFlag_Enum (decl_QGraphicsView_CacheModeFlag_Enums, "QGraphicsView_CacheModeFlag",
  qt_gsi::mkdefs_QGraphicsView_CacheModeFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_CacheModeFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_CacheModeFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsView_CacheModeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsView_CacheModeFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsView_CacheModeFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsView::CacheModeFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_CacheModeFlag_Enum_in_parent (qt_gsi::mkdefs_QGraphicsView_CacheModeFlag ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_CacheModeFlag_Enum_as_child (decl_QGraphicsView_CacheModeFlag_Enum, "CacheModeFlag");

}


//  Implementation of the enum wrapper class for QGraphicsView::DragMode
namespace qt_gsi
{

static QGraphicsView_DragMode_Enum *c_1_QGraphicsView_DragMode_Enum () { return new QGraphicsView_DragMode_Enum (QGraphicsView::NoDrag); }
static QGraphicsView_DragMode_Enum *c_2_QGraphicsView_DragMode_Enum () { return new QGraphicsView_DragMode_Enum (QGraphicsView::ScrollHandDrag); }
static QGraphicsView_DragMode_Enum *c_3_QGraphicsView_DragMode_Enum () { return new QGraphicsView_DragMode_Enum (QGraphicsView::RubberBandDrag); }

static gsi::Methods mkdefs_QGraphicsView_DragMode () {
  return
    gsi::constant ("NoDrag", &qt_gsi::c_1_QGraphicsView_DragMode_Enum, "@brief Enum constant QGraphicsView::NoDrag") +
    gsi::constant ("ScrollHandDrag", &qt_gsi::c_2_QGraphicsView_DragMode_Enum, "@brief Enum constant QGraphicsView::ScrollHandDrag") +
    gsi::constant ("RubberBandDrag", &qt_gsi::c_3_QGraphicsView_DragMode_Enum, "@brief Enum constant QGraphicsView::RubberBandDrag");
}

static std::string to_s_QGraphicsView_DragMode_Enum (const QGraphicsView_DragMode_Enum *e)
{
  if (e->value () == QGraphicsView::NoDrag) { return tl::sprintf ("NoDrag (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::ScrollHandDrag) { return tl::sprintf ("ScrollHandDrag (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::RubberBandDrag) { return tl::sprintf ("RubberBandDrag (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsView_DragMode_Enum (const QGraphicsView_DragMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsView_DragMode_Enum *from_i_QGraphicsView_DragMode_Enum (unsigned int i)
{
  return new QGraphicsView_DragMode_Enum ((QGraphicsView::DragMode) i);
}

static bool equalQGraphicsView_DragMode_Enum (const QGraphicsView_DragMode_Enum *e, QGraphicsView_DragMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsView_DragMode_Enum (const QGraphicsView_DragMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsView_DragMode_Enums oropQGraphicsView_DragMode_Enums (const QGraphicsView_DragMode_Enums *e, const QGraphicsView_DragMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsView_DragMode_Enums andopQGraphicsView_DragMode_Enums (const QGraphicsView_DragMode_Enums *e, const QGraphicsView_DragMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsView_DragMode_Enums xoropQGraphicsView_DragMode_Enums (const QGraphicsView_DragMode_Enums *e, const QGraphicsView_DragMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsView_DragMode_Enums (const QGraphicsView_DragMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsView::NoDrag)) { if (!l.empty ()) l += "|"; l += "NoDrag"; }
  if (e->testFlag (QGraphicsView::ScrollHandDrag)) { if (!l.empty ()) l += "|"; l += "ScrollHandDrag"; }
  if (e->testFlag (QGraphicsView::RubberBandDrag)) { if (!l.empty ()) l += "|"; l += "RubberBandDrag"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsView_DragMode_Enums (const QGraphicsView_DragMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsView_DragMode_Enums (const QGraphicsView_DragMode_Enums *e, const QGraphicsView_DragMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsView_DragMode_Enums> decl_QGraphicsView_DragMode_Enums ("QGraphicsView_QFlags_DragMode",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsView_DragMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsView_DragMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsView_DragMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_DragMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_DragMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsView_DragMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsView::DragMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsView_DragMode_Enum> decl_QGraphicsView_DragMode_Enum (decl_QGraphicsView_DragMode_Enums, "QGraphicsView_DragMode",
  qt_gsi::mkdefs_QGraphicsView_DragMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_DragMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_DragMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsView_DragMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsView_DragMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsView_DragMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsView::DragMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_DragMode_Enum_in_parent (qt_gsi::mkdefs_QGraphicsView_DragMode ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_DragMode_Enum_as_child (decl_QGraphicsView_DragMode_Enum, "DragMode");

}


//  Implementation of the enum wrapper class for QGraphicsView::OptimizationFlag
namespace qt_gsi
{

static QGraphicsView_OptimizationFlag_Enum *c_1_QGraphicsView_OptimizationFlag_Enum () { return new QGraphicsView_OptimizationFlag_Enum (QGraphicsView::DontClipPainter); }
static QGraphicsView_OptimizationFlag_Enum *c_2_QGraphicsView_OptimizationFlag_Enum () { return new QGraphicsView_OptimizationFlag_Enum (QGraphicsView::DontSavePainterState); }
static QGraphicsView_OptimizationFlag_Enum *c_3_QGraphicsView_OptimizationFlag_Enum () { return new QGraphicsView_OptimizationFlag_Enum (QGraphicsView::DontAdjustForAntialiasing); }
static QGraphicsView_OptimizationFlag_Enum *c_4_QGraphicsView_OptimizationFlag_Enum () { return new QGraphicsView_OptimizationFlag_Enum (QGraphicsView::IndirectPainting); }

static gsi::Methods mkdefs_QGraphicsView_OptimizationFlag () {
  return
    gsi::constant ("DontClipPainter", &qt_gsi::c_1_QGraphicsView_OptimizationFlag_Enum, "@brief Enum constant QGraphicsView::DontClipPainter") +
    gsi::constant ("DontSavePainterState", &qt_gsi::c_2_QGraphicsView_OptimizationFlag_Enum, "@brief Enum constant QGraphicsView::DontSavePainterState") +
    gsi::constant ("DontAdjustForAntialiasing", &qt_gsi::c_3_QGraphicsView_OptimizationFlag_Enum, "@brief Enum constant QGraphicsView::DontAdjustForAntialiasing") +
    gsi::constant ("IndirectPainting", &qt_gsi::c_4_QGraphicsView_OptimizationFlag_Enum, "@brief Enum constant QGraphicsView::IndirectPainting");
}

static std::string to_s_QGraphicsView_OptimizationFlag_Enum (const QGraphicsView_OptimizationFlag_Enum *e)
{
  if (e->value () == QGraphicsView::DontClipPainter) { return tl::sprintf ("DontClipPainter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::DontSavePainterState) { return tl::sprintf ("DontSavePainterState (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::DontAdjustForAntialiasing) { return tl::sprintf ("DontAdjustForAntialiasing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::IndirectPainting) { return tl::sprintf ("IndirectPainting (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsView_OptimizationFlag_Enum (const QGraphicsView_OptimizationFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsView_OptimizationFlag_Enum *from_i_QGraphicsView_OptimizationFlag_Enum (unsigned int i)
{
  return new QGraphicsView_OptimizationFlag_Enum ((QGraphicsView::OptimizationFlag) i);
}

static bool equalQGraphicsView_OptimizationFlag_Enum (const QGraphicsView_OptimizationFlag_Enum *e, QGraphicsView_OptimizationFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsView_OptimizationFlag_Enum (const QGraphicsView_OptimizationFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsView_OptimizationFlag_Enums oropQGraphicsView_OptimizationFlag_Enums (const QGraphicsView_OptimizationFlag_Enums *e, const QGraphicsView_OptimizationFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsView_OptimizationFlag_Enums andopQGraphicsView_OptimizationFlag_Enums (const QGraphicsView_OptimizationFlag_Enums *e, const QGraphicsView_OptimizationFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsView_OptimizationFlag_Enums xoropQGraphicsView_OptimizationFlag_Enums (const QGraphicsView_OptimizationFlag_Enums *e, const QGraphicsView_OptimizationFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsView_OptimizationFlag_Enums (const QGraphicsView_OptimizationFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsView::DontClipPainter)) { if (!l.empty ()) l += "|"; l += "DontClipPainter"; }
  if (e->testFlag (QGraphicsView::DontSavePainterState)) { if (!l.empty ()) l += "|"; l += "DontSavePainterState"; }
  if (e->testFlag (QGraphicsView::DontAdjustForAntialiasing)) { if (!l.empty ()) l += "|"; l += "DontAdjustForAntialiasing"; }
  if (e->testFlag (QGraphicsView::IndirectPainting)) { if (!l.empty ()) l += "|"; l += "IndirectPainting"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsView_OptimizationFlag_Enums (const QGraphicsView_OptimizationFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsView_OptimizationFlag_Enums (const QGraphicsView_OptimizationFlag_Enums *e, const QGraphicsView_OptimizationFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsView_OptimizationFlag_Enums> decl_QGraphicsView_OptimizationFlag_Enums ("QGraphicsView_QFlags_OptimizationFlag",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsView_OptimizationFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsView_OptimizationFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsView_OptimizationFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_OptimizationFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_OptimizationFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsView_OptimizationFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsView::OptimizationFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsView_OptimizationFlag_Enum> decl_QGraphicsView_OptimizationFlag_Enum (decl_QGraphicsView_OptimizationFlag_Enums, "QGraphicsView_OptimizationFlag",
  qt_gsi::mkdefs_QGraphicsView_OptimizationFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_OptimizationFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_OptimizationFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsView_OptimizationFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsView_OptimizationFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsView_OptimizationFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsView::OptimizationFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_OptimizationFlag_Enum_in_parent (qt_gsi::mkdefs_QGraphicsView_OptimizationFlag ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_OptimizationFlag_Enum_as_child (decl_QGraphicsView_OptimizationFlag_Enum, "OptimizationFlag");

}


//  Implementation of the enum wrapper class for QGraphicsView::ViewportAnchor
namespace qt_gsi
{

static QGraphicsView_ViewportAnchor_Enum *c_1_QGraphicsView_ViewportAnchor_Enum () { return new QGraphicsView_ViewportAnchor_Enum (QGraphicsView::NoAnchor); }
static QGraphicsView_ViewportAnchor_Enum *c_2_QGraphicsView_ViewportAnchor_Enum () { return new QGraphicsView_ViewportAnchor_Enum (QGraphicsView::AnchorViewCenter); }
static QGraphicsView_ViewportAnchor_Enum *c_3_QGraphicsView_ViewportAnchor_Enum () { return new QGraphicsView_ViewportAnchor_Enum (QGraphicsView::AnchorUnderMouse); }

static gsi::Methods mkdefs_QGraphicsView_ViewportAnchor () {
  return
    gsi::constant ("NoAnchor", &qt_gsi::c_1_QGraphicsView_ViewportAnchor_Enum, "@brief Enum constant QGraphicsView::NoAnchor") +
    gsi::constant ("AnchorViewCenter", &qt_gsi::c_2_QGraphicsView_ViewportAnchor_Enum, "@brief Enum constant QGraphicsView::AnchorViewCenter") +
    gsi::constant ("AnchorUnderMouse", &qt_gsi::c_3_QGraphicsView_ViewportAnchor_Enum, "@brief Enum constant QGraphicsView::AnchorUnderMouse");
}

static std::string to_s_QGraphicsView_ViewportAnchor_Enum (const QGraphicsView_ViewportAnchor_Enum *e)
{
  if (e->value () == QGraphicsView::NoAnchor) { return tl::sprintf ("NoAnchor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::AnchorViewCenter) { return tl::sprintf ("AnchorViewCenter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::AnchorUnderMouse) { return tl::sprintf ("AnchorUnderMouse (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsView_ViewportAnchor_Enum (const QGraphicsView_ViewportAnchor_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsView_ViewportAnchor_Enum *from_i_QGraphicsView_ViewportAnchor_Enum (unsigned int i)
{
  return new QGraphicsView_ViewportAnchor_Enum ((QGraphicsView::ViewportAnchor) i);
}

static bool equalQGraphicsView_ViewportAnchor_Enum (const QGraphicsView_ViewportAnchor_Enum *e, QGraphicsView_ViewportAnchor_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsView_ViewportAnchor_Enum (const QGraphicsView_ViewportAnchor_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsView_ViewportAnchor_Enums oropQGraphicsView_ViewportAnchor_Enums (const QGraphicsView_ViewportAnchor_Enums *e, const QGraphicsView_ViewportAnchor_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsView_ViewportAnchor_Enums andopQGraphicsView_ViewportAnchor_Enums (const QGraphicsView_ViewportAnchor_Enums *e, const QGraphicsView_ViewportAnchor_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsView_ViewportAnchor_Enums xoropQGraphicsView_ViewportAnchor_Enums (const QGraphicsView_ViewportAnchor_Enums *e, const QGraphicsView_ViewportAnchor_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsView_ViewportAnchor_Enums (const QGraphicsView_ViewportAnchor_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsView::NoAnchor)) { if (!l.empty ()) l += "|"; l += "NoAnchor"; }
  if (e->testFlag (QGraphicsView::AnchorViewCenter)) { if (!l.empty ()) l += "|"; l += "AnchorViewCenter"; }
  if (e->testFlag (QGraphicsView::AnchorUnderMouse)) { if (!l.empty ()) l += "|"; l += "AnchorUnderMouse"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsView_ViewportAnchor_Enums (const QGraphicsView_ViewportAnchor_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsView_ViewportAnchor_Enums (const QGraphicsView_ViewportAnchor_Enums *e, const QGraphicsView_ViewportAnchor_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsView_ViewportAnchor_Enums> decl_QGraphicsView_ViewportAnchor_Enums ("QGraphicsView_QFlags_ViewportAnchor",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsView_ViewportAnchor_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsView_ViewportAnchor_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsView_ViewportAnchor_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_ViewportAnchor_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_ViewportAnchor_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsView_ViewportAnchor_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsView::ViewportAnchor> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsView_ViewportAnchor_Enum> decl_QGraphicsView_ViewportAnchor_Enum (decl_QGraphicsView_ViewportAnchor_Enums, "QGraphicsView_ViewportAnchor",
  qt_gsi::mkdefs_QGraphicsView_ViewportAnchor () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_ViewportAnchor_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_ViewportAnchor_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsView_ViewportAnchor_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsView_ViewportAnchor_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsView_ViewportAnchor_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsView::ViewportAnchor enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_ViewportAnchor_Enum_in_parent (qt_gsi::mkdefs_QGraphicsView_ViewportAnchor ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_ViewportAnchor_Enum_as_child (decl_QGraphicsView_ViewportAnchor_Enum, "ViewportAnchor");

}


//  Implementation of the enum wrapper class for QGraphicsView::ViewportUpdateMode
namespace qt_gsi
{

static QGraphicsView_ViewportUpdateMode_Enum *c_1_QGraphicsView_ViewportUpdateMode_Enum () { return new QGraphicsView_ViewportUpdateMode_Enum (QGraphicsView::FullViewportUpdate); }
static QGraphicsView_ViewportUpdateMode_Enum *c_2_QGraphicsView_ViewportUpdateMode_Enum () { return new QGraphicsView_ViewportUpdateMode_Enum (QGraphicsView::MinimalViewportUpdate); }
static QGraphicsView_ViewportUpdateMode_Enum *c_3_QGraphicsView_ViewportUpdateMode_Enum () { return new QGraphicsView_ViewportUpdateMode_Enum (QGraphicsView::SmartViewportUpdate); }
static QGraphicsView_ViewportUpdateMode_Enum *c_4_QGraphicsView_ViewportUpdateMode_Enum () { return new QGraphicsView_ViewportUpdateMode_Enum (QGraphicsView::NoViewportUpdate); }
static QGraphicsView_ViewportUpdateMode_Enum *c_5_QGraphicsView_ViewportUpdateMode_Enum () { return new QGraphicsView_ViewportUpdateMode_Enum (QGraphicsView::BoundingRectViewportUpdate); }

static gsi::Methods mkdefs_QGraphicsView_ViewportUpdateMode () {
  return
    gsi::constant ("FullViewportUpdate", &qt_gsi::c_1_QGraphicsView_ViewportUpdateMode_Enum, "@brief Enum constant QGraphicsView::FullViewportUpdate") +
    gsi::constant ("MinimalViewportUpdate", &qt_gsi::c_2_QGraphicsView_ViewportUpdateMode_Enum, "@brief Enum constant QGraphicsView::MinimalViewportUpdate") +
    gsi::constant ("SmartViewportUpdate", &qt_gsi::c_3_QGraphicsView_ViewportUpdateMode_Enum, "@brief Enum constant QGraphicsView::SmartViewportUpdate") +
    gsi::constant ("NoViewportUpdate", &qt_gsi::c_4_QGraphicsView_ViewportUpdateMode_Enum, "@brief Enum constant QGraphicsView::NoViewportUpdate") +
    gsi::constant ("BoundingRectViewportUpdate", &qt_gsi::c_5_QGraphicsView_ViewportUpdateMode_Enum, "@brief Enum constant QGraphicsView::BoundingRectViewportUpdate");
}

static std::string to_s_QGraphicsView_ViewportUpdateMode_Enum (const QGraphicsView_ViewportUpdateMode_Enum *e)
{
  if (e->value () == QGraphicsView::FullViewportUpdate) { return tl::sprintf ("FullViewportUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::MinimalViewportUpdate) { return tl::sprintf ("MinimalViewportUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::SmartViewportUpdate) { return tl::sprintf ("SmartViewportUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::NoViewportUpdate) { return tl::sprintf ("NoViewportUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QGraphicsView::BoundingRectViewportUpdate) { return tl::sprintf ("BoundingRectViewportUpdate (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QGraphicsView_ViewportUpdateMode_Enum (const QGraphicsView_ViewportUpdateMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QGraphicsView_ViewportUpdateMode_Enum *from_i_QGraphicsView_ViewportUpdateMode_Enum (unsigned int i)
{
  return new QGraphicsView_ViewportUpdateMode_Enum ((QGraphicsView::ViewportUpdateMode) i);
}

static bool equalQGraphicsView_ViewportUpdateMode_Enum (const QGraphicsView_ViewportUpdateMode_Enum *e, QGraphicsView_ViewportUpdateMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QGraphicsView_ViewportUpdateMode_Enum (const QGraphicsView_ViewportUpdateMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QGraphicsView_ViewportUpdateMode_Enums oropQGraphicsView_ViewportUpdateMode_Enums (const QGraphicsView_ViewportUpdateMode_Enums *e, const QGraphicsView_ViewportUpdateMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QGraphicsView_ViewportUpdateMode_Enums andopQGraphicsView_ViewportUpdateMode_Enums (const QGraphicsView_ViewportUpdateMode_Enums *e, const QGraphicsView_ViewportUpdateMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QGraphicsView_ViewportUpdateMode_Enums xoropQGraphicsView_ViewportUpdateMode_Enums (const QGraphicsView_ViewportUpdateMode_Enums *e, const QGraphicsView_ViewportUpdateMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QGraphicsView_ViewportUpdateMode_Enums (const QGraphicsView_ViewportUpdateMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QGraphicsView::FullViewportUpdate)) { if (!l.empty ()) l += "|"; l += "FullViewportUpdate"; }
  if (e->testFlag (QGraphicsView::MinimalViewportUpdate)) { if (!l.empty ()) l += "|"; l += "MinimalViewportUpdate"; }
  if (e->testFlag (QGraphicsView::SmartViewportUpdate)) { if (!l.empty ()) l += "|"; l += "SmartViewportUpdate"; }
  if (e->testFlag (QGraphicsView::NoViewportUpdate)) { if (!l.empty ()) l += "|"; l += "NoViewportUpdate"; }
  if (e->testFlag (QGraphicsView::BoundingRectViewportUpdate)) { if (!l.empty ()) l += "|"; l += "BoundingRectViewportUpdate"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QGraphicsView_ViewportUpdateMode_Enums (const QGraphicsView_ViewportUpdateMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QGraphicsView_ViewportUpdateMode_Enums (const QGraphicsView_ViewportUpdateMode_Enums *e, const QGraphicsView_ViewportUpdateMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QGraphicsView_ViewportUpdateMode_Enums> decl_QGraphicsView_ViewportUpdateMode_Enums ("QGraphicsView_QFlags_ViewportUpdateMode",
  gsi::method_ext ("|", &qt_gsi::oropQGraphicsView_ViewportUpdateMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQGraphicsView_ViewportUpdateMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQGraphicsView_ViewportUpdateMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_ViewportUpdateMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_ViewportUpdateMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QGraphicsView_ViewportUpdateMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QGraphicsView::ViewportUpdateMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QGraphicsView_ViewportUpdateMode_Enum> decl_QGraphicsView_ViewportUpdateMode_Enum (decl_QGraphicsView_ViewportUpdateMode_Enums, "QGraphicsView_ViewportUpdateMode",
  qt_gsi::mkdefs_QGraphicsView_ViewportUpdateMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QGraphicsView_ViewportUpdateMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QGraphicsView_ViewportUpdateMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQGraphicsView_ViewportUpdateMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QGraphicsView_ViewportUpdateMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QGraphicsView_ViewportUpdateMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QGraphicsView::ViewportUpdateMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QGraphicsView> inject_QGraphicsView_ViewportUpdateMode_Enum_in_parent (qt_gsi::mkdefs_QGraphicsView_ViewportUpdateMode ());
static gsi::ClassExt<QGraphicsView> decl_QGraphicsView_ViewportUpdateMode_Enum_as_child (decl_QGraphicsView_ViewportUpdateMode_Enum, "ViewportUpdateMode");

}

