
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsOpacityEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsOpacityEffect_EventAdaptor.h"
#include "gsiDeclQGraphicsOpacityEffect_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsOpacityEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsOpacityEffect::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// double QGraphicsOpacityEffect::opacity()


static void _init_f_opacity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_opacity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsOpacityEffect *)cls)->opacity ());
}

static qt_gsi::GenericMethod *_create_f_opacity_c0 ()
{
  return new qt_gsi::GenericMethod (":opacity", "@brief Method double QGraphicsOpacityEffect::opacity()\n", true, &_init_f_opacity_c0, &_call_f_opacity_c0);
}

// QBrush QGraphicsOpacityEffect::opacityMask()


static void _init_f_opacityMask_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QBrush > ();
}

static void _call_f_opacityMask_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QBrush > ((QBrush)((QGraphicsOpacityEffect *)cls)->opacityMask ());
}

static qt_gsi::GenericMethod *_create_f_opacityMask_c0 ()
{
  return new qt_gsi::GenericMethod (":opacityMask", "@brief Method QBrush QGraphicsOpacityEffect::opacityMask()\n", true, &_init_f_opacityMask_c0, &_call_f_opacityMask_c0);
}

// void QGraphicsOpacityEffect::setOpacity(double opacity)


static void _init_f_setOpacity_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("opacity");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacity_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsOpacityEffect *)cls)->setOpacity (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOpacity_1071 ()
{
  return new qt_gsi::GenericMethod ("setOpacity|opacity=", "@brief Method void QGraphicsOpacityEffect::setOpacity(double opacity)\n", false, &_init_f_setOpacity_1071, &_call_f_setOpacity_1071);
}

// void QGraphicsOpacityEffect::setOpacityMask(const QBrush &mask)


static void _init_f_setOpacityMask_1910 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mask");
  decl->add_arg<const QBrush & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOpacityMask_1910 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QBrush &arg1 = args.read<const QBrush & > ();
  ((QGraphicsOpacityEffect *)cls)->setOpacityMask (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOpacityMask_1910 ()
{
  return new qt_gsi::GenericMethod ("setOpacityMask|opacityMask=", "@brief Method void QGraphicsOpacityEffect::setOpacityMask(const QBrush &mask)\n", false, &_init_f_setOpacityMask_1910, &_call_f_setOpacityMask_1910);
}

// static QString QGraphicsOpacityEffect::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsOpacityEffect::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsOpacityEffect::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsOpacityEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsOpacityEffect::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsOpacityEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsOpacityEffect::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsOpacityEffect::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsOpacityEffect::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsOpacityEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsOpacityEffect::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsOpacityEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsOpacityEffect, QGraphicsOpacityEffect_EventAdaptor> ea_QGraphicsOpacityEffect;

namespace gsi
{
extern gsi::Class<QGraphicsEffect> decl_QGraphicsEffect;

gsi::Class<QGraphicsOpacityEffect> decl_QGraphicsOpacityEffect (ea_QGraphicsOpacityEffect, decl_QGraphicsEffect, "QGraphicsOpacityEffect_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_opacity_c0 ()) +
  gsi::Methods(_create_f_opacityMask_c0 ()) +
  gsi::Methods(_create_f_setOpacity_1071 ()) +
  gsi::Methods(_create_f_setOpacityMask_1910 ()) +
  qt_gsi::qt_signal<QGraphicsOpacityEffect, QGraphicsOpacityEffect_EventAdaptor, QObject *> ("destroyed", &QGraphicsOpacityEffect_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsOpacityEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsOpacityEffect, QGraphicsOpacityEffect_EventAdaptor, bool> ("enabledChanged", &QGraphicsOpacityEffect_EventAdaptor::enabledChanged_e_864, gsi::arg("enabled"), "@brief Signal declaration for QGraphicsOpacityEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsOpacityEffect, QGraphicsOpacityEffect_EventAdaptor, double> ("opacityChanged", &QGraphicsOpacityEffect_EventAdaptor::opacityChanged_e_1071, gsi::arg("opacity"), "@brief Signal declaration for QGraphicsOpacityEffect::opacityChanged(double opacity)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsOpacityEffect, QGraphicsOpacityEffect_EventAdaptor, const QBrush &> ("opacityMaskChanged", &QGraphicsOpacityEffect_EventAdaptor::opacityMaskChanged_e_1910, gsi::arg("mask"), "@brief Signal declaration for QGraphicsOpacityEffect::opacityMaskChanged(const QBrush &mask)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsOpacityEffect");
}


class QGraphicsOpacityEffect_Adaptor : public QGraphicsOpacityEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsOpacityEffect_Adaptor();

  //  [adaptor ctor] QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent)
  QGraphicsOpacityEffect_Adaptor() : QGraphicsOpacityEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent)
  QGraphicsOpacityEffect_Adaptor(QObject *parent) : QGraphicsOpacityEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsOpacityEffect::drawSource(QPainter *painter)
  void fp_QGraphicsOpacityEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsOpacityEffect::drawSource(painter);
  }

  //  int QGraphicsOpacityEffect::receivers(const char *signal)
  int fp_QGraphicsOpacityEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsOpacityEffect::receivers(signal);
  }

  //  QObject *QGraphicsOpacityEffect::sender()
  QObject * fp_QGraphicsOpacityEffect_sender_c0 () const {
    return QGraphicsOpacityEffect::sender();
  }

  //  QRectF QGraphicsOpacityEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsOpacityEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsOpacityEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  bool QGraphicsOpacityEffect::sourceIsPixmap()
  bool fp_QGraphicsOpacityEffect_sourceIsPixmap_c0 () const {
    return QGraphicsOpacityEffect::sourceIsPixmap();
  }

  //  QPixmap QGraphicsOpacityEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsOpacityEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsOpacityEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  void QGraphicsOpacityEffect::updateBoundingRect()
  void fp_QGraphicsOpacityEffect_updateBoundingRect_0 () {
    QGraphicsOpacityEffect::updateBoundingRect();
  }

  //  [adaptor impl] QRectF QGraphicsOpacityEffect::boundingRectFor(const QRectF &sourceRect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &sourceRect) const
  {
    return QGraphicsOpacityEffect::boundingRectFor(sourceRect);
  }

  virtual QRectF boundingRectFor(const QRectF &sourceRect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsOpacityEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsOpacityEffect_Adaptor::cbs_boundingRectFor_c1862_0, sourceRect);
    } else {
      return QGraphicsOpacityEffect::boundingRectFor(sourceRect);
    }
  }

  //  [adaptor impl] bool QGraphicsOpacityEffect::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGraphicsOpacityEffect::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsOpacityEffect_Adaptor, bool, QEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGraphicsOpacityEffect::event(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsOpacityEffect::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsOpacityEffect::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsOpacityEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsOpacityEffect::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsOpacityEffect::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsOpacityEffect_Adaptor, QChildEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsOpacityEffect::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsOpacityEffect::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsOpacityEffect_Adaptor, QEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsOpacityEffect::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsOpacityEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsOpacityEffect_Adaptor, const char *>(&QGraphicsOpacityEffect_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsOpacityEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    QGraphicsOpacityEffect::draw(painter);
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsOpacityEffect_Adaptor, QPainter *>(&QGraphicsOpacityEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      QGraphicsOpacityEffect::draw(painter);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & flags)
  {
    QGraphicsOpacityEffect::sourceChanged(qt_gsi::QtToCppAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags).cref());
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsOpacityEffect_Adaptor, const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type &>(&QGraphicsOpacityEffect_Adaptor::cbs_sourceChanged_3695_0, qt_gsi::CppToQtAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags));
    } else {
      QGraphicsOpacityEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsOpacityEffect::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsOpacityEffect::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsOpacityEffect_Adaptor, QTimerEvent *>(&QGraphicsOpacityEffect_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsOpacityEffect::timerEvent(arg1);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsOpacityEffect_Adaptor::~QGraphicsOpacityEffect_Adaptor() { }

//  Constructor QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsOpacityEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsOpacityEffect_Adaptor *> ();
}

static void _call_ctor_QGraphicsOpacityEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsOpacityEffect_Adaptor *> (new QGraphicsOpacityEffect_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsOpacityEffect_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsOpacityEffect::QGraphicsOpacityEffect(QObject *parent)\nThis method creates an object of class QGraphicsOpacityEffect.", &_init_ctor_QGraphicsOpacityEffect_Adaptor_1302, &_call_ctor_QGraphicsOpacityEffect_Adaptor_1302);
}

// void QGraphicsOpacityEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_drawSource_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawSource_1426 ()
{
  return new qt_gsi::GenericMethod("*drawSource", "@brief Method void QGraphicsOpacityEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
}


// int QGraphicsOpacityEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsOpacityEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QGraphicsOpacityEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsOpacityEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QRectF QGraphicsOpacityEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  ret.write<QRectF > ((QRectF)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sourceBoundingRect_c2426 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_sourceBoundingRect_c2426 ()
{
  return new qt_gsi::GenericMethod("*sourceBoundingRect", "@brief Method QRectF QGraphicsOpacityEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
}


// bool QGraphicsOpacityEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sourceIsPixmap_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sourceIsPixmap_c0 ()
{
  return new qt_gsi::GenericMethod("*sourceIsPixmap", "@brief Method bool QGraphicsOpacityEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
}


// QPixmap QGraphicsOpacityEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  QPoint *arg2 = args ? args.read<QPoint * > () : (QPoint *)(0);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > () : (const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect));
  ret.write<QPixmap > ((QPixmap)((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_sourcePixmap_c6763 ()
{
  return new qt_gsi::GenericMethod("*sourcePixmap", "@brief Method QPixmap QGraphicsOpacityEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
}


// void QGraphicsOpacityEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->fp_QGraphicsOpacityEffect_updateBoundingRect_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateBoundingRect_0 ()
{
  return new qt_gsi::GenericMethod("*updateBoundingRect", "@brief Method void QGraphicsOpacityEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
}


// QRectF QGraphicsOpacityEffect::boundingRectFor(const QRectF &sourceRect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsOpacityEffect::boundingRectFor(const QRectF &sourceRect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
}


// bool QGraphicsOpacityEffect::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsOpacityEffect::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsOpacityEffect::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsOpacityEffect::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsOpacityEffect::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsOpacityEffect::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsOpacityEffect::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsOpacityEffect::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsOpacityEffect::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsOpacityEffect::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsOpacityEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsOpacityEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
}


// void QGraphicsOpacityEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsOpacityEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
}


// void QGraphicsOpacityEffect::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsOpacityEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsOpacityEffect::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsOpacityEffect> decl_QGraphicsOpacityEffect;

gsi::Class<QGraphicsOpacityEffect_Adaptor> decl_QGraphicsOpacityEffect_Adaptor (decl_QGraphicsOpacityEffect, "QGraphicsOpacityEffect",
  gsi::Methods(_create_fp_drawSource_1426 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_sourceBoundingRect_c2426 ()) +
  gsi::Methods(_create_fp_sourceIsPixmap_c0 ()) +
  gsi::Methods(_create_fp_sourcePixmap_c6763 ()) +
  gsi::Methods(_create_fp_updateBoundingRect_0 ()) +
  gsi::Methods(_create_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_callback_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsOpacityEffect_Adaptor_1302 ()),
  "@qt\n@brief Binding of QGraphicsOpacityEffect");

}

