
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQGraphicsColorizeEffect.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQGraphicsColorizeEffect_EventAdaptor.h"
#include "gsiDeclQGraphicsColorizeEffect_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QGraphicsColorizeEffect

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QGraphicsColorizeEffect::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// QColor QGraphicsColorizeEffect::color()


static void _init_f_color_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QColor > ();
}

static void _call_f_color_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QColor > ((QColor)((QGraphicsColorizeEffect *)cls)->color ());
}

static qt_gsi::GenericMethod *_create_f_color_c0 ()
{
  return new qt_gsi::GenericMethod (":color", "@brief Method QColor QGraphicsColorizeEffect::color()\n", true, &_init_f_color_c0, &_call_f_color_c0);
}

// void QGraphicsColorizeEffect::setColor(const QColor &c)


static void _init_f_setColor_1905 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("c");
  decl->add_arg<const QColor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColor_1905 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QColor &arg1 = args.read<const QColor & > ();
  ((QGraphicsColorizeEffect *)cls)->setColor (arg1);
}

static qt_gsi::GenericMethod *_create_f_setColor_1905 ()
{
  return new qt_gsi::GenericMethod ("setColor|color=", "@brief Method void QGraphicsColorizeEffect::setColor(const QColor &c)\n", false, &_init_f_setColor_1905, &_call_f_setColor_1905);
}

// void QGraphicsColorizeEffect::setStrength(double strength)


static void _init_f_setStrength_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("strength");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStrength_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QGraphicsColorizeEffect *)cls)->setStrength (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStrength_1071 ()
{
  return new qt_gsi::GenericMethod ("setStrength|strength=", "@brief Method void QGraphicsColorizeEffect::setStrength(double strength)\n", false, &_init_f_setStrength_1071, &_call_f_setStrength_1071);
}

// double QGraphicsColorizeEffect::strength()


static void _init_f_strength_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_strength_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QGraphicsColorizeEffect *)cls)->strength ());
}

static qt_gsi::GenericMethod *_create_f_strength_c0 ()
{
  return new qt_gsi::GenericMethod (":strength", "@brief Method double QGraphicsColorizeEffect::strength()\n", true, &_init_f_strength_c0, &_call_f_strength_c0);
}

// static QString QGraphicsColorizeEffect::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsColorizeEffect::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsColorizeEffect::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QGraphicsColorizeEffect::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsColorizeEffect::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QGraphicsColorizeEffect::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QGraphicsColorizeEffect::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QGraphicsColorizeEffect::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsColorizeEffect::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QGraphicsColorizeEffect::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QGraphicsColorizeEffect::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QGraphicsColorizeEffect::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QGraphicsColorizeEffect, QGraphicsColorizeEffect_EventAdaptor> ea_QGraphicsColorizeEffect;

namespace gsi
{
extern gsi::Class<QGraphicsEffect> decl_QGraphicsEffect;

gsi::Class<QGraphicsColorizeEffect> decl_QGraphicsColorizeEffect (ea_QGraphicsColorizeEffect, decl_QGraphicsEffect, "QGraphicsColorizeEffect_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_color_c0 ()) +
  gsi::Methods(_create_f_setColor_1905 ()) +
  gsi::Methods(_create_f_setStrength_1071 ()) +
  gsi::Methods(_create_f_strength_c0 ()) +
  qt_gsi::qt_signal<QGraphicsColorizeEffect, QGraphicsColorizeEffect_EventAdaptor, const QColor &> ("colorChanged", &QGraphicsColorizeEffect_EventAdaptor::colorChanged_e_1905, gsi::arg("color"), "@brief Signal declaration for QGraphicsColorizeEffect::colorChanged(const QColor &color)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsColorizeEffect, QGraphicsColorizeEffect_EventAdaptor, QObject *> ("destroyed", &QGraphicsColorizeEffect_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QGraphicsColorizeEffect::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsColorizeEffect, QGraphicsColorizeEffect_EventAdaptor, bool> ("enabledChanged", &QGraphicsColorizeEffect_EventAdaptor::enabledChanged_e_864, gsi::arg("enabled"), "@brief Signal declaration for QGraphicsColorizeEffect::enabledChanged(bool enabled)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QGraphicsColorizeEffect, QGraphicsColorizeEffect_EventAdaptor, double> ("strengthChanged", &QGraphicsColorizeEffect_EventAdaptor::strengthChanged_e_1071, gsi::arg("strength"), "@brief Signal declaration for QGraphicsColorizeEffect::strengthChanged(double strength)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QGraphicsColorizeEffect");
}


class QGraphicsColorizeEffect_Adaptor : public QGraphicsColorizeEffect, public qt_gsi::QtObjectBase
{
public:

  virtual ~QGraphicsColorizeEffect_Adaptor();

  //  [adaptor ctor] QGraphicsColorizeEffect::QGraphicsColorizeEffect(QObject *parent)
  QGraphicsColorizeEffect_Adaptor() : QGraphicsColorizeEffect()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QGraphicsColorizeEffect::QGraphicsColorizeEffect(QObject *parent)
  QGraphicsColorizeEffect_Adaptor(QObject *parent) : QGraphicsColorizeEffect(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QGraphicsColorizeEffect::drawSource(QPainter *painter)
  void fp_QGraphicsColorizeEffect_drawSource_1426 (QPainter *painter) {
    QGraphicsColorizeEffect::drawSource(painter);
  }

  //  int QGraphicsColorizeEffect::receivers(const char *signal)
  int fp_QGraphicsColorizeEffect_receivers_c1731 (const char *signal) const {
    return QGraphicsColorizeEffect::receivers(signal);
  }

  //  QObject *QGraphicsColorizeEffect::sender()
  QObject * fp_QGraphicsColorizeEffect_sender_c0 () const {
    return QGraphicsColorizeEffect::sender();
  }

  //  QRectF QGraphicsColorizeEffect::sourceBoundingRect(Qt::CoordinateSystem system)
  QRectF fp_QGraphicsColorizeEffect_sourceBoundingRect_c2426 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system) const {
    return QGraphicsColorizeEffect::sourceBoundingRect(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref());
  }

  //  bool QGraphicsColorizeEffect::sourceIsPixmap()
  bool fp_QGraphicsColorizeEffect_sourceIsPixmap_c0 () const {
    return QGraphicsColorizeEffect::sourceIsPixmap();
  }

  //  QPixmap QGraphicsColorizeEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)
  QPixmap fp_QGraphicsColorizeEffect_sourcePixmap_c6763 (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & system, QPoint *offset, const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & mode) const {
    return QGraphicsColorizeEffect::sourcePixmap(qt_gsi::QtToCppAdaptor<Qt::CoordinateSystem>(system).cref(), offset, qt_gsi::QtToCppAdaptor<QGraphicsEffect::PixmapPadMode>(mode).cref());
  }

  //  void QGraphicsColorizeEffect::updateBoundingRect()
  void fp_QGraphicsColorizeEffect_updateBoundingRect_0 () {
    QGraphicsColorizeEffect::updateBoundingRect();
  }

  //  [adaptor impl] QRectF QGraphicsColorizeEffect::boundingRectFor(const QRectF &sourceRect)
  QRectF cbs_boundingRectFor_c1862_0(const QRectF &sourceRect) const
  {
    return QGraphicsColorizeEffect::boundingRectFor(sourceRect);
  }

  virtual QRectF boundingRectFor(const QRectF &sourceRect) const
  {
    if (cb_boundingRectFor_c1862_0.can_issue()) {
      return cb_boundingRectFor_c1862_0.issue<QGraphicsColorizeEffect_Adaptor, QRectF, const QRectF &>(&QGraphicsColorizeEffect_Adaptor::cbs_boundingRectFor_c1862_0, sourceRect);
    } else {
      return QGraphicsColorizeEffect::boundingRectFor(sourceRect);
    }
  }

  //  [adaptor impl] bool QGraphicsColorizeEffect::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QGraphicsColorizeEffect::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QGraphicsColorizeEffect_Adaptor, bool, QEvent *>(&QGraphicsColorizeEffect_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QGraphicsColorizeEffect::event(arg1);
    }
  }

  //  [adaptor impl] bool QGraphicsColorizeEffect::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QGraphicsColorizeEffect::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QGraphicsColorizeEffect_Adaptor, bool, QObject *, QEvent *>(&QGraphicsColorizeEffect_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QGraphicsColorizeEffect::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QGraphicsColorizeEffect::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QGraphicsColorizeEffect::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QGraphicsColorizeEffect_Adaptor, QChildEvent *>(&QGraphicsColorizeEffect_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QGraphicsColorizeEffect::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsColorizeEffect::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QGraphicsColorizeEffect::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QGraphicsColorizeEffect_Adaptor, QEvent *>(&QGraphicsColorizeEffect_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QGraphicsColorizeEffect::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QGraphicsColorizeEffect::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QGraphicsColorizeEffect::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QGraphicsColorizeEffect_Adaptor, const char *>(&QGraphicsColorizeEffect_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QGraphicsColorizeEffect::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QGraphicsColorizeEffect::draw(QPainter *painter)
  void cbs_draw_1426_0(QPainter *painter)
  {
    QGraphicsColorizeEffect::draw(painter);
  }

  virtual void draw(QPainter *painter)
  {
    if (cb_draw_1426_0.can_issue()) {
      cb_draw_1426_0.issue<QGraphicsColorizeEffect_Adaptor, QPainter *>(&QGraphicsColorizeEffect_Adaptor::cbs_draw_1426_0, painter);
    } else {
      QGraphicsColorizeEffect::draw(painter);
    }
  }

  //  [adaptor impl] void QGraphicsColorizeEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  void cbs_sourceChanged_3695_0(const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & flags)
  {
    QGraphicsColorizeEffect::sourceChanged(qt_gsi::QtToCppAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags).cref());
  }

  virtual void sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)
  {
    if (cb_sourceChanged_3695_0.can_issue()) {
      cb_sourceChanged_3695_0.issue<QGraphicsColorizeEffect_Adaptor, const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type &>(&QGraphicsColorizeEffect_Adaptor::cbs_sourceChanged_3695_0, qt_gsi::CppToQtAdaptor<QFlags<QGraphicsEffect::ChangeFlag> >(flags));
    } else {
      QGraphicsColorizeEffect::sourceChanged(flags);
    }
  }

  //  [adaptor impl] void QGraphicsColorizeEffect::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QGraphicsColorizeEffect::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QGraphicsColorizeEffect_Adaptor, QTimerEvent *>(&QGraphicsColorizeEffect_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QGraphicsColorizeEffect::timerEvent(arg1);
    }
  }

  gsi::Callback cb_boundingRectFor_c1862_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_draw_1426_0;
  gsi::Callback cb_sourceChanged_3695_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QGraphicsColorizeEffect_Adaptor::~QGraphicsColorizeEffect_Adaptor() { }

//  Constructor QGraphicsColorizeEffect::QGraphicsColorizeEffect(QObject *parent) (adaptor class)

static void _init_ctor_QGraphicsColorizeEffect_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QGraphicsColorizeEffect_Adaptor *> ();
}

static void _call_ctor_QGraphicsColorizeEffect_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QGraphicsColorizeEffect_Adaptor *> (new QGraphicsColorizeEffect_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QGraphicsColorizeEffect_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QGraphicsColorizeEffect::QGraphicsColorizeEffect(QObject *parent)\nThis method creates an object of class QGraphicsColorizeEffect.", &_init_ctor_QGraphicsColorizeEffect_Adaptor_1302, &_call_ctor_QGraphicsColorizeEffect_Adaptor_1302);
}

// void QGraphicsColorizeEffect::drawSource(QPainter *painter)

static void _init_fp_drawSource_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_drawSource_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_drawSource_1426 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_drawSource_1426 ()
{
  return new qt_gsi::GenericMethod("*drawSource", "@brief Method void QGraphicsColorizeEffect::drawSource(QPainter *painter)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_drawSource_1426, &_call_fp_drawSource_1426);
}


// int QGraphicsColorizeEffect::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QGraphicsColorizeEffect::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QGraphicsColorizeEffect::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QGraphicsColorizeEffect::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QRectF QGraphicsColorizeEffect::sourceBoundingRect(Qt::CoordinateSystem system)

static void _init_fp_sourceBoundingRect_c2426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_fp_sourceBoundingRect_c2426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  ret.write<QRectF > ((QRectF)((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_sourceBoundingRect_c2426 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_sourceBoundingRect_c2426 ()
{
  return new qt_gsi::GenericMethod("*sourceBoundingRect", "@brief Method QRectF QGraphicsColorizeEffect::sourceBoundingRect(Qt::CoordinateSystem system)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceBoundingRect_c2426, &_call_fp_sourceBoundingRect_c2426);
}


// bool QGraphicsColorizeEffect::sourceIsPixmap()

static void _init_fp_sourceIsPixmap_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_sourceIsPixmap_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_sourceIsPixmap_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sourceIsPixmap_c0 ()
{
  return new qt_gsi::GenericMethod("*sourceIsPixmap", "@brief Method bool QGraphicsColorizeEffect::sourceIsPixmap()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourceIsPixmap_c0, &_call_fp_sourceIsPixmap_c0);
}


// QPixmap QGraphicsColorizeEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)

static void _init_fp_sourcePixmap_c6763 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("system", true, "Qt::LogicalCoordinates");
  decl->add_arg<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("offset", true, "0");
  decl->add_arg<QPoint * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("mode", true, "QGraphicsEffect::PadToEffectiveBoundingRect");
  decl->add_arg<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > (argspec_2);
  decl->set_return<QPixmap > ();
}

static void _call_fp_sourcePixmap_c6763 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<Qt::CoordinateSystem>::target_type & > () : (const qt_gsi::Converter<Qt::CoordinateSystem>::target_type &)(qt_gsi::CppToQtReadAdaptor<Qt::CoordinateSystem>(heap, Qt::LogicalCoordinates));
  QPoint *arg2 = args ? args.read<QPoint * > () : (QPoint *)(0);
  const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type & > () : (const qt_gsi::Converter<QGraphicsEffect::PixmapPadMode>::target_type &)(qt_gsi::CppToQtReadAdaptor<QGraphicsEffect::PixmapPadMode>(heap, QGraphicsEffect::PadToEffectiveBoundingRect));
  ret.write<QPixmap > ((QPixmap)((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_sourcePixmap_c6763 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_sourcePixmap_c6763 ()
{
  return new qt_gsi::GenericMethod("*sourcePixmap", "@brief Method QPixmap QGraphicsColorizeEffect::sourcePixmap(Qt::CoordinateSystem system, QPoint *offset, QGraphicsEffect::PixmapPadMode mode)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sourcePixmap_c6763, &_call_fp_sourcePixmap_c6763);
}


// void QGraphicsColorizeEffect::updateBoundingRect()

static void _init_fp_updateBoundingRect_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateBoundingRect_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->fp_QGraphicsColorizeEffect_updateBoundingRect_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateBoundingRect_0 ()
{
  return new qt_gsi::GenericMethod("*updateBoundingRect", "@brief Method void QGraphicsColorizeEffect::updateBoundingRect()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateBoundingRect_0, &_call_fp_updateBoundingRect_0);
}


// QRectF QGraphicsColorizeEffect::boundingRectFor(const QRectF &sourceRect)

static void _init_cbs_boundingRectFor_c1862_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceRect");
  decl->add_arg<const QRectF & > (argspec_0);
  decl->set_return<QRectF > ();
}

static void _call_cbs_boundingRectFor_c1862_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRectF &arg1 = args.read<const QRectF & > ();
  ret.write<QRectF > ((QRectF)((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_boundingRectFor_c1862_0 (arg1));
}

static void _set_callback_cbs_boundingRectFor_c1862_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_boundingRectFor_c1862_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@hide", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_boundingRectFor_c1862_0 ()
{
  return new qt_gsi::GenericMethod ("boundingRectFor", "@brief Virtual method QRectF QGraphicsColorizeEffect::boundingRectFor(const QRectF &sourceRect)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_boundingRectFor_c1862_0, &_call_cbs_boundingRectFor_c1862_0, &_set_callback_cbs_boundingRectFor_c1862_0);
}


// bool QGraphicsColorizeEffect::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QGraphicsColorizeEffect::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QGraphicsColorizeEffect::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QGraphicsColorizeEffect::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QGraphicsColorizeEffect::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QGraphicsColorizeEffect::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QGraphicsColorizeEffect::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QGraphicsColorizeEffect::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QGraphicsColorizeEffect::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QGraphicsColorizeEffect::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QGraphicsColorizeEffect::draw(QPainter *painter)

static void _init_cbs_draw_1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_draw_1426_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_draw_1426_0 (arg1);
}

static void _set_callback_cbs_draw_1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_draw_1426_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@hide", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_draw_1426_0 ()
{
  return new qt_gsi::GenericMethod ("*draw", "@brief Virtual method void QGraphicsColorizeEffect::draw(QPainter *painter)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_draw_1426_0, &_call_cbs_draw_1426_0, &_set_callback_cbs_draw_1426_0);
}


// void QGraphicsColorizeEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)

static void _init_cbs_sourceChanged_3695_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_sourceChanged_3695_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & arg1 = args.read<const qt_gsi::Converter<QFlags<QGraphicsEffect::ChangeFlag> >::target_type & > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_sourceChanged_3695_0 (arg1);
}

static void _set_callback_cbs_sourceChanged_3695_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_sourceChanged_3695_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@hide", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sourceChanged_3695_0 ()
{
  return new qt_gsi::GenericMethod ("*sourceChanged", "@brief Virtual method void QGraphicsColorizeEffect::sourceChanged(QFlags<QGraphicsEffect::ChangeFlag> flags)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sourceChanged_3695_0, &_call_cbs_sourceChanged_3695_0, &_set_callback_cbs_sourceChanged_3695_0);
}


// void QGraphicsColorizeEffect::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QGraphicsColorizeEffect_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QGraphicsColorizeEffect::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QGraphicsColorizeEffect> decl_QGraphicsColorizeEffect;

gsi::Class<QGraphicsColorizeEffect_Adaptor> decl_QGraphicsColorizeEffect_Adaptor (decl_QGraphicsColorizeEffect, "QGraphicsColorizeEffect",
  gsi::Methods(_create_fp_drawSource_1426 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_sourceBoundingRect_c2426 ()) +
  gsi::Methods(_create_fp_sourceIsPixmap_c0 ()) +
  gsi::Methods(_create_fp_sourcePixmap_c6763 ()) +
  gsi::Methods(_create_fp_updateBoundingRect_0 ()) +
  gsi::Methods(_create_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_callback_cbs_boundingRectFor_c1862_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_callback_cbs_draw_1426_0 ()) +
  gsi::Methods(_create_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_callback_cbs_sourceChanged_3695_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QGraphicsColorizeEffect_Adaptor_1302 ()),
  "@qt\n@brief Binding of QGraphicsColorizeEffect");

}

