
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFtp.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtNetwork.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQFtp_EventAdaptor.h"
#include "gsiDeclQFtp_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFtp

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFtp::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QFtp::abort()


static void _init_f_abort_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_abort_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFtp *)cls)->abort ();
}

static qt_gsi::GenericMethod *_create_f_abort_0 ()
{
  return new qt_gsi::GenericMethod ("abort", "@brief Method void QFtp::abort()\n", false, &_init_f_abort_0, &_call_f_abort_0);
}

// qint64 QFtp::bytesAvailable()


static void _init_f_bytesAvailable_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_bytesAvailable_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qint64 > ((qint64)((QFtp *)cls)->bytesAvailable ());
}

static qt_gsi::GenericMethod *_create_f_bytesAvailable_c0 ()
{
  return new qt_gsi::GenericMethod ("bytesAvailable", "@brief Method qint64 QFtp::bytesAvailable()\n", true, &_init_f_bytesAvailable_c0, &_call_f_bytesAvailable_c0);
}

// int QFtp::cd(const QString &dir)


static void _init_f_cd_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_cd_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QFtp *)cls)->cd (arg1));
}

static qt_gsi::GenericMethod *_create_f_cd_2025 ()
{
  return new qt_gsi::GenericMethod ("cd", "@brief Method int QFtp::cd(const QString &dir)\n", false, &_init_f_cd_2025, &_call_f_cd_2025);
}

// void QFtp::clearPendingCommands()


static void _init_f_clearPendingCommands_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clearPendingCommands_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QFtp *)cls)->clearPendingCommands ();
}

static qt_gsi::GenericMethod *_create_f_clearPendingCommands_0 ()
{
  return new qt_gsi::GenericMethod ("clearPendingCommands", "@brief Method void QFtp::clearPendingCommands()\n", false, &_init_f_clearPendingCommands_0, &_call_f_clearPendingCommands_0);
}

// int QFtp::close()


static void _init_f_close_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_close_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFtp *)cls)->close ());
}

static qt_gsi::GenericMethod *_create_f_close_0 ()
{
  return new qt_gsi::GenericMethod ("close", "@brief Method int QFtp::close()\n", false, &_init_f_close_0, &_call_f_close_0);
}

// int QFtp::connectToHost(const QString &host, quint16 port)


static void _init_f_connectToHost_3017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port", true, "21");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_connectToHost_3017 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  quint16 arg2 = args ? args.read<quint16 > () : (quint16)(21);
  ret.write<int > ((int)((QFtp *)cls)->connectToHost (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_connectToHost_3017 ()
{
  return new qt_gsi::GenericMethod ("connectToHost", "@brief Method int QFtp::connectToHost(const QString &host, quint16 port)\n", false, &_init_f_connectToHost_3017, &_call_f_connectToHost_3017);
}

// QFtp::Command QFtp::currentCommand()


static void _init_f_currentCommand_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFtp::Command>::target_type > ();
}

static void _call_f_currentCommand_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFtp::Command>::target_type > ((qt_gsi::Converter<QFtp::Command>::target_type)qt_gsi::CppToQtAdaptor<QFtp::Command>(((QFtp *)cls)->currentCommand ()));
}

static qt_gsi::GenericMethod *_create_f_currentCommand_c0 ()
{
  return new qt_gsi::GenericMethod ("currentCommand", "@brief Method QFtp::Command QFtp::currentCommand()\n", true, &_init_f_currentCommand_c0, &_call_f_currentCommand_c0);
}

// QIODevice *QFtp::currentDevice()


static void _init_f_currentDevice_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_currentDevice_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QFtp *)cls)->currentDevice ());
}

static qt_gsi::GenericMethod *_create_f_currentDevice_c0 ()
{
  return new qt_gsi::GenericMethod ("currentDevice", "@brief Method QIODevice *QFtp::currentDevice()\n", true, &_init_f_currentDevice_c0, &_call_f_currentDevice_c0);
}

// int QFtp::currentId()


static void _init_f_currentId_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_currentId_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QFtp *)cls)->currentId ());
}

static qt_gsi::GenericMethod *_create_f_currentId_c0 ()
{
  return new qt_gsi::GenericMethod ("currentId", "@brief Method int QFtp::currentId()\n", true, &_init_f_currentId_c0, &_call_f_currentId_c0);
}

// QFtp::Error QFtp::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFtp::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFtp::Error>::target_type > ((qt_gsi::Converter<QFtp::Error>::target_type)qt_gsi::CppToQtAdaptor<QFtp::Error>(((QFtp *)cls)->error ()));
}

static qt_gsi::GenericMethod *_create_f_error_c0 ()
{
  return new qt_gsi::GenericMethod ("error", "@brief Method QFtp::Error QFtp::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
}

// QString QFtp::errorString()


static void _init_f_errorString_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_errorString_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QFtp *)cls)->errorString ());
}

static qt_gsi::GenericMethod *_create_f_errorString_c0 ()
{
  return new qt_gsi::GenericMethod ("errorString", "@brief Method QString QFtp::errorString()\n", true, &_init_f_errorString_c0, &_call_f_errorString_c0);
}

// int QFtp::get(const QString &file, QIODevice *dev, QFtp::TransferType type)


static void _init_f_get_5442 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("dev", true, "0");
  decl->add_arg<QIODevice * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QFtp::Binary");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferType>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_get_5442 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QIODevice *arg2 = args ? args.read<QIODevice * > () : (QIODevice *)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFtp::TransferType>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFtp::TransferType>::target_type & > () : (const qt_gsi::Converter<QFtp::TransferType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFtp::TransferType>(heap, QFtp::Binary));
  ret.write<int > ((int)((QFtp *)cls)->get (arg1, arg2, qt_gsi::QtToCppAdaptor<QFtp::TransferType>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_get_5442 ()
{
  return new qt_gsi::GenericMethod ("get", "@brief Method int QFtp::get(const QString &file, QIODevice *dev, QFtp::TransferType type)\n", false, &_init_f_get_5442, &_call_f_get_5442);
}

// bool QFtp::hasPendingCommands()


static void _init_f_hasPendingCommands_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasPendingCommands_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QFtp *)cls)->hasPendingCommands ());
}

static qt_gsi::GenericMethod *_create_f_hasPendingCommands_c0 ()
{
  return new qt_gsi::GenericMethod ("hasPendingCommands", "@brief Method bool QFtp::hasPendingCommands()\n", true, &_init_f_hasPendingCommands_c0, &_call_f_hasPendingCommands_c0);
}

// int QFtp::list(const QString &dir)


static void _init_f_list_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_list_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<int > ((int)((QFtp *)cls)->list (arg1));
}

static qt_gsi::GenericMethod *_create_f_list_2025 ()
{
  return new qt_gsi::GenericMethod ("list", "@brief Method int QFtp::list(const QString &dir)\n", false, &_init_f_list_2025, &_call_f_list_2025);
}

// int QFtp::login(const QString &user, const QString &password)


static void _init_f_login_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("user", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("password", true, "QString()");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_login_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  const QString &arg2 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<int > ((int)((QFtp *)cls)->login (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_login_3942 ()
{
  return new qt_gsi::GenericMethod ("login", "@brief Method int QFtp::login(const QString &user, const QString &password)\n", false, &_init_f_login_3942, &_call_f_login_3942);
}

// int QFtp::mkdir(const QString &dir)


static void _init_f_mkdir_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_mkdir_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QFtp *)cls)->mkdir (arg1));
}

static qt_gsi::GenericMethod *_create_f_mkdir_2025 ()
{
  return new qt_gsi::GenericMethod ("mkdir", "@brief Method int QFtp::mkdir(const QString &dir)\n", false, &_init_f_mkdir_2025, &_call_f_mkdir_2025);
}

// int QFtp::put(const QByteArray &data, const QString &file, QFtp::TransferType type)


static void _init_f_put_6304 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("file");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QFtp::Binary");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferType>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_put_6304 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const QString &arg2 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFtp::TransferType>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFtp::TransferType>::target_type & > () : (const qt_gsi::Converter<QFtp::TransferType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFtp::TransferType>(heap, QFtp::Binary));
  ret.write<int > ((int)((QFtp *)cls)->put (arg1, arg2, qt_gsi::QtToCppAdaptor<QFtp::TransferType>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_put_6304 ()
{
  return new qt_gsi::GenericMethod ("put", "@brief Method int QFtp::put(const QByteArray &data, const QString &file, QFtp::TransferType type)\n", false, &_init_f_put_6304, &_call_f_put_6304);
}

// int QFtp::put(QIODevice *dev, const QString &file, QFtp::TransferType type)


static void _init_f_put_5442 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dev");
  decl->add_arg<QIODevice * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("file");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("type", true, "QFtp::Binary");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferType>::target_type & > (argspec_2);
  decl->set_return<int > ();
}

static void _call_f_put_5442 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  const QString &arg2 = args.read<const QString & > ();
  tl::Heap heap;
  const qt_gsi::Converter<QFtp::TransferType>::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFtp::TransferType>::target_type & > () : (const qt_gsi::Converter<QFtp::TransferType>::target_type &)(qt_gsi::CppToQtReadAdaptor<QFtp::TransferType>(heap, QFtp::Binary));
  ret.write<int > ((int)((QFtp *)cls)->put (arg1, arg2, qt_gsi::QtToCppAdaptor<QFtp::TransferType>(arg3).cref()));
}

static qt_gsi::GenericMethod *_create_f_put_5442 ()
{
  return new qt_gsi::GenericMethod ("put", "@brief Method int QFtp::put(QIODevice *dev, const QString &file, QFtp::TransferType type)\n", false, &_init_f_put_5442, &_call_f_put_5442);
}

// int QFtp::rawCommand(const QString &command)


static void _init_f_rawCommand_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("command");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rawCommand_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QFtp *)cls)->rawCommand (arg1));
}

static qt_gsi::GenericMethod *_create_f_rawCommand_2025 ()
{
  return new qt_gsi::GenericMethod ("rawCommand", "@brief Method int QFtp::rawCommand(const QString &command)\n", false, &_init_f_rawCommand_2025, &_call_f_rawCommand_2025);
}

// QByteArray QFtp::readAll()


static void _init_f_readAll_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_readAll_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QFtp *)cls)->readAll ());
}

static qt_gsi::GenericMethod *_create_f_readAll_0 ()
{
  return new qt_gsi::GenericMethod ("readAll", "@brief Method QByteArray QFtp::readAll()\n", false, &_init_f_readAll_0, &_call_f_readAll_0);
}

// int QFtp::remove(const QString &file)


static void _init_f_remove_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("file");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_remove_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QFtp *)cls)->remove (arg1));
}

static qt_gsi::GenericMethod *_create_f_remove_2025 ()
{
  return new qt_gsi::GenericMethod ("remove", "@brief Method int QFtp::remove(const QString &file)\n", false, &_init_f_remove_2025, &_call_f_remove_2025);
}

// int QFtp::rename(const QString &oldname, const QString &newname)


static void _init_f_rename_3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldname");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("newname");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_rename_3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<int > ((int)((QFtp *)cls)->rename (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_rename_3942 ()
{
  return new qt_gsi::GenericMethod ("rename", "@brief Method int QFtp::rename(const QString &oldname, const QString &newname)\n", false, &_init_f_rename_3942, &_call_f_rename_3942);
}

// int QFtp::rmdir(const QString &dir)


static void _init_f_rmdir_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dir");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_rmdir_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<int > ((int)((QFtp *)cls)->rmdir (arg1));
}

static qt_gsi::GenericMethod *_create_f_rmdir_2025 ()
{
  return new qt_gsi::GenericMethod ("rmdir", "@brief Method int QFtp::rmdir(const QString &dir)\n", false, &_init_f_rmdir_2025, &_call_f_rmdir_2025);
}

// int QFtp::setProxy(const QString &host, quint16 port)


static void _init_f_setProxy_3017 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("host");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("port");
  decl->add_arg<quint16 > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_setProxy_3017 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  quint16 arg2 = args.read<quint16 > ();
  ret.write<int > ((int)((QFtp *)cls)->setProxy (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_setProxy_3017 ()
{
  return new qt_gsi::GenericMethod ("setProxy", "@brief Method int QFtp::setProxy(const QString &host, quint16 port)\n", false, &_init_f_setProxy_3017, &_call_f_setProxy_3017);
}

// int QFtp::setTransferMode(QFtp::TransferMode mode)


static void _init_f_setTransferMode_2157 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QFtp::TransferMode>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_setTransferMode_2157 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QFtp::TransferMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QFtp::TransferMode>::target_type & > ();
  ret.write<int > ((int)((QFtp *)cls)->setTransferMode (qt_gsi::QtToCppAdaptor<QFtp::TransferMode>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_setTransferMode_2157 ()
{
  return new qt_gsi::GenericMethod ("setTransferMode", "@brief Method int QFtp::setTransferMode(QFtp::TransferMode mode)\n", false, &_init_f_setTransferMode_2157, &_call_f_setTransferMode_2157);
}

// QFtp::State QFtp::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFtp::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFtp::State>::target_type > ((qt_gsi::Converter<QFtp::State>::target_type)qt_gsi::CppToQtAdaptor<QFtp::State>(((QFtp *)cls)->state ()));
}

static qt_gsi::GenericMethod *_create_f_state_c0 ()
{
  return new qt_gsi::GenericMethod ("state", "@brief Method QFtp::State QFtp::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
}

// static QString QFtp::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFtp::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFtp::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QFtp::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFtp::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFtp::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QFtp::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QFtp::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFtp::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QFtp::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QFtp::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFtp::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QFtp, QFtp_EventAdaptor> ea_QFtp;

namespace gsi
{
extern gsi::Class<QObject> decl_QObject;

gsi::Class<QFtp> decl_QFtp (ea_QFtp, decl_QObject, "QFtp_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_abort_0 ()) +
  gsi::Methods(_create_f_bytesAvailable_c0 ()) +
  gsi::Methods(_create_f_cd_2025 ()) +
  gsi::Methods(_create_f_clearPendingCommands_0 ()) +
  gsi::Methods(_create_f_close_0 ()) +
  gsi::Methods(_create_f_connectToHost_3017 ()) +
  gsi::Methods(_create_f_currentCommand_c0 ()) +
  gsi::Methods(_create_f_currentDevice_c0 ()) +
  gsi::Methods(_create_f_currentId_c0 ()) +
  gsi::Methods(_create_f_error_c0 ()) +
  gsi::Methods(_create_f_errorString_c0 ()) +
  gsi::Methods(_create_f_get_5442 ()) +
  gsi::Methods(_create_f_hasPendingCommands_c0 ()) +
  gsi::Methods(_create_f_list_2025 ()) +
  gsi::Methods(_create_f_login_3942 ()) +
  gsi::Methods(_create_f_mkdir_2025 ()) +
  gsi::Methods(_create_f_put_6304 ()) +
  gsi::Methods(_create_f_put_5442 ()) +
  gsi::Methods(_create_f_rawCommand_2025 ()) +
  gsi::Methods(_create_f_readAll_0 ()) +
  gsi::Methods(_create_f_remove_2025 ()) +
  gsi::Methods(_create_f_rename_3942 ()) +
  gsi::Methods(_create_f_rmdir_2025 ()) +
  gsi::Methods(_create_f_setProxy_3017 ()) +
  gsi::Methods(_create_f_setTransferMode_2157 ()) +
  gsi::Methods(_create_f_state_c0 ()) +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, int, bool> ("commandFinished", &QFtp_EventAdaptor::commandFinished_e_1523, gsi::arg("arg1"), gsi::arg("arg2"), "@brief Signal declaration for QFtp::commandFinished(int, bool)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, int> ("commandStarted", &QFtp_EventAdaptor::commandStarted_e_767, gsi::arg("arg1"), "@brief Signal declaration for QFtp::commandStarted(int)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, qint64, qint64> ("dataTransferProgress", &QFtp_EventAdaptor::dataTransferProgress_e_1864, gsi::arg("arg1"), gsi::arg("arg2"), "@brief Signal declaration for QFtp::dataTransferProgress(qint64, qint64)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, QObject *> ("destroyed", &QFtp_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QFtp::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, bool> ("done", &QFtp_EventAdaptor::done_e_864, gsi::arg("arg1"), "@brief Signal declaration for QFtp::done(bool)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, const QUrlInfo &> ("listInfo", &QFtp_EventAdaptor::listInfo_e_2097, gsi::arg("arg1"), "@brief Signal declaration for QFtp::listInfo(const QUrlInfo &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, int, const QString &> ("rawCommandReply", &QFtp_EventAdaptor::rawCommandReply_e_2684, gsi::arg("arg1"), gsi::arg("arg2"), "@brief Signal declaration for QFtp::rawCommandReply(int, const QString &)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor> ("readyRead", &QFtp_EventAdaptor::readyRead_e_0, "@brief Signal declaration for QFtp::readyRead()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QFtp, QFtp_EventAdaptor, int> ("stateChanged", &QFtp_EventAdaptor::stateChanged_e_767, gsi::arg("arg1"), "@brief Signal declaration for QFtp::stateChanged(int)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QFtp");
}


class QFtp_Adaptor : public QFtp, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFtp_Adaptor();

  //  [adaptor ctor] QFtp::QFtp(QObject *parent)
  QFtp_Adaptor() : QFtp()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFtp::QFtp(QObject *parent)
  QFtp_Adaptor(QObject *parent) : QFtp(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  int QFtp::receivers(const char *signal)
  int fp_QFtp_receivers_c1731 (const char *signal) const {
    return QFtp::receivers(signal);
  }

  //  QObject *QFtp::sender()
  QObject * fp_QFtp_sender_c0 () const {
    return QFtp::sender();
  }

  //  [adaptor impl] bool QFtp::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QFtp::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFtp_Adaptor, bool, QEvent *>(&QFtp_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QFtp::event(arg1);
    }
  }

  //  [adaptor impl] bool QFtp::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QFtp::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFtp_Adaptor, bool, QObject *, QEvent *>(&QFtp_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QFtp::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QFtp::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QFtp::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFtp_Adaptor, QChildEvent *>(&QFtp_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QFtp::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QFtp::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QFtp::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFtp_Adaptor, QEvent *>(&QFtp_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QFtp::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QFtp::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QFtp::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QFtp_Adaptor, const char *>(&QFtp_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QFtp::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFtp::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QFtp::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFtp_Adaptor, QTimerEvent *>(&QFtp_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QFtp::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QFtp_Adaptor::~QFtp_Adaptor() { }

//  Constructor QFtp::QFtp(QObject *parent) (adaptor class)

static void _init_ctor_QFtp_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QFtp_Adaptor *> ();
}

static void _call_ctor_QFtp_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QFtp_Adaptor *> (new QFtp_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QFtp_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFtp::QFtp(QObject *parent)\nThis method creates an object of class QFtp.", &_init_ctor_QFtp_Adaptor_1302, &_call_ctor_QFtp_Adaptor_1302);
}

// int QFtp::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QFtp_Adaptor *)cls)->fp_QFtp_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QFtp::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QFtp::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QFtp_Adaptor *)cls)->fp_QFtp_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QFtp::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QFtp::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFtp_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QFtp::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QFtp::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QFtp_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QFtp::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QFtp::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QFtp_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFtp::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QFtp::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QFtp_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFtp::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QFtp::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QFtp_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFtp::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QFtp::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QFtp_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFtp_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFtp::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QFtp> decl_QFtp;

gsi::Class<QFtp_Adaptor> decl_QFtp_Adaptor (decl_QFtp, "QFtp",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QFtp_Adaptor_1302 ()),
  "@qt\n@brief Binding of QFtp");

}


//  Implementation of the enum wrapper class for QFtp::Command
namespace qt_gsi
{

static QFtp_Command_Enum *c_1_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::None); }
static QFtp_Command_Enum *c_2_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::SetTransferMode); }
static QFtp_Command_Enum *c_3_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::SetProxy); }
static QFtp_Command_Enum *c_4_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::ConnectToHost); }
static QFtp_Command_Enum *c_5_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Login); }
static QFtp_Command_Enum *c_6_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Close); }
static QFtp_Command_Enum *c_7_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::List); }
static QFtp_Command_Enum *c_8_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Cd); }
static QFtp_Command_Enum *c_9_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Get); }
static QFtp_Command_Enum *c_10_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Put); }
static QFtp_Command_Enum *c_11_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Remove); }
static QFtp_Command_Enum *c_12_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Mkdir); }
static QFtp_Command_Enum *c_13_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Rmdir); }
static QFtp_Command_Enum *c_14_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::Rename); }
static QFtp_Command_Enum *c_15_QFtp_Command_Enum () { return new QFtp_Command_Enum (QFtp::RawCommand); }

static gsi::Methods mkdefs_QFtp_Command () {
  return
    gsi::constant ("None", &qt_gsi::c_1_QFtp_Command_Enum, "@brief Enum constant QFtp::None") +
    gsi::constant ("SetTransferMode", &qt_gsi::c_2_QFtp_Command_Enum, "@brief Enum constant QFtp::SetTransferMode") +
    gsi::constant ("SetProxy", &qt_gsi::c_3_QFtp_Command_Enum, "@brief Enum constant QFtp::SetProxy") +
    gsi::constant ("ConnectToHost", &qt_gsi::c_4_QFtp_Command_Enum, "@brief Enum constant QFtp::ConnectToHost") +
    gsi::constant ("Login", &qt_gsi::c_5_QFtp_Command_Enum, "@brief Enum constant QFtp::Login") +
    gsi::constant ("Close", &qt_gsi::c_6_QFtp_Command_Enum, "@brief Enum constant QFtp::Close") +
    gsi::constant ("List", &qt_gsi::c_7_QFtp_Command_Enum, "@brief Enum constant QFtp::List") +
    gsi::constant ("Cd", &qt_gsi::c_8_QFtp_Command_Enum, "@brief Enum constant QFtp::Cd") +
    gsi::constant ("Get", &qt_gsi::c_9_QFtp_Command_Enum, "@brief Enum constant QFtp::Get") +
    gsi::constant ("Put", &qt_gsi::c_10_QFtp_Command_Enum, "@brief Enum constant QFtp::Put") +
    gsi::constant ("Remove", &qt_gsi::c_11_QFtp_Command_Enum, "@brief Enum constant QFtp::Remove") +
    gsi::constant ("Mkdir", &qt_gsi::c_12_QFtp_Command_Enum, "@brief Enum constant QFtp::Mkdir") +
    gsi::constant ("Rmdir", &qt_gsi::c_13_QFtp_Command_Enum, "@brief Enum constant QFtp::Rmdir") +
    gsi::constant ("Rename", &qt_gsi::c_14_QFtp_Command_Enum, "@brief Enum constant QFtp::Rename") +
    gsi::constant ("RawCommand", &qt_gsi::c_15_QFtp_Command_Enum, "@brief Enum constant QFtp::RawCommand");
}

static std::string to_s_QFtp_Command_Enum (const QFtp_Command_Enum *e)
{
  if (e->value () == QFtp::None) { return tl::sprintf ("None (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::SetTransferMode) { return tl::sprintf ("SetTransferMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::SetProxy) { return tl::sprintf ("SetProxy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::ConnectToHost) { return tl::sprintf ("ConnectToHost (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Login) { return tl::sprintf ("Login (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Close) { return tl::sprintf ("Close (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::List) { return tl::sprintf ("List (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Cd) { return tl::sprintf ("Cd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Get) { return tl::sprintf ("Get (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Put) { return tl::sprintf ("Put (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Remove) { return tl::sprintf ("Remove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Mkdir) { return tl::sprintf ("Mkdir (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Rmdir) { return tl::sprintf ("Rmdir (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Rename) { return tl::sprintf ("Rename (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::RawCommand) { return tl::sprintf ("RawCommand (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFtp_Command_Enum (const QFtp_Command_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFtp_Command_Enum *from_i_QFtp_Command_Enum (unsigned int i)
{
  return new QFtp_Command_Enum ((QFtp::Command) i);
}

static bool equalQFtp_Command_Enum (const QFtp_Command_Enum *e, QFtp_Command_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFtp_Command_Enum (const QFtp_Command_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFtp_Command_Enums oropQFtp_Command_Enums (const QFtp_Command_Enums *e, const QFtp_Command_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFtp_Command_Enums andopQFtp_Command_Enums (const QFtp_Command_Enums *e, const QFtp_Command_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFtp_Command_Enums xoropQFtp_Command_Enums (const QFtp_Command_Enums *e, const QFtp_Command_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFtp_Command_Enums (const QFtp_Command_Enums *e)
{
  std::string l;
  if (e->testFlag (QFtp::None)) { if (!l.empty ()) l += "|"; l += "None"; }
  if (e->testFlag (QFtp::SetTransferMode)) { if (!l.empty ()) l += "|"; l += "SetTransferMode"; }
  if (e->testFlag (QFtp::SetProxy)) { if (!l.empty ()) l += "|"; l += "SetProxy"; }
  if (e->testFlag (QFtp::ConnectToHost)) { if (!l.empty ()) l += "|"; l += "ConnectToHost"; }
  if (e->testFlag (QFtp::Login)) { if (!l.empty ()) l += "|"; l += "Login"; }
  if (e->testFlag (QFtp::Close)) { if (!l.empty ()) l += "|"; l += "Close"; }
  if (e->testFlag (QFtp::List)) { if (!l.empty ()) l += "|"; l += "List"; }
  if (e->testFlag (QFtp::Cd)) { if (!l.empty ()) l += "|"; l += "Cd"; }
  if (e->testFlag (QFtp::Get)) { if (!l.empty ()) l += "|"; l += "Get"; }
  if (e->testFlag (QFtp::Put)) { if (!l.empty ()) l += "|"; l += "Put"; }
  if (e->testFlag (QFtp::Remove)) { if (!l.empty ()) l += "|"; l += "Remove"; }
  if (e->testFlag (QFtp::Mkdir)) { if (!l.empty ()) l += "|"; l += "Mkdir"; }
  if (e->testFlag (QFtp::Rmdir)) { if (!l.empty ()) l += "|"; l += "Rmdir"; }
  if (e->testFlag (QFtp::Rename)) { if (!l.empty ()) l += "|"; l += "Rename"; }
  if (e->testFlag (QFtp::RawCommand)) { if (!l.empty ()) l += "|"; l += "RawCommand"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFtp_Command_Enums (const QFtp_Command_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFtp_Command_Enums (const QFtp_Command_Enums *e, const QFtp_Command_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFtp_Command_Enums> decl_QFtp_Command_Enums ("QFtp_QFlags_Command",
  gsi::method_ext ("|", &qt_gsi::oropQFtp_Command_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFtp_Command_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFtp_Command_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_Command_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_Command_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFtp_Command_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFtp::Command> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFtp_Command_Enum> decl_QFtp_Command_Enum (decl_QFtp_Command_Enums, "QFtp_Command",
  qt_gsi::mkdefs_QFtp_Command () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_Command_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_Command_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFtp_Command_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFtp_Command_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFtp_Command_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFtp::Command enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_Command_Enum_in_parent (qt_gsi::mkdefs_QFtp_Command ());
static gsi::ClassExt<QFtp> decl_QFtp_Command_Enum_as_child (decl_QFtp_Command_Enum, "Command");

}


//  Implementation of the enum wrapper class for QFtp::Error
namespace qt_gsi
{

static QFtp_Error_Enum *c_1_QFtp_Error_Enum () { return new QFtp_Error_Enum (QFtp::NoError); }
static QFtp_Error_Enum *c_2_QFtp_Error_Enum () { return new QFtp_Error_Enum (QFtp::UnknownError); }
static QFtp_Error_Enum *c_3_QFtp_Error_Enum () { return new QFtp_Error_Enum (QFtp::HostNotFound); }
static QFtp_Error_Enum *c_4_QFtp_Error_Enum () { return new QFtp_Error_Enum (QFtp::ConnectionRefused); }
static QFtp_Error_Enum *c_5_QFtp_Error_Enum () { return new QFtp_Error_Enum (QFtp::NotConnected); }

static gsi::Methods mkdefs_QFtp_Error () {
  return
    gsi::constant ("NoError", &qt_gsi::c_1_QFtp_Error_Enum, "@brief Enum constant QFtp::NoError") +
    gsi::constant ("UnknownError", &qt_gsi::c_2_QFtp_Error_Enum, "@brief Enum constant QFtp::UnknownError") +
    gsi::constant ("HostNotFound", &qt_gsi::c_3_QFtp_Error_Enum, "@brief Enum constant QFtp::HostNotFound") +
    gsi::constant ("ConnectionRefused", &qt_gsi::c_4_QFtp_Error_Enum, "@brief Enum constant QFtp::ConnectionRefused") +
    gsi::constant ("NotConnected", &qt_gsi::c_5_QFtp_Error_Enum, "@brief Enum constant QFtp::NotConnected");
}

static std::string to_s_QFtp_Error_Enum (const QFtp_Error_Enum *e)
{
  if (e->value () == QFtp::NoError) { return tl::sprintf ("NoError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::UnknownError) { return tl::sprintf ("UnknownError (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::HostNotFound) { return tl::sprintf ("HostNotFound (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::ConnectionRefused) { return tl::sprintf ("ConnectionRefused (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::NotConnected) { return tl::sprintf ("NotConnected (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFtp_Error_Enum (const QFtp_Error_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFtp_Error_Enum *from_i_QFtp_Error_Enum (unsigned int i)
{
  return new QFtp_Error_Enum ((QFtp::Error) i);
}

static bool equalQFtp_Error_Enum (const QFtp_Error_Enum *e, QFtp_Error_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFtp_Error_Enum (const QFtp_Error_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFtp_Error_Enums oropQFtp_Error_Enums (const QFtp_Error_Enums *e, const QFtp_Error_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFtp_Error_Enums andopQFtp_Error_Enums (const QFtp_Error_Enums *e, const QFtp_Error_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFtp_Error_Enums xoropQFtp_Error_Enums (const QFtp_Error_Enums *e, const QFtp_Error_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFtp_Error_Enums (const QFtp_Error_Enums *e)
{
  std::string l;
  if (e->testFlag (QFtp::NoError)) { if (!l.empty ()) l += "|"; l += "NoError"; }
  if (e->testFlag (QFtp::UnknownError)) { if (!l.empty ()) l += "|"; l += "UnknownError"; }
  if (e->testFlag (QFtp::HostNotFound)) { if (!l.empty ()) l += "|"; l += "HostNotFound"; }
  if (e->testFlag (QFtp::ConnectionRefused)) { if (!l.empty ()) l += "|"; l += "ConnectionRefused"; }
  if (e->testFlag (QFtp::NotConnected)) { if (!l.empty ()) l += "|"; l += "NotConnected"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFtp_Error_Enums (const QFtp_Error_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFtp_Error_Enums (const QFtp_Error_Enums *e, const QFtp_Error_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFtp_Error_Enums> decl_QFtp_Error_Enums ("QFtp_QFlags_Error",
  gsi::method_ext ("|", &qt_gsi::oropQFtp_Error_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFtp_Error_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFtp_Error_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_Error_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_Error_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFtp_Error_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFtp::Error> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFtp_Error_Enum> decl_QFtp_Error_Enum (decl_QFtp_Error_Enums, "QFtp_Error",
  qt_gsi::mkdefs_QFtp_Error () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_Error_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_Error_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFtp_Error_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFtp_Error_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFtp_Error_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFtp::Error enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_Error_Enum_in_parent (qt_gsi::mkdefs_QFtp_Error ());
static gsi::ClassExt<QFtp> decl_QFtp_Error_Enum_as_child (decl_QFtp_Error_Enum, "Error");

}


//  Implementation of the enum wrapper class for QFtp::State
namespace qt_gsi
{

static QFtp_State_Enum *c_1_QFtp_State_Enum () { return new QFtp_State_Enum (QFtp::Unconnected); }
static QFtp_State_Enum *c_2_QFtp_State_Enum () { return new QFtp_State_Enum (QFtp::HostLookup); }
static QFtp_State_Enum *c_3_QFtp_State_Enum () { return new QFtp_State_Enum (QFtp::Connecting); }
static QFtp_State_Enum *c_4_QFtp_State_Enum () { return new QFtp_State_Enum (QFtp::Connected); }
static QFtp_State_Enum *c_5_QFtp_State_Enum () { return new QFtp_State_Enum (QFtp::LoggedIn); }
static QFtp_State_Enum *c_6_QFtp_State_Enum () { return new QFtp_State_Enum (QFtp::Closing); }

static gsi::Methods mkdefs_QFtp_State () {
  return
    gsi::constant ("Unconnected", &qt_gsi::c_1_QFtp_State_Enum, "@brief Enum constant QFtp::Unconnected") +
    gsi::constant ("HostLookup", &qt_gsi::c_2_QFtp_State_Enum, "@brief Enum constant QFtp::HostLookup") +
    gsi::constant ("Connecting", &qt_gsi::c_3_QFtp_State_Enum, "@brief Enum constant QFtp::Connecting") +
    gsi::constant ("Connected", &qt_gsi::c_4_QFtp_State_Enum, "@brief Enum constant QFtp::Connected") +
    gsi::constant ("LoggedIn", &qt_gsi::c_5_QFtp_State_Enum, "@brief Enum constant QFtp::LoggedIn") +
    gsi::constant ("Closing", &qt_gsi::c_6_QFtp_State_Enum, "@brief Enum constant QFtp::Closing");
}

static std::string to_s_QFtp_State_Enum (const QFtp_State_Enum *e)
{
  if (e->value () == QFtp::Unconnected) { return tl::sprintf ("Unconnected (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::HostLookup) { return tl::sprintf ("HostLookup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Connecting) { return tl::sprintf ("Connecting (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Connected) { return tl::sprintf ("Connected (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::LoggedIn) { return tl::sprintf ("LoggedIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Closing) { return tl::sprintf ("Closing (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFtp_State_Enum (const QFtp_State_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFtp_State_Enum *from_i_QFtp_State_Enum (unsigned int i)
{
  return new QFtp_State_Enum ((QFtp::State) i);
}

static bool equalQFtp_State_Enum (const QFtp_State_Enum *e, QFtp_State_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFtp_State_Enum (const QFtp_State_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFtp_State_Enums oropQFtp_State_Enums (const QFtp_State_Enums *e, const QFtp_State_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFtp_State_Enums andopQFtp_State_Enums (const QFtp_State_Enums *e, const QFtp_State_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFtp_State_Enums xoropQFtp_State_Enums (const QFtp_State_Enums *e, const QFtp_State_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFtp_State_Enums (const QFtp_State_Enums *e)
{
  std::string l;
  if (e->testFlag (QFtp::Unconnected)) { if (!l.empty ()) l += "|"; l += "Unconnected"; }
  if (e->testFlag (QFtp::HostLookup)) { if (!l.empty ()) l += "|"; l += "HostLookup"; }
  if (e->testFlag (QFtp::Connecting)) { if (!l.empty ()) l += "|"; l += "Connecting"; }
  if (e->testFlag (QFtp::Connected)) { if (!l.empty ()) l += "|"; l += "Connected"; }
  if (e->testFlag (QFtp::LoggedIn)) { if (!l.empty ()) l += "|"; l += "LoggedIn"; }
  if (e->testFlag (QFtp::Closing)) { if (!l.empty ()) l += "|"; l += "Closing"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFtp_State_Enums (const QFtp_State_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFtp_State_Enums (const QFtp_State_Enums *e, const QFtp_State_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFtp_State_Enums> decl_QFtp_State_Enums ("QFtp_QFlags_State",
  gsi::method_ext ("|", &qt_gsi::oropQFtp_State_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFtp_State_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFtp_State_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_State_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_State_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFtp_State_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFtp::State> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFtp_State_Enum> decl_QFtp_State_Enum (decl_QFtp_State_Enums, "QFtp_State",
  qt_gsi::mkdefs_QFtp_State () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_State_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_State_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFtp_State_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFtp_State_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFtp_State_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFtp::State enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_State_Enum_in_parent (qt_gsi::mkdefs_QFtp_State ());
static gsi::ClassExt<QFtp> decl_QFtp_State_Enum_as_child (decl_QFtp_State_Enum, "State");

}


//  Implementation of the enum wrapper class for QFtp::TransferMode
namespace qt_gsi
{

static QFtp_TransferMode_Enum *c_1_QFtp_TransferMode_Enum () { return new QFtp_TransferMode_Enum (QFtp::Active); }
static QFtp_TransferMode_Enum *c_2_QFtp_TransferMode_Enum () { return new QFtp_TransferMode_Enum (QFtp::Passive); }

static gsi::Methods mkdefs_QFtp_TransferMode () {
  return
    gsi::constant ("Active", &qt_gsi::c_1_QFtp_TransferMode_Enum, "@brief Enum constant QFtp::Active") +
    gsi::constant ("Passive", &qt_gsi::c_2_QFtp_TransferMode_Enum, "@brief Enum constant QFtp::Passive");
}

static std::string to_s_QFtp_TransferMode_Enum (const QFtp_TransferMode_Enum *e)
{
  if (e->value () == QFtp::Active) { return tl::sprintf ("Active (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Passive) { return tl::sprintf ("Passive (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFtp_TransferMode_Enum (const QFtp_TransferMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFtp_TransferMode_Enum *from_i_QFtp_TransferMode_Enum (unsigned int i)
{
  return new QFtp_TransferMode_Enum ((QFtp::TransferMode) i);
}

static bool equalQFtp_TransferMode_Enum (const QFtp_TransferMode_Enum *e, QFtp_TransferMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFtp_TransferMode_Enum (const QFtp_TransferMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFtp_TransferMode_Enums oropQFtp_TransferMode_Enums (const QFtp_TransferMode_Enums *e, const QFtp_TransferMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFtp_TransferMode_Enums andopQFtp_TransferMode_Enums (const QFtp_TransferMode_Enums *e, const QFtp_TransferMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFtp_TransferMode_Enums xoropQFtp_TransferMode_Enums (const QFtp_TransferMode_Enums *e, const QFtp_TransferMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFtp_TransferMode_Enums (const QFtp_TransferMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QFtp::Active)) { if (!l.empty ()) l += "|"; l += "Active"; }
  if (e->testFlag (QFtp::Passive)) { if (!l.empty ()) l += "|"; l += "Passive"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFtp_TransferMode_Enums (const QFtp_TransferMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFtp_TransferMode_Enums (const QFtp_TransferMode_Enums *e, const QFtp_TransferMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFtp_TransferMode_Enums> decl_QFtp_TransferMode_Enums ("QFtp_QFlags_TransferMode",
  gsi::method_ext ("|", &qt_gsi::oropQFtp_TransferMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFtp_TransferMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFtp_TransferMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_TransferMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_TransferMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFtp_TransferMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFtp::TransferMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFtp_TransferMode_Enum> decl_QFtp_TransferMode_Enum (decl_QFtp_TransferMode_Enums, "QFtp_TransferMode",
  qt_gsi::mkdefs_QFtp_TransferMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_TransferMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_TransferMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFtp_TransferMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFtp_TransferMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFtp_TransferMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFtp::TransferMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_TransferMode_Enum_in_parent (qt_gsi::mkdefs_QFtp_TransferMode ());
static gsi::ClassExt<QFtp> decl_QFtp_TransferMode_Enum_as_child (decl_QFtp_TransferMode_Enum, "TransferMode");

}


//  Implementation of the enum wrapper class for QFtp::TransferType
namespace qt_gsi
{

static QFtp_TransferType_Enum *c_1_QFtp_TransferType_Enum () { return new QFtp_TransferType_Enum (QFtp::Binary); }
static QFtp_TransferType_Enum *c_2_QFtp_TransferType_Enum () { return new QFtp_TransferType_Enum (QFtp::Ascii); }

static gsi::Methods mkdefs_QFtp_TransferType () {
  return
    gsi::constant ("Binary", &qt_gsi::c_1_QFtp_TransferType_Enum, "@brief Enum constant QFtp::Binary") +
    gsi::constant ("Ascii", &qt_gsi::c_2_QFtp_TransferType_Enum, "@brief Enum constant QFtp::Ascii");
}

static std::string to_s_QFtp_TransferType_Enum (const QFtp_TransferType_Enum *e)
{
  if (e->value () == QFtp::Binary) { return tl::sprintf ("Binary (%u)", (unsigned int) e->value ()); }
  if (e->value () == QFtp::Ascii) { return tl::sprintf ("Ascii (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QFtp_TransferType_Enum (const QFtp_TransferType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QFtp_TransferType_Enum *from_i_QFtp_TransferType_Enum (unsigned int i)
{
  return new QFtp_TransferType_Enum ((QFtp::TransferType) i);
}

static bool equalQFtp_TransferType_Enum (const QFtp_TransferType_Enum *e, QFtp_TransferType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QFtp_TransferType_Enum (const QFtp_TransferType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QFtp_TransferType_Enums oropQFtp_TransferType_Enums (const QFtp_TransferType_Enums *e, const QFtp_TransferType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QFtp_TransferType_Enums andopQFtp_TransferType_Enums (const QFtp_TransferType_Enums *e, const QFtp_TransferType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QFtp_TransferType_Enums xoropQFtp_TransferType_Enums (const QFtp_TransferType_Enums *e, const QFtp_TransferType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QFtp_TransferType_Enums (const QFtp_TransferType_Enums *e)
{
  std::string l;
  if (e->testFlag (QFtp::Binary)) { if (!l.empty ()) l += "|"; l += "Binary"; }
  if (e->testFlag (QFtp::Ascii)) { if (!l.empty ()) l += "|"; l += "Ascii"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QFtp_TransferType_Enums (const QFtp_TransferType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QFtp_TransferType_Enums (const QFtp_TransferType_Enums *e, const QFtp_TransferType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QFtp_TransferType_Enums> decl_QFtp_TransferType_Enums ("QFtp_QFlags_TransferType",
  gsi::method_ext ("|", &qt_gsi::oropQFtp_TransferType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQFtp_TransferType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQFtp_TransferType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_TransferType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_TransferType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QFtp_TransferType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QFtp::TransferType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QFtp_TransferType_Enum> decl_QFtp_TransferType_Enum (decl_QFtp_TransferType_Enums, "QFtp_TransferType",
  qt_gsi::mkdefs_QFtp_TransferType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QFtp_TransferType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QFtp_TransferType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQFtp_TransferType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QFtp_TransferType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QFtp_TransferType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QFtp::TransferType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QFtp> inject_QFtp_TransferType_Enum_in_parent (qt_gsi::mkdefs_QFtp_TransferType ());
static gsi::ClassExt<QFtp> decl_QFtp_TransferType_Enum_as_child (decl_QFtp_TransferType_Enum, "TransferType");

}

