
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQEvent.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQEvent_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QEvent

// void QEvent::accept()


static void _init_f_accept_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_accept_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QEvent *)cls)->accept ();
}

static qt_gsi::GenericMethod *_create_f_accept_0 ()
{
  return new qt_gsi::GenericMethod ("accept", "@brief Method void QEvent::accept()\n", false, &_init_f_accept_0, &_call_f_accept_0);
}

// void QEvent::ignore()


static void _init_f_ignore_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_ignore_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QEvent *)cls)->ignore ();
}

static qt_gsi::GenericMethod *_create_f_ignore_0 ()
{
  return new qt_gsi::GenericMethod ("ignore", "@brief Method void QEvent::ignore()\n", false, &_init_f_ignore_0, &_call_f_ignore_0);
}

// bool QEvent::isAccepted()


static void _init_f_isAccepted_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAccepted_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QEvent *)cls)->isAccepted ());
}

static qt_gsi::GenericMethod *_create_f_isAccepted_c0 ()
{
  return new qt_gsi::GenericMethod ("isAccepted?|:accepted", "@brief Method bool QEvent::isAccepted()\n", true, &_init_f_isAccepted_c0, &_call_f_isAccepted_c0);
}

// void QEvent::setAccepted(bool accepted)


static void _init_f_setAccepted_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("accepted");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAccepted_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QEvent *)cls)->setAccepted (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAccepted_864 ()
{
  return new qt_gsi::GenericMethod ("setAccepted|accepted=", "@brief Method void QEvent::setAccepted(bool accepted)\n", false, &_init_f_setAccepted_864, &_call_f_setAccepted_864);
}

// bool QEvent::spontaneous()


static void _init_f_spontaneous_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_spontaneous_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QEvent *)cls)->spontaneous ());
}

static qt_gsi::GenericMethod *_create_f_spontaneous_c0 ()
{
  return new qt_gsi::GenericMethod ("spontaneous", "@brief Method bool QEvent::spontaneous()\n", true, &_init_f_spontaneous_c0, &_call_f_spontaneous_c0);
}

// QEvent::Type QEvent::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QEvent::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QEvent::Type>::target_type > ((qt_gsi::Converter<QEvent::Type>::target_type)qt_gsi::CppToQtAdaptor<QEvent::Type>(((QEvent *)cls)->type ()));
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod ("type", "@brief Method QEvent::Type QEvent::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// static int QEvent::registerEventType(int hint)


static void _init_f_registerEventType_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("hint", true, "-1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_registerEventType_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(-1);
  ret.write<int > ((int)QEvent::registerEventType (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_registerEventType_767 ()
{
  return new qt_gsi::GenericStaticMethod ("registerEventType", "@brief Static method int QEvent::registerEventType(int hint)\nThis method is static and can be called without an instance.", &_init_f_registerEventType_767, &_call_f_registerEventType_767);
}

namespace gsi
{
gsi::Class<QEvent> decl_QEvent ("QEvent_Native",
  gsi::Methods(_create_f_accept_0 ()) +
  gsi::Methods(_create_f_ignore_0 ()) +
  gsi::Methods(_create_f_isAccepted_c0 ()) +
  gsi::Methods(_create_f_setAccepted_864 ()) +
  gsi::Methods(_create_f_spontaneous_c0 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_registerEventType_767 ()),
  "@hide\n@alias QEvent");
}


class QEvent_Adaptor : public QEvent, public qt_gsi::QtObjectBase
{
public:

  virtual ~QEvent_Adaptor();

  //  [adaptor ctor] QEvent::QEvent(QEvent::Type type)
  QEvent_Adaptor(QEvent::Type type) : QEvent(type)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  
};

QEvent_Adaptor::~QEvent_Adaptor() { }

//  Constructor QEvent::QEvent(QEvent::Type type) (adaptor class)

static void _init_ctor_QEvent_Adaptor_1565 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QEvent::Type>::target_type & > (argspec_0);
  decl->set_return_new<QEvent_Adaptor *> ();
}

static void _call_ctor_QEvent_Adaptor_1565 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QEvent::Type>::target_type & arg1 = args.read<const qt_gsi::Converter<QEvent::Type>::target_type & > ();
  ret.write<QEvent_Adaptor *> (new QEvent_Adaptor (qt_gsi::QtToCppAdaptor<QEvent::Type>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QEvent_Adaptor_1565 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QEvent::QEvent(QEvent::Type type)\nThis method creates an object of class QEvent.", &_init_ctor_QEvent_Adaptor_1565, &_call_ctor_QEvent_Adaptor_1565);
}

namespace gsi
{

extern gsi::Class<QEvent> decl_QEvent;

gsi::Class<QEvent_Adaptor> decl_QEvent_Adaptor (decl_QEvent, "QEvent",
  gsi::Methods(_create_ctor_QEvent_Adaptor_1565 ()),
  "@qt\n@brief Binding of QEvent");

}


//  Implementation of the enum wrapper class for QEvent::Type
namespace qt_gsi
{

static QEvent_Type_Enum *c_1_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::None); }
static QEvent_Type_Enum *c_2_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Timer); }
static QEvent_Type_Enum *c_3_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MouseButtonPress); }
static QEvent_Type_Enum *c_4_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MouseButtonRelease); }
static QEvent_Type_Enum *c_5_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MouseButtonDblClick); }
static QEvent_Type_Enum *c_6_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MouseMove); }
static QEvent_Type_Enum *c_7_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::KeyPress); }
static QEvent_Type_Enum *c_8_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::KeyRelease); }
static QEvent_Type_Enum *c_9_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::FocusIn); }
static QEvent_Type_Enum *c_10_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::FocusOut); }
static QEvent_Type_Enum *c_11_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Enter); }
static QEvent_Type_Enum *c_12_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Leave); }
static QEvent_Type_Enum *c_13_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Paint); }
static QEvent_Type_Enum *c_14_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Move); }
static QEvent_Type_Enum *c_15_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Resize); }
static QEvent_Type_Enum *c_16_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Create); }
static QEvent_Type_Enum *c_17_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Destroy); }
static QEvent_Type_Enum *c_18_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Show); }
static QEvent_Type_Enum *c_19_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Hide); }
static QEvent_Type_Enum *c_20_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Close); }
static QEvent_Type_Enum *c_21_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Quit); }
static QEvent_Type_Enum *c_22_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ParentChange); }
static QEvent_Type_Enum *c_23_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ParentAboutToChange); }
static QEvent_Type_Enum *c_24_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ThreadChange); }
static QEvent_Type_Enum *c_25_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowActivate); }
static QEvent_Type_Enum *c_26_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowDeactivate); }
static QEvent_Type_Enum *c_27_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ShowToParent); }
static QEvent_Type_Enum *c_28_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::HideToParent); }
static QEvent_Type_Enum *c_29_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Wheel); }
static QEvent_Type_Enum *c_30_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowTitleChange); }
static QEvent_Type_Enum *c_31_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowIconChange); }
static QEvent_Type_Enum *c_32_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationWindowIconChange); }
static QEvent_Type_Enum *c_33_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationFontChange); }
static QEvent_Type_Enum *c_34_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationLayoutDirectionChange); }
static QEvent_Type_Enum *c_35_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationPaletteChange); }
static QEvent_Type_Enum *c_36_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::PaletteChange); }
static QEvent_Type_Enum *c_37_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Clipboard); }
static QEvent_Type_Enum *c_38_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Speech); }
static QEvent_Type_Enum *c_39_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MetaCall); }
static QEvent_Type_Enum *c_40_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::SockAct); }
static QEvent_Type_Enum *c_41_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WinEventAct); }
static QEvent_Type_Enum *c_42_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DeferredDelete); }
static QEvent_Type_Enum *c_43_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DragEnter); }
static QEvent_Type_Enum *c_44_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DragMove); }
static QEvent_Type_Enum *c_45_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DragLeave); }
static QEvent_Type_Enum *c_46_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Drop); }
static QEvent_Type_Enum *c_47_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DragResponse); }
static QEvent_Type_Enum *c_48_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ChildAdded); }
static QEvent_Type_Enum *c_49_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ChildPolished); }
static QEvent_Type_Enum *c_50_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ChildRemoved); }
static QEvent_Type_Enum *c_51_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ShowWindowRequest); }
static QEvent_Type_Enum *c_52_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::PolishRequest); }
static QEvent_Type_Enum *c_53_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Polish); }
static QEvent_Type_Enum *c_54_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::LayoutRequest); }
static QEvent_Type_Enum *c_55_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::UpdateRequest); }
static QEvent_Type_Enum *c_56_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::UpdateLater); }
static QEvent_Type_Enum *c_57_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::EmbeddingControl); }
static QEvent_Type_Enum *c_58_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ActivateControl); }
static QEvent_Type_Enum *c_59_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DeactivateControl); }
static QEvent_Type_Enum *c_60_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ContextMenu); }
static QEvent_Type_Enum *c_61_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::InputMethod); }
static QEvent_Type_Enum *c_62_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::AccessibilityPrepare); }
static QEvent_Type_Enum *c_63_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TabletMove); }
static QEvent_Type_Enum *c_64_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::LocaleChange); }
static QEvent_Type_Enum *c_65_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::LanguageChange); }
static QEvent_Type_Enum *c_66_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::LayoutDirectionChange); }
static QEvent_Type_Enum *c_67_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Style); }
static QEvent_Type_Enum *c_68_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TabletPress); }
static QEvent_Type_Enum *c_69_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TabletRelease); }
static QEvent_Type_Enum *c_70_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::OkRequest); }
static QEvent_Type_Enum *c_71_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::HelpRequest); }
static QEvent_Type_Enum *c_72_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::IconDrag); }
static QEvent_Type_Enum *c_73_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::FontChange); }
static QEvent_Type_Enum *c_74_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::EnabledChange); }
static QEvent_Type_Enum *c_75_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ActivationChange); }
static QEvent_Type_Enum *c_76_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::StyleChange); }
static QEvent_Type_Enum *c_77_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::IconTextChange); }
static QEvent_Type_Enum *c_78_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ModifiedChange); }
static QEvent_Type_Enum *c_79_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MouseTrackingChange); }
static QEvent_Type_Enum *c_80_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowBlocked); }
static QEvent_Type_Enum *c_81_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowUnblocked); }
static QEvent_Type_Enum *c_82_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WindowStateChange); }
static QEvent_Type_Enum *c_83_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ToolTip); }
static QEvent_Type_Enum *c_84_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WhatsThis); }
static QEvent_Type_Enum *c_85_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::StatusTip); }
static QEvent_Type_Enum *c_86_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ActionChanged); }
static QEvent_Type_Enum *c_87_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ActionAdded); }
static QEvent_Type_Enum *c_88_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ActionRemoved); }
static QEvent_Type_Enum *c_89_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::FileOpen); }
static QEvent_Type_Enum *c_90_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Shortcut); }
static QEvent_Type_Enum *c_91_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ShortcutOverride); }
static QEvent_Type_Enum *c_92_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WhatsThisClicked); }
static QEvent_Type_Enum *c_93_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ToolBarChange); }
static QEvent_Type_Enum *c_94_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationActivate); }
static QEvent_Type_Enum *c_95_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationActivated); }
static QEvent_Type_Enum *c_96_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationDeactivate); }
static QEvent_Type_Enum *c_97_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ApplicationDeactivated); }
static QEvent_Type_Enum *c_98_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::QueryWhatsThis); }
static QEvent_Type_Enum *c_99_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::EnterWhatsThisMode); }
static QEvent_Type_Enum *c_100_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::LeaveWhatsThisMode); }
static QEvent_Type_Enum *c_101_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ZOrderChange); }
static QEvent_Type_Enum *c_102_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::HoverEnter); }
static QEvent_Type_Enum *c_103_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::HoverLeave); }
static QEvent_Type_Enum *c_104_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::HoverMove); }
static QEvent_Type_Enum *c_105_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::AccessibilityHelp); }
static QEvent_Type_Enum *c_106_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::AccessibilityDescription); }
static QEvent_Type_Enum *c_107_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::AcceptDropsChange); }
static QEvent_Type_Enum *c_108_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MenubarUpdated); }
static QEvent_Type_Enum *c_109_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ZeroTimerEvent); }
static QEvent_Type_Enum *c_110_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneMouseMove); }
static QEvent_Type_Enum *c_111_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneMousePress); }
static QEvent_Type_Enum *c_112_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneMouseRelease); }
static QEvent_Type_Enum *c_113_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneMouseDoubleClick); }
static QEvent_Type_Enum *c_114_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneContextMenu); }
static QEvent_Type_Enum *c_115_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneHoverEnter); }
static QEvent_Type_Enum *c_116_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneHoverMove); }
static QEvent_Type_Enum *c_117_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneHoverLeave); }
static QEvent_Type_Enum *c_118_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneHelp); }
static QEvent_Type_Enum *c_119_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneDragEnter); }
static QEvent_Type_Enum *c_120_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneDragMove); }
static QEvent_Type_Enum *c_121_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneDragLeave); }
static QEvent_Type_Enum *c_122_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneDrop); }
static QEvent_Type_Enum *c_123_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneWheel); }
static QEvent_Type_Enum *c_124_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::KeyboardLayoutChange); }
static QEvent_Type_Enum *c_125_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::DynamicPropertyChange); }
static QEvent_Type_Enum *c_126_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TabletEnterProximity); }
static QEvent_Type_Enum *c_127_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TabletLeaveProximity); }
static QEvent_Type_Enum *c_128_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::NonClientAreaMouseMove); }
static QEvent_Type_Enum *c_129_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::NonClientAreaMouseButtonPress); }
static QEvent_Type_Enum *c_130_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::NonClientAreaMouseButtonRelease); }
static QEvent_Type_Enum *c_131_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::NonClientAreaMouseButtonDblClick); }
static QEvent_Type_Enum *c_132_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MacSizeChange); }
static QEvent_Type_Enum *c_133_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ContentsRectChange); }
static QEvent_Type_Enum *c_134_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MacGLWindowChange); }
static QEvent_Type_Enum *c_135_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::FutureCallOut); }
static QEvent_Type_Enum *c_136_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneResize); }
static QEvent_Type_Enum *c_137_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GraphicsSceneMove); }
static QEvent_Type_Enum *c_138_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::CursorChange); }
static QEvent_Type_Enum *c_139_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::ToolTipChange); }
static QEvent_Type_Enum *c_140_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::NetworkReplyUpdated); }
static QEvent_Type_Enum *c_141_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GrabMouse); }
static QEvent_Type_Enum *c_142_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::UngrabMouse); }
static QEvent_Type_Enum *c_143_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GrabKeyboard); }
static QEvent_Type_Enum *c_144_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::UngrabKeyboard); }
static QEvent_Type_Enum *c_146_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MacGLClearDrawable); }
static QEvent_Type_Enum *c_147_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::StateMachineSignal); }
static QEvent_Type_Enum *c_148_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::StateMachineWrapped); }
static QEvent_Type_Enum *c_149_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TouchBegin); }
static QEvent_Type_Enum *c_150_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TouchUpdate); }
static QEvent_Type_Enum *c_151_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::TouchEnd); }
static QEvent_Type_Enum *c_152_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::NativeGesture); }
static QEvent_Type_Enum *c_153_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::RequestSoftwareInputPanel); }
static QEvent_Type_Enum *c_154_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::CloseSoftwareInputPanel); }
static QEvent_Type_Enum *c_155_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::UpdateSoftKeys); }
static QEvent_Type_Enum *c_156_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::WinIdChange); }
static QEvent_Type_Enum *c_157_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::Gesture); }
static QEvent_Type_Enum *c_158_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::GestureOverride); }
static QEvent_Type_Enum *c_159_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::User); }
static QEvent_Type_Enum *c_160_QEvent_Type_Enum () { return new QEvent_Type_Enum (QEvent::MaxUser); }

static gsi::Methods mkdefs_QEvent_Type () {
  return
    gsi::constant ("None", &qt_gsi::c_1_QEvent_Type_Enum, "@brief Enum constant QEvent::None") +
    gsi::constant ("Timer", &qt_gsi::c_2_QEvent_Type_Enum, "@brief Enum constant QEvent::Timer") +
    gsi::constant ("MouseButtonPress", &qt_gsi::c_3_QEvent_Type_Enum, "@brief Enum constant QEvent::MouseButtonPress") +
    gsi::constant ("MouseButtonRelease", &qt_gsi::c_4_QEvent_Type_Enum, "@brief Enum constant QEvent::MouseButtonRelease") +
    gsi::constant ("MouseButtonDblClick", &qt_gsi::c_5_QEvent_Type_Enum, "@brief Enum constant QEvent::MouseButtonDblClick") +
    gsi::constant ("MouseMove", &qt_gsi::c_6_QEvent_Type_Enum, "@brief Enum constant QEvent::MouseMove") +
    gsi::constant ("KeyPress", &qt_gsi::c_7_QEvent_Type_Enum, "@brief Enum constant QEvent::KeyPress") +
    gsi::constant ("KeyRelease", &qt_gsi::c_8_QEvent_Type_Enum, "@brief Enum constant QEvent::KeyRelease") +
    gsi::constant ("FocusIn", &qt_gsi::c_9_QEvent_Type_Enum, "@brief Enum constant QEvent::FocusIn") +
    gsi::constant ("FocusOut", &qt_gsi::c_10_QEvent_Type_Enum, "@brief Enum constant QEvent::FocusOut") +
    gsi::constant ("Enter", &qt_gsi::c_11_QEvent_Type_Enum, "@brief Enum constant QEvent::Enter") +
    gsi::constant ("Leave", &qt_gsi::c_12_QEvent_Type_Enum, "@brief Enum constant QEvent::Leave") +
    gsi::constant ("Paint", &qt_gsi::c_13_QEvent_Type_Enum, "@brief Enum constant QEvent::Paint") +
    gsi::constant ("Move", &qt_gsi::c_14_QEvent_Type_Enum, "@brief Enum constant QEvent::Move") +
    gsi::constant ("Resize", &qt_gsi::c_15_QEvent_Type_Enum, "@brief Enum constant QEvent::Resize") +
    gsi::constant ("Create", &qt_gsi::c_16_QEvent_Type_Enum, "@brief Enum constant QEvent::Create") +
    gsi::constant ("Destroy", &qt_gsi::c_17_QEvent_Type_Enum, "@brief Enum constant QEvent::Destroy") +
    gsi::constant ("Show", &qt_gsi::c_18_QEvent_Type_Enum, "@brief Enum constant QEvent::Show") +
    gsi::constant ("Hide", &qt_gsi::c_19_QEvent_Type_Enum, "@brief Enum constant QEvent::Hide") +
    gsi::constant ("Close", &qt_gsi::c_20_QEvent_Type_Enum, "@brief Enum constant QEvent::Close") +
    gsi::constant ("Quit", &qt_gsi::c_21_QEvent_Type_Enum, "@brief Enum constant QEvent::Quit") +
    gsi::constant ("ParentChange", &qt_gsi::c_22_QEvent_Type_Enum, "@brief Enum constant QEvent::ParentChange") +
    gsi::constant ("ParentAboutToChange", &qt_gsi::c_23_QEvent_Type_Enum, "@brief Enum constant QEvent::ParentAboutToChange") +
    gsi::constant ("ThreadChange", &qt_gsi::c_24_QEvent_Type_Enum, "@brief Enum constant QEvent::ThreadChange") +
    gsi::constant ("WindowActivate", &qt_gsi::c_25_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowActivate") +
    gsi::constant ("WindowDeactivate", &qt_gsi::c_26_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowDeactivate") +
    gsi::constant ("ShowToParent", &qt_gsi::c_27_QEvent_Type_Enum, "@brief Enum constant QEvent::ShowToParent") +
    gsi::constant ("HideToParent", &qt_gsi::c_28_QEvent_Type_Enum, "@brief Enum constant QEvent::HideToParent") +
    gsi::constant ("Wheel", &qt_gsi::c_29_QEvent_Type_Enum, "@brief Enum constant QEvent::Wheel") +
    gsi::constant ("WindowTitleChange", &qt_gsi::c_30_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowTitleChange") +
    gsi::constant ("WindowIconChange", &qt_gsi::c_31_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowIconChange") +
    gsi::constant ("ApplicationWindowIconChange", &qt_gsi::c_32_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationWindowIconChange") +
    gsi::constant ("ApplicationFontChange", &qt_gsi::c_33_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationFontChange") +
    gsi::constant ("ApplicationLayoutDirectionChange", &qt_gsi::c_34_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationLayoutDirectionChange") +
    gsi::constant ("ApplicationPaletteChange", &qt_gsi::c_35_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationPaletteChange") +
    gsi::constant ("PaletteChange", &qt_gsi::c_36_QEvent_Type_Enum, "@brief Enum constant QEvent::PaletteChange") +
    gsi::constant ("Clipboard", &qt_gsi::c_37_QEvent_Type_Enum, "@brief Enum constant QEvent::Clipboard") +
    gsi::constant ("Speech", &qt_gsi::c_38_QEvent_Type_Enum, "@brief Enum constant QEvent::Speech") +
    gsi::constant ("MetaCall", &qt_gsi::c_39_QEvent_Type_Enum, "@brief Enum constant QEvent::MetaCall") +
    gsi::constant ("SockAct", &qt_gsi::c_40_QEvent_Type_Enum, "@brief Enum constant QEvent::SockAct") +
    gsi::constant ("WinEventAct", &qt_gsi::c_41_QEvent_Type_Enum, "@brief Enum constant QEvent::WinEventAct") +
    gsi::constant ("DeferredDelete", &qt_gsi::c_42_QEvent_Type_Enum, "@brief Enum constant QEvent::DeferredDelete") +
    gsi::constant ("DragEnter", &qt_gsi::c_43_QEvent_Type_Enum, "@brief Enum constant QEvent::DragEnter") +
    gsi::constant ("DragMove", &qt_gsi::c_44_QEvent_Type_Enum, "@brief Enum constant QEvent::DragMove") +
    gsi::constant ("DragLeave", &qt_gsi::c_45_QEvent_Type_Enum, "@brief Enum constant QEvent::DragLeave") +
    gsi::constant ("Drop", &qt_gsi::c_46_QEvent_Type_Enum, "@brief Enum constant QEvent::Drop") +
    gsi::constant ("DragResponse", &qt_gsi::c_47_QEvent_Type_Enum, "@brief Enum constant QEvent::DragResponse") +
    gsi::constant ("ChildAdded", &qt_gsi::c_48_QEvent_Type_Enum, "@brief Enum constant QEvent::ChildAdded") +
    gsi::constant ("ChildPolished", &qt_gsi::c_49_QEvent_Type_Enum, "@brief Enum constant QEvent::ChildPolished") +
    gsi::constant ("ChildRemoved", &qt_gsi::c_50_QEvent_Type_Enum, "@brief Enum constant QEvent::ChildRemoved") +
    gsi::constant ("ShowWindowRequest", &qt_gsi::c_51_QEvent_Type_Enum, "@brief Enum constant QEvent::ShowWindowRequest") +
    gsi::constant ("PolishRequest", &qt_gsi::c_52_QEvent_Type_Enum, "@brief Enum constant QEvent::PolishRequest") +
    gsi::constant ("Polish", &qt_gsi::c_53_QEvent_Type_Enum, "@brief Enum constant QEvent::Polish") +
    gsi::constant ("LayoutRequest", &qt_gsi::c_54_QEvent_Type_Enum, "@brief Enum constant QEvent::LayoutRequest") +
    gsi::constant ("UpdateRequest", &qt_gsi::c_55_QEvent_Type_Enum, "@brief Enum constant QEvent::UpdateRequest") +
    gsi::constant ("UpdateLater", &qt_gsi::c_56_QEvent_Type_Enum, "@brief Enum constant QEvent::UpdateLater") +
    gsi::constant ("EmbeddingControl", &qt_gsi::c_57_QEvent_Type_Enum, "@brief Enum constant QEvent::EmbeddingControl") +
    gsi::constant ("ActivateControl", &qt_gsi::c_58_QEvent_Type_Enum, "@brief Enum constant QEvent::ActivateControl") +
    gsi::constant ("DeactivateControl", &qt_gsi::c_59_QEvent_Type_Enum, "@brief Enum constant QEvent::DeactivateControl") +
    gsi::constant ("ContextMenu", &qt_gsi::c_60_QEvent_Type_Enum, "@brief Enum constant QEvent::ContextMenu") +
    gsi::constant ("InputMethod", &qt_gsi::c_61_QEvent_Type_Enum, "@brief Enum constant QEvent::InputMethod") +
    gsi::constant ("AccessibilityPrepare", &qt_gsi::c_62_QEvent_Type_Enum, "@brief Enum constant QEvent::AccessibilityPrepare") +
    gsi::constant ("TabletMove", &qt_gsi::c_63_QEvent_Type_Enum, "@brief Enum constant QEvent::TabletMove") +
    gsi::constant ("LocaleChange", &qt_gsi::c_64_QEvent_Type_Enum, "@brief Enum constant QEvent::LocaleChange") +
    gsi::constant ("LanguageChange", &qt_gsi::c_65_QEvent_Type_Enum, "@brief Enum constant QEvent::LanguageChange") +
    gsi::constant ("LayoutDirectionChange", &qt_gsi::c_66_QEvent_Type_Enum, "@brief Enum constant QEvent::LayoutDirectionChange") +
    gsi::constant ("Style", &qt_gsi::c_67_QEvent_Type_Enum, "@brief Enum constant QEvent::Style") +
    gsi::constant ("TabletPress", &qt_gsi::c_68_QEvent_Type_Enum, "@brief Enum constant QEvent::TabletPress") +
    gsi::constant ("TabletRelease", &qt_gsi::c_69_QEvent_Type_Enum, "@brief Enum constant QEvent::TabletRelease") +
    gsi::constant ("OkRequest", &qt_gsi::c_70_QEvent_Type_Enum, "@brief Enum constant QEvent::OkRequest") +
    gsi::constant ("HelpRequest", &qt_gsi::c_71_QEvent_Type_Enum, "@brief Enum constant QEvent::HelpRequest") +
    gsi::constant ("IconDrag", &qt_gsi::c_72_QEvent_Type_Enum, "@brief Enum constant QEvent::IconDrag") +
    gsi::constant ("FontChange", &qt_gsi::c_73_QEvent_Type_Enum, "@brief Enum constant QEvent::FontChange") +
    gsi::constant ("EnabledChange", &qt_gsi::c_74_QEvent_Type_Enum, "@brief Enum constant QEvent::EnabledChange") +
    gsi::constant ("ActivationChange", &qt_gsi::c_75_QEvent_Type_Enum, "@brief Enum constant QEvent::ActivationChange") +
    gsi::constant ("StyleChange", &qt_gsi::c_76_QEvent_Type_Enum, "@brief Enum constant QEvent::StyleChange") +
    gsi::constant ("IconTextChange", &qt_gsi::c_77_QEvent_Type_Enum, "@brief Enum constant QEvent::IconTextChange") +
    gsi::constant ("ModifiedChange", &qt_gsi::c_78_QEvent_Type_Enum, "@brief Enum constant QEvent::ModifiedChange") +
    gsi::constant ("MouseTrackingChange", &qt_gsi::c_79_QEvent_Type_Enum, "@brief Enum constant QEvent::MouseTrackingChange") +
    gsi::constant ("WindowBlocked", &qt_gsi::c_80_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowBlocked") +
    gsi::constant ("WindowUnblocked", &qt_gsi::c_81_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowUnblocked") +
    gsi::constant ("WindowStateChange", &qt_gsi::c_82_QEvent_Type_Enum, "@brief Enum constant QEvent::WindowStateChange") +
    gsi::constant ("ToolTip", &qt_gsi::c_83_QEvent_Type_Enum, "@brief Enum constant QEvent::ToolTip") +
    gsi::constant ("WhatsThis", &qt_gsi::c_84_QEvent_Type_Enum, "@brief Enum constant QEvent::WhatsThis") +
    gsi::constant ("StatusTip", &qt_gsi::c_85_QEvent_Type_Enum, "@brief Enum constant QEvent::StatusTip") +
    gsi::constant ("ActionChanged", &qt_gsi::c_86_QEvent_Type_Enum, "@brief Enum constant QEvent::ActionChanged") +
    gsi::constant ("ActionAdded", &qt_gsi::c_87_QEvent_Type_Enum, "@brief Enum constant QEvent::ActionAdded") +
    gsi::constant ("ActionRemoved", &qt_gsi::c_88_QEvent_Type_Enum, "@brief Enum constant QEvent::ActionRemoved") +
    gsi::constant ("FileOpen", &qt_gsi::c_89_QEvent_Type_Enum, "@brief Enum constant QEvent::FileOpen") +
    gsi::constant ("Shortcut", &qt_gsi::c_90_QEvent_Type_Enum, "@brief Enum constant QEvent::Shortcut") +
    gsi::constant ("ShortcutOverride", &qt_gsi::c_91_QEvent_Type_Enum, "@brief Enum constant QEvent::ShortcutOverride") +
    gsi::constant ("WhatsThisClicked", &qt_gsi::c_92_QEvent_Type_Enum, "@brief Enum constant QEvent::WhatsThisClicked") +
    gsi::constant ("ToolBarChange", &qt_gsi::c_93_QEvent_Type_Enum, "@brief Enum constant QEvent::ToolBarChange") +
    gsi::constant ("ApplicationActivate", &qt_gsi::c_94_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationActivate") +
    gsi::constant ("ApplicationActivated", &qt_gsi::c_95_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationActivated") +
    gsi::constant ("ApplicationDeactivate", &qt_gsi::c_96_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationDeactivate") +
    gsi::constant ("ApplicationDeactivated", &qt_gsi::c_97_QEvent_Type_Enum, "@brief Enum constant QEvent::ApplicationDeactivated") +
    gsi::constant ("QueryWhatsThis", &qt_gsi::c_98_QEvent_Type_Enum, "@brief Enum constant QEvent::QueryWhatsThis") +
    gsi::constant ("EnterWhatsThisMode", &qt_gsi::c_99_QEvent_Type_Enum, "@brief Enum constant QEvent::EnterWhatsThisMode") +
    gsi::constant ("LeaveWhatsThisMode", &qt_gsi::c_100_QEvent_Type_Enum, "@brief Enum constant QEvent::LeaveWhatsThisMode") +
    gsi::constant ("ZOrderChange", &qt_gsi::c_101_QEvent_Type_Enum, "@brief Enum constant QEvent::ZOrderChange") +
    gsi::constant ("HoverEnter", &qt_gsi::c_102_QEvent_Type_Enum, "@brief Enum constant QEvent::HoverEnter") +
    gsi::constant ("HoverLeave", &qt_gsi::c_103_QEvent_Type_Enum, "@brief Enum constant QEvent::HoverLeave") +
    gsi::constant ("HoverMove", &qt_gsi::c_104_QEvent_Type_Enum, "@brief Enum constant QEvent::HoverMove") +
    gsi::constant ("AccessibilityHelp", &qt_gsi::c_105_QEvent_Type_Enum, "@brief Enum constant QEvent::AccessibilityHelp") +
    gsi::constant ("AccessibilityDescription", &qt_gsi::c_106_QEvent_Type_Enum, "@brief Enum constant QEvent::AccessibilityDescription") +
    gsi::constant ("AcceptDropsChange", &qt_gsi::c_107_QEvent_Type_Enum, "@brief Enum constant QEvent::AcceptDropsChange") +
    gsi::constant ("MenubarUpdated", &qt_gsi::c_108_QEvent_Type_Enum, "@brief Enum constant QEvent::MenubarUpdated") +
    gsi::constant ("ZeroTimerEvent", &qt_gsi::c_109_QEvent_Type_Enum, "@brief Enum constant QEvent::ZeroTimerEvent") +
    gsi::constant ("GraphicsSceneMouseMove", &qt_gsi::c_110_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneMouseMove") +
    gsi::constant ("GraphicsSceneMousePress", &qt_gsi::c_111_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneMousePress") +
    gsi::constant ("GraphicsSceneMouseRelease", &qt_gsi::c_112_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneMouseRelease") +
    gsi::constant ("GraphicsSceneMouseDoubleClick", &qt_gsi::c_113_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneMouseDoubleClick") +
    gsi::constant ("GraphicsSceneContextMenu", &qt_gsi::c_114_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneContextMenu") +
    gsi::constant ("GraphicsSceneHoverEnter", &qt_gsi::c_115_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneHoverEnter") +
    gsi::constant ("GraphicsSceneHoverMove", &qt_gsi::c_116_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneHoverMove") +
    gsi::constant ("GraphicsSceneHoverLeave", &qt_gsi::c_117_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneHoverLeave") +
    gsi::constant ("GraphicsSceneHelp", &qt_gsi::c_118_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneHelp") +
    gsi::constant ("GraphicsSceneDragEnter", &qt_gsi::c_119_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneDragEnter") +
    gsi::constant ("GraphicsSceneDragMove", &qt_gsi::c_120_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneDragMove") +
    gsi::constant ("GraphicsSceneDragLeave", &qt_gsi::c_121_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneDragLeave") +
    gsi::constant ("GraphicsSceneDrop", &qt_gsi::c_122_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneDrop") +
    gsi::constant ("GraphicsSceneWheel", &qt_gsi::c_123_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneWheel") +
    gsi::constant ("KeyboardLayoutChange", &qt_gsi::c_124_QEvent_Type_Enum, "@brief Enum constant QEvent::KeyboardLayoutChange") +
    gsi::constant ("DynamicPropertyChange", &qt_gsi::c_125_QEvent_Type_Enum, "@brief Enum constant QEvent::DynamicPropertyChange") +
    gsi::constant ("TabletEnterProximity", &qt_gsi::c_126_QEvent_Type_Enum, "@brief Enum constant QEvent::TabletEnterProximity") +
    gsi::constant ("TabletLeaveProximity", &qt_gsi::c_127_QEvent_Type_Enum, "@brief Enum constant QEvent::TabletLeaveProximity") +
    gsi::constant ("NonClientAreaMouseMove", &qt_gsi::c_128_QEvent_Type_Enum, "@brief Enum constant QEvent::NonClientAreaMouseMove") +
    gsi::constant ("NonClientAreaMouseButtonPress", &qt_gsi::c_129_QEvent_Type_Enum, "@brief Enum constant QEvent::NonClientAreaMouseButtonPress") +
    gsi::constant ("NonClientAreaMouseButtonRelease", &qt_gsi::c_130_QEvent_Type_Enum, "@brief Enum constant QEvent::NonClientAreaMouseButtonRelease") +
    gsi::constant ("NonClientAreaMouseButtonDblClick", &qt_gsi::c_131_QEvent_Type_Enum, "@brief Enum constant QEvent::NonClientAreaMouseButtonDblClick") +
    gsi::constant ("MacSizeChange", &qt_gsi::c_132_QEvent_Type_Enum, "@brief Enum constant QEvent::MacSizeChange") +
    gsi::constant ("ContentsRectChange", &qt_gsi::c_133_QEvent_Type_Enum, "@brief Enum constant QEvent::ContentsRectChange") +
    gsi::constant ("MacGLWindowChange", &qt_gsi::c_134_QEvent_Type_Enum, "@brief Enum constant QEvent::MacGLWindowChange") +
    gsi::constant ("FutureCallOut", &qt_gsi::c_135_QEvent_Type_Enum, "@brief Enum constant QEvent::FutureCallOut") +
    gsi::constant ("GraphicsSceneResize", &qt_gsi::c_136_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneResize") +
    gsi::constant ("GraphicsSceneMove", &qt_gsi::c_137_QEvent_Type_Enum, "@brief Enum constant QEvent::GraphicsSceneMove") +
    gsi::constant ("CursorChange", &qt_gsi::c_138_QEvent_Type_Enum, "@brief Enum constant QEvent::CursorChange") +
    gsi::constant ("ToolTipChange", &qt_gsi::c_139_QEvent_Type_Enum, "@brief Enum constant QEvent::ToolTipChange") +
    gsi::constant ("NetworkReplyUpdated", &qt_gsi::c_140_QEvent_Type_Enum, "@brief Enum constant QEvent::NetworkReplyUpdated") +
    gsi::constant ("GrabMouse", &qt_gsi::c_141_QEvent_Type_Enum, "@brief Enum constant QEvent::GrabMouse") +
    gsi::constant ("UngrabMouse", &qt_gsi::c_142_QEvent_Type_Enum, "@brief Enum constant QEvent::UngrabMouse") +
    gsi::constant ("GrabKeyboard", &qt_gsi::c_143_QEvent_Type_Enum, "@brief Enum constant QEvent::GrabKeyboard") +
    gsi::constant ("UngrabKeyboard", &qt_gsi::c_144_QEvent_Type_Enum, "@brief Enum constant QEvent::UngrabKeyboard") +
    gsi::constant ("MacGLClearDrawable", &qt_gsi::c_146_QEvent_Type_Enum, "@brief Enum constant QEvent::MacGLClearDrawable") +
    gsi::constant ("StateMachineSignal", &qt_gsi::c_147_QEvent_Type_Enum, "@brief Enum constant QEvent::StateMachineSignal") +
    gsi::constant ("StateMachineWrapped", &qt_gsi::c_148_QEvent_Type_Enum, "@brief Enum constant QEvent::StateMachineWrapped") +
    gsi::constant ("TouchBegin", &qt_gsi::c_149_QEvent_Type_Enum, "@brief Enum constant QEvent::TouchBegin") +
    gsi::constant ("TouchUpdate", &qt_gsi::c_150_QEvent_Type_Enum, "@brief Enum constant QEvent::TouchUpdate") +
    gsi::constant ("TouchEnd", &qt_gsi::c_151_QEvent_Type_Enum, "@brief Enum constant QEvent::TouchEnd") +
    gsi::constant ("NativeGesture", &qt_gsi::c_152_QEvent_Type_Enum, "@brief Enum constant QEvent::NativeGesture") +
    gsi::constant ("RequestSoftwareInputPanel", &qt_gsi::c_153_QEvent_Type_Enum, "@brief Enum constant QEvent::RequestSoftwareInputPanel") +
    gsi::constant ("CloseSoftwareInputPanel", &qt_gsi::c_154_QEvent_Type_Enum, "@brief Enum constant QEvent::CloseSoftwareInputPanel") +
    gsi::constant ("UpdateSoftKeys", &qt_gsi::c_155_QEvent_Type_Enum, "@brief Enum constant QEvent::UpdateSoftKeys") +
    gsi::constant ("WinIdChange", &qt_gsi::c_156_QEvent_Type_Enum, "@brief Enum constant QEvent::WinIdChange") +
    gsi::constant ("Gesture", &qt_gsi::c_157_QEvent_Type_Enum, "@brief Enum constant QEvent::Gesture") +
    gsi::constant ("GestureOverride", &qt_gsi::c_158_QEvent_Type_Enum, "@brief Enum constant QEvent::GestureOverride") +
    gsi::constant ("User", &qt_gsi::c_159_QEvent_Type_Enum, "@brief Enum constant QEvent::User") +
    gsi::constant ("MaxUser", &qt_gsi::c_160_QEvent_Type_Enum, "@brief Enum constant QEvent::MaxUser");
}

static std::string to_s_QEvent_Type_Enum (const QEvent_Type_Enum *e)
{
  if (e->value () == QEvent::None) { return tl::sprintf ("None (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Timer) { return tl::sprintf ("Timer (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MouseButtonPress) { return tl::sprintf ("MouseButtonPress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MouseButtonRelease) { return tl::sprintf ("MouseButtonRelease (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MouseButtonDblClick) { return tl::sprintf ("MouseButtonDblClick (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MouseMove) { return tl::sprintf ("MouseMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::KeyPress) { return tl::sprintf ("KeyPress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::KeyRelease) { return tl::sprintf ("KeyRelease (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::FocusIn) { return tl::sprintf ("FocusIn (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::FocusOut) { return tl::sprintf ("FocusOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Enter) { return tl::sprintf ("Enter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Leave) { return tl::sprintf ("Leave (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Paint) { return tl::sprintf ("Paint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Move) { return tl::sprintf ("Move (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Resize) { return tl::sprintf ("Resize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Create) { return tl::sprintf ("Create (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Destroy) { return tl::sprintf ("Destroy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Show) { return tl::sprintf ("Show (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Hide) { return tl::sprintf ("Hide (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Close) { return tl::sprintf ("Close (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Quit) { return tl::sprintf ("Quit (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ParentChange) { return tl::sprintf ("ParentChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ParentAboutToChange) { return tl::sprintf ("ParentAboutToChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ThreadChange) { return tl::sprintf ("ThreadChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowActivate) { return tl::sprintf ("WindowActivate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowDeactivate) { return tl::sprintf ("WindowDeactivate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ShowToParent) { return tl::sprintf ("ShowToParent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::HideToParent) { return tl::sprintf ("HideToParent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Wheel) { return tl::sprintf ("Wheel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowTitleChange) { return tl::sprintf ("WindowTitleChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowIconChange) { return tl::sprintf ("WindowIconChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationWindowIconChange) { return tl::sprintf ("ApplicationWindowIconChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationFontChange) { return tl::sprintf ("ApplicationFontChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationLayoutDirectionChange) { return tl::sprintf ("ApplicationLayoutDirectionChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationPaletteChange) { return tl::sprintf ("ApplicationPaletteChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::PaletteChange) { return tl::sprintf ("PaletteChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Clipboard) { return tl::sprintf ("Clipboard (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Speech) { return tl::sprintf ("Speech (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MetaCall) { return tl::sprintf ("MetaCall (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::SockAct) { return tl::sprintf ("SockAct (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WinEventAct) { return tl::sprintf ("WinEventAct (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DeferredDelete) { return tl::sprintf ("DeferredDelete (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DragEnter) { return tl::sprintf ("DragEnter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DragMove) { return tl::sprintf ("DragMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DragLeave) { return tl::sprintf ("DragLeave (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Drop) { return tl::sprintf ("Drop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DragResponse) { return tl::sprintf ("DragResponse (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ChildAdded) { return tl::sprintf ("ChildAdded (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ChildPolished) { return tl::sprintf ("ChildPolished (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ChildRemoved) { return tl::sprintf ("ChildRemoved (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ShowWindowRequest) { return tl::sprintf ("ShowWindowRequest (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::PolishRequest) { return tl::sprintf ("PolishRequest (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Polish) { return tl::sprintf ("Polish (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::LayoutRequest) { return tl::sprintf ("LayoutRequest (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::UpdateRequest) { return tl::sprintf ("UpdateRequest (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::UpdateLater) { return tl::sprintf ("UpdateLater (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::EmbeddingControl) { return tl::sprintf ("EmbeddingControl (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ActivateControl) { return tl::sprintf ("ActivateControl (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DeactivateControl) { return tl::sprintf ("DeactivateControl (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ContextMenu) { return tl::sprintf ("ContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::InputMethod) { return tl::sprintf ("InputMethod (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::AccessibilityPrepare) { return tl::sprintf ("AccessibilityPrepare (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TabletMove) { return tl::sprintf ("TabletMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::LocaleChange) { return tl::sprintf ("LocaleChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::LanguageChange) { return tl::sprintf ("LanguageChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::LayoutDirectionChange) { return tl::sprintf ("LayoutDirectionChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Style) { return tl::sprintf ("Style (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TabletPress) { return tl::sprintf ("TabletPress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TabletRelease) { return tl::sprintf ("TabletRelease (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::OkRequest) { return tl::sprintf ("OkRequest (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::HelpRequest) { return tl::sprintf ("HelpRequest (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::IconDrag) { return tl::sprintf ("IconDrag (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::FontChange) { return tl::sprintf ("FontChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::EnabledChange) { return tl::sprintf ("EnabledChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ActivationChange) { return tl::sprintf ("ActivationChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::StyleChange) { return tl::sprintf ("StyleChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::IconTextChange) { return tl::sprintf ("IconTextChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ModifiedChange) { return tl::sprintf ("ModifiedChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MouseTrackingChange) { return tl::sprintf ("MouseTrackingChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowBlocked) { return tl::sprintf ("WindowBlocked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowUnblocked) { return tl::sprintf ("WindowUnblocked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WindowStateChange) { return tl::sprintf ("WindowStateChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ToolTip) { return tl::sprintf ("ToolTip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WhatsThis) { return tl::sprintf ("WhatsThis (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::StatusTip) { return tl::sprintf ("StatusTip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ActionChanged) { return tl::sprintf ("ActionChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ActionAdded) { return tl::sprintf ("ActionAdded (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ActionRemoved) { return tl::sprintf ("ActionRemoved (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::FileOpen) { return tl::sprintf ("FileOpen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Shortcut) { return tl::sprintf ("Shortcut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ShortcutOverride) { return tl::sprintf ("ShortcutOverride (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WhatsThisClicked) { return tl::sprintf ("WhatsThisClicked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ToolBarChange) { return tl::sprintf ("ToolBarChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationActivate) { return tl::sprintf ("ApplicationActivate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationActivated) { return tl::sprintf ("ApplicationActivated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationDeactivate) { return tl::sprintf ("ApplicationDeactivate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ApplicationDeactivated) { return tl::sprintf ("ApplicationDeactivated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::QueryWhatsThis) { return tl::sprintf ("QueryWhatsThis (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::EnterWhatsThisMode) { return tl::sprintf ("EnterWhatsThisMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::LeaveWhatsThisMode) { return tl::sprintf ("LeaveWhatsThisMode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ZOrderChange) { return tl::sprintf ("ZOrderChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::HoverEnter) { return tl::sprintf ("HoverEnter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::HoverLeave) { return tl::sprintf ("HoverLeave (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::HoverMove) { return tl::sprintf ("HoverMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::AccessibilityHelp) { return tl::sprintf ("AccessibilityHelp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::AccessibilityDescription) { return tl::sprintf ("AccessibilityDescription (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::AcceptDropsChange) { return tl::sprintf ("AcceptDropsChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MenubarUpdated) { return tl::sprintf ("MenubarUpdated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ZeroTimerEvent) { return tl::sprintf ("ZeroTimerEvent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneMouseMove) { return tl::sprintf ("GraphicsSceneMouseMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneMousePress) { return tl::sprintf ("GraphicsSceneMousePress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneMouseRelease) { return tl::sprintf ("GraphicsSceneMouseRelease (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneMouseDoubleClick) { return tl::sprintf ("GraphicsSceneMouseDoubleClick (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneContextMenu) { return tl::sprintf ("GraphicsSceneContextMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneHoverEnter) { return tl::sprintf ("GraphicsSceneHoverEnter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneHoverMove) { return tl::sprintf ("GraphicsSceneHoverMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneHoverLeave) { return tl::sprintf ("GraphicsSceneHoverLeave (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneHelp) { return tl::sprintf ("GraphicsSceneHelp (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneDragEnter) { return tl::sprintf ("GraphicsSceneDragEnter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneDragMove) { return tl::sprintf ("GraphicsSceneDragMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneDragLeave) { return tl::sprintf ("GraphicsSceneDragLeave (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneDrop) { return tl::sprintf ("GraphicsSceneDrop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneWheel) { return tl::sprintf ("GraphicsSceneWheel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::KeyboardLayoutChange) { return tl::sprintf ("KeyboardLayoutChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::DynamicPropertyChange) { return tl::sprintf ("DynamicPropertyChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TabletEnterProximity) { return tl::sprintf ("TabletEnterProximity (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TabletLeaveProximity) { return tl::sprintf ("TabletLeaveProximity (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::NonClientAreaMouseMove) { return tl::sprintf ("NonClientAreaMouseMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::NonClientAreaMouseButtonPress) { return tl::sprintf ("NonClientAreaMouseButtonPress (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::NonClientAreaMouseButtonRelease) { return tl::sprintf ("NonClientAreaMouseButtonRelease (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::NonClientAreaMouseButtonDblClick) { return tl::sprintf ("NonClientAreaMouseButtonDblClick (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MacSizeChange) { return tl::sprintf ("MacSizeChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ContentsRectChange) { return tl::sprintf ("ContentsRectChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MacGLWindowChange) { return tl::sprintf ("MacGLWindowChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::FutureCallOut) { return tl::sprintf ("FutureCallOut (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneResize) { return tl::sprintf ("GraphicsSceneResize (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GraphicsSceneMove) { return tl::sprintf ("GraphicsSceneMove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::CursorChange) { return tl::sprintf ("CursorChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::ToolTipChange) { return tl::sprintf ("ToolTipChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::NetworkReplyUpdated) { return tl::sprintf ("NetworkReplyUpdated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GrabMouse) { return tl::sprintf ("GrabMouse (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::UngrabMouse) { return tl::sprintf ("UngrabMouse (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GrabKeyboard) { return tl::sprintf ("GrabKeyboard (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::UngrabKeyboard) { return tl::sprintf ("UngrabKeyboard (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MacGLClearDrawable) { return tl::sprintf ("MacGLClearDrawable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::StateMachineSignal) { return tl::sprintf ("StateMachineSignal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::StateMachineWrapped) { return tl::sprintf ("StateMachineWrapped (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TouchBegin) { return tl::sprintf ("TouchBegin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TouchUpdate) { return tl::sprintf ("TouchUpdate (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::TouchEnd) { return tl::sprintf ("TouchEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::NativeGesture) { return tl::sprintf ("NativeGesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::RequestSoftwareInputPanel) { return tl::sprintf ("RequestSoftwareInputPanel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::CloseSoftwareInputPanel) { return tl::sprintf ("CloseSoftwareInputPanel (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::UpdateSoftKeys) { return tl::sprintf ("UpdateSoftKeys (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::WinIdChange) { return tl::sprintf ("WinIdChange (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::Gesture) { return tl::sprintf ("Gesture (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::GestureOverride) { return tl::sprintf ("GestureOverride (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::User) { return tl::sprintf ("User (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEvent::MaxUser) { return tl::sprintf ("MaxUser (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QEvent_Type_Enum (const QEvent_Type_Enum *e)
{
  return (unsigned int) e->value ();
}

static QEvent_Type_Enum *from_i_QEvent_Type_Enum (unsigned int i)
{
  return new QEvent_Type_Enum ((QEvent::Type) i);
}

static bool equalQEvent_Type_Enum (const QEvent_Type_Enum *e, QEvent_Type_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QEvent_Type_Enum (const QEvent_Type_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QEvent_Type_Enums oropQEvent_Type_Enums (const QEvent_Type_Enums *e, const QEvent_Type_Enums &d)
{
  return e->flags () | d.flags ();
}

static QEvent_Type_Enums andopQEvent_Type_Enums (const QEvent_Type_Enums *e, const QEvent_Type_Enums &d)
{
  return e->flags () & d.flags ();
}

static QEvent_Type_Enums xoropQEvent_Type_Enums (const QEvent_Type_Enums *e, const QEvent_Type_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QEvent_Type_Enums (const QEvent_Type_Enums *e)
{
  std::string l;
  if (e->testFlag (QEvent::None)) { if (!l.empty ()) l += "|"; l += "None"; }
  if (e->testFlag (QEvent::Timer)) { if (!l.empty ()) l += "|"; l += "Timer"; }
  if (e->testFlag (QEvent::MouseButtonPress)) { if (!l.empty ()) l += "|"; l += "MouseButtonPress"; }
  if (e->testFlag (QEvent::MouseButtonRelease)) { if (!l.empty ()) l += "|"; l += "MouseButtonRelease"; }
  if (e->testFlag (QEvent::MouseButtonDblClick)) { if (!l.empty ()) l += "|"; l += "MouseButtonDblClick"; }
  if (e->testFlag (QEvent::MouseMove)) { if (!l.empty ()) l += "|"; l += "MouseMove"; }
  if (e->testFlag (QEvent::KeyPress)) { if (!l.empty ()) l += "|"; l += "KeyPress"; }
  if (e->testFlag (QEvent::KeyRelease)) { if (!l.empty ()) l += "|"; l += "KeyRelease"; }
  if (e->testFlag (QEvent::FocusIn)) { if (!l.empty ()) l += "|"; l += "FocusIn"; }
  if (e->testFlag (QEvent::FocusOut)) { if (!l.empty ()) l += "|"; l += "FocusOut"; }
  if (e->testFlag (QEvent::Enter)) { if (!l.empty ()) l += "|"; l += "Enter"; }
  if (e->testFlag (QEvent::Leave)) { if (!l.empty ()) l += "|"; l += "Leave"; }
  if (e->testFlag (QEvent::Paint)) { if (!l.empty ()) l += "|"; l += "Paint"; }
  if (e->testFlag (QEvent::Move)) { if (!l.empty ()) l += "|"; l += "Move"; }
  if (e->testFlag (QEvent::Resize)) { if (!l.empty ()) l += "|"; l += "Resize"; }
  if (e->testFlag (QEvent::Create)) { if (!l.empty ()) l += "|"; l += "Create"; }
  if (e->testFlag (QEvent::Destroy)) { if (!l.empty ()) l += "|"; l += "Destroy"; }
  if (e->testFlag (QEvent::Show)) { if (!l.empty ()) l += "|"; l += "Show"; }
  if (e->testFlag (QEvent::Hide)) { if (!l.empty ()) l += "|"; l += "Hide"; }
  if (e->testFlag (QEvent::Close)) { if (!l.empty ()) l += "|"; l += "Close"; }
  if (e->testFlag (QEvent::Quit)) { if (!l.empty ()) l += "|"; l += "Quit"; }
  if (e->testFlag (QEvent::ParentChange)) { if (!l.empty ()) l += "|"; l += "ParentChange"; }
  if (e->testFlag (QEvent::ParentAboutToChange)) { if (!l.empty ()) l += "|"; l += "ParentAboutToChange"; }
  if (e->testFlag (QEvent::ThreadChange)) { if (!l.empty ()) l += "|"; l += "ThreadChange"; }
  if (e->testFlag (QEvent::WindowActivate)) { if (!l.empty ()) l += "|"; l += "WindowActivate"; }
  if (e->testFlag (QEvent::WindowDeactivate)) { if (!l.empty ()) l += "|"; l += "WindowDeactivate"; }
  if (e->testFlag (QEvent::ShowToParent)) { if (!l.empty ()) l += "|"; l += "ShowToParent"; }
  if (e->testFlag (QEvent::HideToParent)) { if (!l.empty ()) l += "|"; l += "HideToParent"; }
  if (e->testFlag (QEvent::Wheel)) { if (!l.empty ()) l += "|"; l += "Wheel"; }
  if (e->testFlag (QEvent::WindowTitleChange)) { if (!l.empty ()) l += "|"; l += "WindowTitleChange"; }
  if (e->testFlag (QEvent::WindowIconChange)) { if (!l.empty ()) l += "|"; l += "WindowIconChange"; }
  if (e->testFlag (QEvent::ApplicationWindowIconChange)) { if (!l.empty ()) l += "|"; l += "ApplicationWindowIconChange"; }
  if (e->testFlag (QEvent::ApplicationFontChange)) { if (!l.empty ()) l += "|"; l += "ApplicationFontChange"; }
  if (e->testFlag (QEvent::ApplicationLayoutDirectionChange)) { if (!l.empty ()) l += "|"; l += "ApplicationLayoutDirectionChange"; }
  if (e->testFlag (QEvent::ApplicationPaletteChange)) { if (!l.empty ()) l += "|"; l += "ApplicationPaletteChange"; }
  if (e->testFlag (QEvent::PaletteChange)) { if (!l.empty ()) l += "|"; l += "PaletteChange"; }
  if (e->testFlag (QEvent::Clipboard)) { if (!l.empty ()) l += "|"; l += "Clipboard"; }
  if (e->testFlag (QEvent::Speech)) { if (!l.empty ()) l += "|"; l += "Speech"; }
  if (e->testFlag (QEvent::MetaCall)) { if (!l.empty ()) l += "|"; l += "MetaCall"; }
  if (e->testFlag (QEvent::SockAct)) { if (!l.empty ()) l += "|"; l += "SockAct"; }
  if (e->testFlag (QEvent::WinEventAct)) { if (!l.empty ()) l += "|"; l += "WinEventAct"; }
  if (e->testFlag (QEvent::DeferredDelete)) { if (!l.empty ()) l += "|"; l += "DeferredDelete"; }
  if (e->testFlag (QEvent::DragEnter)) { if (!l.empty ()) l += "|"; l += "DragEnter"; }
  if (e->testFlag (QEvent::DragMove)) { if (!l.empty ()) l += "|"; l += "DragMove"; }
  if (e->testFlag (QEvent::DragLeave)) { if (!l.empty ()) l += "|"; l += "DragLeave"; }
  if (e->testFlag (QEvent::Drop)) { if (!l.empty ()) l += "|"; l += "Drop"; }
  if (e->testFlag (QEvent::DragResponse)) { if (!l.empty ()) l += "|"; l += "DragResponse"; }
  if (e->testFlag (QEvent::ChildAdded)) { if (!l.empty ()) l += "|"; l += "ChildAdded"; }
  if (e->testFlag (QEvent::ChildPolished)) { if (!l.empty ()) l += "|"; l += "ChildPolished"; }
  if (e->testFlag (QEvent::ChildRemoved)) { if (!l.empty ()) l += "|"; l += "ChildRemoved"; }
  if (e->testFlag (QEvent::ShowWindowRequest)) { if (!l.empty ()) l += "|"; l += "ShowWindowRequest"; }
  if (e->testFlag (QEvent::PolishRequest)) { if (!l.empty ()) l += "|"; l += "PolishRequest"; }
  if (e->testFlag (QEvent::Polish)) { if (!l.empty ()) l += "|"; l += "Polish"; }
  if (e->testFlag (QEvent::LayoutRequest)) { if (!l.empty ()) l += "|"; l += "LayoutRequest"; }
  if (e->testFlag (QEvent::UpdateRequest)) { if (!l.empty ()) l += "|"; l += "UpdateRequest"; }
  if (e->testFlag (QEvent::UpdateLater)) { if (!l.empty ()) l += "|"; l += "UpdateLater"; }
  if (e->testFlag (QEvent::EmbeddingControl)) { if (!l.empty ()) l += "|"; l += "EmbeddingControl"; }
  if (e->testFlag (QEvent::ActivateControl)) { if (!l.empty ()) l += "|"; l += "ActivateControl"; }
  if (e->testFlag (QEvent::DeactivateControl)) { if (!l.empty ()) l += "|"; l += "DeactivateControl"; }
  if (e->testFlag (QEvent::ContextMenu)) { if (!l.empty ()) l += "|"; l += "ContextMenu"; }
  if (e->testFlag (QEvent::InputMethod)) { if (!l.empty ()) l += "|"; l += "InputMethod"; }
  if (e->testFlag (QEvent::AccessibilityPrepare)) { if (!l.empty ()) l += "|"; l += "AccessibilityPrepare"; }
  if (e->testFlag (QEvent::TabletMove)) { if (!l.empty ()) l += "|"; l += "TabletMove"; }
  if (e->testFlag (QEvent::LocaleChange)) { if (!l.empty ()) l += "|"; l += "LocaleChange"; }
  if (e->testFlag (QEvent::LanguageChange)) { if (!l.empty ()) l += "|"; l += "LanguageChange"; }
  if (e->testFlag (QEvent::LayoutDirectionChange)) { if (!l.empty ()) l += "|"; l += "LayoutDirectionChange"; }
  if (e->testFlag (QEvent::Style)) { if (!l.empty ()) l += "|"; l += "Style"; }
  if (e->testFlag (QEvent::TabletPress)) { if (!l.empty ()) l += "|"; l += "TabletPress"; }
  if (e->testFlag (QEvent::TabletRelease)) { if (!l.empty ()) l += "|"; l += "TabletRelease"; }
  if (e->testFlag (QEvent::OkRequest)) { if (!l.empty ()) l += "|"; l += "OkRequest"; }
  if (e->testFlag (QEvent::HelpRequest)) { if (!l.empty ()) l += "|"; l += "HelpRequest"; }
  if (e->testFlag (QEvent::IconDrag)) { if (!l.empty ()) l += "|"; l += "IconDrag"; }
  if (e->testFlag (QEvent::FontChange)) { if (!l.empty ()) l += "|"; l += "FontChange"; }
  if (e->testFlag (QEvent::EnabledChange)) { if (!l.empty ()) l += "|"; l += "EnabledChange"; }
  if (e->testFlag (QEvent::ActivationChange)) { if (!l.empty ()) l += "|"; l += "ActivationChange"; }
  if (e->testFlag (QEvent::StyleChange)) { if (!l.empty ()) l += "|"; l += "StyleChange"; }
  if (e->testFlag (QEvent::IconTextChange)) { if (!l.empty ()) l += "|"; l += "IconTextChange"; }
  if (e->testFlag (QEvent::ModifiedChange)) { if (!l.empty ()) l += "|"; l += "ModifiedChange"; }
  if (e->testFlag (QEvent::MouseTrackingChange)) { if (!l.empty ()) l += "|"; l += "MouseTrackingChange"; }
  if (e->testFlag (QEvent::WindowBlocked)) { if (!l.empty ()) l += "|"; l += "WindowBlocked"; }
  if (e->testFlag (QEvent::WindowUnblocked)) { if (!l.empty ()) l += "|"; l += "WindowUnblocked"; }
  if (e->testFlag (QEvent::WindowStateChange)) { if (!l.empty ()) l += "|"; l += "WindowStateChange"; }
  if (e->testFlag (QEvent::ToolTip)) { if (!l.empty ()) l += "|"; l += "ToolTip"; }
  if (e->testFlag (QEvent::WhatsThis)) { if (!l.empty ()) l += "|"; l += "WhatsThis"; }
  if (e->testFlag (QEvent::StatusTip)) { if (!l.empty ()) l += "|"; l += "StatusTip"; }
  if (e->testFlag (QEvent::ActionChanged)) { if (!l.empty ()) l += "|"; l += "ActionChanged"; }
  if (e->testFlag (QEvent::ActionAdded)) { if (!l.empty ()) l += "|"; l += "ActionAdded"; }
  if (e->testFlag (QEvent::ActionRemoved)) { if (!l.empty ()) l += "|"; l += "ActionRemoved"; }
  if (e->testFlag (QEvent::FileOpen)) { if (!l.empty ()) l += "|"; l += "FileOpen"; }
  if (e->testFlag (QEvent::Shortcut)) { if (!l.empty ()) l += "|"; l += "Shortcut"; }
  if (e->testFlag (QEvent::ShortcutOverride)) { if (!l.empty ()) l += "|"; l += "ShortcutOverride"; }
  if (e->testFlag (QEvent::WhatsThisClicked)) { if (!l.empty ()) l += "|"; l += "WhatsThisClicked"; }
  if (e->testFlag (QEvent::ToolBarChange)) { if (!l.empty ()) l += "|"; l += "ToolBarChange"; }
  if (e->testFlag (QEvent::ApplicationActivate)) { if (!l.empty ()) l += "|"; l += "ApplicationActivate"; }
  if (e->testFlag (QEvent::ApplicationActivated)) { if (!l.empty ()) l += "|"; l += "ApplicationActivated"; }
  if (e->testFlag (QEvent::ApplicationDeactivate)) { if (!l.empty ()) l += "|"; l += "ApplicationDeactivate"; }
  if (e->testFlag (QEvent::ApplicationDeactivated)) { if (!l.empty ()) l += "|"; l += "ApplicationDeactivated"; }
  if (e->testFlag (QEvent::QueryWhatsThis)) { if (!l.empty ()) l += "|"; l += "QueryWhatsThis"; }
  if (e->testFlag (QEvent::EnterWhatsThisMode)) { if (!l.empty ()) l += "|"; l += "EnterWhatsThisMode"; }
  if (e->testFlag (QEvent::LeaveWhatsThisMode)) { if (!l.empty ()) l += "|"; l += "LeaveWhatsThisMode"; }
  if (e->testFlag (QEvent::ZOrderChange)) { if (!l.empty ()) l += "|"; l += "ZOrderChange"; }
  if (e->testFlag (QEvent::HoverEnter)) { if (!l.empty ()) l += "|"; l += "HoverEnter"; }
  if (e->testFlag (QEvent::HoverLeave)) { if (!l.empty ()) l += "|"; l += "HoverLeave"; }
  if (e->testFlag (QEvent::HoverMove)) { if (!l.empty ()) l += "|"; l += "HoverMove"; }
  if (e->testFlag (QEvent::AccessibilityHelp)) { if (!l.empty ()) l += "|"; l += "AccessibilityHelp"; }
  if (e->testFlag (QEvent::AccessibilityDescription)) { if (!l.empty ()) l += "|"; l += "AccessibilityDescription"; }
  if (e->testFlag (QEvent::AcceptDropsChange)) { if (!l.empty ()) l += "|"; l += "AcceptDropsChange"; }
  if (e->testFlag (QEvent::MenubarUpdated)) { if (!l.empty ()) l += "|"; l += "MenubarUpdated"; }
  if (e->testFlag (QEvent::ZeroTimerEvent)) { if (!l.empty ()) l += "|"; l += "ZeroTimerEvent"; }
  if (e->testFlag (QEvent::GraphicsSceneMouseMove)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneMouseMove"; }
  if (e->testFlag (QEvent::GraphicsSceneMousePress)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneMousePress"; }
  if (e->testFlag (QEvent::GraphicsSceneMouseRelease)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneMouseRelease"; }
  if (e->testFlag (QEvent::GraphicsSceneMouseDoubleClick)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneMouseDoubleClick"; }
  if (e->testFlag (QEvent::GraphicsSceneContextMenu)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneContextMenu"; }
  if (e->testFlag (QEvent::GraphicsSceneHoverEnter)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneHoverEnter"; }
  if (e->testFlag (QEvent::GraphicsSceneHoverMove)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneHoverMove"; }
  if (e->testFlag (QEvent::GraphicsSceneHoverLeave)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneHoverLeave"; }
  if (e->testFlag (QEvent::GraphicsSceneHelp)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneHelp"; }
  if (e->testFlag (QEvent::GraphicsSceneDragEnter)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneDragEnter"; }
  if (e->testFlag (QEvent::GraphicsSceneDragMove)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneDragMove"; }
  if (e->testFlag (QEvent::GraphicsSceneDragLeave)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneDragLeave"; }
  if (e->testFlag (QEvent::GraphicsSceneDrop)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneDrop"; }
  if (e->testFlag (QEvent::GraphicsSceneWheel)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneWheel"; }
  if (e->testFlag (QEvent::KeyboardLayoutChange)) { if (!l.empty ()) l += "|"; l += "KeyboardLayoutChange"; }
  if (e->testFlag (QEvent::DynamicPropertyChange)) { if (!l.empty ()) l += "|"; l += "DynamicPropertyChange"; }
  if (e->testFlag (QEvent::TabletEnterProximity)) { if (!l.empty ()) l += "|"; l += "TabletEnterProximity"; }
  if (e->testFlag (QEvent::TabletLeaveProximity)) { if (!l.empty ()) l += "|"; l += "TabletLeaveProximity"; }
  if (e->testFlag (QEvent::NonClientAreaMouseMove)) { if (!l.empty ()) l += "|"; l += "NonClientAreaMouseMove"; }
  if (e->testFlag (QEvent::NonClientAreaMouseButtonPress)) { if (!l.empty ()) l += "|"; l += "NonClientAreaMouseButtonPress"; }
  if (e->testFlag (QEvent::NonClientAreaMouseButtonRelease)) { if (!l.empty ()) l += "|"; l += "NonClientAreaMouseButtonRelease"; }
  if (e->testFlag (QEvent::NonClientAreaMouseButtonDblClick)) { if (!l.empty ()) l += "|"; l += "NonClientAreaMouseButtonDblClick"; }
  if (e->testFlag (QEvent::MacSizeChange)) { if (!l.empty ()) l += "|"; l += "MacSizeChange"; }
  if (e->testFlag (QEvent::ContentsRectChange)) { if (!l.empty ()) l += "|"; l += "ContentsRectChange"; }
  if (e->testFlag (QEvent::MacGLWindowChange)) { if (!l.empty ()) l += "|"; l += "MacGLWindowChange"; }
  if (e->testFlag (QEvent::FutureCallOut)) { if (!l.empty ()) l += "|"; l += "FutureCallOut"; }
  if (e->testFlag (QEvent::GraphicsSceneResize)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneResize"; }
  if (e->testFlag (QEvent::GraphicsSceneMove)) { if (!l.empty ()) l += "|"; l += "GraphicsSceneMove"; }
  if (e->testFlag (QEvent::CursorChange)) { if (!l.empty ()) l += "|"; l += "CursorChange"; }
  if (e->testFlag (QEvent::ToolTipChange)) { if (!l.empty ()) l += "|"; l += "ToolTipChange"; }
  if (e->testFlag (QEvent::NetworkReplyUpdated)) { if (!l.empty ()) l += "|"; l += "NetworkReplyUpdated"; }
  if (e->testFlag (QEvent::GrabMouse)) { if (!l.empty ()) l += "|"; l += "GrabMouse"; }
  if (e->testFlag (QEvent::UngrabMouse)) { if (!l.empty ()) l += "|"; l += "UngrabMouse"; }
  if (e->testFlag (QEvent::GrabKeyboard)) { if (!l.empty ()) l += "|"; l += "GrabKeyboard"; }
  if (e->testFlag (QEvent::UngrabKeyboard)) { if (!l.empty ()) l += "|"; l += "UngrabKeyboard"; }
  if (e->testFlag (QEvent::MacGLClearDrawable)) { if (!l.empty ()) l += "|"; l += "MacGLClearDrawable"; }
  if (e->testFlag (QEvent::StateMachineSignal)) { if (!l.empty ()) l += "|"; l += "StateMachineSignal"; }
  if (e->testFlag (QEvent::StateMachineWrapped)) { if (!l.empty ()) l += "|"; l += "StateMachineWrapped"; }
  if (e->testFlag (QEvent::TouchBegin)) { if (!l.empty ()) l += "|"; l += "TouchBegin"; }
  if (e->testFlag (QEvent::TouchUpdate)) { if (!l.empty ()) l += "|"; l += "TouchUpdate"; }
  if (e->testFlag (QEvent::TouchEnd)) { if (!l.empty ()) l += "|"; l += "TouchEnd"; }
  if (e->testFlag (QEvent::NativeGesture)) { if (!l.empty ()) l += "|"; l += "NativeGesture"; }
  if (e->testFlag (QEvent::RequestSoftwareInputPanel)) { if (!l.empty ()) l += "|"; l += "RequestSoftwareInputPanel"; }
  if (e->testFlag (QEvent::CloseSoftwareInputPanel)) { if (!l.empty ()) l += "|"; l += "CloseSoftwareInputPanel"; }
  if (e->testFlag (QEvent::UpdateSoftKeys)) { if (!l.empty ()) l += "|"; l += "UpdateSoftKeys"; }
  if (e->testFlag (QEvent::WinIdChange)) { if (!l.empty ()) l += "|"; l += "WinIdChange"; }
  if (e->testFlag (QEvent::Gesture)) { if (!l.empty ()) l += "|"; l += "Gesture"; }
  if (e->testFlag (QEvent::GestureOverride)) { if (!l.empty ()) l += "|"; l += "GestureOverride"; }
  if (e->testFlag (QEvent::User)) { if (!l.empty ()) l += "|"; l += "User"; }
  if (e->testFlag (QEvent::MaxUser)) { if (!l.empty ()) l += "|"; l += "MaxUser"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QEvent_Type_Enums (const QEvent_Type_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QEvent_Type_Enums (const QEvent_Type_Enums *e, const QEvent_Type_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QEvent_Type_Enums> decl_QEvent_Type_Enums ("QEvent_QFlags_Type",
  gsi::method_ext ("|", &qt_gsi::oropQEvent_Type_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQEvent_Type_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQEvent_Type_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QEvent_Type_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QEvent_Type_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QEvent_Type_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QEvent::Type> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QEvent_Type_Enum> decl_QEvent_Type_Enum (decl_QEvent_Type_Enums, "QEvent_Type",
  qt_gsi::mkdefs_QEvent_Type () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QEvent_Type_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QEvent_Type_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQEvent_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QEvent_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QEvent_Type_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QEvent::Type enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QEvent> inject_QEvent_Type_Enum_in_parent (qt_gsi::mkdefs_QEvent_Type ());
static gsi::ClassExt<QEvent> decl_QEvent_Type_Enum_as_child (decl_QEvent_Type_Enum, "Type");

}

