
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCryptographicHash.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQCryptographicHash_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCryptographicHash

//  Constructor QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm method)


static void _init_ctor_QCryptographicHash_3331 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("method");
  decl->add_arg<const qt_gsi::Converter<QCryptographicHash::Algorithm>::target_type & > (argspec_0);
  decl->set_return_new<QCryptographicHash *> ();
}

static void _call_ctor_QCryptographicHash_3331 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QCryptographicHash::Algorithm>::target_type & arg1 = args.read<const qt_gsi::Converter<QCryptographicHash::Algorithm>::target_type & > ();
  ret.write<QCryptographicHash *> (new QCryptographicHash (qt_gsi::QtToCppAdaptor<QCryptographicHash::Algorithm>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QCryptographicHash_3331 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCryptographicHash::QCryptographicHash(QCryptographicHash::Algorithm method)\nThis method creates an object of class QCryptographicHash.", &_init_ctor_QCryptographicHash_3331, &_call_ctor_QCryptographicHash_3331);
}

// void QCryptographicHash::addData(const char *data, int length)


static void _init_f_addData_2390 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("length");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addData_2390 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  int arg2 = args.read<int > ();
  ((QCryptographicHash *)cls)->addData (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addData_2390 ()
{
  return new qt_gsi::GenericMethod ("addData", "@brief Method void QCryptographicHash::addData(const char *data, int length)\n", false, &_init_f_addData_2390, &_call_f_addData_2390);
}

// void QCryptographicHash::addData(const QByteArray &data)


static void _init_f_addData_2309 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addData_2309 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ((QCryptographicHash *)cls)->addData (arg1);
}

static qt_gsi::GenericMethod *_create_f_addData_2309 ()
{
  return new qt_gsi::GenericMethod ("addData", "@brief Method void QCryptographicHash::addData(const QByteArray &data)\n", false, &_init_f_addData_2309, &_call_f_addData_2309);
}

// void QCryptographicHash::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCryptographicHash *)cls)->reset ();
}

static qt_gsi::GenericMethod *_create_f_reset_0 ()
{
  return new qt_gsi::GenericMethod ("reset", "@brief Method void QCryptographicHash::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
}

// QByteArray QCryptographicHash::result()


static void _init_f_result_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QByteArray > ();
}

static void _call_f_result_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QByteArray > ((QByteArray)((QCryptographicHash *)cls)->result ());
}

static qt_gsi::GenericMethod *_create_f_result_c0 ()
{
  return new qt_gsi::GenericMethod ("result", "@brief Method QByteArray QCryptographicHash::result()\n", true, &_init_f_result_c0, &_call_f_result_c0);
}

// static QByteArray QCryptographicHash::hash(const QByteArray &data, QCryptographicHash::Algorithm method)


static void _init_f_hash_5532 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QByteArray & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("method");
  decl->add_arg<const qt_gsi::Converter<QCryptographicHash::Algorithm>::target_type & > (argspec_1);
  decl->set_return<QByteArray > ();
}

static void _call_f_hash_5532 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  const qt_gsi::Converter<QCryptographicHash::Algorithm>::target_type & arg2 = args.read<const qt_gsi::Converter<QCryptographicHash::Algorithm>::target_type & > ();
  ret.write<QByteArray > ((QByteArray)QCryptographicHash::hash (arg1, qt_gsi::QtToCppAdaptor<QCryptographicHash::Algorithm>(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_hash_5532 ()
{
  return new qt_gsi::GenericStaticMethod ("hash", "@brief Static method QByteArray QCryptographicHash::hash(const QByteArray &data, QCryptographicHash::Algorithm method)\nThis method is static and can be called without an instance.", &_init_f_hash_5532, &_call_f_hash_5532);
}


namespace gsi
{
gsi::Class<QCryptographicHash> decl_QCryptographicHash ("QCryptographicHash",
  gsi::Methods(_create_ctor_QCryptographicHash_3331 ()) +
  gsi::Methods(_create_f_addData_2390 ()) +
  gsi::Methods(_create_f_addData_2309 ()) +
  gsi::Methods(_create_f_reset_0 ()) +
  gsi::Methods(_create_f_result_c0 ()) +
  gsi::Methods(_create_f_hash_5532 ()),
  "@qt\n@brief Binding of QCryptographicHash");

}


//  Implementation of the enum wrapper class for QCryptographicHash::Algorithm
namespace qt_gsi
{

static QCryptographicHash_Algorithm_Enum *c_1_QCryptographicHash_Algorithm_Enum () { return new QCryptographicHash_Algorithm_Enum (QCryptographicHash::Md4); }
static QCryptographicHash_Algorithm_Enum *c_2_QCryptographicHash_Algorithm_Enum () { return new QCryptographicHash_Algorithm_Enum (QCryptographicHash::Md5); }
static QCryptographicHash_Algorithm_Enum *c_3_QCryptographicHash_Algorithm_Enum () { return new QCryptographicHash_Algorithm_Enum (QCryptographicHash::Sha1); }

static gsi::Methods mkdefs_QCryptographicHash_Algorithm () {
  return
    gsi::constant ("Md4", &qt_gsi::c_1_QCryptographicHash_Algorithm_Enum, "@brief Enum constant QCryptographicHash::Md4") +
    gsi::constant ("Md5", &qt_gsi::c_2_QCryptographicHash_Algorithm_Enum, "@brief Enum constant QCryptographicHash::Md5") +
    gsi::constant ("Sha1", &qt_gsi::c_3_QCryptographicHash_Algorithm_Enum, "@brief Enum constant QCryptographicHash::Sha1");
}

static std::string to_s_QCryptographicHash_Algorithm_Enum (const QCryptographicHash_Algorithm_Enum *e)
{
  if (e->value () == QCryptographicHash::Md4) { return tl::sprintf ("Md4 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCryptographicHash::Md5) { return tl::sprintf ("Md5 (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCryptographicHash::Sha1) { return tl::sprintf ("Sha1 (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QCryptographicHash_Algorithm_Enum (const QCryptographicHash_Algorithm_Enum *e)
{
  return (unsigned int) e->value ();
}

static QCryptographicHash_Algorithm_Enum *from_i_QCryptographicHash_Algorithm_Enum (unsigned int i)
{
  return new QCryptographicHash_Algorithm_Enum ((QCryptographicHash::Algorithm) i);
}

static bool equalQCryptographicHash_Algorithm_Enum (const QCryptographicHash_Algorithm_Enum *e, QCryptographicHash_Algorithm_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QCryptographicHash_Algorithm_Enum (const QCryptographicHash_Algorithm_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QCryptographicHash_Algorithm_Enums oropQCryptographicHash_Algorithm_Enums (const QCryptographicHash_Algorithm_Enums *e, const QCryptographicHash_Algorithm_Enums &d)
{
  return e->flags () | d.flags ();
}

static QCryptographicHash_Algorithm_Enums andopQCryptographicHash_Algorithm_Enums (const QCryptographicHash_Algorithm_Enums *e, const QCryptographicHash_Algorithm_Enums &d)
{
  return e->flags () & d.flags ();
}

static QCryptographicHash_Algorithm_Enums xoropQCryptographicHash_Algorithm_Enums (const QCryptographicHash_Algorithm_Enums *e, const QCryptographicHash_Algorithm_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QCryptographicHash_Algorithm_Enums (const QCryptographicHash_Algorithm_Enums *e)
{
  std::string l;
  if (e->testFlag (QCryptographicHash::Md4)) { if (!l.empty ()) l += "|"; l += "Md4"; }
  if (e->testFlag (QCryptographicHash::Md5)) { if (!l.empty ()) l += "|"; l += "Md5"; }
  if (e->testFlag (QCryptographicHash::Sha1)) { if (!l.empty ()) l += "|"; l += "Sha1"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QCryptographicHash_Algorithm_Enums (const QCryptographicHash_Algorithm_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QCryptographicHash_Algorithm_Enums (const QCryptographicHash_Algorithm_Enums *e, const QCryptographicHash_Algorithm_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QCryptographicHash_Algorithm_Enums> decl_QCryptographicHash_Algorithm_Enums ("QCryptographicHash_QFlags_Algorithm",
  gsi::method_ext ("|", &qt_gsi::oropQCryptographicHash_Algorithm_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQCryptographicHash_Algorithm_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQCryptographicHash_Algorithm_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCryptographicHash_Algorithm_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCryptographicHash_Algorithm_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QCryptographicHash_Algorithm_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QCryptographicHash::Algorithm> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QCryptographicHash_Algorithm_Enum> decl_QCryptographicHash_Algorithm_Enum (decl_QCryptographicHash_Algorithm_Enums, "QCryptographicHash_Algorithm",
  qt_gsi::mkdefs_QCryptographicHash_Algorithm () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCryptographicHash_Algorithm_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCryptographicHash_Algorithm_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQCryptographicHash_Algorithm_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QCryptographicHash_Algorithm_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QCryptographicHash_Algorithm_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QCryptographicHash::Algorithm enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QCryptographicHash> inject_QCryptographicHash_Algorithm_Enum_in_parent (qt_gsi::mkdefs_QCryptographicHash_Algorithm ());
static gsi::ClassExt<QCryptographicHash> decl_QCryptographicHash_Algorithm_Enum_as_child (decl_QCryptographicHash_Algorithm_Enum, "Algorithm");

}

