
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQCalendarWidget.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQCalendarWidget_EventAdaptor.h"
#include "gsiDeclQCalendarWidget_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QCalendarWidget

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QCalendarWidget::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// int QCalendarWidget::dateEditAcceptDelay()


static void _init_f_dateEditAcceptDelay_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_dateEditAcceptDelay_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QCalendarWidget *)cls)->dateEditAcceptDelay ());
}

static qt_gsi::GenericMethod *_create_f_dateEditAcceptDelay_c0 ()
{
  return new qt_gsi::GenericMethod (":dateEditAcceptDelay", "@brief Method int QCalendarWidget::dateEditAcceptDelay()\n", true, &_init_f_dateEditAcceptDelay_c0, &_call_f_dateEditAcceptDelay_c0);
}

// Qt::DayOfWeek QCalendarWidget::firstDayOfWeek()


static void _init_f_firstDayOfWeek_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::DayOfWeek>::target_type > ();
}

static void _call_f_firstDayOfWeek_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::DayOfWeek>::target_type > ((qt_gsi::Converter<Qt::DayOfWeek>::target_type)qt_gsi::CppToQtAdaptor<Qt::DayOfWeek>(((QCalendarWidget *)cls)->firstDayOfWeek ()));
}

static qt_gsi::GenericMethod *_create_f_firstDayOfWeek_c0 ()
{
  return new qt_gsi::GenericMethod (":firstDayOfWeek", "@brief Method Qt::DayOfWeek QCalendarWidget::firstDayOfWeek()\n", true, &_init_f_firstDayOfWeek_c0, &_call_f_firstDayOfWeek_c0);
}

// QTextCharFormat QCalendarWidget::headerTextFormat()


static void _init_f_headerTextFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_headerTextFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QTextCharFormat > ((QTextCharFormat)((QCalendarWidget *)cls)->headerTextFormat ());
}

static qt_gsi::GenericMethod *_create_f_headerTextFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":headerTextFormat", "@brief Method QTextCharFormat QCalendarWidget::headerTextFormat()\n", true, &_init_f_headerTextFormat_c0, &_call_f_headerTextFormat_c0);
}

// QCalendarWidget::HorizontalHeaderFormat QCalendarWidget::horizontalHeaderFormat()


static void _init_f_horizontalHeaderFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type > ();
}

static void _call_f_horizontalHeaderFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type > ((qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type)qt_gsi::CppToQtAdaptor<QCalendarWidget::HorizontalHeaderFormat>(((QCalendarWidget *)cls)->horizontalHeaderFormat ()));
}

static qt_gsi::GenericMethod *_create_f_horizontalHeaderFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":horizontalHeaderFormat", "@brief Method QCalendarWidget::HorizontalHeaderFormat QCalendarWidget::horizontalHeaderFormat()\n", true, &_init_f_horizontalHeaderFormat_c0, &_call_f_horizontalHeaderFormat_c0);
}

// bool QCalendarWidget::isDateEditEnabled()


static void _init_f_isDateEditEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDateEditEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isDateEditEnabled ());
}

static qt_gsi::GenericMethod *_create_f_isDateEditEnabled_c0 ()
{
  return new qt_gsi::GenericMethod ("isDateEditEnabled?|:dateEditEnabled", "@brief Method bool QCalendarWidget::isDateEditEnabled()\n", true, &_init_f_isDateEditEnabled_c0, &_call_f_isDateEditEnabled_c0);
}

// bool QCalendarWidget::isGridVisible()


static void _init_f_isGridVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isGridVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isGridVisible ());
}

static qt_gsi::GenericMethod *_create_f_isGridVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isGridVisible?|:gridVisible", "@brief Method bool QCalendarWidget::isGridVisible()\n", true, &_init_f_isGridVisible_c0, &_call_f_isGridVisible_c0);
}

// bool QCalendarWidget::isHeaderVisible()


static void _init_f_isHeaderVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isHeaderVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isHeaderVisible ());
}

static qt_gsi::GenericMethod *_create_f_isHeaderVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isHeaderVisible?|:headerVisible", "@brief Method bool QCalendarWidget::isHeaderVisible()\n", true, &_init_f_isHeaderVisible_c0, &_call_f_isHeaderVisible_c0);
}

// bool QCalendarWidget::isNavigationBarVisible()


static void _init_f_isNavigationBarVisible_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNavigationBarVisible_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCalendarWidget *)cls)->isNavigationBarVisible ());
}

static qt_gsi::GenericMethod *_create_f_isNavigationBarVisible_c0 ()
{
  return new qt_gsi::GenericMethod ("isNavigationBarVisible?|:navigationBarVisible", "@brief Method bool QCalendarWidget::isNavigationBarVisible()\n", true, &_init_f_isNavigationBarVisible_c0, &_call_f_isNavigationBarVisible_c0);
}

// QDate QCalendarWidget::maximumDate()


static void _init_f_maximumDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_maximumDate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDate > ((QDate)((QCalendarWidget *)cls)->maximumDate ());
}

static qt_gsi::GenericMethod *_create_f_maximumDate_c0 ()
{
  return new qt_gsi::GenericMethod (":maximumDate", "@brief Method QDate QCalendarWidget::maximumDate()\n", true, &_init_f_maximumDate_c0, &_call_f_maximumDate_c0);
}

// QDate QCalendarWidget::minimumDate()


static void _init_f_minimumDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_minimumDate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDate > ((QDate)((QCalendarWidget *)cls)->minimumDate ());
}

static qt_gsi::GenericMethod *_create_f_minimumDate_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumDate", "@brief Method QDate QCalendarWidget::minimumDate()\n", true, &_init_f_minimumDate_c0, &_call_f_minimumDate_c0);
}

// QSize QCalendarWidget::minimumSizeHint()


static void _init_f_minimumSizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCalendarWidget *)cls)->minimumSizeHint ());
}

static qt_gsi::GenericMethod *_create_f_minimumSizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":minimumSizeHint", "@brief Method QSize QCalendarWidget::minimumSizeHint()\nThis is a reimplementation of QWidget::minimumSizeHint", true, &_init_f_minimumSizeHint_c0, &_call_f_minimumSizeHint_c0);
}

// int QCalendarWidget::monthShown()


static void _init_f_monthShown_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_monthShown_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QCalendarWidget *)cls)->monthShown ());
}

static qt_gsi::GenericMethod *_create_f_monthShown_c0 ()
{
  return new qt_gsi::GenericMethod ("monthShown", "@brief Method int QCalendarWidget::monthShown()\n", true, &_init_f_monthShown_c0, &_call_f_monthShown_c0);
}

// QDate QCalendarWidget::selectedDate()


static void _init_f_selectedDate_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDate > ();
}

static void _call_f_selectedDate_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDate > ((QDate)((QCalendarWidget *)cls)->selectedDate ());
}

static qt_gsi::GenericMethod *_create_f_selectedDate_c0 ()
{
  return new qt_gsi::GenericMethod (":selectedDate", "@brief Method QDate QCalendarWidget::selectedDate()\n", true, &_init_f_selectedDate_c0, &_call_f_selectedDate_c0);
}

// QCalendarWidget::SelectionMode QCalendarWidget::selectionMode()


static void _init_f_selectionMode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type > ();
}

static void _call_f_selectionMode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type > ((qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type)qt_gsi::CppToQtAdaptor<QCalendarWidget::SelectionMode>(((QCalendarWidget *)cls)->selectionMode ()));
}

static qt_gsi::GenericMethod *_create_f_selectionMode_c0 ()
{
  return new qt_gsi::GenericMethod (":selectionMode", "@brief Method QCalendarWidget::SelectionMode QCalendarWidget::selectionMode()\n", true, &_init_f_selectionMode_c0, &_call_f_selectionMode_c0);
}

// void QCalendarWidget::setCurrentPage(int year, int month)


static void _init_f_setCurrentPage_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("year");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("month");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setCurrentPage_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QCalendarWidget *)cls)->setCurrentPage (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setCurrentPage_1426 ()
{
  return new qt_gsi::GenericMethod ("setCurrentPage", "@brief Method void QCalendarWidget::setCurrentPage(int year, int month)\n", false, &_init_f_setCurrentPage_1426, &_call_f_setCurrentPage_1426);
}

// void QCalendarWidget::setDateEditAcceptDelay(int delay)


static void _init_f_setDateEditAcceptDelay_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("delay");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDateEditAcceptDelay_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QCalendarWidget *)cls)->setDateEditAcceptDelay (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDateEditAcceptDelay_767 ()
{
  return new qt_gsi::GenericMethod ("setDateEditAcceptDelay|dateEditAcceptDelay=", "@brief Method void QCalendarWidget::setDateEditAcceptDelay(int delay)\n", false, &_init_f_setDateEditAcceptDelay_767, &_call_f_setDateEditAcceptDelay_767);
}

// void QCalendarWidget::setDateEditEnabled(bool enable)


static void _init_f_setDateEditEnabled_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enable");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDateEditEnabled_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget *)cls)->setDateEditEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDateEditEnabled_864 ()
{
  return new qt_gsi::GenericMethod ("setDateEditEnabled|dateEditEnabled=", "@brief Method void QCalendarWidget::setDateEditEnabled(bool enable)\n", false, &_init_f_setDateEditEnabled_864, &_call_f_setDateEditEnabled_864);
}

// void QCalendarWidget::setDateRange(const QDate &min, const QDate &max)


static void _init_f_setDateRange_3444 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("min");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("max");
  decl->add_arg<const QDate & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDateRange_3444 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  const QDate &arg2 = args.read<const QDate & > ();
  ((QCalendarWidget *)cls)->setDateRange (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setDateRange_3444 ()
{
  return new qt_gsi::GenericMethod ("setDateRange", "@brief Method void QCalendarWidget::setDateRange(const QDate &min, const QDate &max)\n", false, &_init_f_setDateRange_3444, &_call_f_setDateRange_3444);
}

// void QCalendarWidget::setDateTextFormat(const QDate &date, const QTextCharFormat &format)


static void _init_f_setDateTextFormat_4482 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setDateTextFormat_4482 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  const QTextCharFormat &arg2 = args.read<const QTextCharFormat & > ();
  ((QCalendarWidget *)cls)->setDateTextFormat (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setDateTextFormat_4482 ()
{
  return new qt_gsi::GenericMethod ("setDateTextFormat", "@brief Method void QCalendarWidget::setDateTextFormat(const QDate &date, const QTextCharFormat &format)\n", false, &_init_f_setDateTextFormat_4482, &_call_f_setDateTextFormat_4482);
}

// void QCalendarWidget::setFirstDayOfWeek(Qt::DayOfWeek dayOfWeek)


static void _init_f_setFirstDayOfWeek_1612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dayOfWeek");
  decl->add_arg<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFirstDayOfWeek_1612 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DayOfWeek>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > ();
  ((QCalendarWidget *)cls)->setFirstDayOfWeek (qt_gsi::QtToCppAdaptor<Qt::DayOfWeek>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFirstDayOfWeek_1612 ()
{
  return new qt_gsi::GenericMethod ("setFirstDayOfWeek|firstDayOfWeek=", "@brief Method void QCalendarWidget::setFirstDayOfWeek(Qt::DayOfWeek dayOfWeek)\n", false, &_init_f_setFirstDayOfWeek_1612, &_call_f_setFirstDayOfWeek_1612);
}

// void QCalendarWidget::setGridVisible(bool show)


static void _init_f_setGridVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("show");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGridVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget *)cls)->setGridVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGridVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setGridVisible|gridVisible=", "@brief Method void QCalendarWidget::setGridVisible(bool show)\n", false, &_init_f_setGridVisible_864, &_call_f_setGridVisible_864);
}

// void QCalendarWidget::setHeaderTextFormat(const QTextCharFormat &format)


static void _init_f_setHeaderTextFormat_2814 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderTextFormat_2814 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QTextCharFormat &arg1 = args.read<const QTextCharFormat & > ();
  ((QCalendarWidget *)cls)->setHeaderTextFormat (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeaderTextFormat_2814 ()
{
  return new qt_gsi::GenericMethod ("setHeaderTextFormat|headerTextFormat=", "@brief Method void QCalendarWidget::setHeaderTextFormat(const QTextCharFormat &format)\n", false, &_init_f_setHeaderTextFormat_2814, &_call_f_setHeaderTextFormat_2814);
}

// void QCalendarWidget::setHeaderVisible(bool show)


static void _init_f_setHeaderVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("show");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHeaderVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget *)cls)->setHeaderVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setHeaderVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setHeaderVisible|headerVisible=", "@brief Method void QCalendarWidget::setHeaderVisible(bool show)\n", false, &_init_f_setHeaderVisible_864, &_call_f_setHeaderVisible_864);
}

// void QCalendarWidget::setHorizontalHeaderFormat(QCalendarWidget::HorizontalHeaderFormat format)


static void _init_f_setHorizontalHeaderFormat_4307 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalHeaderFormat_4307 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<QCalendarWidget::HorizontalHeaderFormat>::target_type & > ();
  ((QCalendarWidget *)cls)->setHorizontalHeaderFormat (qt_gsi::QtToCppAdaptor<QCalendarWidget::HorizontalHeaderFormat>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setHorizontalHeaderFormat_4307 ()
{
  return new qt_gsi::GenericMethod ("setHorizontalHeaderFormat|horizontalHeaderFormat=", "@brief Method void QCalendarWidget::setHorizontalHeaderFormat(QCalendarWidget::HorizontalHeaderFormat format)\n", false, &_init_f_setHorizontalHeaderFormat_4307, &_call_f_setHorizontalHeaderFormat_4307);
}

// void QCalendarWidget::setMaximumDate(const QDate &date)


static void _init_f_setMaximumDate_1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMaximumDate_1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ((QCalendarWidget *)cls)->setMaximumDate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMaximumDate_1776 ()
{
  return new qt_gsi::GenericMethod ("setMaximumDate|maximumDate=", "@brief Method void QCalendarWidget::setMaximumDate(const QDate &date)\n", false, &_init_f_setMaximumDate_1776, &_call_f_setMaximumDate_1776);
}

// void QCalendarWidget::setMinimumDate(const QDate &date)


static void _init_f_setMinimumDate_1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMinimumDate_1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ((QCalendarWidget *)cls)->setMinimumDate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setMinimumDate_1776 ()
{
  return new qt_gsi::GenericMethod ("setMinimumDate|minimumDate=", "@brief Method void QCalendarWidget::setMinimumDate(const QDate &date)\n", false, &_init_f_setMinimumDate_1776, &_call_f_setMinimumDate_1776);
}

// void QCalendarWidget::setNavigationBarVisible(bool visible)


static void _init_f_setNavigationBarVisible_864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNavigationBarVisible_864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget *)cls)->setNavigationBarVisible (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNavigationBarVisible_864 ()
{
  return new qt_gsi::GenericMethod ("setNavigationBarVisible|navigationBarVisible=", "@brief Method void QCalendarWidget::setNavigationBarVisible(bool visible)\n", false, &_init_f_setNavigationBarVisible_864, &_call_f_setNavigationBarVisible_864);
}

// void QCalendarWidget::setSelectedDate(const QDate &date)


static void _init_f_setSelectedDate_1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectedDate_1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ((QCalendarWidget *)cls)->setSelectedDate (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSelectedDate_1776 ()
{
  return new qt_gsi::GenericMethod ("setSelectedDate|selectedDate=", "@brief Method void QCalendarWidget::setSelectedDate(const QDate &date)\n", false, &_init_f_setSelectedDate_1776, &_call_f_setSelectedDate_1776);
}

// void QCalendarWidget::setSelectionMode(QCalendarWidget::SelectionMode mode)


static void _init_f_setSelectionMode_3362 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("mode");
  decl->add_arg<const qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSelectionMode_3362 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type & arg1 = args.read<const qt_gsi::Converter<QCalendarWidget::SelectionMode>::target_type & > ();
  ((QCalendarWidget *)cls)->setSelectionMode (qt_gsi::QtToCppAdaptor<QCalendarWidget::SelectionMode>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setSelectionMode_3362 ()
{
  return new qt_gsi::GenericMethod ("setSelectionMode|selectionMode=", "@brief Method void QCalendarWidget::setSelectionMode(QCalendarWidget::SelectionMode mode)\n", false, &_init_f_setSelectionMode_3362, &_call_f_setSelectionMode_3362);
}

// void QCalendarWidget::setVerticalHeaderFormat(QCalendarWidget::VerticalHeaderFormat format)


static void _init_f_setVerticalHeaderFormat_4067 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("format");
  decl->add_arg<const qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalHeaderFormat_4067 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type & arg1 = args.read<const qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type & > ();
  ((QCalendarWidget *)cls)->setVerticalHeaderFormat (qt_gsi::QtToCppAdaptor<QCalendarWidget::VerticalHeaderFormat>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setVerticalHeaderFormat_4067 ()
{
  return new qt_gsi::GenericMethod ("setVerticalHeaderFormat|verticalHeaderFormat=", "@brief Method void QCalendarWidget::setVerticalHeaderFormat(QCalendarWidget::VerticalHeaderFormat format)\n", false, &_init_f_setVerticalHeaderFormat_4067, &_call_f_setVerticalHeaderFormat_4067);
}

// void QCalendarWidget::setWeekdayTextFormat(Qt::DayOfWeek dayOfWeek, const QTextCharFormat &format)


static void _init_f_setWeekdayTextFormat_4318 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dayOfWeek");
  decl->add_arg<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("format");
  decl->add_arg<const QTextCharFormat & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setWeekdayTextFormat_4318 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DayOfWeek>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > ();
  const QTextCharFormat &arg2 = args.read<const QTextCharFormat & > ();
  ((QCalendarWidget *)cls)->setWeekdayTextFormat (qt_gsi::QtToCppAdaptor<Qt::DayOfWeek>(arg1).cref(), arg2);
}

static qt_gsi::GenericMethod *_create_f_setWeekdayTextFormat_4318 ()
{
  return new qt_gsi::GenericMethod ("setWeekdayTextFormat", "@brief Method void QCalendarWidget::setWeekdayTextFormat(Qt::DayOfWeek dayOfWeek, const QTextCharFormat &format)\n", false, &_init_f_setWeekdayTextFormat_4318, &_call_f_setWeekdayTextFormat_4318);
}

// void QCalendarWidget::showNextMonth()


static void _init_f_showNextMonth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNextMonth_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget *)cls)->showNextMonth ();
}

static qt_gsi::GenericMethod *_create_f_showNextMonth_0 ()
{
  return new qt_gsi::GenericMethod ("showNextMonth", "@brief Method void QCalendarWidget::showNextMonth()\n", false, &_init_f_showNextMonth_0, &_call_f_showNextMonth_0);
}

// void QCalendarWidget::showNextYear()


static void _init_f_showNextYear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showNextYear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget *)cls)->showNextYear ();
}

static qt_gsi::GenericMethod *_create_f_showNextYear_0 ()
{
  return new qt_gsi::GenericMethod ("showNextYear", "@brief Method void QCalendarWidget::showNextYear()\n", false, &_init_f_showNextYear_0, &_call_f_showNextYear_0);
}

// void QCalendarWidget::showPreviousMonth()


static void _init_f_showPreviousMonth_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showPreviousMonth_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget *)cls)->showPreviousMonth ();
}

static qt_gsi::GenericMethod *_create_f_showPreviousMonth_0 ()
{
  return new qt_gsi::GenericMethod ("showPreviousMonth", "@brief Method void QCalendarWidget::showPreviousMonth()\n", false, &_init_f_showPreviousMonth_0, &_call_f_showPreviousMonth_0);
}

// void QCalendarWidget::showPreviousYear()


static void _init_f_showPreviousYear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showPreviousYear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget *)cls)->showPreviousYear ();
}

static qt_gsi::GenericMethod *_create_f_showPreviousYear_0 ()
{
  return new qt_gsi::GenericMethod ("showPreviousYear", "@brief Method void QCalendarWidget::showPreviousYear()\n", false, &_init_f_showPreviousYear_0, &_call_f_showPreviousYear_0);
}

// void QCalendarWidget::showSelectedDate()


static void _init_f_showSelectedDate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showSelectedDate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget *)cls)->showSelectedDate ();
}

static qt_gsi::GenericMethod *_create_f_showSelectedDate_0 ()
{
  return new qt_gsi::GenericMethod ("showSelectedDate", "@brief Method void QCalendarWidget::showSelectedDate()\n", false, &_init_f_showSelectedDate_0, &_call_f_showSelectedDate_0);
}

// void QCalendarWidget::showToday()


static void _init_f_showToday_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_showToday_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget *)cls)->showToday ();
}

static qt_gsi::GenericMethod *_create_f_showToday_0 ()
{
  return new qt_gsi::GenericMethod ("showToday", "@brief Method void QCalendarWidget::showToday()\n", false, &_init_f_showToday_0, &_call_f_showToday_0);
}

// QSize QCalendarWidget::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCalendarWidget *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod (":sizeHint", "@brief Method QSize QCalendarWidget::sizeHint()\nThis is a reimplementation of QWidget::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// QCalendarWidget::VerticalHeaderFormat QCalendarWidget::verticalHeaderFormat()


static void _init_f_verticalHeaderFormat_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type > ();
}

static void _call_f_verticalHeaderFormat_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type > ((qt_gsi::Converter<QCalendarWidget::VerticalHeaderFormat>::target_type)qt_gsi::CppToQtAdaptor<QCalendarWidget::VerticalHeaderFormat>(((QCalendarWidget *)cls)->verticalHeaderFormat ()));
}

static qt_gsi::GenericMethod *_create_f_verticalHeaderFormat_c0 ()
{
  return new qt_gsi::GenericMethod (":verticalHeaderFormat", "@brief Method QCalendarWidget::VerticalHeaderFormat QCalendarWidget::verticalHeaderFormat()\n", true, &_init_f_verticalHeaderFormat_c0, &_call_f_verticalHeaderFormat_c0);
}

// QTextCharFormat QCalendarWidget::weekdayTextFormat(Qt::DayOfWeek dayOfWeek)


static void _init_f_weekdayTextFormat_c1612 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("dayOfWeek");
  decl->add_arg<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > (argspec_0);
  decl->set_return<QTextCharFormat > ();
}

static void _call_f_weekdayTextFormat_c1612 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::DayOfWeek>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::DayOfWeek>::target_type & > ();
  ret.write<QTextCharFormat > ((QTextCharFormat)((QCalendarWidget *)cls)->weekdayTextFormat (qt_gsi::QtToCppAdaptor<Qt::DayOfWeek>(arg1).cref()));
}

static qt_gsi::GenericMethod *_create_f_weekdayTextFormat_c1612 ()
{
  return new qt_gsi::GenericMethod ("weekdayTextFormat", "@brief Method QTextCharFormat QCalendarWidget::weekdayTextFormat(Qt::DayOfWeek dayOfWeek)\n", true, &_init_f_weekdayTextFormat_c1612, &_call_f_weekdayTextFormat_c1612);
}

// int QCalendarWidget::yearShown()


static void _init_f_yearShown_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_yearShown_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QCalendarWidget *)cls)->yearShown ());
}

static qt_gsi::GenericMethod *_create_f_yearShown_c0 ()
{
  return new qt_gsi::GenericMethod ("yearShown", "@brief Method int QCalendarWidget::yearShown()\n", true, &_init_f_yearShown_c0, &_call_f_yearShown_c0);
}

// static QString QCalendarWidget::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCalendarWidget::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCalendarWidget::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QCalendarWidget::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCalendarWidget::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QCalendarWidget::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QCalendarWidget::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QCalendarWidget::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCalendarWidget::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QCalendarWidget::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QCalendarWidget::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QCalendarWidget::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QCalendarWidget, QCalendarWidget_EventAdaptor> ea_QCalendarWidget;

namespace gsi
{
extern gsi::Class<QWidget> decl_QWidget;

gsi::Class<QCalendarWidget> decl_QCalendarWidget (ea_QCalendarWidget, decl_QWidget, "QCalendarWidget_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_dateEditAcceptDelay_c0 ()) +
  gsi::Methods(_create_f_firstDayOfWeek_c0 ()) +
  gsi::Methods(_create_f_headerTextFormat_c0 ()) +
  gsi::Methods(_create_f_horizontalHeaderFormat_c0 ()) +
  gsi::Methods(_create_f_isDateEditEnabled_c0 ()) +
  gsi::Methods(_create_f_isGridVisible_c0 ()) +
  gsi::Methods(_create_f_isHeaderVisible_c0 ()) +
  gsi::Methods(_create_f_isNavigationBarVisible_c0 ()) +
  gsi::Methods(_create_f_maximumDate_c0 ()) +
  gsi::Methods(_create_f_minimumDate_c0 ()) +
  gsi::Methods(_create_f_minimumSizeHint_c0 ()) +
  gsi::Methods(_create_f_monthShown_c0 ()) +
  gsi::Methods(_create_f_selectedDate_c0 ()) +
  gsi::Methods(_create_f_selectionMode_c0 ()) +
  gsi::Methods(_create_f_setCurrentPage_1426 ()) +
  gsi::Methods(_create_f_setDateEditAcceptDelay_767 ()) +
  gsi::Methods(_create_f_setDateEditEnabled_864 ()) +
  gsi::Methods(_create_f_setDateRange_3444 ()) +
  gsi::Methods(_create_f_setDateTextFormat_4482 ()) +
  gsi::Methods(_create_f_setFirstDayOfWeek_1612 ()) +
  gsi::Methods(_create_f_setGridVisible_864 ()) +
  gsi::Methods(_create_f_setHeaderTextFormat_2814 ()) +
  gsi::Methods(_create_f_setHeaderVisible_864 ()) +
  gsi::Methods(_create_f_setHorizontalHeaderFormat_4307 ()) +
  gsi::Methods(_create_f_setMaximumDate_1776 ()) +
  gsi::Methods(_create_f_setMinimumDate_1776 ()) +
  gsi::Methods(_create_f_setNavigationBarVisible_864 ()) +
  gsi::Methods(_create_f_setSelectedDate_1776 ()) +
  gsi::Methods(_create_f_setSelectionMode_3362 ()) +
  gsi::Methods(_create_f_setVerticalHeaderFormat_4067 ()) +
  gsi::Methods(_create_f_setWeekdayTextFormat_4318 ()) +
  gsi::Methods(_create_f_showNextMonth_0 ()) +
  gsi::Methods(_create_f_showNextYear_0 ()) +
  gsi::Methods(_create_f_showPreviousMonth_0 ()) +
  gsi::Methods(_create_f_showPreviousYear_0 ()) +
  gsi::Methods(_create_f_showSelectedDate_0 ()) +
  gsi::Methods(_create_f_showToday_0 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_verticalHeaderFormat_c0 ()) +
  gsi::Methods(_create_f_weekdayTextFormat_c1612 ()) +
  gsi::Methods(_create_f_yearShown_c0 ()) +
  qt_gsi::qt_signal<QCalendarWidget, QCalendarWidget_EventAdaptor, const QDate &> ("activated", &QCalendarWidget_EventAdaptor::activated_e_1776, gsi::arg("date"), "@brief Signal declaration for QCalendarWidget::activated(const QDate &date)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCalendarWidget, QCalendarWidget_EventAdaptor, const QDate &> ("clicked", &QCalendarWidget_EventAdaptor::clicked_e_1776, gsi::arg("date"), "@brief Signal declaration for QCalendarWidget::clicked(const QDate &date)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCalendarWidget, QCalendarWidget_EventAdaptor, int, int> ("currentPageChanged", &QCalendarWidget_EventAdaptor::currentPageChanged_e_1426, gsi::arg("year"), gsi::arg("month"), "@brief Signal declaration for QCalendarWidget::currentPageChanged(int year, int month)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCalendarWidget, QCalendarWidget_EventAdaptor, const QPoint &> ("customContextMenuRequested", &QCalendarWidget_EventAdaptor::customContextMenuRequested_e_1916, gsi::arg("pos"), "@brief Signal declaration for QCalendarWidget::customContextMenuRequested(const QPoint &pos)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCalendarWidget, QCalendarWidget_EventAdaptor, QObject *> ("destroyed", &QCalendarWidget_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QCalendarWidget::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QCalendarWidget, QCalendarWidget_EventAdaptor> ("selectionChanged", &QCalendarWidget_EventAdaptor::selectionChanged_e_0, "@brief Signal declaration for QCalendarWidget::selectionChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QCalendarWidget");
}


class QCalendarWidget_Adaptor : public QCalendarWidget, public qt_gsi::QtObjectBase
{
public:

  virtual ~QCalendarWidget_Adaptor();

  //  [adaptor ctor] QCalendarWidget::QCalendarWidget(QWidget *parent)
  QCalendarWidget_Adaptor() : QCalendarWidget()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QCalendarWidget::QCalendarWidget(QWidget *parent)
  QCalendarWidget_Adaptor(QWidget *parent) : QCalendarWidget(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QCalendarWidget::create(WId, bool initializeWindow, bool destroyOldWindow)
  void fp_QCalendarWidget_create_2208 (const qt_gsi::Converter<WId>::target_type & arg1, bool initializeWindow, bool destroyOldWindow) {
    QCalendarWidget::create(qt_gsi::QtToCppAdaptor<WId>(arg1).cref(), initializeWindow, destroyOldWindow);
  }

  //  void QCalendarWidget::destroy(bool destroyWindow, bool destroySubWindows)
  void fp_QCalendarWidget_destroy_1620 (bool destroyWindow, bool destroySubWindows) {
    QCalendarWidget::destroy(destroyWindow, destroySubWindows);
  }

  //  bool QCalendarWidget::focusNextChild()
  bool fp_QCalendarWidget_focusNextChild_0 () {
    return QCalendarWidget::focusNextChild();
  }

  //  bool QCalendarWidget::focusPreviousChild()
  bool fp_QCalendarWidget_focusPreviousChild_0 () {
    return QCalendarWidget::focusPreviousChild();
  }

  //  int QCalendarWidget::receivers(const char *signal)
  int fp_QCalendarWidget_receivers_c1731 (const char *signal) const {
    return QCalendarWidget::receivers(signal);
  }

  //  void QCalendarWidget::resetInputContext()
  void fp_QCalendarWidget_resetInputContext_0 () {
    QCalendarWidget::resetInputContext();
  }

  //  QObject *QCalendarWidget::sender()
  QObject * fp_QCalendarWidget_sender_c0 () const {
    return QCalendarWidget::sender();
  }

  //  void QCalendarWidget::updateCell(const QDate &date)
  void fp_QCalendarWidget_updateCell_1776 (const QDate &date) {
    QCalendarWidget::updateCell(date);
  }

  //  void QCalendarWidget::updateCells()
  void fp_QCalendarWidget_updateCells_0 () {
    QCalendarWidget::updateCells();
  }

  //  void QCalendarWidget::updateMicroFocus()
  void fp_QCalendarWidget_updateMicroFocus_0 () {
    QCalendarWidget::updateMicroFocus();
  }

  //  [adaptor impl] int QCalendarWidget::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QCalendarWidget::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QCalendarWidget_Adaptor, int, int>(&QCalendarWidget_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QCalendarWidget::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] QVariant QCalendarWidget::inputMethodQuery(Qt::InputMethodQuery)
  QVariant cbs_inputMethodQuery_c2420_0(const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1) const
  {
    return QCalendarWidget::inputMethodQuery(qt_gsi::QtToCppAdaptor<Qt::InputMethodQuery>(arg1).cref());
  }

  virtual QVariant inputMethodQuery(Qt::InputMethodQuery arg1) const
  {
    if (cb_inputMethodQuery_c2420_0.can_issue()) {
      return cb_inputMethodQuery_c2420_0.issue<QCalendarWidget_Adaptor, QVariant, const qt_gsi::Converter<Qt::InputMethodQuery>::target_type &>(&QCalendarWidget_Adaptor::cbs_inputMethodQuery_c2420_0, qt_gsi::CppToQtAdaptor<Qt::InputMethodQuery>(arg1));
    } else {
      return QCalendarWidget::inputMethodQuery(arg1);
    }
  }

  //  [adaptor impl] QSize QCalendarWidget::minimumSizeHint()
  QSize cbs_minimumSizeHint_c0_0() const
  {
    return QCalendarWidget::minimumSizeHint();
  }

  virtual QSize minimumSizeHint() const
  {
    if (cb_minimumSizeHint_c0_0.can_issue()) {
      return cb_minimumSizeHint_c0_0.issue<QCalendarWidget_Adaptor, QSize>(&QCalendarWidget_Adaptor::cbs_minimumSizeHint_c0_0);
    } else {
      return QCalendarWidget::minimumSizeHint();
    }
  }

  //  [adaptor impl] QPaintEngine *QCalendarWidget::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QCalendarWidget::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QCalendarWidget_Adaptor, QPaintEngine *>(&QCalendarWidget_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QCalendarWidget::paintEngine();
    }
  }

  //  [adaptor impl] void QCalendarWidget::setVisible(bool visible)
  void cbs_setVisible_864_0(bool visible)
  {
    QCalendarWidget::setVisible(visible);
  }

  virtual void setVisible(bool visible)
  {
    if (cb_setVisible_864_0.can_issue()) {
      cb_setVisible_864_0.issue<QCalendarWidget_Adaptor, bool>(&QCalendarWidget_Adaptor::cbs_setVisible_864_0, visible);
    } else {
      QCalendarWidget::setVisible(visible);
    }
  }

  //  [adaptor impl] QSize QCalendarWidget::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QCalendarWidget::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QCalendarWidget_Adaptor, QSize>(&QCalendarWidget_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QCalendarWidget::sizeHint();
    }
  }

  //  [adaptor impl] void QCalendarWidget::actionEvent(QActionEvent *)
  void cbs_actionEvent_1823_0(QActionEvent *arg1)
  {
    QCalendarWidget::actionEvent(arg1);
  }

  virtual void actionEvent(QActionEvent *arg1)
  {
    if (cb_actionEvent_1823_0.can_issue()) {
      cb_actionEvent_1823_0.issue<QCalendarWidget_Adaptor, QActionEvent *>(&QCalendarWidget_Adaptor::cbs_actionEvent_1823_0, arg1);
    } else {
      QCalendarWidget::actionEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::changeEvent(QEvent *)
  void cbs_changeEvent_1217_0(QEvent *arg1)
  {
    QCalendarWidget::changeEvent(arg1);
  }

  virtual void changeEvent(QEvent *arg1)
  {
    if (cb_changeEvent_1217_0.can_issue()) {
      cb_changeEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_changeEvent_1217_0, arg1);
    } else {
      QCalendarWidget::changeEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QCalendarWidget::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QCalendarWidget_Adaptor, QChildEvent *>(&QCalendarWidget_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QCalendarWidget::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::closeEvent(QCloseEvent *)
  void cbs_closeEvent_1719_0(QCloseEvent *arg1)
  {
    QCalendarWidget::closeEvent(arg1);
  }

  virtual void closeEvent(QCloseEvent *arg1)
  {
    if (cb_closeEvent_1719_0.can_issue()) {
      cb_closeEvent_1719_0.issue<QCalendarWidget_Adaptor, QCloseEvent *>(&QCalendarWidget_Adaptor::cbs_closeEvent_1719_0, arg1);
    } else {
      QCalendarWidget::closeEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::contextMenuEvent(QContextMenuEvent *)
  void cbs_contextMenuEvent_2363_0(QContextMenuEvent *arg1)
  {
    QCalendarWidget::contextMenuEvent(arg1);
  }

  virtual void contextMenuEvent(QContextMenuEvent *arg1)
  {
    if (cb_contextMenuEvent_2363_0.can_issue()) {
      cb_contextMenuEvent_2363_0.issue<QCalendarWidget_Adaptor, QContextMenuEvent *>(&QCalendarWidget_Adaptor::cbs_contextMenuEvent_2363_0, arg1);
    } else {
      QCalendarWidget::contextMenuEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QCalendarWidget::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QCalendarWidget::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QCalendarWidget::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QCalendarWidget_Adaptor, const char *>(&QCalendarWidget_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QCalendarWidget::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dragEnterEvent(QDragEnterEvent *)
  void cbs_dragEnterEvent_2109_0(QDragEnterEvent *arg1)
  {
    QCalendarWidget::dragEnterEvent(arg1);
  }

  virtual void dragEnterEvent(QDragEnterEvent *arg1)
  {
    if (cb_dragEnterEvent_2109_0.can_issue()) {
      cb_dragEnterEvent_2109_0.issue<QCalendarWidget_Adaptor, QDragEnterEvent *>(&QCalendarWidget_Adaptor::cbs_dragEnterEvent_2109_0, arg1);
    } else {
      QCalendarWidget::dragEnterEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dragLeaveEvent(QDragLeaveEvent *)
  void cbs_dragLeaveEvent_2092_0(QDragLeaveEvent *arg1)
  {
    QCalendarWidget::dragLeaveEvent(arg1);
  }

  virtual void dragLeaveEvent(QDragLeaveEvent *arg1)
  {
    if (cb_dragLeaveEvent_2092_0.can_issue()) {
      cb_dragLeaveEvent_2092_0.issue<QCalendarWidget_Adaptor, QDragLeaveEvent *>(&QCalendarWidget_Adaptor::cbs_dragLeaveEvent_2092_0, arg1);
    } else {
      QCalendarWidget::dragLeaveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dragMoveEvent(QDragMoveEvent *)
  void cbs_dragMoveEvent_2006_0(QDragMoveEvent *arg1)
  {
    QCalendarWidget::dragMoveEvent(arg1);
  }

  virtual void dragMoveEvent(QDragMoveEvent *arg1)
  {
    if (cb_dragMoveEvent_2006_0.can_issue()) {
      cb_dragMoveEvent_2006_0.issue<QCalendarWidget_Adaptor, QDragMoveEvent *>(&QCalendarWidget_Adaptor::cbs_dragMoveEvent_2006_0, arg1);
    } else {
      QCalendarWidget::dragMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::dropEvent(QDropEvent *)
  void cbs_dropEvent_1622_0(QDropEvent *arg1)
  {
    QCalendarWidget::dropEvent(arg1);
  }

  virtual void dropEvent(QDropEvent *arg1)
  {
    if (cb_dropEvent_1622_0.can_issue()) {
      cb_dropEvent_1622_0.issue<QCalendarWidget_Adaptor, QDropEvent *>(&QCalendarWidget_Adaptor::cbs_dropEvent_1622_0, arg1);
    } else {
      QCalendarWidget::dropEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::enabledChange(bool)
  void cbs_enabledChange_864_0(bool arg1)
  {
    QCalendarWidget::enabledChange(arg1);
  }

  virtual void enabledChange(bool arg1)
  {
    if (cb_enabledChange_864_0.can_issue()) {
      cb_enabledChange_864_0.issue<QCalendarWidget_Adaptor, bool>(&QCalendarWidget_Adaptor::cbs_enabledChange_864_0, arg1);
    } else {
      QCalendarWidget::enabledChange(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::enterEvent(QEvent *)
  void cbs_enterEvent_1217_0(QEvent *arg1)
  {
    QCalendarWidget::enterEvent(arg1);
  }

  virtual void enterEvent(QEvent *arg1)
  {
    if (cb_enterEvent_1217_0.can_issue()) {
      cb_enterEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_enterEvent_1217_0, arg1);
    } else {
      QCalendarWidget::enterEvent(arg1);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QCalendarWidget::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QCalendarWidget_Adaptor, bool, QEvent *>(&QCalendarWidget_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QCalendarWidget::event(_event);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QCalendarWidget::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QCalendarWidget_Adaptor, bool, QObject *, QEvent *>(&QCalendarWidget_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QCalendarWidget::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::focusInEvent(QFocusEvent *)
  void cbs_focusInEvent_1729_0(QFocusEvent *arg1)
  {
    QCalendarWidget::focusInEvent(arg1);
  }

  virtual void focusInEvent(QFocusEvent *arg1)
  {
    if (cb_focusInEvent_1729_0.can_issue()) {
      cb_focusInEvent_1729_0.issue<QCalendarWidget_Adaptor, QFocusEvent *>(&QCalendarWidget_Adaptor::cbs_focusInEvent_1729_0, arg1);
    } else {
      QCalendarWidget::focusInEvent(arg1);
    }
  }

  //  [adaptor impl] bool QCalendarWidget::focusNextPrevChild(bool next)
  bool cbs_focusNextPrevChild_864_0(bool next)
  {
    return QCalendarWidget::focusNextPrevChild(next);
  }

  virtual bool focusNextPrevChild(bool next)
  {
    if (cb_focusNextPrevChild_864_0.can_issue()) {
      return cb_focusNextPrevChild_864_0.issue<QCalendarWidget_Adaptor, bool, bool>(&QCalendarWidget_Adaptor::cbs_focusNextPrevChild_864_0, next);
    } else {
      return QCalendarWidget::focusNextPrevChild(next);
    }
  }

  //  [adaptor impl] void QCalendarWidget::focusOutEvent(QFocusEvent *)
  void cbs_focusOutEvent_1729_0(QFocusEvent *arg1)
  {
    QCalendarWidget::focusOutEvent(arg1);
  }

  virtual void focusOutEvent(QFocusEvent *arg1)
  {
    if (cb_focusOutEvent_1729_0.can_issue()) {
      cb_focusOutEvent_1729_0.issue<QCalendarWidget_Adaptor, QFocusEvent *>(&QCalendarWidget_Adaptor::cbs_focusOutEvent_1729_0, arg1);
    } else {
      QCalendarWidget::focusOutEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::fontChange(const QFont &)
  void cbs_fontChange_1801_0(const QFont &arg1)
  {
    QCalendarWidget::fontChange(arg1);
  }

  virtual void fontChange(const QFont &arg1)
  {
    if (cb_fontChange_1801_0.can_issue()) {
      cb_fontChange_1801_0.issue<QCalendarWidget_Adaptor, const QFont &>(&QCalendarWidget_Adaptor::cbs_fontChange_1801_0, arg1);
    } else {
      QCalendarWidget::fontChange(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::hideEvent(QHideEvent *)
  void cbs_hideEvent_1595_0(QHideEvent *arg1)
  {
    QCalendarWidget::hideEvent(arg1);
  }

  virtual void hideEvent(QHideEvent *arg1)
  {
    if (cb_hideEvent_1595_0.can_issue()) {
      cb_hideEvent_1595_0.issue<QCalendarWidget_Adaptor, QHideEvent *>(&QCalendarWidget_Adaptor::cbs_hideEvent_1595_0, arg1);
    } else {
      QCalendarWidget::hideEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::inputMethodEvent(QInputMethodEvent *)
  void cbs_inputMethodEvent_2354_0(QInputMethodEvent *arg1)
  {
    QCalendarWidget::inputMethodEvent(arg1);
  }

  virtual void inputMethodEvent(QInputMethodEvent *arg1)
  {
    if (cb_inputMethodEvent_2354_0.can_issue()) {
      cb_inputMethodEvent_2354_0.issue<QCalendarWidget_Adaptor, QInputMethodEvent *>(&QCalendarWidget_Adaptor::cbs_inputMethodEvent_2354_0, arg1);
    } else {
      QCalendarWidget::inputMethodEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::keyPressEvent(QKeyEvent *event)
  void cbs_keyPressEvent_1514_0(QKeyEvent *event)
  {
    QCalendarWidget::keyPressEvent(event);
  }

  virtual void keyPressEvent(QKeyEvent *event)
  {
    if (cb_keyPressEvent_1514_0.can_issue()) {
      cb_keyPressEvent_1514_0.issue<QCalendarWidget_Adaptor, QKeyEvent *>(&QCalendarWidget_Adaptor::cbs_keyPressEvent_1514_0, event);
    } else {
      QCalendarWidget::keyPressEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::keyReleaseEvent(QKeyEvent *)
  void cbs_keyReleaseEvent_1514_0(QKeyEvent *arg1)
  {
    QCalendarWidget::keyReleaseEvent(arg1);
  }

  virtual void keyReleaseEvent(QKeyEvent *arg1)
  {
    if (cb_keyReleaseEvent_1514_0.can_issue()) {
      cb_keyReleaseEvent_1514_0.issue<QCalendarWidget_Adaptor, QKeyEvent *>(&QCalendarWidget_Adaptor::cbs_keyReleaseEvent_1514_0, arg1);
    } else {
      QCalendarWidget::keyReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::languageChange()
  void cbs_languageChange_0_0()
  {
    QCalendarWidget::languageChange();
  }

  virtual void languageChange()
  {
    if (cb_languageChange_0_0.can_issue()) {
      cb_languageChange_0_0.issue<QCalendarWidget_Adaptor>(&QCalendarWidget_Adaptor::cbs_languageChange_0_0);
    } else {
      QCalendarWidget::languageChange();
    }
  }

  //  [adaptor impl] void QCalendarWidget::leaveEvent(QEvent *)
  void cbs_leaveEvent_1217_0(QEvent *arg1)
  {
    QCalendarWidget::leaveEvent(arg1);
  }

  virtual void leaveEvent(QEvent *arg1)
  {
    if (cb_leaveEvent_1217_0.can_issue()) {
      cb_leaveEvent_1217_0.issue<QCalendarWidget_Adaptor, QEvent *>(&QCalendarWidget_Adaptor::cbs_leaveEvent_1217_0, arg1);
    } else {
      QCalendarWidget::leaveEvent(arg1);
    }
  }

  //  [adaptor impl] int QCalendarWidget::metric(QPaintDevice::PaintDeviceMetric)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1) const
  {
    return QCalendarWidget::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(arg1).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric arg1) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QCalendarWidget_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QCalendarWidget_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(arg1));
    } else {
      return QCalendarWidget::metric(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mouseDoubleClickEvent(QMouseEvent *)
  void cbs_mouseDoubleClickEvent_1738_0(QMouseEvent *arg1)
  {
    QCalendarWidget::mouseDoubleClickEvent(arg1);
  }

  virtual void mouseDoubleClickEvent(QMouseEvent *arg1)
  {
    if (cb_mouseDoubleClickEvent_1738_0.can_issue()) {
      cb_mouseDoubleClickEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mouseDoubleClickEvent_1738_0, arg1);
    } else {
      QCalendarWidget::mouseDoubleClickEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mouseMoveEvent(QMouseEvent *)
  void cbs_mouseMoveEvent_1738_0(QMouseEvent *arg1)
  {
    QCalendarWidget::mouseMoveEvent(arg1);
  }

  virtual void mouseMoveEvent(QMouseEvent *arg1)
  {
    if (cb_mouseMoveEvent_1738_0.can_issue()) {
      cb_mouseMoveEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mouseMoveEvent_1738_0, arg1);
    } else {
      QCalendarWidget::mouseMoveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mousePressEvent(QMouseEvent *event)
  void cbs_mousePressEvent_1738_0(QMouseEvent *event)
  {
    QCalendarWidget::mousePressEvent(event);
  }

  virtual void mousePressEvent(QMouseEvent *event)
  {
    if (cb_mousePressEvent_1738_0.can_issue()) {
      cb_mousePressEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mousePressEvent_1738_0, event);
    } else {
      QCalendarWidget::mousePressEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::mouseReleaseEvent(QMouseEvent *)
  void cbs_mouseReleaseEvent_1738_0(QMouseEvent *arg1)
  {
    QCalendarWidget::mouseReleaseEvent(arg1);
  }

  virtual void mouseReleaseEvent(QMouseEvent *arg1)
  {
    if (cb_mouseReleaseEvent_1738_0.can_issue()) {
      cb_mouseReleaseEvent_1738_0.issue<QCalendarWidget_Adaptor, QMouseEvent *>(&QCalendarWidget_Adaptor::cbs_mouseReleaseEvent_1738_0, arg1);
    } else {
      QCalendarWidget::mouseReleaseEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::moveEvent(QMoveEvent *)
  void cbs_moveEvent_1624_0(QMoveEvent *arg1)
  {
    QCalendarWidget::moveEvent(arg1);
  }

  virtual void moveEvent(QMoveEvent *arg1)
  {
    if (cb_moveEvent_1624_0.can_issue()) {
      cb_moveEvent_1624_0.issue<QCalendarWidget_Adaptor, QMoveEvent *>(&QCalendarWidget_Adaptor::cbs_moveEvent_1624_0, arg1);
    } else {
      QCalendarWidget::moveEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::paintCell(QPainter *painter, const QRect &rect, const QDate &date)
  void cbs_paintCell_c4778_0(QPainter *painter, const QRect &rect, const QDate &date) const
  {
    QCalendarWidget::paintCell(painter, rect, date);
  }

  virtual void paintCell(QPainter *painter, const QRect &rect, const QDate &date) const
  {
    if (cb_paintCell_c4778_0.can_issue()) {
      cb_paintCell_c4778_0.issue<QCalendarWidget_Adaptor, QPainter *, const QRect &, const QDate &>(&QCalendarWidget_Adaptor::cbs_paintCell_c4778_0, painter, rect, date);
    } else {
      QCalendarWidget::paintCell(painter, rect, date);
    }
  }

  //  [adaptor impl] void QCalendarWidget::paintEvent(QPaintEvent *)
  void cbs_paintEvent_1725_0(QPaintEvent *arg1)
  {
    QCalendarWidget::paintEvent(arg1);
  }

  virtual void paintEvent(QPaintEvent *arg1)
  {
    if (cb_paintEvent_1725_0.can_issue()) {
      cb_paintEvent_1725_0.issue<QCalendarWidget_Adaptor, QPaintEvent *>(&QCalendarWidget_Adaptor::cbs_paintEvent_1725_0, arg1);
    } else {
      QCalendarWidget::paintEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::paletteChange(const QPalette &)
  void cbs_paletteChange_2113_0(const QPalette &arg1)
  {
    QCalendarWidget::paletteChange(arg1);
  }

  virtual void paletteChange(const QPalette &arg1)
  {
    if (cb_paletteChange_2113_0.can_issue()) {
      cb_paletteChange_2113_0.issue<QCalendarWidget_Adaptor, const QPalette &>(&QCalendarWidget_Adaptor::cbs_paletteChange_2113_0, arg1);
    } else {
      QCalendarWidget::paletteChange(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::resizeEvent(QResizeEvent *event)
  void cbs_resizeEvent_1843_0(QResizeEvent *event)
  {
    QCalendarWidget::resizeEvent(event);
  }

  virtual void resizeEvent(QResizeEvent *event)
  {
    if (cb_resizeEvent_1843_0.can_issue()) {
      cb_resizeEvent_1843_0.issue<QCalendarWidget_Adaptor, QResizeEvent *>(&QCalendarWidget_Adaptor::cbs_resizeEvent_1843_0, event);
    } else {
      QCalendarWidget::resizeEvent(event);
    }
  }

  //  [adaptor impl] void QCalendarWidget::showEvent(QShowEvent *)
  void cbs_showEvent_1634_0(QShowEvent *arg1)
  {
    QCalendarWidget::showEvent(arg1);
  }

  virtual void showEvent(QShowEvent *arg1)
  {
    if (cb_showEvent_1634_0.can_issue()) {
      cb_showEvent_1634_0.issue<QCalendarWidget_Adaptor, QShowEvent *>(&QCalendarWidget_Adaptor::cbs_showEvent_1634_0, arg1);
    } else {
      QCalendarWidget::showEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::styleChange(QStyle &)
  void cbs_styleChange_1228_0(QStyle &arg1)
  {
    QCalendarWidget::styleChange(arg1);
  }

  virtual void styleChange(QStyle &arg1)
  {
    if (cb_styleChange_1228_0.can_issue()) {
      cb_styleChange_1228_0.issue<QCalendarWidget_Adaptor, QStyle &>(&QCalendarWidget_Adaptor::cbs_styleChange_1228_0, arg1);
    } else {
      QCalendarWidget::styleChange(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::tabletEvent(QTabletEvent *)
  void cbs_tabletEvent_1821_0(QTabletEvent *arg1)
  {
    QCalendarWidget::tabletEvent(arg1);
  }

  virtual void tabletEvent(QTabletEvent *arg1)
  {
    if (cb_tabletEvent_1821_0.can_issue()) {
      cb_tabletEvent_1821_0.issue<QCalendarWidget_Adaptor, QTabletEvent *>(&QCalendarWidget_Adaptor::cbs_tabletEvent_1821_0, arg1);
    } else {
      QCalendarWidget::tabletEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QCalendarWidget::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QCalendarWidget_Adaptor, QTimerEvent *>(&QCalendarWidget_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QCalendarWidget::timerEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::wheelEvent(QWheelEvent *)
  void cbs_wheelEvent_1718_0(QWheelEvent *arg1)
  {
    QCalendarWidget::wheelEvent(arg1);
  }

  virtual void wheelEvent(QWheelEvent *arg1)
  {
    if (cb_wheelEvent_1718_0.can_issue()) {
      cb_wheelEvent_1718_0.issue<QCalendarWidget_Adaptor, QWheelEvent *>(&QCalendarWidget_Adaptor::cbs_wheelEvent_1718_0, arg1);
    } else {
      QCalendarWidget::wheelEvent(arg1);
    }
  }

  //  [adaptor impl] void QCalendarWidget::windowActivationChange(bool)
  void cbs_windowActivationChange_864_0(bool arg1)
  {
    QCalendarWidget::windowActivationChange(arg1);
  }

  virtual void windowActivationChange(bool arg1)
  {
    if (cb_windowActivationChange_864_0.can_issue()) {
      cb_windowActivationChange_864_0.issue<QCalendarWidget_Adaptor, bool>(&QCalendarWidget_Adaptor::cbs_windowActivationChange_864_0, arg1);
    } else {
      QCalendarWidget::windowActivationChange(arg1);
    }
  }

  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_inputMethodQuery_c2420_0;
  gsi::Callback cb_minimumSizeHint_c0_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_setVisible_864_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_actionEvent_1823_0;
  gsi::Callback cb_changeEvent_1217_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_closeEvent_1719_0;
  gsi::Callback cb_contextMenuEvent_2363_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_dragEnterEvent_2109_0;
  gsi::Callback cb_dragLeaveEvent_2092_0;
  gsi::Callback cb_dragMoveEvent_2006_0;
  gsi::Callback cb_dropEvent_1622_0;
  gsi::Callback cb_enabledChange_864_0;
  gsi::Callback cb_enterEvent_1217_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_focusInEvent_1729_0;
  gsi::Callback cb_focusNextPrevChild_864_0;
  gsi::Callback cb_focusOutEvent_1729_0;
  gsi::Callback cb_fontChange_1801_0;
  gsi::Callback cb_hideEvent_1595_0;
  gsi::Callback cb_inputMethodEvent_2354_0;
  gsi::Callback cb_keyPressEvent_1514_0;
  gsi::Callback cb_keyReleaseEvent_1514_0;
  gsi::Callback cb_languageChange_0_0;
  gsi::Callback cb_leaveEvent_1217_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_mouseDoubleClickEvent_1738_0;
  gsi::Callback cb_mouseMoveEvent_1738_0;
  gsi::Callback cb_mousePressEvent_1738_0;
  gsi::Callback cb_mouseReleaseEvent_1738_0;
  gsi::Callback cb_moveEvent_1624_0;
  gsi::Callback cb_paintCell_c4778_0;
  gsi::Callback cb_paintEvent_1725_0;
  gsi::Callback cb_paletteChange_2113_0;
  gsi::Callback cb_resizeEvent_1843_0;
  gsi::Callback cb_showEvent_1634_0;
  gsi::Callback cb_styleChange_1228_0;
  gsi::Callback cb_tabletEvent_1821_0;
  gsi::Callback cb_timerEvent_1730_0;
  gsi::Callback cb_wheelEvent_1718_0;
  gsi::Callback cb_windowActivationChange_864_0;
};

QCalendarWidget_Adaptor::~QCalendarWidget_Adaptor() { }

//  Constructor QCalendarWidget::QCalendarWidget(QWidget *parent) (adaptor class)

static void _init_ctor_QCalendarWidget_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QCalendarWidget_Adaptor *> ();
}

static void _call_ctor_QCalendarWidget_Adaptor_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QCalendarWidget_Adaptor *> (new QCalendarWidget_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QCalendarWidget_Adaptor_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QCalendarWidget::QCalendarWidget(QWidget *parent)\nThis method creates an object of class QCalendarWidget.", &_init_ctor_QCalendarWidget_Adaptor_1315, &_call_ctor_QCalendarWidget_Adaptor_1315);
}

// void QCalendarWidget::create(WId, bool initializeWindow, bool destroyOldWindow)

static void _init_fp_create_2208 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<const qt_gsi::Converter<WId>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("initializeWindow", true, "true");
  decl->add_arg<bool > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("destroyOldWindow", true, "true");
  decl->add_arg<bool > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_create_2208 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<WId>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<WId>::target_type & > () : (const qt_gsi::Converter<WId>::target_type &)(qt_gsi::CppToQtReadAdaptor<WId>(heap, 0));
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  bool arg3 = args ? args.read<bool > () : (bool)(true);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_create_2208 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_create_2208 ()
{
  return new qt_gsi::GenericMethod("*qt_create", "@brief Method void QCalendarWidget::create(WId, bool initializeWindow, bool destroyOldWindow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_create_2208, &_call_fp_create_2208);
}


// void QCalendarWidget::destroy(bool destroyWindow, bool destroySubWindows)

static void _init_fp_destroy_1620 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("destroyWindow", true, "true");
  decl->add_arg<bool > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("destroySubWindows", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_destroy_1620 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_destroy_1620 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_destroy_1620 ()
{
  return new qt_gsi::GenericMethod("*qt_destroy", "@brief Method void QCalendarWidget::destroy(bool destroyWindow, bool destroySubWindows)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_destroy_1620, &_call_fp_destroy_1620);
}


// bool QCalendarWidget::focusNextChild()

static void _init_fp_focusNextChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusNextChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_focusNextChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusNextChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusNextChild", "@brief Method bool QCalendarWidget::focusNextChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusNextChild_0, &_call_fp_focusNextChild_0);
}


// bool QCalendarWidget::focusPreviousChild()

static void _init_fp_focusPreviousChild_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_fp_focusPreviousChild_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_focusPreviousChild_0 ());
}

static qt_gsi::GenericMethod*_create_fp_focusPreviousChild_0 ()
{
  return new qt_gsi::GenericMethod("*focusPreviousChild", "@brief Method bool QCalendarWidget::focusPreviousChild()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_focusPreviousChild_0, &_call_fp_focusPreviousChild_0);
}


// int QCalendarWidget::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QCalendarWidget::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QCalendarWidget::resetInputContext()

static void _init_fp_resetInputContext_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_resetInputContext_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_resetInputContext_0 ();
}

static qt_gsi::GenericMethod*_create_fp_resetInputContext_0 ()
{
  return new qt_gsi::GenericMethod("*resetInputContext", "@brief Method void QCalendarWidget::resetInputContext()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_resetInputContext_0, &_call_fp_resetInputContext_0);
}


// QObject *QCalendarWidget::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QCalendarWidget::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QCalendarWidget::updateCell(const QDate &date)

static void _init_fp_updateCell_1776 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("date");
  decl->add_arg<const QDate & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_updateCell_1776 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDate &arg1 = args.read<const QDate & > ();
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_updateCell_1776 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_updateCell_1776 ()
{
  return new qt_gsi::GenericMethod("*updateCell", "@brief Method void QCalendarWidget::updateCell(const QDate &date)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateCell_1776, &_call_fp_updateCell_1776);
}


// void QCalendarWidget::updateCells()

static void _init_fp_updateCells_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateCells_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_updateCells_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateCells_0 ()
{
  return new qt_gsi::GenericMethod("*updateCells", "@brief Method void QCalendarWidget::updateCells()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateCells_0, &_call_fp_updateCells_0);
}


// void QCalendarWidget::updateMicroFocus()

static void _init_fp_updateMicroFocus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_updateMicroFocus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget_Adaptor *)cls)->fp_QCalendarWidget_updateMicroFocus_0 ();
}

static qt_gsi::GenericMethod*_create_fp_updateMicroFocus_0 ()
{
  return new qt_gsi::GenericMethod("*updateMicroFocus", "@brief Method void QCalendarWidget::updateMicroFocus()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_updateMicroFocus_0, &_call_fp_updateMicroFocus_0);
}


// int QCalendarWidget::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QCalendarWidget::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// QVariant QCalendarWidget::inputMethodQuery(Qt::InputMethodQuery)

static void _init_cbs_inputMethodQuery_c2420_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > (argspec_0);
  decl->set_return<QVariant > ();
}

static void _call_cbs_inputMethodQuery_c2420_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::InputMethodQuery>::target_type & > ();
  ret.write<QVariant > ((QVariant)((QCalendarWidget_Adaptor *)cls)->cbs_inputMethodQuery_c2420_0 (arg1));
}

static void _set_callback_cbs_inputMethodQuery_c2420_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_inputMethodQuery_c2420_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@hide", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodQuery_c2420_0 ()
{
  return new qt_gsi::GenericMethod ("inputMethodQuery", "@brief Virtual method QVariant QCalendarWidget::inputMethodQuery(Qt::InputMethodQuery)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_inputMethodQuery_c2420_0, &_call_cbs_inputMethodQuery_c2420_0, &_set_callback_cbs_inputMethodQuery_c2420_0);
}


// QSize QCalendarWidget::minimumSizeHint()

static void _init_cbs_minimumSizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCalendarWidget_Adaptor *)cls)->cbs_minimumSizeHint_c0_0 ());
}

static void _set_callback_cbs_minimumSizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_minimumSizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@hide", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSizeHint", "@brief Virtual method QSize QCalendarWidget::minimumSizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSizeHint_c0_0, &_call_cbs_minimumSizeHint_c0_0, &_set_callback_cbs_minimumSizeHint_c0_0);
}


// QPaintEngine *QCalendarWidget::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPaintEngine * > ((QPaintEngine *)((QCalendarWidget_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEngine_c0_0 ()
{
  return new qt_gsi::GenericMethod ("paintEngine", "@brief Virtual method QPaintEngine *QCalendarWidget::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
}


// void QCalendarWidget::setVisible(bool visible)

static void _init_cbs_setVisible_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("visible");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVisible_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_setVisible_864_0 (arg1);
}

static void _set_callback_cbs_setVisible_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_setVisible_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@hide", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setVisible_864_0 ()
{
  return new qt_gsi::GenericMethod ("setVisible", "@brief Virtual method void QCalendarWidget::setVisible(bool visible)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVisible_864_0, &_call_cbs_setVisible_864_0, &_set_callback_cbs_setVisible_864_0);
}


// QSize QCalendarWidget::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QCalendarWidget_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QCalendarWidget::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// void QCalendarWidget::actionEvent(QActionEvent *)

static void _init_cbs_actionEvent_1823_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QActionEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_actionEvent_1823_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QActionEvent *arg1 = args.read<QActionEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_actionEvent_1823_0 (arg1);
}

static void _set_callback_cbs_actionEvent_1823_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_actionEvent_1823_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@hide", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_actionEvent_1823_0 ()
{
  return new qt_gsi::GenericMethod ("*actionEvent", "@brief Virtual method void QCalendarWidget::actionEvent(QActionEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_actionEvent_1823_0, &_call_cbs_actionEvent_1823_0, &_set_callback_cbs_actionEvent_1823_0);
}


// void QCalendarWidget::changeEvent(QEvent *)

static void _init_cbs_changeEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_changeEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_changeEvent_1217_0 (arg1);
}

static void _set_callback_cbs_changeEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_changeEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@hide", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_changeEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*changeEvent", "@brief Virtual method void QCalendarWidget::changeEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_changeEvent_1217_0, &_call_cbs_changeEvent_1217_0, &_set_callback_cbs_changeEvent_1217_0);
}


// void QCalendarWidget::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QCalendarWidget::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QCalendarWidget::closeEvent(QCloseEvent *)

static void _init_cbs_closeEvent_1719_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QCloseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_closeEvent_1719_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QCloseEvent *arg1 = args.read<QCloseEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_closeEvent_1719_0 (arg1);
}

static void _set_callback_cbs_closeEvent_1719_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_closeEvent_1719_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@hide", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_closeEvent_1719_0 ()
{
  return new qt_gsi::GenericMethod ("*closeEvent", "@brief Virtual method void QCalendarWidget::closeEvent(QCloseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_closeEvent_1719_0, &_call_cbs_closeEvent_1719_0, &_set_callback_cbs_closeEvent_1719_0);
}


// void QCalendarWidget::contextMenuEvent(QContextMenuEvent *)

static void _init_cbs_contextMenuEvent_2363_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QContextMenuEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_contextMenuEvent_2363_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QContextMenuEvent *arg1 = args.read<QContextMenuEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_contextMenuEvent_2363_0 (arg1);
}

static void _set_callback_cbs_contextMenuEvent_2363_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_contextMenuEvent_2363_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@hide", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_contextMenuEvent_2363_0 ()
{
  return new qt_gsi::GenericMethod ("*contextMenuEvent", "@brief Virtual method void QCalendarWidget::contextMenuEvent(QContextMenuEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_contextMenuEvent_2363_0, &_call_cbs_contextMenuEvent_2363_0, &_set_callback_cbs_contextMenuEvent_2363_0);
}


// void QCalendarWidget::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QCalendarWidget::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QCalendarWidget::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QCalendarWidget::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QCalendarWidget::dragEnterEvent(QDragEnterEvent *)

static void _init_cbs_dragEnterEvent_2109_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragEnterEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragEnterEvent_2109_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragEnterEvent *arg1 = args.read<QDragEnterEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_dragEnterEvent_2109_0 (arg1);
}

static void _set_callback_cbs_dragEnterEvent_2109_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dragEnterEvent_2109_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@hide", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragEnterEvent_2109_0 ()
{
  return new qt_gsi::GenericMethod ("*dragEnterEvent", "@brief Virtual method void QCalendarWidget::dragEnterEvent(QDragEnterEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragEnterEvent_2109_0, &_call_cbs_dragEnterEvent_2109_0, &_set_callback_cbs_dragEnterEvent_2109_0);
}


// void QCalendarWidget::dragLeaveEvent(QDragLeaveEvent *)

static void _init_cbs_dragLeaveEvent_2092_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragLeaveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragLeaveEvent_2092_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragLeaveEvent *arg1 = args.read<QDragLeaveEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_dragLeaveEvent_2092_0 (arg1);
}

static void _set_callback_cbs_dragLeaveEvent_2092_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dragLeaveEvent_2092_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@hide", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragLeaveEvent_2092_0 ()
{
  return new qt_gsi::GenericMethod ("*dragLeaveEvent", "@brief Virtual method void QCalendarWidget::dragLeaveEvent(QDragLeaveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragLeaveEvent_2092_0, &_call_cbs_dragLeaveEvent_2092_0, &_set_callback_cbs_dragLeaveEvent_2092_0);
}


// void QCalendarWidget::dragMoveEvent(QDragMoveEvent *)

static void _init_cbs_dragMoveEvent_2006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDragMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dragMoveEvent_2006_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDragMoveEvent *arg1 = args.read<QDragMoveEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_dragMoveEvent_2006_0 (arg1);
}

static void _set_callback_cbs_dragMoveEvent_2006_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dragMoveEvent_2006_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@hide", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dragMoveEvent_2006_0 ()
{
  return new qt_gsi::GenericMethod ("*dragMoveEvent", "@brief Virtual method void QCalendarWidget::dragMoveEvent(QDragMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dragMoveEvent_2006_0, &_call_cbs_dragMoveEvent_2006_0, &_set_callback_cbs_dragMoveEvent_2006_0);
}


// void QCalendarWidget::dropEvent(QDropEvent *)

static void _init_cbs_dropEvent_1622_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QDropEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_dropEvent_1622_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QDropEvent *arg1 = args.read<QDropEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_dropEvent_1622_0 (arg1);
}

static void _set_callback_cbs_dropEvent_1622_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_dropEvent_1622_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@hide", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropEvent_1622_0 ()
{
  return new qt_gsi::GenericMethod ("*dropEvent", "@brief Virtual method void QCalendarWidget::dropEvent(QDropEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropEvent_1622_0, &_call_cbs_dropEvent_1622_0, &_set_callback_cbs_dropEvent_1622_0);
}


// void QCalendarWidget::enabledChange(bool)

static void _init_cbs_enabledChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enabledChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_enabledChange_864_0 (arg1);
}

static void _set_callback_cbs_enabledChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_enabledChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@hide", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enabledChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*enabledChange", "@brief Virtual method void QCalendarWidget::enabledChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enabledChange_864_0, &_call_cbs_enabledChange_864_0, &_set_callback_cbs_enabledChange_864_0);
}


// void QCalendarWidget::enterEvent(QEvent *)

static void _init_cbs_enterEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_enterEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_enterEvent_1217_0 (arg1);
}

static void _set_callback_cbs_enterEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_enterEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@hide", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_enterEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*enterEvent", "@brief Virtual method void QCalendarWidget::enterEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_enterEvent_1217_0, &_call_cbs_enterEvent_1217_0, &_set_callback_cbs_enterEvent_1217_0);
}


// bool QCalendarWidget::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QCalendarWidget::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QCalendarWidget::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("*eventFilter", "@brief Virtual method bool QCalendarWidget::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QCalendarWidget::focusInEvent(QFocusEvent *)

static void _init_cbs_focusInEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusInEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_focusInEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusInEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_focusInEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@hide", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusInEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusInEvent", "@brief Virtual method void QCalendarWidget::focusInEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusInEvent_1729_0, &_call_cbs_focusInEvent_1729_0, &_set_callback_cbs_focusInEvent_1729_0);
}


// bool QCalendarWidget::focusNextPrevChild(bool next)

static void _init_cbs_focusNextPrevChild_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("next");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_focusNextPrevChild_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ret.write<bool > ((bool)((QCalendarWidget_Adaptor *)cls)->cbs_focusNextPrevChild_864_0 (arg1));
}

static void _set_callback_cbs_focusNextPrevChild_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_focusNextPrevChild_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@hide", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusNextPrevChild_864_0 ()
{
  return new qt_gsi::GenericMethod ("*focusNextPrevChild", "@brief Virtual method bool QCalendarWidget::focusNextPrevChild(bool next)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusNextPrevChild_864_0, &_call_cbs_focusNextPrevChild_864_0, &_set_callback_cbs_focusNextPrevChild_864_0);
}


// void QCalendarWidget::focusOutEvent(QFocusEvent *)

static void _init_cbs_focusOutEvent_1729_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QFocusEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_focusOutEvent_1729_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QFocusEvent *arg1 = args.read<QFocusEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_focusOutEvent_1729_0 (arg1);
}

static void _set_callback_cbs_focusOutEvent_1729_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_focusOutEvent_1729_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@hide", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_focusOutEvent_1729_0 ()
{
  return new qt_gsi::GenericMethod ("*focusOutEvent", "@brief Virtual method void QCalendarWidget::focusOutEvent(QFocusEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_focusOutEvent_1729_0, &_call_cbs_focusOutEvent_1729_0, &_set_callback_cbs_focusOutEvent_1729_0);
}


// void QCalendarWidget::fontChange(const QFont &)

static void _init_cbs_fontChange_1801_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fontChange_1801_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_fontChange_1801_0 (arg1);
}

static void _set_callback_cbs_fontChange_1801_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_fontChange_1801_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@hide", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fontChange_1801_0 ()
{
  return new qt_gsi::GenericMethod ("*fontChange", "@brief Virtual method void QCalendarWidget::fontChange(const QFont &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fontChange_1801_0, &_call_cbs_fontChange_1801_0, &_set_callback_cbs_fontChange_1801_0);
}


// void QCalendarWidget::hideEvent(QHideEvent *)

static void _init_cbs_hideEvent_1595_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QHideEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_hideEvent_1595_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QHideEvent *arg1 = args.read<QHideEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_hideEvent_1595_0 (arg1);
}

static void _set_callback_cbs_hideEvent_1595_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_hideEvent_1595_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@hide", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hideEvent_1595_0 ()
{
  return new qt_gsi::GenericMethod ("*hideEvent", "@brief Virtual method void QCalendarWidget::hideEvent(QHideEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_hideEvent_1595_0, &_call_cbs_hideEvent_1595_0, &_set_callback_cbs_hideEvent_1595_0);
}


// void QCalendarWidget::inputMethodEvent(QInputMethodEvent *)

static void _init_cbs_inputMethodEvent_2354_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputMethodEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_inputMethodEvent_2354_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputMethodEvent *arg1 = args.read<QInputMethodEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_inputMethodEvent_2354_0 (arg1);
}

static void _set_callback_cbs_inputMethodEvent_2354_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_inputMethodEvent_2354_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@hide", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_inputMethodEvent_2354_0 ()
{
  return new qt_gsi::GenericMethod ("*inputMethodEvent", "@brief Virtual method void QCalendarWidget::inputMethodEvent(QInputMethodEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_inputMethodEvent_2354_0, &_call_cbs_inputMethodEvent_2354_0, &_set_callback_cbs_inputMethodEvent_2354_0);
}


// void QCalendarWidget::keyPressEvent(QKeyEvent *event)

static void _init_cbs_keyPressEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyPressEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_keyPressEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyPressEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_keyPressEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@hide", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyPressEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyPressEvent", "@brief Virtual method void QCalendarWidget::keyPressEvent(QKeyEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyPressEvent_1514_0, &_call_cbs_keyPressEvent_1514_0, &_set_callback_cbs_keyPressEvent_1514_0);
}


// void QCalendarWidget::keyReleaseEvent(QKeyEvent *)

static void _init_cbs_keyReleaseEvent_1514_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QKeyEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_keyReleaseEvent_1514_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QKeyEvent *arg1 = args.read<QKeyEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_keyReleaseEvent_1514_0 (arg1);
}

static void _set_callback_cbs_keyReleaseEvent_1514_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_keyReleaseEvent_1514_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@hide", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_keyReleaseEvent_1514_0 ()
{
  return new qt_gsi::GenericMethod ("*keyReleaseEvent", "@brief Virtual method void QCalendarWidget::keyReleaseEvent(QKeyEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_keyReleaseEvent_1514_0, &_call_cbs_keyReleaseEvent_1514_0, &_set_callback_cbs_keyReleaseEvent_1514_0);
}


// void QCalendarWidget::languageChange()

static void _init_cbs_languageChange_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_languageChange_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QCalendarWidget_Adaptor *)cls)->cbs_languageChange_0_0 ();
}

static void _set_callback_cbs_languageChange_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_languageChange_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@hide", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_languageChange_0_0 ()
{
  return new qt_gsi::GenericMethod ("*languageChange", "@brief Virtual method void QCalendarWidget::languageChange()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_languageChange_0_0, &_call_cbs_languageChange_0_0, &_set_callback_cbs_languageChange_0_0);
}


// void QCalendarWidget::leaveEvent(QEvent *)

static void _init_cbs_leaveEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_leaveEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_leaveEvent_1217_0 (arg1);
}

static void _set_callback_cbs_leaveEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_leaveEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@hide", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_leaveEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*leaveEvent", "@brief Virtual method void QCalendarWidget::leaveEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_leaveEvent_1217_0, &_call_cbs_leaveEvent_1217_0, &_set_callback_cbs_leaveEvent_1217_0);
}


// int QCalendarWidget::metric(QPaintDevice::PaintDeviceMetric)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > ();
  ret.write<int > ((int)((QCalendarWidget_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_metric_c3445_0 ()
{
  return new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QCalendarWidget::metric(QPaintDevice::PaintDeviceMetric)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
}


// void QCalendarWidget::mouseDoubleClickEvent(QMouseEvent *)

static void _init_cbs_mouseDoubleClickEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseDoubleClickEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_mouseDoubleClickEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseDoubleClickEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mouseDoubleClickEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@hide", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseDoubleClickEvent", "@brief Virtual method void QCalendarWidget::mouseDoubleClickEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseDoubleClickEvent_1738_0, &_call_cbs_mouseDoubleClickEvent_1738_0, &_set_callback_cbs_mouseDoubleClickEvent_1738_0);
}


// void QCalendarWidget::mouseMoveEvent(QMouseEvent *)

static void _init_cbs_mouseMoveEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseMoveEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_mouseMoveEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseMoveEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mouseMoveEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@hide", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseMoveEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseMoveEvent", "@brief Virtual method void QCalendarWidget::mouseMoveEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseMoveEvent_1738_0, &_call_cbs_mouseMoveEvent_1738_0, &_set_callback_cbs_mouseMoveEvent_1738_0);
}


// void QCalendarWidget::mousePressEvent(QMouseEvent *event)

static void _init_cbs_mousePressEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mousePressEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_mousePressEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mousePressEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mousePressEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@hide", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mousePressEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mousePressEvent", "@brief Virtual method void QCalendarWidget::mousePressEvent(QMouseEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mousePressEvent_1738_0, &_call_cbs_mousePressEvent_1738_0, &_set_callback_cbs_mousePressEvent_1738_0);
}


// void QCalendarWidget::mouseReleaseEvent(QMouseEvent *)

static void _init_cbs_mouseReleaseEvent_1738_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMouseEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_mouseReleaseEvent_1738_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMouseEvent *arg1 = args.read<QMouseEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_mouseReleaseEvent_1738_0 (arg1);
}

static void _set_callback_cbs_mouseReleaseEvent_1738_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_mouseReleaseEvent_1738_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@hide", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mouseReleaseEvent_1738_0 ()
{
  return new qt_gsi::GenericMethod ("*mouseReleaseEvent", "@brief Virtual method void QCalendarWidget::mouseReleaseEvent(QMouseEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_mouseReleaseEvent_1738_0, &_call_cbs_mouseReleaseEvent_1738_0, &_set_callback_cbs_mouseReleaseEvent_1738_0);
}


// void QCalendarWidget::moveEvent(QMoveEvent *)

static void _init_cbs_moveEvent_1624_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QMoveEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_moveEvent_1624_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QMoveEvent *arg1 = args.read<QMoveEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_moveEvent_1624_0 (arg1);
}

static void _set_callback_cbs_moveEvent_1624_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_moveEvent_1624_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@hide", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_moveEvent_1624_0 ()
{
  return new qt_gsi::GenericMethod ("*moveEvent", "@brief Virtual method void QCalendarWidget::moveEvent(QMoveEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_moveEvent_1624_0, &_call_cbs_moveEvent_1624_0, &_set_callback_cbs_moveEvent_1624_0);
}


// void QCalendarWidget::paintCell(QPainter *painter, const QRect &rect, const QDate &date)

static void _init_cbs_paintCell_c4778_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rect");
  decl->add_arg<const QRect & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("date");
  decl->add_arg<const QDate & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_cbs_paintCell_c4778_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPainter *arg1 = args.read<QPainter * > ();
  const QRect &arg2 = args.read<const QRect & > ();
  const QDate &arg3 = args.read<const QDate & > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_paintCell_c4778_0 (arg1, arg2, arg3);
}

static void _set_callback_cbs_paintCell_c4778_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paintCell_c4778_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintCell_c4778_0 ()
{
  return new qt_gsi::GenericMethod ("*paintCell", "@hide", true, &_init_cbs_paintCell_c4778_0, &_call_cbs_paintCell_c4778_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintCell_c4778_0 ()
{
  return new qt_gsi::GenericMethod ("*paintCell", "@brief Virtual method void QCalendarWidget::paintCell(QPainter *painter, const QRect &rect, const QDate &date)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintCell_c4778_0, &_call_cbs_paintCell_c4778_0, &_set_callback_cbs_paintCell_c4778_0);
}


// void QCalendarWidget::paintEvent(QPaintEvent *)

static void _init_cbs_paintEvent_1725_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QPaintEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paintEvent_1725_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QPaintEvent *arg1 = args.read<QPaintEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_paintEvent_1725_0 (arg1);
}

static void _set_callback_cbs_paintEvent_1725_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paintEvent_1725_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@hide", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paintEvent_1725_0 ()
{
  return new qt_gsi::GenericMethod ("*paintEvent", "@brief Virtual method void QCalendarWidget::paintEvent(QPaintEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paintEvent_1725_0, &_call_cbs_paintEvent_1725_0, &_set_callback_cbs_paintEvent_1725_0);
}


// void QCalendarWidget::paletteChange(const QPalette &)

static void _init_cbs_paletteChange_2113_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_paletteChange_2113_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_paletteChange_2113_0 (arg1);
}

static void _set_callback_cbs_paletteChange_2113_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_paletteChange_2113_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@hide", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_paletteChange_2113_0 ()
{
  return new qt_gsi::GenericMethod ("*paletteChange", "@brief Virtual method void QCalendarWidget::paletteChange(const QPalette &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_paletteChange_2113_0, &_call_cbs_paletteChange_2113_0, &_set_callback_cbs_paletteChange_2113_0);
}


// void QCalendarWidget::resizeEvent(QResizeEvent *event)

static void _init_cbs_resizeEvent_1843_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QResizeEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_resizeEvent_1843_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QResizeEvent *arg1 = args.read<QResizeEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_resizeEvent_1843_0 (arg1);
}

static void _set_callback_cbs_resizeEvent_1843_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_resizeEvent_1843_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@hide", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_resizeEvent_1843_0 ()
{
  return new qt_gsi::GenericMethod ("*resizeEvent", "@brief Virtual method void QCalendarWidget::resizeEvent(QResizeEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resizeEvent_1843_0, &_call_cbs_resizeEvent_1843_0, &_set_callback_cbs_resizeEvent_1843_0);
}


// void QCalendarWidget::showEvent(QShowEvent *)

static void _init_cbs_showEvent_1634_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QShowEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_showEvent_1634_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QShowEvent *arg1 = args.read<QShowEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_showEvent_1634_0 (arg1);
}

static void _set_callback_cbs_showEvent_1634_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_showEvent_1634_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@hide", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_showEvent_1634_0 ()
{
  return new qt_gsi::GenericMethod ("*showEvent", "@brief Virtual method void QCalendarWidget::showEvent(QShowEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_showEvent_1634_0, &_call_cbs_showEvent_1634_0, &_set_callback_cbs_showEvent_1634_0);
}


// void QCalendarWidget::styleChange(QStyle &)

static void _init_cbs_styleChange_1228_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_styleChange_1228_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle &arg1 = args.read<QStyle & > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_styleChange_1228_0 (arg1);
}

static void _set_callback_cbs_styleChange_1228_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_styleChange_1228_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@hide", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_styleChange_1228_0 ()
{
  return new qt_gsi::GenericMethod ("*styleChange", "@brief Virtual method void QCalendarWidget::styleChange(QStyle &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_styleChange_1228_0, &_call_cbs_styleChange_1228_0, &_set_callback_cbs_styleChange_1228_0);
}


// void QCalendarWidget::tabletEvent(QTabletEvent *)

static void _init_cbs_tabletEvent_1821_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTabletEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_tabletEvent_1821_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTabletEvent *arg1 = args.read<QTabletEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_tabletEvent_1821_0 (arg1);
}

static void _set_callback_cbs_tabletEvent_1821_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_tabletEvent_1821_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@hide", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_tabletEvent_1821_0 ()
{
  return new qt_gsi::GenericMethod ("*tabletEvent", "@brief Virtual method void QCalendarWidget::tabletEvent(QTabletEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_tabletEvent_1821_0, &_call_cbs_tabletEvent_1821_0, &_set_callback_cbs_tabletEvent_1821_0);
}


// void QCalendarWidget::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QCalendarWidget::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


// void QCalendarWidget::wheelEvent(QWheelEvent *)

static void _init_cbs_wheelEvent_1718_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWheelEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_wheelEvent_1718_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWheelEvent *arg1 = args.read<QWheelEvent * > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_wheelEvent_1718_0 (arg1);
}

static void _set_callback_cbs_wheelEvent_1718_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_wheelEvent_1718_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@hide", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_wheelEvent_1718_0 ()
{
  return new qt_gsi::GenericMethod ("*wheelEvent", "@brief Virtual method void QCalendarWidget::wheelEvent(QWheelEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_wheelEvent_1718_0, &_call_cbs_wheelEvent_1718_0, &_set_callback_cbs_wheelEvent_1718_0);
}


// void QCalendarWidget::windowActivationChange(bool)

static void _init_cbs_windowActivationChange_864_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_windowActivationChange_864_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  ((QCalendarWidget_Adaptor *)cls)->cbs_windowActivationChange_864_0 (arg1);
}

static void _set_callback_cbs_windowActivationChange_864_0 (void *cls, const gsi::Callback &cb)
{
  ((QCalendarWidget_Adaptor *)cls)->cb_windowActivationChange_864_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@hide", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_windowActivationChange_864_0 ()
{
  return new qt_gsi::GenericMethod ("*windowActivationChange", "@brief Virtual method void QCalendarWidget::windowActivationChange(bool)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_windowActivationChange_864_0, &_call_cbs_windowActivationChange_864_0, &_set_callback_cbs_windowActivationChange_864_0);
}


namespace gsi
{

extern gsi::Class<QCalendarWidget> decl_QCalendarWidget;

gsi::Class<QCalendarWidget_Adaptor> decl_QCalendarWidget_Adaptor (decl_QCalendarWidget, "QCalendarWidget",
  gsi::Methods(_create_fp_create_2208 ()) +
  gsi::Methods(_create_fp_destroy_1620 ()) +
  gsi::Methods(_create_fp_focusNextChild_0 ()) +
  gsi::Methods(_create_fp_focusPreviousChild_0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_resetInputContext_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_updateCell_1776 ()) +
  gsi::Methods(_create_fp_updateCells_0 ()) +
  gsi::Methods(_create_fp_updateMicroFocus_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodQuery_c2420_0 ()) +
  gsi::Methods(_create_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEngine_c0_0 ()) +
  gsi::Methods(_create_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_callback_cbs_setVisible_864_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_callback_cbs_actionEvent_1823_0 ()) +
  gsi::Methods(_create_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_changeEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_callback_cbs_closeEvent_1719_0 ()) +
  gsi::Methods(_create_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_callback_cbs_contextMenuEvent_2363_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_callback_cbs_dragEnterEvent_2109_0 ()) +
  gsi::Methods(_create_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_callback_cbs_dragLeaveEvent_2092_0 ()) +
  gsi::Methods(_create_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_callback_cbs_dragMoveEvent_2006_0 ()) +
  gsi::Methods(_create_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_callback_cbs_dropEvent_1622_0 ()) +
  gsi::Methods(_create_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_enabledChange_864_0 ()) +
  gsi::Methods(_create_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_enterEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusInEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_callback_cbs_focusNextPrevChild_864_0 ()) +
  gsi::Methods(_create_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_callback_cbs_focusOutEvent_1729_0 ()) +
  gsi::Methods(_create_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_callback_cbs_fontChange_1801_0 ()) +
  gsi::Methods(_create_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_callback_cbs_hideEvent_1595_0 ()) +
  gsi::Methods(_create_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_callback_cbs_inputMethodEvent_2354_0 ()) +
  gsi::Methods(_create_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyPressEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_callback_cbs_keyReleaseEvent_1514_0 ()) +
  gsi::Methods(_create_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_callback_cbs_languageChange_0_0 ()) +
  gsi::Methods(_create_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_leaveEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_callback_cbs_metric_c3445_0 ()) +
  gsi::Methods(_create_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseDoubleClickEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseMoveEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mousePressEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_callback_cbs_mouseReleaseEvent_1738_0 ()) +
  gsi::Methods(_create_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_callback_cbs_moveEvent_1624_0 ()) +
  gsi::Methods(_create_cbs_paintCell_c4778_0 ()) +
  gsi::Methods(_create_callback_cbs_paintCell_c4778_0 ()) +
  gsi::Methods(_create_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_callback_cbs_paintEvent_1725_0 ()) +
  gsi::Methods(_create_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_callback_cbs_paletteChange_2113_0 ()) +
  gsi::Methods(_create_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_callback_cbs_resizeEvent_1843_0 ()) +
  gsi::Methods(_create_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_callback_cbs_showEvent_1634_0 ()) +
  gsi::Methods(_create_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_callback_cbs_styleChange_1228_0 ()) +
  gsi::Methods(_create_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_callback_cbs_tabletEvent_1821_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_callback_cbs_wheelEvent_1718_0 ()) +
  gsi::Methods(_create_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_callback_cbs_windowActivationChange_864_0 ()) +
  gsi::Methods(_create_ctor_QCalendarWidget_Adaptor_1315 ()),
  "@qt\n@brief Binding of QCalendarWidget");

}


//  Implementation of the enum wrapper class for QCalendarWidget::HorizontalHeaderFormat
namespace qt_gsi
{

static QCalendarWidget_HorizontalHeaderFormat_Enum *c_1_QCalendarWidget_HorizontalHeaderFormat_Enum () { return new QCalendarWidget_HorizontalHeaderFormat_Enum (QCalendarWidget::NoHorizontalHeader); }
static QCalendarWidget_HorizontalHeaderFormat_Enum *c_2_QCalendarWidget_HorizontalHeaderFormat_Enum () { return new QCalendarWidget_HorizontalHeaderFormat_Enum (QCalendarWidget::SingleLetterDayNames); }
static QCalendarWidget_HorizontalHeaderFormat_Enum *c_3_QCalendarWidget_HorizontalHeaderFormat_Enum () { return new QCalendarWidget_HorizontalHeaderFormat_Enum (QCalendarWidget::ShortDayNames); }
static QCalendarWidget_HorizontalHeaderFormat_Enum *c_4_QCalendarWidget_HorizontalHeaderFormat_Enum () { return new QCalendarWidget_HorizontalHeaderFormat_Enum (QCalendarWidget::LongDayNames); }

static gsi::Methods mkdefs_QCalendarWidget_HorizontalHeaderFormat () {
  return
    gsi::constant ("NoHorizontalHeader", &qt_gsi::c_1_QCalendarWidget_HorizontalHeaderFormat_Enum, "@brief Enum constant QCalendarWidget::NoHorizontalHeader") +
    gsi::constant ("SingleLetterDayNames", &qt_gsi::c_2_QCalendarWidget_HorizontalHeaderFormat_Enum, "@brief Enum constant QCalendarWidget::SingleLetterDayNames") +
    gsi::constant ("ShortDayNames", &qt_gsi::c_3_QCalendarWidget_HorizontalHeaderFormat_Enum, "@brief Enum constant QCalendarWidget::ShortDayNames") +
    gsi::constant ("LongDayNames", &qt_gsi::c_4_QCalendarWidget_HorizontalHeaderFormat_Enum, "@brief Enum constant QCalendarWidget::LongDayNames");
}

static std::string to_s_QCalendarWidget_HorizontalHeaderFormat_Enum (const QCalendarWidget_HorizontalHeaderFormat_Enum *e)
{
  if (e->value () == QCalendarWidget::NoHorizontalHeader) { return tl::sprintf ("NoHorizontalHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCalendarWidget::SingleLetterDayNames) { return tl::sprintf ("SingleLetterDayNames (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCalendarWidget::ShortDayNames) { return tl::sprintf ("ShortDayNames (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCalendarWidget::LongDayNames) { return tl::sprintf ("LongDayNames (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QCalendarWidget_HorizontalHeaderFormat_Enum (const QCalendarWidget_HorizontalHeaderFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static QCalendarWidget_HorizontalHeaderFormat_Enum *from_i_QCalendarWidget_HorizontalHeaderFormat_Enum (unsigned int i)
{
  return new QCalendarWidget_HorizontalHeaderFormat_Enum ((QCalendarWidget::HorizontalHeaderFormat) i);
}

static bool equalQCalendarWidget_HorizontalHeaderFormat_Enum (const QCalendarWidget_HorizontalHeaderFormat_Enum *e, QCalendarWidget_HorizontalHeaderFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QCalendarWidget_HorizontalHeaderFormat_Enum (const QCalendarWidget_HorizontalHeaderFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QCalendarWidget_HorizontalHeaderFormat_Enums oropQCalendarWidget_HorizontalHeaderFormat_Enums (const QCalendarWidget_HorizontalHeaderFormat_Enums *e, const QCalendarWidget_HorizontalHeaderFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static QCalendarWidget_HorizontalHeaderFormat_Enums andopQCalendarWidget_HorizontalHeaderFormat_Enums (const QCalendarWidget_HorizontalHeaderFormat_Enums *e, const QCalendarWidget_HorizontalHeaderFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static QCalendarWidget_HorizontalHeaderFormat_Enums xoropQCalendarWidget_HorizontalHeaderFormat_Enums (const QCalendarWidget_HorizontalHeaderFormat_Enums *e, const QCalendarWidget_HorizontalHeaderFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QCalendarWidget_HorizontalHeaderFormat_Enums (const QCalendarWidget_HorizontalHeaderFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (QCalendarWidget::NoHorizontalHeader)) { if (!l.empty ()) l += "|"; l += "NoHorizontalHeader"; }
  if (e->testFlag (QCalendarWidget::SingleLetterDayNames)) { if (!l.empty ()) l += "|"; l += "SingleLetterDayNames"; }
  if (e->testFlag (QCalendarWidget::ShortDayNames)) { if (!l.empty ()) l += "|"; l += "ShortDayNames"; }
  if (e->testFlag (QCalendarWidget::LongDayNames)) { if (!l.empty ()) l += "|"; l += "LongDayNames"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QCalendarWidget_HorizontalHeaderFormat_Enums (const QCalendarWidget_HorizontalHeaderFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QCalendarWidget_HorizontalHeaderFormat_Enums (const QCalendarWidget_HorizontalHeaderFormat_Enums *e, const QCalendarWidget_HorizontalHeaderFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QCalendarWidget_HorizontalHeaderFormat_Enums> decl_QCalendarWidget_HorizontalHeaderFormat_Enums ("QCalendarWidget_QFlags_HorizontalHeaderFormat",
  gsi::method_ext ("|", &qt_gsi::oropQCalendarWidget_HorizontalHeaderFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQCalendarWidget_HorizontalHeaderFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQCalendarWidget_HorizontalHeaderFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCalendarWidget_HorizontalHeaderFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCalendarWidget_HorizontalHeaderFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QCalendarWidget_HorizontalHeaderFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QCalendarWidget::HorizontalHeaderFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QCalendarWidget_HorizontalHeaderFormat_Enum> decl_QCalendarWidget_HorizontalHeaderFormat_Enum (decl_QCalendarWidget_HorizontalHeaderFormat_Enums, "QCalendarWidget_HorizontalHeaderFormat",
  qt_gsi::mkdefs_QCalendarWidget_HorizontalHeaderFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCalendarWidget_HorizontalHeaderFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCalendarWidget_HorizontalHeaderFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQCalendarWidget_HorizontalHeaderFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QCalendarWidget_HorizontalHeaderFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QCalendarWidget_HorizontalHeaderFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QCalendarWidget::HorizontalHeaderFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QCalendarWidget> inject_QCalendarWidget_HorizontalHeaderFormat_Enum_in_parent (qt_gsi::mkdefs_QCalendarWidget_HorizontalHeaderFormat ());
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_HorizontalHeaderFormat_Enum_as_child (decl_QCalendarWidget_HorizontalHeaderFormat_Enum, "HorizontalHeaderFormat");

}


//  Implementation of the enum wrapper class for QCalendarWidget::SelectionMode
namespace qt_gsi
{

static QCalendarWidget_SelectionMode_Enum *c_1_QCalendarWidget_SelectionMode_Enum () { return new QCalendarWidget_SelectionMode_Enum (QCalendarWidget::NoSelection); }
static QCalendarWidget_SelectionMode_Enum *c_2_QCalendarWidget_SelectionMode_Enum () { return new QCalendarWidget_SelectionMode_Enum (QCalendarWidget::SingleSelection); }

static gsi::Methods mkdefs_QCalendarWidget_SelectionMode () {
  return
    gsi::constant ("NoSelection", &qt_gsi::c_1_QCalendarWidget_SelectionMode_Enum, "@brief Enum constant QCalendarWidget::NoSelection") +
    gsi::constant ("SingleSelection", &qt_gsi::c_2_QCalendarWidget_SelectionMode_Enum, "@brief Enum constant QCalendarWidget::SingleSelection");
}

static std::string to_s_QCalendarWidget_SelectionMode_Enum (const QCalendarWidget_SelectionMode_Enum *e)
{
  if (e->value () == QCalendarWidget::NoSelection) { return tl::sprintf ("NoSelection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCalendarWidget::SingleSelection) { return tl::sprintf ("SingleSelection (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QCalendarWidget_SelectionMode_Enum (const QCalendarWidget_SelectionMode_Enum *e)
{
  return (unsigned int) e->value ();
}

static QCalendarWidget_SelectionMode_Enum *from_i_QCalendarWidget_SelectionMode_Enum (unsigned int i)
{
  return new QCalendarWidget_SelectionMode_Enum ((QCalendarWidget::SelectionMode) i);
}

static bool equalQCalendarWidget_SelectionMode_Enum (const QCalendarWidget_SelectionMode_Enum *e, QCalendarWidget_SelectionMode_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QCalendarWidget_SelectionMode_Enum (const QCalendarWidget_SelectionMode_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QCalendarWidget_SelectionMode_Enums oropQCalendarWidget_SelectionMode_Enums (const QCalendarWidget_SelectionMode_Enums *e, const QCalendarWidget_SelectionMode_Enums &d)
{
  return e->flags () | d.flags ();
}

static QCalendarWidget_SelectionMode_Enums andopQCalendarWidget_SelectionMode_Enums (const QCalendarWidget_SelectionMode_Enums *e, const QCalendarWidget_SelectionMode_Enums &d)
{
  return e->flags () & d.flags ();
}

static QCalendarWidget_SelectionMode_Enums xoropQCalendarWidget_SelectionMode_Enums (const QCalendarWidget_SelectionMode_Enums *e, const QCalendarWidget_SelectionMode_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QCalendarWidget_SelectionMode_Enums (const QCalendarWidget_SelectionMode_Enums *e)
{
  std::string l;
  if (e->testFlag (QCalendarWidget::NoSelection)) { if (!l.empty ()) l += "|"; l += "NoSelection"; }
  if (e->testFlag (QCalendarWidget::SingleSelection)) { if (!l.empty ()) l += "|"; l += "SingleSelection"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QCalendarWidget_SelectionMode_Enums (const QCalendarWidget_SelectionMode_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QCalendarWidget_SelectionMode_Enums (const QCalendarWidget_SelectionMode_Enums *e, const QCalendarWidget_SelectionMode_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QCalendarWidget_SelectionMode_Enums> decl_QCalendarWidget_SelectionMode_Enums ("QCalendarWidget_QFlags_SelectionMode",
  gsi::method_ext ("|", &qt_gsi::oropQCalendarWidget_SelectionMode_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQCalendarWidget_SelectionMode_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQCalendarWidget_SelectionMode_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCalendarWidget_SelectionMode_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCalendarWidget_SelectionMode_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QCalendarWidget_SelectionMode_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QCalendarWidget::SelectionMode> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QCalendarWidget_SelectionMode_Enum> decl_QCalendarWidget_SelectionMode_Enum (decl_QCalendarWidget_SelectionMode_Enums, "QCalendarWidget_SelectionMode",
  qt_gsi::mkdefs_QCalendarWidget_SelectionMode () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCalendarWidget_SelectionMode_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCalendarWidget_SelectionMode_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQCalendarWidget_SelectionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QCalendarWidget_SelectionMode_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QCalendarWidget_SelectionMode_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QCalendarWidget::SelectionMode enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QCalendarWidget> inject_QCalendarWidget_SelectionMode_Enum_in_parent (qt_gsi::mkdefs_QCalendarWidget_SelectionMode ());
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_SelectionMode_Enum_as_child (decl_QCalendarWidget_SelectionMode_Enum, "SelectionMode");

}


//  Implementation of the enum wrapper class for QCalendarWidget::VerticalHeaderFormat
namespace qt_gsi
{

static QCalendarWidget_VerticalHeaderFormat_Enum *c_1_QCalendarWidget_VerticalHeaderFormat_Enum () { return new QCalendarWidget_VerticalHeaderFormat_Enum (QCalendarWidget::NoVerticalHeader); }
static QCalendarWidget_VerticalHeaderFormat_Enum *c_2_QCalendarWidget_VerticalHeaderFormat_Enum () { return new QCalendarWidget_VerticalHeaderFormat_Enum (QCalendarWidget::ISOWeekNumbers); }

static gsi::Methods mkdefs_QCalendarWidget_VerticalHeaderFormat () {
  return
    gsi::constant ("NoVerticalHeader", &qt_gsi::c_1_QCalendarWidget_VerticalHeaderFormat_Enum, "@brief Enum constant QCalendarWidget::NoVerticalHeader") +
    gsi::constant ("ISOWeekNumbers", &qt_gsi::c_2_QCalendarWidget_VerticalHeaderFormat_Enum, "@brief Enum constant QCalendarWidget::ISOWeekNumbers");
}

static std::string to_s_QCalendarWidget_VerticalHeaderFormat_Enum (const QCalendarWidget_VerticalHeaderFormat_Enum *e)
{
  if (e->value () == QCalendarWidget::NoVerticalHeader) { return tl::sprintf ("NoVerticalHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QCalendarWidget::ISOWeekNumbers) { return tl::sprintf ("ISOWeekNumbers (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QCalendarWidget_VerticalHeaderFormat_Enum (const QCalendarWidget_VerticalHeaderFormat_Enum *e)
{
  return (unsigned int) e->value ();
}

static QCalendarWidget_VerticalHeaderFormat_Enum *from_i_QCalendarWidget_VerticalHeaderFormat_Enum (unsigned int i)
{
  return new QCalendarWidget_VerticalHeaderFormat_Enum ((QCalendarWidget::VerticalHeaderFormat) i);
}

static bool equalQCalendarWidget_VerticalHeaderFormat_Enum (const QCalendarWidget_VerticalHeaderFormat_Enum *e, QCalendarWidget_VerticalHeaderFormat_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QCalendarWidget_VerticalHeaderFormat_Enum (const QCalendarWidget_VerticalHeaderFormat_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QCalendarWidget_VerticalHeaderFormat_Enums oropQCalendarWidget_VerticalHeaderFormat_Enums (const QCalendarWidget_VerticalHeaderFormat_Enums *e, const QCalendarWidget_VerticalHeaderFormat_Enums &d)
{
  return e->flags () | d.flags ();
}

static QCalendarWidget_VerticalHeaderFormat_Enums andopQCalendarWidget_VerticalHeaderFormat_Enums (const QCalendarWidget_VerticalHeaderFormat_Enums *e, const QCalendarWidget_VerticalHeaderFormat_Enums &d)
{
  return e->flags () & d.flags ();
}

static QCalendarWidget_VerticalHeaderFormat_Enums xoropQCalendarWidget_VerticalHeaderFormat_Enums (const QCalendarWidget_VerticalHeaderFormat_Enums *e, const QCalendarWidget_VerticalHeaderFormat_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QCalendarWidget_VerticalHeaderFormat_Enums (const QCalendarWidget_VerticalHeaderFormat_Enums *e)
{
  std::string l;
  if (e->testFlag (QCalendarWidget::NoVerticalHeader)) { if (!l.empty ()) l += "|"; l += "NoVerticalHeader"; }
  if (e->testFlag (QCalendarWidget::ISOWeekNumbers)) { if (!l.empty ()) l += "|"; l += "ISOWeekNumbers"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QCalendarWidget_VerticalHeaderFormat_Enums (const QCalendarWidget_VerticalHeaderFormat_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QCalendarWidget_VerticalHeaderFormat_Enums (const QCalendarWidget_VerticalHeaderFormat_Enums *e, const QCalendarWidget_VerticalHeaderFormat_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QCalendarWidget_VerticalHeaderFormat_Enums> decl_QCalendarWidget_VerticalHeaderFormat_Enums ("QCalendarWidget_QFlags_VerticalHeaderFormat",
  gsi::method_ext ("|", &qt_gsi::oropQCalendarWidget_VerticalHeaderFormat_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQCalendarWidget_VerticalHeaderFormat_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQCalendarWidget_VerticalHeaderFormat_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCalendarWidget_VerticalHeaderFormat_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCalendarWidget_VerticalHeaderFormat_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QCalendarWidget_VerticalHeaderFormat_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QCalendarWidget::VerticalHeaderFormat> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QCalendarWidget_VerticalHeaderFormat_Enum> decl_QCalendarWidget_VerticalHeaderFormat_Enum (decl_QCalendarWidget_VerticalHeaderFormat_Enums, "QCalendarWidget_VerticalHeaderFormat",
  qt_gsi::mkdefs_QCalendarWidget_VerticalHeaderFormat () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QCalendarWidget_VerticalHeaderFormat_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QCalendarWidget_VerticalHeaderFormat_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQCalendarWidget_VerticalHeaderFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QCalendarWidget_VerticalHeaderFormat_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QCalendarWidget_VerticalHeaderFormat_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QCalendarWidget::VerticalHeaderFormat enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QCalendarWidget> inject_QCalendarWidget_VerticalHeaderFormat_Enum_in_parent (qt_gsi::mkdefs_QCalendarWidget_VerticalHeaderFormat ());
static gsi::ClassExt<QCalendarWidget> decl_QCalendarWidget_VerticalHeaderFormat_Enum_as_child (decl_QCalendarWidget_VerticalHeaderFormat_Enum, "VerticalHeaderFormat");

}

