
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractTableModel.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAbstractTableModel_EventAdaptor.h"
#include "gsiDeclQAbstractTableModel_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractTableModel

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractTableModel::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// bool QAbstractTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)


static void _init_f_dropMimeData_7425 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_f_dropMimeData_7425 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel *)cls)->dropMimeData (arg1, qt_gsi::QtToCppAdaptor<Qt::DropAction>(arg2).cref(), arg3, arg4, arg5));
}

static qt_gsi::GenericMethod *_create_f_dropMimeData_7425 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Method bool QAbstractTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::dropMimeData", false, &_init_f_dropMimeData_7425, &_call_f_dropMimeData_7425);
}

// QModelIndex QAbstractTableModel::index(int row, int column, const QModelIndex &parent)


static void _init_f_index_c3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent", true, "QModelIndex()");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_f_index_c3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args ? args.read<const QModelIndex & > () : (const QModelIndex &)(QModelIndex());
  ret.write<QModelIndex > ((QModelIndex)((QAbstractTableModel *)cls)->index (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod *_create_f_index_c3713 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Method QModelIndex QAbstractTableModel::index(int row, int column, const QModelIndex &parent)\nThis is a reimplementation of QAbstractItemModel::index", true, &_init_f_index_c3713, &_call_f_index_c3713);
}

// static QString QAbstractTableModel::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractTableModel::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractTableModel::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QAbstractTableModel::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractTableModel::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractTableModel::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QAbstractTableModel::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QAbstractTableModel::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractTableModel::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QAbstractTableModel::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QAbstractTableModel::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractTableModel::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QAbstractTableModel, QAbstractTableModel_EventAdaptor> ea_QAbstractTableModel;

namespace gsi
{
extern gsi::Class<QAbstractItemModel> decl_QAbstractItemModel;

gsi::Class<QAbstractTableModel> decl_QAbstractTableModel (ea_QAbstractTableModel, decl_QAbstractItemModel, "QAbstractTableModel_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_dropMimeData_7425 ()) +
  gsi::Methods(_create_f_index_c3713 ()) +
  qt_gsi::qt_signal<QAbstractTableModel, QAbstractTableModel_EventAdaptor, const QModelIndex &, const QModelIndex &> ("dataChanged", &QAbstractTableModel_EventAdaptor::dataChanged_e_4682, gsi::arg("topLeft"), gsi::arg("bottomRight"), "@brief Signal declaration for QAbstractTableModel::dataChanged(const QModelIndex &topLeft, const QModelIndex &bottomRight)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTableModel, QAbstractTableModel_EventAdaptor, QObject *> ("destroyed", &QAbstractTableModel_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QAbstractTableModel::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTableModel, QAbstractTableModel_EventAdaptor, const qt_gsi::Converter<Qt::Orientation>::target_type &, int, int> ("headerDataChanged", &QAbstractTableModel_EventAdaptor::headerDataChanged_e_3231, gsi::arg("orientation"), gsi::arg("first"), gsi::arg("last"), "@brief Signal declaration for QAbstractTableModel::headerDataChanged(Qt::Orientation orientation, int first, int last)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTableModel, QAbstractTableModel_EventAdaptor> ("layoutAboutToBeChanged", &QAbstractTableModel_EventAdaptor::layoutAboutToBeChanged_e_0, "@brief Signal declaration for QAbstractTableModel::layoutAboutToBeChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QAbstractTableModel, QAbstractTableModel_EventAdaptor> ("layoutChanged", &QAbstractTableModel_EventAdaptor::layoutChanged_e_0, "@brief Signal declaration for QAbstractTableModel::layoutChanged()\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QAbstractTableModel");
}


class QAbstractTableModel_Adaptor : public QAbstractTableModel, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractTableModel_Adaptor();

  //  [adaptor ctor] QAbstractTableModel::QAbstractTableModel(QObject *parent)
  QAbstractTableModel_Adaptor() : QAbstractTableModel()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QAbstractTableModel::QAbstractTableModel(QObject *parent)
  QAbstractTableModel_Adaptor(QObject *parent) : QAbstractTableModel(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QAbstractTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)
  void fp_QAbstractTableModel_beginInsertColumns_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractTableModel::beginInsertColumns(parent, first, last);
  }

  //  void QAbstractTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)
  void fp_QAbstractTableModel_beginInsertRows_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractTableModel::beginInsertRows(parent, first, last);
  }

  //  bool QAbstractTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)
  bool fp_QAbstractTableModel_beginMoveColumns_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn) {
    return QAbstractTableModel::beginMoveColumns(sourceParent, sourceFirst, sourceLast, destinationParent, destinationColumn);
  }

  //  bool QAbstractTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)
  bool fp_QAbstractTableModel_beginMoveRows_6659 (const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow) {
    return QAbstractTableModel::beginMoveRows(sourceParent, sourceFirst, sourceLast, destinationParent, destinationRow);
  }

  //  void QAbstractTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)
  void fp_QAbstractTableModel_beginRemoveColumns_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractTableModel::beginRemoveColumns(parent, first, last);
  }

  //  void QAbstractTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)
  void fp_QAbstractTableModel_beginRemoveRows_3713 (const QModelIndex &parent, int first, int last) {
    QAbstractTableModel::beginRemoveRows(parent, first, last);
  }

  //  void QAbstractTableModel::beginResetModel()
  void fp_QAbstractTableModel_beginResetModel_0 () {
    QAbstractTableModel::beginResetModel();
  }

  //  void QAbstractTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)
  void fp_QAbstractTableModel_changePersistentIndex_4682 (const QModelIndex &from, const QModelIndex &to) {
    QAbstractTableModel::changePersistentIndex(from, to);
  }

  //  void QAbstractTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)
  void fp_QAbstractTableModel_changePersistentIndexList_5912 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & from, const qt_gsi::Converter<QList<QModelIndex> >::target_type & to) {
    QAbstractTableModel::changePersistentIndexList(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(from).cref(), qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(to).cref());
  }

  //  QModelIndex QAbstractTableModel::createIndex(int row, int column, void *data)
  QModelIndex fp_QAbstractTableModel_createIndex_c2374 (int row, int column, void *data) const {
    return QAbstractTableModel::createIndex(row, column, data);
  }

  //  QModelIndex QAbstractTableModel::createIndex(int row, int column, int id)
  QModelIndex fp_QAbstractTableModel_createIndex_c2085 (int row, int column, int id) const {
    return QAbstractTableModel::createIndex(row, column, id);
  }

  //  QModelIndex QAbstractTableModel::createIndex(int row, int column, quint32 id)
  QModelIndex fp_QAbstractTableModel_createIndex_c2416 (int row, int column, quint32 id) const {
    return QAbstractTableModel::createIndex(row, column, id);
  }

  //  bool QAbstractTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)
  bool fp_QAbstractTableModel_decodeData_5302 (int row, int column, const QModelIndex &parent, QDataStream &stream) {
    return QAbstractTableModel::decodeData(row, column, parent, stream);
  }

  //  void QAbstractTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)
  void fp_QAbstractTableModel_encodeData_c4599 (const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes, QDataStream &stream) const {
    QAbstractTableModel::encodeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref(), stream);
  }

  //  void QAbstractTableModel::endInsertColumns()
  void fp_QAbstractTableModel_endInsertColumns_0 () {
    QAbstractTableModel::endInsertColumns();
  }

  //  void QAbstractTableModel::endInsertRows()
  void fp_QAbstractTableModel_endInsertRows_0 () {
    QAbstractTableModel::endInsertRows();
  }

  //  void QAbstractTableModel::endMoveColumns()
  void fp_QAbstractTableModel_endMoveColumns_0 () {
    QAbstractTableModel::endMoveColumns();
  }

  //  void QAbstractTableModel::endMoveRows()
  void fp_QAbstractTableModel_endMoveRows_0 () {
    QAbstractTableModel::endMoveRows();
  }

  //  void QAbstractTableModel::endRemoveColumns()
  void fp_QAbstractTableModel_endRemoveColumns_0 () {
    QAbstractTableModel::endRemoveColumns();
  }

  //  void QAbstractTableModel::endRemoveRows()
  void fp_QAbstractTableModel_endRemoveRows_0 () {
    QAbstractTableModel::endRemoveRows();
  }

  //  void QAbstractTableModel::endResetModel()
  void fp_QAbstractTableModel_endResetModel_0 () {
    QAbstractTableModel::endResetModel();
  }

  //  QList<QModelIndex> QAbstractTableModel::persistentIndexList()
  qt_gsi::Converter<QList<QModelIndex> >::target_type fp_QAbstractTableModel_persistentIndexList_c0 () const {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QAbstractTableModel::persistentIndexList());
  }

  //  int QAbstractTableModel::receivers(const char *signal)
  int fp_QAbstractTableModel_receivers_c1731 (const char *signal) const {
    return QAbstractTableModel::receivers(signal);
  }

  //  void QAbstractTableModel::reset()
  void fp_QAbstractTableModel_reset_0 () {
    QAbstractTableModel::reset();
  }

  //  QObject *QAbstractTableModel::sender()
  QObject * fp_QAbstractTableModel_sender_c0 () const {
    return QAbstractTableModel::sender();
  }

  //  [adaptor impl] QModelIndex QAbstractTableModel::buddy(const QModelIndex &index)
  QModelIndex cbs_buddy_c2395_0(const QModelIndex &index) const
  {
    return QAbstractTableModel::buddy(index);
  }

  virtual QModelIndex buddy(const QModelIndex &index) const
  {
    if (cb_buddy_c2395_0.can_issue()) {
      return cb_buddy_c2395_0.issue<QAbstractTableModel_Adaptor, QModelIndex, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_buddy_c2395_0, index);
    } else {
      return QAbstractTableModel::buddy(index);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::canFetchMore(const QModelIndex &parent)
  bool cbs_canFetchMore_c2395_0(const QModelIndex &parent) const
  {
    return QAbstractTableModel::canFetchMore(parent);
  }

  virtual bool canFetchMore(const QModelIndex &parent) const
  {
    if (cb_canFetchMore_c2395_0.can_issue()) {
      return cb_canFetchMore_c2395_0.issue<QAbstractTableModel_Adaptor, bool, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_canFetchMore_c2395_0, parent);
    } else {
      return QAbstractTableModel::canFetchMore(parent);
    }
  }

  //  [adaptor impl] int QAbstractTableModel::columnCount(const QModelIndex &parent)
  int cbs_columnCount_c2395_1(const QModelIndex &parent) const
  {
    throw qt_gsi::AbstractMethodCalledException("columnCount");
  }

  virtual int columnCount(const QModelIndex &parent) const
  {
    if (cb_columnCount_c2395_1.can_issue()) {
      return cb_columnCount_c2395_1.issue<QAbstractTableModel_Adaptor, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_columnCount_c2395_1, parent);
    } else {
      throw qt_gsi::AbstractMethodCalledException("columnCount");
    }
  }

  //  [adaptor impl] QVariant QAbstractTableModel::data(const QModelIndex &index, int role)
  QVariant cbs_data_c3054_1(const QModelIndex &index, int role) const
  {
    throw qt_gsi::AbstractMethodCalledException("data");
  }

  virtual QVariant data(const QModelIndex &index, int role) const
  {
    if (cb_data_c3054_1.can_issue()) {
      return cb_data_c3054_1.issue<QAbstractTableModel_Adaptor, QVariant, const QModelIndex &, int>(&QAbstractTableModel_Adaptor::cbs_data_c3054_1, index, role);
    } else {
      throw qt_gsi::AbstractMethodCalledException("data");
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  bool cbs_dropMimeData_7425_0(const QMimeData *data, const qt_gsi::Converter<Qt::DropAction>::target_type & action, int row, int column, const QModelIndex &parent)
  {
    return QAbstractTableModel::dropMimeData(data, qt_gsi::QtToCppAdaptor<Qt::DropAction>(action).cref(), row, column, parent);
  }

  virtual bool dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)
  {
    if (cb_dropMimeData_7425_0.can_issue()) {
      return cb_dropMimeData_7425_0.issue<QAbstractTableModel_Adaptor, bool, const QMimeData *, const qt_gsi::Converter<Qt::DropAction>::target_type &, int, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_dropMimeData_7425_0, data, qt_gsi::CppToQtAdaptor<Qt::DropAction>(action), row, column, parent);
    } else {
      return QAbstractTableModel::dropMimeData(data, action, row, column, parent);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractTableModel::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractTableModel_Adaptor, bool, QEvent *>(&QAbstractTableModel_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractTableModel::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractTableModel::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractTableModel_Adaptor, bool, QObject *, QEvent *>(&QAbstractTableModel_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractTableModel::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] void QAbstractTableModel::fetchMore(const QModelIndex &parent)
  void cbs_fetchMore_2395_0(const QModelIndex &parent)
  {
    QAbstractTableModel::fetchMore(parent);
  }

  virtual void fetchMore(const QModelIndex &parent)
  {
    if (cb_fetchMore_2395_0.can_issue()) {
      cb_fetchMore_2395_0.issue<QAbstractTableModel_Adaptor, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_fetchMore_2395_0, parent);
    } else {
      QAbstractTableModel::fetchMore(parent);
    }
  }

  //  [adaptor impl] QFlags<Qt::ItemFlag> QAbstractTableModel::flags(const QModelIndex &index)
  qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type cbs_flags_c2395_0(const QModelIndex &index) const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::ItemFlag> >(QAbstractTableModel::flags(index));
  }

  virtual QFlags<Qt::ItemFlag> flags(const QModelIndex &index) const
  {
    if (cb_flags_c2395_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::ItemFlag> >(cb_flags_c2395_0.issue<QAbstractTableModel_Adaptor, qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_flags_c2395_0, index)).cref();
    } else {
      return QAbstractTableModel::flags(index);
    }
  }

  //  [adaptor impl] QVariant QAbstractTableModel::headerData(int section, Qt::Orientation orientation, int role)
  QVariant cbs_headerData_c3231_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, int role) const
  {
    return QAbstractTableModel::headerData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), role);
  }

  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const
  {
    if (cb_headerData_c3231_1.can_issue()) {
      return cb_headerData_c3231_1.issue<QAbstractTableModel_Adaptor, QVariant, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, int>(&QAbstractTableModel_Adaptor::cbs_headerData_c3231_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), role);
    } else {
      return QAbstractTableModel::headerData(section, orientation, role);
    }
  }

  //  [adaptor impl] QModelIndex QAbstractTableModel::index(int row, int column, const QModelIndex &parent)
  QModelIndex cbs_index_c3713_1(int row, int column, const QModelIndex &parent) const
  {
    return QAbstractTableModel::index(row, column, parent);
  }

  virtual QModelIndex index(int row, int column, const QModelIndex &parent) const
  {
    if (cb_index_c3713_1.can_issue()) {
      return cb_index_c3713_1.issue<QAbstractTableModel_Adaptor, QModelIndex, int, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_index_c3713_1, row, column, parent);
    } else {
      return QAbstractTableModel::index(row, column, parent);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::insertColumns(int column, int count, const QModelIndex &parent)
  bool cbs_insertColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QAbstractTableModel::insertColumns(column, count, parent);
  }

  virtual bool insertColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_insertColumns_3713_1.can_issue()) {
      return cb_insertColumns_3713_1.issue<QAbstractTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_insertColumns_3713_1, column, count, parent);
    } else {
      return QAbstractTableModel::insertColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::insertRows(int row, int count, const QModelIndex &parent)
  bool cbs_insertRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QAbstractTableModel::insertRows(row, count, parent);
  }

  virtual bool insertRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_insertRows_3713_1.can_issue()) {
      return cb_insertRows_3713_1.issue<QAbstractTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_insertRows_3713_1, row, count, parent);
    } else {
      return QAbstractTableModel::insertRows(row, count, parent);
    }
  }

  //  [adaptor impl] QList<QModelIndex> QAbstractTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)
  qt_gsi::Converter<QList<QModelIndex> >::target_type cbs_match_c7932_2(const QModelIndex &start, int role, const QVariant &value, int hits, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & flags) const
  {
    return qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(QAbstractTableModel::match(start, role, value, hits, qt_gsi::QtToCppAdaptor<QFlags<Qt::MatchFlag> >(flags).cref()));
  }

  virtual QList<QModelIndex> match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags) const
  {
    if (cb_match_c7932_2.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(cb_match_c7932_2.issue<QAbstractTableModel_Adaptor, qt_gsi::Converter<QList<QModelIndex> >::target_type, const QModelIndex &, int, const QVariant &, int, const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type &>(&QAbstractTableModel_Adaptor::cbs_match_c7932_2, start, role, value, hits, qt_gsi::CppToQtAdaptor<QFlags<Qt::MatchFlag> >(flags))).cref();
    } else {
      return QAbstractTableModel::match(start, role, value, hits, flags);
    }
  }

  //  [adaptor impl] QMimeData *QAbstractTableModel::mimeData(const QList<QModelIndex> &indexes)
  QMimeData * cbs_mimeData_c3010_0(const qt_gsi::Converter<QList<QModelIndex> >::target_type & indexes) const
  {
    return QAbstractTableModel::mimeData(qt_gsi::QtToCppAdaptor<QList<QModelIndex> >(indexes).cref());
  }

  virtual QMimeData * mimeData(const QList<QModelIndex> &indexes) const
  {
    if (cb_mimeData_c3010_0.can_issue()) {
      return cb_mimeData_c3010_0.issue<QAbstractTableModel_Adaptor, QMimeData *, const qt_gsi::Converter<QList<QModelIndex> >::target_type &>(&QAbstractTableModel_Adaptor::cbs_mimeData_c3010_0, qt_gsi::CppToQtAdaptor<QList<QModelIndex> >(indexes));
    } else {
      return QAbstractTableModel::mimeData(indexes);
    }
  }

  //  [adaptor impl] QStringList QAbstractTableModel::mimeTypes()
  qt_gsi::Converter<QStringList>::target_type cbs_mimeTypes_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QStringList>(QAbstractTableModel::mimeTypes());
  }

  virtual QStringList mimeTypes() const
  {
    if (cb_mimeTypes_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QStringList>(cb_mimeTypes_c0_0.issue<QAbstractTableModel_Adaptor, qt_gsi::Converter<QStringList>::target_type>(&QAbstractTableModel_Adaptor::cbs_mimeTypes_c0_0)).cref();
    } else {
      return QAbstractTableModel::mimeTypes();
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::removeColumns(int column, int count, const QModelIndex &parent)
  bool cbs_removeColumns_3713_1(int column, int count, const QModelIndex &parent)
  {
    return QAbstractTableModel::removeColumns(column, count, parent);
  }

  virtual bool removeColumns(int column, int count, const QModelIndex &parent)
  {
    if (cb_removeColumns_3713_1.can_issue()) {
      return cb_removeColumns_3713_1.issue<QAbstractTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_removeColumns_3713_1, column, count, parent);
    } else {
      return QAbstractTableModel::removeColumns(column, count, parent);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::removeRows(int row, int count, const QModelIndex &parent)
  bool cbs_removeRows_3713_1(int row, int count, const QModelIndex &parent)
  {
    return QAbstractTableModel::removeRows(row, count, parent);
  }

  virtual bool removeRows(int row, int count, const QModelIndex &parent)
  {
    if (cb_removeRows_3713_1.can_issue()) {
      return cb_removeRows_3713_1.issue<QAbstractTableModel_Adaptor, bool, int, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_removeRows_3713_1, row, count, parent);
    } else {
      return QAbstractTableModel::removeRows(row, count, parent);
    }
  }

  //  [adaptor impl] void QAbstractTableModel::revert()
  void cbs_revert_0_0()
  {
    QAbstractTableModel::revert();
  }

  virtual void revert()
  {
    if (cb_revert_0_0.can_issue()) {
      cb_revert_0_0.issue<QAbstractTableModel_Adaptor>(&QAbstractTableModel_Adaptor::cbs_revert_0_0);
    } else {
      QAbstractTableModel::revert();
    }
  }

  //  [adaptor impl] int QAbstractTableModel::rowCount(const QModelIndex &parent)
  int cbs_rowCount_c2395_1(const QModelIndex &parent) const
  {
    throw qt_gsi::AbstractMethodCalledException("rowCount");
  }

  virtual int rowCount(const QModelIndex &parent) const
  {
    if (cb_rowCount_c2395_1.can_issue()) {
      return cb_rowCount_c2395_1.issue<QAbstractTableModel_Adaptor, int, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_rowCount_c2395_1, parent);
    } else {
      throw qt_gsi::AbstractMethodCalledException("rowCount");
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::setData(const QModelIndex &index, const QVariant &value, int role)
  bool cbs_setData_5065_1(const QModelIndex &index, const QVariant &value, int role)
  {
    return QAbstractTableModel::setData(index, value, role);
  }

  virtual bool setData(const QModelIndex &index, const QVariant &value, int role)
  {
    if (cb_setData_5065_1.can_issue()) {
      return cb_setData_5065_1.issue<QAbstractTableModel_Adaptor, bool, const QModelIndex &, const QVariant &, int>(&QAbstractTableModel_Adaptor::cbs_setData_5065_1, index, value, role);
    } else {
      return QAbstractTableModel::setData(index, value, role);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  bool cbs_setHeaderData_5242_1(int section, const qt_gsi::Converter<Qt::Orientation>::target_type & orientation, const QVariant &value, int role)
  {
    return QAbstractTableModel::setHeaderData(section, qt_gsi::QtToCppAdaptor<Qt::Orientation>(orientation).cref(), value, role);
  }

  virtual bool setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)
  {
    if (cb_setHeaderData_5242_1.can_issue()) {
      return cb_setHeaderData_5242_1.issue<QAbstractTableModel_Adaptor, bool, int, const qt_gsi::Converter<Qt::Orientation>::target_type &, const QVariant &, int>(&QAbstractTableModel_Adaptor::cbs_setHeaderData_5242_1, section, qt_gsi::CppToQtAdaptor<Qt::Orientation>(orientation), value, role);
    } else {
      return QAbstractTableModel::setHeaderData(section, orientation, value, role);
    }
  }

  //  [adaptor impl] void QAbstractTableModel::sort(int column, Qt::SortOrder order)
  void cbs_sort_2340_1(int column, const qt_gsi::Converter<Qt::SortOrder>::target_type & order)
  {
    QAbstractTableModel::sort(column, qt_gsi::QtToCppAdaptor<Qt::SortOrder>(order).cref());
  }

  virtual void sort(int column, Qt::SortOrder order)
  {
    if (cb_sort_2340_1.can_issue()) {
      cb_sort_2340_1.issue<QAbstractTableModel_Adaptor, int, const qt_gsi::Converter<Qt::SortOrder>::target_type &>(&QAbstractTableModel_Adaptor::cbs_sort_2340_1, column, qt_gsi::CppToQtAdaptor<Qt::SortOrder>(order));
    } else {
      QAbstractTableModel::sort(column, order);
    }
  }

  //  [adaptor impl] QSize QAbstractTableModel::span(const QModelIndex &index)
  QSize cbs_span_c2395_0(const QModelIndex &index) const
  {
    return QAbstractTableModel::span(index);
  }

  virtual QSize span(const QModelIndex &index) const
  {
    if (cb_span_c2395_0.can_issue()) {
      return cb_span_c2395_0.issue<QAbstractTableModel_Adaptor, QSize, const QModelIndex &>(&QAbstractTableModel_Adaptor::cbs_span_c2395_0, index);
    } else {
      return QAbstractTableModel::span(index);
    }
  }

  //  [adaptor impl] bool QAbstractTableModel::submit()
  bool cbs_submit_0_0()
  {
    return QAbstractTableModel::submit();
  }

  virtual bool submit()
  {
    if (cb_submit_0_0.can_issue()) {
      return cb_submit_0_0.issue<QAbstractTableModel_Adaptor, bool>(&QAbstractTableModel_Adaptor::cbs_submit_0_0);
    } else {
      return QAbstractTableModel::submit();
    }
  }

  //  [adaptor impl] QFlags<Qt::DropAction> QAbstractTableModel::supportedDropActions()
  qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type cbs_supportedDropActions_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::DropAction> >(QAbstractTableModel::supportedDropActions());
  }

  virtual QFlags<Qt::DropAction> supportedDropActions() const
  {
    if (cb_supportedDropActions_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::DropAction> >(cb_supportedDropActions_c0_0.issue<QAbstractTableModel_Adaptor, qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type>(&QAbstractTableModel_Adaptor::cbs_supportedDropActions_c0_0)).cref();
    } else {
      return QAbstractTableModel::supportedDropActions();
    }
  }

  //  [adaptor impl] void QAbstractTableModel::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractTableModel::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractTableModel_Adaptor, QChildEvent *>(&QAbstractTableModel_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractTableModel::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractTableModel::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractTableModel::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractTableModel_Adaptor, QEvent *>(&QAbstractTableModel_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractTableModel::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractTableModel::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QAbstractTableModel::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QAbstractTableModel_Adaptor, const char *>(&QAbstractTableModel_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QAbstractTableModel::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractTableModel::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractTableModel::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractTableModel_Adaptor, QTimerEvent *>(&QAbstractTableModel_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractTableModel::timerEvent(arg1);
    }
  }

  gsi::Callback cb_buddy_c2395_0;
  gsi::Callback cb_canFetchMore_c2395_0;
  gsi::Callback cb_columnCount_c2395_1;
  gsi::Callback cb_data_c3054_1;
  gsi::Callback cb_dropMimeData_7425_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_fetchMore_2395_0;
  gsi::Callback cb_flags_c2395_0;
  gsi::Callback cb_headerData_c3231_1;
  gsi::Callback cb_index_c3713_1;
  gsi::Callback cb_insertColumns_3713_1;
  gsi::Callback cb_insertRows_3713_1;
  gsi::Callback cb_match_c7932_2;
  gsi::Callback cb_mimeData_c3010_0;
  gsi::Callback cb_mimeTypes_c0_0;
  gsi::Callback cb_removeColumns_3713_1;
  gsi::Callback cb_removeRows_3713_1;
  gsi::Callback cb_revert_0_0;
  gsi::Callback cb_rowCount_c2395_1;
  gsi::Callback cb_setData_5065_1;
  gsi::Callback cb_setHeaderData_5242_1;
  gsi::Callback cb_sort_2340_1;
  gsi::Callback cb_span_c2395_0;
  gsi::Callback cb_submit_0_0;
  gsi::Callback cb_supportedDropActions_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractTableModel_Adaptor::~QAbstractTableModel_Adaptor() { }

//  Constructor QAbstractTableModel::QAbstractTableModel(QObject *parent) (adaptor class)

static void _init_ctor_QAbstractTableModel_Adaptor_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return_new<QAbstractTableModel_Adaptor *> ();
}

static void _call_ctor_QAbstractTableModel_Adaptor_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args ? args.read<QObject * > () : (QObject *)(0);
  ret.write<QAbstractTableModel_Adaptor *> (new QAbstractTableModel_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAbstractTableModel_Adaptor_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractTableModel::QAbstractTableModel(QObject *parent)\nThis method creates an object of class QAbstractTableModel.", &_init_ctor_QAbstractTableModel_Adaptor_1302, &_call_ctor_QAbstractTableModel_Adaptor_1302);
}

// void QAbstractTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginInsertColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertColumns", "@brief Method void QAbstractTableModel::beginInsertColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertColumns_3713, &_call_fp_beginInsertColumns_3713);
}


// void QAbstractTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginInsertRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginInsertRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginInsertRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginInsertRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginInsertRows", "@brief Method void QAbstractTableModel::beginInsertRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginInsertRows_3713, &_call_fp_beginInsertRows_3713);
}


// bool QAbstractTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)

static void _init_fp_beginMoveColumns_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationColumn");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveColumns_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginMoveColumns_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveColumns_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveColumns", "@brief Method bool QAbstractTableModel::beginMoveColumns(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationColumn)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveColumns_6659, &_call_fp_beginMoveColumns_6659);
}


// bool QAbstractTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)

static void _init_fp_beginMoveRows_6659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sourceParent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("sourceFirst");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("sourceLast");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("destinationParent");
  decl->add_arg<const QModelIndex & > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("destinationRow");
  decl->add_arg<int > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_fp_beginMoveRows_6659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  const QModelIndex &arg4 = args.read<const QModelIndex & > ();
  int arg5 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginMoveRows_6659 (arg1, arg2, arg3, arg4, arg5));
}

static qt_gsi::GenericMethod*_create_fp_beginMoveRows_6659 ()
{
  return new qt_gsi::GenericMethod("*beginMoveRows", "@brief Method bool QAbstractTableModel::beginMoveRows(const QModelIndex &sourceParent, int sourceFirst, int sourceLast, const QModelIndex &destinationParent, int destinationRow)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginMoveRows_6659, &_call_fp_beginMoveRows_6659);
}


// void QAbstractTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveColumns_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveColumns_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginRemoveColumns_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveColumns_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveColumns", "@brief Method void QAbstractTableModel::beginRemoveColumns(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveColumns_3713, &_call_fp_beginRemoveColumns_3713);
}


// void QAbstractTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)

static void _init_fp_beginRemoveRows_3713 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("first");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("last");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_fp_beginRemoveRows_3713 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginRemoveRows_3713 (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod*_create_fp_beginRemoveRows_3713 ()
{
  return new qt_gsi::GenericMethod("*beginRemoveRows", "@brief Method void QAbstractTableModel::beginRemoveRows(const QModelIndex &parent, int first, int last)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginRemoveRows_3713, &_call_fp_beginRemoveRows_3713);
}


// void QAbstractTableModel::beginResetModel()

static void _init_fp_beginResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_beginResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_beginResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_beginResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*beginResetModel", "@brief Method void QAbstractTableModel::beginResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_beginResetModel_0, &_call_fp_beginResetModel_0);
}


// void QAbstractTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)

static void _init_fp_changePersistentIndex_4682 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const QModelIndex & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndex_4682 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QModelIndex &arg2 = args.read<const QModelIndex & > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_changePersistentIndex_4682 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndex_4682 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndex", "@brief Method void QAbstractTableModel::changePersistentIndex(const QModelIndex &from, const QModelIndex &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndex_4682, &_call_fp_changePersistentIndex_4682);
}


// void QAbstractTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)

static void _init_fp_changePersistentIndexList_5912 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("from");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("to");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_changePersistentIndexList_5912 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg2 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_changePersistentIndexList_5912 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_changePersistentIndexList_5912 ()
{
  return new qt_gsi::GenericMethod("*changePersistentIndexList", "@brief Method void QAbstractTableModel::changePersistentIndexList(const QList<QModelIndex> &from, const QList<QModelIndex> &to)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_changePersistentIndexList_5912, &_call_fp_changePersistentIndexList_5912);
}


// QModelIndex QAbstractTableModel::createIndex(int row, int column, void *data)

static void _init_fp_createIndex_c2374 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("data", true, "0");
  decl->add_arg<void * > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2374 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  void *arg3 = args ? args.read<void * > () : (void *)(0);
  ret.write<QModelIndex > ((QModelIndex)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_createIndex_c2374 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2374 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QAbstractTableModel::createIndex(int row, int column, void *data)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2374, &_call_fp_createIndex_c2374);
}


// QModelIndex QAbstractTableModel::createIndex(int row, int column, int id)

static void _init_fp_createIndex_c2085 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2085 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  int arg3 = args.read<int > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_createIndex_c2085 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2085 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QAbstractTableModel::createIndex(int row, int column, int id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2085, &_call_fp_createIndex_c2085);
}


// QModelIndex QAbstractTableModel::createIndex(int row, int column, quint32 id)

static void _init_fp_createIndex_c2416 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("id");
  decl->add_arg<quint32 > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_fp_createIndex_c2416 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  quint32 arg3 = args.read<quint32 > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_createIndex_c2416 (arg1, arg2, arg3));
}

static qt_gsi::GenericMethod*_create_fp_createIndex_c2416 ()
{
  return new qt_gsi::GenericMethod("*createIndex", "@brief Method QModelIndex QAbstractTableModel::createIndex(int row, int column, quint32 id)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_createIndex_c2416, &_call_fp_createIndex_c2416);
}


// bool QAbstractTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)

static void _init_fp_decodeData_5302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("stream");
  decl->add_arg<QDataStream & > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_fp_decodeData_5302 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  QDataStream &arg4 = args.read<QDataStream & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_decodeData_5302 (arg1, arg2, arg3, arg4));
}

static qt_gsi::GenericMethod*_create_fp_decodeData_5302 ()
{
  return new qt_gsi::GenericMethod("*decodeData", "@brief Method bool QAbstractTableModel::decodeData(int row, int column, const QModelIndex &parent, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_decodeData_5302, &_call_fp_decodeData_5302);
}


// void QAbstractTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)

static void _init_fp_encodeData_c4599 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stream");
  decl->add_arg<QDataStream & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_encodeData_c4599 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  QDataStream &arg2 = args.read<QDataStream & > ();
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_encodeData_c4599 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_encodeData_c4599 ()
{
  return new qt_gsi::GenericMethod("*encodeData", "@brief Method void QAbstractTableModel::encodeData(const QList<QModelIndex> &indexes, QDataStream &stream)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_encodeData_c4599, &_call_fp_encodeData_c4599);
}


// void QAbstractTableModel::endInsertColumns()

static void _init_fp_endInsertColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endInsertColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertColumns", "@brief Method void QAbstractTableModel::endInsertColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertColumns_0, &_call_fp_endInsertColumns_0);
}


// void QAbstractTableModel::endInsertRows()

static void _init_fp_endInsertRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endInsertRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endInsertRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endInsertRows_0 ()
{
  return new qt_gsi::GenericMethod("*endInsertRows", "@brief Method void QAbstractTableModel::endInsertRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endInsertRows_0, &_call_fp_endInsertRows_0);
}


// void QAbstractTableModel::endMoveColumns()

static void _init_fp_endMoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endMoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveColumns", "@brief Method void QAbstractTableModel::endMoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveColumns_0, &_call_fp_endMoveColumns_0);
}


// void QAbstractTableModel::endMoveRows()

static void _init_fp_endMoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endMoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endMoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endMoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endMoveRows", "@brief Method void QAbstractTableModel::endMoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endMoveRows_0, &_call_fp_endMoveRows_0);
}


// void QAbstractTableModel::endRemoveColumns()

static void _init_fp_endRemoveColumns_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveColumns_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endRemoveColumns_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveColumns_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveColumns", "@brief Method void QAbstractTableModel::endRemoveColumns()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveColumns_0, &_call_fp_endRemoveColumns_0);
}


// void QAbstractTableModel::endRemoveRows()

static void _init_fp_endRemoveRows_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endRemoveRows_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endRemoveRows_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endRemoveRows_0 ()
{
  return new qt_gsi::GenericMethod("*endRemoveRows", "@brief Method void QAbstractTableModel::endRemoveRows()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endRemoveRows_0, &_call_fp_endRemoveRows_0);
}


// void QAbstractTableModel::endResetModel()

static void _init_fp_endResetModel_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_endResetModel_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_endResetModel_0 ();
}

static qt_gsi::GenericMethod*_create_fp_endResetModel_0 ()
{
  return new qt_gsi::GenericMethod("*endResetModel", "@brief Method void QAbstractTableModel::endResetModel()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_endResetModel_0, &_call_fp_endResetModel_0);
}


// QList<QModelIndex> QAbstractTableModel::persistentIndexList()

static void _init_fp_persistentIndexList_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_fp_persistentIndexList_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_persistentIndexList_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_persistentIndexList_c0 ()
{
  return new qt_gsi::GenericMethod("*persistentIndexList", "@brief Method QList<QModelIndex> QAbstractTableModel::persistentIndexList()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_persistentIndexList_c0, &_call_fp_persistentIndexList_c0);
}


// int QAbstractTableModel::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QAbstractTableModel::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// void QAbstractTableModel::reset()

static void _init_fp_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_fp_reset_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_reset_0 ();
}

static qt_gsi::GenericMethod*_create_fp_reset_0 ()
{
  return new qt_gsi::GenericMethod("*reset", "@brief Method void QAbstractTableModel::reset()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_reset_0, &_call_fp_reset_0);
}


// QObject *QAbstractTableModel::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QAbstractTableModel_Adaptor *)cls)->fp_QAbstractTableModel_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QAbstractTableModel::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// QModelIndex QAbstractTableModel::buddy(const QModelIndex &index)

static void _init_cbs_buddy_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_buddy_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractTableModel_Adaptor *)cls)->cbs_buddy_c2395_0 (arg1));
}

static void _set_callback_cbs_buddy_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_buddy_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@hide", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_buddy_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("buddy", "@brief Virtual method QModelIndex QAbstractTableModel::buddy(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_buddy_c2395_0, &_call_cbs_buddy_c2395_0, &_set_callback_cbs_buddy_c2395_0);
}


// bool QAbstractTableModel::canFetchMore(const QModelIndex &parent)

static void _init_cbs_canFetchMore_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_canFetchMore_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_canFetchMore_c2395_0 (arg1));
}

static void _set_callback_cbs_canFetchMore_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_canFetchMore_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@hide", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_canFetchMore_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("canFetchMore", "@brief Virtual method bool QAbstractTableModel::canFetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_canFetchMore_c2395_0, &_call_cbs_canFetchMore_c2395_0, &_set_callback_cbs_canFetchMore_c2395_0);
}


// int QAbstractTableModel::columnCount(const QModelIndex &parent)

static void _init_cbs_columnCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_columnCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QAbstractTableModel_Adaptor *)cls)->cbs_columnCount_c2395_1 (arg1));
}

static void _set_callback_cbs_columnCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_columnCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@hide", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_columnCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("columnCount", "@brief Virtual method int QAbstractTableModel::columnCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_columnCount_c2395_1, &_call_cbs_columnCount_c2395_1, &_set_callback_cbs_columnCount_c2395_1);
}


// QVariant QAbstractTableModel::data(const QModelIndex &index, int role)

static void _init_cbs_data_c3054_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QVariant > ();
}

static void _call_cbs_data_c3054_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QAbstractTableModel_Adaptor *)cls)->cbs_data_c3054_1 (arg1, arg2));
}

static void _set_callback_cbs_data_c3054_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_data_c3054_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@hide", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_data_c3054_1 ()
{
  return new qt_gsi::GenericMethod ("data", "@brief Virtual method QVariant QAbstractTableModel::data(const QModelIndex &index, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_data_c3054_1, &_call_cbs_data_c3054_1, &_set_callback_cbs_data_c3054_1);
}


// bool QAbstractTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)

static void _init_cbs_dropMimeData_7425_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("data");
  decl->add_arg<const QMimeData * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("action");
  decl->add_arg<const qt_gsi::Converter<Qt::DropAction>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("row");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("column");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_4);
  decl->set_return<bool > ();
}

static void _call_cbs_dropMimeData_7425_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QMimeData *arg1 = args.read<const QMimeData * > ();
  const qt_gsi::Converter<Qt::DropAction>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::DropAction>::target_type & > ();
  int arg3 = args.read<int > ();
  int arg4 = args.read<int > ();
  const QModelIndex &arg5 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_dropMimeData_7425_0 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_dropMimeData_7425_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_dropMimeData_7425_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@hide", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_dropMimeData_7425_0 ()
{
  return new qt_gsi::GenericMethod ("dropMimeData", "@brief Virtual method bool QAbstractTableModel::dropMimeData(const QMimeData *data, Qt::DropAction action, int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_dropMimeData_7425_0, &_call_cbs_dropMimeData_7425_0, &_set_callback_cbs_dropMimeData_7425_0);
}


// bool QAbstractTableModel::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractTableModel::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QAbstractTableModel::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractTableModel::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// void QAbstractTableModel::fetchMore(const QModelIndex &parent)

static void _init_cbs_fetchMore_2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_fetchMore_2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ((QAbstractTableModel_Adaptor *)cls)->cbs_fetchMore_2395_0 (arg1);
}

static void _set_callback_cbs_fetchMore_2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_fetchMore_2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@hide", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_fetchMore_2395_0 ()
{
  return new qt_gsi::GenericMethod ("fetchMore", "@brief Virtual method void QAbstractTableModel::fetchMore(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_fetchMore_2395_0, &_call_cbs_fetchMore_2395_0, &_set_callback_cbs_fetchMore_2395_0);
}


// QFlags<Qt::ItemFlag> QAbstractTableModel::flags(const QModelIndex &index)

static void _init_cbs_flags_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ();
}

static void _call_cbs_flags_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type > ((qt_gsi::Converter<QFlags<Qt::ItemFlag> >::target_type)((QAbstractTableModel_Adaptor *)cls)->cbs_flags_c2395_0 (arg1));
}

static void _set_callback_cbs_flags_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_flags_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@hide", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_flags_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("flags", "@brief Virtual method QFlags<Qt::ItemFlag> QAbstractTableModel::flags(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_flags_c2395_0, &_call_cbs_flags_c2395_0, &_set_callback_cbs_flags_c2395_0);
}


// QVariant QAbstractTableModel::headerData(int section, Qt::Orientation orientation, int role)

static void _init_cbs_headerData_c3231_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QVariant > ();
}

static void _call_cbs_headerData_c3231_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  int arg3 = args.read<int > ();
  ret.write<QVariant > ((QVariant)((QAbstractTableModel_Adaptor *)cls)->cbs_headerData_c3231_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_headerData_c3231_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_headerData_c3231_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@hide", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_headerData_c3231_1 ()
{
  return new qt_gsi::GenericMethod ("headerData", "@brief Virtual method QVariant QAbstractTableModel::headerData(int section, Qt::Orientation orientation, int role)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_headerData_c3231_1, &_call_cbs_headerData_c3231_1, &_set_callback_cbs_headerData_c3231_1);
}


// QModelIndex QAbstractTableModel::index(int row, int column, const QModelIndex &parent)

static void _init_cbs_index_c3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("column");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<QModelIndex > ();
}

static void _call_cbs_index_c3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<QModelIndex > ((QModelIndex)((QAbstractTableModel_Adaptor *)cls)->cbs_index_c3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_index_c3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_index_c3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@hide", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_index_c3713_1 ()
{
  return new qt_gsi::GenericMethod ("index", "@brief Virtual method QModelIndex QAbstractTableModel::index(int row, int column, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_index_c3713_1, &_call_cbs_index_c3713_1, &_set_callback_cbs_index_c3713_1);
}


// bool QAbstractTableModel::insertColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_insertColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_insertColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_insertColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@hide", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertColumns", "@brief Virtual method bool QAbstractTableModel::insertColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertColumns_3713_1, &_call_cbs_insertColumns_3713_1, &_set_callback_cbs_insertColumns_3713_1);
}


// bool QAbstractTableModel::insertRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_insertRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_insertRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_insertRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_insertRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_insertRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@hide", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_insertRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("insertRows", "@brief Virtual method bool QAbstractTableModel::insertRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_insertRows_3713_1, &_call_cbs_insertRows_3713_1, &_set_callback_cbs_insertRows_3713_1);
}


// QList<QModelIndex> QAbstractTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)

static void _init_cbs_match_c7932_2 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("start");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("hits");
  decl->add_arg<int > (argspec_3);
  static gsi::ArgSpecBase argspec_4 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > (argspec_4);
  decl->set_return<qt_gsi::Converter<QList<QModelIndex> >::target_type > ();
}

static void _call_cbs_match_c7932_2 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  int arg2 = args.read<int > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & arg5 = args.read<const qt_gsi::Converter<QFlags<Qt::MatchFlag> >::target_type & > ();
  ret.write<qt_gsi::Converter<QList<QModelIndex> >::target_type > ((qt_gsi::Converter<QList<QModelIndex> >::target_type)((QAbstractTableModel_Adaptor *)cls)->cbs_match_c7932_2 (arg1, arg2, arg3, arg4, arg5));
}

static void _set_callback_cbs_match_c7932_2 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_match_c7932_2 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@hide", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2);
}

static qt_gsi::GenericMethod *_create_callback_cbs_match_c7932_2 ()
{
  return new qt_gsi::GenericMethod ("match", "@brief Virtual method QList<QModelIndex> QAbstractTableModel::match(const QModelIndex &start, int role, const QVariant &value, int hits, QFlags<Qt::MatchFlag> flags)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_match_c7932_2, &_call_cbs_match_c7932_2, &_set_callback_cbs_match_c7932_2);
}


// QMimeData *QAbstractTableModel::mimeData(const QList<QModelIndex> &indexes)

static void _init_cbs_mimeData_c3010_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("indexes");
  decl->add_arg<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > (argspec_0);
  decl->set_return<QMimeData * > ();
}

static void _call_cbs_mimeData_c3010_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QList<QModelIndex> >::target_type & arg1 = args.read<const qt_gsi::Converter<QList<QModelIndex> >::target_type & > ();
  ret.write<QMimeData * > ((QMimeData *)((QAbstractTableModel_Adaptor *)cls)->cbs_mimeData_c3010_0 (arg1));
}

static void _set_callback_cbs_mimeData_c3010_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_mimeData_c3010_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@hide", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeData_c3010_0 ()
{
  return new qt_gsi::GenericMethod ("mimeData", "@brief Virtual method QMimeData *QAbstractTableModel::mimeData(const QList<QModelIndex> &indexes)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeData_c3010_0, &_call_cbs_mimeData_c3010_0, &_set_callback_cbs_mimeData_c3010_0);
}


// QStringList QAbstractTableModel::mimeTypes()

static void _init_cbs_mimeTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QStringList>::target_type > ();
}

static void _call_cbs_mimeTypes_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QStringList>::target_type > ((qt_gsi::Converter<QStringList>::target_type)((QAbstractTableModel_Adaptor *)cls)->cbs_mimeTypes_c0_0 ());
}

static void _set_callback_cbs_mimeTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_mimeTypes_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@hide", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_mimeTypes_c0_0 ()
{
  return new qt_gsi::GenericMethod ("mimeTypes", "@brief Virtual method QStringList QAbstractTableModel::mimeTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_mimeTypes_c0_0, &_call_cbs_mimeTypes_c0_0, &_set_callback_cbs_mimeTypes_c0_0);
}


// bool QAbstractTableModel::removeColumns(int column, int count, const QModelIndex &parent)

static void _init_cbs_removeColumns_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeColumns_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_removeColumns_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeColumns_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_removeColumns_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@hide", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeColumns_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeColumns", "@brief Virtual method bool QAbstractTableModel::removeColumns(int column, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeColumns_3713_1, &_call_cbs_removeColumns_3713_1, &_set_callback_cbs_removeColumns_3713_1);
}


// bool QAbstractTableModel::removeRows(int row, int count, const QModelIndex &parent)

static void _init_cbs_removeRows_3713_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("count");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_removeRows_3713_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  const QModelIndex &arg3 = args.read<const QModelIndex & > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_removeRows_3713_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_removeRows_3713_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_removeRows_3713_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@hide", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_removeRows_3713_1 ()
{
  return new qt_gsi::GenericMethod ("removeRows", "@brief Virtual method bool QAbstractTableModel::removeRows(int row, int count, const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_removeRows_3713_1, &_call_cbs_removeRows_3713_1, &_set_callback_cbs_removeRows_3713_1);
}


// void QAbstractTableModel::revert()

static void _init_cbs_revert_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_revert_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QAbstractTableModel_Adaptor *)cls)->cbs_revert_0_0 ();
}

static void _set_callback_cbs_revert_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_revert_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@hide", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_revert_0_0 ()
{
  return new qt_gsi::GenericMethod ("revert", "@brief Virtual method void QAbstractTableModel::revert()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_revert_0_0, &_call_cbs_revert_0_0, &_set_callback_cbs_revert_0_0);
}


// int QAbstractTableModel::rowCount(const QModelIndex &parent)

static void _init_cbs_rowCount_c2395_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_rowCount_c2395_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<int > ((int)((QAbstractTableModel_Adaptor *)cls)->cbs_rowCount_c2395_1 (arg1));
}

static void _set_callback_cbs_rowCount_c2395_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_rowCount_c2395_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@hide", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_rowCount_c2395_1 ()
{
  return new qt_gsi::GenericMethod ("rowCount", "@brief Virtual method int QAbstractTableModel::rowCount(const QModelIndex &parent)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_rowCount_c2395_1, &_call_cbs_rowCount_c2395_1, &_set_callback_cbs_rowCount_c2395_1);
}


// bool QAbstractTableModel::setData(const QModelIndex &index, const QVariant &value, int role)

static void _init_cbs_setData_5065_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("value");
  decl->add_arg<const QVariant & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("role");
  decl->add_arg<int > (argspec_2);
  decl->set_return<bool > ();
}

static void _call_cbs_setData_5065_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  const QVariant &arg2 = args.read<const QVariant & > ();
  int arg3 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_setData_5065_1 (arg1, arg2, arg3));
}

static void _set_callback_cbs_setData_5065_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_setData_5065_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@hide", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setData_5065_1 ()
{
  return new qt_gsi::GenericMethod ("setData", "@brief Virtual method bool QAbstractTableModel::setData(const QModelIndex &index, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setData_5065_1, &_call_cbs_setData_5065_1, &_set_callback_cbs_setData_5065_1);
}


// bool QAbstractTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)

static void _init_cbs_setHeaderData_5242_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("section");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("orientation");
  decl->add_arg<const qt_gsi::Converter<Qt::Orientation>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("value");
  decl->add_arg<const QVariant & > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("role");
  decl->add_arg<int > (argspec_3);
  decl->set_return<bool > ();
}

static void _call_cbs_setHeaderData_5242_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::Orientation>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::Orientation>::target_type & > ();
  const QVariant &arg3 = args.read<const QVariant & > ();
  int arg4 = args.read<int > ();
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_setHeaderData_5242_1 (arg1, arg2, arg3, arg4));
}

static void _set_callback_cbs_setHeaderData_5242_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_setHeaderData_5242_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@hide", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setHeaderData_5242_1 ()
{
  return new qt_gsi::GenericMethod ("setHeaderData", "@brief Virtual method bool QAbstractTableModel::setHeaderData(int section, Qt::Orientation orientation, const QVariant &value, int role)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setHeaderData_5242_1, &_call_cbs_setHeaderData_5242_1, &_set_callback_cbs_setHeaderData_5242_1);
}


// void QAbstractTableModel::sort(int column, Qt::SortOrder order)

static void _init_cbs_sort_2340_1 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("column");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("order");
  decl->add_arg<const qt_gsi::Converter<Qt::SortOrder>::target_type & > (argspec_1);
  decl->set_return<void > ();
}

static void _call_cbs_sort_2340_1 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  const qt_gsi::Converter<Qt::SortOrder>::target_type & arg2 = args.read<const qt_gsi::Converter<Qt::SortOrder>::target_type & > ();
  ((QAbstractTableModel_Adaptor *)cls)->cbs_sort_2340_1 (arg1, arg2);
}

static void _set_callback_cbs_sort_2340_1 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_sort_2340_1 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@hide", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sort_2340_1 ()
{
  return new qt_gsi::GenericMethod ("sort", "@brief Virtual method void QAbstractTableModel::sort(int column, Qt::SortOrder order)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_sort_2340_1, &_call_cbs_sort_2340_1, &_set_callback_cbs_sort_2340_1);
}


// QSize QAbstractTableModel::span(const QModelIndex &index)

static void _init_cbs_span_c2395_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<const QModelIndex & > (argspec_0);
  decl->set_return<QSize > ();
}

static void _call_cbs_span_c2395_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QModelIndex &arg1 = args.read<const QModelIndex & > ();
  ret.write<QSize > ((QSize)((QAbstractTableModel_Adaptor *)cls)->cbs_span_c2395_0 (arg1));
}

static void _set_callback_cbs_span_c2395_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_span_c2395_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@hide", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_span_c2395_0 ()
{
  return new qt_gsi::GenericMethod ("span", "@brief Virtual method QSize QAbstractTableModel::span(const QModelIndex &index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_span_c2395_0, &_call_cbs_span_c2395_0, &_set_callback_cbs_span_c2395_0);
}


// bool QAbstractTableModel::submit()

static void _init_cbs_submit_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_submit_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QAbstractTableModel_Adaptor *)cls)->cbs_submit_0_0 ());
}

static void _set_callback_cbs_submit_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_submit_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@hide", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_submit_0_0 ()
{
  return new qt_gsi::GenericMethod ("submit", "@brief Virtual method bool QAbstractTableModel::submit()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_submit_0_0, &_call_cbs_submit_0_0, &_set_callback_cbs_submit_0_0);
}


// QFlags<Qt::DropAction> QAbstractTableModel::supportedDropActions()

static void _init_cbs_supportedDropActions_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ();
}

static void _call_cbs_supportedDropActions_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type > ((qt_gsi::Converter<QFlags<Qt::DropAction> >::target_type)((QAbstractTableModel_Adaptor *)cls)->cbs_supportedDropActions_c0_0 ());
}

static void _set_callback_cbs_supportedDropActions_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_supportedDropActions_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@hide", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_supportedDropActions_c0_0 ()
{
  return new qt_gsi::GenericMethod ("supportedDropActions", "@brief Virtual method QFlags<Qt::DropAction> QAbstractTableModel::supportedDropActions()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_supportedDropActions_c0_0, &_call_cbs_supportedDropActions_c0_0, &_set_callback_cbs_supportedDropActions_c0_0);
}


// void QAbstractTableModel::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QAbstractTableModel_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractTableModel::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QAbstractTableModel::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QAbstractTableModel_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractTableModel::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QAbstractTableModel::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QAbstractTableModel_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractTableModel::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QAbstractTableModel::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QAbstractTableModel_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractTableModel_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractTableModel::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QAbstractTableModel> decl_QAbstractTableModel;

gsi::Class<QAbstractTableModel_Adaptor> decl_QAbstractTableModel_Adaptor (decl_QAbstractTableModel, "QAbstractTableModel",
  gsi::Methods(_create_fp_beginInsertColumns_3713 ()) +
  gsi::Methods(_create_fp_beginInsertRows_3713 ()) +
  gsi::Methods(_create_fp_beginMoveColumns_6659 ()) +
  gsi::Methods(_create_fp_beginMoveRows_6659 ()) +
  gsi::Methods(_create_fp_beginRemoveColumns_3713 ()) +
  gsi::Methods(_create_fp_beginRemoveRows_3713 ()) +
  gsi::Methods(_create_fp_beginResetModel_0 ()) +
  gsi::Methods(_create_fp_changePersistentIndex_4682 ()) +
  gsi::Methods(_create_fp_changePersistentIndexList_5912 ()) +
  gsi::Methods(_create_fp_createIndex_c2374 ()) +
  gsi::Methods(_create_fp_createIndex_c2085 ()) +
  gsi::Methods(_create_fp_createIndex_c2416 ()) +
  gsi::Methods(_create_fp_decodeData_5302 ()) +
  gsi::Methods(_create_fp_encodeData_c4599 ()) +
  gsi::Methods(_create_fp_endInsertColumns_0 ()) +
  gsi::Methods(_create_fp_endInsertRows_0 ()) +
  gsi::Methods(_create_fp_endMoveColumns_0 ()) +
  gsi::Methods(_create_fp_endMoveRows_0 ()) +
  gsi::Methods(_create_fp_endRemoveColumns_0 ()) +
  gsi::Methods(_create_fp_endRemoveRows_0 ()) +
  gsi::Methods(_create_fp_endResetModel_0 ()) +
  gsi::Methods(_create_fp_persistentIndexList_c0 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_reset_0 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_buddy_c2395_0 ()) +
  gsi::Methods(_create_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_canFetchMore_c2395_0 ()) +
  gsi::Methods(_create_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_columnCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_callback_cbs_data_c3054_1 ()) +
  gsi::Methods(_create_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_callback_cbs_dropMimeData_7425_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_callback_cbs_fetchMore_2395_0 ()) +
  gsi::Methods(_create_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_flags_c2395_0 ()) +
  gsi::Methods(_create_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_callback_cbs_headerData_c3231_1 ()) +
  gsi::Methods(_create_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_callback_cbs_index_c3713_1 ()) +
  gsi::Methods(_create_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_insertRows_3713_1 ()) +
  gsi::Methods(_create_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_callback_cbs_match_c7932_2 ()) +
  gsi::Methods(_create_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeData_c3010_0 ()) +
  gsi::Methods(_create_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_mimeTypes_c0_0 ()) +
  gsi::Methods(_create_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeColumns_3713_1 ()) +
  gsi::Methods(_create_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_callback_cbs_removeRows_3713_1 ()) +
  gsi::Methods(_create_cbs_revert_0_0 ()) +
  gsi::Methods(_create_callback_cbs_revert_0_0 ()) +
  gsi::Methods(_create_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_callback_cbs_rowCount_c2395_1 ()) +
  gsi::Methods(_create_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_callback_cbs_setData_5065_1 ()) +
  gsi::Methods(_create_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_callback_cbs_setHeaderData_5242_1 ()) +
  gsi::Methods(_create_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_callback_cbs_sort_2340_1 ()) +
  gsi::Methods(_create_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_callback_cbs_span_c2395_0 ()) +
  gsi::Methods(_create_cbs_submit_0_0 ()) +
  gsi::Methods(_create_callback_cbs_submit_0_0 ()) +
  gsi::Methods(_create_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_supportedDropActions_c0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QAbstractTableModel_Adaptor_1302 ()),
  "@qt\n@brief Binding of QAbstractTableModel");

}

