
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/


#include <QtGui/QApplication>
#include <QtGui/QFont>
#include <QtGui/QBitmap>
#include <QtGui/QPainter>
#include <QtGui/QFontDialog>

#include <stdio.h>

int 
main (int argc, char *argv [])
{
  QApplication app (argc, argv);

  printf ("\n// generated by fontgen\n// DO NOT EDIT !\n\n");

  printf ("\nnamespace lay {\n");

  std::string table;

  int sz[] = { 9, 11, 13, 18, 22, 26, 27, 33, 39, 0 };

  for (int os = 1; sz[os - 1] > 0; ++os) {

    char b[1024];
    sprintf (b, "  FixedFont (ff%d_height, ff%d_line_height, ff%d_width, ff%d_first_char, sizeof (ff%d_data) / sizeof (uint32_t) / ff%d_height, ff%d_data),\n", os, os, os, os, os, os, os);
    table += b;

    QFont f (QString::fromAscii ("Liberation Mono"), sz[os - 1]);
    f.setStyleStrategy(QFont::StyleStrategy ((f.styleStrategy() & ~QFont::PreferAntialias) | QFont::NoAntialias));

    QFontMetrics fm (f);

    int w = std::min (32, fm.width (QChar::fromAscii ('W')));

    printf ("\n// Font: %s\n", f.toString ().toAscii ().constData ());
    printf ("const unsigned int ff%d_height = %d;\nconst unsigned int ff%d_line_height = %d;\nconst unsigned int ff%d_width = %d;\n",
      os, fm.height (), os, fm.lineSpacing (), os, w);

    printf ("const unsigned char ff%d_first_char = ' ';\n\nuint32_t ff%d_data [] = {\n", os, os);

    for (int c = ' '; c < 256; ++c) {

      QImage img (w, fm.height (), QImage::Format_RGB32);
      img.fill (0xffffffff);
      QPainter p (&img);
      p.setPen (Qt::black);
      p.setRenderHints (QPainter::TextAntialiasing, false);
      p.setFont (f);

      char t[2];
      t[0] = c;
      t[1] = 0;
      p.drawText (0, fm.ascent (), QString::fromLatin1 (t));

      QImage b = img.convertToFormat (QImage::Format_MonoLSB);

      printf ("  // %d\n  ", c);
      for (int i = 0; i < fm.height (); ++i) {
        if (i > 0) {
          printf (", ");
        }
        printf ("0x%x", w < 32 ? *(int *)b.scanLine (i) & ((1 << b.width ()) - 1) : *(int *)b.scanLine (i));
      }
      printf (",\n");

    }

    printf ("};\n");

  }

  printf ("\nstatic FixedFont fonts[] = {\n%s};\n", table.c_str ());

  printf ("\n} // namespace lay\n");

  return 0;
}


