// 
// Hiero
// Copyright (c) 2015  Barry Block 
// 
// This program is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version. 
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  See the GNU General Public License for more details. 
// 
// You should have received a copy of the GNU General Public License along with
// this program.  If not, see <http://www.gnu.org/licenses/>. 
//

using System;
using System.IO;
using Gtk;

namespace Hiero
{
   // Manages the app's command session, keeping track of opened documents. 
   public class Session
   {
      private string sessionFile;
         // The file containing the session data.

      public Session(string sessionFile)
      {
         this.sessionFile = sessionFile;
      }

      // Gets the session's file path.
      public string FilePath
      {
         get { return sessionFile; }
      }

      // Saves the session.
      public void Save(string sessionData)
      {
         File.WriteAllText(FilePath, sessionData);
      }
   }
}

