// 
// Hiero
// Copyright (c) 2015  Barry Block 
// 
// This program is free software: you can redistribute it and/or modify it under
// the terms of the GNU General Public License as published by the Free Software
// Foundation, either version 3 of the License, or (at your option) any later
// version. 
// 
// This program is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
// PARTICULAR PURPOSE.  See the GNU General Public License for more details. 
// 
// You should have received a copy of the GNU General Public License along with
// this program.  If not, see <http://www.gnu.org/licenses/>. 
//

using System;
using Gtk;

namespace Hiero
{
   public class PropertiesDialog : Gtk.Dialog
   {
      private FontButton OutlineFontButton;
      private CheckButton TreeLinesEnabledCheckBox;
      private CheckButton PangoEnabledCheckBox;
      private CheckButton ColorBarsEnabledCheckBox;
      private Entry WrapMarginEntry;

      public PropertiesDialog(Gtk.Window parent) : base("Document Properties", parent, DialogFlags.Modal | DialogFlags.DestroyWithParent,
      Gtk.Stock.Cancel, ResponseType.Cancel, Gtk.Stock.Ok, ResponseType.Ok)
      {
         this.Resizable = false;
         VBox vBox1 = new Gtk.VBox();


         HBox hBox1 = new Gtk.HBox();
         Label label3 = new Gtk.Label();
         label3.LabelProp = "   Default Font:";
         hBox1.PackStart(label3, false, false, 0);

         OutlineFontButton = new Gtk.FontButton();
         hBox1.PackStart(OutlineFontButton, false, false, 0);

         hBox1.Spacing = 6;
         vBox1.Add(hBox1);


         HBox hBox2 = new Gtk.HBox();
         Label label4 = new Gtk.Label();
         label4.LabelProp = "   Enable Tree Lines:";
         hBox2.PackStart(label4, false, false, 0);

         TreeLinesEnabledCheckBox = new Gtk.CheckButton();
         hBox2.PackStart(TreeLinesEnabledCheckBox, false, false, 0);

         hBox2.Spacing = 6;
         vBox1.Add(hBox2);


         HBox hBox4 = new Gtk.HBox();
         Label label6 = new Gtk.Label();
         label6.LabelProp = "   Enable Color Bars:";
         hBox4.PackStart(label6, false, false, 0);

         ColorBarsEnabledCheckBox = new Gtk.CheckButton();
         hBox4.PackStart(ColorBarsEnabledCheckBox, false, false, 0);

         hBox4.Spacing = 6;
         vBox1.Add(hBox4);


         HBox hBox3 = new Gtk.HBox();
         Label label5 = new Gtk.Label();
         label5.LabelProp = "   Enable Pango Markup:";
         hBox3.PackStart(label5, false, false, 0);

         PangoEnabledCheckBox = new Gtk.CheckButton();
         hBox3.PackStart(PangoEnabledCheckBox, false, false, 0);

         hBox3.Spacing = 6;
         vBox1.Add(hBox3);

         
         HBox hBox5 = new Gtk.HBox();
         Label label1 = new Gtk.Label();
         label1.LabelProp = "   Wrap Margin:";
         hBox5.PackStart(label1, false, false, 0);

         WrapMarginEntry = new Gtk.Entry();
         hBox5.PackStart(WrapMarginEntry, false, false, 0);

         hBox5.Spacing = 6;
         vBox1.Add(hBox5);


         vBox1.Spacing = 6;
         this.VBox.Add(vBox1);
         this.ShowAll();
      }

      public string OutlineFont
      {
         get { return OutlineFontButton.FontName; }
         set { OutlineFontButton.FontName = value; }
      }

      public bool TreeLinesEnabled
      {
         get { return TreeLinesEnabledCheckBox.Active; }
         set { TreeLinesEnabledCheckBox.Active = value; }
      }

      public bool PangoEnabled
      {
         get { return PangoEnabledCheckBox.Active; }
         set { PangoEnabledCheckBox.Active = value; }
      }

      public bool ColorBarsEnabled
      {
         get { return ColorBarsEnabledCheckBox.Active; }
         set { ColorBarsEnabledCheckBox.Active = value; }
      }

      public int WrapMargin
      {
         get { return Convert.ToInt32(WrapMarginEntry.Text); }
         set { WrapMarginEntry.Text = value.ToString(); }
      }
   }
}

