// generated from file './/guvnor.dsp' by dsp2cc:
// Code generated with Faust 0.9.73 (http://faust.grame.fr)


namespace guvnor {

template <int tab_size>
struct table1d_imp { // 1-dimensional clipping table
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
};

static table1d_imp<100> clip __rt_data = {
	0.005,0.795235013262,101.97,100, {
	0.00548195523036,0.016445865691,0.0274097761516,0.0383736866119,0.0493375970718,
	0.060301507531,0.0712654179894,0.0822293284464,0.0931932389016,0.104157149354,
	0.115121059803,0.126084970245,0.13704888068,0.148012791103,0.158976701508,
	0.169940611889,0.180904522235,0.19186843253,0.202832342751,0.213796252866,
	0.224760162828,0.23572407257,0.246687981995,0.257651890962,0.26861579927,
	0.279579706628,0.290543612617,0.301507516632,0.312471417804,0.323435314878,
	0.334399206045,0.3453630887,0.356326959087,0.367290811794,0.378254639021,
	0.389218429528,0.400182167115,0.411145828437,0.422109379849,0.433072772871,
	0.444035937638,0.454998773485,0.465961135365,0.476922814321,0.48788350936,
	0.498842787024,0.509800023297,0.520754320256,0.531704386732,0.542648367922,
	0.55358360312,0.564506283341,0.575410971703,0.586289940184,0.597132269761,
	0.607922663898,0.618639951041,0.629255322196,0.639730493837,0.650016225239,
	0.660051925492,0.669767316942,0.679086989359,0.687937882416,0.696258343947,
	0.704006183628,0.711163121782,0.717734492237,0.723745022743,0.72923269117,
	0.734242606851,0.738822090117,0.743017303269,0.74687127245,0.750422944114,
	0.7537069184,0.756753578753,0.759589425229,0.762237491115,0.764717773458,
	0.767047640962,0.769242202516,0.771314630963,0.773276442704,0.775137736666,
	0.776907397287,0.778593266396,0.780202288563,0.781740634041,0.783213802858,
	0.784626713121,0.785983776084,0.787288960129,0.788545845459,0.789757670968,
	0.790927374556,0.792057627879,0.793150866414,0.794209315546,0.795235013262
	}
};

class Dsp: public PluginLV2 {
private:
	uint32_t fSamplingFreq;
	FAUSTFLOAT 	fslider0;
	FAUSTFLOAT	*fslider0_;
	double 	fRec0[2];
	int 	iConst0;
	double 	fConst1;
	double 	fConst2;
	double 	fConst3;
	double 	fConst4;
	double 	fConst5;
	double 	fConst6;
	double 	fConst7;
	double 	fConst8;
	double 	fConst9;
	double 	fConst10;
	double 	fConst11;
	double 	fConst12;
	double 	fConst13;
	FAUSTFLOAT 	fslider1;
	FAUSTFLOAT	*fslider1_;
	double 	fRec3[2];
	double 	fConst14;
	double 	fConst15;
	double 	fConst16;
	double 	fConst17;
	double 	fConst18;
	double 	fConst19;
	double 	fConst20;
	FAUSTFLOAT 	fslider2;
	FAUSTFLOAT	*fslider2_;
	double 	fRec4[2];
	double 	fConst21;
	double 	fConst22;
	double 	fConst23;
	double 	fConst24;
	double 	fConst25;
	double 	fConst26;
	double 	fConst27;
	double 	fConst28;
	double 	fConst29;
	double 	fConst30;
	double 	fConst31;
	double 	fConst32;
	double 	fConst33;
	double 	fConst34;
	double 	fConst35;
	double 	fConst36;
	double 	fConst37;
	double 	fConst38;
	double 	fConst39;
	double 	fConst40;
	FAUSTFLOAT 	fslider3;
	FAUSTFLOAT	*fslider3_;
	double 	fRec5[2];
	double 	fConst41;
	double 	fConst42;
	double 	fConst43;
	double 	fConst44;
	double 	fConst45;
	double 	fConst46;
	double 	fConst47;
	double 	fConst48;
	double 	fConst49;
	double 	fConst50;
	double 	fConst51;
	double 	fConst52;
	double 	fConst53;
	double 	fConst54;
	double 	fConst55;
	double 	fConst56;
	double 	fConst57;
	double 	fConst58;
	double 	fConst59;
	double 	fConst60;
	double 	fConst61;
	double 	fConst62;
	double 	fConst63;
	double 	fConst64;
	double 	fConst65;
	double 	fConst66;
	double 	fConst67;
	double 	fConst68;
	double 	fConst69;
	double 	fConst70;
	double 	fConst71;
	double 	fConst72;
	double 	fConst73;
	double 	fConst74;
	double 	fConst75;
	double 	fConst76;
	double 	fConst77;
	double 	fConst78;
	double 	fConst79;
	double 	fConst80;
	double 	fConst81;
	double 	fConst82;
	double 	fConst83;
	double 	fConst84;
	double 	fConst85;
	double 	fConst86;
	double 	fConst87;
	double 	fConst88;
	double 	fConst89;
	double 	fConst90;
	double 	fConst91;
	double 	fConst92;
	FAUSTFLOAT 	fslider4;
	FAUSTFLOAT	*fslider4_;
	double 	fRec6[2];
	double 	fConst93;
	double 	fConst94;
	double 	fConst95;
	double 	fConst96;
	double 	fConst97;
	double 	fConst98;
	double 	fConst99;
	double 	fConst100;
	double 	fConst101;
	double 	fConst102;
	double 	fConst103;
	double 	fConst104;
	double 	fConst105;
	double 	fConst106;
	double 	fConst107;
	double 	fConst108;
	double 	fConst109;
	double 	fConst110;
	double 	fConst111;
	double 	fConst112;
	double 	fConst113;
	double 	fConst114;
	double 	fConst115;
	double 	fConst116;
	double 	fConst117;
	double 	fConst118;
	double 	fConst119;
	double 	fConst120;
	double 	fConst121;
	double 	fConst122;
	double 	fConst123;
	double 	fConst124;
	double 	fConst125;
	double 	fConst126;
	double 	fConst127;
	double 	fConst128;
	double 	fConst129;
	double 	fConst130;
	double 	fConst131;
	double 	fConst132;
	double 	fConst133;
	double 	fConst134;
	double 	fConst135;
	double 	fConst136;
	double 	fConst137;
	double 	fConst138;
	double 	fConst139;
	double 	fConst140;
	double 	fConst141;
	double 	fConst142;
	double 	fConst143;
	double 	fConst144;
	double 	fConst145;
	double 	fConst146;
	double 	fConst147;
	double 	fConst148;
	double 	fConst149;
	double 	fConst150;
	double 	fConst151;
	double 	fConst152;
	double 	fConst153;
	double 	fConst154;
	double 	fConst155;
	double 	fConst156;
	double 	fConst157;
	double 	fConst158;
	double 	fConst159;
	double 	fConst160;
	double 	fConst161;
	double 	fConst162;
	double 	fConst163;
	double 	fConst164;
	double 	fConst165;
	double 	fConst166;
	double 	fConst167;
	double 	fConst168;
	double 	fConst169;
	double 	fConst170;
	double 	fConst171;
	double 	fConst172;
	double 	fConst173;
	double 	fConst174;
	double 	fConst175;
	double 	fConst176;
	double 	fConst177;
	double 	fConst178;
	double 	fConst179;
	double 	fConst180;
	double 	fConst181;
	double 	fConst182;
	double 	fConst183;
	double 	fConst184;
	double 	fConst185;
	double 	fConst186;
	double 	fConst187;
	double 	fConst188;
	double 	fConst189;
	double 	fConst190;
	double 	fConst191;
	double 	fConst192;
	double 	fConst193;
	double 	fConst194;
	double 	fConst195;
	double 	fConst196;
	double 	fConst197;
	double 	fConst198;
	double 	fConst199;
	double 	fConst200;
	double 	fConst201;
	double 	fConst202;
	double 	fConst203;
	double 	fConst204;
	double 	fConst205;
	double 	fConst206;
	double 	fConst207;
	double 	fConst208;
	double 	fConst209;
	double 	fConst210;
	double 	fConst211;
	double 	fConst212;
	double 	fConst213;
	double 	fConst214;
	double 	fConst215;
	double 	fConst216;
	double 	fConst217;
	double 	fConst218;
	double 	fConst219;
	double 	fConst220;
	double 	fConst221;
	double 	fConst222;
	double 	fConst223;
	double 	fConst224;
	double 	fConst225;
	double 	fConst226;
	double 	fConst227;
	double 	fConst228;
	double 	fConst229;
	double 	fConst230;
	double 	fConst231;
	double 	fConst232;
	double 	fConst233;
	double 	fConst234;
	double 	fConst235;
	double 	fConst236;
	double 	fConst237;
	double 	fConst238;
	double 	fConst239;
	double 	fConst240;
	double 	fConst241;
	double 	fConst242;
	double 	fConst243;
	double 	fConst244;
	double 	fConst245;
	double 	fConst246;
	double 	fConst247;
	double 	fConst248;
	double 	fConst249;
	double 	fConst250;
	double 	fConst251;
	double 	fConst252;
	double 	fConst253;
	double 	fConst254;
	double 	fConst255;
	double 	fConst256;
	double 	fConst257;
	double 	fConst258;
	double 	fConst259;
	double 	fConst260;
	double 	fConst261;
	double 	fConst262;
	double 	fConst263;
	double 	fConst264;
	double 	fConst265;
	double 	fConst266;
	double 	fConst267;
	double 	fConst268;
	double 	fConst269;
	double 	fConst270;
	double 	fConst271;
	double 	fConst272;
	double 	fConst273;
	double 	fConst274;
	double 	fConst275;
	double 	fConst276;
	double 	fConst277;
	double 	fConst278;
	double 	fConst279;
	double 	fConst280;
	double 	fConst281;
	double 	fConst282;
	double 	fConst283;
	double 	fConst284;
	double 	fConst285;
	double 	fConst286;
	double 	fConst287;
	double 	fConst288;
	double 	fConst289;
	double 	fConst290;
	double 	fConst291;
	double 	fConst292;
	double 	fConst293;
	double 	fConst294;
	double 	fConst295;
	double 	fConst296;
	double 	fConst297;
	double 	fConst298;
	double 	fConst299;
	double 	fConst300;
	double 	fConst301;
	double 	fConst302;
	double 	fConst303;
	double 	fConst304;
	double 	fConst305;
	double 	fConst306;
	double 	fConst307;
	double 	fConst308;
	double 	fConst309;
	double 	fConst310;
	double 	fConst311;
	double 	fConst312;
	double 	fConst313;
	double 	fConst314;
	double 	fConst315;
	double 	fConst316;
	double 	fConst317;
	double 	fConst318;
	double 	fConst319;
	double 	fConst320;
	double 	fConst321;
	double 	fConst322;
	double 	fConst323;
	double 	fConst324;
	double 	fConst325;
	double 	fConst326;
	double 	fConst327;
	double 	fConst328;
	double 	fConst329;
	double 	fConst330;
	double 	fConst331;
	double 	fConst332;
	double 	fConst333;
	double 	fConst334;
	double 	fConst335;
	double 	fConst336;
	double 	fConst337;
	double 	fConst338;
	double 	fConst339;
	double 	fConst340;
	double 	fConst341;
	double 	fConst342;
	double 	fConst343;
	double 	fConst344;
	double 	fConst345;
	double 	fConst346;
	double 	fConst347;
	double 	fConst348;
	double 	fConst349;
	double 	fConst350;
	double 	fConst351;
	double 	fConst352;
	double 	fConst353;
	double 	fConst354;
	double 	fConst355;
	double 	fConst356;
	double 	fConst357;
	double 	fConst358;
	double 	fConst359;
	double 	fConst360;
	double 	fConst361;
	double 	fConst362;
	double 	fConst363;
	double 	fConst364;
	double 	fConst365;
	double 	fConst366;
	double 	fConst367;
	double 	fConst368;
	double 	fConst369;
	double 	fConst370;
	double 	fConst371;
	double 	fConst372;
	double 	fConst373;
	double 	fConst374;
	double 	fConst375;
	double 	fConst376;
	double 	fConst377;
	double 	fConst378;
	double 	fConst379;
	double 	fConst380;
	double 	fConst381;
	double 	fConst382;
	double 	fConst383;
	double 	fConst384;
	double 	fConst385;
	double 	fConst386;
	double 	fConst387;
	double 	fConst388;
	double 	fConst389;
	double 	fConst390;
	double 	fConst391;
	double 	fConst392;
	double 	fConst393;
	double 	fConst394;
	double 	fConst395;
	double 	fConst396;
	double 	fConst397;
	double 	fConst398;
	double 	fConst399;
	double 	fConst400;
	double 	fConst401;
	double 	fConst402;
	double 	fConst403;
	double 	fConst404;
	double 	fConst405;
	double 	fConst406;
	double 	fConst407;
	double 	fConst408;
	double 	fConst409;
	double 	fConst410;
	double 	fConst411;
	double 	fConst412;
	double 	fConst413;
	double 	fConst414;
	double 	fConst415;
	double 	fConst416;
	double 	fConst417;
	double 	fConst418;
	double 	fConst419;
	double 	fConst420;
	double 	fConst421;
	double 	fConst422;
	double 	fConst423;
	double 	fConst424;
	double 	fConst425;
	double 	fConst426;
	double 	fConst427;
	double 	fConst428;
	double 	fConst429;
	double 	fConst430;
	double 	fConst431;
	double 	fConst432;
	double 	fConst433;
	double 	fConst434;
	double 	fConst435;
	double 	fConst436;
	double 	fConst437;
	double 	fConst438;
	double 	fConst439;
	double 	fConst440;
	double 	fConst441;
	double 	fConst442;
	double 	fConst443;
	double 	fConst444;
	double 	fConst445;
	double 	fConst446;
	double 	fConst447;
	double 	fConst448;
	double 	fConst449;
	double 	fConst450;
	double 	fConst451;
	double 	fConst452;
	double 	fConst453;
	double 	fConst454;
	double 	fConst455;
	double 	fConst456;
	double 	fConst457;
	double 	fConst458;
	double 	fConst459;
	double 	fConst460;
	double 	fConst461;
	double 	fConst462;
	double 	fConst463;
	double 	fConst464;
	double 	fConst465;
	double 	fConst466;
	double 	fConst467;
	double 	fConst468;
	double 	fConst469;
	double 	fConst470;
	double 	fConst471;
	double 	fConst472;
	double 	fConst473;
	double 	fConst474;
	double 	fConst475;
	double 	fConst476;
	double 	fConst477;
	double 	fConst478;
	double 	fConst479;
	double 	fConst480;
	double 	fConst481;
	double 	fConst482;
	double 	fConst483;
	double 	fConst484;
	double 	fConst485;
	double 	fConst486;
	double 	fConst487;
	double 	fConst488;
	double 	fConst489;
	double 	fConst490;
	double 	fConst491;
	double 	fConst492;
	double 	fConst493;
	double 	fConst494;
	double 	fConst495;
	double 	fConst496;
	double 	fConst497;
	double 	fConst498;
	double 	fConst499;
	double 	fConst500;
	double 	fConst501;
	double 	fConst502;
	double 	fConst503;
	double 	fConst504;
	double 	fConst505;
	double 	fConst506;
	double 	fConst507;
	double 	fConst508;
	double 	fConst509;
	double 	fConst510;
	double 	fConst511;
	double 	fConst512;
	double 	fConst513;
	double 	fConst514;
	double 	fConst515;
	double 	fConst516;
	double 	fConst517;
	double 	fConst518;
	double 	fConst519;
	double 	fConst520;
	double 	fConst521;
	double 	fConst522;
	double 	fConst523;
	double 	fConst524;
	double 	fConst525;
	double 	fConst526;
	double 	fConst527;
	double 	fConst528;
	double 	fConst529;
	double 	fConst530;
	double 	fConst531;
	double 	fConst532;
	double 	fConst533;
	double 	fConst534;
	double 	fConst535;
	double 	fConst536;
	double 	fConst537;
	double 	fConst538;
	double 	fConst539;
	double 	fConst540;
	double 	fConst541;
	double 	fConst542;
	double 	fConst543;
	double 	fConst544;
	double 	fVec0[2];
	double 	fConst545;
	double 	fRec10[2];
	double 	fRec9[3];
	double 	fConst546;
	double 	fVec1[2];
	double 	fRec8[2];
	double 	fRec7[7];
	double 	fConst547;
	double 	fConst548;
	double 	fConst549;
	double 	fConst550;
	double 	fConst551;
	double 	fConst552;
	double 	fConst553;
	double 	fConst554;
	double 	fConst555;
	double 	fConst556;
	double 	fConst557;
	double 	fConst558;
	double 	fConst559;
	double 	fConst560;
	double 	fConst561;
	double 	fConst562;
	double 	fConst563;
	double 	fConst564;
	double 	fConst565;
	double 	fConst566;
	double 	fConst567;
	double 	fConst568;
	double 	fConst569;
	double 	fConst570;
	double 	fConst571;
	double 	fConst572;
	double 	fConst573;
	double 	fConst574;
	double 	fConst575;
	double 	fConst576;
	double 	fConst577;
	double 	fConst578;
	double 	fConst579;
	double 	fConst580;
	double 	fConst581;
	double 	fConst582;
	double 	fConst583;
	double 	fConst584;
	double 	fConst585;
	double 	fConst586;
	double 	fConst587;
	double 	fConst588;
	double 	fConst589;
	double 	fConst590;
	double 	fConst591;
	double 	fConst592;
	double 	fConst593;
	double 	fConst594;
	double 	fConst595;
	double 	fConst596;
	double 	fConst597;
	double 	fConst598;
	double 	fConst599;
	double 	fConst600;
	double 	fConst601;
	double 	fConst602;
	double 	fConst603;
	double 	fConst604;
	double 	fConst605;
	double 	fConst606;
	double 	fConst607;
	double 	fConst608;
	double 	fConst609;
	double 	fConst610;
	double 	fConst611;
	double 	fConst612;
	double 	fConst613;
	double 	fConst614;
	double 	fConst615;
	double 	fConst616;
	double 	fConst617;
	double 	fConst618;
	double 	fConst619;
	double 	fConst620;
	double 	fConst621;
	double 	fConst622;
	double 	fConst623;
	double 	fConst624;
	double 	fConst625;
	double 	fConst626;
	double 	fConst627;
	double 	fConst628;
	double 	fConst629;
	double 	fConst630;
	double 	fConst631;
	double 	fConst632;
	double 	fConst633;
	double 	fConst634;
	double 	fConst635;
	double 	fConst636;
	double 	fConst637;
	double 	fConst638;
	double 	fConst639;
	double 	fConst640;
	double 	fConst641;
	double 	fConst642;
	double 	fConst643;
	double 	fConst644;
	double 	fConst645;
	double 	fConst646;
	double 	fConst647;
	double 	fConst648;
	double 	fConst649;
	double 	fConst650;
	double 	fConst651;
	double 	fConst652;
	double 	fConst653;
	double 	fConst654;
	double 	fConst655;
	double 	fConst656;
	double 	fConst657;
	double 	fVec2[2];
	double 	fRec2[2];
	double 	fRec1[3];
	void connect(uint32_t port,void* data);
	void clear_state_f();
	void init(uint32_t samplingFreq);
	void compute(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0);

	static void clear_state_f_static(PluginLV2*);
	static void init_static(uint32_t samplingFreq, PluginLV2*);
	static double symclip(double x);
	static void compute_static(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0, PluginLV2*);
	static void del_instance(PluginLV2 *p);
	static void connect_static(uint32_t port,void* data, PluginLV2 *p);
public:
	Dsp();
	~Dsp();
};



Dsp::Dsp()
	: PluginLV2() {
	version = PLUGINLV2_VERSION;
	id = "guvnor";
	name = N_("Guvnor");
	mono_audio = compute_static;
	stereo_audio = 0;
	set_samplerate = init_static;
	activate_plugin = 0;
	connect_ports = connect_static;
	clear_state = clear_state_f_static;
	delete_instance = del_instance;
}

Dsp::~Dsp() {
}

inline void Dsp::clear_state_f()
{
	for (int i=0; i<2; i++) fRec0[i] = 0;
	for (int i=0; i<2; i++) fRec3[i] = 0;
	for (int i=0; i<2; i++) fRec4[i] = 0;
	for (int i=0; i<2; i++) fRec5[i] = 0;
	for (int i=0; i<2; i++) fRec6[i] = 0;
	for (int i=0; i<2; i++) fVec0[i] = 0;
	for (int i=0; i<2; i++) fRec10[i] = 0;
	for (int i=0; i<3; i++) fRec9[i] = 0;
	for (int i=0; i<2; i++) fVec1[i] = 0;
	for (int i=0; i<2; i++) fRec8[i] = 0;
	for (int i=0; i<7; i++) fRec7[i] = 0;
	for (int i=0; i<2; i++) fVec2[i] = 0;
	for (int i=0; i<2; i++) fRec2[i] = 0;
	for (int i=0; i<3; i++) fRec1[i] = 0;
}

void Dsp::clear_state_f_static(PluginLV2 *p)
{
	static_cast<Dsp*>(p)->clear_state_f();
}

inline void Dsp::init(uint32_t samplingFreq)
{
	fSamplingFreq = samplingFreq;
	iConst0 = min(192000, max(1, fSamplingFreq));
	fConst1 = double(iConst0);
	fConst2 = (4.33054407650898e-10 * fConst1);
	fConst3 = (1.22474303201741e-06 + (fConst1 * (fConst2 - 4.66962506103765e-08)));
	fConst4 = faustpower<2>(fConst1);
	fConst5 = (2.44948606403482e-06 - (8.66108815301797e-10 * fConst4));
	fConst6 = (1.22474303201741e-06 + (fConst1 * (4.66962506103765e-08 + fConst2)));
	fConst7 = (1.0 / fConst6);
	fConst8 = (470.33999466970965 / double(iConst0));
	fConst9 = (1 - fConst8);
	fConst10 = (1.6450517805097e-22 * fConst1);
	fConst11 = (2.62765894811075e-10 + (fConst1 * (9.98989964774112e-14 + (fConst1 * (7.86071004722922e-18 + fConst10)))));
	fConst12 = (1.54634867367912e-26 * fConst1);
	fConst13 = (1.55277717116775e-11 + (fConst1 * (2.46999941122411e-14 + (fConst1 * (9.39050566887665e-18 + (fConst1 * (7.38906744439547e-22 + fConst12)))))));
	fConst14 = (2.10517764981068e-29 * fConst1);
	fConst15 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (8.14190622320712e-25 + fConst14))) - 7.97274651643249e-21)) - 1.36644391062762e-17));
	fConst16 = (2.12622942630879e-29 * fConst1);
	fConst17 = (6.83221955313812e-14 + (fConst1 * (6.63062014766489e-17 + (fConst1 * (1.90114697943801e-20 + (fConst1 * (1.19073861726079e-24 + fConst16)))))));
	fConst18 = (fConst1 * (1.3433140006821e-17 + (fConst1 * (7.93489352919472e-21 + (fConst1 * (8.12642697578205e-25 + fConst14))))));
	fConst19 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.18917521327086e-24 + fConst16))) - 1.89461495942761e-20)) - 6.56520253505552e-17)) - 6.71657000341052e-14);
	fConst20 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (7.37769723355959e-22 + fConst12))) - 9.35234455241899e-18)) - 2.45029450717437e-14)) - 1.5264931825933e-11);
	fConst21 = (2.23955069128796e-25 * fConst1);
	fConst22 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (8.66160236511396e-21 + fConst21))) - 8.48164523024733e-17)) - 1.45366373471024e-13));
	fConst23 = (2.26194619820084e-25 * fConst1);
	fConst24 = (7.26831867355119e-10 + (fConst1 * (7.0538512209201e-13 + (fConst1 * (2.02249678663618e-16 + (fConst1 * (1.2667432098519e-20 + fConst23)))))));
	fConst25 = (1.6450517805097e-23 * fConst1);
	fConst26 = (2.45011082038024e-11 + (fConst1 * (9.43976329166227e-15 + (fConst1 * (7.60669469876817e-19 + fConst25)))));
	fConst27 = (2.10517764981068e-30 * fConst1);
	fConst28 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (7.81684202728047e-26 + fConst27))) - 7.56481497006641e-22)) - 1.3433140006821e-18));
	fConst29 = (2.12622942630879e-30 * fConst1);
	fConst30 = (6.71657000341052e-15 + (fConst1 * (6.25116952694904e-18 + (fConst1 * (1.80305965896787e-21 + (fConst1 * (1.1579071334722e-25 + fConst29)))))));
	fConst31 = (1.54634867367912e-27 * fConst1);
	fConst32 = (1.5264931825933e-12 + (fConst1 * (2.30310417115742e-15 + (fConst1 * (8.87337749416253e-19 + (fConst1 * (7.15029301684208e-23 + fConst31)))))));
	fConst33 = (fConst1 * (1.07465120054568e-22 + (fConst1 * (5.34016243926791e-26 + fConst27))));
	fConst34 = ((fConst1 * ((fConst1 * (0 - (9.07762495082928e-26 + fConst29))) - 1.043068198127e-21)) - 1.88063960095495e-18);
	fConst35 = ((fConst1 * ((fConst1 * (0 - (5.33105928310193e-23 + fConst31))) - 4.84128424874367e-19)) - 4.27418091126124e-16);
	fConst36 = (2.23955069128796e-26 * fConst1);
	fConst37 = (fConst1 * (1.14324595802732e-18 + (fConst1 * (5.6810238715616e-22 + fConst36))));
	fConst38 = (2.26194619820084e-26 * fConst1);
	fConst39 = ((fConst1 * ((fConst1 * (0 - (9.65704782003115e-22 + fConst38))) - 1.10964701928404e-17)) - 2.00068042654782e-14);
	fConst40 = ((fConst1 * ((fConst1 * (0 - (5.6713396628744e-19 + fConst25))) - 5.15030239228049e-15)) - 4.54700096942685e-12);
	fConst41 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (8.31578939072391e-22 + fConst36))) - 8.04767550007065e-18)) - 1.42905744753415e-14));
	fConst42 = (7.14528723767077e-11 + (fConst1 * (6.65018034781812e-14 + (fConst1 * (1.91814857337008e-17 + (fConst1 * (1.23181609943851e-21 + fConst38)))))));
	fConst43 = (4.11392373590659e-09 + (fConst1 * (1.86995242795741e-12 + (fConst1 * (2.6506307935329e-16 + (fConst1 * (1.36117518832741e-20 + fConst23)))))));
	fConst44 = (2.28349583995258e-10 + (fConst1 * (3.8670883117522e-13 + (fConst1 * (1.75775528227997e-16 + (fConst1 * (2.49159294592092e-20 + (fConst1 * (1.27950467702777e-24 + fConst16)))))))));
	fConst45 = (8.12891788916079e-28 * fConst1);
	fConst46 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (2.02873486734413e-23 + fConst45))) - 1.37903061105669e-19)) - 2.00947633915827e-16));
	fConst47 = (8.2102070680524e-28 * fConst1);
	fConst48 = (1.00473816957914e-12 + (fConst1 * (1.07837514221197e-15 + (fConst1 * (3.60237280890823e-19 + (fConst1 * (3.47158284662071e-23 + fConst47)))))));
	fConst49 = (fConst1 * (1.97546176570898e-16 + (fConst1 * (1.36883801329732e-19 + (fConst1 * (2.0227577218374e-23 + fConst45))))));
	fConst50 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (3.46554592965891e-23 + fConst47))) - 3.58161828053448e-19)) - 1.06644191406898e-15)) - 9.87730882854489e-13);
	fConst51 = ((fConst1 * ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.27794127303783e-24 + fConst16))) - 2.48440823429459e-20)) - 1.74864212392649e-16)) - 3.83285371396416e-13)) - 2.24484291557838e-10);
	fConst52 = (8.64778498846893e-24 * fConst1);
	fConst53 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (2.15822858228099e-19 + fConst52))) - 1.46705384154967e-15)) - 2.13774078633859e-12));
	fConst54 = (8.73426283835362e-24 * fConst1);
	fConst55 = (1.06887039316929e-08 + (fConst1 * (1.14720759809784e-11 + (fConst1 * (3.83231149883854e-15 + (fConst1 * (3.69317324108586e-19 + fConst54)))))));
	fConst56 = (3.84723121007303e-10 + (fConst1 * (1.75400821768783e-13 + (fConst1 * (2.53170117182572e-17 + (fConst1 * (1.32624807791401e-21 + fConst38)))))));
	fConst57 = (8.12891788916079e-29 * fConst1);
	fConst58 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (1.90321481170268e-24 + fConst57))) - 1.31441469577845e-20)) - 1.97546176570898e-17));
	fConst59 = (8.2102070680524e-29 * fConst1);
	fConst60 = (9.87730882854489e-14 + (fConst1 * (1.02026058934744e-16 + (fConst1 * (3.38804134303455e-20 + (fConst1 * (3.34480759042284e-24 + fConst59)))))));
	fConst61 = (2.24484291557838e-11 + (fConst1 * (3.61639733746865e-14 + (fConst1 * (1.64876772462656e-17 + (fConst1 * (2.37979910151618e-21 + (fConst1 * (1.24667319323917e-25 + fConst29)))))))));
	fConst62 = (fConst1 * (1.58036941256718e-21 + (fConst1 * (9.46871530624937e-25 + fConst57))));
	fConst63 = ((fConst1 * ((fConst1 * (0 - (2.37890087653433e-24 + fConst59))) - 1.81664248926293e-20)) - 2.76564647199257e-17);
	fConst64 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (9.96528554849904e-26 + fConst29))) - 1.51537698212592e-21)) - 7.76207808829881e-18)) - 6.28556016361947e-15);
	fConst65 = (8.64778498846893e-25 * fConst1);
	fConst66 = (fConst1 * (1.68124405592253e-17 + (fConst1 * (1.0073101389627e-20 + fConst65))));
	fConst67 = (8.73426283835362e-25 * fConst1);
	fConst68 = ((fConst1 * ((fConst1 * (0 - (2.53074561333439e-20 + fConst67))) - 1.9325983928329e-16)) - 2.94217709786443e-13);
	fConst69 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.06013676047862e-21 + fConst38))) - 1.61210317247438e-17)) - 8.25752988116895e-14)) - 6.68676613151008e-11);
	fConst70 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (2.02469660819434e-20 + fConst65))) - 1.39831350614729e-16)) - 2.10155506990317e-13));
	fConst71 = (1.05077753495158e-09 + (fConst1 * (1.08538360568876e-12 + (fConst1 * (3.60429930110059e-16 + (fConst1 * (3.55830594725834e-20 + fConst67)))))));
	fConst72 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.3445432309877e-20 + fConst23))) - 2.58723214045085e-16)) - 1.81188143839367e-12)) - 3.83038460817312e-09);
	fConst73 = ((fConst1 * ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.26387063712844e-24 + fConst16))) - 2.4319982120238e-20)) - 1.70316855209005e-16)) - 3.60056153168273e-13)) - 1.89696659621061e-10);
	fConst74 = (fConst1 * (1.66933060466533e-16 + (fConst1 * (1.34382552753667e-19 + (fConst1 * (2.02234012753566e-23 + fConst45))))));
	fConst75 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (3.46512415941416e-23 + fConst47))) - 3.55949469174446e-19)) - 9.92403307818879e-16)) - 8.34665302332667e-13);
	fConst76 = (fConst1 * ((fConst1 * ((fConst1 * (0 - (2.01636298202893e-23 + fConst45))) - 1.33363292977731e-19)) - 1.63531603121604e-16));
	fConst77 = (8.1765801560802e-13 + (fConst1 * (9.80470079675889e-16 + (fConst1 * (3.53874016337071e-19 + (fConst1 * (3.45908724245236e-23 + fConst47)))))));
	fConst78 = (1.85831367183641e-10 + (fConst1 * (3.56632693389469e-13 + (fConst1 * (1.69405539373657e-16 + (fConst1 * (2.42481350039747e-20 + (fConst1 * (1.2623072331385e-24 + fConst16)))))))));
	fConst79 = (fConst1 * (1.7758836219844e-12 + (fConst1 * (1.42960162503901e-15 + (fConst1 * (2.15142566759113e-19 + fConst52))))));
	fConst80 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (3.68630229724911e-19 + fConst54))) - 3.78669648057921e-15)) - 1.05574819980732e-11)) - 8.87941810992199e-09);
	fConst81 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.3096161205743e-21 + fConst38))) - 2.46830251874368e-17)) - 1.69593722812409e-13)) - 3.56369208233956e-10);
	fConst82 = (fConst1 * (1.63531603121604e-17 + (fConst1 * (1.27920961225844e-20 + (fConst1 * (1.89682007189421e-24 + fConst57))))));
	fConst83 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (3.33834890321629e-24 + fConst59))) - 3.34129341401451e-20)) - 9.34288754954348e-17)) - 8.1765801560802e-14);
	fConst84 = ((fConst1 * ((fConst1 * ((fConst1 * ((fConst1 * (0 - (1.23103915333984e-25 + fConst29))) - 2.32020436761906e-21)) - 1.59418099443664e-17)) - 3.34987055739919e-14)) - 1.85831367183641e-11);
	fConst85 = (fConst1 * ((fConst1 * (0 - (9.4047679081647e-25 + fConst57))) - 1.30825282497283e-21));
	fConst86 = (2.28944244370246e-17 + (fConst1 * (1.77796791925108e-20 + (fConst1 * (2.37244218932777e-24 + fConst59)))));
	fConst87 = (5.20327828114195e-15 + (fConst1 * (7.47499984566977e-18 + (fConst1 * (1.47532479810296e-21 + (fConst1 * (9.80894514950575e-26 + fConst29)))))));
	fConst88 = (fConst1 * ((fConst1 * (0 - (1.00050722427284e-20 + fConst65))) - 1.39175832443918e-17));
	fConst89 = (2.43557706776857e-13 + (fConst1 * (1.89145523324583e-16 + (fConst1 * (2.52387466949763e-20 + fConst67)))));
	fConst90 = (5.53540242674675e-11 + (fConst1 * (7.95212749539338e-14 + (fConst1 * (1.56949446606698e-17 + (fConst1 * (1.04350480313891e-21 + fConst38)))))));
	fConst91 = (fConst1 * (1.73969790554898e-13 + (fConst1 * (1.36086128963663e-16 + (fConst1 * (2.01789369350448e-20 + fConst65))))));
	fConst92 = ((fConst1 * ((fConst1 * ((fConst1 * (0 - (3.55143500342159e-20 + fConst67))) - 3.55456746171757e-16)) - 9.93924207398243e-13)) - 8.6984895277449e-10);
	fConst93 = (1.2095968974336e-19 * fConst1);
	fConst94 = ((fConst1 * (3.22307947619052e-15 - fConst93)) - 6.70327744617729e-11);
	fConst95 = (1.64672844947644e-22 * fConst1);
	fConst96 = (fConst1 * ((fConst1 * (1.14324595802732e-17 - fConst95)) - 1.18299457577331e-13));
	fConst97 = (1.66319573397121e-22 * fConst1);
	fConst98 = ((fConst1 * (3.01805576171286e-13 + (fConst1 * (fConst97 - 1.37897418917422e-17)))) - 5.91497287886653e-10);
	fConst99 = (fConst1 * (1.96850297408678e-18 + (fConst1 * (fConst21 - 5.6810238715616e-21))));
	fConst100 = (1.67038834099191e-14 + (fConst1 * ((fConst1 * (6.8576094559212e-21 - fConst23)) - 3.83051750844075e-17)));
	fConst101 = (2.46493051606583e-11 + (fConst1 * (1.44172194219261e-14 + (fConst1 * (fConst10 - 3.63538448897625e-18)))));
	fConst102 = ((fConst1 * (1.88980093869201e-13 + (fConst1 * (fConst97 - 8.10272080703706e-18)))) - 1.27023251801883e-09);
	fConst103 = (2.63843976113883e-20 * fConst1);
	fConst104 = (fConst1 * ((fConst1 * (4.18446057825885e-16 - fConst103)) - 1.73969790554898e-12));
	fConst105 = (2.96521014143057e-20 * fConst1);
	fConst106 = ((fConst1 * (5.68992555780471e-12 + (fConst1 * (fConst105 - 8.39473270640275e-16)))) - 8.6984895277449e-09);
	fConst107 = (fConst1 * (2.8948573148335e-17 + (fConst1 * (fConst52 - 8.07052817175794e-20))));
	fConst108 = (2.45645344263516e-13 + (fConst1 * ((fConst1 * (1.40410322077696e-19 - fConst54)) - 5.49115463390831e-16)));
	fConst109 = (3.62489781774387e-10 + (fConst1 * (1.51900299233814e-13 + (fConst1 * ((fConst1 * (7.80192924067626e-21 - fConst23)) - 7.39135770084066e-17)))));
	fConst110 = (fConst1 * (8.11228092149111e-20 - fConst52));
	fConst111 = (5.21965041997671e-16 + (fConst1 * (fConst54 - 1.40996697694949e-19)));
	fConst112 = ((fConst1 * ((fConst1 * (7.19631162831439e-17 + (fConst1 * (fConst23 - 7.63560966727914e-21)))) - 1.4279440408746e-13)) - 3.95385887624768e-10);
	fConst113 = (1.25463849861091e-09 + (fConst1 * ((fConst1 * (7.85072145340506e-18 - fConst97)) - 1.81463776514583e-13)));
	fConst114 = (2.52865786450706e-20 * fConst1);
	fConst115 = (fConst1 * (1.73969790554898e-12 + (fConst1 * (fConst114 - 4.04723320746915e-16))));
	fConst116 = (2.83786314133773e-20 * fConst1);
	fConst117 = (8.6984895277449e-09 + (fConst1 * ((fConst1 * (8.06401474279956e-16 - fConst116)) - 5.62131187240986e-12)));
	fConst118 = ((fConst1 * (9.98989964774112e-14 + (fConst1 * (fConst10 - 7.86071004722922e-18)))) - 2.62765894811075e-10);
	fConst119 = ((fConst1 * (2.46999941122411e-14 + (fConst1 * ((fConst1 * (7.38906744439547e-22 - fConst12)) - 9.39050566887665e-18)))) - 1.55277717116775e-11);
	fConst120 = (fConst1 * (1.36644391062762e-17 + (fConst1 * ((fConst1 * (8.14190622320712e-25 - fConst14)) - 7.97274651643249e-21))));
	fConst121 = (6.83221955313812e-14 + (fConst1 * ((fConst1 * (1.90114697943801e-20 + (fConst1 * (fConst16 - 1.19073861726079e-24)))) - 6.63062014766489e-17)));
	fConst122 = (fConst1 * ((fConst1 * (7.93489352919472e-21 + (fConst1 * (fConst14 - 8.12642697578205e-25)))) - 1.3433140006821e-17));
	fConst123 = ((fConst1 * (6.56520253505552e-17 + (fConst1 * ((fConst1 * (1.18917521327086e-24 - fConst16)) - 1.89461495942761e-20)))) - 6.71657000341052e-14);
	fConst124 = (1.5264931825933e-11 + (fConst1 * ((fConst1 * (9.35234455241899e-18 + (fConst1 * (fConst12 - 7.37769723355959e-22)))) - 2.45029450717437e-14)));
	fConst125 = (fConst1 * ((fConst1 * (8.48164523024733e-17 + (fConst1 * (fConst21 - 8.66160236511396e-21)))) - 1.45366373471024e-13));
	fConst126 = ((fConst1 * (7.0538512209201e-13 + (fConst1 * ((fConst1 * (1.2667432098519e-20 - fConst23)) - 2.02249678663618e-16)))) - 7.26831867355119e-10);
	fConst127 = ((fConst1 * (9.43976329166227e-15 + (fConst1 * (fConst25 - 7.60669469876817e-19)))) - 2.45011082038024e-11);
	fConst128 = (fConst1 * (1.3433140006821e-18 + (fConst1 * ((fConst1 * (7.81684202728047e-26 - fConst27)) - 7.56481497006641e-22))));
	fConst129 = (6.71657000341052e-15 + (fConst1 * ((fConst1 * (1.80305965896787e-21 + (fConst1 * (fConst29 - 1.1579071334722e-25)))) - 6.25116952694904e-18)));
	fConst130 = ((fConst1 * (2.30310417115742e-15 + (fConst1 * ((fConst1 * (7.15029301684208e-23 - fConst31)) - 8.87337749416253e-19)))) - 1.5264931825933e-12);
	fConst131 = (fConst1 * (1.07465120054568e-22 + (fConst1 * (fConst27 - 5.34016243926791e-26))));
	fConst132 = (1.88063960095495e-18 + (fConst1 * ((fConst1 * (9.07762495082928e-26 - fConst29)) - 1.043068198127e-21)));
	fConst133 = ((fConst1 * (4.84128424874367e-19 + (fConst1 * (fConst31 - 5.33105928310193e-23)))) - 4.27418091126124e-16);
	fConst134 = (fConst1 * ((fConst1 * (5.6810238715616e-22 - fConst36)) - 1.14324595802732e-18));
	fConst135 = ((fConst1 * (1.10964701928404e-17 + (fConst1 * (fConst38 - 9.65704782003115e-22)))) - 2.00068042654782e-14);
	fConst136 = (4.54700096942685e-12 + (fConst1 * ((fConst1 * (5.6713396628744e-19 - fConst25)) - 5.15030239228049e-15)));
	fConst137 = (fConst1 * ((fConst1 * (8.04767550007065e-18 + (fConst1 * (fConst36 - 8.31578939072391e-22)))) - 1.42905744753415e-14));
	fConst138 = ((fConst1 * (6.65018034781812e-14 + (fConst1 * ((fConst1 * (1.23181609943851e-21 - fConst38)) - 1.91814857337008e-17)))) - 7.14528723767077e-11);
	fConst139 = ((fConst1 * (1.86995242795741e-12 + (fConst1 * ((fConst1 * (1.36117518832741e-20 - fConst23)) - 2.6506307935329e-16)))) - 4.11392373590659e-09);
	fConst140 = ((fConst1 * (3.8670883117522e-13 + (fConst1 * ((fConst1 * (2.49159294592092e-20 + (fConst1 * (fConst16 - 1.27950467702777e-24)))) - 1.75775528227997e-16)))) - 2.28349583995258e-10);
	fConst141 = (fConst1 * (2.00947633915827e-16 + (fConst1 * ((fConst1 * (2.02873486734413e-23 - fConst45)) - 1.37903061105669e-19))));
	fConst142 = (1.00473816957914e-12 + (fConst1 * ((fConst1 * (3.60237280890823e-19 + (fConst1 * (fConst47 - 3.47158284662071e-23)))) - 1.07837514221197e-15)));
	fConst143 = (fConst1 * ((fConst1 * (1.36883801329732e-19 + (fConst1 * (fConst45 - 2.0227577218374e-23)))) - 1.97546176570898e-16));
	fConst144 = ((fConst1 * (1.06644191406898e-15 + (fConst1 * ((fConst1 * (3.46554592965891e-23 - fConst47)) - 3.58161828053448e-19)))) - 9.87730882854489e-13);
	fConst145 = (2.24484291557838e-10 + (fConst1 * ((fConst1 * (1.74864212392649e-16 + (fConst1 * ((fConst1 * (1.27794127303783e-24 - fConst16)) - 2.48440823429459e-20)))) - 3.83285371396416e-13)));
	fConst146 = (fConst1 * ((fConst1 * (1.46705384154967e-15 + (fConst1 * (fConst52 - 2.15822858228099e-19)))) - 2.13774078633859e-12));
	fConst147 = ((fConst1 * (1.14720759809784e-11 + (fConst1 * ((fConst1 * (3.69317324108586e-19 - fConst54)) - 3.83231149883854e-15)))) - 1.06887039316929e-08);
	fConst148 = ((fConst1 * (1.75400821768783e-13 + (fConst1 * ((fConst1 * (1.32624807791401e-21 - fConst38)) - 2.53170117182572e-17)))) - 3.84723121007303e-10);
	fConst149 = (fConst1 * (1.97546176570898e-17 + (fConst1 * ((fConst1 * (1.90321481170268e-24 - fConst57)) - 1.31441469577845e-20))));
	fConst150 = (9.87730882854489e-14 + (fConst1 * ((fConst1 * (3.38804134303455e-20 + (fConst1 * (fConst59 - 3.34480759042284e-24)))) - 1.02026058934744e-16)));
	fConst151 = ((fConst1 * (3.61639733746865e-14 + (fConst1 * ((fConst1 * (2.37979910151618e-21 + (fConst1 * (fConst29 - 1.24667319323917e-25)))) - 1.64876772462656e-17)))) - 2.24484291557838e-11);
	fConst152 = (fConst1 * (1.58036941256718e-21 + (fConst1 * (fConst57 - 9.46871530624937e-25))));
	fConst153 = (2.76564647199257e-17 + (fConst1 * ((fConst1 * (2.37890087653433e-24 - fConst59)) - 1.81664248926293e-20)));
	fConst154 = ((fConst1 * (7.76207808829881e-18 + (fConst1 * ((fConst1 * (9.96528554849904e-26 - fConst29)) - 1.51537698212592e-21)))) - 6.28556016361947e-15);
	fConst155 = (fConst1 * ((fConst1 * (1.0073101389627e-20 - fConst65)) - 1.68124405592253e-17));
	fConst156 = ((fConst1 * (1.9325983928329e-16 + (fConst1 * (fConst67 - 2.53074561333439e-20)))) - 2.94217709786443e-13);
	fConst157 = (6.68676613151008e-11 + (fConst1 * ((fConst1 * (1.61210317247438e-17 + (fConst1 * (fConst38 - 1.06013676047862e-21)))) - 8.25752988116895e-14)));
	fConst158 = (fConst1 * ((fConst1 * (1.39831350614729e-16 + (fConst1 * (fConst65 - 2.02469660819434e-20)))) - 2.10155506990317e-13));
	fConst159 = ((fConst1 * (1.08538360568876e-12 + (fConst1 * ((fConst1 * (3.55830594725834e-20 - fConst67)) - 3.60429930110059e-16)))) - 1.05077753495158e-09);
	fConst160 = (3.83038460817312e-09 + (fConst1 * ((fConst1 * (2.58723214045085e-16 + (fConst1 * (fConst23 - 1.3445432309877e-20)))) - 1.81188143839367e-12)));
	fConst161 = (1.89696659621061e-10 + (fConst1 * ((fConst1 * (1.70316855209005e-16 + (fConst1 * ((fConst1 * (1.26387063712844e-24 - fConst16)) - 2.4319982120238e-20)))) - 3.60056153168273e-13)));
	fConst162 = (fConst1 * ((fConst1 * (1.34382552753667e-19 + (fConst1 * (fConst45 - 2.02234012753566e-23)))) - 1.66933060466533e-16));
	fConst163 = ((fConst1 * (9.92403307818879e-16 + (fConst1 * ((fConst1 * (3.46512415941416e-23 - fConst47)) - 3.55949469174446e-19)))) - 8.34665302332667e-13);
	fConst164 = (fConst1 * (1.63531603121604e-16 + (fConst1 * ((fConst1 * (2.01636298202893e-23 - fConst45)) - 1.33363292977731e-19))));
	fConst165 = (8.1765801560802e-13 + (fConst1 * ((fConst1 * (3.53874016337071e-19 + (fConst1 * (fConst47 - 3.45908724245236e-23)))) - 9.80470079675889e-16)));
	fConst166 = ((fConst1 * (3.56632693389469e-13 + (fConst1 * ((fConst1 * (2.42481350039747e-20 + (fConst1 * (fConst16 - 1.2623072331385e-24)))) - 1.69405539373657e-16)))) - 1.85831367183641e-10);
	fConst167 = (fConst1 * (1.7758836219844e-12 + (fConst1 * ((fConst1 * (2.15142566759113e-19 - fConst52)) - 1.42960162503901e-15))));
	fConst168 = (8.87941810992199e-09 + (fConst1 * ((fConst1 * (3.78669648057921e-15 + (fConst1 * (fConst54 - 3.68630229724911e-19)))) - 1.05574819980732e-11)));
	fConst169 = (3.56369208233956e-10 + (fConst1 * ((fConst1 * (2.46830251874368e-17 + (fConst1 * (fConst38 - 1.3096161205743e-21)))) - 1.69593722812409e-13)));
	fConst170 = (fConst1 * ((fConst1 * (1.27920961225844e-20 + (fConst1 * (fConst57 - 1.89682007189421e-24)))) - 1.63531603121604e-17));
	fConst171 = ((fConst1 * (9.34288754954348e-17 + (fConst1 * ((fConst1 * (3.33834890321629e-24 - fConst59)) - 3.34129341401451e-20)))) - 8.1765801560802e-14);
	fConst172 = (1.85831367183641e-11 + (fConst1 * ((fConst1 * (1.59418099443664e-17 + (fConst1 * ((fConst1 * (1.23103915333984e-25 - fConst29)) - 2.32020436761906e-21)))) - 3.34987055739919e-14)));
	fConst173 = (fConst1 * ((fConst1 * (9.4047679081647e-25 - fConst57)) - 1.30825282497283e-21));
	fConst174 = ((fConst1 * (1.77796791925108e-20 + (fConst1 * (fConst59 - 2.37244218932777e-24)))) - 2.28944244370246e-17);
	fConst175 = (5.20327828114195e-15 + (fConst1 * ((fConst1 * (1.47532479810296e-21 + (fConst1 * (fConst29 - 9.80894514950575e-26)))) - 7.47499984566977e-18)));
	fConst176 = (fConst1 * (1.39175832443918e-17 + (fConst1 * (fConst65 - 1.00050722427284e-20))));
	fConst177 = (2.43557706776857e-13 + (fConst1 * ((fConst1 * (2.52387466949763e-20 - fConst67)) - 1.89145523324583e-16)));
	fConst178 = ((fConst1 * (7.95212749539338e-14 + (fConst1 * ((fConst1 * (1.04350480313891e-21 - fConst38)) - 1.56949446606698e-17)))) - 5.53540242674675e-11);
	fConst179 = (fConst1 * (1.73969790554898e-13 + (fConst1 * ((fConst1 * (2.01789369350448e-20 - fConst65)) - 1.36086128963663e-16))));
	fConst180 = (8.6984895277449e-10 + (fConst1 * ((fConst1 * (3.55456746171757e-16 + (fConst1 * (fConst67 - 3.55143500342159e-20)))) - 9.93924207398243e-13)));
	fConst181 = (fConst1 * (1.99797992954822e-13 - (3.29010356101941e-22 * fConst4)));
	fConst182 = (fConst181 - 1.0510635792443e-09);
	fConst183 = (6.18539469471648e-26 * fConst1);
	fConst184 = ((fConst1 * (4.93999882244822e-14 + (fConst4 * (fConst183 - 1.47781348887909e-21)))) - 6.21110868467102e-11);
	fConst185 = (1.26310658988641e-28 * fConst1);
	fConst186 = (fConst4 * (1.5945493032865e-20 + (fConst1 * (fConst185 - 3.25676248928285e-24))));
	fConst187 = (1.27573765578527e-28 * fConst1);
	fConst188 = (1.36644391062762e-13 + (fConst4 * ((fConst1 * (4.76295446904316e-24 - fConst187)) - 3.80229395887602e-20)));
	fConst189 = (fConst4 * ((fConst1 * (3.25057079031282e-24 - fConst185)) - 1.58697870583894e-20));
	fConst190 = ((fConst4 * (3.78922991885521e-20 + (fConst1 * (fConst187 - 4.75670085308342e-24)))) - 1.3433140006821e-13);
	fConst191 = (6.1059727303732e-11 + (fConst1 * ((fConst4 * (1.47553944671192e-21 - fConst183)) - 4.90058901434873e-14)));
	fConst192 = (8.95820276515184e-25 * fConst1);
	fConst193 = (fConst1 * ((fConst4 * (1.73232047302279e-20 - fConst192)) - 2.90732746942048e-13));
	fConst194 = (9.04778479280336e-25 * fConst1);
	fConst195 = ((fConst1 * (1.41077024418402e-12 + (fConst4 * (fConst194 - 2.53348641970381e-20)))) - 2.90732746942048e-09);
	fConst196 = (3.2901035610194e-23 * fConst4);
	fConst197 = (fConst1 * (1.88795265833245e-14 - fConst196));
	fConst198 = (fConst197 - 9.80044328152095e-11);
	fConst199 = (1.26310658988641e-29 * fConst1);
	fConst200 = (fConst4 * (1.51296299401328e-21 + (fConst1 * (fConst199 - 3.12673681091219e-25))));
	fConst201 = (1.27573765578527e-29 * fConst1);
	fConst202 = (1.3433140006821e-14 + (fConst4 * ((fConst1 * (4.63162853388879e-25 - fConst201)) - 3.60611931793574e-21)));
	fConst203 = (6.18539469471648e-27 * fConst1);
	fConst204 = ((fConst1 * (4.60620834231485e-15 + (fConst4 * (fConst203 - 1.43005860336842e-22)))) - 6.1059727303732e-12);
	fConst205 = ((fConst1 * (2.13606497570716e-25 - fConst199)) - 2.14930240109137e-22);
	fConst206 = (2.08613639625399e-21 + (fConst1 * (fConst201 - 3.63104998033171e-25)));
	fConst207 = ((fConst4 * (1.06621185662039e-22 - fConst203)) - 8.54836182252248e-16);
	fConst208 = (8.95820276515184e-26 * fConst1);
	fConst209 = (fConst4 * (fConst208 - 1.13620477431232e-21));
	fConst210 = (9.04778479280336e-26 * fConst1);
	fConst211 = ((fConst4 * (1.93140956400623e-21 - fConst210)) - 4.00136085309563e-14);
	fConst212 = (fConst1 * (fConst196 - 1.0300604784561e-14));
	fConst213 = (1.81880038777074e-11 + fConst212);
	fConst214 = (fConst1 * ((fConst4 * (1.66315787814478e-21 - fConst208)) - 2.85811489506831e-14));
	fConst215 = ((fConst1 * (1.33003606956362e-13 + (fConst4 * (fConst210 - 2.46363219887702e-21)))) - 2.85811489506831e-10);
	fConst216 = ((fConst1 * (3.73990485591482e-12 + (fConst4 * (fConst194 - 2.72235037665482e-20)))) - 1.64556949436264e-08);
	fConst217 = ((fConst1 * (7.73417662350439e-13 + (fConst4 * ((fConst1 * (5.11801870811106e-24 - fConst187)) - 4.98318589184184e-20)))) - 9.13398335981032e-10);
	fConst218 = (4.87735073349648e-27 * fConst1);
	fConst219 = (fConst4 * (2.75806122211338e-19 + (fConst1 * (fConst218 - 8.11493946937652e-23))));
	fConst220 = (4.92612424083144e-27 * fConst1);
	fConst221 = (2.00947633915827e-12 + (fConst4 * ((fConst1 * (1.38863313864828e-22 - fConst220)) - 7.20474561781645e-19)));
	fConst222 = (fConst4 * ((fConst1 * (8.09103088734958e-23 - fConst218)) - 2.73767602659465e-19));
	fConst223 = ((fConst4 * (7.16323656106896e-19 + (fConst1 * (fConst220 - 1.38621837186356e-22)))) - 1.97546176570898e-12);
	fConst224 = (8.97937166231353e-10 + (fConst1 * ((fConst4 * (4.96881646858917e-20 + (fConst1 * (fConst187 - 5.11176509215133e-24)))) - 7.66570742792831e-13)));
	fConst225 = (3.45911399538757e-23 * fConst1);
	fConst226 = (fConst1 * ((fConst4 * (4.31645716456198e-19 - fConst225)) - 4.27548157267717e-12));
	fConst227 = (3.49370513534145e-23 * fConst1);
	fConst228 = ((fConst1 * (2.29441519619568e-11 + (fConst4 * (fConst227 - 7.38634648217173e-19)))) - 4.27548157267717e-08);
	fConst229 = ((fConst1 * (3.50801643537566e-13 + (fConst4 * (fConst210 - 2.65249615582803e-21)))) - 1.53889248402921e-09);
	fConst230 = (4.87735073349648e-28 * fConst1);
	fConst231 = (fConst4 * (2.62882939155691e-20 + (fConst1 * (fConst230 - 7.61285924681071e-24))));
	fConst232 = (4.92612424083144e-28 * fConst1);
	fConst233 = (1.97546176570898e-13 + (fConst4 * ((fConst1 * (1.33792303616914e-23 - fConst232)) - 6.7760826860691e-20)));
	fConst234 = ((fConst1 * (7.2327946749373e-14 + (fConst4 * ((fConst1 * (4.98669277295669e-25 - fConst201)) - 4.75959820303236e-21)))) - 8.97937166231353e-11);
	fConst235 = ((fConst1 * (3.78748612249975e-24 - fConst230)) - 3.16073882513436e-21);
	fConst236 = (3.63328497852585e-20 + (fConst1 * (fConst232 - 9.5156035061373e-24)));
	fConst237 = ((fConst4 * (3.03075396425184e-21 + (fConst1 * (fConst201 - 3.98611421939962e-25)))) - 1.25711203272389e-14);
	fConst238 = (3.45911399538757e-24 * fConst1);
	fConst239 = (fConst4 * (fConst238 - 2.0146202779254e-20));
	fConst240 = (3.49370513534145e-24 * fConst1);
	fConst241 = ((fConst4 * (5.06149122666878e-20 - fConst240)) - 5.88435419572887e-13);
	fConst242 = (2.67470645260403e-10 + (fConst1 * ((fConst4 * (2.12027352095724e-21 - fConst210)) - 1.65150597623379e-13)));
	fConst243 = (fConst1 * ((fConst4 * (4.04939321638868e-20 - fConst238)) - 4.20311013980633e-13));
	fConst244 = ((fConst1 * (2.17076721137753e-12 + (fConst4 * (fConst240 - 7.11661189451669e-20)))) - 4.20311013980633e-09);
	fConst245 = (1.53215384326925e-08 + (fConst1 * ((fConst4 * (2.6890864619754e-20 - fConst194)) - 3.62376287678734e-12)));
	fConst246 = (7.58786638484243e-10 + (fConst1 * ((fConst4 * (4.86399642404761e-20 + (fConst1 * (fConst187 - 5.05548254851374e-24)))) - 7.20112306336546e-13)));
	fConst247 = (fConst4 * ((fConst1 * (8.08936051014266e-23 - fConst218)) - 2.68765105507334e-19));
	fConst248 = ((fConst4 * (7.11898938348892e-19 + (fConst1 * (fConst220 - 1.38604966376566e-22)))) - 1.66933060466533e-12);
	fConst249 = (fConst4 * (2.66726585955461e-19 + (fConst1 * (fConst218 - 8.06545192811571e-23))));
	fConst250 = (1.63531603121604e-12 + (fConst4 * ((fConst1 * (1.38363489698094e-22 - fConst220)) - 7.07748032674143e-19)));
	fConst251 = ((fConst1 * (7.13265386778938e-13 + (fConst4 * ((fConst1 * (5.04922893255401e-24 - fConst187)) - 4.84962700079493e-20)))) - 7.43325468734564e-10);
	fConst252 = (fConst1 * (3.5517672439688e-12 + (fConst4 * (fConst225 - 4.30285133518226e-19))));
	fConst253 = (3.5517672439688e-08 + (fConst1 * ((fConst4 * (7.37260459449821e-19 - fConst227)) - 2.11149639961464e-11)));
	fConst254 = (1.42547683293582e-09 + (fConst1 * ((fConst4 * (2.6192322411486e-21 - fConst210)) - 3.39187445624818e-13)));
	fConst255 = (fConst4 * ((fConst1 * (7.58728028757684e-24 - fConst230)) - 2.55841922451687e-20));
	fConst256 = ((fConst4 * (6.68258682802903e-20 + (fConst1 * (fConst232 - 1.33533956128652e-23)))) - 1.63531603121604e-13);
	fConst257 = (7.43325468734564e-11 + (fConst1 * ((fConst4 * (4.64040873523812e-21 + (fConst1 * (fConst201 - 4.92415661335938e-25)))) - 6.69974111479837e-14)));
	fConst258 = (2.61650564994567e-21 + (fConst1 * (fConst230 - 3.76190716326588e-24)));
	fConst259 = ((fConst1 * (9.48976875731109e-24 - fConst232)) - 3.55593583850216e-20);
	fConst260 = (1.04065565622839e-14 + (fConst4 * ((fConst1 * (3.9235780598023e-25 - fConst201)) - 2.95064959620593e-21)));
	fConst261 = (fConst4 * (2.00101444854568e-20 - fConst238));
	fConst262 = (4.87115413553714e-13 + (fConst4 * (fConst240 - 5.04774933899526e-20)));
	fConst263 = ((fConst1 * (1.59042549907868e-13 + (fConst4 * (fConst210 - 2.08700960627782e-21)))) - 2.2141609706987e-10);
	fConst264 = (fConst1 * (3.47939581109796e-13 + (fConst4 * (fConst238 - 4.03578738700896e-20))));
	fConst265 = (3.47939581109796e-09 + (fConst1 * ((fConst4 * (7.10287000684317e-20 - fConst240)) - 1.98784841479649e-12)));
	fConst266 = ((fConst1 * ((fConst1 * (2.35821301416877e-17 - fConst10)) - 9.98989964774112e-14)) - 1.31382947405538e-09);
	fConst267 = (7.7317433683956e-26 * fConst1);
	fConst268 = ((fConst1 * ((fConst1 * (2.817151700663e-17 + (fConst1 * (0 - (7.38906744439547e-22 + fConst267))))) - 2.46999941122411e-14)) - 7.76388585583877e-11);
	fConst269 = (3.15776647471603e-28 * fConst1);
	fConst270 = (fConst1 * ((fConst1 * (7.97274651643249e-21 + (fConst1 * (4.07095311160356e-24 - fConst269)))) - 4.09933173188287e-17));
	fConst271 = (3.18934413946319e-28 * fConst1);
	fConst272 = ((fConst1 * (1.98918604429947e-16 + (fConst1 * ((fConst1 * (fConst271 - 5.95369308630395e-24)) - 1.90114697943801e-20)))) - 6.83221955313812e-14);
	fConst273 = (fConst1 * (4.02994200204631e-17 + (fConst1 * ((fConst1 * (fConst269 - 4.06321348789102e-24)) - 7.93489352919472e-21))));
	fConst274 = (6.71657000341052e-14 + (fConst1 * ((fConst1 * (1.89461495942761e-20 + (fConst1 * (5.94587606635428e-24 - fConst271)))) - 1.96956076051665e-16)));
	fConst275 = (7.6324659129665e-11 + (fConst1 * (2.45029450717437e-14 + (fConst1 * ((fConst1 * (7.37769723355959e-22 + fConst267)) - 2.8057033657257e-17)))));
	fConst276 = (1.11977534564398e-24 * fConst1);
	fConst277 = (fConst1 * (1.45366373471024e-13 + (fConst1 * ((fConst1 * (8.66160236511396e-21 + fConst276)) - 2.5444935690742e-16))));
	fConst278 = (1.13097309910042e-24 * fConst1);
	fConst279 = ((fConst1 * ((fConst1 * (6.06749035990854e-16 + (fConst1 * (0 - (1.2667432098519e-20 + fConst278))))) - 7.0538512209201e-13)) - 3.6341593367756e-09);
	fConst280 = ((fConst1 * ((fConst1 * (2.28200840963045e-18 - fConst25)) - 9.43976329166227e-15)) - 1.22505541019012e-10);
	fConst281 = (3.15776647471603e-29 * fConst1);
	fConst282 = (fConst1 * ((fConst1 * (7.56481497006641e-22 + (fConst1 * (3.90842101364024e-25 - fConst281)))) - 4.02994200204631e-18));
	fConst283 = (3.18934413946319e-29 * fConst1);
	fConst284 = ((fConst1 * (1.87535085808471e-17 + (fConst1 * ((fConst1 * (fConst283 - 5.78953566736099e-25)) - 1.80305965896787e-21)))) - 6.71657000341052e-15);
	fConst285 = (7.7317433683956e-27 * fConst1);
	fConst286 = ((fConst1 * ((fConst1 * (2.66201324824876e-18 + (fConst1 * (0 - (7.15029301684208e-23 + fConst285))))) - 2.30310417115742e-15)) - 7.6324659129665e-12);
	fConst287 = (fConst1 * ((fConst1 * (fConst281 - 2.67008121963395e-25)) - 1.07465120054568e-22));
	fConst288 = ((fConst1 * (1.043068198127e-21 + (fConst1 * (4.53881247541464e-25 - fConst283)))) - 5.64191880286484e-18);
	fConst289 = (4.27418091126124e-16 + (fConst1 * ((fConst1 * (5.33105928310193e-23 + fConst285)) - 1.4523852746231e-18)));
	fConst290 = (1.11977534564398e-25 * fConst1);
	fConst291 = (fConst1 * (3.42973787408197e-18 + (fConst1 * (0 - (5.6810238715616e-22 + fConst290)))));
	fConst292 = (1.13097309910042e-25 * fConst1);
	fConst293 = (2.00068042654782e-14 + (fConst1 * ((fConst1 * (9.65704782003115e-22 + fConst292)) - 3.32894105785212e-17)));
	fConst294 = (2.27350048471343e-11 + (fConst1 * (5.15030239228049e-15 + (fConst1 * (fConst25 - 1.70140189886232e-18)))));
	fConst295 = (fConst1 * (1.42905744753415e-14 + (fConst1 * ((fConst1 * (8.31578939072391e-22 + fConst290)) - 2.41430265002119e-17))));
	fConst296 = ((fConst1 * ((fConst1 * (5.75444572011023e-17 + (fConst1 * (0 - (1.23181609943851e-21 + fConst292))))) - 6.65018034781812e-14)) - 3.57264361883538e-10);
	fConst297 = ((fConst1 * ((fConst1 * (7.95189238059869e-16 + (fConst1 * (0 - (1.36117518832741e-20 + fConst278))))) - 1.86995242795741e-12)) - 2.0569618679533e-08);
	fConst298 = ((fConst1 * ((fConst1 * (5.2732658468399e-16 + (fConst1 * ((fConst1 * (fConst271 - 6.39752338513883e-24)) - 2.49159294592092e-20)))) - 3.8670883117522e-13)) - 1.14174791997629e-09);
	fConst299 = (1.21933768337412e-26 * fConst1);
	fConst300 = (fConst1 * ((fConst1 * (1.37903061105669e-19 + (fConst1 * (1.01436743367207e-22 - fConst299)))) - 6.02842901747481e-16));
	fConst301 = (1.23153106020786e-26 * fConst1);
	fConst302 = ((fConst1 * (3.23512542663591e-15 + (fConst1 * ((fConst1 * (fConst301 - 1.73579142331036e-22)) - 3.60237280890823e-19)))) - 1.00473816957914e-12);
	fConst303 = (fConst1 * (5.92638529712693e-16 + (fConst1 * ((fConst1 * (fConst299 - 1.0113788609187e-22)) - 1.36883801329732e-19))));
	fConst304 = (9.87730882854489e-13 + (fConst1 * ((fConst1 * (3.58161828053448e-19 + (fConst1 * (1.73277296482945e-22 - fConst301)))) - 3.19932574220694e-15)));
	fConst305 = (1.12242145778919e-09 + (fConst1 * (3.83285371396416e-13 + (fConst1 * ((fConst1 * (2.48440823429459e-20 + (fConst1 * (6.38970636518916e-24 - fConst271)))) - 5.24592637177946e-16)))));
	fConst306 = (4.32389249423446e-23 * fConst1);
	fConst307 = (fConst1 * (2.13774078633859e-12 + (fConst1 * ((fConst1 * (2.15822858228099e-19 + fConst306)) - 4.401161524649e-15))));
	fConst308 = (4.36713141917681e-23 * fConst1);
	fConst309 = ((fConst1 * ((fConst1 * (1.14969344965156e-14 + (fConst1 * (0 - (3.69317324108586e-19 + fConst308))))) - 1.14720759809784e-11)) - 5.34435196584647e-08);
	fConst310 = ((fConst1 * ((fConst1 * (7.59510351547716e-17 + (fConst1 * (0 - (1.32624807791401e-21 + fConst292))))) - 1.75400821768783e-13)) - 1.92361560503652e-09);
	fConst311 = (1.21933768337412e-27 * fConst1);
	fConst312 = (fConst1 * ((fConst1 * (1.31441469577845e-20 + (fConst1 * (9.51607405851339e-24 - fConst311)))) - 5.92638529712693e-17));
	fConst313 = (1.23153106020786e-27 * fConst1);
	fConst314 = ((fConst1 * (3.06078176804231e-16 + (fConst1 * ((fConst1 * (fConst313 - 1.67240379521142e-23)) - 3.38804134303455e-20)))) - 9.87730882854489e-14);
	fConst315 = ((fConst1 * ((fConst1 * (4.94630317387968e-17 + (fConst1 * ((fConst1 * (fConst283 - 6.23336596619587e-25)) - 2.37979910151618e-21)))) - 3.61639733746865e-14)) - 1.12242145778919e-10);
	fConst316 = (fConst1 * ((fConst1 * (fConst311 - 4.73435765312469e-24)) - 1.58036941256718e-21));
	fConst317 = ((fConst1 * (1.81664248926293e-20 + (fConst1 * (1.18945043826716e-23 - fConst313)))) - 8.2969394159777e-17);
	fConst318 = (6.28556016361947e-15 + (fConst1 * ((fConst1 * (1.51537698212592e-21 + (fConst1 * (4.98264277424952e-25 - fConst283)))) - 2.32862342648964e-17)));
	fConst319 = (4.32389249423446e-24 * fConst1);
	fConst320 = (fConst1 * (5.0437321677676e-17 + (fConst1 * (0 - (1.0073101389627e-20 + fConst319)))));
	fConst321 = (4.36713141917681e-24 * fConst1);
	fConst322 = (2.94217709786443e-13 + (fConst1 * ((fConst1 * (2.53074561333439e-20 + fConst321)) - 5.7977951784987e-16)));
	fConst323 = (3.34338306575504e-10 + (fConst1 * (8.25752988116895e-14 + (fConst1 * ((fConst1 * (1.06013676047862e-21 + fConst292)) - 4.83630951742315e-17)))));
	fConst324 = (fConst1 * (2.10155506990317e-13 + (fConst1 * ((fConst1 * (2.02469660819434e-20 + fConst319)) - 4.19494051844188e-16))));
	fConst325 = ((fConst1 * ((fConst1 * (1.08128979033018e-15 + (fConst1 * (0 - (3.55830594725834e-20 + fConst321))))) - 1.08538360568876e-12)) - 5.25388767475792e-09);
	fConst326 = (1.91519230408656e-08 + (fConst1 * (1.81188143839367e-12 + (fConst1 * ((fConst1 * (1.3445432309877e-20 + fConst278)) - 7.76169642135256e-16)))));
	fConst327 = (9.48483298105304e-10 + (fConst1 * (3.60056153168273e-13 + (fConst1 * ((fConst1 * (2.4319982120238e-20 + (fConst1 * (6.31935318564218e-24 - fConst271)))) - 5.10950565627015e-16)))));
	fConst328 = (fConst1 * (5.007991813996e-16 + (fConst1 * ((fConst1 * (fConst299 - 1.01117006376783e-22)) - 1.34382552753667e-19))));
	fConst329 = (8.34665302332667e-13 + (fConst1 * ((fConst1 * (3.55949469174446e-19 + (fConst1 * (1.73256207970708e-22 - fConst301)))) - 2.97720992345664e-15)));
	fConst330 = (fConst1 * ((fConst1 * (1.33363292977731e-19 + (fConst1 * (1.00818149101446e-22 - fConst299)))) - 4.90594809364812e-16));
	fConst331 = ((fConst1 * (2.94141023902767e-15 + (fConst1 * ((fConst1 * (fConst301 - 1.72954362122618e-22)) - 3.53874016337071e-19)))) - 8.1765801560802e-13);
	fConst332 = ((fConst1 * ((fConst1 * (5.08216618120971e-16 + (fConst1 * ((fConst1 * (fConst271 - 6.31153616569251e-24)) - 2.42481350039747e-20)))) - 3.56632693389469e-13)) - 9.29156835918205e-10);
	fConst333 = (fConst1 * ((fConst1 * (4.28880487511703e-15 + (fConst1 * (0 - (2.15142566759113e-19 + fConst306))))) - 1.7758836219844e-12));
	fConst334 = (4.439709054961e-08 + (fConst1 * (1.05574819980732e-11 + (fConst1 * ((fConst1 * (3.68630229724911e-19 + fConst308)) - 1.13600894417376e-14)))));
	fConst335 = (1.78184604116978e-09 + (fConst1 * (1.69593722812409e-13 + (fConst1 * ((fConst1 * (1.3096161205743e-21 + fConst292)) - 7.40490755623104e-17)))));
	fConst336 = (fConst1 * (4.90594809364812e-17 + (fConst1 * ((fConst1 * (fConst311 - 9.48410035947105e-24)) - 1.27920961225844e-20))));
	fConst337 = (8.1765801560802e-14 + (fConst1 * ((fConst1 * (3.34129341401451e-20 + (fConst1 * (1.66917445160815e-23 - fConst313)))) - 2.80286626486305e-16)));
	fConst338 = (9.29156835918205e-11 + (fConst1 * (3.34987055739919e-14 + (fConst1 * ((fConst1 * (2.32020436761906e-21 + (fConst1 * (6.15519576669922e-25 - fConst283)))) - 4.78254298330993e-17)))));
	fConst339 = (fConst1 * (1.30825282497283e-21 + (fConst1 * (4.70238395408235e-24 - fConst311))));
	fConst340 = (6.86832733110737e-17 + (fConst1 * ((fConst1 * (fConst313 - 1.18622109466389e-23)) - 1.77796791925108e-20)));
	fConst341 = ((fConst1 * (2.24249995370093e-17 + (fConst1 * ((fConst1 * (fConst283 - 4.90447257475287e-25)) - 1.47532479810296e-21)))) - 5.20327828114195e-15);
	fConst342 = (fConst1 * ((fConst1 * (1.00050722427284e-20 + fConst319)) - 4.17527497331755e-17));
	fConst343 = ((fConst1 * (5.67436569973748e-16 + (fConst1 * (0 - (2.52387466949763e-20 + fConst321))))) - 2.43557706776857e-13);
	fConst344 = ((fConst1 * ((fConst1 * (4.70848339820095e-17 + (fConst1 * (0 - (1.04350480313891e-21 + fConst292))))) - 7.95212749539338e-14)) - 2.76770121337338e-10);
	fConst345 = (fConst1 * ((fConst1 * (4.0825838689099e-16 + (fConst1 * (0 - (2.01789369350448e-20 + fConst319))))) - 1.73969790554898e-13));
	fConst346 = (4.34924476387245e-09 + (fConst1 * (9.93924207398243e-13 + (fConst1 * ((fConst1 * (3.55143500342159e-20 + fConst321)) - 1.06637023851527e-15)))));
	fConst347 = (9.80117802869747e-14 - (2.95107889342384e-21 * fConst4));
	fConst348 = (4.21035529962137e-28 * fConst4);
	fConst349 = (fConst4 * (3.17395741167789e-20 - fConst348));
	fConst350 = (4.25245885261758e-28 * fConst4);
	fConst351 = (2.68662800136421e-13 + (fConst4 * (fConst350 - 7.57845983771042e-20)));
	fConst352 = (fConst4 * (fConst348 - 3.18909860657299e-20));
	fConst353 = ((fConst4 * (7.60458791775203e-20 - fConst350)) - 2.73288782125525e-13);
	fConst354 = ((2.95562697775819e-21 * fConst4) - 9.87999764489643e-14);
	fConst355 = (5.81465493884095e-13 - (3.46464094604558e-20 * fConst4));
	fConst356 = ((5.06697283940761e-20 * fConst4) - 2.82154048836804e-12);
	fConst357 = (6.58020712203881e-22 * fConst4);
	fConst358 = (fConst357 - 3.99595985909645e-13);
	fConst359 = (4.21035529962137e-29 * fConst4);
	fConst360 = (fConst4 * (fConst359 - 3.02592598802656e-21));
	fConst361 = (4.25245885261758e-29 * fConst4);
	fConst362 = ((fConst4 * (7.21223863587148e-21 - fConst361)) - 2.68662800136421e-14);
	fConst363 = ((2.86011720673683e-22 * fConst4) - 9.21241668462969e-15);
	fConst364 = (6.58020712203881e-23 * fConst4);
	fConst365 = (2.0601209569122e-14 - fConst364);
	fConst366 = (4.29860480218273e-22 - fConst359);
	fConst367 = (fConst361 - 4.17227279250799e-21);
	fConst368 = (1.7096723645045e-15 - (2.13242371324077e-22 * fConst4));
	fConst369 = (2.27240954862464e-21 * fConst4);
	fConst370 = (8.00272170619126e-14 - (3.86281912801246e-21 * fConst4));
	fConst371 = (5.71622979013661e-14 - (3.32631575628956e-21 * fConst4));
	fConst372 = ((4.92726439775403e-21 * fConst4) - 2.66007213912725e-13);
	fConst373 = (fConst364 - 3.77590531666491e-14);
	fConst374 = ((fConst4 * (9.96637178368369e-20 - fConst350)) - 1.54683532470088e-12);
	fConst375 = (1.53314148558566e-12 + (fConst4 * (fConst350 - 9.93763293717834e-20)));
	fConst376 = (1.62578357783216e-26 * fConst4);
	fConst377 = (fConst4 * (5.4753520531893e-19 - fConst376));
	fConst378 = (1.64204141361048e-26 * fConst4);
	fConst379 = (3.95092353141795e-12 + (fConst4 * (fConst378 - 1.43264731221379e-18)));
	fConst380 = (fConst4 * (fConst376 - 5.51612244422675e-19));
	fConst381 = ((fConst4 * (1.44094912356329e-18 - fConst378)) - 4.01895267831654e-12);
	fConst382 = (8.55096314535434e-12 - (8.63291432912396e-19 * fConst4));
	fConst383 = ((1.47726929643435e-18 * fConst4) - 4.58883039239136e-11);
	fConst384 = ((5.44470075330964e-20 * fConst4) - 7.47980971182964e-12);
	fConst385 = ((fConst4 * (9.51919640606471e-21 - fConst361)) - 1.44655893498746e-13);
	fConst386 = (1.62578357783216e-27 * fConst4);
	fConst387 = (fConst4 * (fConst386 - 5.25765878311382e-20));
	fConst388 = (1.64204141361048e-27 * fConst4);
	fConst389 = ((fConst4 * (1.35521653721382e-19 - fConst388)) - 3.95092353141795e-13);
	fConst390 = (3.30301195246758e-13 - (4.24054704191449e-21 * fConst4));
	fConst391 = (6.32147765026873e-21 - fConst386);
	fConst392 = (fConst388 - 7.2665699570517e-20);
	fConst393 = (2.51422406544779e-14 + (fConst4 * (fConst361 - 6.06150792850369e-21)));
	fConst394 = (4.0292405558508e-20 * fConst4);
	fConst395 = (1.17687083914577e-12 - (1.01229824533376e-19 * fConst4));
	fConst396 = (8.40622027961267e-13 - (8.09878643277735e-20 * fConst4));
	fConst397 = ((1.42332237890334e-19 * fConst4) - 4.34153442275506e-12);
	fConst398 = ((5.30499231165606e-21 * fConst4) - 7.01603287075133e-13);
	fConst399 = (7.24752575357468e-12 - (5.37817292395079e-20 * fConst4));
	fConst400 = (1.44022461267309e-12 + (fConst4 * (fConst350 - 9.72799284809521e-20)));
	fConst401 = ((fConst4 * (9.69925400158986e-20 - fConst350)) - 1.42653077355788e-12);
	fConst402 = (fConst4 * (fConst376 - 5.33453171910922e-19));
	fConst403 = ((fConst4 * (1.41549606534829e-18 - fConst378)) - 3.27063206243208e-12);
	fConst404 = (fConst4 * (5.37530211014667e-19 - fConst376));
	fConst405 = (3.33866120933067e-12 + (fConst4 * (fConst378 - 1.42379787669778e-18)));
	fConst406 = ((8.60570267036453e-19 * fConst4) - 7.10353448793759e-12);
	fConst407 = (4.22299279922927e-11 - (1.47452091889964e-18 * fConst4));
	fConst408 = (6.78374891249636e-13 - (5.23846448229721e-21 * fConst4));
	fConst409 = (1.33994822295967e-13 + (fConst4 * (fConst361 - 9.28081747047623e-21)));
	fConst410 = (fConst4 * (5.11683844903374e-20 - fConst386));
	fConst411 = (3.27063206243208e-13 + (fConst4 * (fConst388 - 1.33651736560581e-19)));
	fConst412 = (fConst386 - 5.23301129989133e-21);
	fConst413 = (7.11187167700431e-20 - fConst388);
	fConst414 = ((fConst4 * (5.90129919241185e-21 - fConst361)) - 2.08131131245678e-14);
	fConst415 = ((1.00954986779905e-19 * fConst4) - 9.74230827107429e-13);
	fConst416 = ((4.17401921255564e-21 * fConst4) - 3.18085099815735e-13);
	fConst417 = ((8.07157477401792e-20 * fConst4) - 6.95879162219592e-13);
	fConst418 = (3.97569682959297e-12 - (1.42057400136863e-19 * fConst4));
	fConst419 = (1.31382947405538e-09 + (fConst1 * ((fConst1 * (0 - (2.35821301416877e-17 + fConst10))) - 9.98989964774112e-14)));
	fConst420 = (7.76388585583877e-11 + (fConst1 * ((fConst1 * ((fConst1 * (fConst267 - 7.38906744439547e-22)) - 2.817151700663e-17)) - 2.46999941122411e-14)));
	fConst421 = (fConst1 * (4.09933173188287e-17 + (fConst1 * (7.97274651643249e-21 + (fConst1 * (0 - (4.07095311160356e-24 + fConst269)))))));
	fConst422 = ((fConst1 * ((fConst1 * ((fConst1 * (5.95369308630395e-24 + fConst271)) - 1.90114697943801e-20)) - 1.98918604429947e-16)) - 6.83221955313812e-14);
	fConst423 = (fConst1 * ((fConst1 * ((fConst1 * (4.06321348789102e-24 + fConst269)) - 7.93489352919472e-21)) - 4.02994200204631e-17));
	fConst424 = (6.71657000341052e-14 + (fConst1 * (1.96956076051665e-16 + (fConst1 * (1.89461495942761e-20 + (fConst1 * (0 - (5.94587606635428e-24 + fConst271))))))));
	fConst425 = ((fConst1 * (2.45029450717437e-14 + (fConst1 * (2.8057033657257e-17 + (fConst1 * (7.37769723355959e-22 - fConst267)))))) - 7.6324659129665e-11);
	fConst426 = (fConst1 * (1.45366373471024e-13 + (fConst1 * (2.5444935690742e-16 + (fConst1 * (8.66160236511396e-21 - fConst276))))));
	fConst427 = (3.6341593367756e-09 + (fConst1 * ((fConst1 * ((fConst1 * (fConst278 - 1.2667432098519e-20)) - 6.06749035990854e-16)) - 7.0538512209201e-13)));
	fConst428 = (1.22505541019012e-10 + (fConst1 * ((fConst1 * (0 - (2.28200840963045e-18 + fConst25))) - 9.43976329166227e-15)));
	fConst429 = (fConst1 * (4.02994200204631e-18 + (fConst1 * (7.56481497006641e-22 + (fConst1 * (0 - (3.90842101364024e-25 + fConst281)))))));
	fConst430 = ((fConst1 * ((fConst1 * ((fConst1 * (5.78953566736099e-25 + fConst283)) - 1.80305965896787e-21)) - 1.87535085808471e-17)) - 6.71657000341052e-15);
	fConst431 = (7.6324659129665e-12 + (fConst1 * ((fConst1 * ((fConst1 * (fConst285 - 7.15029301684208e-23)) - 2.66201324824876e-18)) - 2.30310417115742e-15)));
	fConst432 = (fConst1 * ((fConst1 * (2.67008121963395e-25 + fConst281)) - 1.07465120054568e-22));
	fConst433 = (5.64191880286484e-18 + (fConst1 * (1.043068198127e-21 + (fConst1 * (0 - (4.53881247541464e-25 + fConst283))))));
	fConst434 = (4.27418091126124e-16 + (fConst1 * (1.4523852746231e-18 + (fConst1 * (5.33105928310193e-23 - fConst285)))));
	fConst435 = (fConst1 * ((fConst1 * (fConst290 - 5.6810238715616e-22)) - 3.42973787408197e-18));
	fConst436 = (2.00068042654782e-14 + (fConst1 * (3.32894105785212e-17 + (fConst1 * (9.65704782003115e-22 - fConst292)))));
	fConst437 = ((fConst1 * (5.15030239228049e-15 + (fConst1 * (1.70140189886232e-18 + fConst25)))) - 2.27350048471343e-11);
	fConst438 = (fConst1 * (1.42905744753415e-14 + (fConst1 * (2.41430265002119e-17 + (fConst1 * (8.31578939072391e-22 - fConst290))))));
	fConst439 = (3.57264361883538e-10 + (fConst1 * ((fConst1 * ((fConst1 * (fConst292 - 1.23181609943851e-21)) - 5.75444572011023e-17)) - 6.65018034781812e-14)));
	fConst440 = (2.0569618679533e-08 + (fConst1 * ((fConst1 * ((fConst1 * (fConst278 - 1.36117518832741e-20)) - 7.95189238059869e-16)) - 1.86995242795741e-12)));
	fConst441 = (1.14174791997629e-09 + (fConst1 * ((fConst1 * ((fConst1 * ((fConst1 * (6.39752338513883e-24 + fConst271)) - 2.49159294592092e-20)) - 5.2732658468399e-16)) - 3.8670883117522e-13)));
	fConst442 = (fConst1 * (6.02842901747481e-16 + (fConst1 * (1.37903061105669e-19 + (fConst1 * (0 - (1.01436743367207e-22 + fConst299)))))));
	fConst443 = ((fConst1 * ((fConst1 * ((fConst1 * (1.73579142331036e-22 + fConst301)) - 3.60237280890823e-19)) - 3.23512542663591e-15)) - 1.00473816957914e-12);
	fConst444 = (fConst1 * ((fConst1 * ((fConst1 * (1.0113788609187e-22 + fConst299)) - 1.36883801329732e-19)) - 5.92638529712693e-16));
	fConst445 = (9.87730882854489e-13 + (fConst1 * (3.19932574220694e-15 + (fConst1 * (3.58161828053448e-19 + (fConst1 * (0 - (1.73277296482945e-22 + fConst301))))))));
	fConst446 = ((fConst1 * (3.83285371396416e-13 + (fConst1 * (5.24592637177946e-16 + (fConst1 * (2.48440823429459e-20 + (fConst1 * (0 - (6.38970636518916e-24 + fConst271))))))))) - 1.12242145778919e-09);
	fConst447 = (fConst1 * (2.13774078633859e-12 + (fConst1 * (4.401161524649e-15 + (fConst1 * (2.15822858228099e-19 - fConst306))))));
	fConst448 = (5.34435196584647e-08 + (fConst1 * ((fConst1 * ((fConst1 * (fConst308 - 3.69317324108586e-19)) - 1.14969344965156e-14)) - 1.14720759809784e-11)));
	fConst449 = (1.92361560503652e-09 + (fConst1 * ((fConst1 * ((fConst1 * (fConst292 - 1.32624807791401e-21)) - 7.59510351547716e-17)) - 1.75400821768783e-13)));
	fConst450 = (fConst1 * (5.92638529712693e-17 + (fConst1 * (1.31441469577845e-20 + (fConst1 * (0 - (9.51607405851339e-24 + fConst311)))))));
	fConst451 = ((fConst1 * ((fConst1 * ((fConst1 * (1.67240379521142e-23 + fConst313)) - 3.38804134303455e-20)) - 3.06078176804231e-16)) - 9.87730882854489e-14);
	fConst452 = (1.12242145778919e-10 + (fConst1 * ((fConst1 * ((fConst1 * ((fConst1 * (6.23336596619587e-25 + fConst283)) - 2.37979910151618e-21)) - 4.94630317387968e-17)) - 3.61639733746865e-14)));
	fConst453 = (fConst1 * ((fConst1 * (4.73435765312469e-24 + fConst311)) - 1.58036941256718e-21));
	fConst454 = (8.2969394159777e-17 + (fConst1 * (1.81664248926293e-20 + (fConst1 * (0 - (1.18945043826716e-23 + fConst313))))));
	fConst455 = (6.28556016361947e-15 + (fConst1 * (2.32862342648964e-17 + (fConst1 * (1.51537698212592e-21 + (fConst1 * (0 - (4.98264277424952e-25 + fConst283))))))));
	fConst456 = (fConst1 * ((fConst1 * (fConst319 - 1.0073101389627e-20)) - 5.0437321677676e-17));
	fConst457 = (2.94217709786443e-13 + (fConst1 * (5.7977951784987e-16 + (fConst1 * (2.53074561333439e-20 - fConst321)))));
	fConst458 = ((fConst1 * (8.25752988116895e-14 + (fConst1 * (4.83630951742315e-17 + (fConst1 * (1.06013676047862e-21 - fConst292)))))) - 3.34338306575504e-10);
	fConst459 = (fConst1 * (2.10155506990317e-13 + (fConst1 * (4.19494051844188e-16 + (fConst1 * (2.02469660819434e-20 - fConst319))))));
	fConst460 = (5.25388767475792e-09 + (fConst1 * ((fConst1 * ((fConst1 * (fConst321 - 3.55830594725834e-20)) - 1.08128979033018e-15)) - 1.08538360568876e-12)));
	fConst461 = ((fConst1 * (1.81188143839367e-12 + (fConst1 * (7.76169642135256e-16 + (fConst1 * (1.3445432309877e-20 - fConst278)))))) - 1.91519230408656e-08);
	fConst462 = ((fConst1 * (3.60056153168273e-13 + (fConst1 * (5.10950565627015e-16 + (fConst1 * (2.4319982120238e-20 + (fConst1 * (0 - (6.31935318564218e-24 + fConst271))))))))) - 9.48483298105304e-10);
	fConst463 = (fConst1 * ((fConst1 * ((fConst1 * (1.01117006376783e-22 + fConst299)) - 1.34382552753667e-19)) - 5.007991813996e-16));
	fConst464 = (8.34665302332667e-13 + (fConst1 * (2.97720992345664e-15 + (fConst1 * (3.55949469174446e-19 + (fConst1 * (0 - (1.73256207970708e-22 + fConst301))))))));
	fConst465 = (fConst1 * (4.90594809364812e-16 + (fConst1 * (1.33363292977731e-19 + (fConst1 * (0 - (1.00818149101446e-22 + fConst299)))))));
	fConst466 = ((fConst1 * ((fConst1 * ((fConst1 * (1.72954362122618e-22 + fConst301)) - 3.53874016337071e-19)) - 2.94141023902767e-15)) - 8.1765801560802e-13);
	fConst467 = (9.29156835918205e-10 + (fConst1 * ((fConst1 * ((fConst1 * ((fConst1 * (6.31153616569251e-24 + fConst271)) - 2.42481350039747e-20)) - 5.08216618120971e-16)) - 3.56632693389469e-13)));
	fConst468 = (fConst1 * ((fConst1 * ((fConst1 * (fConst306 - 2.15142566759113e-19)) - 4.28880487511703e-15)) - 1.7758836219844e-12));
	fConst469 = ((fConst1 * (1.05574819980732e-11 + (fConst1 * (1.13600894417376e-14 + (fConst1 * (3.68630229724911e-19 - fConst308)))))) - 4.439709054961e-08);
	fConst470 = ((fConst1 * (1.69593722812409e-13 + (fConst1 * (7.40490755623104e-17 + (fConst1 * (1.3096161205743e-21 - fConst292)))))) - 1.78184604116978e-09);
	fConst471 = (fConst1 * ((fConst1 * ((fConst1 * (9.48410035947105e-24 + fConst311)) - 1.27920961225844e-20)) - 4.90594809364812e-17));
	fConst472 = (8.1765801560802e-14 + (fConst1 * (2.80286626486305e-16 + (fConst1 * (3.34129341401451e-20 + (fConst1 * (0 - (1.66917445160815e-23 + fConst313))))))));
	fConst473 = ((fConst1 * (3.34987055739919e-14 + (fConst1 * (4.78254298330993e-17 + (fConst1 * (2.32020436761906e-21 + (fConst1 * (0 - (6.15519576669922e-25 + fConst283))))))))) - 9.29156835918205e-11);
	fConst474 = (fConst1 * (1.30825282497283e-21 + (fConst1 * (0 - (4.70238395408235e-24 + fConst311)))));
	fConst475 = ((fConst1 * ((fConst1 * (1.18622109466389e-23 + fConst313)) - 1.77796791925108e-20)) - 6.86832733110737e-17);
	fConst476 = ((fConst1 * ((fConst1 * ((fConst1 * (4.90447257475287e-25 + fConst283)) - 1.47532479810296e-21)) - 2.24249995370093e-17)) - 5.20327828114195e-15);
	fConst477 = (fConst1 * (4.17527497331755e-17 + (fConst1 * (1.00050722427284e-20 - fConst319))));
	fConst478 = ((fConst1 * ((fConst1 * (fConst321 - 2.52387466949763e-20)) - 5.67436569973748e-16)) - 2.43557706776857e-13);
	fConst479 = (2.76770121337338e-10 + (fConst1 * ((fConst1 * ((fConst1 * (fConst292 - 1.04350480313891e-21)) - 4.70848339820095e-17)) - 7.95212749539338e-14)));
	fConst480 = (fConst1 * ((fConst1 * ((fConst1 * (fConst319 - 2.01789369350448e-20)) - 4.0825838689099e-16)) - 1.73969790554898e-13));
	fConst481 = ((fConst1 * (9.93924207398243e-13 + (fConst1 * (1.06637023851527e-15 + (fConst1 * (3.55143500342159e-20 - fConst321)))))) - 4.34924476387245e-09);
	fConst482 = (1.0510635792443e-09 + fConst181);
	fConst483 = (6.21110868467102e-11 + (fConst1 * (4.93999882244822e-14 + (fConst4 * (0 - (1.47781348887909e-21 + fConst183))))));
	fConst484 = (fConst4 * (1.5945493032865e-20 + (fConst1 * (3.25676248928285e-24 + fConst185))));
	fConst485 = (1.36644391062762e-13 + (fConst4 * ((fConst1 * (0 - (4.76295446904316e-24 + fConst187))) - 3.80229395887602e-20)));
	fConst486 = (fConst4 * ((fConst1 * (0 - (3.25057079031282e-24 + fConst185))) - 1.58697870583894e-20));
	fConst487 = ((fConst4 * (3.78922991885521e-20 + (fConst1 * (4.75670085308342e-24 + fConst187)))) - 1.3433140006821e-13);
	fConst488 = ((fConst1 * ((fConst4 * (1.47553944671192e-21 + fConst183)) - 4.90058901434873e-14)) - 6.1059727303732e-11);
	fConst489 = (fConst1 * ((fConst4 * (1.73232047302279e-20 + fConst192)) - 2.90732746942048e-13));
	fConst490 = (2.90732746942048e-09 + (fConst1 * (1.41077024418402e-12 + (fConst4 * (0 - (2.53348641970381e-20 + fConst194))))));
	fConst491 = (9.80044328152095e-11 + fConst197);
	fConst492 = (fConst4 * (1.51296299401328e-21 + (fConst1 * (3.12673681091219e-25 + fConst199))));
	fConst493 = (1.3433140006821e-14 + (fConst4 * ((fConst1 * (0 - (4.63162853388879e-25 + fConst201))) - 3.60611931793574e-21)));
	fConst494 = (6.1059727303732e-12 + (fConst1 * (4.60620834231485e-15 + (fConst4 * (0 - (1.43005860336842e-22 + fConst203))))));
	fConst495 = ((fConst1 * (0 - (2.13606497570716e-25 + fConst199))) - 2.14930240109137e-22);
	fConst496 = (2.08613639625399e-21 + (fConst1 * (3.63104998033171e-25 + fConst201)));
	fConst497 = ((fConst4 * (1.06621185662039e-22 + fConst203)) - 8.54836182252248e-16);
	fConst498 = (fConst4 * (0 - (1.13620477431232e-21 + fConst208)));
	fConst499 = ((fConst4 * (1.93140956400623e-21 + fConst210)) - 4.00136085309563e-14);
	fConst500 = (fConst212 - 1.81880038777074e-11);
	fConst501 = (fConst1 * ((fConst4 * (1.66315787814478e-21 + fConst208)) - 2.85811489506831e-14));
	fConst502 = (2.85811489506831e-10 + (fConst1 * (1.33003606956362e-13 + (fConst4 * (0 - (2.46363219887702e-21 + fConst210))))));
	fConst503 = (1.64556949436264e-08 + (fConst1 * (3.73990485591482e-12 + (fConst4 * (0 - (2.72235037665482e-20 + fConst194))))));
	fConst504 = (9.13398335981032e-10 + (fConst1 * (7.73417662350439e-13 + (fConst4 * ((fConst1 * (0 - (5.11801870811106e-24 + fConst187))) - 4.98318589184184e-20)))));
	fConst505 = (fConst4 * (2.75806122211338e-19 + (fConst1 * (8.11493946937652e-23 + fConst218))));
	fConst506 = (2.00947633915827e-12 + (fConst4 * ((fConst1 * (0 - (1.38863313864828e-22 + fConst220))) - 7.20474561781645e-19)));
	fConst507 = (fConst4 * ((fConst1 * (0 - (8.09103088734958e-23 + fConst218))) - 2.73767602659465e-19));
	fConst508 = ((fConst4 * (7.16323656106896e-19 + (fConst1 * (1.38621837186356e-22 + fConst220)))) - 1.97546176570898e-12);
	fConst509 = ((fConst1 * ((fConst4 * (4.96881646858917e-20 + (fConst1 * (5.11176509215133e-24 + fConst187)))) - 7.66570742792831e-13)) - 8.97937166231353e-10);
	fConst510 = (fConst1 * ((fConst4 * (4.31645716456198e-19 + fConst225)) - 4.27548157267717e-12));
	fConst511 = (4.27548157267717e-08 + (fConst1 * (2.29441519619568e-11 + (fConst4 * (0 - (7.38634648217173e-19 + fConst227))))));
	fConst512 = (1.53889248402921e-09 + (fConst1 * (3.50801643537566e-13 + (fConst4 * (0 - (2.65249615582803e-21 + fConst210))))));
	fConst513 = (fConst4 * (2.62882939155691e-20 + (fConst1 * (7.61285924681071e-24 + fConst230))));
	fConst514 = (1.97546176570898e-13 + (fConst4 * ((fConst1 * (0 - (1.33792303616914e-23 + fConst232))) - 6.7760826860691e-20)));
	fConst515 = (8.97937166231353e-11 + (fConst1 * (7.2327946749373e-14 + (fConst4 * ((fConst1 * (0 - (4.98669277295669e-25 + fConst201))) - 4.75959820303236e-21)))));
	fConst516 = ((fConst1 * (0 - (3.78748612249975e-24 + fConst230))) - 3.16073882513436e-21);
	fConst517 = (3.63328497852585e-20 + (fConst1 * (9.5156035061373e-24 + fConst232)));
	fConst518 = ((fConst4 * (3.03075396425184e-21 + (fConst1 * (3.98611421939962e-25 + fConst201)))) - 1.25711203272389e-14);
	fConst519 = (fConst4 * (0 - (2.0146202779254e-20 + fConst238)));
	fConst520 = ((fConst4 * (5.06149122666878e-20 + fConst240)) - 5.88435419572887e-13);
	fConst521 = ((fConst1 * ((fConst4 * (2.12027352095724e-21 + fConst210)) - 1.65150597623379e-13)) - 2.67470645260403e-10);
	fConst522 = (fConst1 * ((fConst4 * (4.04939321638868e-20 + fConst238)) - 4.20311013980633e-13));
	fConst523 = (4.20311013980633e-09 + (fConst1 * (2.17076721137753e-12 + (fConst4 * (0 - (7.11661189451669e-20 + fConst240))))));
	fConst524 = ((fConst1 * ((fConst4 * (2.6890864619754e-20 + fConst194)) - 3.62376287678734e-12)) - 1.53215384326925e-08);
	fConst525 = ((fConst1 * ((fConst4 * (4.86399642404761e-20 + (fConst1 * (5.05548254851374e-24 + fConst187)))) - 7.20112306336546e-13)) - 7.58786638484243e-10);
	fConst526 = (fConst4 * ((fConst1 * (0 - (8.08936051014266e-23 + fConst218))) - 2.68765105507334e-19));
	fConst527 = ((fConst4 * (7.11898938348892e-19 + (fConst1 * (1.38604966376566e-22 + fConst220)))) - 1.66933060466533e-12);
	fConst528 = (fConst4 * (2.66726585955461e-19 + (fConst1 * (8.06545192811571e-23 + fConst218))));
	fConst529 = (1.63531603121604e-12 + (fConst4 * ((fConst1 * (0 - (1.38363489698094e-22 + fConst220))) - 7.07748032674143e-19)));
	fConst530 = (7.43325468734564e-10 + (fConst1 * (7.13265386778938e-13 + (fConst4 * ((fConst1 * (0 - (5.04922893255401e-24 + fConst187))) - 4.84962700079493e-20)))));
	fConst531 = (fConst1 * (3.5517672439688e-12 + (fConst4 * (0 - (4.30285133518226e-19 + fConst225)))));
	fConst532 = ((fConst1 * ((fConst4 * (7.37260459449821e-19 + fConst227)) - 2.11149639961464e-11)) - 3.5517672439688e-08);
	fConst533 = ((fConst1 * ((fConst4 * (2.6192322411486e-21 + fConst210)) - 3.39187445624818e-13)) - 1.42547683293582e-09);
	fConst534 = (fConst4 * ((fConst1 * (0 - (7.58728028757684e-24 + fConst230))) - 2.55841922451687e-20));
	fConst535 = ((fConst4 * (6.68258682802903e-20 + (fConst1 * (1.33533956128652e-23 + fConst232)))) - 1.63531603121604e-13);
	fConst536 = ((fConst1 * ((fConst4 * (4.64040873523812e-21 + (fConst1 * (4.92415661335938e-25 + fConst201)))) - 6.69974111479837e-14)) - 7.43325468734564e-11);
	fConst537 = (2.61650564994567e-21 + (fConst1 * (3.76190716326588e-24 + fConst230)));
	fConst538 = ((fConst1 * (0 - (9.48976875731109e-24 + fConst232))) - 3.55593583850216e-20);
	fConst539 = (1.04065565622839e-14 + (fConst4 * ((fConst1 * (0 - (3.9235780598023e-25 + fConst201))) - 2.95064959620593e-21)));
	fConst540 = (fConst4 * (2.00101444854568e-20 + fConst238));
	fConst541 = (4.87115413553714e-13 + (fConst4 * (0 - (5.04774933899526e-20 + fConst240))));
	fConst542 = (2.2141609706987e-10 + (fConst1 * (1.59042549907868e-13 + (fConst4 * (0 - (2.08700960627782e-21 + fConst210))))));
	fConst543 = (fConst1 * (3.47939581109796e-13 + (fConst4 * (0 - (4.03578738700896e-20 + fConst238)))));
	fConst544 = ((fConst1 * ((fConst4 * (7.10287000684317e-20 + fConst240)) - 1.98784841479649e-12)) - 3.47939581109796e-09);
	fConst545 = (1.0 / (1 + fConst8));
	fConst546 = (fConst4 / fConst6);
	fConst547 = (3.32639146794241e-22 * fConst4);
	fConst548 = (fConst1 * (6.03611152342572e-13 - fConst547));
	fConst549 = (fConst548 - 2.36598915154661e-09);
	fConst550 = (fConst1 * ((3.29345689895288e-22 * fConst4) - 2.36598915154661e-13));
	fConst551 = (6.44615895238103e-15 * fConst1);
	fConst552 = (fConst551 - 2.68131097847092e-10);
	fConst553 = (fConst4 * (1.13620477431232e-20 - fConst192));
	fConst554 = (3.34077668198382e-14 + (fConst4 * (fConst194 - 1.37152189118424e-20)));
	fConst555 = (fConst1 * (2.88344388438523e-14 - (3.2901035610194e-22 * fConst4)));
	fConst556 = (9.85972206426334e-11 + fConst555);
	fConst557 = (fConst1 * (3.77960187738401e-13 - fConst547));
	fConst558 = (fConst557 - 5.08093007207534e-09);
	fConst559 = (fConst1 * (1.13798511156094e-11 - (5.93042028286115e-20 * fConst4)));
	fConst560 = (fConst559 - 3.47939581109796e-08);
	fConst561 = (fConst1 * ((5.27687952227765e-20 * fConst4) - 3.47939581109796e-12));
	fConst562 = (fConst4 * (1.61410563435159e-19 - fConst225));
	fConst563 = (4.91290688527032e-13 + (fConst4 * (fConst227 - 2.80820644155392e-19)));
	fConst564 = (1.44995912709755e-09 + (fConst1 * (3.03800598467627e-13 + (fConst4 * (fConst194 - 1.56038584813525e-20)))));
	fConst565 = (fConst225 - 1.62245618429822e-19);
	fConst566 = (2.81993395389897e-19 - fConst227);
	fConst567 = faustpower<3>(fConst1);
	fConst568 = ((fConst1 * ((fConst4 * (1.52712193345583e-20 - fConst194)) - 2.8558880817492e-13)) - 1.58154355049907e-09);
	fConst569 = (fConst1 * (fConst547 - 3.62927553029165e-13));
	fConst570 = (5.01855399444366e-09 + fConst569);
	fConst571 = (fConst1 * ((5.67572628267546e-20 * fConst4) - 1.12426237448197e-11));
	fConst572 = (3.47939581109796e-08 + fConst571);
	fConst573 = (fConst1 * (3.47939581109796e-12 - (5.05731572901413e-20 * fConst4)));
	fConst574 = (fConst1 * (1.18299457577331e-13 + (fConst1 * (fConst95 - 3.42973787408197e-17))));
	fConst575 = ((fConst1 * ((fConst1 * (4.13692256752265e-17 - fConst97)) - 3.01805576171286e-13)) - 2.95748643943327e-09);
	fConst576 = (3.62879069230081e-19 * fConst1);
	fConst577 = ((fConst1 * (fConst576 - 3.22307947619052e-15)) - 3.35163872308864e-10);
	fConst578 = (fConst1 * ((fConst1 * (5.6810238715616e-21 + fConst276)) - 5.90550892226034e-18));
	fConst579 = ((fConst1 * (1.14915525253223e-16 + (fConst1 * (0 - (6.8576094559212e-21 + fConst278))))) - 1.67038834099191e-14);
	fConst580 = (1.23246525803292e-10 + (fConst1 * ((fConst1 * (1.09061534669288e-17 - fConst10)) - 1.44172194219261e-14)));
	fConst581 = ((fConst1 * ((fConst1 * (2.43081624211112e-17 - fConst97)) - 1.88980093869201e-13)) - 6.35116259009417e-09);
	fConst582 = (fConst1 * (1.73969790554898e-12 + (fConst1 * (fConst103 - 1.25533817347765e-15))));
	fConst583 = ((fConst1 * ((fConst1 * (2.51841981192082e-15 - fConst105)) - 5.68992555780471e-12)) - 4.34924476387245e-08);
	fConst584 = (fConst1 * ((fConst1 * (8.07052817175794e-20 + fConst306)) - 8.68457194450051e-17));
	fConst585 = ((fConst1 * (1.64734639017249e-15 + (fConst1 * (0 - (1.40410322077696e-19 + fConst308))))) - 2.45645344263516e-13);
	fConst586 = (1.81244890887194e-09 + (fConst1 * ((fConst1 * (2.2174073102522e-16 + (fConst1 * (0 - (7.80192924067626e-21 + fConst278))))) - 1.51900299233814e-13)));
	fConst587 = (fConst1 * (0 - (8.11228092149111e-20 + fConst306)));
	fConst588 = ((fConst1 * (1.40996697694949e-19 + fConst308)) - 1.56589512599301e-15);
	fConst589 = ((fConst1 * (1.4279440408746e-13 + (fConst1 * ((fConst1 * (7.63560966727914e-21 + fConst278)) - 2.15889348849432e-16)))) - 1.97692943812384e-09);
	fConst590 = (6.27319249305457e-09 + (fConst1 * (1.81463776514583e-13 + (fConst1 * (fConst97 - 2.35521643602152e-17)))));
	fConst591 = (fConst1 * ((fConst1 * (1.21416996224074e-15 - fConst114)) - 1.73969790554898e-12));
	fConst592 = (4.34924476387245e-08 + (fConst1 * (5.62131187240986e-12 + (fConst1 * (fConst116 - 2.41920442283987e-15)))));
	fConst593 = (4.73197830309322e-13 - (6.58691379790577e-22 * fConst4));
	fConst594 = (6.65278293588483e-22 * fConst4);
	fConst595 = (fConst594 - 1.20722230468514e-12);
	fConst596 = ((2.74304378236848e-20 * fConst4) - 6.68155336396763e-14);
	fConst597 = (fConst357 - 5.76688776877046e-14);
	fConst598 = (6.95879162219592e-12 - (1.05537590445553e-19 * fConst4));
	fConst599 = ((1.18608405657223e-19 * fConst4) - 2.27597022312189e-11);
	fConst600 = (fConst594 - 7.55920375476802e-13);
	fConst601 = ((5.61641288310784e-19 * fConst4) - 9.82581377054064e-13);
	fConst602 = ((3.1207716962705e-20 * fConst4) - 6.07601196935255e-13);
	fConst603 = (5.71177616349841e-13 - (3.05424386691166e-20 * fConst4));
	fConst604 = (7.25855106058331e-13 - fConst594);
	fConst605 = ((1.01146314580283e-19 * fConst4) - 6.95879162219592e-12);
	fConst606 = (2.24852474896395e-11 - (1.13514525653509e-19 * fConst4));
	fConst607 = (3.35163872308864e-10 + (fConst1 * (0 - (3.22307947619052e-15 + fConst576))));
	fConst608 = (fConst1 * (1.18299457577331e-13 + (fConst1 * (3.42973787408197e-17 + fConst95))));
	fConst609 = (2.95748643943327e-09 + (fConst1 * ((fConst1 * (0 - (4.13692256752265e-17 + fConst97))) - 3.01805576171286e-13)));
	fConst610 = (fConst1 * (5.90550892226034e-18 + (fConst1 * (5.6810238715616e-21 - fConst276))));
	fConst611 = ((fConst1 * ((fConst1 * (fConst278 - 6.8576094559212e-21)) - 1.14915525253223e-16)) - 1.67038834099191e-14);
	fConst612 = ((fConst1 * ((fConst1 * (0 - (1.09061534669288e-17 + fConst10))) - 1.44172194219261e-14)) - 1.23246525803292e-10);
	fConst613 = (6.35116259009417e-09 + (fConst1 * ((fConst1 * (0 - (2.43081624211112e-17 + fConst97))) - 1.88980093869201e-13)));
	fConst614 = (fConst1 * (1.73969790554898e-12 + (fConst1 * (1.25533817347765e-15 + fConst103))));
	fConst615 = (4.34924476387245e-08 + (fConst1 * ((fConst1 * (0 - (2.51841981192082e-15 + fConst105))) - 5.68992555780471e-12)));
	fConst616 = (fConst1 * (8.68457194450051e-17 + (fConst1 * (8.07052817175794e-20 - fConst306))));
	fConst617 = ((fConst1 * ((fConst1 * (fConst308 - 1.40410322077696e-19)) - 1.64734639017249e-15)) - 2.45645344263516e-13);
	fConst618 = ((fConst1 * ((fConst1 * ((fConst1 * (fConst278 - 7.80192924067626e-21)) - 2.2174073102522e-16)) - 1.51900299233814e-13)) - 1.81244890887194e-09);
	fConst619 = (fConst1 * (fConst306 - 8.11228092149111e-20));
	fConst620 = (1.56589512599301e-15 + (fConst1 * (1.40996697694949e-19 - fConst308)));
	fConst621 = (1.97692943812384e-09 + (fConst1 * (1.4279440408746e-13 + (fConst1 * (2.15889348849432e-16 + (fConst1 * (7.63560966727914e-21 - fConst278)))))));
	fConst622 = ((fConst1 * (1.81463776514583e-13 + (fConst1 * (2.35521643602152e-17 + fConst97)))) - 6.27319249305457e-09);
	fConst623 = (fConst1 * ((fConst1 * (0 - (1.21416996224074e-15 + fConst114))) - 1.73969790554898e-12));
	fConst624 = ((fConst1 * (5.62131187240986e-12 + (fConst1 * (2.41920442283987e-15 + fConst116)))) - 4.34924476387245e-08);
	fConst625 = (2.68131097847092e-10 + fConst551);
	fConst626 = (2.36598915154661e-09 + fConst548);
	fConst627 = (fConst4 * (1.13620477431232e-20 + fConst192));
	fConst628 = (3.34077668198382e-14 + (fConst4 * (0 - (1.37152189118424e-20 + fConst194))));
	fConst629 = (fConst555 - 9.85972206426334e-11);
	fConst630 = (5.08093007207534e-09 + fConst557);
	fConst631 = (3.47939581109796e-08 + fConst559);
	fConst632 = (fConst4 * (1.61410563435159e-19 + fConst225));
	fConst633 = (4.91290688527032e-13 + (fConst4 * (0 - (2.80820644155392e-19 + fConst227))));
	fConst634 = ((fConst1 * (3.03800598467627e-13 + (fConst4 * (0 - (1.56038584813525e-20 + fConst194))))) - 1.44995912709755e-09);
	fConst635 = (0 - (1.62245618429822e-19 + fConst225));
	fConst636 = (2.81993395389897e-19 + fConst227);
	fConst637 = (1.58154355049907e-09 + (fConst1 * ((fConst4 * (1.52712193345583e-20 + fConst194)) - 2.8558880817492e-13)));
	fConst638 = (fConst571 - 3.47939581109796e-08);
	fConst639 = (fConst569 - 5.01855399444366e-09);
	fConst640 = (6.70327744617729e-11 + (fConst1 * (3.22307947619052e-15 + fConst93)));
	fConst641 = (fConst1 * ((fConst1 * (0 - (1.14324595802732e-17 + fConst95))) - 1.18299457577331e-13));
	fConst642 = (5.91497287886653e-10 + (fConst1 * (3.01805576171286e-13 + (fConst1 * (1.37897418917422e-17 + fConst97)))));
	fConst643 = (fConst1 * ((fConst1 * (0 - (5.6810238715616e-21 + fConst21))) - 1.96850297408678e-18));
	fConst644 = (1.67038834099191e-14 + (fConst1 * (3.83051750844075e-17 + (fConst1 * (6.8576094559212e-21 + fConst23)))));
	fConst645 = ((fConst1 * (1.44172194219261e-14 + (fConst1 * (3.63538448897625e-18 + fConst10)))) - 2.46493051606583e-11);
	fConst646 = (1.27023251801883e-09 + (fConst1 * (1.88980093869201e-13 + (fConst1 * (8.10272080703706e-18 + fConst97)))));
	fConst647 = (fConst1 * ((fConst1 * (0 - (4.18446057825885e-16 + fConst103))) - 1.73969790554898e-12));
	fConst648 = (8.6984895277449e-09 + (fConst1 * (5.68992555780471e-12 + (fConst1 * (8.39473270640275e-16 + fConst105)))));
	fConst649 = (fConst1 * ((fConst1 * (0 - (8.07052817175794e-20 + fConst52))) - 2.8948573148335e-17));
	fConst650 = (2.45645344263516e-13 + (fConst1 * (5.49115463390831e-16 + (fConst1 * (1.40410322077696e-19 + fConst54)))));
	fConst651 = ((fConst1 * (1.51900299233814e-13 + (fConst1 * (7.39135770084066e-17 + (fConst1 * (7.80192924067626e-21 + fConst23)))))) - 3.62489781774387e-10);
	fConst652 = (fConst1 * (8.11228092149111e-20 + fConst52));
	fConst653 = ((fConst1 * (0 - (1.40996697694949e-19 + fConst54))) - 5.21965041997671e-16);
	fConst654 = (3.95385887624768e-10 + (fConst1 * ((fConst1 * ((fConst1 * (0 - (7.63560966727914e-21 + fConst23))) - 7.19631162831439e-17)) - 1.4279440408746e-13)));
	fConst655 = ((fConst1 * ((fConst1 * (0 - (7.85072145340506e-18 + fConst97))) - 1.81463776514583e-13)) - 1.25463849861091e-09);
	fConst656 = (fConst1 * (1.73969790554898e-12 + (fConst1 * (4.04723320746915e-16 + fConst114))));
	fConst657 = ((fConst1 * ((fConst1 * (0 - (8.06401474279956e-16 + fConst116))) - 5.62131187240986e-12)) - 8.6984895277449e-09);
	clear_state_f();
}

void Dsp::init_static(uint32_t samplingFreq, PluginLV2 *p)
{
	static_cast<Dsp*>(p)->init(samplingFreq);
}

double always_inline Dsp::symclip(double x) {
    double f = fabs(x);
    f = (f - clip.low) * clip.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = clip.data[0];
    } else if (i >= clip.size-1) {
        f = clip.data[clip.size-1];
    } else {
	f -= i;
	f = clip.data[i]*(1-f) + clip.data[i+1]*f;
    }
    return copysign(f, -x);
}

void always_inline Dsp::compute(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0)
{
#define fslider0 (*fslider0_)
#define fslider1 (*fslider1_)
#define fslider2 (*fslider2_)
#define fslider3 (*fslider3_)
#define fslider4 (*fslider4_)
	double 	fSlow0 = (0.007000000000000006 * double(fslider0));
	double 	fSlow1 = (0.007000000000000006 * double(fslider1));
	double 	fSlow2 = (0.007000000000000006 * double(fslider2));
	double 	fSlow3 = (0.007000000000000006 * double(fslider3));
	double 	fSlow4 = (0.007000000000000006 * (1 - double(fslider4)));
	for (int i=0; i<count; i++) {
		fRec0[0] = ((0.993 * fRec0[1]) + fSlow0);
		double fTemp0 = ((0 - (2.8645140609571137e-09 * fRec0[0])) - 8.68034563926398e-11);
		fRec3[0] = ((0.993 * fRec3[1]) + fSlow1);
		fRec4[0] = ((0.993 * fRec4[1]) + fSlow2);
		fRec5[0] = ((0.993 * fRec5[1]) + fSlow3);
		fRec6[0] = ((0.993 * fRec6[1]) + fSlow4);
		double fTemp1 = (1.65189060762527e-07 + (((fRec6[0] * (2.42925089356658e-06 + (((fRec6[0] * (((fRec5[0] * ((fConst1 * ((((fRec3[0] * (fConst92 + (fConst91 * fRec3[0]))) + (fRec5[0] * (fConst90 + (fConst1 * ((fRec3[0] * (fConst89 + (fConst88 * fRec3[0]))) + (fRec4[0] * (fConst87 + (fConst1 * (fRec3[0] * (fConst86 + (fConst85 * fRec3[0]))))))))))) + (fRec4[0] * (fConst84 + (fConst1 * (fRec3[0] * (fConst83 + (fConst82 * fRec3[0]))))))) + fConst81)) - 1.97692943812384e-07)) + (fConst1 * (((fRec3[0] * (fConst80 + (fConst79 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst78 + (fConst1 * (fRec3[0] * (fConst77 + (fConst76 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst75 + (fConst74 * fRec3[0]))))) + fConst73))) + fConst72))) - 2.01804957043682e-06)) + (fRec5[0] * (2.3881307612536e-07 + (fConst1 * ((((fRec3[0] * (fConst71 + (fConst70 * fRec3[0]))) + (fRec5[0] * (fConst69 + (fConst1 * ((fRec3[0] * (fConst68 + (fConst66 * fRec3[0]))) + (fRec4[0] * (fConst64 + (fConst1 * (fRec3[0] * (fConst63 + (fConst62 * fRec3[0]))))))))))) + (fRec4[0] * (fConst61 + (fConst1 * (fRec3[0] * (fConst60 + (fConst58 * fRec3[0]))))))) + fConst56))))) + (fConst1 * (((fRec3[0] * (fConst55 + (fConst53 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst51 + (fConst1 * (fRec3[0] * (fConst50 + (fConst49 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst48 + (fConst46 * fRec3[0]))))) + fConst44))) + fConst43))))) + (fRec5[0] * (1.62392891765245e-08 + (fConst1 * ((((fRec3[0] * (fConst42 + (fConst41 * fRec3[0]))) + (fRec5[0] * (fConst40 + (fConst1 * ((fRec3[0] * (fConst39 + (fConst37 * fRec3[0]))) + (fRec4[0] * (fConst35 + (fConst1 * (fRec3[0] * (fConst34 + (fConst33 * fRec3[0]))))))))))) + (fRec4[0] * (fConst32 + (fConst1 * (fRec3[0] * (fConst30 + (fConst28 * fRec3[0]))))))) + fConst26))))) + (fConst1 * (((fRec3[0] * (fConst24 + (fConst22 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst20 + (fConst1 * (fRec3[0] * (fConst19 + (fConst18 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst17 + (fConst15 * fRec3[0]))))) + fConst13))) + fConst11))));
		double fTemp2 = ((0 - (8.68034563926398e-09 * fRec0[0])) - 8.68034563926398e-11);
		double fTemp3 = (double)input0[i];
		fVec0[0] = fTemp3;
		fRec10[0] = (fConst545 * ((fVec0[0] - fVec0[1]) + (fConst9 * fRec10[1])));
		fRec9[0] = (fRec10[0] - (fConst7 * ((fConst5 * fRec9[1]) + (fConst3 * fRec9[2]))));
		double fTemp4 = symclip((fConst546 * (((fRec9[0] * fTemp2) + (fRec9[1] * (1.7360691278528e-10 + (1.7360691278528e-08 * fRec0[0])))) + (fRec9[2] * fTemp2))));
		fVec1[0] = fTemp4;
		fRec8[0] = (fConst545 * ((fVec1[0] - fVec1[1]) + (fConst9 * fRec8[1])));
		fRec7[0] = (fRec8[0] - (((((((fRec7[1] * (9.91134364575163e-07 + (((fRec6[0] * (1.45755053613994e-05 + (((fRec6[0] * (((fRec5[0] * ((fConst1 * ((((fRec3[0] * (fConst544 + (fConst543 * fRec3[0]))) + (fRec5[0] * (fConst542 + (fConst1 * ((fRec3[0] * (fConst541 + (fConst540 * fRec3[0]))) + (fRec4[0] * (fConst539 + (fConst4 * (fRec3[0] * (fConst538 + (fConst537 * fRec3[0]))))))))))) + (fRec4[0] * (fConst536 + (fConst1 * (fRec3[0] * (fConst535 + (fConst534 * fRec3[0]))))))) + fConst533)) - 1.1861576628743e-06)) + (fConst1 * (((fRec3[0] * (fConst532 + (fConst531 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst530 + (fConst1 * (fRec3[0] * (fConst529 + (fConst528 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst527 + (fConst526 * fRec3[0]))))) + fConst525))) + fConst524))) - 1.21082974226209e-05)) + (fRec5[0] * (1.43287845675216e-06 + (fConst1 * ((((fRec3[0] * (fConst523 + (fConst522 * fRec3[0]))) + (fRec5[0] * (fConst521 + (fConst1 * ((fRec3[0] * (fConst520 + (fConst519 * fRec3[0]))) + (fRec4[0] * (fConst518 + (fConst4 * (fRec3[0] * (fConst517 + (fConst516 * fRec3[0]))))))))))) + (fRec4[0] * (fConst515 + (fConst1 * (fRec3[0] * (fConst514 + (fConst513 * fRec3[0]))))))) + fConst512))))) + (fConst1 * (((fRec3[0] * (fConst511 + (fConst510 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst509 + (fConst1 * (fRec3[0] * (fConst508 + (fConst507 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst506 + (fConst505 * fRec3[0]))))) + fConst504))) + fConst503))))) + (fRec5[0] * (9.74357350591468e-08 + (fConst1 * ((((fRec3[0] * (fConst502 + (fConst501 * fRec3[0]))) + (fRec5[0] * (fConst500 + (fConst1 * ((fRec3[0] * (fConst499 + (fConst498 * fRec3[0]))) + (fRec4[0] * (fConst497 + (fConst4 * (fRec3[0] * (fConst496 + (fConst495 * fRec3[0]))))))))))) + (fRec4[0] * (fConst494 + (fConst1 * (fRec3[0] * (fConst493 + (fConst492 * fRec3[0]))))))) + fConst491))))) + (fConst1 * (((fRec3[0] * (fConst490 + (fConst489 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst488 + (fConst1 * (fRec3[0] * (fConst487 + (fConst486 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst485 + (fConst484 * fRec3[0]))))) + fConst483))) + fConst482))))) + (fRec7[2] * (2.47783591143791e-06 + (((fRec6[0] * (3.64387634034986e-05 + (((fRec6[0] * (((fRec5[0] * ((fConst1 * ((((fRec3[0] * (fConst481 + (fConst480 * fRec3[0]))) + (fRec5[0] * (fConst479 + (fConst1 * ((fRec3[0] * (fConst478 + (fConst477 * fRec3[0]))) + (fRec4[0] * (fConst476 + (fConst1 * (fRec3[0] * (fConst475 + (fConst474 * fRec3[0]))))))))))) + (fRec4[0] * (fConst473 + (fConst1 * (fRec3[0] * (fConst472 + (fConst471 * fRec3[0]))))))) + fConst470)) - 2.96539415718576e-06)) + (fConst1 * (((fRec3[0] * (fConst469 + (fConst468 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst467 + (fConst1 * (fRec3[0] * (fConst466 + (fConst465 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst464 + (fConst463 * fRec3[0]))))) + fConst462))) + fConst461))) - 3.02707435565522e-05)) + (fRec5[0] * (3.5821961418804e-06 + (fConst1 * ((((fRec3[0] * (fConst460 + (fConst459 * fRec3[0]))) + (fRec5[0] * (fConst458 + (fConst1 * ((fRec3[0] * (fConst457 + (fConst456 * fRec3[0]))) + (fRec4[0] * (fConst455 + (fConst1 * (fRec3[0] * (fConst454 + (fConst453 * fRec3[0]))))))))))) + (fRec4[0] * (fConst452 + (fConst1 * (fRec3[0] * (fConst451 + (fConst450 * fRec3[0]))))))) + fConst449))))) + (fConst1 * (((fRec3[0] * (fConst448 + (fConst447 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst446 + (fConst1 * (fRec3[0] * (fConst445 + (fConst444 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst443 + (fConst442 * fRec3[0]))))) + fConst441))) + fConst440))))) + (fRec5[0] * (2.43589337647867e-07 + (fConst1 * ((((fRec3[0] * (fConst439 + (fConst438 * fRec3[0]))) + (fRec5[0] * (fConst437 + (fConst1 * ((fRec3[0] * (fConst436 + (fConst435 * fRec3[0]))) + (fRec4[0] * (fConst434 + (fConst1 * (fRec3[0] * (fConst433 + (fConst432 * fRec3[0]))))))))))) + (fRec4[0] * (fConst431 + (fConst1 * (fRec3[0] * (fConst430 + (fConst429 * fRec3[0]))))))) + fConst428))))) + (fConst1 * (((fRec3[0] * (fConst427 + (fConst426 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst425 + (fConst1 * (fRec3[0] * (fConst424 + (fConst423 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst422 + (fConst421 * fRec3[0]))))) + fConst420))) + fConst419)))))) + (fRec7[3] * (3.30378121525054e-06 + (((fRec6[0] * (4.85850178713315e-05 + (((fRec6[0] * (((fRec5[0] * ((fConst4 * ((((fRec3[0] * (fConst418 + (fConst417 * fRec3[0]))) + (fRec5[0] * (fConst416 + ((fRec3[0] * (fConst415 + (fConst4 * (0 - (4.00202889709136e-20 * fRec3[0]))))) + (fRec4[0] * (fConst414 + (fConst4 * (fRec3[0] * (fConst413 + (fConst412 * fRec3[0])))))))))) + (fRec4[0] * ((fRec3[0] * (fConst411 + (fConst410 * fRec3[0]))) + fConst409))) + fConst408)) - 3.95385887624768e-06)) + (fConst4 * (((fRec3[0] * (fConst407 + (fConst406 * fRec3[0]))) + (fRec4[0] * (((fRec3[0] * (fConst405 + (fConst404 * fRec3[0]))) + (fRec4[0] * ((fRec3[0] * (fConst403 + (fConst402 * fRec3[0]))) + fConst401))) + fConst400))) + fConst399))) - 4.03609914087363e-05)) + (fRec5[0] * (4.7762615225072e-06 + (fConst4 * (fConst398 + (((fRec3[0] * (fConst397 + (fConst396 * fRec3[0]))) + (fRec5[0] * (((fRec3[0] * (fConst395 + (fConst394 * fRec3[0]))) + (fRec4[0] * (fConst393 + (fConst4 * (fRec3[0] * (fConst392 + (fConst391 * fRec3[0]))))))) + fConst390))) + (fRec4[0] * ((fRec3[0] * (fConst389 + (fConst387 * fRec3[0]))) + fConst385)))))))) + (fConst4 * (fConst384 + ((fRec3[0] * (fConst383 + (fConst382 * fRec3[0]))) + (fRec4[0] * (((fRec3[0] * (fConst381 + (fConst380 * fRec3[0]))) + (fRec4[0] * ((fRec3[0] * (fConst379 + (fConst377 * fRec3[0]))) + fConst375))) + fConst374)))))))) + (fRec5[0] * (3.24785783530489e-07 + (fConst4 * (fConst373 + (((fRec3[0] * (fConst372 + (fConst371 * fRec3[0]))) + (fRec5[0] * (((fRec3[0] * (fConst370 + (fConst369 * fRec3[0]))) + (fRec4[0] * (fConst368 + (fConst4 * (fRec3[0] * (fConst367 + (fConst366 * fRec3[0]))))))) + fConst365))) + (fRec4[0] * (fConst363 + (fRec3[0] * (fConst362 + (fConst360 * fRec3[0]))))))))))) + (fConst4 * (fConst358 + ((fRec3[0] * (fConst356 + (fConst355 * fRec3[0]))) + (fRec4[0] * (fConst354 + ((fRec3[0] * (fConst353 + (fConst352 * fRec3[0]))) + (fRec4[0] * ((fRec3[0] * (fConst351 + (fConst349 * fRec3[0]))) + fConst347)))))))))))) + (fRec7[4] * (2.47783591143791e-06 + (((fRec6[0] * (3.64387634034986e-05 + (((fRec6[0] * (((fRec5[0] * ((fConst1 * ((((fRec3[0] * (fConst346 + (fConst345 * fRec3[0]))) + (fRec5[0] * (fConst344 + (fConst1 * ((fRec3[0] * (fConst343 + (fConst342 * fRec3[0]))) + (fRec4[0] * (fConst341 + (fConst1 * (fRec3[0] * (fConst340 + (fConst339 * fRec3[0]))))))))))) + (fRec4[0] * (fConst338 + (fConst1 * (fRec3[0] * (fConst337 + (fConst336 * fRec3[0]))))))) + fConst335)) - 2.96539415718576e-06)) + (fConst1 * (((fRec3[0] * (fConst334 + (fConst333 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst332 + (fConst1 * (fRec3[0] * (fConst331 + (fConst330 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst329 + (fConst328 * fRec3[0]))))) + fConst327))) + fConst326))) - 3.02707435565522e-05)) + (fRec5[0] * (3.5821961418804e-06 + (fConst1 * ((((fRec3[0] * (fConst325 + (fConst324 * fRec3[0]))) + (fRec5[0] * (fConst323 + (fConst1 * ((fRec3[0] * (fConst322 + (fConst320 * fRec3[0]))) + (fRec4[0] * (fConst318 + (fConst1 * (fRec3[0] * (fConst317 + (fConst316 * fRec3[0]))))))))))) + (fRec4[0] * (fConst315 + (fConst1 * (fRec3[0] * (fConst314 + (fConst312 * fRec3[0]))))))) + fConst310))))) + (fConst1 * (((fRec3[0] * (fConst309 + (fConst307 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst305 + (fConst1 * (fRec3[0] * (fConst304 + (fConst303 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst302 + (fConst300 * fRec3[0]))))) + fConst298))) + fConst297))))) + (fRec5[0] * (2.43589337647867e-07 + (fConst1 * ((((fRec3[0] * (fConst296 + (fConst295 * fRec3[0]))) + (fRec5[0] * (fConst294 + (fConst1 * ((fRec3[0] * (fConst293 + (fConst291 * fRec3[0]))) + (fRec4[0] * (fConst289 + (fConst1 * (fRec3[0] * (fConst288 + (fConst287 * fRec3[0]))))))))))) + (fRec4[0] * (fConst286 + (fConst1 * (fRec3[0] * (fConst284 + (fConst282 * fRec3[0]))))))) + fConst280))))) + (fConst1 * (((fRec3[0] * (fConst279 + (fConst277 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst275 + (fConst1 * (fRec3[0] * (fConst274 + (fConst273 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst272 + (fConst270 * fRec3[0]))))) + fConst268))) + fConst266)))))) + (fRec7[5] * (9.91134364575163e-07 + (((fRec6[0] * (1.45755053613994e-05 + (((fRec6[0] * (((fRec5[0] * ((fConst1 * ((((fRec3[0] * (fConst265 + (fConst264 * fRec3[0]))) + (fRec5[0] * (fConst263 + (fConst1 * ((fRec3[0] * (fConst262 + (fConst261 * fRec3[0]))) + (fRec4[0] * (fConst260 + (fConst4 * (fRec3[0] * (fConst259 + (fConst258 * fRec3[0]))))))))))) + (fRec4[0] * (fConst257 + (fConst1 * (fRec3[0] * (fConst256 + (fConst255 * fRec3[0]))))))) + fConst254)) - 1.1861576628743e-06)) + (fConst1 * (((fRec3[0] * (fConst253 + (fConst252 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst251 + (fConst1 * (fRec3[0] * (fConst250 + (fConst249 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst248 + (fConst247 * fRec3[0]))))) + fConst246))) + fConst245))) - 1.21082974226209e-05)) + (fRec5[0] * (1.43287845675216e-06 + (fConst1 * ((((fRec3[0] * (fConst244 + (fConst243 * fRec3[0]))) + (fRec5[0] * (fConst242 + (fConst1 * ((fRec3[0] * (fConst241 + (fConst239 * fRec3[0]))) + (fRec4[0] * (fConst237 + (fConst4 * (fRec3[0] * (fConst236 + (fConst235 * fRec3[0]))))))))))) + (fRec4[0] * (fConst234 + (fConst1 * (fRec3[0] * (fConst233 + (fConst231 * fRec3[0]))))))) + fConst229))))) + (fConst1 * (((fRec3[0] * (fConst228 + (fConst226 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst224 + (fConst1 * (fRec3[0] * (fConst223 + (fConst222 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst221 + (fConst219 * fRec3[0]))))) + fConst217))) + fConst216))))) + (fRec5[0] * (9.74357350591468e-08 + (fConst1 * ((((fRec3[0] * (fConst215 + (fConst214 * fRec3[0]))) + (fRec5[0] * (fConst213 + (fConst1 * ((fRec3[0] * (fConst211 + (fConst209 * fRec3[0]))) + (fRec4[0] * (fConst207 + (fConst4 * (fRec3[0] * (fConst206 + (fConst205 * fRec3[0]))))))))))) + (fRec4[0] * (fConst204 + (fConst1 * (fRec3[0] * (fConst202 + (fConst200 * fRec3[0]))))))) + fConst198))))) + (fConst1 * (((fRec3[0] * (fConst195 + (fConst193 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst191 + (fConst1 * (fRec3[0] * (fConst190 + (fConst189 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst188 + (fConst186 * fRec3[0]))))) + fConst184))) + fConst182)))))) + (fRec7[6] * (1.65189060762527e-07 + (((fRec6[0] * (2.42925089356658e-06 + (((fRec6[0] * (((fRec5[0] * ((fConst1 * ((((fRec3[0] * (fConst180 + (fConst179 * fRec3[0]))) + (fRec5[0] * (fConst178 + (fConst1 * ((fRec3[0] * (fConst177 + (fConst176 * fRec3[0]))) + (fRec4[0] * (fConst175 + (fConst1 * (fRec3[0] * (fConst174 + (fConst173 * fRec3[0]))))))))))) + (fRec4[0] * (fConst172 + (fConst1 * (fRec3[0] * (fConst171 + (fConst170 * fRec3[0]))))))) + fConst169)) - 1.97692943812384e-07)) + (fConst1 * (((fRec3[0] * (fConst168 + (fConst167 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst166 + (fConst1 * (fRec3[0] * (fConst165 + (fConst164 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst163 + (fConst162 * fRec3[0]))))) + fConst161))) + fConst160))) - 2.01804957043682e-06)) + (fRec5[0] * (2.3881307612536e-07 + (fConst1 * ((((fRec3[0] * (fConst159 + (fConst158 * fRec3[0]))) + (fRec5[0] * (fConst157 + (fConst1 * ((fRec3[0] * (fConst156 + (fConst155 * fRec3[0]))) + (fRec4[0] * (fConst154 + (fConst1 * (fRec3[0] * (fConst153 + (fConst152 * fRec3[0]))))))))))) + (fRec4[0] * (fConst151 + (fConst1 * (fRec3[0] * (fConst150 + (fConst149 * fRec3[0]))))))) + fConst148))))) + (fConst1 * (((fRec3[0] * (fConst147 + (fConst146 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst145 + (fConst1 * (fRec3[0] * (fConst144 + (fConst143 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst142 + (fConst141 * fRec3[0]))))) + fConst140))) + fConst139))))) + (fRec5[0] * (1.62392891765245e-08 + (fConst1 * ((((fRec3[0] * (fConst138 + (fConst137 * fRec3[0]))) + (fRec5[0] * (fConst136 + (fConst1 * ((fRec3[0] * (fConst135 + (fConst134 * fRec3[0]))) + (fRec4[0] * (fConst133 + (fConst1 * (fRec3[0] * (fConst132 + (fConst131 * fRec3[0]))))))))))) + (fRec4[0] * (fConst130 + (fConst1 * (fRec3[0] * (fConst129 + (fConst128 * fRec3[0]))))))) + fConst127))))) + (fConst1 * (((fRec3[0] * (fConst126 + (fConst125 * fRec3[0]))) + (fRec4[0] * (((fRec4[0] * (fConst124 + (fConst1 * (fRec3[0] * (fConst123 + (fConst122 * fRec3[0])))))) + (fConst1 * (fRec3[0] * (fConst121 + (fConst120 * fRec3[0]))))) + fConst119))) + fConst118)))))) / fTemp1));
		double fTemp5 = (fConst550 * fRec3[0]);
		double fTemp6 = (fConst561 * fRec3[0]);
		double fTemp7 = (fConst573 * fRec3[0]);
		double fTemp8 = ((fRec4[0] * (((((((fRec7[0] * (((fRec6[0] * (((fRec6[0] * (((fConst1 * ((fRec3[0] * (fConst657 + (fConst656 * fRec3[0]))) + fConst655)) - 1.97692943812384e-06) + (fConst1 * (fRec5[0] * (fConst654 + (fConst4 * (fRec3[0] * (fConst653 + (fConst652 * fRec3[0]))))))))) + (fConst1 * (fRec5[0] * (fConst651 + (fConst1 * (fRec3[0] * (fConst650 + (fConst649 * fRec3[0])))))))) + (1.97692943812384e-06 + (fConst1 * ((fRec3[0] * (fConst648 + (fConst647 * fRec3[0]))) + fConst646))))) + (fConst1 * (fRec5[0] * (fConst645 + (fConst1 * (fRec3[0] * (fConst644 + (fConst643 * fRec3[0])))))))) + (1.34431201792421e-07 + (fConst1 * ((fRec3[0] * (fConst642 + (fConst641 * fRec3[0]))) + fConst640))))) + (fRec7[1] * (((fRec6[0] * (((fRec6[0] * (((fConst1 * (fConst639 + (fRec3[0] * (fConst638 + fTemp7)))) - 1.1861576628743e-05) + (fConst1 * (fRec5[0] * (fConst637 + (fConst567 * (fRec3[0] * (fConst636 + (fConst635 * fRec3[0]))))))))) + (fConst1 * (fRec5[0] * (fConst634 + (fConst1 * (fRec3[0] * (fConst633 + (fConst632 * fRec3[0])))))))) + (1.1861576628743e-05 + (fConst1 * ((fRec3[0] * (fConst631 + fTemp6)) + fConst630))))) + (fConst1 * (fRec5[0] * (fConst629 + (fConst1 * (fRec3[0] * (fConst628 + (fConst627 * fRec3[0])))))))) + (8.06587210754527e-07 + (fConst1 * ((fRec3[0] * (fConst626 + fTemp5)) + fConst625)))))) + (fRec7[2] * (((fRec6[0] * (((fRec6[0] * (((fConst1 * ((fRec3[0] * (fConst624 + (fConst623 * fRec3[0]))) + fConst622)) - 2.96539415718576e-05) + (fConst1 * (fRec5[0] * (fConst621 + (fConst4 * (fRec3[0] * (fConst620 + (fConst619 * fRec3[0]))))))))) + (fConst1 * (fRec5[0] * (fConst618 + (fConst1 * (fRec3[0] * (fConst617 + (fConst616 * fRec3[0])))))))) + (2.96539415718576e-05 + (fConst1 * ((fRec3[0] * (fConst615 + (fConst614 * fRec3[0]))) + fConst613))))) + (fConst1 * (fRec5[0] * (fConst612 + (fConst1 * (fRec3[0] * (fConst611 + (fConst610 * fRec3[0])))))))) + (2.01646802688632e-06 + (fConst1 * ((fRec3[0] * (fConst609 + (fConst608 * fRec3[0]))) + fConst607)))))) + (fRec7[3] * (((fRec6[0] * (((fRec6[0] * (((fConst4 * ((fRec3[0] * (fConst606 + (fConst605 * fRec3[0]))) + fConst604)) - 3.95385887624768e-05) + (fConst4 * (fRec5[0] * (fConst603 + (fConst4 * (fRec3[0] * ((3.24491236859645e-19 * fRec3[0]) - 5.63986790779795e-19)))))))) + (fConst4 * (fRec5[0] * (fConst602 + (fRec3[0] * (fConst601 + (fConst4 * (0 - (3.22821126870318e-19 * fRec3[0]))))))))) + (3.95385887624768e-05 + (fConst4 * (fConst600 + (fRec3[0] * (fConst599 + (fConst598 * fRec3[0])))))))) + (fConst4 * (fRec5[0] * (fConst597 + (fRec3[0] * (fConst596 + (fConst4 * (0 - (2.27240954862464e-20 * fRec3[0]))))))))) + (2.68862403584842e-06 + (fConst4 * ((fRec3[0] * (fConst595 + (fConst593 * fRec3[0]))) - 1.28923179047621e-14)))))) + (fRec7[4] * (((fRec6[0] * (((fRec6[0] * (((fConst1 * ((fRec3[0] * (fConst592 + (fConst591 * fRec3[0]))) + fConst590)) - 2.96539415718576e-05) + (fConst1 * (fRec5[0] * (fConst589 + (fConst4 * (fRec3[0] * (fConst588 + (fConst587 * fRec3[0]))))))))) + (fConst1 * (fRec5[0] * (fConst586 + (fConst1 * (fRec3[0] * (fConst585 + (fConst584 * fRec3[0])))))))) + (2.96539415718576e-05 + (fConst1 * ((fRec3[0] * (fConst583 + (fConst582 * fRec3[0]))) + fConst581))))) + (fConst1 * (fRec5[0] * (fConst580 + (fConst1 * (fRec3[0] * (fConst579 + (fConst578 * fRec3[0])))))))) + (2.01646802688632e-06 + (fConst1 * (fConst577 + (fRec3[0] * (fConst575 + (fConst574 * fRec3[0]))))))))) + (fRec7[5] * (((fRec6[0] * (((fRec6[0] * (((fConst1 * ((fRec3[0] * (fTemp7 + fConst572)) + fConst570)) - 1.1861576628743e-05) + (fConst1 * (fRec5[0] * (fConst568 + (fConst567 * (fRec3[0] * (fConst566 + (fConst565 * fRec3[0]))))))))) + (fConst1 * (fRec5[0] * (fConst564 + (fConst1 * (fRec3[0] * (fConst563 + (fConst562 * fRec3[0])))))))) + (1.1861576628743e-05 + (fConst1 * ((fRec3[0] * (fTemp6 + fConst560)) + fConst558))))) + (fConst1 * (fRec5[0] * (fConst556 + (fConst1 * (fRec3[0] * (fConst554 + (fConst553 * fRec3[0])))))))) + (8.06587210754527e-07 + (fConst1 * (fConst552 + (fRec3[0] * (fTemp5 + fConst549)))))))) + (fRec7[6] * (((fRec6[0] * (((fRec6[0] * (((fConst1 * ((fRec3[0] * (fConst117 + (fConst115 * fRec3[0]))) + fConst113)) - 1.97692943812384e-06) + (fConst1 * (fRec5[0] * (fConst112 + (fConst4 * (fRec3[0] * (fConst111 + (fConst110 * fRec3[0]))))))))) + (fConst1 * (fRec5[0] * (fConst109 + (fConst1 * (fRec3[0] * (fConst108 + (fConst107 * fRec3[0])))))))) + (1.97692943812384e-06 + (fConst1 * ((fRec3[0] * (fConst106 + (fConst104 * fRec3[0]))) + fConst102))))) + (fConst1 * (fRec5[0] * (fConst101 + (fConst1 * (fRec3[0] * (fConst100 + (fConst99 * fRec3[0])))))))) + (1.34431201792421e-07 + (fConst1 * ((fRec3[0] * (fConst98 + (fConst96 * fRec3[0]))) + fConst94))))))) / fTemp1);
		fVec2[0] = fTemp8;
		fRec2[0] = (fConst545 * ((fVec2[0] - fVec2[1]) + (fConst9 * fRec2[1])));
		fRec1[0] = (fRec2[0] - (fConst7 * ((fConst5 * fRec1[1]) + (fConst3 * fRec1[2]))));
		output0[i] = (FAUSTFLOAT)(fConst546 * (((fRec1[0] * fTemp0) + (fRec1[1] * (1.7360691278528e-10 + (5.729028121914241e-09 * fRec0[0])))) + (fRec1[2] * fTemp0)));
		// post processing
		fRec1[2] = fRec1[1]; fRec1[1] = fRec1[0];
		fRec2[1] = fRec2[0];
		fVec2[1] = fVec2[0];
		for (int i=6; i>0; i--) fRec7[i] = fRec7[i-1];
		fRec8[1] = fRec8[0];
		fVec1[1] = fVec1[0];
		fRec9[2] = fRec9[1]; fRec9[1] = fRec9[0];
		fRec10[1] = fRec10[0];
		fVec0[1] = fVec0[0];
		fRec6[1] = fRec6[0];
		fRec5[1] = fRec5[0];
		fRec4[1] = fRec4[0];
		fRec3[1] = fRec3[0];
		fRec0[1] = fRec0[0];
	}
#undef fslider0
#undef fslider1
#undef fslider2
#undef fslider3
#undef fslider4
}

void __rt_func Dsp::compute_static(int count, FAUSTFLOAT *input0, FAUSTFLOAT *output0, PluginLV2 *p)
{
	static_cast<Dsp*>(p)->compute(count, input0, output0);
}


void Dsp::connect(uint32_t port,void* data)
{
	switch ((PortIndex)port)
	{
	case BASS: 
		fslider4_ = (float*)data; // , 0.5, 0.0, 1.0, 0.01 
		break;
	case GAIN: 
		fslider0_ = (float*)data; // , 0.5, 0.0, 1.0, 0.01 
		break;
	case LEVEL: 
		fslider2_ = (float*)data; // , 0.5, 0.0, 1.0, 0.01 
		break;
	case MID: 
		fslider1_ = (float*)data; // , 0.5, 0.0, 1.0, 0.01 
		break;
	case TREBLE: 
		fslider3_ = (float*)data; // , 0.5, 0.0, 1.0, 0.01 
		break;
	default:
		break;
	}
}

void Dsp::connect_static(uint32_t port,void* data, PluginLV2 *p)
{
	static_cast<Dsp*>(p)->connect(port, data);
}


PluginLV2 *plugin() {
	return new Dsp();
}

void Dsp::del_instance(PluginLV2 *p)
{
	delete static_cast<Dsp*>(p);
}

/*
typedef enum
{
   BASS, 
   GAIN, 
   LEVEL, 
   MID, 
   TREBLE, 
} PortIndex;
*/

} // end namespace guvnor
