(use-modules (gnucash gnc-module))
(gnc:module-begin-syntax (gnc:module-load "gnucash/app-utils" 0))
(use-modules (gnucash engine test test-extras))

(define (run-test)
  (and (test test-weeknum-calculator)
       (test test-date-get-quarter-string)))

(define (create-datevec l)
  (let ((now (gnc-localtime (current-time))))
    (set-tm:sec now (list-ref l 5))
    (set-tm:min now (list-ref l 4))
    (set-tm:hour now (list-ref l 3))
    (set-tm:mday now (list-ref l 2))
    (set-tm:mon now (list-ref l 1))
    (set-tm:year now (list-ref l 0))
    (set-tm:isdst now -1)
    now))

(define (create-time64 l)
  (let ((now (create-datevec l)))
    (gnc-mktime now)))

(define (weeknums-equal? pair-of-dates)
  (let ((d1 (car pair-of-dates))
        (d2 (cdr pair-of-dates)))
    (equal? (gnc:date-to-week (create-time64 d1))
            (gnc:date-to-week (create-time64 d2)))))

(define (test-weeknum-calculator)
  (and (weeknums-equal? (cons '(1970 1 1 0 0 0)
                              '(1970 1 1 23 59 59)))
       (weeknums-equal? (cons '(1969 12 31 0 0 0)
                              '(1969 12 31 23 59 59)))
       (weeknums-equal? (cons '(1969 12 31 0 0 0)
                              '(1970 1 1 0 0 1)))
       (weeknums-equal? (cons '(2001 1 1 0 0 0)
                              '(2001 1 1 23 59 59)))
       (not (weeknums-equal? (cons '(1970 1 1 0 0 0)
                                   '(1970 1 10 0 0 1))))
       (not (weeknums-equal? (cons '(1969 12 28 0 0 1)
                                   '(1970 1 5 0 0 1))))
       ))

(define (test-date-get-quarter-string)
  (and (or (string=? "Q1" (gnc:date-get-quarter-string (create-datevec '(2001 2 14 11 42 23))))
           (begin (format #t "Expected Q1, got ~a~%" (gnc:date-get-quarter-string (creaete-datevec '(2001 2 14 11 42 23))))
                  #f))
       (or (string=? "Q2" (gnc:date-get-quarter-string (create-datevec '(2013 4 23 18 11 49))))
           (begin (format #t "Expected Q1, got ~a~%" (gnc:date-get-quarter-string (create-datevec '(2001 2 14 11 42 23))))
                  #f))
       (or (string=? "Q3" (gnc:date-get-quarter-string (create-datevec '(1997 9 11 08 14 21))))
           (begin (format #t "Expected Q1, got ~a~%" (gnc:date-get-quarter-string (create-datevec '(2001 2 14 11 42 23)))))
           #f)))
       
