/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <cairo.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimp.h"
#include "core/gimpgrouplayer.h"
#include "core/gimpimage-merge.h"
#include "core/gimpimage.h"
#include "core/gimplayer.h"
#include "core/gimpparamspecs.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
group_layer_new_invoker (GimpProcedure         *procedure,
                         Gimp                  *gimp,
                         GimpContext           *context,
                         GimpProgress          *progress,
                         const GimpValueArray  *args,
                         GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  GimpGroupLayer *group_layer = NULL;

  image = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      group_layer = GIMP_GROUP_LAYER (gimp_group_layer_new (image));

      if (! group_layer)
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), group_layer);

  return return_vals;
}

static GimpValueArray *
group_layer_merge_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpGroupLayer *group_layer;
  GimpLayer *layer = NULL;

  group_layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      if (gimp_pdb_item_is_attached (GIMP_ITEM (group_layer), NULL, 0, error) &&
          gimp_pdb_item_is_group (GIMP_ITEM (group_layer), error))
        {
          GimpImage *image = gimp_item_get_image (GIMP_ITEM (group_layer));

          layer = gimp_image_merge_group_layer (image, group_layer);

          if (! layer)
            success = FALSE;
        }
      else
        success = FALSE;
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), layer);

  return return_vals;
}

void
register_group_layer_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-group-layer-new
   */
  procedure = gimp_procedure_new (group_layer_new_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-group-layer-new");
  gimp_procedure_set_static_help (procedure,
                                  "Create a new group layer.",
                                  "This procedure creates a new group layer. Attributes such as layer mode and opacity should be set with explicit procedure calls. Add the new group layer (which is a kind of layer) with [method@image.insert_layer].\n"
                                  "Other procedures useful with group layers: [method@image_reorder_item], [method@item.get_parent], [method@item.get_children], [method@item.is_group].",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Barak Itkin <lightningismyname@gmail.com>",
                                         "Barak Itkin",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image to which to add the group layer",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_group_layer ("group-layer",
                                                                "group layer",
                                                                "The newly created group layer",
                                                                FALSE,
                                                                GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-group-layer-merge
   */
  procedure = gimp_procedure_new (group_layer_merge_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-group-layer-merge");
  gimp_procedure_set_static_help (procedure,
                                  "Merge the passed group layer's layers into one normal layer.",
                                  "This procedure combines the layers of the passed group layer into a single normal layer, replacing the group.\n"
                                  "The group layer is expected to be attached to an image.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Ell",
                                         "Ell",
                                         "2019");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_group_layer ("group-layer",
                                                            "group layer",
                                                            "The group layer to merge",
                                                            FALSE,
                                                            GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_layer ("layer",
                                                          "layer",
                                                          "The resulting layer",
                                                          FALSE,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
