/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimppatternselect_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimppatternselect
 * @title: gimppatternselect
 * @short_description: Methods of a pattern chooser dialog
 *
 * A dialog letting a user choose a pattern.  Read more at
 * gimpfontselect.
 **/


/**
 * gimp_patterns_popup:
 * @pattern_callback: The callback PDB proc to call when the user chooses a pattern.
 * @popup_title: Title of the pattern selection dialog.
 * @initial_pattern: The pattern to set as the initial choice.
 * @parent_window: An optional parent window handle for the popup to be set transient to.
 *
 * Invokes the Gimp pattern selection.
 *
 * Opens the pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_popup (const gchar *pattern_callback,
                     const gchar *popup_title,
                     GimpPattern *initial_pattern,
                     GBytes      *parent_window)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, pattern_callback,
                                          G_TYPE_STRING, popup_title,
                                          GIMP_TYPE_PATTERN, initial_pattern,
                                          G_TYPE_BYTES, parent_window,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-patterns-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_patterns_close_popup:
 * @pattern_callback: The name of the callback registered for this pop-up.
 *
 * Close the pattern selection dialog.
 *
 * Closes an open pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_close_popup (const gchar *pattern_callback)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, pattern_callback,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-patterns-close-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_patterns_set_popup:
 * @pattern_callback: The name of the callback registered for this pop-up.
 * @pattern: The pattern to set as selected.
 *
 * Sets the current pattern in a pattern selection dialog.
 *
 * Sets the current pattern in a pattern selection dialog.
 *
 * Returns: TRUE on success.
 **/
gboolean
gimp_patterns_set_popup (const gchar *pattern_callback,
                         GimpPattern *pattern)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, pattern_callback,
                                          GIMP_TYPE_PATTERN, pattern,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-patterns-set-popup",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
