/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpconfig/gimpconfig.h"
#include "libgimpmath/gimpmath.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpdrawable.h"
#include "core/gimpdynamics.h"
#include "core/gimppaintinfo.h"
#include "core/gimpparamspecs.h"
#include "paint/gimppaintcore-stroke.h"
#include "paint/gimppaintcore.h"
#include "paint/gimppaintoptions.h"

#include "gimppdb.h"
#include "gimppdb-utils.h"
#include "gimppdbcontext.h"
#include "gimpprocedure.h"
#include "internal-procs.h"


static const GimpCoords default_coords = GIMP_COORDS_DEFAULT_VALUES;

static gboolean
paint_tools_stroke (Gimp              *gimp,
                    GimpContext       *context,
                    GimpPaintOptions  *options,
                    GimpDrawable      *drawable,
                    gsize              n_strokes,
                    const gdouble     *strokes,
                    GError           **error,
                    const gchar       *first_property_name,
                    ...)
{
  GimpPaintCore *core;
  GimpCoords    *coords;
  gboolean       retval;
  gint           i;
  va_list        args;

  n_strokes /= 2;  /* #doubles -> #points */

  /*  undefine the paint-relevant context properties and get them
   *  from the current context
   */
  gimp_context_define_properties (GIMP_CONTEXT (options),
                                  GIMP_CONTEXT_PROP_MASK_PAINT,
                                  FALSE);
  gimp_context_set_parent (GIMP_CONTEXT (options), context);

  va_start (args, first_property_name);
  core = GIMP_PAINT_CORE (g_object_new_valist (options->paint_info->paint_type,
                                               first_property_name, args));
  va_end (args);

  coords = g_new (GimpCoords, n_strokes);

  for (i = 0; i < n_strokes; i++)
    {
      coords[i]   = default_coords;
      coords[i].x = strokes[2 * i];
      coords[i].y = strokes[2 * i + 1];
    }

  retval = gimp_paint_core_stroke (core, drawable, options,
                                   coords, n_strokes, TRUE,
                                   error);

  g_free (coords);

  g_object_unref (core);
  g_object_unref (options);

  return retval;
}

static GimpValueArray *
airbrush_invoker (GimpProcedure         *procedure,
                  Gimp                  *gimp,
                  GimpContext           *context,
                  GimpProgress          *progress,
                  const GimpValueArray  *args,
                  GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  pressure = g_value_get_double (gimp_value_array_index (args, 1));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 2), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-airbrush");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          g_object_set (options,
                        "pressure", pressure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
airbrush_default_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-airbrush");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
clone_invoker (GimpProcedure         *procedure,
               Gimp                  *gimp,
               GimpContext           *context,
               GimpProgress          *progress,
               const GimpValueArray  *args,
               GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpDrawable *src_drawable;
  gint clone_type;
  gdouble src_x;
  gdouble src_y;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  src_drawable = g_value_get_object (gimp_value_array_index (args, 1));
  clone_type = g_value_get_enum (gimp_value_array_index (args, 2));
  src_x = g_value_get_double (gimp_value_array_index (args, 3));
  src_y = g_value_get_double (gimp_value_array_index (args, 4));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 5), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-clone");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          GList *src_drawables;

          options = gimp_config_duplicate (GIMP_CONFIG (options));
          src_drawables = g_list_prepend (NULL, src_drawable);

          g_object_set (options,
                        "clone-type",    clone_type,
                        "src-drawables", src_drawables,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        "src-x",     (gint) floor (src_x),
                                        "src-y",     (gint) floor (src_y),
                                        NULL);
          g_list_free (src_drawables);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
clone_default_invoker (GimpProcedure         *procedure,
                       Gimp                  *gimp,
                       GimpContext           *context,
                       GimpProgress          *progress,
                       const GimpValueArray  *args,
                       GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-clone");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
convolve_invoker (GimpProcedure         *procedure,
                  Gimp                  *gimp,
                  GimpContext           *context,
                  GimpProgress          *progress,
                  const GimpValueArray  *args,
                  GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gint convolve_type;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  pressure = g_value_get_double (gimp_value_array_index (args, 1));
  convolve_type = g_value_get_enum (gimp_value_array_index (args, 2));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 3), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-convolve");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          g_object_set (options,
                        "type", convolve_type,
                        "rate", pressure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
convolve_default_invoker (GimpProcedure         *procedure,
                          Gimp                  *gimp,
                          GimpContext           *context,
                          GimpProgress          *progress,
                          const GimpValueArray  *args,
                          GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-convolve");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
dodgeburn_invoker (GimpProcedure         *procedure,
                   Gimp                  *gimp,
                   GimpContext           *context,
                   GimpProgress          *progress,
                   const GimpValueArray  *args,
                   GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble exposure;
  gint dodgeburn_type;
  gint dodgeburn_mode;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  exposure = g_value_get_double (gimp_value_array_index (args, 1));
  dodgeburn_type = g_value_get_enum (gimp_value_array_index (args, 2));
  dodgeburn_mode = g_value_get_enum (gimp_value_array_index (args, 3));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 4), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-dodge-burn");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          g_object_set (options,
                        "type",     dodgeburn_type,
                        "mode",     dodgeburn_mode,
                        "exposure", exposure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
dodgeburn_default_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-dodge-burn");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
eraser_invoker (GimpProcedure         *procedure,
                Gimp                  *gimp,
                GimpContext           *context,
                GimpProgress          *progress,
                const GimpValueArray  *args,
                GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;
  gint hardness;
  gint method;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);
  hardness = g_value_get_enum (gimp_value_array_index (args, 2));
  method = g_value_get_enum (gimp_value_array_index (args, 3));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-eraser");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          g_object_set (options,
                        "application-mode", method,
                        "hard",             hardness,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
eraser_default_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-eraser");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
heal_invoker (GimpProcedure         *procedure,
              Gimp                  *gimp,
              GimpContext           *context,
              GimpProgress          *progress,
              const GimpValueArray  *args,
              GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  GimpDrawable *src_drawable;
  gdouble src_x;
  gdouble src_y;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  src_drawable = g_value_get_object (gimp_value_array_index (args, 1));
  src_x = g_value_get_double (gimp_value_array_index (args, 2));
  src_y = g_value_get_double (gimp_value_array_index (args, 3));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 4), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-heal");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          GList *src_drawables;

          options = gimp_config_duplicate (GIMP_CONFIG (options));
          src_drawables = g_list_prepend (NULL, src_drawable);

          g_object_set (options,
                        "src-drawables", src_drawables,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        "src-x",     (gint) floor (src_x),
                                        "src-y",     (gint) floor (src_y),
                                        NULL);
          g_list_free (src_drawables);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
heal_default_invoker (GimpProcedure         *procedure,
                      Gimp                  *gimp,
                      GimpContext           *context,
                      GimpProgress          *progress,
                      const GimpValueArray  *args,
                      GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-heal");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
paintbrush_invoker (GimpProcedure         *procedure,
                    Gimp                  *gimp,
                    GimpContext           *context,
                    GimpProgress          *progress,
                    const GimpValueArray  *args,
                    GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble fade_out;
  gsize num_strokes;
  const gdouble *strokes;
  gint method;
  gdouble gradient_length;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  fade_out = g_value_get_double (gimp_value_array_index (args, 1));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 2), &num_strokes);
  method = g_value_get_enum (gimp_value_array_index (args, 3));
  gradient_length = g_value_get_double (gimp_value_array_index (args, 4));

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-paintbrush");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          GimpDynamics *pdb_dynamics  = GIMP_DYNAMICS (gimp_dynamics_new (context, "pdb"));
          GimpDynamics *user_dynamics = gimp_context_get_dynamics (context);

          options = gimp_config_duplicate (GIMP_CONFIG (options));

          g_object_set (options,
                        "application-mode", method,
                        "fade-length",      MAX (fade_out, gradient_length),
                        NULL);

          if (fade_out > 0)
            {
               GimpDynamicsOutput *opacity_output =
                 gimp_dynamics_get_output (pdb_dynamics,
                                           GIMP_DYNAMICS_OUTPUT_OPACITY);

               g_object_set (opacity_output,
                             "use-fade", TRUE,
                             NULL);
            }

          if (gradient_length > 0)
            {
              GimpDynamicsOutput *color_output =
                gimp_dynamics_get_output (pdb_dynamics,
                                          GIMP_DYNAMICS_OUTPUT_COLOR);

              g_object_set (color_output,
                            "use-fade", TRUE,
                            NULL);
            }

          gimp_context_set_dynamics (context, pdb_dynamics);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);

          gimp_context_set_dynamics (context, user_dynamics);

          g_object_unref (pdb_dynamics);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
paintbrush_default_invoker (GimpProcedure         *procedure,
                            Gimp                  *gimp,
                            GimpContext           *context,
                            GimpProgress          *progress,
                            const GimpValueArray  *args,
                            GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-paintbrush");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
pencil_invoker (GimpProcedure         *procedure,
                Gimp                  *gimp,
                GimpContext           *context,
                GimpProgress          *progress,
                const GimpValueArray  *args,
                GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-pencil");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
smudge_invoker (GimpProcedure         *procedure,
                Gimp                  *gimp,
                GimpContext           *context,
                GimpProgress          *progress,
                const GimpValueArray  *args,
                GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gdouble pressure;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  pressure = g_value_get_double (gimp_value_array_index (args, 1));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 2), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-smudge");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          g_object_set (options,
                        "rate", pressure,
                        NULL);

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
smudge_default_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpDrawable *drawable;
  gsize num_strokes;
  const gdouble *strokes;

  drawable = g_value_get_object (gimp_value_array_index (args, 0));
  strokes = gimp_value_get_double_array (gimp_value_array_index (args, 1), &num_strokes);

  if (success)
    {
      GimpPaintOptions *options =
        gimp_pdb_context_get_paint_options (GIMP_PDB_CONTEXT (context),
                                            "gimp-smudge");

      if (options &&
          gimp_pdb_item_is_attached (GIMP_ITEM (drawable), NULL,
                                     GIMP_PDB_ITEM_CONTENT, error) &&
          gimp_pdb_item_is_not_group (GIMP_ITEM (drawable), error))
        {
          options = gimp_config_duplicate (GIMP_CONFIG (options));

          success = paint_tools_stroke (gimp, context, options, drawable,
                                        num_strokes, strokes, error,
                                        "undo-desc", options->paint_info->blurb,
                                        NULL);
        }
      else
        success = FALSE;
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_paint_tools_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-airbrush
   */
  procedure = gimp_procedure_new (airbrush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-airbrush");
  gimp_procedure_set_static_help (procedure,
                                  "Paint in the current brush with varying pressure. Paint application is time-dependent.",
                                  "This tool simulates the use of an airbrush. Paint pressure represents the relative intensity of the paint application. High pressure results in a thicker layer of paint while low pressure results in a thinner layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("pressure",
                                                    "pressure",
                                                    "The pressure of the airbrush strokes",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-airbrush-default
   */
  procedure = gimp_procedure_new (airbrush_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-airbrush-default");
  gimp_procedure_set_static_help (procedure,
                                  "Paint in the current brush with varying pressure. Paint application is time-dependent.",
                                  "This tool simulates the use of an airbrush. It is similar to 'gimp-airbrush' except that the pressure is derived from the airbrush tools options box. It the option has not been set the default for the option will be used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-clone
   */
  procedure = gimp_procedure_new (clone_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-clone");
  gimp_procedure_set_static_help (procedure,
                                  "Clone from the source to the dest drawable using the current brush",
                                  "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. If the \"clone_type\" argument is set to PATTERN-CLONE, then the current pattern is used as the source and the \"src_drawable\" argument is ignored. Pattern cloning assumes a tileable pattern and mods the sum of the src coordinates and subsequent stroke offsets with the width and height of the pattern. For image cloning, if the sum of the src coordinates and subsequent stroke offsets exceeds the extents of the src drawable, then no paint is transferred. The clone tool is capable of transforming between any image types including RGB->Indexed--although converting from any type to indexed is significantly slower.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("src-drawable",
                                                         "src drawable",
                                                         "The source drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("clone-type",
                                                  "clone type",
                                                  "The type of clone",
                                                  GIMP_TYPE_CLONE_TYPE,
                                                  GIMP_CLONE_IMAGE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-x",
                                                    "src x",
                                                    "The x coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-y",
                                                    "src y",
                                                    "The y coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-clone-default
   */
  procedure = gimp_procedure_new (clone_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-clone-default");
  gimp_procedure_set_static_help (procedure,
                                  "Clone from the source to the dest drawable using the current brush",
                                  "This tool clones (copies) from the source drawable starting at the specified source coordinates to the dest drawable. This function performs exactly the same as the 'gimp-clone' function except that the tools arguments are obtained from the clones option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-convolve
   */
  procedure = gimp_procedure_new (convolve_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-convolve");
  gimp_procedure_set_static_help (procedure,
                                  "Convolve (Blur, Sharpen) using the current brush.",
                                  "This tool convolves the specified drawable with either a sharpening or blurring kernel. The pressure parameter controls the magnitude of the operation. Like the paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("pressure",
                                                    "pressure",
                                                    "The pressure",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("convolve-type",
                                                  "convolve type",
                                                  "Convolve type",
                                                  GIMP_TYPE_CONVOLVE_TYPE,
                                                  GIMP_CONVOLVE_BLUR,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-convolve-default
   */
  procedure = gimp_procedure_new (convolve_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-convolve-default");
  gimp_procedure_set_static_help (procedure,
                                  "Convolve (Blur, Sharpen) using the current brush.",
                                  "This tool convolves the specified drawable with either a sharpening or blurring kernel. This function performs exactly the same as the 'gimp-convolve' function except that the tools arguments are obtained from the convolve option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-dodgeburn
   */
  procedure = gimp_procedure_new (dodgeburn_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-dodgeburn");
  gimp_procedure_set_static_help (procedure,
                                  "Dodgeburn image with varying exposure.",
                                  "Dodgeburn. More details here later.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("exposure",
                                                    "exposure",
                                                    "The exposure of the strokes",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("dodgeburn-type",
                                                  "dodgeburn type",
                                                  "The type either dodge or burn",
                                                  GIMP_TYPE_DODGE_BURN_TYPE,
                                                  GIMP_DODGE_BURN_TYPE_DODGE,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("dodgeburn-mode",
                                                  "dodgeburn mode",
                                                  "The mode",
                                                  GIMP_TYPE_TRANSFER_MODE,
                                                  GIMP_TRANSFER_SHADOWS,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-dodgeburn-default
   */
  procedure = gimp_procedure_new (dodgeburn_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-dodgeburn-default");
  gimp_procedure_set_static_help (procedure,
                                  "Dodgeburn image with varying exposure. This is the same as the gimp_dodgeburn() function except that the exposure, type and mode are taken from the tools option dialog. If the dialog has not been activated then the defaults as used by the dialog will be used.",
                                  "Dodgeburn. More details here later.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-eraser
   */
  procedure = gimp_procedure_new (eraser_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-eraser");
  gimp_procedure_set_static_help (procedure,
                                  "Erase using the current brush.",
                                  "This tool erases using the current brush mask. If the specified drawable contains an alpha channel, then the erased pixels will become transparent. Otherwise, the eraser tool replaces the contents of the drawable with the background color. Like paintbrush, this tool linearly interpolates between the specified stroke coordinates.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("hardness",
                                                  "hardness",
                                                  "How to apply the brush",
                                                  GIMP_TYPE_BRUSH_APPLICATION_MODE,
                                                  GIMP_BRUSH_HARD,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("method",
                                                  "method",
                                                  "The paint method to use",
                                                  GIMP_TYPE_PAINT_APPLICATION_MODE,
                                                  GIMP_PAINT_CONSTANT,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-eraser-default
   */
  procedure = gimp_procedure_new (eraser_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-eraser-default");
  gimp_procedure_set_static_help (procedure,
                                  "Erase using the current brush.",
                                  "This tool erases using the current brush mask. This function performs exactly the same as the 'gimp-eraser' function except that the tools arguments are obtained from the eraser option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-heal
   */
  procedure = gimp_procedure_new (heal_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-heal");
  gimp_procedure_set_static_help (procedure,
                                  "Heal from the source to the dest drawable using the current brush",
                                  "This tool heals the source drawable starting at the specified source coordinates to the dest drawable. For image healing, if the sum of the src coordinates and subsequent stroke offsets exceeds the extents of the src drawable, then no paint is transferred. The healing tool is capable of transforming between any image types except RGB->Indexed.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Kevin Sookocheff",
                                         "Kevin Sookocheff",
                                         "2006");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("src-drawable",
                                                         "src drawable",
                                                         "The source drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-x",
                                                    "src x",
                                                    "The x coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("src-y",
                                                    "src y",
                                                    "The y coordinate in the source image",
                                                    -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-heal-default
   */
  procedure = gimp_procedure_new (heal_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-heal-default");
  gimp_procedure_set_static_help (procedure,
                                  "Heal from the source to the dest drawable using the current brush",
                                  "This tool heals from the source drawable starting at the specified source coordinates to the dest drawable. This function performs exactly the same as the 'gimp-heal' function except that the tools arguments are obtained from the healing option dialog. It this dialog has not been activated then the dialogs default values will be used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Kevin Sookocheff",
                                         "Kevin Sookocheff",
                                         "2006");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-paintbrush
   */
  procedure = gimp_procedure_new (paintbrush_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-paintbrush");
  gimp_procedure_set_static_help (procedure,
                                  "Paint in the current brush with optional fade out parameter and pull colors from a gradient.",
                                  "This tool is the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The 'fade-out' parameter is measured in pixels and allows the brush stroke to linearly fall off. The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade-out value, the pressure will approach zero. The gradient-length is the distance to spread the gradient over. It is measured in pixels. If the gradient-length is 0, no gradient is used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("fade-out",
                                                    "fade out",
                                                    "Fade out parameter",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("method",
                                                  "method",
                                                  "The paint method to use",
                                                  GIMP_TYPE_PAINT_APPLICATION_MODE,
                                                  GIMP_PAINT_CONSTANT,
                                                  GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("gradient-length",
                                                    "gradient length",
                                                    "Length of gradient to draw",
                                                    0, G_MAXDOUBLE, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-paintbrush-default
   */
  procedure = gimp_procedure_new (paintbrush_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-paintbrush-default");
  gimp_procedure_set_static_help (procedure,
                                  "Paint in the current brush. The fade out parameter and pull colors from a gradient parameter are set from the paintbrush options dialog. If this dialog has not been activated then the dialog defaults will be used.",
                                  "This tool is similar to the standard paintbrush. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The 'fade-out' parameter is measured in pixels and allows the brush stroke to linearly fall off (value obtained from the option dialog). The pressure is set to the maximum at the beginning of the stroke. As the distance of the stroke nears the fade-out value, the pressure will approach zero. The gradient-length (value obtained from the option dialog) is the distance to spread the gradient over. It is measured in pixels. If the gradient-length is 0, no gradient is used.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-pencil
   */
  procedure = gimp_procedure_new (pencil_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-pencil");
  gimp_procedure_set_static_help (procedure,
                                  "Paint in the current brush without sub-pixel sampling.",
                                  "This tool is the standard pencil. It draws linearly interpolated lines through the specified stroke coordinates. It operates on the specified drawable in the foreground color with the active brush. The brush mask is treated as though it contains only black and white values. Any value below half is treated as black; any above half, as white.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-smudge
   */
  procedure = gimp_procedure_new (smudge_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-smudge");
  gimp_procedure_set_static_help (procedure,
                                  "Smudge image with varying pressure.",
                                  "This tool simulates a smudge using the current brush. High pressure results in a greater smudge of paint while low pressure results in a lesser smudge.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Spencer Kimball & Peter Mattis",
                                         "Spencer Kimball & Peter Mattis",
                                         "1995-1996");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("pressure",
                                                    "pressure",
                                                    "The pressure of the smudge strokes",
                                                    0, 100, 0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-smudge-default
   */
  procedure = gimp_procedure_new (smudge_default_invoker);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-smudge-default");
  gimp_procedure_set_static_help (procedure,
                                  "Smudge image with varying pressure.",
                                  "This tool simulates a smudge using the current brush. It behaves exactly the same as 'gimp-smudge' except that the pressure value is taken from the smudge tool options or the options default if the tools option dialog has not been activated.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Andy Thomas",
                                         "Andy Thomas",
                                         "1999");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_drawable ("drawable",
                                                         "drawable",
                                                         "The affected drawable",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_double_array ("strokes",
                                                             "strokes",
                                                             "Array of stroke coordinates: { s1.x, s1.y, s2.x, s2.y, ..., sn.x, sn.y }",
                                                             GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
