static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef G_OS_WIN32                                                             \n"
"#define realpath(a,b) _fullpath(b,a,_MAX_PATH)                                \n"
"#endif                                                                        \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description (_(\"Path of file to load.\"))                                \n"
"property_uri (uri, _(\"URI\"), \"\")                                          \n"
"    description (_(\"URI of file to load.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_C_SOURCE load.c                                               \n"
"                                                                              \n"
"#include <gegl-plugin.h>                                                      \n"
"#include <gegl-gio-private.h>                                                 \n"
"                                                                              \n"
"struct _GeglOp                                                                \n"
"{                                                                             \n"
"  GeglOperationMeta parent_instance;                                          \n"
"  gpointer          properties;                                               \n"
"                                                                              \n"
"  GeglNode *output;                                                           \n"
"  GeglNode *load;                                                             \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  GeglOperationMetaClass parent_class;                                        \n"
"} GeglOpClass;                                                                \n"
"                                                                              \n"
"#include <gegl-op.h>                                                          \n"
"GEGL_DEFINE_DYNAMIC_OPERATION(GEGL_TYPE_OPERATION_META)                       \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"#define SNIFFING_LENGTH 4096                                                  \n"
"                                                                              \n"
"static gboolean                                                               \n"
"read_from_stream (GInputStream *stream,                                       \n"
"                  guchar      **buffer,                                       \n"
"                  gsize        *read,                                         \n"
"                  GError      **error)                                        \n"
"{                                                                             \n"
"  const gsize size = SNIFFING_LENGTH;                                         \n"
"                                                                              \n"
"  *read = 0;                                                                  \n"
"  *buffer = g_try_new (guchar, size);                                         \n"
"                                                                              \n"
"  g_assert (buffer != NULL);                                                  \n"
"                                                                              \n"
"  return g_input_stream_read_all (stream, *buffer, size, read, NULL, error);  \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"do_setup (GeglOperation *operation, const gchar *path, const gchar *uri)      \n"
"{                                                                             \n"
"  GeglOp  *self = GEGL_OP (operation);                                        \n"
"  const gchar *handler = NULL;                                                \n"
"  gchar *content_type = NULL, *filename = NULL, *message;                     \n"
"  gboolean load_from_uri, uncertain;                                          \n"
"  GInputStream *stream = NULL;                                                \n"
"  GError *error = NULL;                                                       \n"
"  GFile *file = NULL;                                                         \n"
"  guchar *buffer = NULL;                                                      \n"
"  gsize size;                                                                 \n"
"                                                                              \n"
"  if (uri != NULL && strlen (uri) > 0)                                        \n"
"    {                                                                         \n"
"      if (!gegl_gio_uri_is_datauri (uri))                                     \n"
"        filename = g_filename_display_name (uri);                             \n"
"      stream = gegl_gio_open_input_stream (uri, NULL, &file, &error);         \n"
"      if (stream == NULL || (file == NULL && !gegl_gio_uri_is_datauri (uri))) \n"
"        {                                                                     \n"
"          if (!gegl_gio_uri_is_datauri (uri))                                 \n"
"            {                                                                 \n"
"              if (g_error_matches (error, G_IO_ERROR, G_IO_ERROR_NOT_FOUND))  \n"
"                {                                                             \n"
"                  message = g_strdup_printf (\"%s does not exist\", filename);\n"
"                  gegl_node_set (self->load,                                  \n"
"                                 \"operation\", \"gegl:text\",                \n"
"                                 \"string\", message,                         \n"
"                                 \"size\", 12.0,                              \n"
"                                 NULL);                                       \n"
"                  g_free (message);                                           \n"
"                }                                                             \n"
"                                                                              \n"
"              g_warning (\"%s does not exist or could not be opened\", filename);\n"
"            }                                                                 \n"
"          else                                                                \n"
"            g_warning (\"datauri could not be parsed\");                      \n"
"                                                                              \n"
"          g_clear_error (&error);                                             \n"
"          goto cleanup;                                                       \n"
"        }                                                                     \n"
"      load_from_uri = TRUE;                                                   \n"
"    }                                                                         \n"
"  else if (path != NULL && strlen (path) > 0)                                 \n"
"    {                                                                         \n"
"      gchar *resolved_path = realpath (path, NULL);                           \n"
"      if (resolved_path)                                                      \n"
"        {                                                                     \n"
"          filename = g_filename_display_name (resolved_path);                 \n"
"                                                                              \n"
"          stream = gegl_gio_open_input_stream (NULL, resolved_path, &file, &error);\n"
"          if (stream == NULL || file == NULL)                                 \n"
"            {                                                                 \n"
"              if (g_error_matches (error, G_IO_ERROR, G_IO_ERROR_NOT_FOUND))  \n"
"                {                                                             \n"
"                  message = g_strdup_printf (\"%s does not exist\", filename);\n"
"                  gegl_node_set (self->load,                                  \n"
"                                 \"operation\", \"gegl:text\",                \n"
"                                 \"string\", message,                         \n"
"                                 \"size\", 12.0,                              \n"
"                                 NULL);                                       \n"
"                  g_free (message);                                           \n"
"                }                                                             \n"
"              g_warning (\"%s does not exist or could not be opened\", filename);\n"
"              g_clear_error (&error);                                         \n"
"              free (resolved_path);                                           \n"
"              goto cleanup;                                                   \n"
"            }                                                                 \n"
"          load_from_uri = FALSE;                                              \n"
"          free (resolved_path);                                               \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          gegl_node_set (self->load,                                          \n"
"                         \"operation\", \"gegl:text\",                        \n"
"                         \"string\", \"load failed\",                         \n"
"                         \"size\", 12.0,                                      \n"
"                         NULL);                                               \n"
"          goto cleanup;                                                       \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      gegl_node_set (self->load,                                              \n"
"                     \"operation\", \"gegl:text\",                            \n"
"                     \"string\", \"No path or URI specified\",                \n"
"                     \"size\", 12.0,                                          \n"
"                     NULL);                                                   \n"
"      return;                                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_assert (stream != NULL);                                                  \n"
"                                                                              \n"
"  if (!read_from_stream (stream, &buffer, &size, &error))                     \n"
"    {                                                                         \n"
"      g_warning (\"%s\", error->message);                                     \n"
"      g_clear_error (&error);                                                 \n"
"      goto cleanup;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  content_type = g_content_type_guess (NULL, buffer, size, &uncertain);       \n"
"  if ((!g_str_has_prefix (content_type, \"image/\") &&                        \n"
"       !g_str_has_prefix (content_type, \".\")) || uncertain)                 \n"
"    {                                                                         \n"
"      g_free (content_type);                                                  \n"
"      if (load_from_uri && gegl_gio_uri_is_datauri (uri))                     \n"
"        content_type = gegl_gio_datauri_get_content_type (uri);               \n"
"      else                                                                    \n"
"      {                                                                       \n"
"        content_type = g_content_type_guess (filename, buffer, size, NULL);   \n"
"        if (!g_str_has_prefix (content_type, \"image/\") &&                   \n"
"            !g_str_has_prefix (content_type, \".\"))                          \n"
"          {                                                                   \n"
"            g_free (content_type);                                            \n"
"            if (g_strrstr (filename, \".\") != NULL)                          \n"
"              content_type = g_strdup (g_strrstr (filename, \".\"));          \n"
"            else                                                              \n"
"              content_type = NULL;                                            \n"
"          }                                                                   \n"
"      }                                                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  handler = gegl_operation_handlers_get_loader (content_type);                \n"
"                                                                              \n"
"  gegl_node_set (self->load, \"operation\", handler, NULL);                   \n"
"  if (load_from_uri == TRUE)                                                  \n"
"    gegl_node_set (self->load, \"uri\", uri, NULL);                           \n"
"  else                                                                        \n"
"    gegl_node_set (self->load, \"path\", path, NULL);                         \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"                                                                              \n"
"  if (stream != NULL)                                                         \n"
"    {                                                                         \n"
"      g_input_stream_close (stream, NULL, NULL);                              \n"
"      g_object_unref (stream);                                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (file != NULL)                                                           \n"
"    g_object_unref (file);                                                    \n"
"                                                                              \n"
"  g_free (buffer);                                                            \n"
"                                                                              \n"
"  g_free (content_type);                                                      \n"
"  g_free (filename);                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"attach (GeglOperation *operation)                                             \n"
"{                                                                             \n"
"  GeglOp         *self = GEGL_OP (operation);                                 \n"
"  GeglProperties *o    = GEGL_PROPERTIES (operation);                         \n"
"                                                                              \n"
"  self->output = gegl_node_get_output_proxy (operation->node, \"output\");    \n"
"                                                                              \n"
"  self->load = gegl_node_new_child (operation->node,                          \n"
"                                    \"operation\", \"gegl:text\",             \n"
"                                    NULL);                                    \n"
"                                                                              \n"
"  do_setup (operation, o->path, o->uri);                                      \n"
"                                                                              \n"
"  gegl_node_link (self->load, self->output);                                  \n"
"                                                                              \n"
"  gegl_operation_meta_watch_node (operation, self->load);                     \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglNode *                                                             \n"
"detect (GeglOperation *operation,                                             \n"
"        gint           x,                                                     \n"
"        gint           y)                                                     \n"
"{                                                                             \n"
"  GeglOp *self = GEGL_OP (operation);                                         \n"
"  GeglNode *output = self->output;                                            \n"
"  GeglRectangle bounds;                                                       \n"
"                                                                              \n"
"  bounds = gegl_node_get_bounding_box (output); /* hopefully this is          \n"
"                                                   as correct as original     \n"
"                                                   which was peeking          \n"
"                                                   directly into output->have_rect\n"
"                                                   */                         \n"
"                                                                              \n"
"  if (x >= bounds.x &&                                                        \n"
"      y >= bounds.y &&                                                        \n"
"      x  < bounds.x + bounds.width &&                                         \n"
"      y  < bounds.y + bounds.height)                                          \n"
"    return operation->node;                                                   \n"
"                                                                              \n"
"  return NULL;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"my_set_property (GObject      *gobject,                                       \n"
"                 guint         property_id,                                   \n"
"                 const GValue *value,                                         \n"
"                 GParamSpec   *pspec)                                         \n"
"{                                                                             \n"
"  GeglOperation  *operation = GEGL_OPERATION (gobject);                       \n"
"  GeglOp         *self      = GEGL_OP (operation);                            \n"
"  GeglProperties *o         = GEGL_PROPERTIES (operation);                    \n"
"                                                                              \n"
"  gchar *old_path = g_strdup (o->path);                                       \n"
"  gchar *old_uri = g_strdup (o->uri);                                         \n"
"                                                                              \n"
"  gboolean props_changed;                                                     \n"
"                                                                              \n"
"  /* The set_property provided by the chant system does the                   \n"
"   * storing and reffing/unreffing of the input properties                    \n"
"   */                                                                         \n"
"  set_property (gobject, property_id, value, pspec);                          \n"
"  props_changed = g_strcmp0 (o->path, old_path) || g_strcmp0 (o->uri, old_uri);\n"
"                                                                              \n"
"  if (self->load && props_changed)                                            \n"
"    do_setup (operation, o->path, o->uri);                                    \n"
"  g_free (old_path);                                                          \n"
"  g_free (old_uri);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GObjectClass       *object_class    = G_OBJECT_CLASS (klass);               \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"                                                                              \n"
"  object_class->set_property = my_set_property;                               \n"
"                                                                              \n"
"  operation_class->attach = attach;                                           \n"
"  operation_class->detect = detect;                                           \n"
"  operation_class->no_cache = TRUE;                                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:load\",                                           \n"
"    \"title\",       \"Load Image\",                                          \n"
"    \"categories\" , \"meta:input\",                                          \n"
"    \"description\",                                                          \n"
"          _(\"Multipurpose file loader, that uses other native handlers, and \"\n"
"            \"fallback conversion using Image Magick's convert.\"),           \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
