static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * This program is free software: you can redistribute it and/or modify       \n"
" * it under the terms of the GNU General Public License as published by       \n"
" * the Free Software Foundation; either version 3 of the License, or          \n"
" * (at your option) any later version.                                        \n"
" *                                                                            \n"
" * This program is distributed in the hope that it will be useful,            \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              \n"
" * GNU General Public License for more details.                               \n"
" *                                                                            \n"
" * You should have received a copy of the GNU General Public License          \n"
" * along with this program.  If not, see <http://www.gnu.org/licenses/>.      \n"
" *                                                                            \n"
" * Copyright Nigel Wetten                                                     \n"
" * Copyright 2000 Tim Copperfield <timecop@japan.co.jp>                       \n"
" * Copyright 2011 Hans Lo <hansshulo@gmail.com>                               \n"
" *                                                                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"enum_start (gegl_wind_style)                                                  \n"
"  enum_value (GEGL_WIND_STYLE_WIND, \"wind\", N_(\"Wind\"))                   \n"
"  enum_value (GEGL_WIND_STYLE_BLAST, \"blast\", N_(\"Blast\"))                \n"
"enum_end (GeglWindStyle)                                                      \n"
"                                                                              \n"
"enum_start (gegl_wind_direction)                                              \n"
"  enum_value (GEGL_WIND_DIRECTION_LEFT, \"left\", N_(\"Left\"))               \n"
"  enum_value (GEGL_WIND_DIRECTION_RIGHT, \"right\", N_(\"Right\"))            \n"
"  enum_value (GEGL_WIND_DIRECTION_TOP, \"top\", N_(\"Top\"))                  \n"
"  enum_value (GEGL_WIND_DIRECTION_BOTTOM, \"bottom\", N_(\"Bottom\"))         \n"
"enum_end (GeglWindDirection)                                                  \n"
"                                                                              \n"
"enum_start (gegl_wind_edge)                                                   \n"
"  enum_value (GEGL_WIND_EDGE_BOTH, \"both\", N_(\"Both\"))                    \n"
"  enum_value (GEGL_WIND_EDGE_LEADING, \"leading\", N_(\"Leading\"))           \n"
"  enum_value (GEGL_WIND_EDGE_TRAILING, \"trailing\", N_(\"Trailing\"))        \n"
"enum_end (GeglWindEdge)                                                       \n"
"                                                                              \n"
"property_enum (style, _(\"Style\"),                                           \n"
"               GeglWindStyle, gegl_wind_style,                                \n"
"               GEGL_WIND_STYLE_WIND)                                          \n"
"  description (_(\"Style of effect\"))                                        \n"
"                                                                              \n"
"property_enum (direction, _(\"Direction\"),                                   \n"
"               GeglWindDirection, gegl_wind_direction,                        \n"
"               GEGL_WIND_DIRECTION_LEFT)                                      \n"
"  description (_(\"Direction of the effect\"))                                \n"
"                                                                              \n"
"property_enum (edge, _(\"Edge Affected\"),                                    \n"
"               GeglWindEdge, gegl_wind_edge,                                  \n"
"               GEGL_WIND_EDGE_LEADING)                                        \n"
"  description (_(\"Edge behavior\"))                                          \n"
"                                                                              \n"
"property_int (threshold, _(\"Threshold\"), 10)                                \n"
" description (_(\"Higher values restrict the effect to fewer areas of the image\"))\n"
" value_range (0, 50)                                                          \n"
"                                                                              \n"
"property_int (strength, _(\"Strength\"), 10)                                  \n"
" description (_(\"Higher values increase the magnitude of the effect\"))      \n"
" value_range (1, 100)                                                         \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_C_SOURCE wind.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"#define COMPARE_WIDTH    3                                                    \n"
"                                                                              \n"
"typedef struct ThreadData                                                     \n"
"{                                                                             \n"
"  GeglOperationFilterClass *klass;                                            \n"
"  GeglOperation            *operation;                                        \n"
"  GeglBuffer               *input;                                            \n"
"  GeglBuffer               *output;                                           \n"
"  gint                     *pending;                                          \n"
"  gint                      level;                                            \n"
"  gboolean                  success;                                          \n"
"  GeglRectangle             roi;                                              \n"
"} ThreadData;                                                                 \n"
"                                                                              \n"
"static void                                                                   \n"
"thread_process (gpointer thread_data, gpointer unused)                        \n"
"{                                                                             \n"
"  ThreadData *data = thread_data;                                             \n"
"  if (!data->klass->process (data->operation,                                 \n"
"                       data->input, data->output, &data->roi, data->level))   \n"
"    data->success = FALSE;                                                    \n"
"  g_atomic_int_add (data->pending, -1);                                       \n"
"}                                                                             \n"
"                                                                              \n"
"int gegl_config_threads (void);                                               \n"
"                                                                              \n"
"static GThreadPool *                                                          \n"
"thread_pool (void)                                                            \n"
"{                                                                             \n"
"  static GThreadPool *pool = NULL;                                            \n"
"  if (!pool)                                                                  \n"
"    {                                                                         \n"
"      pool =  g_thread_pool_new (thread_process, NULL, gegl_config_threads (),\n"
"                                 FALSE, NULL);                                \n"
"    }                                                                         \n"
"  return pool;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"get_derivative (gfloat       *pixel1,                                         \n"
"                gfloat       *pixel2,                                         \n"
"                gboolean      has_alpha,                                      \n"
"                GeglWindEdge  edge,                                           \n"
"                gfloat       *derivative)                                     \n"
"{                                                                             \n"
"  gint i;                                                                     \n"
"                                                                              \n"
"  for (i = 0; i < 3; i++)                                                     \n"
"    derivative[i] = pixel2[i] - pixel1[i];                                    \n"
"                                                                              \n"
"  if (has_alpha)                                                              \n"
"    derivative[3] = pixel2[3] - pixel1[3];                                    \n"
"  else                                                                        \n"
"    derivative[3] = 0.0;                                                      \n"
"                                                                              \n"
"  if (edge == GEGL_WIND_EDGE_BOTH)                                            \n"
"    {                                                                         \n"
"      for (i = 0; i < 4; i++)                                                 \n"
"        derivative[i] = fabs (derivative[i]);                                 \n"
"    }                                                                         \n"
"  else if (edge == GEGL_WIND_EDGE_LEADING)                                    \n"
"    {                                                                         \n"
"      for (i = 0; i < 4; i++)                                                 \n"
"        derivative[i] = - derivative[i];                                      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"threshold_exceeded (gfloat         *pixel1,                                   \n"
"                    gfloat         *pixel2,                                   \n"
"                    gboolean        has_alpha,                                \n"
"                    GeglWindEdge    edge,                                     \n"
"                    gint            threshold)                                \n"
"{                                                                             \n"
"  gfloat derivative[4];                                                       \n"
"  gint i;                                                                     \n"
"  gfloat sum = 0.0;                                                           \n"
"                                                                              \n"
"  get_derivative (pixel1, pixel2, has_alpha, edge, derivative);               \n"
"                                                                              \n"
"  for (i = 0; i < 4; i++)                                                     \n"
"    sum += derivative[i];                                                     \n"
"                                                                              \n"
"  return ((sum / 4.0f) > (threshold / 200.0));                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"reverse_buffer (gfloat *buffer,                                               \n"
"                gint    length,                                               \n"
"                gint    bytes)                                                \n"
"{                                                                             \n"
"  gint b, i, si;                                                              \n"
"  gfloat temp;                                                                \n"
"  gint midpoint;                                                              \n"
"                                                                              \n"
"  midpoint = length / 2;                                                      \n"
"  for (i = 0; i < midpoint; i += bytes)                                       \n"
"    {                                                                         \n"
"      si = length - bytes - i;                                                \n"
"                                                                              \n"
"      for (b = 0; b < bytes; b++)                                             \n"
"        {                                                                     \n"
"          temp = buffer[i + b];                                               \n"
"          buffer[i + b] = buffer[si + b];                                     \n"
"          buffer[si + b] = temp;                                              \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"render_wind_row (gfloat         *buffer,                                      \n"
"                 gint            n_components,                                \n"
"                 gint            lpi,                                         \n"
"                 GeglProperties *o,                                           \n"
"                 GRand          *gr)                                          \n"
"{                                                                             \n"
"  gfloat *blend_color;                                                        \n"
"  gfloat *target_color;                                                       \n"
"  gfloat *blend_amt;                                                          \n"
"  gboolean has_alpha;                                                         \n"
"  gint i, j, b;                                                               \n"
"  gint bleed_length;                                                          \n"
"  gint n;                                                                     \n"
"  gint sbi;  /* starting bleed index */                                       \n"
"  gint lbi;      /* last bleed index */                                       \n"
"  gdouble denominator;                                                        \n"
"  gint comp_stride = n_components * COMPARE_WIDTH;                            \n"
"                                                                              \n"
"  target_color = g_new0 (gfloat, n_components);                               \n"
"  blend_color  = g_new0 (gfloat, n_components);                               \n"
"  blend_amt    = g_new0 (gfloat, n_components);                               \n"
"                                                                              \n"
"  has_alpha = n_components > 3 ? TRUE : FALSE;                                \n"
"                                                                              \n"
"  for (j = 0; j < lpi; j += n_components)                                     \n"
"    {                                                                         \n"
"      gint pxi = j;                                                           \n"
"                                                                              \n"
"      if (threshold_exceeded (buffer + pxi,                                   \n"
"                              buffer + pxi + comp_stride,                     \n"
"                              has_alpha,                                      \n"
"                              o->edge,                                        \n"
"                              o->threshold))                                  \n"
"        {                                                                     \n"
"          gdouble bleed_length_max;                                           \n"
"          sbi = pxi + comp_stride;                                            \n"
"                                                                              \n"
"          for (b = 0; b < n_components; b++)                                  \n"
"            {                                                                 \n"
"              blend_color[b]  = buffer[pxi + b];                              \n"
"              target_color[b] = buffer[sbi + b];                              \n"
"            }                                                                 \n"
"                                                                              \n"
"          if (g_rand_int_range (gr, 0, 3))                                    \n"
"            {                                                                 \n"
"              bleed_length_max = o->strength;                                 \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              bleed_length_max = 4 * o->strength;                             \n"
"            }                                                                 \n"
"                                                                              \n"
"          bleed_length = 1 + (gint) (bleed_length_max * g_rand_double (gr));  \n"
"                                                                              \n"
"          lbi = sbi + bleed_length * n_components;                            \n"
"          if (lbi > lpi)                                                      \n"
"            {                                                                 \n"
"              lbi = lpi;                                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          for (b = 0; b < n_components; b++)                                  \n"
"            blend_amt[b] = target_color[b] - blend_color[b];                  \n"
"                                                                              \n"
"          denominator = 2.0 / (bleed_length * bleed_length + bleed_length);   \n"
"          n = bleed_length;                                                   \n"
"                                                                              \n"
"          for (i = sbi; i < lbi; i += n_components)                           \n"
"            {                                                                 \n"
"              if (!threshold_exceeded (buffer + pxi,                          \n"
"                                       buffer + i,                            \n"
"                                       has_alpha,                             \n"
"                                       o->edge,                               \n"
"                                       o->threshold)                          \n"
"                  && g_rand_boolean (gr))                                     \n"
"                {                                                             \n"
"                  break;                                                      \n"
"                }                                                             \n"
"                                                                              \n"
"              for (b = 0; b < n_components; b++)                              \n"
"                {                                                             \n"
"                  blend_color[b] += blend_amt[b] * n * denominator;           \n"
"                  blend_color[b] = CLAMP (blend_color[b], 0.0, 1.0);          \n"
"                  buffer[i + b] = (blend_color[b] * 2 + buffer[i + b]) / 3;   \n"
"                }                                                             \n"
"                                                                              \n"
"              if (threshold_exceeded (buffer + i,                             \n"
"                                      buffer + i + comp_stride,               \n"
"                                      has_alpha,                              \n"
"                                      GEGL_WIND_EDGE_BOTH,                    \n"
"                                      o->threshold))                          \n"
"                {                                                             \n"
"                  for (b = 0; b < n_components; b++)                          \n"
"                    {                                                         \n"
"                      target_color[b] = buffer[i + comp_stride + b];          \n"
"                      blend_amt[b] = target_color[b] - blend_color[b];        \n"
"                    }                                                         \n"
"                                                                              \n"
"                  denominator = 2.0 / (n * n + n);                            \n"
"                }                                                             \n"
"              n--;                                                            \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (target_color);                                                      \n"
"  g_free (blend_color);                                                       \n"
"  g_free (blend_amt);                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"render_blast_row (gfloat         *buffer,                                     \n"
"                  gint            n_components,                               \n"
"                  gint            lpi,                                        \n"
"                  GeglProperties *o,                                          \n"
"                  GRand          *gr)                                         \n"
"{                                                                             \n"
"  gint sbi, lbi;                                                              \n"
"  gint bleed_length;                                                          \n"
"  gint i, j, b;                                                               \n"
"  gint weight, random_factor;                                                 \n"
"  gboolean skip = FALSE;                                                      \n"
"                                                                              \n"
"  for (j = 0; j < lpi; j += n_components)                                     \n"
"    {                                                                         \n"
"      gfloat *pbuf = buffer + j;                                              \n"
"                                                                              \n"
"      if (threshold_exceeded (pbuf,                                           \n"
"                              pbuf + n_components,                            \n"
"                              n_components > 3,                               \n"
"                              o->edge,                                        \n"
"                              o->threshold))                                  \n"
"        {                                                                     \n"
"          sbi = j;                                                            \n"
"          weight = g_rand_int_range (gr, 0, 10);                              \n"
"                                                                              \n"
"          if (weight > 5)                                                     \n"
"            {                                                                 \n"
"              random_factor = 2;                                              \n"
"            }                                                                 \n"
"          else if (weight > 3)                                                \n"
"            {                                                                 \n"
"              random_factor = 3;                                              \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              random_factor = 4;                                              \n"
"            }                                                                 \n"
"                                                                              \n"
"          bleed_length = 0;                                                   \n"
"                                                                              \n"
"          switch (g_rand_int_range (gr, 0, random_factor))                    \n"
"            {                                                                 \n"
"            case 3:                                                           \n"
"              bleed_length += o->strength;                                    \n"
"            case 2:                                                           \n"
"              bleed_length += o->strength;                                    \n"
"            case 1:                                                           \n"
"              bleed_length += o->strength;                                    \n"
"            case 0:                                                           \n"
"              bleed_length += o->strength;                                    \n"
"            }                                                                 \n"
"                                                                              \n"
"          lbi = sbi + n_components * bleed_length;                            \n"
"          if (lbi > lpi)                                                      \n"
"            {                                                                 \n"
"              lbi = lpi;                                                      \n"
"            }                                                                 \n"
"                                                                              \n"
"          for (i = sbi; i < lbi; i += n_components)                           \n"
"            for (b = 0; b < n_components; b++)                                \n"
"                buffer[i+b] = *(pbuf + b);                                    \n"
"                                                                              \n"
"          j = lbi - n_components;                                             \n"
"                                                                              \n"
"          if (g_rand_int_range (gr, 0, 10) > 7)                               \n"
"            {                                                                 \n"
"              skip = TRUE;                                                    \n"
"            }                                                                 \n"
"        }                                                                     \n"
"    }                                                                         \n"
"  return skip;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  const Babl *in_format = gegl_operation_get_source_format (operation, \"input\");\n"
"  const Babl *format = babl_format (\"RGB float\");                           \n"
"                                                                              \n"
"  if (in_format)                                                              \n"
"  {                                                                           \n"
"    if (babl_format_has_alpha (in_format))                                    \n"
"      format = babl_format (\"RGBA float\");                                  \n"
"  }                                                                           \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle  *boundary;                                                   \n"
"  GeglRectangle   result;                                                     \n"
"                                                                              \n"
"  boundary = gegl_operation_source_get_bounding_box (operation, \"input\");   \n"
"  result   = *roi;                                                            \n"
"                                                                              \n"
"  if (o->direction == GEGL_WIND_DIRECTION_LEFT ||                             \n"
"      o->direction == GEGL_WIND_DIRECTION_RIGHT)                              \n"
"    {                                                                         \n"
"      result.x     = boundary->x;                                             \n"
"      result.width = boundary->width;                                         \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      result.y      = boundary->y;                                            \n"
"      result.height = boundary->height;                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *operation,                      \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  GeglRectangle  *boundary;                                                   \n"
"  GeglRectangle   result;                                                     \n"
"                                                                              \n"
"  boundary = gegl_operation_source_get_bounding_box (operation, \"input\");   \n"
"  result   = *roi;                                                            \n"
"                                                                              \n"
"  if (o->direction == GEGL_WIND_DIRECTION_TOP)                                \n"
"    {                                                                         \n"
"      result.height = boundary->height - roi->y;                              \n"
"    }                                                                         \n"
"  else if (o->direction == GEGL_WIND_DIRECTION_BOTTOM)                        \n"
"    {                                                                         \n"
"      result.y      = boundary->y;                                            \n"
"      result.height = boundary->height - roi->y + roi->height;                \n"
"    }                                                                         \n"
"  else if (o->direction == GEGL_WIND_DIRECTION_RIGHT)                         \n"
"    {                                                                         \n"
"      result.x     = boundary->x;                                             \n"
"      result.width = boundary->width - roi->x + roi->width;                   \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      result.width = boundary->width - roi->x;                                \n"
"    }                                                                         \n"
"                                                                              \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"operation_process (GeglOperation        *operation,                           \n"
"                   GeglOperationContext *context,                             \n"
"                   const gchar          *output_prop,                         \n"
"                   const GeglRectangle  *result,                              \n"
"                   gint                  level)                               \n"
"{                                                                             \n"
"  GeglProperties           *o = GEGL_PROPERTIES (operation);                  \n"
"  GeglOperationFilterClass *klass;                                            \n"
"  GeglBuffer               *input;                                            \n"
"  GeglBuffer               *output;                                           \n"
"  gboolean                  success = FALSE;                                  \n"
"                                                                              \n"
"  klass = GEGL_OPERATION_FILTER_GET_CLASS (operation);                        \n"
"                                                                              \n"
"  g_assert (klass->process);                                                  \n"
"                                                                              \n"
"  if (strcmp (output_prop, \"output\"))                                       \n"
"    {                                                                         \n"
"      g_warning (\"requested processing of %s pad on a filter\", output_prop);\n"
"      return FALSE;                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  input  = gegl_operation_context_get_source (context, \"input\");            \n"
"  output = gegl_operation_context_get_target (context, \"output\");           \n"
"                                                                              \n"
"  if (gegl_operation_use_threading (operation, result))                       \n"
"  {                                                                           \n"
"    gint threads = gegl_config_threads ();                                    \n"
"    GThreadPool *pool = thread_pool ();                                       \n"
"    ThreadData thread_data[32];                                               \n"
"    gint pending = threads;                                                   \n"
"                                                                              \n"
"    if (o->direction == GEGL_WIND_DIRECTION_LEFT ||                           \n"
"        o->direction == GEGL_WIND_DIRECTION_RIGHT)                            \n"
"    {                                                                         \n"
"      gint bit = result->height / threads;                                    \n"
"      for (gint j = 0; j < threads; j++)                                      \n"
"      {                                                                       \n"
"        thread_data[j].roi.x = result->x;                                     \n"
"        thread_data[j].roi.width = result->width;                             \n"
"        thread_data[j].roi.y = result->y + bit * j;                           \n"
"        thread_data[j].roi.height = bit;                                      \n"
"      }                                                                       \n"
"      thread_data[threads-1].roi.height = result->height - (bit * (threads-1));\n"
"    }                                                                         \n"
"    else                                                                      \n"
"    {                                                                         \n"
"      gint bit = result->width / threads;                                     \n"
"      for (gint j = 0; j < threads; j++)                                      \n"
"      {                                                                       \n"
"        thread_data[j].roi.y = result->y;                                     \n"
"        thread_data[j].roi.height = result->height;                           \n"
"        thread_data[j].roi.x = result->x + bit * j;                           \n"
"        thread_data[j].roi.width = bit;                                       \n"
"      }                                                                       \n"
"      thread_data[threads-1].roi.width = result->width - (bit * (threads-1)); \n"
"    }                                                                         \n"
"    for (gint i = 0; i < threads; i++)                                        \n"
"    {                                                                         \n"
"      thread_data[i].klass = klass;                                           \n"
"      thread_data[i].operation = operation;                                   \n"
"      thread_data[i].input = input;                                           \n"
"      thread_data[i].output = output;                                         \n"
"      thread_data[i].pending = &pending;                                      \n"
"      thread_data[i].level = level;                                           \n"
"      thread_data[i].success = TRUE;                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"    for (gint i = 1; i < threads; i++)                                        \n"
"      g_thread_pool_push (pool, &thread_data[i], NULL);                       \n"
"    thread_process (&thread_data[0], NULL);                                   \n"
"                                                                              \n"
"    while (g_atomic_int_get (&pending)) {};                                   \n"
"                                                                              \n"
"    success = thread_data[0].success;                                         \n"
"  }                                                                           \n"
"  else                                                                        \n"
"  {                                                                           \n"
"    success = klass->process (operation, input, output, result, level);       \n"
"  }                                                                           \n"
"                                                                              \n"
"  if (input != NULL)                                                          \n"
"    g_object_unref (input);                                                   \n"
"                                                                              \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *format = gegl_operation_get_format (operation, \"output\");     \n"
"  gint n_components = babl_format_get_n_components (format);                  \n"
"                                                                              \n"
"  gint           y, row_size;                                                 \n"
"  gint           row_start, row_end;                                          \n"
"  GeglRectangle  row_rect;                                                    \n"
"  gfloat        *row_buf;                                                     \n"
"  GRand         *gr;                                                          \n"
"  gboolean       skip_rows;                                                   \n"
"  gboolean       need_reverse;                                                \n"
"  gboolean       horizontal_effect;                                           \n"
"  gint           last_pix;                                                    \n"
"                                                                              \n"
"  gr = g_rand_new ();                                                         \n"
"                                                                              \n"
"  horizontal_effect = (o->direction == GEGL_WIND_DIRECTION_LEFT ||            \n"
"                       o->direction == GEGL_WIND_DIRECTION_RIGHT);            \n"
"                                                                              \n"
"  need_reverse = (o->direction == GEGL_WIND_DIRECTION_RIGHT ||                \n"
"                  o->direction == GEGL_WIND_DIRECTION_TOP);                   \n"
"                                                                              \n"
"  if (horizontal_effect)                                                      \n"
"    {                                                                         \n"
"      row_size   = result->width * n_components;                              \n"
"      row_start  = result->y;                                                 \n"
"      row_end    = result->y + result->height;                                \n"
"      row_rect.x = result->x;                                                 \n"
"      row_rect.width  = result->width;                                        \n"
"      row_rect.height = 1;                                                    \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      row_size  = result->height * n_components;                              \n"
"      row_start = result->x;                                                  \n"
"      row_end   = result->x + result->width;                                  \n"
"      row_rect.y = result->y;                                                 \n"
"      row_rect.width  = 1;                                                    \n"
"      row_rect.height = result->height;                                       \n"
"    }                                                                         \n"
"                                                                              \n"
"  row_buf = g_new (gfloat, row_size);                                         \n"
"                                                                              \n"
"  for (y = row_start; y < row_end; y++)                                       \n"
"    {                                                                         \n"
"      if (horizontal_effect)                                                  \n"
"        row_rect.y = y;                                                       \n"
"      else                                                                    \n"
"        row_rect.x = y;                                                       \n"
"                                                                              \n"
"      gegl_buffer_get (input, &row_rect, 1.0, format, row_buf,                \n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      if (need_reverse)                                                       \n"
"        reverse_buffer (row_buf, row_size, n_components);                     \n"
"                                                                              \n"
"      if (o->style == GEGL_WIND_STYLE_WIND)                                   \n"
"        {                                                                     \n"
"          last_pix  = row_size - (n_components * COMPARE_WIDTH);              \n"
"          skip_rows = FALSE;                                                  \n"
"          render_wind_row (row_buf, n_components, last_pix, o, gr);           \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          last_pix = row_size - n_components;                                 \n"
"          skip_rows = render_blast_row (row_buf, n_components, last_pix, o, gr);\n"
"        }                                                                     \n"
"                                                                              \n"
"      if (need_reverse)                                                       \n"
"        reverse_buffer (row_buf, row_size, n_components);                     \n"
"                                                                              \n"
"      gegl_buffer_set (output, &row_rect, level, format, row_buf,             \n"
"                       GEGL_AUTO_ROWSTRIDE);                                  \n"
"                                                                              \n"
"      if (skip_rows)                                                          \n"
"        {                                                                     \n"
"          GeglRectangle rect   = row_rect;                                    \n"
"          gint          n_rows = g_rand_int_range (gr, 1, 3);                 \n"
"                                                                              \n"
"          if (horizontal_effect)                                              \n"
"            {                                                                 \n"
"              rect.y      = y + 1;                                            \n"
"              rect.height = n_rows;                                           \n"
"            }                                                                 \n"
"          else                                                                \n"
"            {                                                                 \n"
"              rect.x     = y + 1;                                             \n"
"              rect.width = n_rows;                                            \n"
"            }                                                                 \n"
"                                                                              \n"
"          gegl_buffer_copy (input, &rect, GEGL_ABYSS_CLAMP, output, &rect);   \n"
"          y += n_rows;                                                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_rand_free (gr);                                                           \n"
"  g_free (row_buf);                                                           \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process                    = process;                         \n"
"  operation_class->process                 = operation_process;               \n"
"  operation_class->prepare                 = prepare;                         \n"
"  operation_class->get_cached_region       = get_cached_region;               \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->opencl_support          = FALSE;                           \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"     \"name\",       \"gegl:wind\",                                           \n"
"     \"title\",      _(\"Wind\"),                                             \n"
"     \"categories\", \"distort\",                                             \n"
"     \"license\",    \"GPL3+\",                                               \n"
"     \"description\", _(\"Wind-like bleed effect\"),                          \n"
"     NULL);                                                                   \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
