/**
 * WinPR: Windows Portable Runtime
 * Time Zone
 *
 * Copyright 2012 Marc-Andre Moreau <marcandre.moreau@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <winpr/wtypes.h>
#include <winpr/timezone.h>
#include <winpr/crt.h>
#include "../log.h"

#define TAG WINPR_TAG("timezone")

#ifndef _WIN32

#include <time.h>
#include <unistd.h>


struct _TIME_ZONE_RULE_ENTRY
{
	UINT64 TicksStart;
	UINT64 TicksEnd;
	INT32 DaylightDelta;
	SYSTEMTIME StandardDate;
	SYSTEMTIME DaylightDate;
};
typedef struct _TIME_ZONE_RULE_ENTRY TIME_ZONE_RULE_ENTRY;

struct _TIME_ZONE_ENTRY
{
	const char* Id;
	INT32 Bias;
	BOOL SupportsDST;
	const char* DisplayName;
	const char* StandardName;
	const char* DaylightName;
	TIME_ZONE_RULE_ENTRY* RuleTable;
	UINT32 RuleTableCount;
};
typedef struct _TIME_ZONE_ENTRY TIME_ZONE_ENTRY;

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_2[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_5[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_7[] =
{
	{ 633978324000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633979188000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_9[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_11[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_12[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_14[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_15[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 6, 2, 22, 0 }, { 0, 10, 6, 2, 22, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 6, 5, 22, 0 }, { 0, 10, 6, 2, 22, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 2, 22, 0 }, { 0, 10, 6, 2, 22, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 4, 6, 1, 22, 0 }, { 0, 10, 6, 2, 22, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 5, 6, 1, 22, 0 }, { 0, 8, 6, 3, 22, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 4, 6, 5, 22, 0 }, { 0, 9, 6, 1, 22, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 4, 6, 5, 22, 0 }, { 0, 9, 6, 1, 22, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 4, 6, 5, 22, 0 }, { 0, 9, 6, 1, 22, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 3155378292000000000ULL, 635872212000000000ULL, 60, { 0, 5, 6, 2, 22, 0 }, { 0, 8, 6, 2, 22, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_16[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_19[] =
{
	{ 635555988000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 1, 4, 1, 0, 0 }, { 0, 2, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_20[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_21[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 4, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, },
	{ 3155378292000000000ULL, 636188436000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_22[] =
{
	{ 632084436000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 4, 0, 1, 0, 0 }, },
	{ 632400660000000000ULL, 632085300000000000ULL, 60, { 0, 1, 4, 1, 0, 0 }, { 0, 3, 0, 5, 0, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 3, 0, 2, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 3, 0, 3, 0, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 3, 0, 2, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 3, 0, 2, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 11, 0, 2, 1, 0 }, { 0, 3, 0, 3, 0, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 11, 0, 1, 1, 0 }, { 0, 4, 0, 1, 0, 0 }, },
	{ 3155378292000000000ULL, 634926132000000000ULL, 60, { 0, 11, 0, 1, 1, 0 }, { 0, 3, 0, 2, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_23[] =
{
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_24[] =
{
	{ 633662964000000000ULL, 180000000000ULL, 60, { 0, 3, 6, 2, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 1, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 4, 6, 2, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 4, 6, 2, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 3, 6, 4, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 3, 6, 4, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 3, 6, 3, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 3, 6, 5, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 3, 6, 5, 23, 59 }, { 0, 9, 6, 5, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 3, 6, 4, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 3, 6, 4, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 3, 6, 3, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, },
	{ 3155378292000000000ULL, 637450740000000000ULL, 60, { 0, 3, 6, 5, 23, 59 }, { 0, 10, 6, 1, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_25[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_26[] =
{
	{ 633346740000000000ULL, 633032244000000000ULL, 30, { 0, 12, 0, 2, 3, 0 }, { 0, 1, 1, 1, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -30, { 0, 5, 0, 1, 2, 30 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_27[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 1, 4, 1, 0, 0 }, { 0, 11, 2, 1, 0, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 0, 3, 0, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 11, 0, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 2, 6, 5, 23, 59 }, { 0, 10, 0, 2, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 0, 3, 0, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 2, 6, 2, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 638395956000000000ULL, 638081460000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 638712180000000000ULL, 638396820000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639027540000000000ULL, 638713044000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639342900000000000ULL, 639028404000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639658260000000000ULL, 639343764000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639974484000000000ULL, 639659124000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 640289844000000000ULL, 639975348000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 640605204000000000ULL, 640290708000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 640920564000000000ULL, 640606068000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 641236788000000000ULL, 640921428000000000ULL, 60, { 0, 2, 6, 2, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 641552148000000000ULL, 641237652000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 641867508000000000ULL, 641553012000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 642182868000000000ULL, 641868372000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 642499092000000000ULL, 642183732000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 642814452000000000ULL, 642499956000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 643129812000000000ULL, 642815316000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 643445172000000000ULL, 643130676000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 3155378292000000000ULL, 643446036000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_29[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 6, 2, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 6, 5, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 2, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 5, 6, 1, 23, 59 }, { 0, 8, 6, 3, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 4, 6, 5, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 4, 6, 5, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 4, 6, 5, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 3155378292000000000ULL, 635872212000000000ULL, 60, { 0, 5, 6, 2, 23, 59 }, { 0, 8, 6, 2, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_30[] =
{
	{ 635555988000000000ULL, 180000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 1, 4, 1, 0, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_31[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 0, 1 }, { 0, 4, 0, 1, 0, 1 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 2, 0, 1 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 2, 0, 1 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 2, 0, 1 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 11, 0, 1, 0, 1 }, { 0, 3, 0, 2, 0, 1 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 0, 1 }, },
	{ 3155378292000000000ULL, 634609908000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_32[] =
{
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 1, 0, 1, 0, 0 }, { 0, 10, 0, 3, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 1, 2, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_33[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 2, 6, 2, 23, 59 }, { 0, 11, 2, 1, 0, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 0, 3, 0, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 11, 0, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 2, 6, 5, 23, 59 }, { 0, 10, 0, 2, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 0, 3, 0, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 2, 6, 2, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 638395956000000000ULL, 638081460000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 638712180000000000ULL, 638396820000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639027540000000000ULL, 638713044000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639342900000000000ULL, 639028404000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639658260000000000ULL, 639343764000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 639974484000000000ULL, 639659124000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 640289844000000000ULL, 639975348000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 640605204000000000ULL, 640290708000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 640920564000000000ULL, 640606068000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 641236788000000000ULL, 640921428000000000ULL, 60, { 0, 2, 6, 2, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 641552148000000000ULL, 641237652000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 641867508000000000ULL, 641553012000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 642182868000000000ULL, 641868372000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 642499092000000000ULL, 642183732000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 642814452000000000ULL, 642499956000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 643129812000000000ULL, 642815316000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 643445172000000000ULL, 643130676000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 3155378292000000000ULL, 643446036000000000ULL, 60, { 0, 2, 6, 3, 23, 59 }, { 0, 10, 6, 3, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_35[] =
{
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 1, 1, 1, 0, 0 }, { 0, 12, 0, 5, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 0, 3, 0, 0 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 2, 23, 59 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_36[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 4, 22, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 6, 4, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 4, 22, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 6, 4, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 4, 22, 0 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 10, 6, 4, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, },
	{ 3155378292000000000ULL, 637450740000000000ULL, 60, { 0, 10, 6, 5, 23, 0 }, { 0, 3, 6, 5, 22, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_37[] =
{
	{ 635555988000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 2, 2, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 3, 0, 2, 2, 0 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_38[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 6, 2, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 6, 5, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 6, 2, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 4, 6, 1, 23, 59 }, { 0, 10, 6, 2, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 5, 6, 1, 23, 59 }, { 0, 8, 6, 3, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 4, 6, 5, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 4, 6, 5, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 4, 6, 5, 23, 59 }, { 0, 9, 6, 1, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 5, 6, 2, 23, 59 }, { 0, 8, 6, 2, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_39[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 4, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633032244000000000ULL, 60, { 0, 11, 0, 1, 2, 0 }, { 0, 3, 0, 2, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_40[] =
{
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 10, 6, 3, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 2, 6, 4, 23, 59 }, { 0, 1, 0, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_42[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 9, 0, 5, 2, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_43[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 1, 0 }, { 0, 3, 0, 5, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_46[] =
{
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 8, 0, 5, 23, 59 }, { 0, 5, 6, 5, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 8, 4, 3, 23, 59 }, { 0, 5, 0, 5, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 8, 6, 1, 23, 59 }, { 0, 5, 6, 1, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 7, 6, 5, 23, 59 }, { 0, 4, 6, 1, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 9, 0, 5, 3, 0 }, { 0, 4, 0, 5, 2, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 4, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 7, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_47[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 0, 5, 1, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_49[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_50[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_51[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_52[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_54[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 4, 0, 1, 2, 0 }, { 0, 9, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_55[] =
{
	{ 634609044000000000ULL, 180000000000ULL, 60, { 0, 10, 5, 5, 1, 0 }, { 0, 3, 4, 5, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 1, 0, 1, 0, 0 }, { 0, 3, 4, 5, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 12, 5, 3, 0, 0 }, { 0, 1, 2, 1, 0, 0 }, },
	{ 3155378292000000000ULL, 635241492000000000ULL, 60, { 0, 10, 5, 5, 1, 0 }, { 0, 3, 4, 5, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_56[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 0, 5, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_57[] =
{
	{ 633978324000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 0, 0 }, { 0, 3, 0, 5, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 4, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 6, 4, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 4, 23, 59 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 10, 6, 4, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, },
	{ 3155378292000000000ULL, 637450740000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 3, 6, 5, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_58[] =
{
	{ 632716020000000000ULL, 180000000000ULL, 60, { 0, 9, 4, 5, 23, 59 }, { 0, 4, 5, 5, 0, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 9, 4, 3, 23, 59 }, { 0, 4, 5, 5, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 9, 4, 1, 23, 59 }, { 0, 4, 4, 5, 23, 59 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 8, 4, 5, 23, 59 }, { 0, 4, 4, 5, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 8, 4, 3, 23, 59 }, { 0, 4, 4, 4, 23, 59 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 9, 4, 5, 23, 59 }, { 0, 4, 4, 5, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 9, 4, 5, 23, 59 }, { 0, 5, 4, 3, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_59[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_60[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 9, 4, 5, 23, 59 }, { 0, 4, 4, 1, 0, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 9, 5, 5, 23, 59 }, { 0, 4, 5, 1, 0, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 9, 4, 3, 23, 59 }, { 0, 4, 6, 1, 0, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 11, 4, 1, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 5, 5, 23, 59 }, { 0, 4, 5, 1, 0, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 4, 5, 1, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 4, 5, 1, 0, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 4, 4, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 4, 4, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, },
	{ 3155378292000000000ULL, 637134516000000000ULL, 60, { 0, 10, 4, 5, 23, 59 }, { 0, 3, 5, 5, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_61[] =
{
	{ 634925268000000000ULL, 180000000000ULL, 60, { 0, 9, 5, 3, 1, 0 }, { 0, 3, 4, 5, 23, 59 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 9, 4, 5, 23, 59 }, { 0, 3, 4, 5, 23, 59 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 4, 4, 23, 59 }, { 0, 3, 4, 5, 23, 59 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 4, 4, 23, 59 }, { 0, 3, 5, 5, 23, 59 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 6, 5, 1, 0 }, { 0, 3, 6, 5, 1, 0 }, },
	{ 3155378292000000000ULL, 636188436000000000ULL, 60, { 0, 10, 6, 5, 1, 0 }, { 0, 3, 6, 5, 1, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_63[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 0, 5, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_64[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 9, 3, 4, 1, 0 }, { 0, 4, 3, 1, 1, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 10, 0, 2, 2, 0 }, { 0, 4, 5, 1, 2, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 9, 0, 3, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 9, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 9, 0, 2, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 0, 1, 2, 0 }, { 0, 4, 5, 1, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 9, 0, 4, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 4, 2, 0 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 4, 2, 0 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 5, 2, 0 }, },
	{ 3155378292000000000ULL, 638081460000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 3, 5, 4, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_65[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_66[] =
{
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 11, 6, 2, 2, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 1, 2, 1, 0, 0 }, { 0, 3, 5, 5, 1, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_67[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 10, 5, 1, 4, 0 }, { 0, 4, 4, 1, 3, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 10, 6, 1, 4, 0 }, { 0, 4, 5, 1, 3, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 10, 0, 1, 4, 0 }, { 0, 4, 6, 1, 3, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 10, 1, 1, 4, 0 }, { 0, 4, 0, 1, 3, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_68[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 0, 5, 3, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 1, 5, 3, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 0, 5, 3, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 0, 5, 3, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 4, 0 }, { 0, 3, 1, 5, 3, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 11, 0, 2, 4, 0 }, { 0, 3, 0, 5, 3, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 3, 0, 5, 3, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_70[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_71[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_73[] =
{
	{ 632400660000000000ULL, 180000000000ULL, 60, { 0, 9, 1, 3, 23, 59 }, { 0, 3, 0, 3, 0, 0 }, },
	{ 632716020000000000ULL, 632401524000000000ULL, 60, { 0, 9, 3, 3, 23, 59 }, { 0, 3, 2, 4, 0, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 9, 6, 3, 23, 59 }, { 0, 3, 5, 3, 0, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 9, 1, 3, 23, 59 }, { 0, 3, 0, 4, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 9, 2, 3, 23, 59 }, { 0, 3, 1, 4, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 9, 3, 3, 23, 59 }, { 0, 3, 2, 4, 0, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 9, 4, 3, 23, 59 }, { 0, 3, 3, 3, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 9, 6, 3, 23, 59 }, { 0, 3, 5, 4, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 9, 0, 3, 23, 59 }, { 0, 3, 6, 4, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 9, 1, 3, 23, 59 }, { 0, 3, 0, 4, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 9, 2, 3, 23, 59 }, { 0, 3, 1, 3, 0, 0 }, },
	{ 636502932000000000ULL, 636188436000000000ULL, 60, { 0, 9, 4, 3, 23, 59 }, { 0, 3, 3, 4, 0, 0 }, },
	{ 636818292000000000ULL, 636503796000000000ULL, 60, { 0, 9, 5, 3, 23, 59 }, { 0, 3, 4, 4, 0, 0 }, },
	{ 637133652000000000ULL, 636819156000000000ULL, 60, { 0, 9, 6, 3, 23, 59 }, { 0, 3, 5, 4, 0, 0 }, },
	{ 637449876000000000ULL, 637134516000000000ULL, 60, { 0, 9, 0, 3, 23, 59 }, { 0, 3, 6, 3, 0, 0 }, },
	{ 637765236000000000ULL, 637450740000000000ULL, 60, { 0, 9, 2, 3, 23, 59 }, { 0, 3, 1, 4, 0, 0 }, },
	{ 638080596000000000ULL, 637766100000000000ULL, 60, { 0, 9, 3, 3, 23, 59 }, { 0, 3, 2, 4, 0, 0 }, },
	{ 638395956000000000ULL, 638081460000000000ULL, 60, { 0, 9, 4, 3, 23, 59 }, { 0, 3, 3, 4, 0, 0 }, },
	{ 3155378292000000000ULL, 638396820000000000ULL, 60, { 0, 9, 5, 3, 23, 59 }, { 0, 3, 4, 3, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_75[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 3, 0, 5, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_76[] =
{
	{ 635871348000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 5, 0 }, { 0, 3, 0, 5, 4, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_77[] =
{
	{ 633978324000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 1, 5, 1, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_78[] =
{
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 1, 2, 1, 0, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 0, 5, 2, 0 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_79[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 12, 0, 1, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_81[] =
{
	{ 634609044000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_84[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_85[] =
{
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 10, 5, 5, 23, 59 }, { 0, 5, 6, 5, 23, 59 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 10, 6, 5, 23, 59 }, { 0, 4, 2, 2, 23, 59 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_90[] =
{
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 12, 4, 5, 23, 59 }, { 0, 6, 5, 3, 23, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_91[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_94[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 3, 0, 5, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_95[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 9, 6, 5, 2, 0 }, { 0, 3, 6, 5, 2, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 9, 5, 5, 23, 59 }, { 0, 3, 6, 5, 2, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 9, 5, 4, 23, 59 }, { 0, 3, 6, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_96[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_97[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 7, 0, 4, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_98[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 5, 0, 5, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_100[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_102[] =
{
	{ 633031380000000000ULL, 632716884000000000ULL, 60, { 0, 1, 0, 1, 0, 0 }, { 0, 12, 0, 1, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 633662964000000000ULL, 633347604000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_104[] =
{
	{ 635871348000000000ULL, 635556852000000000ULL, 60, { 0, 9, 5, 5, 23, 59 }, { 0, 3, 6, 5, 2, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 9, 5, 4, 23, 59 }, { 0, 3, 6, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_105[] =
{
	{ 635555988000000000ULL, 180000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 30, { 0, 8, 5, 2, 23, 59 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_107[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 120, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 3, 0, 5, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_110[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_111[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_114[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_116[] =
{
	{ 633346740000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_117[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_118[] =
{
	{ 632716020000000000ULL, 180000000000ULL, 30, { 0, 3, 0, 5, 2, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 633031380000000000ULL, 632716884000000000ULL, 30, { 0, 4, 0, 1, 2, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 30, { 0, 3, 0, 5, 2, 0 }, { 0, 10, 0, 5, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 30, { 0, 4, 0, 1, 2, 0 }, { 0, 10, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_119[] =
{
	{ 635240628000000000ULL, 180000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 1, 3, 1, 0, 0 }, { 0, 12, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_120[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_121[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 120, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 4, 0, 5, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_122[] =
{
	{ 635555988000000000ULL, 180000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 30, { 0, 10, 0, 1, 2, 0 }, { 0, 1, 4, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_123[] =
{
	{ 634293684000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 10, 0, 5, 2, 0 }, { 0, 1, 3, 1, 0, 0 }, },
	{ 635871348000000000ULL, 635556852000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 636187572000000000ULL, 635872212000000000ULL, -60, { 0, 3, 0, 5, 2, 0 }, { 0, 1, 5, 1, 0, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_125[] =
{
	{ 633978324000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 1, 5, 1, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 1, 6, 1, 0, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_126[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 3, 3, 0 }, { 0, 10, 0, 1, 2, 0 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 3, 0, 3, 3, 0 }, { 0, 9, 0, 5, 2, 0 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 0 }, { 0, 9, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_128[] =
{
	{ 633978324000000000ULL, 633663828000000000ULL, 60, { 0, 1, 4, 1, 0, 0 }, { 0, 11, 0, 5, 2, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 3, 0, 5, 3, 0 }, { 0, 10, 0, 4, 2, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 3, 0, 1, 3, 0 }, { 0, 10, 0, 4, 2, 0 }, },
	{ 634925268000000000ULL, 634609908000000000ULL, 60, { 0, 1, 0, 4, 3, 0 }, { 0, 10, 0, 3, 2, 0 }, },
	{ 635240628000000000ULL, 634926132000000000ULL, 60, { 0, 1, 0, 3, 3, 0 }, { 0, 10, 0, 4, 2, 0 }, },
	{ 635555988000000000ULL, 635241492000000000ULL, 60, { 0, 1, 0, 3, 2, 0 }, { 0, 11, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 635556852000000000ULL, 60, { 0, 1, 0, 3, 3, 0 }, { 0, 11, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_129[] =
{
	{ 3155378292000000000ULL, 180000000000ULL, 60, { 0, 10, 0, 5, 3, 0 }, { 0, 3, 0, 5, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_130[] =
{
	{ 633031380000000000ULL, 180000000000ULL, 60, { 0, 3, 0, 3, 3, 45 }, { 0, 10, 0, 1, 2, 45 }, },
	{ 633346740000000000ULL, 633032244000000000ULL, 60, { 0, 3, 0, 3, 3, 45 }, { 0, 9, 0, 5, 2, 45 }, },
	{ 3155378292000000000ULL, 633347604000000000ULL, 60, { 0, 4, 0, 1, 3, 45 }, { 0, 9, 0, 5, 2, 45 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_132[] =
{
	{ 636187572000000000ULL, 635872212000000000ULL, 60, { 0, 1, 5, 1, 0, 0 }, { 0, 11, 0, 1, 2, 0 }, },
	{ 3155378292000000000ULL, 636188436000000000ULL, 60, { 0, 1, 0, 3, 3, 0 }, { 0, 11, 0, 1, 2, 0 }, }
};

static const TIME_ZONE_RULE_ENTRY TimeZoneRuleTable_133[] =
{
	{ 633978324000000000ULL, 180000000000ULL, 0, { 0, 1, 0, 1, 0, 0 }, { 0, 1, 0, 1, 0, 0 }, },
	{ 634293684000000000ULL, 633979188000000000ULL, 60, { 0, 1, 5, 1, 0, 0 }, { 0, 9, 0, 5, 0, 0 }, },
	{ 634609044000000000ULL, 634294548000000000ULL, 60, { 0, 4, 6, 1, 4, 0 }, { 0, 9, 6, 4, 3, 0 }, },
	{ 3155378292000000000ULL, 634609908000000000ULL, 60, { 0, 4, 0, 1, 4, 0 }, { 0, 9, 0, 5, 3, 0 }, }
};

static const TIME_ZONE_ENTRY TimeZoneTable[] =
{
	{
		"Dateline Standard Time", 720, FALSE, "(UTC-12:00) International Date Line West",
		"Dateline Standard Time", "Dateline Daylight Time",
		NULL, 0
	},
	{
		"UTC-11", 660, FALSE, "(UTC-11:00) Coordinated Universal Time-11",
		"UTC-11", "UTC-11",
		NULL, 0
	},
	{
		"Aleutian Standard Time", 600, TRUE, "(UTC-10:00) Aleutian Islands",
		"Aleutian Standard Time", "Aleutian Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_2, 2
	},
	{
		"Hawaiian Standard Time", 600, FALSE, "(UTC-10:00) Hawaii",
		"Hawaiian Standard Time", "Hawaiian Daylight Time",
		NULL, 0
	},
	{
		"Marquesas Standard Time", 570, FALSE, "(UTC-09:30) Marquesas Islands",
		"Marquesas Standard Time", "Marquesas Daylight Time",
		NULL, 0
	},
	{
		"Alaskan Standard Time", 540, TRUE, "(UTC-09:00) Alaska",
		"Alaskan Standard Time", "Alaskan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_5, 2
	},
	{
		"UTC-09", 540, FALSE, "(UTC-09:00) Coordinated Universal Time-09",
		"UTC-09", "UTC-09",
		NULL, 0
	},
	{
		"Pacific Standard Time (Mexico)", 480, TRUE, "(UTC-08:00) Baja California",
		"Pacific Standard Time (Mexico)", "Pacific Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_7, 2
	},
	{
		"UTC-08", 480, FALSE, "(UTC-08:00) Coordinated Universal Time-08",
		"UTC-08", "UTC-08",
		NULL, 0
	},
	{
		"Pacific Standard Time", 480, TRUE, "(UTC-08:00) Pacific Time (US & Canada)",
		"Pacific Standard Time", "Pacific Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_9, 2
	},
	{
		"US Mountain Standard Time", 420, FALSE, "(UTC-07:00) Arizona",
		"US Mountain Standard Time", "US Mountain Daylight Time",
		NULL, 0
	},
	{
		"Mountain Standard Time (Mexico)", 420, TRUE, "(UTC-07:00) Chihuahua, La Paz, Mazatlan",
		"Mountain Standard Time (Mexico)", "Mountain Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_11, 1
	},
	{
		"Mountain Standard Time", 420, TRUE, "(UTC-07:00) Mountain Time (US & Canada)",
		"Mountain Standard Time", "Mountain Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_12, 2
	},
	{
		"Central America Standard Time", 360, FALSE, "(UTC-06:00) Central America",
		"Central America Standard Time", "Central America Daylight Time",
		NULL, 0
	},
	{
		"Central Standard Time", 360, TRUE, "(UTC-06:00) Central Time (US & Canada)",
		"Central Standard Time", "Central Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_14, 2
	},
	{
		"Easter Island Standard Time", 360, TRUE, "(UTC-06:00) Easter Island",
		"Easter Island Standard Time", "Easter Island Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_15, 10
	},
	{
		"Central Standard Time (Mexico)", 360, TRUE, "(UTC-06:00) Guadalajara, Mexico City, Monterrey",
		"Central Standard Time (Mexico)", "Central Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_16, 1
	},
	{
		"Canada Central Standard Time", 360, FALSE, "(UTC-06:00) Saskatchewan",
		"Canada Central Standard Time", "Canada Central Daylight Time",
		NULL, 0
	},
	{
		"SA Pacific Standard Time", 300, FALSE, "(UTC-05:00) Bogota, Lima, Quito, Rio Branco",
		"SA Pacific Standard Time", "SA Pacific Daylight Time",
		NULL, 0
	},
	{
		"Eastern Standard Time (Mexico)", 300, TRUE, "(UTC-05:00) Chetumal",
		"Eastern Standard Time (Mexico)", "Eastern Daylight Time (Mexico)",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_19, 2
	},
	{
		"Eastern Standard Time", 300, TRUE, "(UTC-05:00) Eastern Time (US & Canada)",
		"Eastern Standard Time", "Eastern Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_20, 2
	},
	{
		"Haiti Standard Time", 300, TRUE, "(UTC-05:00) Haiti",
		"Haiti Standard Time", "Haiti Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_21, 6
	},
	{
		"Cuba Standard Time", 300, TRUE, "(UTC-05:00) Havana",
		"Cuba Standard Time", "Cuba Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_22, 11
	},
	{
		"US Eastern Standard Time", 300, TRUE, "(UTC-05:00) Indiana (East)",
		"US Eastern Standard Time", "US Eastern Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_23, 2
	},
	{
		"Paraguay Standard Time", 240, TRUE, "(UTC-04:00) Asuncion",
		"Paraguay Standard Time", "Paraguay Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_24, 14
	},
	{
		"Atlantic Standard Time", 240, TRUE, "(UTC-04:00) Atlantic Time (Canada)",
		"Atlantic Standard Time", "Atlantic Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_25, 2
	},
	{
		"Venezuela Standard Time", 240, TRUE, "(UTC-04:00) Caracas",
		"Venezuela Standard Time", "Venezuela Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_26, 10
	},
	{
		"Central Brazilian Standard Time", 240, TRUE, "(UTC-04:00) Cuiaba",
		"Central Brazilian Standard Time", "Central Brazilian Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_27, 37
	},
	{
		"SA Western Standard Time", 240, FALSE, "(UTC-04:00) Georgetown, La Paz, Manaus, San Juan",
		"SA Western Standard Time", "SA Western Daylight Time",
		NULL, 0
	},
	{
		"Pacific SA Standard Time", 240, TRUE, "(UTC-04:00) Santiago",
		"Pacific SA Standard Time", "Pacific SA Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_29, 10
	},
	{
		"Turks And Caicos Standard Time", 240, TRUE, "(UTC-04:00) Turks and Caicos",
		"Turks and Caicos Standard Time", "Turks and Caicos Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_30, 2
	},
	{
		"Newfoundland Standard Time", 210, TRUE, "(UTC-03:30) Newfoundland",
		"Newfoundland Standard Time", "Newfoundland Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_31, 7
	},
	{
		"Tocantins Standard Time", 180, TRUE, "(UTC-03:00) Araguaina",
		"Tocantins Standard Time", "Tocantins Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_32, 2
	},
	{
		"E. South America Standard Time", 180, TRUE, "(UTC-03:00) Brasilia",
		"E. South America Standard Time", "E. South America Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_33, 37
	},
	{
		"SA Eastern Standard Time", 180, FALSE, "(UTC-03:00) Cayenne, Fortaleza",
		"SA Eastern Standard Time", "SA Eastern Daylight Time",
		NULL, 0
	},
	{
		"Argentina Standard Time", 180, TRUE, "(UTC-03:00) City of Buenos Aires",
		"Argentina Standard Time", "Argentina Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_35, 3
	},
	{
		"Greenland Standard Time", 180, TRUE, "(UTC-03:00) Greenland",
		"Greenland Standard Time", "Greenland Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_36, 18
	},
	{
		"Montevideo Standard Time", 180, TRUE, "(UTC-03:00) Montevideo",
		"Montevideo Standard Time", "Montevideo Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_37, 2
	},
	{
		"Magallanes Standard Time", 180, TRUE, "(UTC-03:00) Punta Arenas",
		"Magallanes Standard Time", "Magallanes Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_38, 9
	},
	{
		"Saint Pierre Standard Time", 180, TRUE, "(UTC-03:00) Saint Pierre and Miquelon",
		"Saint Pierre Standard Time", "Saint Pierre Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_39, 2
	},
	{
		"Bahia Standard Time", 180, TRUE, "(UTC-03:00) Salvador",
		"Bahia Standard Time", "Bahia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_40, 2
	},
	{
		"UTC-02", 120, FALSE, "(UTC-02:00) Coordinated Universal Time-02",
		"UTC-02", "UTC-02",
		NULL, 0
	},
	{
		"Mid-Atlantic Standard Time", 120, TRUE, "(UTC-02:00) Mid-Atlantic - Old",
		"Mid-Atlantic Standard Time", "Mid-Atlantic Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_42, 1
	},
	{
		"Azores Standard Time", 60, TRUE, "(UTC-01:00) Azores",
		"Azores Standard Time", "Azores Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_43, 1
	},
	{
		"Cape Verde Standard Time", 60, FALSE, "(UTC-01:00) Cabo Verde Is.",
		"Cabo Verde Standard Time", "Cabo Verde Daylight Time",
		NULL, 0
	},
	{
		"UTC", 0, FALSE, "(UTC) Coordinated Universal Time",
		"Coordinated Universal Time", "Coordinated Universal Time",
		NULL, 0
	},
	{
		"Morocco Standard Time", 0, TRUE, "(UTC+00:00) Casablanca",
		"Morocco Standard Time", "Morocco Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_46, 11
	},
	{
		"GMT Standard Time", 0, TRUE, "(UTC+00:00) Dublin, Edinburgh, Lisbon, London",
		"GMT Standard Time", "GMT Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_47, 1
	},
	{
		"Greenwich Standard Time", 0, FALSE, "(UTC+00:00) Monrovia, Reykjavik",
		"Greenwich Standard Time", "Greenwich Daylight Time",
		NULL, 0
	},
	{
		"W. Europe Standard Time", -60, TRUE, "(UTC+01:00) Amsterdam, Berlin, Bern, Rome, Stockholm, Vienna",
		"W. Europe Standard Time", "W. Europe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_49, 1
	},
	{
		"Central Europe Standard Time", -60, TRUE, "(UTC+01:00) Belgrade, Bratislava, Budapest, Ljubljana, Prague",
		"Central Europe Standard Time", "Central Europe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_50, 1
	},
	{
		"Romance Standard Time", -60, TRUE, "(UTC+01:00) Brussels, Copenhagen, Madrid, Paris",
		"Romance Standard Time", "Romance Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_51, 1
	},
	{
		"Central European Standard Time", -60, TRUE, "(UTC+01:00) Sarajevo, Skopje, Warsaw, Zagreb",
		"Central European Standard Time", "Central European Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_52, 1
	},
	{
		"W. Central Africa Standard Time", -60, FALSE, "(UTC+01:00) West Central Africa",
		"W. Central Africa Standard Time", "W. Central Africa Daylight Time",
		NULL, 0
	},
	{
		"Namibia Standard Time", -60, TRUE, "(UTC+01:00) Windhoek",
		"Namibia Standard Time", "Namibia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_54, 1
	},
	{
		"Jordan Standard Time", -120, TRUE, "(UTC+02:00) Amman",
		"Jordan Standard Time", "Jordan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_55, 4
	},
	{
		"GTB Standard Time", -120, TRUE, "(UTC+02:00) Athens, Bucharest",
		"GTB Standard Time", "GTB Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_56, 1
	},
	{
		"Middle East Standard Time", -120, TRUE, "(UTC+02:00) Beirut",
		"Middle East Standard Time", "Middle East Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_57, 13
	},
	{
		"Egypt Standard Time", -120, TRUE, "(UTC+02:00) Cairo",
		"Egypt Standard Time", "Egypt Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_58, 7
	},
	{
		"E. Europe Standard Time", -120, TRUE, "(UTC+02:00) Chisinau",
		"E. Europe Standard Time", "E. Europe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_59, 1
	},
	{
		"Syria Standard Time", -120, TRUE, "(UTC+02:00) Damascus",
		"Syria Standard Time", "Syria Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_60, 17
	},
	{
		"West Bank Standard Time", -120, TRUE, "(UTC+02:00) Gaza, Hebron",
		"West Bank Gaza Standard Time", "West Bank Gaza Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_61, 6
	},
	{
		"South Africa Standard Time", -120, FALSE, "(UTC+02:00) Harare, Pretoria",
		"South Africa Standard Time", "South Africa Daylight Time",
		NULL, 0
	},
	{
		"FLE Standard Time", -120, TRUE, "(UTC+02:00) Helsinki, Kyiv, Riga, Sofia, Tallinn, Vilnius",
		"FLE Standard Time", "FLE Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_63, 1
	},
	{
		"Israel Standard Time", -120, TRUE, "(UTC+02:00) Jerusalem",
		"Jerusalem Standard Time", "Jerusalem Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_64, 20
	},
	{
		"Kaliningrad Standard Time", -120, TRUE, "(UTC+02:00) Kaliningrad",
		"Russia TZ 1 Standard Time", "Russia TZ 1 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_65, 5
	},
	{
		"Libya Standard Time", -120, TRUE, "(UTC+02:00) Tripoli",
		"Libya Standard Time", "Libya Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_66, 2
	},
	{
		"Arabic Standard Time", -180, TRUE, "(UTC+03:00) Baghdad",
		"Arabic Standard Time", "Arabic Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_67, 4
	},
	{
		"Turkey Standard Time", -180, TRUE, "(UTC+03:00) Istanbul",
		"Turkey Standard Time", "Turkey Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_68, 7
	},
	{
		"Arab Standard Time", -180, FALSE, "(UTC+03:00) Kuwait, Riyadh",
		"Arab Standard Time", "Arab Daylight Time",
		NULL, 0
	},
	{
		"Belarus Standard Time", -180, TRUE, "(UTC+03:00) Minsk",
		"Belarus Standard Time", "Belarus Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_70, 2
	},
	{
		"Russian Standard Time", -180, TRUE, "(UTC+03:00) Moscow, St. Petersburg, Volgograd",
		"Russia TZ 2 Standard Time", "Russia TZ 2 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_71, 5
	},
	{
		"E. Africa Standard Time", -180, FALSE, "(UTC+03:00) Nairobi",
		"E. Africa Standard Time", "E. Africa Daylight Time",
		NULL, 0
	},
	{
		"Iran Standard Time", -210, TRUE, "(UTC+03:30) Tehran",
		"Iran Standard Time", "Iran Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_73, 19
	},
	{
		"Arabian Standard Time", -240, FALSE, "(UTC+04:00) Abu Dhabi, Muscat",
		"Arabian Standard Time", "Arabian Daylight Time",
		NULL, 0
	},
	{
		"Astrakhan Standard Time", -240, TRUE, "(UTC+04:00) Astrakhan, Ulyanovsk",
		"Astrakhan Standard Time", "Astrakhan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_75, 5
	},
	{
		"Azerbaijan Standard Time", -240, TRUE, "(UTC+04:00) Baku",
		"Azerbaijan Standard Time", "Azerbaijan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_76, 1
	},
	{
		"Russia Time Zone 3", -240, TRUE, "(UTC+04:00) Izhevsk, Samara",
		"Russia TZ 3 Standard Time", "Russia TZ 3 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_77, 3
	},
	{
		"Mauritius Standard Time", -240, TRUE, "(UTC+04:00) Port Louis",
		"Mauritius Standard Time", "Mauritius Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_78, 2
	},
	{
		"Saratov Standard Time", -240, TRUE, "(UTC+04:00) Saratov",
		"Saratov Standard Time", "Saratov Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_79, 5
	},
	{
		"Georgian Standard Time", -240, FALSE, "(UTC+04:00) Tbilisi",
		"Georgian Standard Time", "Georgian Daylight Time",
		NULL, 0
	},
	{
		"Caucasus Standard Time", -240, TRUE, "(UTC+04:00) Yerevan",
		"Caucasus Standard Time", "Caucasus Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_81, 1
	},
	{
		"Afghanistan Standard Time", -270, FALSE, "(UTC+04:30) Kabul",
		"Afghanistan Standard Time", "Afghanistan Daylight Time",
		NULL, 0
	},
	{
		"West Asia Standard Time", -300, FALSE, "(UTC+05:00) Ashgabat, Tashkent",
		"West Asia Standard Time", "West Asia Daylight Time",
		NULL, 0
	},
	{
		"Ekaterinburg Standard Time", -300, TRUE, "(UTC+05:00) Ekaterinburg",
		"Russia TZ 4 Standard Time", "Russia TZ 4 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_84, 5
	},
	{
		"Pakistan Standard Time", -300, TRUE, "(UTC+05:00) Islamabad, Karachi",
		"Pakistan Standard Time", "Pakistan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_85, 2
	},
	{
		"India Standard Time", -330, FALSE, "(UTC+05:30) Chennai, Kolkata, Mumbai, New Delhi",
		"India Standard Time", "India Daylight Time",
		NULL, 0
	},
	{
		"Sri Lanka Standard Time", -330, FALSE, "(UTC+05:30) Sri Jayawardenepura",
		"Sri Lanka Standard Time", "Sri Lanka Daylight Time",
		NULL, 0
	},
	{
		"Nepal Standard Time", -345, FALSE, "(UTC+05:45) Kathmandu",
		"Nepal Standard Time", "Nepal Daylight Time",
		NULL, 0
	},
	{
		"Central Asia Standard Time", -360, FALSE, "(UTC+06:00) Astana",
		"Central Asia Standard Time", "Central Asia Daylight Time",
		NULL, 0
	},
	{
		"Bangladesh Standard Time", -360, TRUE, "(UTC+06:00) Dhaka",
		"Bangladesh Standard Time", "Bangladesh Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_90, 1
	},
	{
		"Omsk Standard Time", -360, TRUE, "(UTC+06:00) Omsk",
		"Omsk Standard Time", "Omsk Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_91, 5
	},
	{
		"Myanmar Standard Time", -390, FALSE, "(UTC+06:30) Yangon (Rangoon)",
		"Myanmar Standard Time", "Myanmar Daylight Time",
		NULL, 0
	},
	{
		"SE Asia Standard Time", -420, FALSE, "(UTC+07:00) Bangkok, Hanoi, Jakarta",
		"SE Asia Standard Time", "SE Asia Daylight Time",
		NULL, 0
	},
	{
		"Altai Standard Time", -420, TRUE, "(UTC+07:00) Barnaul, Gorno-Altaysk",
		"Altai Standard Time", "Altai Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_94, 5
	},
	{
		"W. Mongolia Standard Time", -420, TRUE, "(UTC+07:00) Hovd",
		"W. Mongolia Standard Time", "W. Mongolia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_95, 3
	},
	{
		"North Asia Standard Time", -420, TRUE, "(UTC+07:00) Krasnoyarsk",
		"Russia TZ 6 Standard Time", "Russia TZ 6 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_96, 5
	},
	{
		"N. Central Asia Standard Time", -420, TRUE, "(UTC+07:00) Novosibirsk",
		"Novosibirsk Standard Time", "Novosibirsk Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_97, 5
	},
	{
		"Tomsk Standard Time", -420, TRUE, "(UTC+07:00) Tomsk",
		"Tomsk Standard Time", "Tomsk Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_98, 5
	},
	{
		"China Standard Time", -480, FALSE, "(UTC+08:00) Beijing, Chongqing, Hong Kong, Urumqi",
		"China Standard Time", "China Daylight Time",
		NULL, 0
	},
	{
		"North Asia East Standard Time", -480, TRUE, "(UTC+08:00) Irkutsk",
		"Russia TZ 7 Standard Time", "Russia TZ 7 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_100, 5
	},
	{
		"Singapore Standard Time", -480, FALSE, "(UTC+08:00) Kuala Lumpur, Singapore",
		"Malay Peninsula Standard Time", "Malay Peninsula Daylight Time",
		NULL, 0
	},
	{
		"W. Australia Standard Time", -480, TRUE, "(UTC+08:00) Perth",
		"W. Australia Standard Time", "W. Australia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_102, 4
	},
	{
		"Taipei Standard Time", -480, FALSE, "(UTC+08:00) Taipei",
		"Taipei Standard Time", "Taipei Daylight Time",
		NULL, 0
	},
	{
		"Ulaanbaatar Standard Time", -480, TRUE, "(UTC+08:00) Ulaanbaatar",
		"Ulaanbaatar Standard Time", "Ulaanbaatar Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_104, 2
	},
	{
		"North Korea Standard Time", -510, TRUE, "(UTC+08:30) Pyongyang",
		"North Korea Standard Time", "North Korea Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_105, 2
	},
	{
		"Aus Central W. Standard Time", -525, FALSE, "(UTC+08:45) Eucla",
		"Aus Central W. Standard Time", "Aus Central W. Daylight Time",
		NULL, 0
	},
	{
		"Transbaikal Standard Time", -540, TRUE, "(UTC+09:00) Chita",
		"Transbaikal Standard Time", "Transbaikal Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_107, 7
	},
	{
		"Tokyo Standard Time", -540, FALSE, "(UTC+09:00) Osaka, Sapporo, Tokyo",
		"Tokyo Standard Time", "Tokyo Daylight Time",
		NULL, 0
	},
	{
		"Korea Standard Time", -540, FALSE, "(UTC+09:00) Seoul",
		"Korea Standard Time", "Korea Daylight Time",
		NULL, 0
	},
	{
		"Yakutsk Standard Time", -540, TRUE, "(UTC+09:00) Yakutsk",
		"Russia TZ 8 Standard Time", "Russia TZ 8 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_110, 5
	},
	{
		"Cen. Australia Standard Time", -570, TRUE, "(UTC+09:30) Adelaide",
		"Cen. Australia Standard Time", "Cen. Australia Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_111, 2
	},
	{
		"AUS Central Standard Time", -570, FALSE, "(UTC+09:30) Darwin",
		"AUS Central Standard Time", "AUS Central Daylight Time",
		NULL, 0
	},
	{
		"E. Australia Standard Time", -600, FALSE, "(UTC+10:00) Brisbane",
		"E. Australia Standard Time", "E. Australia Daylight Time",
		NULL, 0
	},
	{
		"AUS Eastern Standard Time", -600, TRUE, "(UTC+10:00) Canberra, Melbourne, Sydney",
		"AUS Eastern Standard Time", "AUS Eastern Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_114, 2
	},
	{
		"West Pacific Standard Time", -600, FALSE, "(UTC+10:00) Guam, Port Moresby",
		"West Pacific Standard Time", "West Pacific Daylight Time",
		NULL, 0
	},
	{
		"Tasmania Standard Time", -600, TRUE, "(UTC+10:00) Hobart",
		"Tasmania Standard Time", "Tasmania Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_116, 2
	},
	{
		"Vladivostok Standard Time", -600, TRUE, "(UTC+10:00) Vladivostok",
		"Russia TZ 9 Standard Time", "Russia TZ 9 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_117, 5
	},
	{
		"Lord Howe Standard Time", -630, TRUE, "(UTC+10:30) Lord Howe Island",
		"Lord Howe Standard Time", "Lord Howe Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_118, 4
	},
	{
		"Bougainville Standard Time", -660, TRUE, "(UTC+11:00) Bougainville Island",
		"Bougainville Standard Time", "Bougainville Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_119, 2
	},
	{
		"Russia Time Zone 10", -660, TRUE, "(UTC+11:00) Chokurdakh",
		"Russia TZ 10 Standard Time", "Russia TZ 10 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_120, 5
	},
	{
		"Magadan Standard Time", -660, TRUE, "(UTC+11:00) Magadan",
		"Magadan Standard Time", "Magadan Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_121, 7
	},
	{
		"Norfolk Standard Time", -660, TRUE, "(UTC+11:00) Norfolk Island",
		"Norfolk Standard Time", "Norfolk Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_122, 2
	},
	{
		"Sakhalin Standard Time", -660, TRUE, "(UTC+11:00) Sakhalin",
		"Sakhalin Standard Time", "Sakhalin Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_123, 5
	},
	{
		"Central Pacific Standard Time", -660, FALSE, "(UTC+11:00) Solomon Is., New Caledonia",
		"Central Pacific Standard Time", "Central Pacific Daylight Time",
		NULL, 0
	},
	{
		"Russia Time Zone 11", -720, TRUE, "(UTC+12:00) Anadyr, Petropavlovsk-Kamchatsky",
		"Russia TZ 11 Standard Time", "Russia TZ 11 Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_125, 3
	},
	{
		"New Zealand Standard Time", -720, TRUE, "(UTC+12:00) Auckland, Wellington",
		"New Zealand Standard Time", "New Zealand Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_126, 3
	},
	{
		"UTC+12", -720, FALSE, "(UTC+12:00) Coordinated Universal Time+12",
		"UTC+12", "UTC+12",
		NULL, 0
	},
	{
		"Fiji Standard Time", -720, TRUE, "(UTC+12:00) Fiji",
		"Fiji Standard Time", "Fiji Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_128, 7
	},
	{
		"Kamchatka Standard Time", -720, TRUE, "(UTC+12:00) Petropavlovsk-Kamchatsky - Old",
		"Kamchatka Standard Time", "Kamchatka Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_129, 1
	},
	{
		"Chatham Islands Standard Time", -765, TRUE, "(UTC+12:45) Chatham Islands",
		"Chatham Islands Standard Time", "Chatham Islands Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_130, 3
	},
	{
		"UTC+13", -780, FALSE, "(UTC+13:00) Coordinated Universal Time+13",
		"UTC+13", "UTC+13",
		NULL, 0
	},
	{
		"Tonga Standard Time", -780, TRUE, "(UTC+13:00) Nuku'alofa",
		"Tonga Standard Time", "Tonga Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_132, 2
	},
	{
		"Samoa Standard Time", -780, TRUE, "(UTC+13:00) Samoa",
		"Samoa Standard Time", "Samoa Daylight Time",
		(TIME_ZONE_RULE_ENTRY*) &TimeZoneRuleTable_133, 4
	},
	{
		"Line Islands Standard Time", -840, FALSE, "(UTC+14:00) Kiritimati Island",
		"Line Islands Standard Time", "Line Islands Daylight Time",
		NULL, 0
	}
};

/* Table generated with WindowsZones.cs */

struct _WINDOWS_TZID_ENTRY
{
	const char* windows;
	const char* tzid;
};
typedef struct _WINDOWS_TZID_ENTRY WINDOWS_TZID_ENTRY;

const WINDOWS_TZID_ENTRY WindowsTimeZoneIdTable[] =
{
	{ "Afghanistan Standard Time", "Asia/Kabul" },
	{ "Alaskan Standard Time", "America/Anchorage America/Juneau America/Metlakatla America/Nome America/Sitka America/Yakutat" },
	{ "Alaskan Standard Time", "America/Anchorage" },
	{ "Aleutian Standard Time", "America/Adak" },
	{ "Altai Standard Time", "Asia/Barnaul" },
	{ "Arab Standard Time", "Asia/Aden" },
	{ "Arab Standard Time", "Asia/Bahrain" },
	{ "Arab Standard Time", "Asia/Kuwait" },
	{ "Arab Standard Time", "Asia/Qatar" },
	{ "Arab Standard Time", "Asia/Riyadh" },
	{ "Arabian Standard Time", "Asia/Dubai" },
	{ "Arabian Standard Time", "Asia/Muscat" },
	{ "Arabian Standard Time", "Etc/GMT-4" },
	{ "Arabic Standard Time", "Asia/Baghdad" },
	{ "Argentina Standard Time", "America/Buenos_Aires America/Argentina/La_Rioja America/Argentina/Rio_Gallegos America/Argentina/Salta America/Argentina/San_Juan America/Argentina/San_Luis America/Argentina/Tucuman America/Argentina/Ushuaia America/Catamarca America/Cordoba America/Jujuy America/Mendoza" },
	{ "Argentina Standard Time", "America/Buenos_Aires" },
	{ "Astrakhan Standard Time", "Europe/Astrakhan Europe/Saratov Europe/Ulyanovsk" },
	{ "Astrakhan Standard Time", "Europe/Astrakhan" },
	{ "Atlantic Standard Time", "America/Halifax America/Glace_Bay America/Goose_Bay America/Moncton" },
	{ "Atlantic Standard Time", "America/Halifax" },
	{ "Atlantic Standard Time", "America/Thule" },
	{ "Atlantic Standard Time", "Atlantic/Bermuda" },
	{ "AUS Central Standard Time", "Australia/Darwin" },
	{ "Aus Central W. Standard Time", "Australia/Eucla" },
	{ "AUS Eastern Standard Time", "Australia/Sydney Australia/Melbourne" },
	{ "AUS Eastern Standard Time", "Australia/Sydney" },
	{ "Azerbaijan Standard Time", "Asia/Baku" },
	{ "Azores Standard Time", "America/Scoresbysund" },
	{ "Azores Standard Time", "Atlantic/Azores" },
	{ "Bahia Standard Time", "America/Bahia" },
	{ "Bangladesh Standard Time", "Asia/Dhaka" },
	{ "Bangladesh Standard Time", "Asia/Thimphu" },
	{ "Belarus Standard Time", "Europe/Minsk" },
	{ "Bougainville Standard Time", "Pacific/Bougainville" },
	{ "Canada Central Standard Time", "America/Regina America/Swift_Current" },
	{ "Canada Central Standard Time", "America/Regina" },
	{ "Cape Verde Standard Time", "Atlantic/Cape_Verde" },
	{ "Cape Verde Standard Time", "Etc/GMT+1" },
	{ "Caucasus Standard Time", "Asia/Yerevan" },
	{ "Cen. Australia Standard Time", "Australia/Adelaide Australia/Broken_Hill" },
	{ "Cen. Australia Standard Time", "Australia/Adelaide" },
	{ "Central America Standard Time", "America/Belize" },
	{ "Central America Standard Time", "America/Costa_Rica" },
	{ "Central America Standard Time", "America/El_Salvador" },
	{ "Central America Standard Time", "America/Guatemala" },
	{ "Central America Standard Time", "America/Managua" },
	{ "Central America Standard Time", "America/Tegucigalpa" },
	{ "Central America Standard Time", "Etc/GMT+6" },
	{ "Central America Standard Time", "Pacific/Galapagos" },
	{ "Central Asia Standard Time", "Antarctica/Vostok" },
	{ "Central Asia Standard Time", "Asia/Almaty Asia/Qyzylorda" },
	{ "Central Asia Standard Time", "Asia/Almaty" },
	{ "Central Asia Standard Time", "Asia/Bishkek" },
	{ "Central Asia Standard Time", "Asia/Urumqi" },
	{ "Central Asia Standard Time", "Etc/GMT-6" },
	{ "Central Asia Standard Time", "Indian/Chagos" },
	{ "Central Brazilian Standard Time", "America/Cuiaba America/Campo_Grande" },
	{ "Central Brazilian Standard Time", "America/Cuiaba" },
	{ "Central Europe Standard Time", "Europe/Belgrade" },
	{ "Central Europe Standard Time", "Europe/Bratislava" },
	{ "Central Europe Standard Time", "Europe/Budapest" },
	{ "Central Europe Standard Time", "Europe/Ljubljana" },
	{ "Central Europe Standard Time", "Europe/Podgorica" },
	{ "Central Europe Standard Time", "Europe/Prague" },
	{ "Central Europe Standard Time", "Europe/Tirane" },
	{ "Central European Standard Time", "Europe/Sarajevo" },
	{ "Central European Standard Time", "Europe/Skopje" },
	{ "Central European Standard Time", "Europe/Warsaw" },
	{ "Central European Standard Time", "Europe/Zagreb" },
	{ "Central Pacific Standard Time", "Antarctica/Casey" },
	{ "Central Pacific Standard Time", "Antarctica/Macquarie" },
	{ "Central Pacific Standard Time", "Etc/GMT-11" },
	{ "Central Pacific Standard Time", "Pacific/Efate" },
	{ "Central Pacific Standard Time", "Pacific/Guadalcanal" },
	{ "Central Pacific Standard Time", "Pacific/Noumea" },
	{ "Central Pacific Standard Time", "Pacific/Ponape Pacific/Kosrae" },
	{ "Central Standard Time (Mexico)", "America/Mexico_City America/Bahia_Banderas America/Merida America/Monterrey" },
	{ "Central Standard Time (Mexico)", "America/Mexico_City" },
	{ "Central Standard Time", "America/Chicago America/Indiana/Knox America/Indiana/Tell_City America/Menominee America/North_Dakota/Beulah America/North_Dakota/Center America/North_Dakota/New_Salem" },
	{ "Central Standard Time", "America/Chicago" },
	{ "Central Standard Time", "America/Matamoros" },
	{ "Central Standard Time", "America/Winnipeg America/Rainy_River America/Rankin_Inlet America/Resolute" },
	{ "Central Standard Time", "CST6CDT" },
	{ "Chatham Islands Standard Time", "Pacific/Chatham" },
	{ "China Standard Time", "Asia/Hong_Kong" },
	{ "China Standard Time", "Asia/Macau" },
	{ "China Standard Time", "Asia/Shanghai" },
	{ "Cuba Standard Time", "America/Havana" },
	{ "Dateline Standard Time", "Etc/GMT+12" },
	{ "E. Africa Standard Time", "Africa/Addis_Ababa" },
	{ "E. Africa Standard Time", "Africa/Asmera" },
	{ "E. Africa Standard Time", "Africa/Dar_es_Salaam" },
	{ "E. Africa Standard Time", "Africa/Djibouti" },
	{ "E. Africa Standard Time", "Africa/Juba" },
	{ "E. Africa Standard Time", "Africa/Kampala" },
	{ "E. Africa Standard Time", "Africa/Khartoum" },
	{ "E. Africa Standard Time", "Africa/Mogadishu" },
	{ "E. Africa Standard Time", "Africa/Nairobi" },
	{ "E. Africa Standard Time", "Antarctica/Syowa" },
	{ "E. Africa Standard Time", "Etc/GMT-3" },
	{ "E. Africa Standard Time", "Indian/Antananarivo" },
	{ "E. Africa Standard Time", "Indian/Comoro" },
	{ "E. Africa Standard Time", "Indian/Mayotte" },
	{ "E. Australia Standard Time", "Australia/Brisbane Australia/Lindeman" },
	{ "E. Australia Standard Time", "Australia/Brisbane" },
	{ "E. Europe Standard Time", "Europe/Chisinau" },
	{ "E. South America Standard Time", "America/Sao_Paulo" },
	{ "Easter Island Standard Time", "Pacific/Easter" },
	{ "Eastern Standard Time (Mexico)", "America/Cancun" },
	{ "Eastern Standard Time", "America/Nassau" },
	{ "Eastern Standard Time", "America/New_York America/Detroit America/Indiana/Petersburg America/Indiana/Vincennes America/Indiana/Winamac America/Kentucky/Monticello America/Louisville" },
	{ "Eastern Standard Time", "America/New_York" },
	{ "Eastern Standard Time", "America/Toronto America/Iqaluit America/Montreal America/Nipigon America/Pangnirtung America/Thunder_Bay" },
	{ "Eastern Standard Time", "EST5EDT" },
	{ "Egypt Standard Time", "Africa/Cairo" },
	{ "Ekaterinburg Standard Time", "Asia/Yekaterinburg" },
	{ "Fiji Standard Time", "Pacific/Fiji" },
	{ "FLE Standard Time", "Europe/Helsinki" },
	{ "FLE Standard Time", "Europe/Kiev Europe/Uzhgorod Europe/Zaporozhye" },
	{ "FLE Standard Time", "Europe/Kiev" },
	{ "FLE Standard Time", "Europe/Mariehamn" },
	{ "FLE Standard Time", "Europe/Riga" },
	{ "FLE Standard Time", "Europe/Sofia" },
	{ "FLE Standard Time", "Europe/Tallinn" },
	{ "FLE Standard Time", "Europe/Vilnius" },
	{ "Georgian Standard Time", "Asia/Tbilisi" },
	{ "GMT Standard Time", "Atlantic/Canary" },
	{ "GMT Standard Time", "Atlantic/Faeroe" },
	{ "GMT Standard Time", "Europe/Dublin" },
	{ "GMT Standard Time", "Europe/Guernsey" },
	{ "GMT Standard Time", "Europe/Isle_of_Man" },
	{ "GMT Standard Time", "Europe/Jersey" },
	{ "GMT Standard Time", "Europe/Lisbon Atlantic/Madeira" },
	{ "GMT Standard Time", "Europe/London" },
	{ "Greenland Standard Time", "America/Godthab" },
	{ "Greenwich Standard Time", "Africa/Abidjan" },
	{ "Greenwich Standard Time", "Africa/Accra" },
	{ "Greenwich Standard Time", "Africa/Bamako" },
	{ "Greenwich Standard Time", "Africa/Banjul" },
	{ "Greenwich Standard Time", "Africa/Bissau" },
	{ "Greenwich Standard Time", "Africa/Conakry" },
	{ "Greenwich Standard Time", "Africa/Dakar" },
	{ "Greenwich Standard Time", "Africa/Freetown" },
	{ "Greenwich Standard Time", "Africa/Lome" },
	{ "Greenwich Standard Time", "Africa/Monrovia" },
	{ "Greenwich Standard Time", "Africa/Nouakchott" },
	{ "Greenwich Standard Time", "Africa/Ouagadougou" },
	{ "Greenwich Standard Time", "Africa/Sao_Tome" },
	{ "Greenwich Standard Time", "Atlantic/Reykjavik" },
	{ "Greenwich Standard Time", "Atlantic/St_Helena" },
	{ "GTB Standard Time", "Asia/Nicosia" },
	{ "GTB Standard Time", "Europe/Athens" },
	{ "GTB Standard Time", "Europe/Bucharest" },
	{ "Haiti Standard Time", "America/Port-au-Prince" },
	{ "Hawaiian Standard Time", "Etc/GMT+10" },
	{ "Hawaiian Standard Time", "Pacific/Honolulu" },
	{ "Hawaiian Standard Time", "Pacific/Johnston" },
	{ "Hawaiian Standard Time", "Pacific/Rarotonga" },
	{ "Hawaiian Standard Time", "Pacific/Tahiti" },
	{ "India Standard Time", "Asia/Calcutta" },
	{ "Iran Standard Time", "Asia/Tehran" },
	{ "Israel Standard Time", "Asia/Jerusalem" },
	{ "Jordan Standard Time", "Asia/Amman" },
	{ "Kaliningrad Standard Time", "Europe/Kaliningrad" },
	{ "Korea Standard Time", "Asia/Seoul" },
	{ "Libya Standard Time", "Africa/Tripoli" },
	{ "Line Islands Standard Time", "Etc/GMT-14" },
	{ "Line Islands Standard Time", "Pacific/Kiritimati" },
	{ "Lord Howe Standard Time", "Australia/Lord_Howe" },
	{ "Magadan Standard Time", "Asia/Magadan" },
	{ "Marquesas Standard Time", "Pacific/Marquesas" },
	{ "Mauritius Standard Time", "Indian/Mahe" },
	{ "Mauritius Standard Time", "Indian/Mauritius" },
	{ "Mauritius Standard Time", "Indian/Reunion" },
	{ "Middle East Standard Time", "Asia/Beirut" },
	{ "Montevideo Standard Time", "America/Montevideo" },
	{ "Morocco Standard Time", "Africa/Casablanca" },
	{ "Morocco Standard Time", "Africa/El_Aaiun" },
	{ "Mountain Standard Time (Mexico)", "America/Chihuahua America/Mazatlan" },
	{ "Mountain Standard Time (Mexico)", "America/Chihuahua" },
	{ "Mountain Standard Time", "America/Denver America/Boise" },
	{ "Mountain Standard Time", "America/Denver" },
	{ "Mountain Standard Time", "America/Edmonton America/Cambridge_Bay America/Inuvik America/Yellowknife" },
	{ "Mountain Standard Time", "America/Ojinaga" },
	{ "Mountain Standard Time", "MST7MDT" },
	{ "Myanmar Standard Time", "Asia/Rangoon" },
	{ "Myanmar Standard Time", "Indian/Cocos" },
	{ "N. Central Asia Standard Time", "Asia/Novosibirsk" },
	{ "Namibia Standard Time", "Africa/Windhoek" },
	{ "Nepal Standard Time", "Asia/Katmandu" },
	{ "New Zealand Standard Time", "Antarctica/McMurdo" },
	{ "New Zealand Standard Time", "Pacific/Auckland" },
	{ "Newfoundland Standard Time", "America/St_Johns" },
	{ "Norfolk Standard Time", "Pacific/Norfolk" },
	{ "North Asia East Standard Time", "Asia/Irkutsk" },
	{ "North Asia Standard Time", "Asia/Krasnoyarsk Asia/Novokuznetsk" },
	{ "North Asia Standard Time", "Asia/Krasnoyarsk" },
	{ "North Korea Standard Time", "Asia/Pyongyang" },
	{ "Omsk Standard Time", "Asia/Omsk" },
	{ "Pacific SA Standard Time", "America/Santiago" },
	{ "Pacific Standard Time (Mexico)", "America/Tijuana America/Santa_Isabel" },
	{ "Pacific Standard Time (Mexico)", "America/Tijuana" },
	{ "Pacific Standard Time", "America/Los_Angeles" },
	{ "Pacific Standard Time", "America/Vancouver America/Dawson America/Whitehorse" },
	{ "Pacific Standard Time", "PST8PDT" },
	{ "Pakistan Standard Time", "Asia/Karachi" },
	{ "Paraguay Standard Time", "America/Asuncion" },
	{ "Romance Standard Time", "Europe/Brussels" },
	{ "Romance Standard Time", "Europe/Copenhagen" },
	{ "Romance Standard Time", "Europe/Madrid Africa/Ceuta" },
	{ "Romance Standard Time", "Europe/Paris" },
	{ "Russia Time Zone 10", "Asia/Srednekolymsk" },
	{ "Russia Time Zone 11", "Asia/Kamchatka Asia/Anadyr" },
	{ "Russia Time Zone 11", "Asia/Kamchatka" },
	{ "Russia Time Zone 3", "Europe/Samara" },
	{ "Russian Standard Time", "Europe/Moscow Europe/Kirov Europe/Volgograd" },
	{ "Russian Standard Time", "Europe/Moscow" },
	{ "Russian Standard Time", "Europe/Simferopol" },
	{ "SA Eastern Standard Time", "America/Cayenne" },
	{ "SA Eastern Standard Time", "America/Fortaleza America/Belem America/Maceio America/Recife America/Santarem" },
	{ "SA Eastern Standard Time", "America/Paramaribo" },
	{ "SA Eastern Standard Time", "America/Punta_Arenas" },
	{ "SA Eastern Standard Time", "Antarctica/Rothera Antarctica/Palmer" },
	{ "SA Eastern Standard Time", "Atlantic/Stanley" },
	{ "SA Eastern Standard Time", "Etc/GMT+3" },
	{ "SA Pacific Standard Time", "America/Bogota" },
	{ "SA Pacific Standard Time", "America/Cayman" },
	{ "SA Pacific Standard Time", "America/Coral_Harbour" },
	{ "SA Pacific Standard Time", "America/Guayaquil" },
	{ "SA Pacific Standard Time", "America/Jamaica" },
	{ "SA Pacific Standard Time", "America/Lima" },
	{ "SA Pacific Standard Time", "America/Panama" },
	{ "SA Pacific Standard Time", "America/Rio_Branco America/Eirunepe" },
	{ "SA Pacific Standard Time", "Etc/GMT+5" },
	{ "SA Western Standard Time", "America/Anguilla" },
	{ "SA Western Standard Time", "America/Antigua" },
	{ "SA Western Standard Time", "America/Aruba" },
	{ "SA Western Standard Time", "America/Barbados" },
	{ "SA Western Standard Time", "America/Blanc-Sablon" },
	{ "SA Western Standard Time", "America/Curacao" },
	{ "SA Western Standard Time", "America/Dominica" },
	{ "SA Western Standard Time", "America/Grenada" },
	{ "SA Western Standard Time", "America/Guadeloupe" },
	{ "SA Western Standard Time", "America/Guyana" },
	{ "SA Western Standard Time", "America/Kralendijk" },
	{ "SA Western Standard Time", "America/La_Paz" },
	{ "SA Western Standard Time", "America/Lower_Princes" },
	{ "SA Western Standard Time", "America/Manaus America/Boa_Vista America/Porto_Velho" },
	{ "SA Western Standard Time", "America/Marigot" },
	{ "SA Western Standard Time", "America/Martinique" },
	{ "SA Western Standard Time", "America/Montserrat" },
	{ "SA Western Standard Time", "America/Port_of_Spain" },
	{ "SA Western Standard Time", "America/Puerto_Rico" },
	{ "SA Western Standard Time", "America/Santo_Domingo" },
	{ "SA Western Standard Time", "America/St_Barthelemy" },
	{ "SA Western Standard Time", "America/St_Kitts" },
	{ "SA Western Standard Time", "America/St_Lucia" },
	{ "SA Western Standard Time", "America/St_Thomas" },
	{ "SA Western Standard Time", "America/St_Vincent" },
	{ "SA Western Standard Time", "America/Tortola" },
	{ "SA Western Standard Time", "Etc/GMT+4" },
	{ "Saint Pierre Standard Time", "America/Miquelon" },
	{ "Sakhalin Standard Time", "Asia/Sakhalin" },
	{ "Samoa Standard Time", "Pacific/Apia" },
	{ "SE Asia Standard Time", "Antarctica/Davis" },
	{ "SE Asia Standard Time", "Asia/Bangkok" },
	{ "SE Asia Standard Time", "Asia/Jakarta Asia/Pontianak" },
	{ "SE Asia Standard Time", "Asia/Phnom_Penh" },
	{ "SE Asia Standard Time", "Asia/Saigon" },
	{ "SE Asia Standard Time", "Asia/Vientiane" },
	{ "SE Asia Standard Time", "Etc/GMT-7" },
	{ "SE Asia Standard Time", "Indian/Christmas" },
	{ "Singapore Standard Time", "Asia/Brunei" },
	{ "Singapore Standard Time", "Asia/Kuala_Lumpur Asia/Kuching" },
	{ "Singapore Standard Time", "Asia/Makassar" },
	{ "Singapore Standard Time", "Asia/Manila" },
	{ "Singapore Standard Time", "Asia/Singapore" },
	{ "Singapore Standard Time", "Etc/GMT-8" },
	{ "South Africa Standard Time", "Africa/Blantyre" },
	{ "South Africa Standard Time", "Africa/Bujumbura" },
	{ "South Africa Standard Time", "Africa/Gaborone" },
	{ "South Africa Standard Time", "Africa/Harare" },
	{ "South Africa Standard Time", "Africa/Johannesburg" },
	{ "South Africa Standard Time", "Africa/Kigali" },
	{ "South Africa Standard Time", "Africa/Lubumbashi" },
	{ "South Africa Standard Time", "Africa/Lusaka" },
	{ "South Africa Standard Time", "Africa/Maputo" },
	{ "South Africa Standard Time", "Africa/Maseru" },
	{ "South Africa Standard Time", "Africa/Mbabane" },
	{ "South Africa Standard Time", "Etc/GMT-2" },
	{ "Sri Lanka Standard Time", "Asia/Colombo" },
	{ "Syria Standard Time", "Asia/Damascus" },
	{ "Taipei Standard Time", "Asia/Taipei" },
	{ "Tasmania Standard Time", "Australia/Hobart Australia/Currie" },
	{ "Tasmania Standard Time", "Australia/Hobart" },
	{ "Tocantins Standard Time", "America/Araguaina" },
	{ "Tokyo Standard Time", "Asia/Dili" },
	{ "Tokyo Standard Time", "Asia/Jayapura" },
	{ "Tokyo Standard Time", "Asia/Tokyo" },
	{ "Tokyo Standard Time", "Etc/GMT-9" },
	{ "Tokyo Standard Time", "Pacific/Palau" },
	{ "Tomsk Standard Time", "Asia/Tomsk" },
	{ "Tonga Standard Time", "Etc/GMT-13" },
	{ "Tonga Standard Time", "Pacific/Enderbury" },
	{ "Tonga Standard Time", "Pacific/Fakaofo" },
	{ "Tonga Standard Time", "Pacific/Tongatapu" },
	{ "Transbaikal Standard Time", "Asia/Chita" },
	{ "Turkey Standard Time", "Asia/Famagusta" },
	{ "Turkey Standard Time", "Europe/Istanbul" },
	{ "Turks And Caicos Standard Time", "America/Grand_Turk" },
	{ "Ulaanbaatar Standard Time", "Asia/Ulaanbaatar Asia/Choibalsan" },
	{ "Ulaanbaatar Standard Time", "Asia/Ulaanbaatar" },
	{ "US Eastern Standard Time", "America/Indianapolis America/Indiana/Marengo America/Indiana/Vevay" },
	{ "US Eastern Standard Time", "America/Indianapolis" },
	{ "US Mountain Standard Time", "America/Dawson_Creek America/Creston America/Fort_Nelson" },
	{ "US Mountain Standard Time", "America/Hermosillo" },
	{ "US Mountain Standard Time", "America/Phoenix" },
	{ "US Mountain Standard Time", "Etc/GMT+7" },
	{ "UTC", "America/Danmarkshavn" },
	{ "UTC", "Etc/GMT Etc/UTC" },
	{ "UTC", "Etc/GMT" },
	{ "UTC+12", "Etc/GMT-12" },
	{ "UTC+12", "Pacific/Funafuti" },
	{ "UTC+12", "Pacific/Majuro Pacific/Kwajalein" },
	{ "UTC+12", "Pacific/Nauru" },
	{ "UTC+12", "Pacific/Tarawa" },
	{ "UTC+12", "Pacific/Wake" },
	{ "UTC+12", "Pacific/Wallis" },
	{ "UTC-02", "America/Noronha" },
	{ "UTC-02", "Atlantic/South_Georgia" },
	{ "UTC-02", "Etc/GMT+2" },
	{ "UTC-08", "Etc/GMT+8" },
	{ "UTC-08", "Pacific/Pitcairn" },
	{ "UTC-09", "Etc/GMT+9" },
	{ "UTC-09", "Pacific/Gambier" },
	{ "UTC-11", "Etc/GMT+11" },
	{ "UTC-11", "Pacific/Midway" },
	{ "UTC-11", "Pacific/Niue" },
	{ "UTC-11", "Pacific/Pago_Pago" },
	{ "Venezuela Standard Time", "America/Caracas" },
	{ "Vladivostok Standard Time", "Asia/Vladivostok Asia/Ust-Nera" },
	{ "Vladivostok Standard Time", "Asia/Vladivostok" },
	{ "W. Australia Standard Time", "Australia/Perth" },
	{ "W. Central Africa Standard Time", "Africa/Algiers" },
	{ "W. Central Africa Standard Time", "Africa/Bangui" },
	{ "W. Central Africa Standard Time", "Africa/Brazzaville" },
	{ "W. Central Africa Standard Time", "Africa/Douala" },
	{ "W. Central Africa Standard Time", "Africa/Kinshasa" },
	{ "W. Central Africa Standard Time", "Africa/Lagos" },
	{ "W. Central Africa Standard Time", "Africa/Libreville" },
	{ "W. Central Africa Standard Time", "Africa/Luanda" },
	{ "W. Central Africa Standard Time", "Africa/Malabo" },
	{ "W. Central Africa Standard Time", "Africa/Ndjamena" },
	{ "W. Central Africa Standard Time", "Africa/Niamey" },
	{ "W. Central Africa Standard Time", "Africa/Porto-Novo" },
	{ "W. Central Africa Standard Time", "Africa/Tunis" },
	{ "W. Central Africa Standard Time", "Etc/GMT-1" },
	{ "W. Europe Standard Time", "Arctic/Longyearbyen" },
	{ "W. Europe Standard Time", "Europe/Amsterdam" },
	{ "W. Europe Standard Time", "Europe/Andorra" },
	{ "W. Europe Standard Time", "Europe/Berlin Europe/Busingen" },
	{ "W. Europe Standard Time", "Europe/Berlin" },
	{ "W. Europe Standard Time", "Europe/Gibraltar" },
	{ "W. Europe Standard Time", "Europe/Luxembourg" },
	{ "W. Europe Standard Time", "Europe/Malta" },
	{ "W. Europe Standard Time", "Europe/Monaco" },
	{ "W. Europe Standard Time", "Europe/Oslo" },
	{ "W. Europe Standard Time", "Europe/Rome" },
	{ "W. Europe Standard Time", "Europe/San_Marino" },
	{ "W. Europe Standard Time", "Europe/Stockholm" },
	{ "W. Europe Standard Time", "Europe/Vaduz" },
	{ "W. Europe Standard Time", "Europe/Vatican" },
	{ "W. Europe Standard Time", "Europe/Vienna" },
	{ "W. Europe Standard Time", "Europe/Zurich" },
	{ "W. Mongolia Standard Time", "Asia/Hovd" },
	{ "West Asia Standard Time", "Antarctica/Mawson" },
	{ "West Asia Standard Time", "Asia/Ashgabat" },
	{ "West Asia Standard Time", "Asia/Dushanbe" },
	{ "West Asia Standard Time", "Asia/Oral Asia/Aqtau Asia/Aqtobe Asia/Atyrau" },
	{ "West Asia Standard Time", "Asia/Tashkent Asia/Samarkand" },
	{ "West Asia Standard Time", "Asia/Tashkent" },
	{ "West Asia Standard Time", "Etc/GMT-5" },
	{ "West Asia Standard Time", "Indian/Kerguelen" },
	{ "West Asia Standard Time", "Indian/Maldives" },
	{ "West Bank Standard Time", "Asia/Hebron Asia/Gaza" },
	{ "West Bank Standard Time", "Asia/Hebron" },
	{ "West Pacific Standard Time", "Antarctica/DumontDUrville" },
	{ "West Pacific Standard Time", "Etc/GMT-10" },
	{ "West Pacific Standard Time", "Pacific/Guam" },
	{ "West Pacific Standard Time", "Pacific/Port_Moresby" },
	{ "West Pacific Standard Time", "Pacific/Saipan" },
	{ "West Pacific Standard Time", "Pacific/Truk" },
	{ "Yakutsk Standard Time", "Asia/Yakutsk Asia/Khandyga" },
	{ "Yakutsk Standard Time", "Asia/Yakutsk" },
};

static UINT64 winpr_windows_gmtime()
{
	time_t unix_time;
	UINT64 windows_time;

	time(&unix_time);
	windows_time = unix_time;
	windows_time *= 10000000;
	windows_time += 621355968000000000ULL;

	return windows_time;
}

static char* winpr_read_unix_timezone_identifier_from_file(FILE* fp)
{
	INT64 length;
	char* tzid = NULL;

	if (_fseeki64(fp, 0, SEEK_END) != 0)
		return NULL;
	length = _ftelli64(fp);
	if (_fseeki64(fp, 0, SEEK_SET) != 0)
		return NULL;

	if (length < 2)
		return NULL;

	tzid = (char*) malloc(length + 1);
	if (!tzid)
		return NULL;

	if (fread(tzid, length, 1, fp) != 1)
	{
		free(tzid);
		return NULL;
	}

	tzid[length] = '\0';
	if (tzid[length - 1] == '\n')
		tzid[length - 1] = '\0';

	return tzid;
}

static char* winpr_get_timezone_from_link(void)
{
	const char* links[] =
	{
		"/etc/localtime",
		"/etc/TZ"
	};
	size_t x;
	ssize_t len;
	char buf[1024];
	char* tzid = NULL;

	/*
	 * On linux distros such as Redhat or Archlinux, a symlink at /etc/localtime
	 * will point to /usr/share/zoneinfo/region/place where region/place could be
	 * America/Montreal for example.
	 * Some distributions do have to symlink at /etc/TZ.
	 */

	for (x=0; x<sizeof(links) / sizeof(links[0]); x++)
	{
		const char* link = links[x];

		if ((len = readlink(link, buf, sizeof(buf) - 1)) != -1)
		{
			int num = 0;
			int pos = len;

			buf[len] = '\0';

			/* find the position of the 2nd to last "/" */

			while (num < 2)
			{
				if (pos == 0)
					break;

				pos -= 1;

				if (buf[pos] == '/')
					num++;
			}

			tzid = (char*) malloc(len - pos + 1);
			if (!tzid)
				return NULL;

			strncpy(tzid, buf + pos + 1, len - pos);

			return tzid;
		}
	}

	return NULL;
}

static char* winpr_get_unix_timezone_identifier_from_file(void)
{
	FILE* fp;
	char* tzid = NULL;

#if defined(ANDROID)
	fp = popen("getprop persist.sys.timezone", "r");
#elif defined(__FreeBSD__) || defined(__OpenBSD__)
	fp = fopen("/var/db/zoneinfo", "r");
#else
	fp = fopen("/etc/timezone", "r");
#endif

	if (NULL == fp )
		return NULL;

	tzid = winpr_read_unix_timezone_identifier_from_file(fp);

#if defined(ANDROID)
	pclose(fp) ;
#else
	fclose(fp) ;
#endif
	return tzid;
}


static BOOL winpr_match_unix_timezone_identifier_with_list(const char* tzid, const char* list)
{
	char* p;
	char* list_copy;

	list_copy = _strdup(list);
	if (!list_copy)
		return FALSE;

	p = strtok(list_copy, " ");

	while (p != NULL)
	{
		if (strcmp(p, tzid) == 0)
		{
			free(list_copy);
			return TRUE;
		}

		p = strtok(NULL, " ");
	}

	free(list_copy);

	return FALSE;
}

static TIME_ZONE_ENTRY* winpr_detect_windows_time_zone(void)
{
	int i, j;
	char* tzid;
	TIME_ZONE_ENTRY* timezone;

	tzid = winpr_get_unix_timezone_identifier_from_file();

	if (tzid == NULL)
		tzid = winpr_get_timezone_from_link();

	if (tzid == NULL)
		return NULL;

	for (i = 0; i < ARRAYSIZE(TimeZoneTable); i++)
	{
		for (j = 0; j < ARRAYSIZE(WindowsTimeZoneIdTable); j++)
		{
			if (strcmp(TimeZoneTable[i].Id, WindowsTimeZoneIdTable[j].windows) != 0)
				continue;

			if (winpr_match_unix_timezone_identifier_with_list(tzid, WindowsTimeZoneIdTable[j].tzid))
			{
				free(tzid);

				timezone = (TIME_ZONE_ENTRY*) malloc(sizeof(TIME_ZONE_ENTRY));
				if (!timezone)
					return NULL;
				memcpy((void*) timezone, (void*) &TimeZoneTable[i], sizeof(TIME_ZONE_ENTRY));
				return timezone;
			}
		}
	}

	WLog_ERR(TAG,  "Unable to find a match for unix timezone: %s", tzid);
	free(tzid);
	return NULL;
}

static TIME_ZONE_RULE_ENTRY* winpr_get_current_time_zone_rule(TIME_ZONE_RULE_ENTRY* rules, UINT32 count)
{
	int i;
	UINT64 windows_time;

	windows_time = winpr_windows_gmtime();

	for (i = 0; i < (int) count; i++)
	{
		if ((rules[i].TicksStart >= windows_time) && (windows_time >= rules[i].TicksEnd))
		{
			/*WLog_ERR(TAG,  "Got rule %d from table at %p with count %"PRIu32"", i, (void*) rules, count);*/
			return &rules[i];
		}
	}

	WLog_ERR(TAG,  "Unable to get current timezone rule");
	return NULL;
}

DWORD GetTimeZoneInformation(LPTIME_ZONE_INFORMATION lpTimeZoneInformation)
{
	time_t t;
	struct tm* local_time;
	TIME_ZONE_ENTRY* dtz;
	LPTIME_ZONE_INFORMATION tz = lpTimeZoneInformation;

	lpTimeZoneInformation->StandardBias = 0;

	time(&t);
	local_time = localtime(&t);

	memset(tz, 0, sizeof(TIME_ZONE_INFORMATION));

#ifdef HAVE_TM_GMTOFF
	tz->Bias = -(local_time->tm_gmtoff / 60);
#else
	tz->Bias = 0;
#endif

	dtz = winpr_detect_windows_time_zone();

	if (dtz!= NULL)
	{
		int status;
		WLog_DBG(TAG, "tz: Bias=%"PRId32" sn='%s' dln='%s'",
			dtz->Bias, dtz->StandardName, dtz->DaylightName);

		tz->Bias = dtz->Bias;
		tz->StandardBias = 0;
		tz->DaylightBias = 0;

		ZeroMemory(tz->StandardName, sizeof(tz->StandardName));
		ZeroMemory(tz->DaylightName, sizeof(tz->DaylightName));
		status = MultiByteToWideChar(CP_UTF8, 0, dtz->StandardName, -1, tz->StandardName,
									 sizeof(tz->StandardName)/sizeof(WCHAR)-1);
		if (status < 1)
		{
			WLog_ERR(TAG, "StandardName conversion failed - using default");
			goto out_error;
		}

		status = MultiByteToWideChar(CP_UTF8, 0, dtz->DaylightName, -1, tz->DaylightName,
									 sizeof(tz->DaylightName)/sizeof(WCHAR)-1);
		if (status < 1)
		{
			WLog_ERR(TAG, "DaylightName conversion failed - using default");
			goto out_error;
		}

		if ((dtz->SupportsDST) && (dtz->RuleTableCount > 0))
		{
			TIME_ZONE_RULE_ENTRY* rule;
			rule = winpr_get_current_time_zone_rule(dtz->RuleTable, dtz->RuleTableCount);

			if (rule != NULL)
			{
				tz->DaylightBias = -rule->DaylightDelta;

				tz->StandardDate = rule->StandardDate;
				tz->DaylightDate = rule->DaylightDate;
			}
		}
		free(dtz);

		/* 1 ... TIME_ZONE_ID_STANDARD
		 * 2 ... TIME_ZONE_ID_DAYLIGHT */
		return local_time->tm_isdst ? 2 : 1;
	}

	/* could not detect timezone, use computed bias from tm_gmtoff */
	WLog_DBG(TAG, "tz not found, using computed bias %"PRId32".", tz->Bias);
out_error:
	free(dtz);
	memcpy(tz->StandardName, L"Client Local Time", sizeof(tz->StandardName));
	memcpy(tz->DaylightName, L"Client Local Time", sizeof(tz->DaylightName));
	return 0; /* TIME_ZONE_ID_UNKNOWN */
}

BOOL SetTimeZoneInformation(const TIME_ZONE_INFORMATION* lpTimeZoneInformation)
{
	return FALSE;
}

BOOL SystemTimeToFileTime(const SYSTEMTIME* lpSystemTime, LPFILETIME lpFileTime)
{
	return FALSE;
}

BOOL FileTimeToSystemTime(const FILETIME *lpFileTime, LPSYSTEMTIME lpSystemTime)
{
	return FALSE;
}

BOOL SystemTimeToTzSpecificLocalTime(LPTIME_ZONE_INFORMATION lpTimeZone,
		LPSYSTEMTIME lpUniversalTime, LPSYSTEMTIME lpLocalTime)
{
	return FALSE;
}

BOOL TzSpecificLocalTimeToSystemTime(LPTIME_ZONE_INFORMATION lpTimeZoneInformation,
		LPSYSTEMTIME lpLocalTime, LPSYSTEMTIME lpUniversalTime)
{
	return FALSE;
}

#endif

/*
 * GetDynamicTimeZoneInformation is provided by the SDK if _WIN32_WINNT >= 0x0600 in SDKs above 7.1A
 * and incorrectly if _WIN32_WINNT >= 0x0501 in older SDKs
 */
#if !defined(_WIN32) || (defined(_WIN32) && (defined(NTDDI_WIN8) && _WIN32_WINNT < 0x0600 || !defined(NTDDI_WIN8) && _WIN32_WINNT < 0x0501)) /* Windows Vista */

DWORD GetDynamicTimeZoneInformation(PDYNAMIC_TIME_ZONE_INFORMATION pTimeZoneInformation)
{
	return 0;
}

BOOL SetDynamicTimeZoneInformation(const DYNAMIC_TIME_ZONE_INFORMATION* lpTimeZoneInformation)
{
	return FALSE;
}

BOOL GetTimeZoneInformationForYear(USHORT wYear, PDYNAMIC_TIME_ZONE_INFORMATION pdtzi, LPTIME_ZONE_INFORMATION ptzi)
{
	return FALSE;
}

#endif

#if !defined(_WIN32) || (defined(_WIN32) && (_WIN32_WINNT < 0x0601)) /* Windows 7 */

BOOL SystemTimeToTzSpecificLocalTimeEx(const DYNAMIC_TIME_ZONE_INFORMATION* lpTimeZoneInformation,
		const SYSTEMTIME* lpUniversalTime, LPSYSTEMTIME lpLocalTime)
{
	return FALSE;
}

BOOL TzSpecificLocalTimeToSystemTimeEx(const DYNAMIC_TIME_ZONE_INFORMATION* lpTimeZoneInformation,
		const SYSTEMTIME* lpLocalTime, LPSYSTEMTIME lpUniversalTime)
{
	return FALSE;
}

#endif

#if !defined(_WIN32) || (defined(_WIN32) && (_WIN32_WINNT < 0x0602)) /* Windows 8 */

DWORD EnumDynamicTimeZoneInformation(const DWORD dwIndex, PDYNAMIC_TIME_ZONE_INFORMATION lpTimeZoneInformation)
{
	return 0;
}

DWORD GetDynamicTimeZoneInformationEffectiveYears(const PDYNAMIC_TIME_ZONE_INFORMATION lpTimeZoneInformation,
		LPDWORD FirstYear, LPDWORD LastYear)
{
	return 0;
}

#endif
