/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MapMarkerDot;
import org.openstreetmap.gui.jmapviewer.OsmFileCacheTileLoader;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.events.JMVCommandEvent;
import org.openstreetmap.gui.jmapviewer.interfaces.JMapViewerEventListener;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.BingAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOpenAerialTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.MapQuestOsmTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;

public class Demo
extends JFrame
implements JMapViewerEventListener {
    private static final long serialVersionUID = 1L;
    private JMapViewer map = null;
    private JLabel zoomLabel = null;
    private JLabel zoomValue = null;
    private JLabel mperpLabelName = null;
    private JLabel mperpLabelValue = null;

    public Demo() {
        super("JMapViewer Demo");
        JComboBox<TileLoader> tileLoaderSelector;
        this.setSize(400, 400);
        this.map = new JMapViewer();
        this.map.addJMVListener(this);
        this.setLayout(new BorderLayout());
        this.setDefaultCloseOperation(3);
        this.setExtendedState(6);
        JPanel panel = new JPanel();
        JPanel panelTop = new JPanel();
        JPanel panelBottom = new JPanel();
        JPanel helpPanel = new JPanel();
        this.mperpLabelName = new JLabel("Meters/Pixels: ");
        this.mperpLabelValue = new JLabel(String.format("%s", this.map.getMeterPerPixel()));
        this.zoomLabel = new JLabel("Zoom: ");
        this.zoomValue = new JLabel(String.format("%s", this.map.getZoom()));
        this.add((Component)panel, "North");
        this.add((Component)helpPanel, "South");
        panel.setLayout(new BorderLayout());
        panel.add((Component)panelTop, "North");
        panel.add((Component)panelBottom, "South");
        JLabel helpLabel = new JLabel("Use right mouse button to move,\n left double click or mouse wheel to zoom.");
        helpPanel.add(helpLabel);
        JButton button = new JButton("setDisplayToFitMapMarkers");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map.setDisplayToFitMapMarkers();
            }
        });
        JComboBox<TileSource> tileSourceSelector = new JComboBox<TileSource>(new TileSource[]{new OsmTileSource.Mapnik(), new OsmTileSource.CycleMap(), new BingAerialTileSource(), new MapQuestOsmTileSource(), new MapQuestOpenAerialTileSource()});
        tileSourceSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Demo.this.map.setTileSource((TileSource)e.getItem());
            }
        });
        try {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmFileCacheTileLoader(this.map), new OsmTileLoader(this.map)});
        }
        catch (IOException e) {
            tileLoaderSelector = new JComboBox<TileLoader>(new TileLoader[]{new OsmTileLoader(this.map)});
        }
        tileLoaderSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                Demo.this.map.setTileLoader((TileLoader)e.getItem());
            }
        });
        this.map.setTileLoader((TileLoader)tileLoaderSelector.getSelectedItem());
        panelTop.add(tileSourceSelector);
        panelTop.add(tileLoaderSelector);
        final JCheckBox showMapMarker = new JCheckBox("Map markers visible");
        showMapMarker.setSelected(this.map.getMapMarkersVisible());
        showMapMarker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map.setMapMarkerVisible(showMapMarker.isSelected());
            }
        });
        panelBottom.add(showMapMarker);
        final JCheckBox showTileGrid = new JCheckBox("Tile grid visible");
        showTileGrid.setSelected(this.map.isTileGridVisible());
        showTileGrid.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map.setTileGridVisible(showTileGrid.isSelected());
            }
        });
        panelBottom.add(showTileGrid);
        final JCheckBox showZoomControls = new JCheckBox("Show zoom controls");
        showZoomControls.setSelected(this.map.getZoomContolsVisible());
        showZoomControls.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map.setZoomContolsVisible(showZoomControls.isSelected());
            }
        });
        panelBottom.add(showZoomControls);
        final JCheckBox scrollWrapEnabled = new JCheckBox("Scrollwrap enabled");
        scrollWrapEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Demo.this.map.setScrollWrapEnabled(scrollWrapEnabled.isSelected());
            }
        });
        panelBottom.add(scrollWrapEnabled);
        panelBottom.add(button);
        panelTop.add(this.zoomLabel);
        panelTop.add(this.zoomValue);
        panelTop.add(this.mperpLabelName);
        panelTop.add(this.mperpLabelValue);
        this.add((Component)this.map, "Center");
        this.map.addMapMarker(new MapMarkerDot(49.814284999, 8.642065999));
        this.map.addMapMarker(new MapMarkerDot(49.91, 8.24));
        this.map.addMapMarker(new MapMarkerDot(49.71, 8.64));
        this.map.addMapMarker(new MapMarkerDot(48.71, -1.0));
        this.map.addMapMarker(new MapMarkerDot(49.8588, 8.643));
        this.map.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Demo.this.map.getAttribution().handleAttribution(e.getPoint(), true);
                }
            }
        });
        this.map.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                boolean cursorHand = Demo.this.map.getAttribution().handleAttributionCursor(e.getPoint());
                if (cursorHand) {
                    Demo.this.map.setCursor(new Cursor(12));
                } else {
                    Demo.this.map.setCursor(new Cursor(0));
                }
            }
        });
    }

    public static void main(String[] args) {
        new Demo().setVisible(true);
    }

    private void updateZoomParameters() {
        if (this.mperpLabelValue != null) {
            this.mperpLabelValue.setText(String.format("%s", this.map.getMeterPerPixel()));
        }
        if (this.zoomValue != null) {
            this.zoomValue.setText(String.format("%s", this.map.getZoom()));
        }
    }

    @Override
    public void processCommand(JMVCommandEvent command) {
        if (command.getCommand().equals((Object)JMVCommandEvent.COMMAND.ZOOM) || command.getCommand().equals((Object)JMVCommandEvent.COMMAND.MOVE)) {
            this.updateZoomParameters();
        }
    }
}

