.TH FOTOXX 1 2020-01-01 "Linux" "Fotoxx man page"
.SH NAME
Fotoxx \- photo/image editor and collection manager

.SH DESCRIPTION
Organize and manage a large image collection. Edit and optimize photos and
other images, edit metadata, search images, and perform batch operations.
.br
Fotoxx is a GTK GUI application. The included user manual explains Fotoxx
operation in great detail. The following is a summary of capabilities.

.SH CAPABILITIES
• Organize and manage a very large photo/image collection.
.br
• Thumbnail browser/navigator with adjustable thumb size and list view.
.br
• Click thumbnail for full-size view, image zoom in/out and pan/scroll.
.br
• RAW file conversion, single or batch, save with 8 or 16 bits/color.
.br
• Edit RAW files directly using RawTherapee or the Fotoxx edit functions.
.br
• Large set of functions to edit, repair, enhance, and transform images.
.br
• Internal processing in 24 bits per color (float), output in 8 or 16 bits.
.br
• Edited files have a version number, originals are retained by default.
.br
• Fast edit visual feedback using the full image or selected zoom-in area.
.br
• Undo/Redo edits, go back and forth to compare original and edited versions.
.br
• Conventional edit functions include: brightness, contrast, color balance,
  saturation, trim/crop, rotate, upright, resize, sharpen, denoise, blur,
  paint, draw text/line/arrow/box, red eyes, smart erase (remove spoilers),
  fix perspective, warp/unwarp, HDR, panorama, stack/edit, photo montage ...
.br
• Advanced edit functions to bring out details and add flair to an image:
  Edit brightness distribution, Global/zonal Retinex, Gradients ...
.br
• A large set of creative special effects and arty transforms is available:
  sketch, cartoon, drawing, emboss, tiles, dither, painting, mosaic, sphere,
  tiny planet, Escher spiral, custom convolution kernels ...
.br
• Most edit functions can be 'painted' locally and gradually with the mouse.
.br
• Select image objects or areas to edit separately from the background:
  outline by hand, follow feature edges, 'flood' into matching colors ...
.br
• Special selection tool for complex image features (e.g. hair, foliage).
.br
• Copy areas within and across images by mouse painting and blending.
.br
• Create or maintain transparent image areas while editing.
.br
• Mashup: arrange images and text in an arbitrary layout using the mouse.
.br
• Custom scripts: record a series of edits and use as a new edit function.
.br
• Custom favorites menu: select and arrange icons and text in popup window.
.br
• Plugins: use other edit apps (e.g. Gimp) as Fotoxx plug-in edit function.
.br
• Batch tools for renaming, resizing, converting, processing RAW files,
  adding/revising/reporting metadata, and executing custom edit scripts.
.br
• Metadata edit and report (tags, dates, captions, geotags ... any metadata).
.br
• Search images using any metadata and folder/file names or partial names:
  dates, tags, locations, ratings, captions, comments, exposure data ...
.br
• Show a table of image locations and date groups, click for image gallery.
.br
• Show an image calendar, click on year or month for a gallery of images.
.br
• Click markers on a scalable internet map for gallery of images at location.
.br
• Use locally stored maps: world, continents, nations, cities, custom maps.
.br
• View 360 degree panorama image (Google Street View format).
.br
• Show video files (first frame) in thumbnails, view full size, play video.
.br
• Show animated GIF files (first frame) in thumbnails, play animation.
.br
• Bookmarks: assign names to file locations, list names, goto name (gallery).
.br
• Create albums linking selected images. Arrange sequence by drag and drop.
.br
• Slide show: show album images with animated transitions and pan/zoom.
.br
• Print an image at any scale. Printer color calibration tool is available.
.br
• Custom keyboard shortcuts can be assigned to most functions.
.br
• Comprehensive user guide and context help popups via F1 key.

.SH SEE ALSO
The User Guide is available from the menu Help > User Guide
.br
The home page for Fotoxx is at https://kornelix.net

.SH AUTHORS
Written by Mike Cornelison <mkornelix@gmail.com>
