/**************************************************************************
   fotoxx-maps      general wildcard file and string search

   Copyright 2007-2019 Michael Cornelison
   source code URL: https://kornelix.net
   contact: kornelix@posteo.de

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version. See https://www.gnu.org/licenses

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
   See the GNU General Public License for more details.

***************************************************************************/

#include "zfuncs.h"


namespace zfuncs {
   extern char       *appimagexe;                                                //  appimage executable path name
   extern char       *progexe;                                                   //  executable path name
}


int main(int argc, char *argv[])
{
   using namespace zfuncs;

   cchar    *message1 = "Already installed at /usr/share/fotoxx-maps";
   cchar    *message2 = "Copy Fotoxx map files to \n"
                        " %s/.local/share/fotoxx-maps ?";
   cchar    *message3 = "Remove Fotoxx map files ?";

   int      err, yn, ii;
   char     command[200], sharedir[100];
   STATB    statb;
   
   snprintf(sharedir,100,"%s/usr/share/",getenv("HERE"));
   err = stat(sharedir,&statb);
   if (err) {
      printz("use command: 'sudo make install' or 'sudo make uninstall' \n"
             "to install or uninstall fotoxx-map files from this package \n");
      exit(0);
   }
   
   setenv("GDK_BACKEND","x11",1);                                                //  fedora/wayland
   setenv("GTK_THEME","default",0);                                              //  KDE window manager

   gtk_init(&argc, &argv);                                                       //  GTK command line options

   zinitapp("fotoxx-maps");                                                      //  set up app directories
   
   ii = zdialog_choose(null,"desktop","fotoxx-map files",                        //  get user choice
                              "install","uninstall","quit",null);

   if (ii == 1)                                                                  //  install
   {
      err = stat("/usr/share/fotoxx-maps/data",&statb);
      if (! err) {
         zmessageACK(0,message1);                                                //  debian package is installed
         exit(0);                                                                //  notify and do nothing
      }

      yn = zmessageYN(null,message2,getenv("HOME"));                             //  ask to install map files
      if (! yn) exit(0);
      snprintf(command,200,"cp -R %s $HOME/.local/",sharedir);
      shell_ack(command);
   }

   if (ii == 2)                                                                  //  uninstall
   {
      yn = zmessageYN(null,message3);                                            //  ask to uninstall map files
      if (! yn) exit(0);
      snprintf(command,200,"rm -f -R $HOME/.local/share/fotoxx-maps");
      shell_ack(command);
   }
   
   exit(0);
}


//  supply unused zdialog callback function

void KBevent(GdkEventKey *event)
{ return; }


