# Firejail profile for dconf
# Description: Configuration database system
# This file is overwritten after every install/update
# Persistent local customizations
include dconf.local
# Persistent global definitions
include globals.local

whitelist ${HOME}/.local/share/glib-2.0

include disable-common.inc
include disable-devel.inc
include disable-exec.inc
include disable-interpreters.inc
include disable-passwdmgr.inc
include disable-programs.inc
include disable-xdg.inc

# dconf paths are whitelisted by the following
include whitelist-common.inc

apparmor
caps.drop all
ipc-namespace
machine-id
net none
no3d
nodvd
nogroups
nonewprivs
noroot
nosound
notv
nou2f
novideo
protocol unix
seccomp
shell none
tracelog

disable-mnt
private-bin dconf,gsettings
private-cache
private-dev
private-etc alternatives,dconf
private-lib
private-tmp

memory-deny-write-execute
