/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins;

import info.dolezel.fatrat.plugins.TransferPlugin;
import info.dolezel.fatrat.plugins.extra.DownloadUrl;
import info.dolezel.fatrat.plugins.listeners.CaptchaListener;
import info.dolezel.fatrat.plugins.listeners.PageFetchListener;
import info.dolezel.fatrat.plugins.listeners.ReCaptchaListener;
import info.dolezel.fatrat.plugins.listeners.WaitListener;
import info.dolezel.fatrat.plugins.util.FormatUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public abstract class DownloadPlugin
extends TransferPlugin {
    private static final Pattern reImageCode = Pattern.compile("challenge : '([^']+)");

    public abstract void processLink(String var1);

    public void onFailed() {
    }

    protected final native void startDownload(DownloadUrl var1);

    protected final void startDownload(String url, String referrer, String userAgent, String fileName) {
        this.startDownload(new DownloadUrl(url).setReferrer(referrer).setUserAgent(userAgent).setFileName(fileName));
    }

    protected final void startDownload(String url) {
        this.startDownload(new DownloadUrl(url));
    }

    protected final void startDownload(String url, String referrer) {
        this.startDownload(new DownloadUrl(url).setReferrer(referrer));
    }

    protected final void startDownload(String url, String referrer, String userAgent) {
        this.startDownload(new DownloadUrl(url).setReferrer(referrer).setUserAgent(userAgent));
    }

    protected final native void startWait(int var1, WaitListener var2);

    protected final native void solveCaptcha(String var1, CaptchaListener var2);

    protected void solveCaptchaLoadLocally(String url, final CaptchaListener cb) {
        this.fetchPage(url, new PageFetchListener(){

            @Override
            public void onCompleted(ByteBuffer buf, Map<String, String> headers) {
                String type = headers.containsKey("content-type") ? headers.get("content-type") : "";
                byte[] b = new byte[buf.remaining()];
                buf.get(b);
                String encodedImage = "data:" + type + ";base64," + Base64.encodeBase64String((byte[])b);
                DownloadPlugin.this.solveCaptcha(encodedImage, cb);
            }

            @Override
            public void onFailed(String error) {
                cb.onFailed();
            }
        });
    }

    protected void solveReCaptcha(String code, final ReCaptchaListener cl) {
        this.fetchPage("http://www.google.com/recaptcha/api/challenge?k=" + code + "&ajax=1", new PageFetchListener(){

            @Override
            public void onCompleted(ByteBuffer buf, Map<String, String> headers) {
                CharBuffer cb = DownloadPlugin.this.charsetUtf8.decode(buf);
                final Matcher m = reImageCode.matcher(cb);
                if (!m.find()) {
                    DownloadPlugin.this.setFailed("Failed to find the captcha image code");
                    return;
                }
                DownloadPlugin.this.solveCaptcha("http://www.google.com/recaptcha/api/image?c=" + m.group(1), new CaptchaListener(){

                    @Override
                    public void onFailed() {
                        cl.onFailed();
                    }

                    @Override
                    public void onSolved(String text) {
                        cl.onSolved(text, m.group(1));
                    }
                });
            }

            @Override
            public void onFailed(String error) {
                DownloadPlugin.this.setFailed(error);
            }
        });
    }

    protected final native void reportFileName(String var1);

    public void finalCheck(String filePath) {
    }

    public static String formatTime(int seconds) {
        return FormatUtils.formatTime(seconds);
    }
}

