/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins.helpers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;

class NativeHelpers {
    private static final MyClassLoader loader = new MyClassLoader(Thread.currentThread().getContextClassLoader());

    private NativeHelpers() {
    }

    public static Map<String, String> getPackageVersions() throws IOException {
        HashMap<String, String> rv = new HashMap<String, String>();
        String[] jars = System.getProperty("java.class.path").split(":");
        for (String jar : jars) {
            String name;
            File fo = new File(jar);
            if (!fo.exists() || !(name = fo.getName()).startsWith("fatrat-") || name.equals("fatrat-jplugins-core.jar") || name.equals("fatrat-jplugins-json.jar")) continue;
            NativeHelpers.getPackageVersion(fo, rv);
        }
        for (URL url : loader.getURLs()) {
            String jarPath = url.getPath().replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
            NativeHelpers.getPackageVersion(new File(jarPath), rv);
        }
        return rv;
    }

    private static void getPackageVersion(File fo, Map<String, String> rv) throws IOException {
        if (!fo.exists()) {
            return;
        }
        JarFile file = new JarFile(fo);
        Manifest manifest = file.getManifest();
        Attributes attr = manifest.getMainAttributes();
        rv.put(fo.getName(), attr.getValue("Implementation-Version"));
    }

    public static void loadPackage(String path) throws Exception {
        loader.addJar(path);
    }

    public static Class[] findAnnotatedClasses(String path, String packageName, String annotation) throws IOException, ClassNotFoundException {
        URL url = new URL("jar", "", "file:" + path + "!/");
        Set<Class> classes = NativeHelpers.findClasses(new File(url.getFile()), packageName, Class.forName(annotation));
        return classes.toArray(new Class[classes.size()]);
    }

    public static Class[] findAnnotatedClasses(String packageName, String annotation) throws IOException, ClassNotFoundException {
        Class[] c = NativeHelpers.findAnnotatedClasses(packageName, Class.forName(annotation));
        return c;
    }

    public static Class[] findAnnotatedClasses(String packageName, Class annotation) throws IOException, ClassNotFoundException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = loader.getResources(path);
        HashSet<File> dirs = new HashSet<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        for (URL url : loader.getURLs()) {
            dirs.add(new File(url.getFile()));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (File directory : dirs) {
            classes.addAll(NativeHelpers.findClasses(directory, packageName, annotation));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private static Set<Class> findClasses(File directory, String packageName, Class annotation) throws ClassNotFoundException, IOException {
        HashSet<Class> classes = new HashSet<Class>();
        if (!directory.exists()) {
            String fullPath = directory.toString();
            String jarPath = fullPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
                String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
                Class<?> cls = loader.loadClass(className);
                if (annotation != null && !cls.isAnnotationPresent(annotation)) continue;
                classes.add(cls);
            }
        } else {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(NativeHelpers.findClasses(file, packageName + "." + file.getName(), annotation));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                Class<?> cls = loader.loadClass(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
                if (annotation != null && !cls.isAnnotationPresent(annotation)) continue;
                classes.add(cls);
            }
        }
        return classes;
    }

    public static String loadDialogFile(String path) {
        try {
            InputStream stream = loader.getResourceAsStream(path);
            if (stream == null) {
                return null;
            }
            return IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static class MyClassLoader
    extends URLClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(new URL[0], parent);
        }

        public void addJar(String path) throws MalformedURLException {
            URL url = new URL("jar", "", "file:" + path + "!/");
            this.addURL(url);
        }
    }
}

