/*
 * Decompiled with CFR 0.152.
 */
package info.dolezel.fatrat.plugins.helpers;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;

class JarClassLoader
extends URLClassLoader {
    Map<String, JarClassLoader> children = new HashMap<String, JarClassLoader>();
    Set<String> loadedExtensions = new HashSet<String>();
    Map<String, String> classCache = new HashMap<String, String>();

    public JarClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
    }

    public JarClassLoader() {
        this(JarClassLoader.class.getClassLoader());
    }

    public JarClassLoader addExtension(String path) throws MalformedURLException {
        JarClassLoader child = new JarClassLoader(JarClassLoader.class.getClassLoader());
        child.addJar(path);
        this.children.put(path, child);
        this.loadedExtensions.add(path);
        return child;
    }

    public JarClassLoader removeExtension(String path) {
        this.loadedExtensions.remove(path);
        return this.children.remove(path);
    }

    private void addJar(String path) throws MalformedURLException {
        URL url = new URL("jar", "", "file:" + path + "!/");
        this.addURL(url);
    }

    public Class loadExtensionClass(String name) {
        Class c;
        JarClassLoader cl;
        if (this.classCache.containsKey(name) && (cl = this.children.get(this.classCache.get(name))) != null) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException ex) {
                this.classCache.remove(name);
            }
        }
        try {
            c = this.loadClass(name);
        }
        catch (ClassNotFoundException ex) {
            c = null;
        }
        if (c != null) {
            return c;
        }
        for (Map.Entry<String, JarClassLoader> e : this.children.entrySet()) {
            c = e.getValue().loadExtensionClass(name);
            if (c == null) continue;
            this.classCache.put(name, e.getKey());
            return c;
        }
        return null;
    }

    public void loadAllExtensions(String path) throws Exception {
        File[] extensions;
        File f = new File(path);
        for (File e : extensions = f.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".jar");
            }
        })) {
            this.addExtension(e.getAbsolutePath());
        }
    }

    public Map<String, String> getPackageVersions() throws IOException {
        HashMap<String, String> rv = new HashMap<String, String>();
        Iterator<String> it = this.loadedExtensions.iterator();
        while (it.hasNext()) {
            JarClassLoader.getPackageVersion(new File(it.next()), rv);
        }
        return rv;
    }

    private static void getPackageVersion(File fo, Map<String, String> rv) throws IOException {
        if (!fo.exists()) {
            return;
        }
        JarFile file = new JarFile(fo);
        Manifest manifest = file.getManifest();
        Attributes attr = manifest.getMainAttributes();
        rv.put(fo.getName(), attr.getValue("Implementation-Version"));
    }

    public String loadPackagedFile(Class c, String path) {
        try {
            InputStream stream = c.getClassLoader().getResourceAsStream(path);
            if (stream == null) {
                return null;
            }
            return IOUtils.toString((InputStream)stream, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Class[] findAnnotatedClasses(String packageName, Class ann) throws IOException, ClassNotFoundException {
        HashSet<Class> rv = new HashSet<Class>();
        rv.addAll(this.findAnnotatedClassesLocal(packageName, ann));
        for (JarClassLoader cl : this.children.values()) {
            rv.addAll(cl.findAnnotatedClassesLocal(packageName, ann));
        }
        return rv.toArray(new Class[rv.size()]);
    }

    public Set<Class> findAnnotatedClassesLocal(String packageName, Class annotation) throws IOException, ClassNotFoundException {
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = this.getResources(path);
        HashSet<File> dirs = new HashSet<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        for (URL url : this.getURLs()) {
            dirs.add(new File(url.getFile()));
        }
        HashSet<Class> classes = new HashSet<Class>();
        for (File directory : dirs) {
            classes.addAll(this.findClasses(directory, packageName, annotation));
        }
        return classes;
    }

    private Set<Class> findClasses(File directory, String packageName, Class annotation) throws ClassNotFoundException, IOException {
        HashSet<Class> classes = new HashSet<Class>();
        if (!directory.exists()) {
            String fullPath = directory.toString();
            String jarPath = fullPath.replaceFirst("[.]jar[!].*", ".jar").replaceFirst("file:", "");
            JarFile jarFile = new JarFile(jarPath);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || entryName.contains("$")) continue;
                String className = entryName.replace('/', '.').replace('\\', '.').replace(".class", "");
                Class<?> cls = this.loadClass(className);
                if (annotation != null && !cls.isAnnotationPresent(annotation)) continue;
                classes.add(cls);
            }
        } else {
            File[] files;
            for (File file : files = directory.listFiles()) {
                if (file.isDirectory()) {
                    assert (!file.getName().contains("."));
                    classes.addAll(this.findClasses(file, packageName + "." + file.getName(), annotation));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                Class<?> cls = this.loadClass(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
                if (annotation != null && !cls.isAnnotationPresent(annotation)) continue;
                classes.add(cls);
            }
        }
        return classes;
    }
}

