.\" dpkg manual page - dpkg-divert(1)
.\"
.\" Copyright © 1995 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 1999 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2004 Scott James Remnant <keybuk@debian.org>
.\" Copyright © 2007-2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-divert 1 %RELEASE_DATE% %VERSION% "Herramientas de dpkg"
.nh
.SH NOMBRE
dpkg\-divert \- Redefine la versión de un fichero del paquete
.
.SH SINOPSIS
\fBdpkg\-divert\fP [\fIopción\fP...] \fIorden\fP
.
.SH DESCRIPCIÓN
\fBdpkg\-divert\fP es una herramienta para configurar y actualizar la lista de
redirecciones.
.PP
File \fIdiversions\fP are a way of forcing \fBdpkg\fP(1)  not to install a file
into its location, but to a \fIdiverted\fP location. Diversions can be used
through the Debian package scripts to move a file away when it causes a
conflict. System administrators can also use it to override some package's
configuration file, or whenever some files (which aren't marked as
“conffiles”) need to be preserved by \fBdpkg\fP, when installing a newer
version of a package which contains those files.
.sp
.SH ÓRDENES
.TP 
[\fB\-\-add\fP] \fIfichero\fP
Añade una redirección para el \fIfichero\fP.
.TP 
\fB\-\-remove\fP\fI fichero\fP
Elimina una redirección para el \fIfichero\fP.
.TP 
\fB\-\-list\fP\fI comodín\fP
Lista las redirecciones que encajan con el \fIcomodín\fP (patrón «glob»).
.TP 
\fB\-\-listpackage\fP\fI fichero\fP
Print the name of the package that diverts \fIfile\fP (since dpkg 1.15.0).
Prints LOCAL if \fIfile\fP is locally diverted and nothing if \fIfile\fP is not
diverted.
.TP 
\fB\-\-truename\fP\fI fichero\fP
Muestra el nombre real del fichero redirigido.
.
.SH OPCIONES
.TP 
\fB\-\-admindir\fP\fI directorio\fP
Set the \fBdpkg\fP data directory to \fIdirectory\fP (default: \fI%ADMINDIR%\fP).
.TP 
\fB\-\-divert\fP\fI redirigir\-a\fP
\fIredirigir\-a\fP es la ubicación donde las versiones del \fIfichero\fP, tal y
como otros paquetes lo ofrecen, se redirigirá.
.TP 
\fB\-\-local\fP
Especifica que todas las versiones de los paquetes de este fichero se
redirigirán. Esto es, sin excepciones, y sin importar qué paquete está
instalado, el fichero se redirigirá. El administrador del sistema puede
utilizar esto para instalar una versión modificada localmente.
.TP 
\fB\-\-package\fP\fI paquete\fP
\fIpaquete\fP es el nombre de un paquete cuya copia del \fIfichero\fP no se
redirigirá. Por ejemplo, el \fIfichero\fP se redirigirá para todos los paquetes
a excepción de \fIpaquete\fP.
.TP 
\fB\-\-quiet\fP
Modo silencioso, esto es: sin información detallada.
.TP 
\fB\-\-rename\fP
Mueve el archivo a un lado (o atrás). \fBdpkg\-divert\fP interrumpirá la
operación en caso de que el fichero destino ya exista.
.TP 
\fB\-\-test\fP
Modo de prueba, esto es, no realiza ningún cambio, sólo muestra su
ejecución.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Muestra el modo de uso y termina.
.TP 
\fB\-\-version\fP
Muestra la versión y termina.
.
.SH "ESTADOS DE SALIDA"
.TP 
\fB0\fP
La acción requerida finalizó con éxito.
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, or
interactions with the system, such as accesses to the database, memory
allocations, etc.
.
.SH ENTORNO
.TP 
\fBDPKG_ADMINDIR\fP
If set and the \fB\-\-admindir\fP option has not been specified, it will be used
as the \fBdpkg\fP data directory.
.TP 
\fBDPKG_MAINTSCRIPT_PACKAGE\fP
Si se define, y las opciones \fB\-\-local\fP y \fB\-\-package\fP no se definen,
\fBdpkg\-divert\fP lo utiliza como el nombre de paquete.
.
.SH FICHEROS
.TP 
\fI%ADMINDIR%/diversions\fP
File which contains the current list of diversions of the system. It is
located in the \fBdpkg\fP administration directory, along with other files
important to \fBdpkg\fP, such as \fIstatus\fP or \fIavailable\fP.
.br
Nota: \fBdpkg\-divert\fP preserva la copia antigua de este archivo, insertando
la extensión \fI\-old\fP antes de reemplazarlo con uno nuevo.
.
.SH NOTAS
Al añadir redirecciones se usa \fB\-\-local\fP y \fB\-\-divert\fP
\fIoriginal\fP\fB.distrib\fP de forma predefinida. Al eliminar, \fB\-\-package\fP o
\fB\-\-local\fP deben coincidir con \fB\-\-divert\fP si se definen.

Los directorios no se pueden redirigir con \fBdpkg\-divert\fP.

Care should be taken when diverting shared libraries, \fBldconfig\fP(8)
creates a symbolic link based on the DT_SONAME field embedded in the
library.  Because \fBldconfig\fP doesn't honour diverts (only \fBdpkg\fP does),
the symlink may end up pointing at the diverted library, if a diverted
library has the same SONAME as the undiverted one.
.
.SH EJEMPLOS
Para redireccionar todas las copias de \fI/usr/bin/ejemplo\fP a
\fI/usr/bin/ejemplo.foo\fP; hará que todos los paquetes que provean
\fI/usr/bin/ejemplo\fP lo instalen como \fI/usr/bin/ejemplo.foo\fP, renombrando el
fichero en caso de ser necesario.
.HP
dpkg\-divert \-\-divert /usr/bin/ejemplo.foo \-\-rename /usr/bin/ejemplo
.PP
Para eliminar esa redirección:
.HP
dpkg\-divert \-\-rename \-\-remove /usr/bin/ejemplo

.PP
Para redireccionar cualquier paquete que instale \fI/usr/bin/ejemplo\fP como
\fI/usr/bin/ejemplo.foo\fP, a excepción de su propio paquete \fIwibble\fP:
.HP
dpkg\-divert \-\-package wibble \-\-divert /usr/bin/ejemplo.foo \-\-rename
/usr/bin/ejemplo
.PP
Para eliminar esa redirección:
.HP
dpkg\-divert \-\-package wibble \-\-rename \-\-remove /usr/bin/ejemplo
.
.SH "VÉASE TAMBIÉN"
\fBdpkg\fP(1).
.SH TRADUCTOR
Rudy Godoy <rudy@kernel\-panik.org>,
Rubén Porras <nahoo@inicia.es>,
Bruno Barrera C. <bruno.barrera@igloo.cl>,
Carlos Izquierdo <gheesh@ertis.net>,
Esteban Manchado y
NOK.
Debian L10n Spanish <debian\-l10n\-spanish@lists.debian.org>.
.br
Revisiones por Santiago Vila <sanvila@unex.es>,
Javier Fernández\-Sanguino, Rubén Porras,
Luis Uribe y Omar Campagne.
