/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.clickhouse.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;

public class ClickhouseTable
extends GenericTable
implements DBPObjectStatistics {
    private static final Log log = Log.getLog(ClickhouseTable.class);
    private Long tableSize;
    private long tableRows;
    private Date lastModifyTime;
    private String maxDate;
    private String minDate;
    private String engine;

    ClickhouseTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    public boolean hasStatistics() {
        return this.tableSize != null;
    }

    @Property(category="Statistics", viewable=true, order=20, formatter=ByteNumberFormat.class)
    public long getStatObjectSize() {
        return this.tableSize == null ? 0L : this.tableSize;
    }

    @Property(category="Statistics", viewable=true, order=21)
    @Nullable
    public synchronized Long getRowCount(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.tableRows;
    }

    @Property(category="Statistics", order=22)
    public Date getLastModifyTime(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.lastModifyTime;
    }

    @Property(category="Statistics", order=23)
    public String getMinDate(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.minDate;
    }

    @Property(category="Statistics", order=24)
    public String getMaxDate(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.maxDate;
    }

    @Property(category="Statistics", viewable=true, order=25)
    public String getEngine(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.engine;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readStatistics(DBRProgressMonitor monitor) {
        if (this.hasStatistics()) {
            return;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read relation statistics");){
            try {
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("select sum(bytes) as table_size, sum(rows) as table_rows, max(modification_time) as latest_modification,min(min_date) AS min_date,max(max_date) AS max_date,any(engine) as engine\nFROM system.parts\nWHERE database=? AND table=?\nGROUP BY table");){
                    dbStat.setString(1, ((GenericStructContainer)this.getContainer()).getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchStatistics(dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                log.error((Object)"Error reading table statistics", (Throwable)e);
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tableSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"table_size");
        this.tableRows = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"table_rows");
        this.lastModifyTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"latest_modification");
        this.maxDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"max_date");
        this.minDate = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"min_date");
        this.engine = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"engine");
    }
}

