/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNLocalFolder;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNProjectDatabases;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSWrapper;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTree;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseNavigatorTreeFilter;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;

public class ObjectBrowserDialog
extends Dialog {
    private String title;
    private DBNNode rootNode;
    private DBNNode selectedNode;
    private boolean singleSelection;
    private Class<?>[] allowedTypes;
    private Class<?>[] resultTypes;
    private Class<?>[] leafTypes;
    private List<DBNNode> selectedObjects = new ArrayList<DBNNode>();
    private TreeNodeSpecial specialNode;
    private DatabaseNavigatorTree navigatorTree;
    private static boolean showConnected;

    private ObjectBrowserDialog(Shell parentShell, String title, DBNNode rootNode, DBNNode selectedNode, boolean singleSelection, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        super(parentShell);
        this.title = title;
        this.rootNode = rootNode;
        this.selectedNode = selectedNode;
        this.singleSelection = singleSelection;
        this.allowedTypes = allowedTypes;
        this.resultTypes = resultTypes == null ? allowedTypes : resultTypes;
        this.leafTypes = leafTypes;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        Composite group = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        DatabaseNavigatorTreeFilter filter = new DatabaseNavigatorTreeFilter(){

            @Override
            public boolean isLeafObject(Object object) {
                DBSObject dbObject;
                if (ObjectBrowserDialog.this.leafTypes != null && ObjectBrowserDialog.this.leafTypes.length > 0 && object instanceof DBNDatabaseNode && (dbObject = ((DBNDatabaseNode)object).getObject()) != null) {
                    Class[] classArray = ObjectBrowserDialog.this.leafTypes;
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class leafType = classArray[n2];
                        if (leafType.isAssignableFrom(dbObject.getClass())) {
                            return true;
                        }
                        ++n2;
                    }
                }
                return super.isLeafObject(object);
            }
        };
        this.navigatorTree = new DatabaseNavigatorTree(group, this.rootNode, (this.singleSelection ? 4 : 2) | 0x800, false, filter);
        gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 500;
        this.navigatorTree.setLayoutData(gd);
        final TreeViewer treeViewer = this.navigatorTree.getViewer();
        treeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (showConnected) {
                    if (element instanceof DBNDataSource) {
                        return ((DBNDataSource)element).getDataSource() != null;
                    }
                    if (element instanceof DBNLocalFolder) {
                        return ((DBNLocalFolder)element).hasConnected();
                    }
                }
                if (element instanceof TreeNodeSpecial || element instanceof DBNLocalFolder) {
                    return true;
                }
                if (element instanceof DBNNode) {
                    if (element instanceof DBNDatabaseFolder) {
                        DBNDatabaseFolder folder = (DBNDatabaseFolder)element;
                        Class folderItemsClass = folder.getChildrenClass();
                        return folderItemsClass != null && ObjectBrowserDialog.this.matchesType(folderItemsClass, false);
                    }
                    if (element instanceof DBNProject || element instanceof DBNProjectDatabases || element instanceof DBNDataSource || element instanceof DBSWrapper && ObjectBrowserDialog.this.matchesType(((DBSWrapper)element).getObject().getClass(), false)) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (this.selectedNode != null) {
            treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.selectedNode));
            if (!(this.selectedNode instanceof DBNDataSource) || ((DBNDataSource)this.selectedNode).getDataSourceContainer().isConnected()) {
                treeViewer.expandToLevel((Object)this.selectedNode, 1);
            }
            this.selectedObjects.add(this.selectedNode);
        }
        treeViewer.addSelectionChangedListener(event -> {
            this.selectedObjects.clear();
            this.specialNode = null;
            IStructuredSelection selection = (IStructuredSelection)treeViewer.getSelection();
            for (Object node : selection) {
                if (node instanceof DBNNode && node instanceof DBSWrapper) {
                    DBSObject object = (DBSObject)DBUtils.getAdapter(DBSObject.class, (Object)((DBSWrapper)node).getObject());
                    if (object == null) continue;
                    if (!this.matchesType(object.getClass(), true)) {
                        this.selectedObjects.clear();
                        break;
                    }
                    this.selectedObjects.add((DBNNode)node);
                    continue;
                }
                if (!(node instanceof TreeNodeSpecial)) continue;
                this.specialNode = (TreeNodeSpecial)node;
            }
            this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
        });
        treeViewer.addDoubleClickListener(event -> {
            if (!this.selectedObjects.isEmpty()) {
                this.okPressed();
            } else if (this.specialNode != null) {
                this.specialNode.handleDefaultAction(this.navigatorTree);
            }
        });
        treeViewer.getTree().setFocus();
        final Button showConnectedCheck = new Button(group, 32);
        showConnectedCheck.setText(UINavigatorMessages.label_show_connected);
        showConnectedCheck.setSelection(showConnected);
        showConnectedCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                showConnected = showConnectedCheck.getSelection();
                treeViewer.getControl().setRedraw(false);
                try {
                    treeViewer.refresh();
                    if (showConnected) {
                        treeViewer.expandAll();
                    }
                }
                finally {
                    treeViewer.getControl().setRedraw(true);
                }
            }
        });
        return group;
    }

    private boolean matchesType(Class<?> nodeType, boolean result) {
        Class<?>[] classArray = result ? this.resultTypes : this.allowedTypes;
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ot = classArray[n2];
            if (ot.isAssignableFrom(nodeType)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.getButton(0).setEnabled(!this.selectedObjects.isEmpty());
        return contents;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public List<DBNNode> getSelectedObjects() {
        return this.selectedObjects;
    }

    public static DBNNode selectObject(Shell parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        ObjectBrowserDialog scDialog = new ObjectBrowserDialog(parentShell, title, rootNode, selectedNode, true, allowedTypes, resultTypes, leafTypes);
        if (scDialog.open() == 0) {
            List<DBNNode> result = scDialog.getSelectedObjects();
            return result.isEmpty() ? null : result.get(0);
        }
        return null;
    }

    public static List<DBNNode> selectObjects(Shell parentShell, String title, DBNNode rootNode, DBNNode selectedNode, Class<?>[] allowedTypes, Class<?>[] resultTypes, Class<?>[] leafTypes) {
        ObjectBrowserDialog scDialog = new ObjectBrowserDialog(parentShell, title, rootNode, selectedNode, false, allowedTypes, resultTypes, leafTypes);
        if (scDialog.open() == 0) {
            return scDialog.getSelectedObjects();
        }
        return null;
    }
}

