/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.spreadsheet;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridCell;
import org.jkiss.dbeaver.ui.controls.lightgrid.GridPos;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetModel;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.Spreadsheet;
import org.jkiss.dbeaver.ui.controls.resultset.spreadsheet.SpreadsheetPresentation;
import org.jkiss.utils.CommonUtils;

class SpreadsheetFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Log log = Log.getLog(SpreadsheetFindReplaceTarget.class);
    private final SpreadsheetPresentation owner;
    private Pattern searchPattern;
    private Color scopeHighlightColor;
    private boolean replaceAll;
    private boolean sessionActive = false;
    private List<GridPos> originalSelection = null;

    SpreadsheetFindReplaceTarget(SpreadsheetPresentation owner) {
        this.owner = owner;
        this.scopeHighlightColor = UIStyles.getDefaultTextColor((String)"AbstractTextEditor.Color.FindScope", (int)26);
    }

    public boolean isSessionActive() {
        return this.sessionActive;
    }

    public Pattern getSearchPattern() {
        return this.searchPattern;
    }

    public Color getScopeHighlightColor() {
        return this.scopeHighlightColor;
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public Point getSelection() {
        Collection<Integer> rowSelection = this.owner.getSpreadsheet().getRowSelection();
        int minRow = rowSelection.stream().mapToInt(v -> v).min().orElse(-1);
        int maxRow = rowSelection.stream().mapToInt(v -> v).max().orElse(-1);
        return new Point(minRow, maxRow);
    }

    public String getSelectionText() {
        GridPos selection = (GridPos)this.owner.getSelection().getFirstElement();
        if (selection == null) {
            return "";
        }
        Spreadsheet spreadsheet = this.owner.getSpreadsheet();
        GridCell cell = spreadsheet.posToCell(selection);
        String value = cell == null ? "" : CommonUtils.toString((Object)spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, true, true));
        return CommonUtils.toString((Object)value);
    }

    public boolean isEditable() {
        return this.owner.getController().getReadOnlyStatus() == null;
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void beginSession() {
        this.sessionActive = true;
        this.owner.getControl().redraw();
        this.originalSelection = new ArrayList<GridPos>(this.owner.getSpreadsheet().getSelection());
        this.owner.highlightRows(-1, -1, null);
    }

    public void endSession() {
        this.sessionActive = false;
        this.searchPattern = null;
        Control control = this.owner.getControl();
        if (control != null && !control.isDisposed()) {
            this.owner.getSpreadsheet().deselectAll();
            this.owner.getSpreadsheet().selectCells(this.originalSelection);
        }
    }

    public IRegion getScope() {
        return null;
    }

    public void setScope(IRegion scope) {
        if (scope == null || scope.getLength() == 0) {
            this.owner.highlightRows(-1, -1, null);
            if (scope == null) {
                this.owner.getSpreadsheet().deselectAll();
                this.owner.getSpreadsheet().selectCells(this.originalSelection);
            }
        } else {
            this.owner.highlightRows(scope.getOffset(), scope.getLength(), this.scopeHighlightColor);
        }
    }

    public Point getLineSelection() {
        return this.getSelection();
    }

    public void setSelection(int offset, int length) {
        int columnCount = this.owner.getSpreadsheet().getColumnCount();
        ArrayList<GridPos> selRows = new ArrayList<GridPos>();
        int rowNum = 0;
        while (rowNum < length) {
            int col = 0;
            while (col < columnCount) {
                selRows.add(new GridPos(col, offset + rowNum));
                ++col;
            }
            ++rowNum;
        }
        this.owner.setSelection((ISelection)new StructuredSelection(selRows));
    }

    public void setScopeHighlightColor(Color color) {
        this.scopeHighlightColor = color;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        Pattern findPattern;
        GridPos startPosition;
        int lastRow;
        this.searchPattern = null;
        ResultSetModel model = this.owner.getController().getModel();
        if (model.isEmpty()) {
            return -1;
        }
        Spreadsheet spreadsheet = this.owner.getSpreadsheet();
        int rowCount = spreadsheet.getItemCount();
        int columnCount = spreadsheet.getColumnCount();
        Collection<GridPos> selection = spreadsheet.getSelection();
        int firstRow = this.owner.getHighlightScopeFirstLine();
        if (firstRow < 0) {
            firstRow = 0;
        }
        if ((lastRow = this.owner.getHighlightScopeLastLine()) >= rowCount || lastRow < 0) {
            lastRow = rowCount - 1;
        }
        GridPos gridPos = startPosition = selection.isEmpty() ? null : selection.iterator().next();
        if (startPosition == null) {
            int startRow = searchForward ? firstRow : lastRow;
            startPosition = startRow >= 0 ? new GridPos(0, startRow) : new GridPos(0, 0);
        }
        if (regExSearch) {
            try {
                findPattern = Pattern.compile(findString, caseSensitive ? 0 : 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                log.warn((Object)("Bad regex pattern: " + findString));
                return -1;
            }
        } else {
            findPattern = Pattern.compile(Pattern.quote(findString), caseSensitive ? 0 : 2);
        }
        int minColumnNum = this.owner.getController().isRecordMode() ? -1 : 0;
        GridPos curPosition = new GridPos(startPosition);
        while (true) {
            String cellText;
            if (searchForward) {
                ++curPosition.col;
                if (curPosition.col >= columnCount) {
                    curPosition.col = minColumnNum;
                    ++curPosition.row;
                }
            } else {
                --curPosition.col;
                if (curPosition.col < minColumnNum) {
                    curPosition.col = columnCount - 1;
                    --curPosition.row;
                }
            }
            if (firstRow >= 0 && curPosition.row < firstRow || lastRow >= 0 && curPosition.row > lastRow) {
                if (offset == -1) {
                    offset = 0;
                    curPosition = searchForward ? new GridPos(0, firstRow) : new GridPos(columnCount - 1, lastRow);
                } else {
                    return -1;
                }
            }
            if (this.owner.getController().isRecordMode() && curPosition.col == minColumnNum) {
                cellText = spreadsheet.getLabelProvider().getText(spreadsheet.getRowElement(curPosition.row));
            } else {
                GridCell cell = spreadsheet.posToCell(curPosition);
                if (cell == null) continue;
                cellText = CommonUtils.toString((Object)spreadsheet.getContentProvider().getCellValue(cell.col, cell.row, true, true));
            }
            Matcher matcher = findPattern.matcher(cellText);
            if (wholeWord ? matcher.matches() : matcher.find()) break;
        }
        if (curPosition.col == minColumnNum) {
            curPosition.col = 0;
        }
        spreadsheet.setFocusColumn(curPosition.col);
        spreadsheet.setFocusItem(curPosition.row);
        spreadsheet.setCellSelection(curPosition);
        if (!this.owner.getController().isHasMoreData() || !this.replaceAll || curPosition.row >= spreadsheet.getTopIndex() && curPosition.row < spreadsheet.getBottomIndex()) {
            spreadsheet.showSelection();
        }
        this.searchPattern = findPattern;
        return curPosition.row;
    }

    public void replaceSelection(String text, boolean regExReplace) {
        boolean recordMode;
        GridPos selection = (GridPos)this.owner.getSelection().getFirstElement();
        if (selection == null) {
            return;
        }
        GridCell cell = this.owner.getSpreadsheet().posToCell(selection);
        if (cell == null) {
            return;
        }
        String oldValue = CommonUtils.toString((Object)this.owner.getSpreadsheet().getContentProvider().getCellValue(cell.col, cell.row, true, true));
        String newValue = text;
        if (this.searchPattern != null) {
            newValue = this.searchPattern.matcher(oldValue).replaceAll(newValue);
        }
        DBDAttributeBinding attr = (DBDAttributeBinding)((recordMode = this.owner.getController().isRecordMode()) ? cell.row : cell.col);
        ResultSetRow row = (ResultSetRow)(recordMode ? cell.col : cell.row);
        this.owner.getController().getModel().updateCellValue(attr, row, newValue);
        this.owner.getController().updatePanelsContent(false);
    }

    public String toString() {
        DBSDataContainer dataContainer = this.owner.getController().getDataContainer();
        return "Target: " + (dataContainer == null ? null : dataContainer.getName());
    }
}

