/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.app.standalone;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.ide.ChooseWorkspaceData;
import org.eclipse.ui.internal.ide.ChooseWorkspaceDialog;
import org.eclipse.ui.internal.ide.application.DelayedEventsProcessor;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBASecureStorage;
import org.jkiss.dbeaver.model.app.DBPApplicationController;
import org.jkiss.dbeaver.model.impl.app.DefaultSecureStorage;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.registry.BaseApplicationImpl;
import org.jkiss.dbeaver.registry.BaseWorkspaceImpl;
import org.jkiss.dbeaver.registry.updater.VersionDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.IVariableResolver;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.app.standalone.ApplicationWorkbenchAdvisor;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverCommandLine;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverSettingsImporter;
import org.jkiss.dbeaver.ui.app.standalone.DBeaverSplashHandler;
import org.jkiss.dbeaver.ui.app.standalone.rpc.DBeaverInstanceServer;
import org.jkiss.dbeaver.ui.app.standalone.rpc.IInstanceController;
import org.jkiss.dbeaver.ui.app.standalone.rpc.InstanceClient;
import org.jkiss.dbeaver.ui.app.standalone.update.VersionUpdateDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.dbeaver.utils.SystemVariablesResolver;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DBeaverApplication
extends BaseApplicationImpl
implements DBPApplicationController {
    private static final Log log;
    public static final String APPLICATION_PLUGIN_ID = "org.jkiss.dbeaver.ui.app.standalone";
    public static final String WORKSPACE_DIR_LEGACY = "${user.home}/.dbeaver";
    public static final String WORKSPACE_DIR_4 = "${user.home}/.dbeaver4";
    public static final String WORKSPACE_DIR_6;
    public static final String DBEAVER_DATA_DIR = "DBeaverData";
    public static final String WORKSPACE_DIR_CURRENT;
    public static final String[] WORKSPACE_DIR_PREVIOUS;
    static final String VERSION_PROP_PRODUCT_NAME = "product-name";
    static final String VERSION_PROP_PRODUCT_VERSION = "product-version";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    static boolean WORKSPACE_MIGRATED;
    static DBeaverApplication instance;
    boolean reuseWorkspace = false;
    private boolean primaryInstance = true;
    private boolean headlessMode = false;
    private IInstanceController instanceServer;
    private OutputStream debugWriter;
    private PrintStream oldSystemOut;
    private PrintStream oldSystemErr;
    private Display display = null;
    private boolean resetUIOnRestart;
    private boolean resetWorkspaceOnRestart;

    static {
        String workingDirectory;
        log = Log.getLog(DBeaverApplication.class);
        WORKSPACE_DIR_PREVIOUS = new String[]{WORKSPACE_DIR_4, WORKSPACE_DIR_LEGACY};
        WORKSPACE_MIGRATED = false;
        String osName = System.getProperty("os.name").toUpperCase();
        if (osName.contains("WIN")) {
            String appData = System.getenv("AppData");
            if (appData == null) {
                appData = System.getProperty("user.home");
            }
            workingDirectory = String.valueOf(appData) + "\\" + DBEAVER_DATA_DIR;
        } else if (osName.contains("MAC")) {
            workingDirectory = String.valueOf(System.getProperty("user.home")) + "/Library/" + DBEAVER_DATA_DIR;
        } else {
            String dataHome = System.getProperty("XDG_DATA_HOME");
            if (dataHome == null) {
                dataHome = String.valueOf(System.getProperty("user.home")) + "/.local/share";
            }
            String badWorkingDir = String.valueOf(dataHome) + "/." + DBEAVER_DATA_DIR;
            String goodWorkingDir = String.valueOf(dataHome) + "/" + DBEAVER_DATA_DIR;
            workingDirectory = !new File(goodWorkingDir).exists() && new File(badWorkingDir).exists() ? badWorkingDir : goodWorkingDir;
        }
        WORKSPACE_DIR_CURRENT = WORKSPACE_DIR_6 = new File(workingDirectory, "workspace6").getAbsolutePath();
    }

    public static DBeaverApplication getInstance() {
        return instance;
    }

    public Object start(IApplicationContext context) {
        String defaultHomePath;
        instance = this;
        Location instanceLoc = Platform.getInstanceLocation();
        boolean ideWorkspaceSet = this.setIDEWorkspace(instanceLoc);
        CommandLine commandLine = DBeaverCommandLine.getCommandLine();
        if (DBeaverCommandLine.handleCommandLine(commandLine, defaultHomePath = this.getDefaultInstanceLocation())) {
            System.err.println("Commands processed. Exit " + GeneralUtils.getProductName() + ".");
            return IApplication.EXIT_OK;
        }
        try {
            if (!instanceLoc.isSet() ? !this.setDefaultWorkspacePath(instanceLoc) : instanceLoc.isLocked() && !ideWorkspaceSet && !this.setDefaultWorkspacePath(instanceLoc)) {
                return IApplication.EXIT_OK;
            }
            if (!instanceLoc.isLocked()) {
                instanceLoc.lock();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.headlessMode = true;
            if (DBeaverCommandLine.handleCustomParameters(commandLine)) {
                Integer n = IApplication.EXIT_OK;
                return n;
            }
        }
        finally {
            this.headlessMode = false;
        }
        this.initDebugWriter();
        this.updateSplashHandler();
        Runtime runtime = Runtime.getRuntime();
        log.debug((Object)(String.valueOf(GeneralUtils.getProductName()) + " " + GeneralUtils.getProductVersion() + " is starting"));
        log.debug((Object)("OS: " + System.getProperty("os.name") + " " + System.getProperty("os.version") + " (" + System.getProperty("os.arch") + ")"));
        log.debug((Object)("Java version: " + System.getProperty("java.version") + " by " + System.getProperty("java.vendor") + " (" + System.getProperty("sun.arch.data.model") + "bit)"));
        log.debug((Object)("Install path: '" + SystemVariablesResolver.getInstallPath() + "'"));
        log.debug((Object)("Instance path: '" + instanceLoc.getURL() + "'"));
        log.debug((Object)("Memory available " + runtime.totalMemory() / 0x100000L + "Mb/" + runtime.maxMemory() / 0x100000L + "Mb"));
        DBeaverApplication.writeWorkspaceInfo();
        this.initializeApplication();
        this.instanceServer = DBeaverInstanceServer.startInstanceServer(commandLine, this.createInstanceController());
        PlatformUI.getPreferenceStore().setDefault("KEY_CONFIGURATION_ID", "org.jkiss.dbeaver.defaultKeyScheme");
        try {
            log.debug((Object)"Run workbench");
            this.getDisplay();
            int returnCode = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)this.createWorkbenchAdvisor());
            if (this.resetUIOnRestart || this.resetWorkspaceOnRestart) {
                this.resetUISettings(instanceLoc);
            }
            if (returnCode != 1) {
                Integer n = EXIT_OK;
                return n;
            }
            Integer n = EXIT_RELAUNCH.equals(Integer.getInteger(PROP_EXIT_CODE)) ? EXIT_RELAUNCH : EXIT_RESTART;
            return n;
        }
        catch (Throwable e) {
            log.debug((Object)"Internal error in workbench lifecycle", e);
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            this.shutdown();
            this.display.dispose();
            this.display = null;
        }
    }

    private boolean setIDEWorkspace(Location instanceLoc) {
        Object lastWorkspace;
        if (instanceLoc.isSet()) {
            return false;
        }
        ChooseWorkspaceData launchData = new ChooseWorkspaceData(instanceLoc.getDefault());
        Object[] recentWorkspaces = launchData.getRecentWorkspaces();
        if (recentWorkspaces != null && recentWorkspaces.length > 1 && !ArrayUtils.contains((Object[])recentWorkspaces, (Object)WORKSPACE_DIR_CURRENT)) {
            boolean added = false;
            int i = 0;
            while (i < recentWorkspaces.length) {
                if (recentWorkspaces[i] == null) {
                    recentWorkspaces[i] = WORKSPACE_DIR_CURRENT;
                    added = true;
                    break;
                }
                ++i;
            }
            if (!added) {
                recentWorkspaces[recentWorkspaces.length - 1] = WORKSPACE_DIR_CURRENT;
            }
            launchData.setRecentWorkspaces((String[])recentWorkspaces);
            launchData.writePersistedData();
        }
        if (!(ArrayUtils.isEmpty((Object[])recentWorkspaces) || CommonUtils.isEmpty((String)(lastWorkspace = recentWorkspaces[0])) || WORKSPACE_DIR_CURRENT.equals(lastWorkspace))) {
            try {
                URL selectedWorkspaceURL = new URL("file", null, (String)lastWorkspace);
                instanceLoc.set(selectedWorkspaceURL, true);
                return true;
            }
            catch (Exception e) {
                System.err.println("Can't set IDE workspace to '" + (String)lastWorkspace + "'");
                e.printStackTrace();
            }
        }
        return false;
    }

    private String getDefaultInstanceLocation() {
        String defaultHomePath = WORKSPACE_DIR_CURRENT;
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc.isSet()) {
            defaultHomePath = instanceLoc.getURL().getFile();
        }
        return defaultHomePath;
    }

    private void updateSplashHandler() {
        if (ArrayUtils.contains((Object[])Platform.getApplicationArgs(), (Object)"-nosplash")) {
            return;
        }
        try {
            this.getDisplay();
            Shell shell = WorkbenchPlugin.getSplashShell((Display)this.display);
            if (shell != null) {
                shell.setText(ChooseWorkspaceDialog.getWindowTitle());
                shell.setImages(Window.getDefaultImages());
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
            System.err.println("Error updating splash shell");
        }
        Log.addListener((message, t) -> DBeaverSplashHandler.showMessage(CommonUtils.toString((Object)message)));
    }

    protected IInstanceController createInstanceController() {
        return new DBeaverInstanceServer();
    }

    private void resetUISettings(Location instanceLoc) {
        try {
            File settingsFile;
            File instanceDir = new File(instanceLoc.getURL().toURI());
            if (instanceDir.exists() && (settingsFile = new File(instanceDir, ".metadata/.plugins/org.eclipse.e4.workbench/workbench.xmi")).exists()) {
                settingsFile.deleteOnExit();
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error resetting UI settings", e);
        }
    }

    private void markFoldertoDelete(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    this.markFoldertoDelete(file);
                } else {
                    log.debug((Object)("Delete resource file " + file.getAbsolutePath()));
                    file.deleteOnExit();
                }
                ++n2;
            }
        }
        folder.deleteOnExit();
    }

    protected void initializeApplication() {
    }

    private Display getDisplay() {
        if (this.display == null) {
            log.debug((Object)"Create display");
            Display.setAppName((String)GeneralUtils.getProductName());
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = PlatformUI.createDisplay();
            }
            new DelayedEventsProcessor(this.display);
        }
        return this.display;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean setDefaultWorkspacePath(Location instanceLoc) {
        String defaultHomePath = WORKSPACE_DIR_CURRENT;
        File homeDir = new File(defaultHomePath);
        try {
            if (!homeDir.exists() || ArrayUtils.isEmpty((Object[])homeDir.listFiles())) {
                DBeaverSettingsImporter importer;
                File previousVersionWorkspaceDir = null;
                String[] stringArray = WORKSPACE_DIR_PREVIOUS;
                int n = WORKSPACE_DIR_PREVIOUS.length;
                int n2 = 0;
                while (n2 < n) {
                    String oldDir = stringArray[n2];
                    File oldWorkspaceDir = new File(oldDir = GeneralUtils.replaceSystemPropertyVariables((String)oldDir));
                    if (oldWorkspaceDir.exists() && GeneralUtils.getMetadataFolder((File)oldWorkspaceDir).exists()) {
                        previousVersionWorkspaceDir = oldWorkspaceDir;
                        break;
                    }
                    ++n2;
                }
                if (previousVersionWorkspaceDir != null && !(importer = new DBeaverSettingsImporter(this, this.getDisplay())).migrateFromPreviousVersion(previousVersionWorkspaceDir, homeDir)) {
                    return false;
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)"Error migrating old workspace version", e);
        }
        try {
            URL defaultHomeURL = new URL("file", null, defaultHomePath);
            boolean keepTrying = true;
            while (keepTrying) {
                if (!instanceLoc.isLocked()) {
                    if (instanceLoc.set(defaultHomeURL, true)) return true;
                }
                if (this.reuseWorkspace) {
                    instanceLoc.set(defaultHomeURL, false);
                    keepTrying = false;
                    this.primaryInstance = false;
                    continue;
                }
                int msgResult = this.showMessageBox("DBeaver - Can't lock workspace", "Can't lock workspace at " + defaultHomePath + ".\n" + "It seems that you have another DBeaver instance running.\n" + "You may ignore it and work without lock but it is recommended to shutdown previous instance otherwise you may corrupt workspace data.", 3592);
                switch (msgResult) {
                    case 512: {
                        return false;
                    }
                    case 2048: {
                        instanceLoc.set(defaultHomeURL, false);
                        keepTrying = false;
                        this.primaryInstance = false;
                        break;
                    }
                }
            }
            return true;
        }
        catch (Throwable e) {
            System.err.println("Can't switch workspace to '" + defaultHomePath + "' - " + e.getMessage());
        }
        return true;
    }

    public static void writeWorkspaceInfo() {
        File metadataFolder = GeneralUtils.getMetadataFolder();
        Properties props = BaseWorkspaceImpl.readWorkspaceInfo((File)metadataFolder);
        props.setProperty(VERSION_PROP_PRODUCT_NAME, GeneralUtils.getProductName());
        props.setProperty(VERSION_PROP_PRODUCT_VERSION, GeneralUtils.getProductVersion().toString());
        BaseWorkspaceImpl.writeWorkspaceInfo((File)metadataFolder, (Properties)props);
    }

    @NotNull
    protected ApplicationWorkbenchAdvisor createWorkbenchAdvisor() {
        return new ApplicationWorkbenchAdvisor();
    }

    public void stop() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        Display display = workbench.getDisplay();
        display.syncExec(() -> {
            if (!display.isDisposed()) {
                workbench.close();
            }
        });
    }

    private void shutdown() {
        log.debug((Object)"DBeaver is stopping");
        try {
            try {
                this.instanceServer = null;
                RuntimeUtils.runTask(monitor -> DBeaverInstanceServer.stopInstanceServer(), (String)"Stop RMI", (long)1000L);
            }
            catch (Throwable e) {
                log.error((Object)e);
                instance = null;
                log.debug((Object)"DBeaver shutdown completed");
                this.stopDebugWriter();
            }
        }
        finally {
            instance = null;
            log.debug((Object)"DBeaver shutdown completed");
            this.stopDebugWriter();
        }
    }

    private void initDebugWriter() {
        File debugLogFile;
        DBPPreferenceStore preferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
        if (!preferenceStore.getBoolean("logs.debug.enabled")) {
            return;
        }
        String logLocation = preferenceStore.getString("logs.debug.location");
        if (CommonUtils.isEmpty((String)logLocation)) {
            logLocation = new File(GeneralUtils.getMetadataFolder(), "dbeaver-debug.log").getAbsolutePath();
        }
        if ((debugLogFile = new File(logLocation = GeneralUtils.replaceVariables((String)logLocation, (IVariableResolver)new SystemVariablesResolver()))).exists() && !debugLogFile.delete()) {
            System.err.println("Can't delete debug log file");
            return;
        }
        try {
            this.debugWriter = new FileOutputStream(debugLogFile);
            this.oldSystemOut = System.out;
            this.oldSystemErr = System.err;
            System.setOut(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemOut)));
            System.setErr(new PrintStream(new ProxyPrintStream(this.debugWriter, this.oldSystemErr)));
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
    }

    private void stopDebugWriter() {
        if (this.oldSystemOut != null) {
            System.setOut(this.oldSystemOut);
        }
        if (this.oldSystemErr != null) {
            System.setErr(this.oldSystemErr);
        }
        if (this.debugWriter != null) {
            IOUtils.close((Closeable)this.debugWriter);
            this.debugWriter = null;
        }
    }

    public IInstanceController getInstanceServer() {
        return this.instanceServer;
    }

    public IInstanceController createInstanceClient() {
        return InstanceClient.createClient(this.getDefaultInstanceLocation());
    }

    private static File getDefaultWorkspaceLocation(String path) {
        return new File(System.getProperty("user.home"), path);
    }

    public boolean isStandalone() {
        return true;
    }

    public boolean isPrimaryInstance() {
        return this.primaryInstance;
    }

    public boolean isHeadlessMode() {
        return this.headlessMode;
    }

    public void setHeadlessMode(boolean headlessMode) {
        this.headlessMode = headlessMode;
    }

    @NotNull
    public DBASecureStorage getSecureStorage() {
        return DefaultSecureStorage.INSTANCE;
    }

    public String getInfoDetails() {
        return null;
    }

    public String getDefaultProjectName() {
        return "General";
    }

    private int showMessageBox(String title, String message, int style) {
        Shell shell = new Shell(this.getDisplay(), 16384);
        shell.setText(GeneralUtils.getProductTitle());
        MessageBox messageBox = new MessageBox(shell, style);
        messageBox.setText(title);
        messageBox.setMessage(message);
        int msgResult = messageBox.open();
        shell.dispose();
        return msgResult;
    }

    public void notifyVersionUpgrade(VersionDescriptor currentVersion, VersionDescriptor newVersion, boolean showSkip) {
        VersionUpdateDialog dialog = new VersionUpdateDialog(UIUtils.getActiveWorkbenchShell(), currentVersion, newVersion, showSkip);
        dialog.open();
    }

    public void setResetUIOnRestart(boolean resetUIOnRestart) {
        this.resetUIOnRestart = resetUIOnRestart;
    }

    public void setResetWorkspaceOnRestart(boolean resetWorkspaceOnRestart) {
        this.resetWorkspaceOnRestart = resetWorkspaceOnRestart;
    }

    private class ProxyPrintStream
    extends OutputStream {
        private final OutputStream debugWriter;
        private final OutputStream stdOut;

        ProxyPrintStream(OutputStream debugWriter, OutputStream stdOut) {
            this.debugWriter = debugWriter;
            this.stdOut = stdOut;
        }

        @Override
        public void write(@NotNull byte[] b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }

        @Override
        public void write(@NotNull byte[] b, int off, int len) throws IOException {
            this.debugWriter.write(b, off, len);
            this.stdOut.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.debugWriter.write(b);
            this.stdOut.write(b);
        }

        @Override
        public void flush() throws IOException {
            this.debugWriter.flush();
            this.stdOut.flush();
        }
    }
}

