/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.sqlite.edit;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericTableColumnManager;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SQLiteTableColumnManager
extends GenericTableColumnManager
implements DBEObjectRenamer<GenericTableColumn> {
    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) throws DBException {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        GenericTableBase table = (GenericTableBase)column.getTable();
        List attributes = table.getAttributes(monitor);
        if (CommonUtils.isEmpty((Collection)attributes)) {
            throw new DBException("Table was deleted");
        }
        String tableColumns = attributes.stream().filter(x -> !x.getName().equals(column.getName()) && x.isPersisted()).map(DBUtils::getQuotedIdentifier).collect(Collectors.joining(", "));
        String tableName = DBUtils.getQuotedIdentifier((DBSObject)table);
        actions.add((DBEPersistAction)new SQLDatabasePersistActionComment(table.getDataSource(), "Drop column " + DBUtils.getQuotedIdentifier((DBSObject)column)));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create temporary table from original table", "CREATE TEMPORARY TABLE temp AS SELECT " + tableColumns + " FROM " + tableName));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop original table", "DROP TABLE " + tableName));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Create original table from temporary table", "CREATE TABLE " + tableName + " AS SELECT " + tableColumns + " FROM temp"));
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Drop temporary table", "DROP TABLE temp"));
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericTableColumn column = (GenericTableColumn)command.getObject();
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename column", "ALTER TABLE " + DBUtils.getQuotedIdentifier((DBSObject)column.getTable()) + " RENAME COLUMN " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getOldName()) + " TO " + DBUtils.getQuotedIdentifier((DBPDataSource)column.getDataSource(), (String)command.getNewName())));
    }

    public void renameObject(DBECommandContext commandContext, GenericTableColumn object, String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, newName);
    }
}

