/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.manager;

import java.util.Collection;
import java.util.Map;
import org.apache.felix.scr.impl.manager.ComponentContextImpl;
import org.apache.felix.scr.impl.manager.RefPair;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public abstract class AbstractPrototypeRefPair<S, T>
extends RefPair<S, T> {
    public AbstractPrototypeRefPair(ServiceReference<T> ref) {
        super(ref);
    }

    @Override
    public abstract T getServiceObject(ComponentContextImpl<S> var1);

    @Override
    public abstract boolean setServiceObject(ComponentContextImpl<S> var1, T var2);

    protected abstract T remove(ComponentContextImpl<S> var1);

    protected abstract Collection<Map.Entry<ComponentContextImpl<S>, T>> clearEntries();

    @Override
    public final T ungetServiceObject(ComponentContextImpl<S> key) {
        if (key == null) {
            Collection<Map.Entry<ComponentContextImpl<S>, T>> keys = this.clearEntries();
            for (Map.Entry<ComponentContextImpl<S>, T> e : keys) {
                this.doUngetService(e.getKey(), e.getValue());
            }
            return null;
        }
        T service = this.remove(key);
        if (service != null) {
            this.doUngetService(key, service);
        }
        return service;
    }

    @Override
    public final void ungetServiceObjects(BundleContext bundleContext) {
        this.ungetServiceObject(null);
    }

    public abstract String toString();

    @Override
    public final boolean getServiceObject(ComponentContextImpl<S> key, BundleContext context) {
        Object service = key.getComponentServiceObjectsHelper().getPrototypeRefInstance(this.getRef());
        if (service == null) {
            this.setFailed();
            key.getLogger().log(2, "Could not get service from serviceobjects for ref {0}", null, this.getRef());
            return false;
        }
        if (!this.setServiceObject(key, service)) {
            this.doUngetService(key, service);
        }
        return true;
    }

    private void doUngetService(ComponentContextImpl<S> key, T service) {
        try {
            key.getComponentServiceObjectsHelper().getServiceObjects(this.getRef()).ungetService(service);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

