/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectReference;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;

public abstract class JDBCStructureAssistant<CONTEXT extends JDBCExecutionContext>
implements DBSStructureAssistant<CONTEXT> {
    protected static final Log log = Log.getLog(JDBCStructureAssistant.class);

    protected abstract JDBCDataSource getDataSource();

    @Override
    public DBSObjectType[] getSupportedObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @Override
    public DBSObjectType[] getSearchObjectTypes() {
        return this.getSupportedObjectTypes();
    }

    @Override
    public DBSObjectType[] getHyperlinkObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @Override
    public DBSObjectType[] getAutoCompleteObjectTypes() {
        return new DBSObjectType[]{RelationalObjectType.TYPE_TABLE};
    }

    @Override
    @NotNull
    public List<DBSObjectReference> findObjectsByMask(@NotNull DBRProgressMonitor monitor, @NotNull CONTEXT executionContext, DBSObject parentObject, DBSObjectType[] objectTypes, String objectNameMask, boolean caseSensitive, boolean globalSearch, int maxResults) throws DBException {
        ArrayList<DBSObjectReference> references = new ArrayList<DBSObjectReference>();
        try {
            Throwable throwable = null;
            Object var11_13 = null;
            try (JDBCSession session = ((JDBCExecutionContext)executionContext).openSession(monitor, DBCExecutionPurpose.META, ModelMessages.model_jdbc_find_objects_by_name);){
                DBSObjectType[] dBSObjectTypeArray = objectTypes;
                int n = objectTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    DBSObjectType type = dBSObjectTypeArray[n2];
                    this.findObjectsByMask(executionContext, session, type, parentObject, objectNameMask, caseSensitive, globalSearch, maxResults - references.size(), references);
                    if (references.size() >= maxResults) {
                        break;
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException ex) {
            throw new DBException(ex, this.getDataSource());
        }
        return references;
    }

    protected abstract void findObjectsByMask(CONTEXT var1, JDBCSession var2, DBSObjectType var3, DBSObject var4, String var5, boolean var6, boolean var7, int var8, List<DBSObjectReference> var9) throws DBException, SQLException;
}

