/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.tools.maintenance;

import java.util.Collection;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.tools.maintenance.TableToolDialog;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.tools.IUserInterfaceTool;
import org.jkiss.utils.CommonUtils;

public class MySQLToolTruncate
implements IUserInterfaceTool {
    public void execute(IWorkbenchWindow window, IWorkbenchPart activePart, Collection<DBSObject> objects) throws DBException {
        List tables = CommonUtils.filterCollection(objects, MySQLTable.class);
        if (!tables.isEmpty()) {
            SQLDialog dialog = new SQLDialog(activePart.getSite(), tables);
            dialog.open();
        }
    }

    static class SQLDialog
    extends TableToolDialog {
        public SQLDialog(IWorkbenchPartSite partSite, Collection<MySQLTable> selectedTables) {
            super(partSite, "Truncate table(s)", selectedTables);
        }

        protected boolean needsRefreshOnFinish() {
            return true;
        }

        protected void generateObjectCommand(List<String> lines, MySQLTable object) {
            lines.add("TRUNCATE TABLE " + object.getFullyQualifiedName(DBPEvaluationContext.DDL));
        }

        protected void createControls(Composite parent) {
            this.createObjectsSelector(parent);
        }
    }
}

