/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.format.sqlworkbenchj;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.utils.CommonUtils;

public class SQLWorkbenchJManager {
    private static final Log log = Log.getLog(SQLWorkbenchJManager.class);
    private static final String MYSQL_FORMAT_TYPE = "mysql";
    private static final String POSTGRESQL_FORMAT_TYPE = "postgresql";
    private static final String ORACLE_FORMAT_TYPE = "oracle";
    private static final String DB_2_FORMAT_TYPE = "db2";
    private static SQLWorkbenchJManager instance;
    private final File workbenchPath;
    private final URLClassLoader wbClassLoader;

    public static SQLWorkbenchJManager getInstance() {
        return instance;
    }

    static void initManager(File path) throws DBException {
        if (instance == null || !SQLWorkbenchJManager.instance.workbenchPath.equals(path)) {
            SQLWorkbenchJManager.initializeManager(path);
        }
    }

    public static void initializeManager(File path) throws DBException {
        instance = new SQLWorkbenchJManager(path);
    }

    public SQLWorkbenchJManager(File wbPath) throws DBException {
        this.workbenchPath = wbPath;
        File wbJar = new File(this.workbenchPath, "sqlworkbench.jar");
        if (!wbJar.exists()) {
            throw new DBException("SQL Workbench/J jar file not found: " + wbJar.getAbsolutePath());
        }
        try {
            this.wbClassLoader = new URLClassLoader(new URL[]{wbJar.toURI().toURL()});
            Class<?> wbManagerClass = this.wbClassLoader.loadClass("workbench.WbManager");
            wbManagerClass.getMethod("initConsoleMode", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new DBException("Error initializing SQL Workbench/J manager", (Throwable)e);
        }
    }

    public String format(DBPDataSource dataSource, String source) throws DBException {
        try {
            Class<?> wbFormatterClass = this.wbClassLoader.loadClass("workbench.sql.formatter.WbSqlFormatter");
            String formatType = this.getFormatType(dataSource);
            Object wbFormatterInstance = wbFormatterClass.getConstructor(CharSequence.class, String.class).newInstance(source, formatType);
            Object formatResult = wbFormatterClass.getMethod("getFormattedSql", new Class[0]).invoke(wbFormatterInstance, new Object[0]);
            if (formatResult != null) {
                return CommonUtils.toString((Object)formatResult);
            }
            return source;
        }
        catch (Exception e) {
            throw new DBException("Error calling SQL Workbench/J formatter", (Throwable)e);
        }
    }

    private String getFormatType(DBPDataSource dataSource) {
        String defaultFormatType = MYSQL_FORMAT_TYPE;
        if (dataSource == null) {
            return defaultFormatType;
        }
        String driverClassName = dataSource.getContainer().getDriver().getDriverClassName();
        String formatType = defaultFormatType;
        if (driverClassName.contains(POSTGRESQL_FORMAT_TYPE)) {
            formatType = POSTGRESQL_FORMAT_TYPE;
        } else if (driverClassName.contains(ORACLE_FORMAT_TYPE)) {
            formatType = ORACLE_FORMAT_TYPE;
        } else if (driverClassName.contains(DB_2_FORMAT_TYPE)) {
            formatType = DB_2_FORMAT_TYPE;
        }
        return formatType;
    }
}

