/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import java.util.Collection;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.sql.dialogs.SQLScriptProgressListener;

public abstract class SQLScriptStatusDialog<T extends DBSObject>
extends BaseDialog
implements SQLScriptProgressListener<T> {
    private static final String DIALOG_ID = "SQLScriptStatusDialog";
    private Tree objectTree;
    private ProgressBar progressBar;
    private Label finishLabel;
    private Job job;
    private Collection<T> objects;
    private int processedCount;

    protected SQLScriptStatusDialog(String title, @Nullable DBPImage image) {
        super(UIUtils.getActiveWorkbenchShell(), title, image);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getDialogSettings((String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        this.objectTree = new Tree(composite, 67588);
        GridData gd = new GridData(1808);
        gd.widthHint = 500;
        gd.heightHint = 200;
        this.objectTree.setLayoutData((Object)gd);
        this.objectTree.setHeaderVisible(true);
        this.objectTree.setLinesVisible(true);
        TreeColumn nameColumn = new TreeColumn(this.objectTree, 0);
        nameColumn.setText("Object");
        this.createStatusColumns(this.objectTree);
        for (DBSObject object : this.objects) {
            TreeItem item = new TreeItem(this.objectTree, 0);
            item.setData((Object)object);
            item.setText(0, DBUtils.getObjectFullName((DBPNamedObject)object, (DBPEvaluationContext)DBPEvaluationContext.UI));
        }
        Composite progressPanel = UIUtils.createPlaceholder((Composite)composite, (int)2, (int)5);
        progressPanel.setLayoutData((Object)new GridData(768));
        this.progressBar = new ProgressBar(progressPanel, 256);
        gd = new GridData(768);
        this.progressBar.setLayoutData((Object)gd);
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(this.objects.size());
        final Button stopButton = UIUtils.createPushButton((Composite)progressPanel, null, (Image)UIUtils.getShardImage((String)"IMG_ELCL_STOP"));
        stopButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SQLScriptStatusDialog.this.job.cancel();
                stopButton.setEnabled(false);
            }
        });
        this.finishLabel = new Label(composite, 0);
        gd = new GridData(768);
        gd.exclude = true;
        this.finishLabel.setLayoutData((Object)gd);
        this.finishLabel.setText("Finished");
        UIUtils.asyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                UIUtils.packColumns((Tree)SQLScriptStatusDialog.this.objectTree, (boolean)false, null);
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
        button.setEnabled(false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 12) {
            this.okPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected TreeItem getTreeItem(T object) {
        return UIUtils.getTreeItem((Tree)this.objectTree, object);
    }

    protected void createStatusColumns(Tree objectTree) {
    }

    @Override
    public void beginScriptProcessing(Job job, Collection<T> objects) {
        this.job = job;
        this.objects = objects;
        this.open();
    }

    @Override
    public void endScriptProcessing() {
        if (this.getShell().isDisposed()) {
            return;
        }
        this.getButton(12).setEnabled(true);
        Composite progressPanel = this.progressBar.getParent();
        progressPanel.setVisible(false);
        ((GridData)progressPanel.getLayoutData()).exclude = true;
        this.finishLabel.setVisible(true);
        ((GridData)this.finishLabel.getLayoutData()).exclude = false;
        this.finishLabel.setText("Finished - " + this.processedCount + " object(s) processed");
        progressPanel.getParent().layout();
    }

    @Override
    public void beginObjectProcessing(@NotNull T object, int objectNumber) {
        this.progressBar.setSelection(objectNumber + 1);
        TreeItem item = this.getTreeItem(object);
        if (item != null) {
            this.objectTree.setSelection(item);
        }
        ++this.processedCount;
    }

    @Override
    public void endObjectProcessing(@NotNull T object, Exception error) {
        UIUtils.packColumns((Tree)this.objectTree, (boolean)false, null);
        TreeItem treeItem = this.getTreeItem(object);
        if (treeItem != null) {
            treeItem.setText(1, error == null ? "Done" : error.getMessage());
            if (error != null) {
                ColorRegistry colorRegistry = UIUtils.getActiveWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry();
                Color colorError = colorRegistry.get("org.jkiss.dbeaver.txn.color.reverted.background");
                treeItem.setForeground(1, colorError);
            }
        }
    }

    @Override
    public void processObjectResults(@NotNull T object, @Nullable DBCStatement statement, @Nullable DBCResultSet resultSet) throws DBCException {
    }
}

