/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.compare.simple;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressListener;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.runtime.properties.DataSourcePropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ILazyPropertyLoadListener;
import org.jkiss.dbeaver.runtime.properties.IPropertyFilter;
import org.jkiss.dbeaver.runtime.properties.ObjectPropertyDescriptor;
import org.jkiss.dbeaver.runtime.properties.PropertiesContributor;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.tools.compare.simple.CompareObjectsSettings;
import org.jkiss.dbeaver.tools.compare.simple.CompareReport;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportLine;
import org.jkiss.dbeaver.tools.compare.simple.CompareReportProperty;
import org.jkiss.dbeaver.tools.compare.simple.CompareUtils;

public class CompareObjectsExecutor {
    private static final Log log = Log.getLog(CompareObjectsExecutor.class);
    private final Object PROPS_LOCK = new Object();
    private CompareObjectsSettings settings;
    private final List<DBNDatabaseNode> rootNodes;
    private final Map<DBPDataSource, DataSourcePropertyFilter> dataSourceFilters = new IdentityHashMap<DBPDataSource, DataSourcePropertyFilter>();
    private final DBRProgressListener initializeFinisher;
    private final ILazyPropertyLoadListener lazyPropertyLoadListener;
    private volatile int initializedCount = 0;
    private volatile IStatus initializeError;
    private final Map<Object, Map<DBPPropertyDescriptor, Object>> propertyValues = new IdentityHashMap<Object, Map<DBPPropertyDescriptor, Object>>();
    private final List<CompareReportLine> reportLines = new ArrayList<CompareReportLine>();
    private int reportDepth = 0;
    private CompareReportLine lastLine;

    private void reportObjectsCompareBegin(List<DBNDatabaseNode> objects) {
        ++this.reportDepth;
        this.lastLine = new CompareReportLine();
        this.lastLine.depth = this.reportDepth;
        this.lastLine.structure = objects.get(0);
        this.lastLine.nodes = new DBNDatabaseNode[this.rootNodes.size()];
        int i = 0;
        while (i < this.rootNodes.size()) {
            for (DBNDatabaseNode node : objects) {
                if (node != this.rootNodes.get(i) && !node.isChildOf((DBNNode)this.rootNodes.get(i))) continue;
                this.lastLine.nodes[i] = node;
                break;
            }
            ++i;
        }
        DBNDatabaseNode[] dBNDatabaseNodeArray = this.lastLine.nodes;
        int n = this.lastLine.nodes.length;
        int n2 = 0;
        while (n2 < n) {
            DBNDatabaseNode node = dBNDatabaseNodeArray[n2];
            if (node == null) {
                this.lastLine.hasDifference = true;
                break;
            }
            ++n2;
        }
        this.reportLines.add(this.lastLine);
    }

    private void reportPropertyCompare(ObjectPropertyDescriptor property) {
        CompareReportProperty reportProperty = new CompareReportProperty(property);
        reportProperty.values = new Object[this.rootNodes.size()];
        int i = 0;
        while (i < this.lastLine.nodes.length) {
            Map<DBPPropertyDescriptor, Object> valueMap;
            DBNDatabaseNode node = this.lastLine.nodes[i];
            if (node != null && (valueMap = this.propertyValues.get(node.getObject())) != null) {
                reportProperty.values[i] = valueMap.get(property);
            }
            ++i;
        }
        if (this.lastLine.properties == null) {
            this.lastLine.properties = new ArrayList<CompareReportProperty>();
        }
        this.lastLine.properties.add(reportProperty);
        Object firstValue = reportProperty.values[0];
        int i2 = 1;
        while (i2 < this.rootNodes.size()) {
            if (!CompareUtils.equalPropertyValues(reportProperty.values[i2], firstValue)) {
                this.lastLine.hasDifference = true;
                break;
            }
            ++i2;
        }
    }

    private void reportObjectsCompareEnd() {
        --this.reportDepth;
    }

    public CompareObjectsExecutor(CompareObjectsSettings settings) {
        this.settings = settings;
        this.rootNodes = settings.getNodes();
        this.initializeFinisher = new DBRProgressListener(){

            public void onTaskFinished(IStatus status) {
                if (!status.isOK()) {
                    CompareObjectsExecutor.this.initializeError = status;
                } else {
                    CompareObjectsExecutor compareObjectsExecutor = CompareObjectsExecutor.this;
                    compareObjectsExecutor.initializedCount = compareObjectsExecutor.initializedCount + 1;
                }
            }
        };
        this.lazyPropertyLoadListener = new ILazyPropertyLoadListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handlePropertyLoad(Object object, DBPPropertyDescriptor property, Object propertyValue, boolean completed) {
                Map map = CompareObjectsExecutor.this.propertyValues;
                synchronized (map) {
                    Map objectProps = (Map)CompareObjectsExecutor.this.propertyValues.get(object);
                    if (objectProps != null) {
                        objectProps.put(property, propertyValue);
                    }
                }
            }
        };
        PropertiesContributor.getInstance().addLazyListener(this.lazyPropertyLoadListener);
    }

    public IStatus getInitializeError() {
        return this.initializeError;
    }

    public void dispose() {
        PropertiesContributor.getInstance().removeLazyListener(this.lazyPropertyLoadListener);
    }

    public CompareReport compareObjects(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        this.reportLines.clear();
        this.lastLine = null;
        this.compareNodes(monitor, nodes);
        return new CompareReport(this.rootNodes, this.reportLines);
    }

    private void compareNodes(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        this.reportObjectsCompareBegin(nodes);
        try {
            if (nodes.size() > 1) {
                if (!this.settings.isCompareOnlyStructure() && !(nodes.get(0) instanceof DBNDatabaseFolder)) {
                    this.compareProperties(monitor, nodes);
                }
                this.compareChildren(monitor, nodes);
            }
        }
        finally {
            this.reportObjectsCompareEnd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareProperties(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        this.initializedCount = 0;
        this.initializeError = null;
        this.propertyValues.clear();
        StringBuilder title = new StringBuilder();
        monitor.subTask("Initialize nodes");
        for (DBNDatabaseNode node : nodes) {
            if (title.length() > 0) {
                title.append(", ");
            }
            title.append(node.getNodeFullName());
            node.initializeNode(null, this.initializeFinisher);
            monitor.worked(1);
        }
        while (this.initializedCount != nodes.size()) {
            if (this.initializeError != null) {
                throw new DBException(this.initializeError.getMessage());
            }
            Thread.sleep(100L);
            if (!monitor.isCanceled()) continue;
            throw new InterruptedException();
        }
        monitor.subTask("Compare " + title.toString());
        boolean compareLazyProperties = false;
        DBNDatabaseNode firstNode = nodes.get(0);
        List properties = ObjectPropertyDescriptor.extractAnnotations(null, firstNode.getObject().getClass(), (IPropertyFilter)this.getDataSourceFilter(firstNode), null);
        for (ObjectPropertyDescriptor prop : properties) {
            if (!prop.isLazy()) continue;
            compareLazyProperties = true;
            break;
        }
        boolean compareScripts = compareLazyProperties && this.settings.isCompareScripts();
        compareLazyProperties = compareLazyProperties && this.settings.isCompareLazyProperties();
        for (DBNDatabaseNode node : nodes) {
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            DBSObject databaseObject = node.getObject();
            Map<DBPPropertyDescriptor, Object> nodeProperties = this.propertyValues.get(databaseObject);
            if (nodeProperties == null) {
                nodeProperties = new IdentityHashMap<DBPPropertyDescriptor, Object>();
                this.propertyValues.put(databaseObject, nodeProperties);
            }
            PropertyCollector propertySource = new PropertyCollector((Object)databaseObject, compareLazyProperties || compareScripts);
            for (ObjectPropertyDescriptor prop : properties) {
                if (prop.isLazy() ? !compareLazyProperties && (!compareScripts || !prop.getId().equals("objectDefinitionText") && !prop.getId().equals("extendedDefinitionText")) : prop.isHidden()) continue;
                Object propertyValue = propertySource.getPropertyValue(monitor, (Object)databaseObject, prop, true);
                Object object = this.PROPS_LOCK;
                synchronized (object) {
                    if (propertyValue instanceof DBPNamedObject) {
                        propertyValue = ((DBPNamedObject)propertyValue).getName();
                    }
                    nodeProperties.put((DBPPropertyDescriptor)prop, propertyValue);
                }
            }
            monitor.worked(1);
        }
        for (ObjectPropertyDescriptor prop : properties) {
            this.reportPropertyCompare(prop);
        }
    }

    private void compareChildren(DBRProgressMonitor monitor, List<DBNDatabaseNode> nodes) throws DBException, InterruptedException {
        int nodeCount = nodes.size();
        ArrayList<DBNDatabaseNode[]> allChildren = new ArrayList<DBNDatabaseNode[]>(nodeCount);
        int i = 0;
        while (i < nodeCount) {
            DBNDatabaseNode node = nodes.get(i);
            if (node.getObject() instanceof DBSObjectContainer) {
                ((DBSObjectContainer)node.getObject()).cacheStructure(monitor, 7);
            }
            try {
                DBNDatabaseNode[] children = node.getChildren(monitor);
                allChildren.add(children);
            }
            catch (Exception e) {
                log.warn((Object)"Error reading child nodes for compare", (Throwable)e);
                allChildren.add(null);
            }
            ++i;
        }
        LinkedHashSet<String> allChildNames = new LinkedHashSet<String>();
        for (DBNDatabaseNode[] childList : allChildren) {
            if (childList == null) continue;
            DBNDatabaseNode[] dBNDatabaseNodeArray = childList;
            int n = childList.length;
            int n2 = 0;
            while (n2 < n) {
                DBNDatabaseNode child = dBNDatabaseNodeArray[n2];
                DBXTreeNode meta = child.getMeta();
                if (!(meta.isVirtual() || this.settings.isSkipSystemObjects() && DBUtils.isSystemObject((Object)child.getObject()))) {
                    allChildNames.add(child.getNodeName());
                }
                ++n2;
            }
        }
        for (String childName : allChildNames) {
            int[] childIndexes = new int[nodeCount];
            int i2 = 0;
            while (i2 < nodeCount) {
                childIndexes[i2] = -1;
                DBNDatabaseNode[] childList = (DBNDatabaseNode[])allChildren.get(i2);
                if (childList != null) {
                    int k = 0;
                    while (k < childList.length) {
                        DBNDatabaseNode child = childList[k];
                        if (child.getNodeName().equals(childName)) {
                            childIndexes[i2] = k;
                            break;
                        }
                        ++k;
                    }
                }
                ++i2;
            }
            ArrayList<DBNDatabaseNode> nodesToCompare = new ArrayList<DBNDatabaseNode>(nodeCount);
            int i3 = 0;
            while (i3 < nodeCount) {
                if (childIndexes[i3] != -1) {
                    int k = 0;
                    while (k < nodeCount) {
                        if (k != i3 && childIndexes[k] != childIndexes[i3]) break;
                        ++k;
                    }
                    DBNDatabaseNode[] childList = (DBNDatabaseNode[])allChildren.get(i3);
                    if (childList != null) {
                        nodesToCompare.add(childList[childIndexes[i3]]);
                    }
                }
                ++i3;
            }
            this.compareNodes(monitor, nodesToCompare);
        }
    }

    private DataSourcePropertyFilter getDataSourceFilter(DBNDatabaseNode node) {
        DBPDataSource dataSource = node.getDataSourceContainer().getDataSource();
        if (dataSource == null) {
            return null;
        }
        DataSourcePropertyFilter filter = this.dataSourceFilters.get(dataSource);
        if (filter == null) {
            filter = new DataSourcePropertyFilter(dataSource);
            this.dataSourceFilters.put(dataSource, filter);
        }
        return filter;
    }
}

