/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.views;

import java.util.Map;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class DB2ConnectionTracePage
extends ConnectionPageAbstract {
    private Button enableTraceCheck;
    private Text fileNameText;
    private Text folderText;
    private Button traceAppendCheck;
    private LevelConfig[] levels;
    private ControlEnableState traceEnableState;
    private Composite traceGroup;

    public DB2ConnectionTracePage() {
        this.setTitle(DB2Messages.db2_connection_trace_page_tab_trace_settings);
        this.setDescription(DB2Messages.db2_connection_trace_page_tab_description_trace_settings);
        this.levels = new LevelConfig[]{new LevelConfig(1, DB2Messages.db2_connection_trace_page_checkbox_connection_calls), new LevelConfig(2, DB2Messages.db2_connection_trace_page_checkbox_statement_calls), new LevelConfig(4, DB2Messages.db2_connection_trace_page_checkbox_result_set_calls), new LevelConfig(16, DB2Messages.db2_connection_trace_page_checkbox_driver_configuration), new LevelConfig(32, DB2Messages.db2_connection_trace_page_checkbox_connect), new LevelConfig(64, DB2Messages.db2_connection_trace_page_checkbox_drda_flows), new LevelConfig(128, DB2Messages.db2_connection_trace_page_checkbox_result_set_metadata), new LevelConfig(256, DB2Messages.db2_connection_trace_page_checkbox_parameter_metadata), new LevelConfig(512, DB2Messages.db2_connection_trace_page_checkbox_diagnostics), new LevelConfig(1024, DB2Messages.db2_connection_trace_page_checkbox_sql_j), new LevelConfig(2048, DB2Messages.db2_connection_trace_page_checkbox_xa_calls)};
    }

    public void dispose() {
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite cfgGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        cfgGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        cfgGroup.setLayoutData((Object)gd);
        this.enableTraceCheck = UIUtils.createCheckbox((Composite)cfgGroup, (String)DB2Messages.db2_connection_trace_page_checkbox_enable_trace, (boolean)false);
        this.traceGroup = new Composite(cfgGroup, 0);
        this.traceGroup.setLayout((Layout)new GridLayout(2, false));
        this.traceGroup.setLayoutData((Object)new GridData(768));
        this.folderText = DialogUtils.createOutputFolderChooser((Composite)this.traceGroup, (String)DB2Messages.db2_connection_trace_page_label_folder, null);
        this.fileNameText = UIUtils.createLabelText((Composite)this.traceGroup, (String)DB2Messages.db2_connection_trace_page_label_file_name, (String)DB2Messages.db2_connection_trace_page_string_trace);
        this.traceAppendCheck = UIUtils.createLabelCheckbox((Composite)this.traceGroup, (String)DB2Messages.db2_connection_trace_page_checkbox_append, (boolean)false);
        Group levelsGroup = UIUtils.createControlGroup((Composite)this.traceGroup, (String)DB2Messages.db2_connection_trace_page_header_levels, (int)2, (int)0, (int)0);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        levelsGroup.setLayoutData((Object)gd);
        LevelConfig[] levelConfigArray = this.levels;
        int n = this.levels.length;
        int n2 = 0;
        while (n2 < n) {
            LevelConfig level = levelConfigArray[n2];
            level.checkbox = UIUtils.createCheckbox((Composite)levelsGroup, (String)level.label, (boolean)false);
            ++n2;
        }
        this.enableTraceCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DB2ConnectionTracePage.this.traceEnableState == null) {
                    DB2ConnectionTracePage.this.traceEnableState = ControlEnableState.disable((Control)DB2ConnectionTracePage.this.traceGroup);
                } else {
                    DB2ConnectionTracePage.this.traceEnableState.restore();
                    DB2ConnectionTracePage.this.traceEnableState = null;
                }
            }
        });
        this.setControl((Control)cfgGroup);
        this.loadSettings();
    }

    public boolean isComplete() {
        return true;
    }

    public void loadSettings() {
        DBPConnectionConfiguration connectionInfo = this.site.getActiveDataSource().getConnectionConfiguration();
        Map providerProperties = connectionInfo.getProviderProperties();
        this.enableTraceCheck.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-trace.enabled")), (boolean)false));
        if (!this.enableTraceCheck.getSelection() && this.traceEnableState == null) {
            this.traceEnableState = ControlEnableState.disable((Control)this.traceGroup);
        }
        if (providerProperties.containsKey("@dbeaver-trace.folder")) {
            this.folderText.setText(CommonUtils.toString(providerProperties.get("@dbeaver-trace.folder")));
        }
        if (providerProperties.containsKey("@dbeaver-trace.file")) {
            this.fileNameText.setText(CommonUtils.toString(providerProperties.get("@dbeaver-trace.file")));
        }
        this.traceAppendCheck.setSelection(CommonUtils.getBoolean((String)((String)providerProperties.get("@dbeaver-trace.append")), (boolean)false));
        int traceLevel = CommonUtils.toInt(providerProperties.get("@dbeaver-trace.level"));
        LevelConfig[] levelConfigArray = this.levels;
        int n = this.levels.length;
        int n2 = 0;
        while (n2 < n) {
            LevelConfig level = levelConfigArray[n2];
            level.checkbox.setSelection((traceLevel & level.level) != 0);
            ++n2;
        }
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        Map providerProperties = dataSource.getConnectionConfiguration().getProviderProperties();
        providerProperties.put("@dbeaver-trace.enabled", String.valueOf(this.enableTraceCheck.getSelection()));
        providerProperties.put("@dbeaver-trace.folder", this.folderText.getText());
        providerProperties.put("@dbeaver-trace.file", this.fileNameText.getText());
        providerProperties.put("@dbeaver-trace.append", String.valueOf(this.traceAppendCheck.getSelection()));
        int traceLevel = 0;
        LevelConfig[] levelConfigArray = this.levels;
        int n = this.levels.length;
        int n2 = 0;
        while (n2 < n) {
            LevelConfig level = levelConfigArray[n2];
            if (level.checkbox.getSelection()) {
                traceLevel |= level.level;
            }
            ++n2;
        }
        providerProperties.put("@dbeaver-trace.level", String.valueOf(traceLevel));
        this.saveConnectionURL(dataSource.getConnectionConfiguration());
    }

    private static class LevelConfig {
        final int level;
        final String label;
        Button checkbox;

        private LevelConfig(int level, String label) {
            this.level = level;
            this.label = label;
        }
    }
}

