/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.exec;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.DBSQLException;
import org.jkiss.utils.CommonUtils;

public class JDBCStatementImpl<STATEMENT extends Statement>
extends AbstractStatement<JDBCSession>
implements JDBCStatement {
    private static final Log log = Log.getLog(JDBCStatementImpl.class);
    protected final STATEMENT original;
    protected String query;
    protected boolean disableLogging;
    private long rsOffset = -1L;
    private long rsMaxRows = -1L;
    private DBCExecutionSource source;
    private int updateCount;
    private Throwable executeError;

    public JDBCStatementImpl(@NotNull JDBCSession connection, @NotNull STATEMENT original, boolean disableLogging) {
        super(connection);
        this.original = original;
        this.disableLogging = disableLogging;
        if (this.isQMLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen(this);
        }
    }

    protected STATEMENT getOriginal() {
        return this.original;
    }

    protected boolean isQMLoggingEnabled() {
        return !this.disableLogging;
    }

    protected void startBlock() {
        ((JDBCSession)this.connection).getProgressMonitor().startBlock(this, null);
    }

    protected void endBlock() {
        ((JDBCSession)this.connection).getProgressMonitor().endBlock();
    }

    @Override
    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        this.getConnection().getDataSource().cancelStatementExecute(monitor, this);
    }

    @Override
    @NotNull
    public JDBCSession getConnection() {
        return (JDBCSession)this.connection;
    }

    @Override
    @Nullable
    public String getQueryString() {
        return this.query;
    }

    @Override
    public void setQueryString(@Nullable String query) {
        this.query = query;
    }

    @Override
    public boolean executeStatement() throws DBCException {
        try {
            return this.execute(this.query);
        }
        catch (SQLException e) {
            throw new DBSQLException(this.query, (Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public void addToBatch() throws DBCException {
        try {
            this.addBatch(this.query);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public int[] executeStatementBatch() throws DBCException {
        try {
            return this.executeBatch();
        }
        catch (SQLException e) {
            throw new DBSQLException(this.query, (Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    @Nullable
    public JDBCResultSet openResultSet() throws DBCException {
        this.startBlock();
        try {
            JDBCResultSet jDBCResultSet = this.getResultSet();
            return jDBCResultSet;
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
        finally {
            this.endBlock();
        }
    }

    @Override
    @Nullable
    public JDBCResultSet openGeneratedKeysResultSet() throws DBCException {
        try {
            return this.makeResultSet(this.getOriginal().getGeneratedKeys());
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public int getUpdateRowCount() throws DBCException {
        try {
            return this.getUpdateCount();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public boolean nextResults() throws DBCException {
        try {
            return this.getOriginal().getMoreResults();
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public void setLimit(long offset, long limit) throws DBCException {
        int totalRows;
        if (offset <= 0L) {
            totalRows = (int)limit;
            this.rsMaxRows = limit;
        } else {
            this.rsOffset = offset;
            this.rsMaxRows = limit;
            int n = totalRows = limit > 0L ? (int)(offset + limit) : -1;
        }
        if (totalRows > 0 && ((JDBCSession)this.connection).getDataSource().getInfo().supportsResultSetLimit()) {
            try {
                this.setMaxRows(totalRows);
            }
            catch (SQLException e) {
                log.debug(String.valueOf(this.getOriginal().getClass().getName()) + ".setMaxRows not supported?", e);
            }
        }
    }

    @Override
    @Nullable
    public DBCExecutionSource getStatementSource() {
        return this.source;
    }

    @Override
    public void setStatementSource(DBCExecutionSource source) {
        this.source = source;
    }

    @Nullable
    protected JDBCResultSet makeResultSet(@Nullable ResultSet resultSet) throws SQLException {
        if (resultSet == null) {
            return null;
        }
        JDBCResultSet dbResult = this.createResultSetImpl(resultSet);
        if (this.rsOffset > 0L) {
            JDBCUtils.scrollResultSet(resultSet, this.rsOffset, !this.getConnection().getDataSource().getInfo().supportsResultSetScroll());
        }
        if (this.rsMaxRows > 0L && ((JDBCSession)this.connection).getDataSource().getInfo().supportsResultSetLimit()) {
            dbResult.setMaxRows(this.rsMaxRows);
        }
        return dbResult;
    }

    protected JDBCResultSet createResultSetImpl(ResultSet resultSet) throws SQLException {
        return ((JDBCSession)this.connection).getDataSource().getJdbcFactory().createResultSet((JDBCSession)this.connection, this, resultSet, null, this.disableLogging);
    }

    protected boolean handleExecuteResult(boolean result) {
        return result;
    }

    protected int handleExecuteResult(int result) {
        this.updateCount = result;
        return result;
    }

    protected SQLException handleExecuteError(Throwable ex) {
        this.executeError = ex;
        if (((JDBCSession)this.connection).getDataSource().getContainer().getPreferenceStore().getBoolean("query.rollback-on-error")) {
            try {
                if (!((JDBCSession)this.connection).isClosed() && !((JDBCSession)this.connection).getAutoCommit()) {
                    ((JDBCSession)this.connection).rollback();
                }
            }
            catch (SQLException e) {
                log.error("Can't rollback connection after error (" + ex.getMessage() + ")", e);
            }
        }
        if (ex instanceof SQLException) {
            return (SQLException)ex;
        }
        return new SQLException(ModelMessages.model_jdbc_exception_internal_jdbc_driver_error, ex);
    }

    protected void beforeExecute() {
        this.updateCount = -1;
        this.executeError = null;
        if (this.isQMLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin(this);
        }
        this.startBlock();
    }

    protected void afterExecute() {
        this.endBlock();
        if (this.isQMLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteEnd(this, this.updateCount, this.executeError);
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            boolean bl = this.handleExecuteResult(this.getOriginal().execute(sql));
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    @Nullable
    public JDBCResultSet executeQuery(String sql) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            JDBCResultSet jDBCResultSet = this.makeResultSet(this.getOriginal().executeQuery(sql));
            return jDBCResultSet;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            int n = this.handleExecuteResult(this.getOriginal().executeUpdate(sql));
            return n;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.beforeExecute();
        try {
            int[] nArray = this.getOriginal().executeBatch();
            return nArray;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            int n = this.handleExecuteResult(this.getOriginal().executeUpdate(sql, autoGeneratedKeys));
            return n;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            int n = this.handleExecuteResult(this.getOriginal().executeUpdate(sql, columnIndexes));
            return n;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            int n = this.handleExecuteResult(this.getOriginal().executeUpdate(sql, columnNames));
            return n;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            boolean bl = this.handleExecuteResult(this.getOriginal().execute(sql, autoGeneratedKeys));
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            boolean bl = this.handleExecuteResult(this.getOriginal().execute(sql, columnIndexes));
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.setQueryString(sql);
        this.beforeExecute();
        try {
            boolean bl = this.handleExecuteResult(this.getOriginal().execute(sql, columnNames));
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }

    @Override
    public void close() {
        if (this.isQMLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementClose(this, this.updateCount);
        }
        try {
            this.getOriginal().close();
        }
        catch (Throwable e) {
            log.error("Can't close statement", e);
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.getOriginal().getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.getOriginal().setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.getOriginal().getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.getOriginal().setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.getOriginal().setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.getOriginal().getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.getOriginal().setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.getOriginal().cancel();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.getOriginal().getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.getOriginal().clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.getOriginal().setCursorName(name);
    }

    @Override
    @Nullable
    public JDBCResultSet getResultSet() throws SQLException {
        return this.makeResultSet(this.getOriginal().getResultSet());
    }

    @Override
    @Nullable
    public Throwable[] getStatementWarnings() throws DBCException {
        try {
            ArrayList<SQLWarning> warnings = null;
            SQLWarning warning = this.getWarnings();
            while (warning != null) {
                if (warning.getMessage() != null || warning.getErrorCode() != 0) {
                    if (warnings == null) {
                        warnings = new ArrayList<SQLWarning>();
                    }
                    if (warnings.contains(warning)) break;
                    warnings.add(warning);
                }
                warning = warning.getNextWarning();
            }
            if (!CommonUtils.isEmpty(warnings)) {
                try {
                    this.clearWarnings();
                }
                catch (Throwable e) {
                    log.debug("Internal error during clearWarnings", e);
                }
            }
            return warnings == null ? null : warnings.toArray(new Throwable[0]);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public void setStatementTimeout(int timeout) throws DBCException {
        try {
            this.getOriginal().setQueryTimeout(timeout);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public void setResultsFetchSize(int fetchSize) throws DBCException {
        try {
            this.getOriginal().setFetchSize(fetchSize);
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, ((JDBCSession)this.connection).getExecutionContext());
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        int uc = this.getOriginal().getUpdateCount();
        if (uc >= 0) {
            this.updateCount = uc;
        }
        return uc;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getOriginal().getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.getOriginal().setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.getOriginal().getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.getOriginal().setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.getOriginal().getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.getOriginal().getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.getOriginal().getResultSetType();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.getOriginal().addBatch(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.getOriginal().clearBatch();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.getOriginal().getMoreResults(current);
    }

    @Override
    @Nullable
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.makeResultSet(this.getOriginal().getGeneratedKeys());
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.getOriginal().getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.getOriginal().isClosed();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.getOriginal().setPoolable(poolable);
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.getOriginal().isPoolable();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.getOriginal().closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.getOriginal().isCloseOnCompletion();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.getOriginal().unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getOriginal().isWrapperFor(iface);
    }

    public String toString() {
        return "JDBC Statement [" + this.query + "]";
    }
}

