/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections;

import java.util.Objects;
import org.freedesktop.dbus.connections.AbstractConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.FatalException;
import org.freedesktop.dbus.messages.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class IncomingMessageThread
extends Thread {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private volatile boolean terminate;
    private final AbstractConnection connection;

    public IncomingMessageThread(AbstractConnection _connection) {
        Objects.requireNonNull(_connection);
        this.connection = _connection;
        this.setName("DBusConnection");
        this.setDaemon(true);
    }

    public void terminate() {
        this.terminate = true;
        this.interrupt();
    }

    @Override
    public void run() {
        Message msg = null;
        while (!this.terminate) {
            msg = null;
            try {
                msg = this.connection.readIncoming();
                if (msg == null) continue;
                this.logger.trace("Got Incoming Message: {}", (Object)msg);
                this.connection.handleMessage(msg);
                msg = null;
            }
            catch (DBusException _ex) {
                if (_ex instanceof FatalException) {
                    this.logger.error("FatalException in connection thread.", (Throwable)_ex);
                    if (this.connection.isConnected()) {
                        this.terminate();
                        this.connection.disconnect();
                    }
                    return;
                }
                if (this.terminate) continue;
                this.logger.error("Exception in connection thread.", (Throwable)_ex);
            }
        }
    }
}

