/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.v2;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.SecureRandom;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeader;
import org.cryptomator.cryptolib.common.CipherSupplier;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.v2.FileHeaderImpl;

class FileContentCryptorImpl
implements FileContentCryptor {
    private final SecureRandom random;

    FileContentCryptorImpl(SecureRandom random) {
        this.random = random;
    }

    @Override
    public boolean canSkipAuthentication() {
        return false;
    }

    @Override
    public int cleartextChunkSize() {
        return 32768;
    }

    @Override
    public int ciphertextChunkSize() {
        return 32796;
    }

    @Override
    public ByteBuffer encryptChunk(ByteBuffer cleartextChunk, long chunkNumber, FileHeader header) {
        ByteBuffer ciphertextChunk = ByteBuffer.allocate(32796);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, header);
        ciphertextChunk.flip();
        return ciphertextChunk;
    }

    @Override
    public void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header) {
        if (cleartextChunk.remaining() <= 0 || cleartextChunk.remaining() > 32768) {
            throw new IllegalArgumentException("Invalid cleartext chunk size: " + cleartextChunk.remaining() + ", expected range [1, " + 32768 + "]");
        }
        if (ciphertextChunk.remaining() < 32796) {
            throw new IllegalArgumentException("Invalid cipehrtext chunk size: " + ciphertextChunk.remaining() + ", must fit up to " + 32796 + " bytes.");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        this.encryptChunk(cleartextChunk, ciphertextChunk, chunkNumber, headerImpl.getNonce(), headerImpl.getPayload().getContentKey());
    }

    @Override
    public ByteBuffer decryptChunk(ByteBuffer ciphertextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        ByteBuffer cleartextChunk = ByteBuffer.allocate(32768);
        this.decryptChunk(ciphertextChunk, cleartextChunk, chunkNumber, header, authenticate);
        cleartextChunk.flip();
        return cleartextChunk;
    }

    @Override
    public void decryptChunk(ByteBuffer ciphertextChunk, ByteBuffer cleartextChunk, long chunkNumber, FileHeader header, boolean authenticate) throws AuthenticationFailedException {
        if (ciphertextChunk.remaining() < 28 || ciphertextChunk.remaining() > 32796) {
            throw new IllegalArgumentException("Invalid ciphertext chunk size: " + ciphertextChunk.remaining() + ", expected range [" + 28 + ", " + 32796 + "]");
        }
        if (cleartextChunk.remaining() < 32768) {
            throw new IllegalArgumentException("Invalid cleartext chunk size: " + cleartextChunk.remaining() + ", must fit up to " + 32768 + " bytes.");
        }
        if (!authenticate) {
            throw new UnsupportedOperationException("authenticate can not be false");
        }
        FileHeaderImpl headerImpl = FileHeaderImpl.cast(header);
        this.decryptChunk(ciphertextChunk, cleartextChunk, chunkNumber, headerImpl.getNonce(), headerImpl.getPayload().getContentKey());
    }

    void encryptChunk(ByteBuffer cleartextChunk, ByteBuffer ciphertextChunk, long chunkNumber, byte[] headerNonce, DestroyableSecretKey fileKey) {
        try (DestroyableSecretKey fk = fileKey.copy();){
            byte[] nonce = new byte[12];
            this.random.nextBytes(nonce);
            Cipher cipher = CipherSupplier.AES_GCM.forEncryption(fk, new GCMParameterSpec(128, nonce));
            byte[] chunkNumberBigEndian = this.longToBigEndianByteArray(chunkNumber);
            cipher.updateAAD(chunkNumberBigEndian);
            cipher.updateAAD(headerNonce);
            ciphertextChunk.put(nonce);
            assert (ciphertextChunk.remaining() >= cipher.getOutputSize(cleartextChunk.remaining()));
            cipher.doFinal(cleartextChunk, ciphertextChunk);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception during GCM encryption.", e);
        }
    }

    void decryptChunk(ByteBuffer ciphertextChunk, ByteBuffer cleartextChunk, long chunkNumber, byte[] headerNonce, DestroyableSecretKey fileKey) throws AuthenticationFailedException {
        assert (ciphertextChunk.remaining() >= 28);
        try (DestroyableSecretKey fk = fileKey.copy();){
            byte[] nonce = new byte[12];
            ByteBuffer chunkNonceBuf = ciphertextChunk.asReadOnlyBuffer();
            chunkNonceBuf.position(0).limit(12);
            chunkNonceBuf.get(nonce);
            ByteBuffer payloadBuf = ciphertextChunk.asReadOnlyBuffer();
            payloadBuf.position(12);
            assert (payloadBuf.remaining() >= 16);
            Cipher cipher = CipherSupplier.AES_GCM.forDecryption(fk, new GCMParameterSpec(128, nonce));
            byte[] chunkNumberBigEndian = this.longToBigEndianByteArray(chunkNumber);
            cipher.updateAAD(chunkNumberBigEndian);
            cipher.updateAAD(headerNonce);
            assert (cleartextChunk.remaining() >= cipher.getOutputSize(payloadBuf.remaining()));
            cipher.doFinal(payloadBuf, cleartextChunk);
        }
        catch (AEADBadTagException e) {
            throw new AuthenticationFailedException("Content tag mismatch.", e);
        }
        catch (ShortBufferException e) {
            throw new IllegalStateException("Buffer allocated for reported output size apparently not big enough.", e);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new IllegalStateException("Unexpected exception during GCM decryption.", e);
        }
    }

    private byte[] longToBigEndianByteArray(long n) {
        return ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(n).array();
    }
}

