/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v7;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Optional;
import java.util.regex.Pattern;
import org.cryptomator.cryptofs.migration.v7.FilePathMigration;
import org.cryptomator.cryptofs.migration.v7.InvalidOldFilenameException;
import org.cryptomator.cryptofs.migration.v7.UninflatableFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreMigrationVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger LOG = LoggerFactory.getLogger(PreMigrationVisitor.class);
    private static final Pattern[] BLACKLISTED_NAMES = new Pattern[]{Pattern.compile(".*\\.icloud$")};
    private final Path vaultRoot;
    private final boolean determineMaxCiphertextPathLength;
    private long fileCount = 0L;
    private long maxNameLength = 0L;
    private long maxPathLength = 0L;
    private Path pathWithLongestName = null;
    private Path longestPath = null;

    public PreMigrationVisitor(Path vaultRoot, boolean determineMaxCiphertextPathLength) {
        this.vaultRoot = vaultRoot;
        this.determineMaxCiphertextPathLength = determineMaxCiphertextPathLength;
    }

    public long getTotalFileCount() {
        return this.fileCount;
    }

    public long getMaxCiphertextNameLength() {
        if (this.determineMaxCiphertextPathLength) {
            return this.maxNameLength;
        }
        return 220L;
    }

    public long getMaxCiphertextPathLength() {
        if (this.determineMaxCiphertextPathLength) {
            return this.maxPathLength;
        }
        return 268L;
    }

    public Path getPathWithLongestName() {
        return this.pathWithLongestName;
    }

    public Path getLongestPath() {
        return this.longestPath;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        this.assertNotBlacklisted(file.getFileName().toString());
        ++this.fileCount;
        if (this.determineMaxCiphertextPathLength) {
            try {
                Optional<FilePathMigration> migration = FilePathMigration.parse(this.vaultRoot, file);
                migration.ifPresent(this::updateMaxCiphertextPathLength);
            }
            catch (UninflatableFileException e) {
                LOG.warn("SKIP {} because inflation failed.", (Object)file);
                return FileVisitResult.CONTINUE;
            }
        }
        return FileVisitResult.CONTINUE;
    }

    private void updateMaxCiphertextPathLength(FilePathMigration filePathMigration) {
        try {
            String name;
            int nameLen;
            Path newPath = filePathMigration.getTargetPath("");
            Path relativeToVaultRoot = this.vaultRoot.relativize(newPath);
            int pathLen = relativeToVaultRoot.toString().length();
            if ((long)pathLen > this.maxPathLength) {
                this.maxPathLength = pathLen;
                this.longestPath = newPath;
            }
            if ((long)(nameLen = (name = relativeToVaultRoot.getName(3).toString()).length()) > this.maxNameLength) {
                this.maxNameLength = nameLen;
                this.pathWithLongestName = newPath;
            }
        }
        catch (InvalidOldFilenameException e) {
            LOG.warn("Encountered malformed filename.", (Throwable)e);
        }
    }

    private void assertNotBlacklisted(String filename) throws PreMigrationChecksFailedException {
        for (Pattern p : BLACKLISTED_NAMES) {
            if (!p.matcher(filename).matches()) continue;
            throw new PreMigrationChecksFailedException(filename);
        }
    }

    public static class PreMigrationChecksFailedException
    extends IOException {
        PreMigrationChecksFailedException(String filename) {
            super("Migration impossible due to file: " + filename);
        }
    }
}

