/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs;

import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import org.cryptomator.cryptofs.LongFileNameProvider;

public class CiphertextFilePath {
    private final Path path;
    private final Optional<LongFileNameProvider.DeflatedFileName> deflatedFileName;

    CiphertextFilePath(Path path, Optional<LongFileNameProvider.DeflatedFileName> deflatedFileName) {
        this.path = Objects.requireNonNull(path);
        this.deflatedFileName = Objects.requireNonNull(deflatedFileName);
    }

    public Path getRawPath() {
        return this.path;
    }

    public boolean isShortened() {
        return this.deflatedFileName.isPresent();
    }

    public Path getFilePath() {
        return this.isShortened() ? this.path.resolve("contents.c9r") : this.path;
    }

    public Path getDirFilePath() {
        return this.path.resolve("dir.c9r");
    }

    public Path getSymlinkFilePath() {
        return this.path.resolve("symlink.c9r");
    }

    public Path getInflatedNamePath() {
        return this.path.resolve("name.c9s");
    }

    public int hashCode() {
        return Objects.hash(this.path, this.deflatedFileName);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CiphertextFilePath) {
            CiphertextFilePath other = (CiphertextFilePath)obj;
            return this.path.equals(other.path) && this.deflatedFileName.equals(other.deflatedFileName);
        }
        return false;
    }

    public String toString() {
        return this.path.toString();
    }

    public void persistLongFileName() {
        this.deflatedFileName.ifPresent(LongFileNameProvider.DeflatedFileName::persist);
    }
}

