/*
 * Decompiled with CFR 0.152.
 */
package com.dokany.java.structure;

public final class FreeSpace {
    private final long totalBytes;
    private final long totalUsed;

    public long getFreeBytes() {
        return this.totalBytes - this.totalUsed;
    }

    public FreeSpace(long totalBytes, long totalUsed) {
        this.totalBytes = totalBytes;
        this.totalUsed = totalUsed;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getTotalUsed() {
        return this.totalUsed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FreeSpace)) {
            return false;
        }
        FreeSpace other = (FreeSpace)o;
        if (this.getTotalBytes() != other.getTotalBytes()) {
            return false;
        }
        return this.getTotalUsed() == other.getTotalUsed();
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalBytes = this.getTotalBytes();
        result = result * 59 + (int)($totalBytes >>> 32 ^ $totalBytes);
        long $totalUsed = this.getTotalUsed();
        result = result * 59 + (int)($totalUsed >>> 32 ^ $totalUsed);
        return result;
    }

    public String toString() {
        return "FreeSpace(totalBytes=" + this.getTotalBytes() + ", totalUsed=" + this.getTotalUsed() + ")";
    }
}

