/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javafx.concurrent.Task;
import javax.inject.Inject;
import org.cryptomator.common.vaults.LockNotCompletedException;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultState;
import org.cryptomator.common.vaults.Volume;
import org.cryptomator.ui.common.HostServiceRevealer;
import org.cryptomator.ui.fxapp.FxApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FxApplicationScoped
public class VaultService {
    private static final Logger LOG = LoggerFactory.getLogger(VaultService.class);
    private final ExecutorService executorService;
    private final HostServiceRevealer vaultRevealer;

    @Inject
    public VaultService(ExecutorService executorService, HostServiceRevealer vaultRevealer) {
        this.executorService = executorService;
        this.vaultRevealer = vaultRevealer;
    }

    public void reveal(Vault vault) {
        this.executorService.execute((Runnable)this.createRevealTask(vault));
    }

    public Task<Vault> createRevealTask(Vault vault) {
        RevealVaultTask task = new RevealVaultTask(vault, this.vaultRevealer);
        task.setOnSucceeded(evt -> LOG.info("Revealed {}", (Object)vault.getDisplayName()));
        task.setOnFailed(evt -> LOG.error("Failed to reveal " + vault.getDisplayName(), evt.getSource().getException()));
        return task;
    }

    public void lock(Vault vault, boolean forced) {
        this.executorService.execute((Runnable)this.createLockTask(vault, forced));
    }

    public Task<Vault> createLockTask(Vault vault, boolean forced) {
        LockVaultTask task = new LockVaultTask(vault, forced);
        task.setOnSucceeded(evt -> LOG.info("Locked {}", (Object)vault.getDisplayName()));
        task.setOnFailed(evt -> LOG.info("Failed to lock {}.", (Object)vault.getDisplayName(), (Object)evt.getSource().getException()));
        return task;
    }

    public void lockAll(Collection<Vault> vaults, boolean forced) {
        this.executorService.execute((Runnable)this.createLockAllTask(vaults, forced));
    }

    public Task<Collection<Vault>> createLockAllTask(Collection<Vault> vaults, boolean forced) {
        List<Task<Vault>> lockTasks = vaults.stream().map(v -> new LockVaultTask((Vault)v, forced)).collect(Collectors.toUnmodifiableList());
        lockTasks.forEach(this.executorService::execute);
        WaitForTasksTask task = new WaitForTasksTask(lockTasks);
        String vaultNames = vaults.stream().map(Vault::getDisplayName).collect(Collectors.joining(", "));
        task.setOnSucceeded(evt -> LOG.info("Locked {}", (Object)vaultNames));
        task.setOnFailed(evt -> LOG.error("Failed to lock vaults " + vaultNames, evt.getSource().getException()));
        return task;
    }

    private static class RevealVaultTask
    extends Task<Vault> {
        private final Vault vault;
        private final Volume.Revealer revealer;

        public RevealVaultTask(Vault vault, Volume.Revealer revealer) {
            this.vault = vault;
            this.revealer = revealer;
            this.setOnFailed(evt -> LOG.error("Failed to reveal " + vault.getDisplayName(), this.getException()));
        }

        protected Vault call() throws Volume.VolumeException {
            this.vault.reveal(this.revealer);
            return this.vault;
        }
    }

    private static class LockVaultTask
    extends Task<Vault> {
        private final Vault vault;
        private final boolean forced;

        public LockVaultTask(Vault vault, boolean forced) {
            this.vault = vault;
            this.forced = forced;
            this.setOnFailed(event -> LOG.error("Failed to lock " + vault.getDisplayName(), event.getSource().getException()));
        }

        protected Vault call() throws Volume.VolumeException, LockNotCompletedException {
            this.vault.lock(this.forced);
            return this.vault;
        }

        protected void scheduled() {
            this.vault.stateProperty().transition(VaultState.Value.UNLOCKED, VaultState.Value.PROCESSING);
        }

        protected void succeeded() {
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.LOCKED);
        }

        protected void failed() {
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
        }

        protected void cancelled() {
            this.vault.stateProperty().transition(VaultState.Value.PROCESSING, VaultState.Value.UNLOCKED);
        }
    }

    private static class WaitForTasksTask
    extends Task<Collection<Vault>> {
        private final Collection<Task<Vault>> startedTasks;

        public WaitForTasksTask(Collection<Task<Vault>> tasks) {
            this.startedTasks = List.copyOf(tasks);
            this.setOnFailed(event -> LOG.error("Failed to lock multiple vaults", this.getException()));
        }

        protected Collection<Vault> call() throws ExecutionException, InterruptedException {
            Iterator<Task<Vault>> remainingTasks = this.startedTasks.iterator();
            ArrayList<Vault> completed = new ArrayList<Vault>();
            try {
                while (remainingTasks.hasNext()) {
                    Vault done = (Vault)remainingTasks.next().get();
                    completed.add(done);
                }
            }
            catch (ExecutionException e) {
                while (remainingTasks.hasNext()) {
                    remainingTasks.next().cancel(true);
                }
                throw e;
            }
            return completed;
        }
    }
}

