/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.vaultoptions;

import javafx.beans.property.ObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javax.inject.Inject;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.vaultoptions.SelectedVaultOptionsTab;
import org.cryptomator.ui.vaultoptions.VaultOptionsScoped;
import org.cryptomator.ui.vaultoptions.VaultOptionsWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VaultOptionsScoped
public class VaultOptionsController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(VaultOptionsController.class);
    private final Stage window;
    private final ObjectProperty<SelectedVaultOptionsTab> selectedTabProperty;
    public TabPane tabPane;
    public Tab generalTab;
    public Tab mountTab;
    public Tab keyTab;

    @Inject
    VaultOptionsController(@VaultOptionsWindow Stage window, ObjectProperty<SelectedVaultOptionsTab> selectedTabProperty) {
        this.window = window;
        this.selectedTabProperty = selectedTabProperty;
    }

    @FXML
    public void initialize() {
        this.window.setOnShowing(this::windowWillAppear);
        this.selectedTabProperty.addListener(observable -> this.selectChosenTab());
        this.tabPane.getSelectionModel().selectedItemProperty().addListener(observable -> this.selectedTabChanged());
    }

    private void selectChosenTab() {
        Tab toBeSelected = this.getTabToSelect((SelectedVaultOptionsTab)((Object)this.selectedTabProperty.get()));
        this.tabPane.getSelectionModel().select((Object)toBeSelected);
    }

    private Tab getTabToSelect(SelectedVaultOptionsTab selectedTab) {
        return switch (selectedTab) {
            default -> throw new IncompatibleClassChangeError();
            case SelectedVaultOptionsTab.ANY, SelectedVaultOptionsTab.GENERAL -> this.generalTab;
            case SelectedVaultOptionsTab.MOUNT -> this.mountTab;
            case SelectedVaultOptionsTab.KEY -> this.keyTab;
        };
    }

    private void selectedTabChanged() {
        Tab selectedTab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        try {
            SelectedVaultOptionsTab selectedVaultOptionsTab = SelectedVaultOptionsTab.valueOf(selectedTab.getId());
            this.selectedTabProperty.set((Object)selectedVaultOptionsTab);
        }
        catch (IllegalArgumentException e) {
            LOG.error("Unknown vault options tab id: {}", (Object)selectedTab.getId());
        }
    }

    private void windowWillAppear(WindowEvent windowEvent) {
        this.selectChosenTab();
    }
}

